	using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;

namespace NinjaTrader.Indicator
{	
	public class i14m03: Indicator
    {
		int lastBar, period = 100, step = 10;
		double lastBid, lastAsk;
		List<double> supply = new List<double>();
		Queue<MarketDataEventArgs> eventBuffer = new Queue<MarketDataEventArgs>();
		
		protected override void Initialize()
		{
			Add(new Plot(Color.Green, PlotStyle.Line, "Предложения Bid"));
			Add(new Plot(Color.Red, PlotStyle.Line, "Предложения Ask"));
			Add(new Plot(Color.Blue, PlotStyle.Line, "Уровень"));
			Add(new Plot(Color.Cyan, PlotStyle.Line, "Остаток Bid"));
			Add(new Plot(Color.Magenta, PlotStyle.Line, "Остаток Ask"));
			
			Add(PeriodType.Tick, 1);

			CalculateOnBarClose = false;
		}

        protected override void OnBarUpdate()
		{
			if (Historical)
				return;
			
 			if (BarsInProgress == 1) {
				MarketDataEventArgs e;
				
				while (eventBuffer.Count > 0) {
					e = eventBuffer.Dequeue();
					if (e.MarketDataType == MarketDataType.Bid) {
						lastBid = e.Volume;
						if (!RemainingBid.ContainsValue(1) && !RemainingAsk.ContainsValue(1))
							RemainingBid.Set(1, lastBid);
						continue;
					}
					else if (e.MarketDataType == MarketDataType.Ask) {
						lastAsk = e.Volume;
						if (!RemainingBid.ContainsValue(1) && !RemainingAsk.ContainsValue(1))
							RemainingAsk.Set(1, lastAsk);
						continue;
					}
					
					if (e.Volume == Volume[0] && e.Price == Close[0])
						break;
				}
				
				Values[0].Set(lastBid);
				Values[1].Set(lastAsk);
				supply.Add(Math.Max(lastBid, lastAsk));
				
				if (supply.Count < period) return;
					
				double mean = 0;
				for (int i = step; i < period; i += step) mean += supply[i];
				mean /= (period / step);

				if (mean == 0) return;
				
				double sum = 0;
				for (int i = step; i < period; i += step) sum += Math.Pow(supply[i] - mean, 2);
				double level = mean + Math.Sqrt(sum /= period);

				supply.RemoveAt(0);
				
				Values[2].Set(level);
			}
			else if (lastBar < CurrentBar)
				lastBar = CurrentBar;
			
		}
		
		protected override void OnMarketData(MarketDataEventArgs e)
		{
			if (e.MarketDataType == MarketDataType.Bid
					|| e.MarketDataType == MarketDataType.Ask
					|| e.MarketDataType == MarketDataType.Last)
				eventBuffer.Enqueue(e);
		}
		
		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries Bid
        {
			get { return Values[0]; }
		}

		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries Ask
        {
			get { return Values[1]; }
		}

		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries Supply
        {
			get { return Values[2]; }
		}

		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries RemainingBid
        {
			get { return Values[3]; }
		}

		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries RemainingAsk
        {
			get { return Values[4]; }
		}

		[GridCategory("Параметры")]
		[Gui.Design.DisplayNameAttribute("Период")]
		public int Period
		{
			get { return period; }
			set { period = Math.Max(1, value); }
		}

        [GridCategory("Параметры")]
		[Gui.Design.DisplayNameAttribute("Шаг")]
		public int Step
		{
			get { return step; }
			set { step = Math.Max(1, value); }
		}
		
	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private i14m03[] cachei14m03 = null;

        private static i14m03 checki14m03 = new i14m03();

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public i14m03 i14m03(int period, int step)
        {
            return i14m03(Input, period, step);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public i14m03 i14m03(Data.IDataSeries input, int period, int step)
        {
            if (cachei14m03 != null)
                for (int idx = 0; idx < cachei14m03.Length; idx++)
                    if (cachei14m03[idx].Period == period && cachei14m03[idx].Step == step && cachei14m03[idx].EqualsInput(input))
                        return cachei14m03[idx];

            lock (checki14m03)
            {
                checki14m03.Period = period;
                period = checki14m03.Period;
                checki14m03.Step = step;
                step = checki14m03.Step;

                if (cachei14m03 != null)
                    for (int idx = 0; idx < cachei14m03.Length; idx++)
                        if (cachei14m03[idx].Period == period && cachei14m03[idx].Step == step && cachei14m03[idx].EqualsInput(input))
                            return cachei14m03[idx];

                i14m03 indicator = new i14m03();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Period = period;
                indicator.Step = step;
                Indicators.Add(indicator);
                indicator.SetUp();

                i14m03[] tmp = new i14m03[cachei14m03 == null ? 1 : cachei14m03.Length + 1];
                if (cachei14m03 != null)
                    cachei14m03.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachei14m03 = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.i14m03 i14m03(int period, int step)
        {
            return _indicator.i14m03(Input, period, step);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.i14m03 i14m03(Data.IDataSeries input, int period, int step)
        {
            return _indicator.i14m03(input, period, step);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.i14m03 i14m03(int period, int step)
        {
            return _indicator.i14m03(Input, period, step);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.i14m03 i14m03(Data.IDataSeries input, int period, int step)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.i14m03(input, period, step);
        }
    }
}
#endregion
