using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;

namespace NinjaTrader.Indicator
{
    public class i15m06: Indicator
    {
		const int MAX_DRAW_COUNT = 4000;

		int drawCount = 0, thresholdPeriod = 200, thresholdStep = 4,
			bidAskMeanPeriod = 1, maxPeriod, drawBarsAgo = 0, lineLength = 10;
		double thresholdLow = 20, thresholdHighMultiplier = 2.3;
		string alertFilenameBid = "", alertFilenameAsk = "";

		i14m03 bidAskMean;
		LinReg bidMean, askMean;
		RegressionChannel thresholdBid, thresholdAsk;
		
		protected override void Initialize()
		{
			Add(PeriodType.Tick, 1);
			
			Overlay = true;
		}

		protected override void OnStartUp()
		{
			bidAskMean = i14m03(Inputs[1], thresholdPeriod, thresholdStep);
			bidMean = LinReg(bidAskMean.Bid, bidAskMeanPeriod);
			askMean = LinReg(bidAskMean.Ask, bidAskMeanPeriod);

			if (CalculateOnBarClose)
				drawBarsAgo = -1;
			
			maxPeriod = Math.Max(thresholdPeriod, bidAskMeanPeriod);
		}

		protected override void OnBarUpdate()
		{
			if (Historical
					|| !bidAskMean.Bid.ContainsValue(maxPeriod)
					|| !bidAskMean.Ask.ContainsValue(maxPeriod)
					|| BarsInProgress != 1)
				return;
			
			if (bidMean[0] <= thresholdLow
					&& askMean[0] >= bidAskMean.Supply[0] * thresholdHighMultiplier) {
				DrawLine(String.Format("Mark {0}", ++drawCount), false,
					drawBarsAgo, Closes[1][0], -lineLength, Closes[1][0],
					Color.Red, DashStyle.Solid, 2);
				if (alertFilenameBid != "")
					Alert(Name + " alert", NinjaTrader.Cbi.Priority.Medium,
						"Bid absent", alertFilenameBid, 10, Color.White, Color.Black);
			}
			if (askMean[0] <= thresholdLow
					&& bidMean[0] >= bidAskMean.Supply[0] * thresholdHighMultiplier) {
				DrawLine(String.Format("Mark {0}", ++drawCount), false,
					drawBarsAgo, Closes[1][0], -lineLength, Closes[1][0],
					Color.Green, DashStyle.Solid, 2);
				if (alertFilenameAsk != "")
					Alert(Name + " alert", NinjaTrader.Cbi.Priority.Medium,
						"Ask absent", alertFilenameAsk, 10, Color.White, Color.Black);
			}
			
			if (drawCount > MAX_DRAW_COUNT)
				drawCount = 0;
		}
		
        [GridCategory("Параметры")]
		[Gui.Design.DisplayNameAttribute("Нижняя граница")]
		[Description("Абсолютное значение нижней границы")]
		public double ThresholdLow
		{
			get { return thresholdLow; }
			set { thresholdLow = value; }
		}

        [GridCategory("Параметры")]
		[Gui.Design.DisplayNameAttribute("Верхняя граница, множитель")]
		[Description("Множитель для расчёта верхней границы. " +
			"Например, 1.2 - 20%")]
		public double ThresholdHighMultiplier
		{
			get { return thresholdHighMultiplier; }
			set { thresholdHighMultiplier = Math.Max(0.001, value); }
		}

		[GridCategory("Параметры")]
		[Gui.Design.DisplayNameAttribute("Верхняя граница, период")]
		[Description("Период для расчёта уровня в i14")]
		public int ThresholdPeriod
		{
			get { return thresholdPeriod; }
			set { thresholdPeriod = Math.Max(1, value); }
		}

		[GridCategory("Параметры")]
		[Gui.Design.DisplayNameAttribute("Верхняя граница, шаг")]
		[Description("Шаг для расчёта уровня в i14")]
		public int ThresholdStep
		{
			get { return thresholdStep; }
			set { thresholdStep = Math.Max(1, value); }
		}

        [GridCategory("Параметры")]
		[Gui.Design.DisplayNameAttribute("Период")]
		[Description("Период для сглаживания i14")]
		public int BidAskMeanPeriod
		{
			get { return bidAskMeanPeriod; }
			set { bidAskMeanPeriod = Math.Max(1, value); }
		}

		[GridCategory("Параметры")]
		[Gui.Design.DisplayNameAttribute("Длина линии")]
		public int LineLength
		{
			get { return lineLength; }
			set { lineLength = Math.Max(1, value); }
		}

        [GridCategory("Параметры")]
		[Gui.Design.DisplayNameAttribute("Звук оповещения, Bid")]
		[Description("Имя wav-файла для оповещения, bid'ы \"ушли\"")]
		public string AlertFilenameBid
		{
			get { return alertFilenameBid; }
			set { alertFilenameBid = value; }
		}

        [GridCategory("Параметры")]
		[Gui.Design.DisplayNameAttribute("Звук оповещения, Ask")]
		[Description("Имя wav-файла для оповещения, фыл'и \"ушли\"")]
		public string AlertFilenameAsk
		{
			get { return alertFilenameAsk; }
			set { alertFilenameAsk = value; }
		}
	}
}




#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private i15m06[] cachei15m06 = null;

        private static i15m06 checki15m06 = new i15m06();

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public i15m06 i15m06(string alertFilenameAsk, string alertFilenameBid, int bidAskMeanPeriod, int lineLength, double thresholdHighMultiplier, double thresholdLow, int thresholdPeriod, int thresholdStep)
        {
            return i15m06(Input, alertFilenameAsk, alertFilenameBid, bidAskMeanPeriod, lineLength, thresholdHighMultiplier, thresholdLow, thresholdPeriod, thresholdStep);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public i15m06 i15m06(Data.IDataSeries input, string alertFilenameAsk, string alertFilenameBid, int bidAskMeanPeriod, int lineLength, double thresholdHighMultiplier, double thresholdLow, int thresholdPeriod, int thresholdStep)
        {
            if (cachei15m06 != null)
                for (int idx = 0; idx < cachei15m06.Length; idx++)
                    if (cachei15m06[idx].AlertFilenameAsk == alertFilenameAsk && cachei15m06[idx].AlertFilenameBid == alertFilenameBid && cachei15m06[idx].BidAskMeanPeriod == bidAskMeanPeriod && cachei15m06[idx].LineLength == lineLength && Math.Abs(cachei15m06[idx].ThresholdHighMultiplier - thresholdHighMultiplier) <= double.Epsilon && Math.Abs(cachei15m06[idx].ThresholdLow - thresholdLow) <= double.Epsilon && cachei15m06[idx].ThresholdPeriod == thresholdPeriod && cachei15m06[idx].ThresholdStep == thresholdStep && cachei15m06[idx].EqualsInput(input))
                        return cachei15m06[idx];

            lock (checki15m06)
            {
                checki15m06.AlertFilenameAsk = alertFilenameAsk;
                alertFilenameAsk = checki15m06.AlertFilenameAsk;
                checki15m06.AlertFilenameBid = alertFilenameBid;
                alertFilenameBid = checki15m06.AlertFilenameBid;
                checki15m06.BidAskMeanPeriod = bidAskMeanPeriod;
                bidAskMeanPeriod = checki15m06.BidAskMeanPeriod;
                checki15m06.LineLength = lineLength;
                lineLength = checki15m06.LineLength;
                checki15m06.ThresholdHighMultiplier = thresholdHighMultiplier;
                thresholdHighMultiplier = checki15m06.ThresholdHighMultiplier;
                checki15m06.ThresholdLow = thresholdLow;
                thresholdLow = checki15m06.ThresholdLow;
                checki15m06.ThresholdPeriod = thresholdPeriod;
                thresholdPeriod = checki15m06.ThresholdPeriod;
                checki15m06.ThresholdStep = thresholdStep;
                thresholdStep = checki15m06.ThresholdStep;

                if (cachei15m06 != null)
                    for (int idx = 0; idx < cachei15m06.Length; idx++)
                        if (cachei15m06[idx].AlertFilenameAsk == alertFilenameAsk && cachei15m06[idx].AlertFilenameBid == alertFilenameBid && cachei15m06[idx].BidAskMeanPeriod == bidAskMeanPeriod && cachei15m06[idx].LineLength == lineLength && Math.Abs(cachei15m06[idx].ThresholdHighMultiplier - thresholdHighMultiplier) <= double.Epsilon && Math.Abs(cachei15m06[idx].ThresholdLow - thresholdLow) <= double.Epsilon && cachei15m06[idx].ThresholdPeriod == thresholdPeriod && cachei15m06[idx].ThresholdStep == thresholdStep && cachei15m06[idx].EqualsInput(input))
                            return cachei15m06[idx];

                i15m06 indicator = new i15m06();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.AlertFilenameAsk = alertFilenameAsk;
                indicator.AlertFilenameBid = alertFilenameBid;
                indicator.BidAskMeanPeriod = bidAskMeanPeriod;
                indicator.LineLength = lineLength;
                indicator.ThresholdHighMultiplier = thresholdHighMultiplier;
                indicator.ThresholdLow = thresholdLow;
                indicator.ThresholdPeriod = thresholdPeriod;
                indicator.ThresholdStep = thresholdStep;
                Indicators.Add(indicator);
                indicator.SetUp();

                i15m06[] tmp = new i15m06[cachei15m06 == null ? 1 : cachei15m06.Length + 1];
                if (cachei15m06 != null)
                    cachei15m06.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachei15m06 = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.i15m06 i15m06(string alertFilenameAsk, string alertFilenameBid, int bidAskMeanPeriod, int lineLength, double thresholdHighMultiplier, double thresholdLow, int thresholdPeriod, int thresholdStep)
        {
            return _indicator.i15m06(Input, alertFilenameAsk, alertFilenameBid, bidAskMeanPeriod, lineLength, thresholdHighMultiplier, thresholdLow, thresholdPeriod, thresholdStep);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.i15m06 i15m06(Data.IDataSeries input, string alertFilenameAsk, string alertFilenameBid, int bidAskMeanPeriod, int lineLength, double thresholdHighMultiplier, double thresholdLow, int thresholdPeriod, int thresholdStep)
        {
            return _indicator.i15m06(input, alertFilenameAsk, alertFilenameBid, bidAskMeanPeriod, lineLength, thresholdHighMultiplier, thresholdLow, thresholdPeriod, thresholdStep);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.i15m06 i15m06(string alertFilenameAsk, string alertFilenameBid, int bidAskMeanPeriod, int lineLength, double thresholdHighMultiplier, double thresholdLow, int thresholdPeriod, int thresholdStep)
        {
            return _indicator.i15m06(Input, alertFilenameAsk, alertFilenameBid, bidAskMeanPeriod, lineLength, thresholdHighMultiplier, thresholdLow, thresholdPeriod, thresholdStep);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.i15m06 i15m06(Data.IDataSeries input, string alertFilenameAsk, string alertFilenameBid, int bidAskMeanPeriod, int lineLength, double thresholdHighMultiplier, double thresholdLow, int thresholdPeriod, int thresholdStep)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.i15m06(input, alertFilenameAsk, alertFilenameBid, bidAskMeanPeriod, lineLength, thresholdHighMultiplier, thresholdLow, thresholdPeriod, thresholdStep);
        }
    }
}
#endregion
