using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;

namespace NinjaTrader.Indicator
{		
    public class i16: Indicator
    {
		int lastBar;
		double lastAsk = 0, lastBid = Double.MaxValue,
			bidVolume, askVolume, unknownVolume, volume;
		Queue<MarketDataEventArgs> eventBuffer = new Queue<MarketDataEventArgs>();
		
		protected override void Initialize()
		{
			Add(new Plot(Color.Green, PlotStyle.Hash, "BidVolume"));
			Add(new Plot(Color.Red, PlotStyle.Hash, "AskVolume"));
			Add(new Plot(Color.Magenta, PlotStyle.Hash, "UnknownVolume"));
			Add(new Plot(Color.Lavender, PlotStyle.Bar, "Volume"));
			
			Add(PeriodType.Tick, 1);

			CalculateOnBarClose = false;
		}

        protected override void OnBarUpdate()
		{
			if (Historical)
				return;
			
			if (BarsInProgress == 1) {
				MarketDataEventArgs e;
				
				while (eventBuffer.Count > 0) {
					e = eventBuffer.Dequeue();
					if (e.MarketDataType == MarketDataType.Ask) {
						lastAsk = e.Price;
						continue;
					}
					else if (e.MarketDataType == MarketDataType.Bid) {
						lastBid = e.Price;
						continue;
					}
					
					if (e.Volume == Volume[0] && e.Price == Close[0]) {
						if (Close[0] >= lastAsk)
							bidVolume += e.Volume;
						else if (Close[0] <= lastBid)
							askVolume += e.Volume;
						else
							unknownVolume += e.Volume;

						break;
					}
				}
				
				BidVolume.Set(bidVolume);
				AskVolume.Set(askVolume);
				UnknownVolume.Set(unknownVolume);
				VolumesSum.Set(bidVolume + askVolume + unknownVolume);
			}
			else if (lastBar < CurrentBar) {
				lastBar = CurrentBar;
				bidVolume = askVolume = unknownVolume = 0;
			}
			
		}
		
		protected override void OnMarketData(MarketDataEventArgs e)
		{
			if (e.MarketDataType == MarketDataType.Bid
					|| e.MarketDataType == MarketDataType.Ask
					|| e.MarketDataType == MarketDataType.Last)
				eventBuffer.Enqueue(e);
		}
		
		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries BidVolume
        {
			get { return Values[0]; }
		}

		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries AskVolume
        {
			get { return Values[1]; }
		}

		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries UnknownVolume
        {
			get { return Values[2]; }
		}

		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries VolumesSum
        {
			get { return Values[3]; }
		}
	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private i16[] cachei16 = null;

        private static i16 checki16 = new i16();

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public i16 i16()
        {
            return i16(Input);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public i16 i16(Data.IDataSeries input)
        {
            if (cachei16 != null)
                for (int idx = 0; idx < cachei16.Length; idx++)
                    if (cachei16[idx].EqualsInput(input))
                        return cachei16[idx];

            lock (checki16)
            {
                if (cachei16 != null)
                    for (int idx = 0; idx < cachei16.Length; idx++)
                        if (cachei16[idx].EqualsInput(input))
                            return cachei16[idx];

                i16 indicator = new i16();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                Indicators.Add(indicator);
                indicator.SetUp();

                i16[] tmp = new i16[cachei16 == null ? 1 : cachei16.Length + 1];
                if (cachei16 != null)
                    cachei16.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachei16 = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.i16 i16()
        {
            return _indicator.i16(Input);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.i16 i16(Data.IDataSeries input)
        {
            return _indicator.i16(input);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.i16 i16()
        {
            return _indicator.i16(Input);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.i16 i16(Data.IDataSeries input)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.i16(input);
        }
    }
}
#endregion
