using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Linq;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;

namespace NinjaTrader.Indicator
{
    public class i18: Indicator
    {
		const int MAX_DRAW_COUNT = 200;

		int drawCount = 0, length = 200, thresholdPeriod = 200,
			middleVolume = 20, bigVolume = 40, drawBarsAgo = 0;
		double thresholdMultiplier = 2.2;
		Color colorAboveAsk = Color.Red, colorUnderBid = Color.Green,
			colorUnknown = Color.Blue;
		
		i12m03 maxTrade;
		LinReg threshold;
		
		protected override void Initialize()
		{
			Overlay = true;
			
			Add(PeriodType.Custom2, 1);
		}

		protected override void OnStartUp()
		{
			maxTrade = i12m03(Inputs[1]);
			threshold = LinReg(Volumes[1], thresholdPeriod);
			
			if (CalculateOnBarClose)
				drawBarsAgo = -1;
		}

		int getWidth(double v)
		{
			if (v < middleVolume)
				return 1;
			else if (v < bigVolume)
				return 2;
			else
				return 4;
		}
		
		double getIfContain(DataSeries data, int barsAgo)
		{
			return data.ContainsValue(barsAgo) ? data[barsAgo] : 0;
		}

		double getIfContain(DataSeries data)
		{
			return getIfContain(data, 0);
		}

		void draw(double volume, Color color) {
			//DrawLine(String.Format("Line {0}", drawCount++), false, drawBarsAgo, maxTrade.Price[0], -length, maxTrade.Price[0],
			//	color, DashStyle.Solid, getWidth(volume));
			DrawDiamond(String.Format("Line {0}", drawCount++), false, 0, maxTrade.Price[0], color);
			//DrawLine(string tag, int startBarsAgo, double startY, int endBarsAgo, double endY, Color color) 
			//DrawLine(string tag, bool autoScale, int startBarsAgo, double startY, int endBarsAgo, double endY, Color color, DashStyle dashStyle, int width)
			


		}
		
        protected override void OnBarUpdate()
		{
			if (Historical)
				return;
			
			if (BarsInProgress == 1) {
				Dictionary<double, Color> maxTradeWithColor = new Dictionary<double, Color>();
				maxTradeWithColor[getIfContain(maxTrade.AskVolume)] = colorAboveAsk;
				maxTradeWithColor[getIfContain(maxTrade.AboveAskVolume)] = colorAboveAsk;
				maxTradeWithColor[getIfContain(maxTrade.BidVolume)] = colorUnderBid;
				maxTradeWithColor[getIfContain(maxTrade.UnderBidVolume)] = colorUnderBid;
				maxTradeWithColor[getIfContain(maxTrade.UnknownVolume)] = colorUnknown;
				maxTradeWithColor[threshold[0] * thresholdMultiplier] = Color.Empty;
				
				double v = maxTradeWithColor.Keys.Max();
				Color c = maxTradeWithColor[v];
				if (c != Color.Empty)
					draw(v, c);
				
				if (drawCount > MAX_DRAW_COUNT)
					drawCount = 0;
			}
			
		}
		
        [XmlIgnore()]
        [GridCategory("Параметры")]
		[Gui.Design.DisplayNameAttribute("Цвет линии, Ask")]
		[Description("Выброс на цене равной или выше Ask")]
		public Color ColorAboveAsk
		{
			get { return colorAboveAsk; }
			set { colorAboveAsk = (Color) value; }
		}

		[Browsable(false)]
		public string ColorAboveAskSerialize
		{
			get { return Gui.Design.SerializableColor.ToString(colorAboveAsk); }
			set { colorAboveAsk = Gui.Design.SerializableColor.FromString(value); }
		}

        [XmlIgnore()]
        [GridCategory("Параметры")]
		[Gui.Design.DisplayNameAttribute("Цвет линии, Bid")]
		[Description("Выброс на цене равной или ниже Bid")]
		public Color ColorUnderBid
		{
			get { return colorUnderBid; }
			set { colorUnderBid = (Color) value; }
		}

		[Browsable(false)]
		public string ColorUnderBidSerialize
		{
			get { return Gui.Design.SerializableColor.ToString(colorUnderBid); }
			set { colorUnderBid = Gui.Design.SerializableColor.FromString(value); }
		}

        [XmlIgnore()]
        [GridCategory("Параметры")]
		[Gui.Design.DisplayNameAttribute("Цвет линии, между Bid и Ask")]
		[Description("Выброс на цене между Bid и Ask")]
		public Color ColorUnknown
		{
			get { return colorUnknown; }
			set { colorUnknown = (Color) value; }
		}

		[Browsable(false)]
		public string ColorUnknownSerialize
		{
			get { return Gui.Design.SerializableColor.ToString(colorUnknown); }
			set { colorUnknown = Gui.Design.SerializableColor.FromString(value); }
		}

        [GridCategory("Параметры")]
		[Gui.Design.DisplayNameAttribute("Средний объём")]
		public int MiddleVolume
		{
			get { return middleVolume; }
			set { middleVolume = Math.Max(1, value); }
		}

        [GridCategory("Параметры")]
		[Gui.Design.DisplayNameAttribute("Большой объём")]
		public int BigVolume
		{
			get { return bigVolume; }
			set { bigVolume = Math.Max(1, value); }
		}

        [GridCategory("Параметры")]
		[Gui.Design.DisplayNameAttribute("Длина линии")]
		public int Length
		{
			get { return length; }
			set { length = Math.Max(1, value); }
		}

        [GridCategory("Параметры")]
		[Gui.Design.DisplayNameAttribute("Превышение")]
		[Description("Множитель для превышения. Например, 1.2 - 20%")]
		public double ThresholdMultiplier
		{
			get { return thresholdMultiplier; }
			set { thresholdMultiplier = Math.Max(0, value); }
		}

        [GridCategory("Параметры")]
		[Gui.Design.DisplayNameAttribute("Период средней")]
		[Description("Период для расчёта средней")]
		public int ThresholdPeriod
		{
			get { return thresholdPeriod; }
			set { thresholdPeriod = Math.Max(1, value); }
		}

	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private i18[] cachei18 = null;

        private static i18 checki18 = new i18();

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public i18 i18()
        {
            return i18(Input);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public i18 i18(Data.IDataSeries input)
        {
            if (cachei18 != null)
                for (int idx = 0; idx < cachei18.Length; idx++)
                    if (cachei18[idx].EqualsInput(input))
                        return cachei18[idx];

            lock (checki18)
            {
                if (cachei18 != null)
                    for (int idx = 0; idx < cachei18.Length; idx++)
                        if (cachei18[idx].EqualsInput(input))
                            return cachei18[idx];

                i18 indicator = new i18();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                Indicators.Add(indicator);
                indicator.SetUp();

                i18[] tmp = new i18[cachei18 == null ? 1 : cachei18.Length + 1];
                if (cachei18 != null)
                    cachei18.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachei18 = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.i18 i18()
        {
            return _indicator.i18(Input);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.i18 i18(Data.IDataSeries input)
        {
            return _indicator.i18(input);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.i18 i18()
        {
            return _indicator.i18(Input);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.i18 i18(Data.IDataSeries input)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.i18(input);
        }
    }
}
#endregion
