using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Linq;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;

namespace NinjaTrader.Indicator
{
    public class i20m02: Indicator
    {
		const int MAX_DRAW_COUNT = 2000;
		
		int drawCount = 0, drawBarsAgo = 0, firstBar, lastBar = 0,
			levelHeight = 5, levelAmount = 2;
		
		TimeSpan startTime = new TimeSpan(23, 30, 00),
			endTime = new TimeSpan(00, 30, 00);
		
		double high, low;
		List<double> deltas;
		
		protected override void Initialize()
		{
			Overlay = true;
		}

		protected override void OnStartUp()
		{
			if (CalculateOnBarClose)
				drawBarsAgo = -1;
		}

		protected override void OnBarUpdate()
		{
			if (Time[0].TimeOfDay >= startTime || Time[0].TimeOfDay < endTime) {
				if (CurrentBar - lastBar > 1) {
					firstBar = CurrentBar;
					
					high = High[0];
					low = Low[0];

					if (drawCount == MAX_DRAW_COUNT)
						drawCount = 0;
					else
						drawCount++;
					
					DrawVerticalLine(String.Format("left vline {0}", drawCount), 0, Color.BlueViolet);
				}
				
				lastBar = CurrentBar;
				
				if (High[0] > high)
					high = High[0];
				if (Low[0] < low)
					low = Low[0];
				
				Double delta = high - low;
				deltas = new List<double>();
				for (int i = 2; i < LevelAmount + 2; i++)
					deltas.Add(Math.Floor(delta * Math.Pow(1.618, i) / TickSize) * TickSize);

				DrawVerticalLine(String.Format("right vline {0}", drawCount), drawBarsAgo, Color.BlueViolet);
			}
			else if (lastBar > 0) {
				DrawRectangle(String.Format("rect middle {0}", drawCount), false,
					CurrentBar - lastBar - 1, low, drawBarsAgo, high, Color.Transparent, Color.Red, 2);

				foreach (double d in deltas) {
					DrawRectangle(String.Format("rect up d{1} {0}", drawCount, d), false,
						CurrentBar - lastBar - 1, low + d, drawBarsAgo, low + d - levelHeight * TickSize,
						Color.Transparent, Color.Blue, 2);
					DrawRectangle(String.Format("rect down d{1} {0}", drawCount, d), false,
						CurrentBar - lastBar - 1, high - d, drawBarsAgo, high - d + levelHeight * TickSize,
						Color.Transparent, Color.Blue, 2);
				}
			}
		}
		
		[GridCategory("Параметры")]
		[Gui.Design.DisplayNameAttribute("Начало")]
		[Description("Начало \"утренней\" сессии")]
		public TimeSpan StartTime
		{
			get { return startTime; }
			set { startTime = (0 <= value.Hours && value.Hours <= 23) ? value : new TimeSpan(); }
		}
	
		[GridCategory("Параметры")]
		[Gui.Design.DisplayNameAttribute("Окончание")]
		[Description("Окончание \"утренней\" сессии")]
		public TimeSpan EndTime
		{
			get { return endTime; }
			set { endTime = (0 <= value.Hours && value.Hours <= 23) ? value : new TimeSpan(); }
		}

		[GridCategory("Параметры")]
		[Gui.Design.DisplayNameAttribute("Высота уровней")]
		[Description("Высота выделения уровней в пунктах")]
		public int LevelHeight
		{
			get { return levelHeight; }
			set { levelHeight = Math.Max(1, value); }
		}

		[GridCategory("Параметры")]
		[Gui.Design.DisplayNameAttribute("Количество уровней")]
		public int LevelAmount
		{
			get { return levelAmount; }
			set { levelAmount = Math.Max(2, value); }
		}

	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private i20m02[] cachei20m02 = null;

        private static i20m02 checki20m02 = new i20m02();

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public i20m02 i20m02()
        {
            return i20m02(Input);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public i20m02 i20m02(Data.IDataSeries input)
        {
            if (cachei20m02 != null)
                for (int idx = 0; idx < cachei20m02.Length; idx++)
                    if (cachei20m02[idx].EqualsInput(input))
                        return cachei20m02[idx];

            lock (checki20m02)
            {
                if (cachei20m02 != null)
                    for (int idx = 0; idx < cachei20m02.Length; idx++)
                        if (cachei20m02[idx].EqualsInput(input))
                            return cachei20m02[idx];

                i20m02 indicator = new i20m02();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                Indicators.Add(indicator);
                indicator.SetUp();

                i20m02[] tmp = new i20m02[cachei20m02 == null ? 1 : cachei20m02.Length + 1];
                if (cachei20m02 != null)
                    cachei20m02.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachei20m02 = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.i20m02 i20m02()
        {
            return _indicator.i20m02(Input);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.i20m02 i20m02(Data.IDataSeries input)
        {
            return _indicator.i20m02(input);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.i20m02 i20m02()
        {
            return _indicator.i20m02(Input);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.i20m02 i20m02(Data.IDataSeries input)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.i20m02(input);
        }
    }
}
#endregion
