using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Linq;
using System.Xml.Serialization;
using System.Windows.Forms;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;

namespace NinjaTrader.Indicator
{
	public class i20m03: Indicator
    {
		int drawCount = 0, drawBarsAgo = 0, startBar, endBar = 0,
			levelHeight = 5, levelAmount = 2;
		
		readonly TimeSpan ONE_DAY = new TimeSpan(1, 0, 0, 0);
		TimeSpan startTime = new TimeSpan(23, 30, 00),
			duration = new TimeSpan(00, 30, 00);
		
		DateTime startBoundTime, endBoundTime = DateTime.MinValue;
		
		double high, low;
		List<double> deltas = new List<double>();
		
		void MouseUpHandler(object sender, MouseEventArgs e) {
			TimeSpan newStartTime, newDuration;
			
			IVerticalLine bound1 = (IVerticalLine) DrawObjects["bound 1"];
			IVerticalLine bound2 = (IVerticalLine) DrawObjects["bound 2"];

			if (bound1 != null && bound2 != null) {
				if (bound1.Time < bound2.Time) {
					newStartTime = bound1.Time.TimeOfDay;
					newDuration = bound2.Time - bound1.Time;
				}
				else {
					newStartTime = bound2.Time.TimeOfDay;
					newDuration = bound1.Time - bound2.Time;
				}
			}
			else
				return;
			
			if (newStartTime == startTime && newDuration == duration)
				return;
			
			startTime = newStartTime;
			duration = newDuration;
			
			makeBounds(false);
			OnBarUpdate();
		}
		
		void makeBounds(bool redraw) {
			startBoundTime = Time[0].Date + startTime;
			if (Time[0].TimeOfDay < startTime)
				startBoundTime -= ONE_DAY;
			endBoundTime = startBoundTime + duration;
			
			if (redraw) {
				DrawVerticalLine("bound 1", startBoundTime,
					Color.BlueViolet, DashStyle.Solid, 1).Locked = false;
				DrawVerticalLine("bound 2", endBoundTime,
					Color.BlueViolet, DashStyle.Solid, 1).Locked = false;
			}

			startBar = CurrentBar - GetBar(startBoundTime);
			endBar = CurrentBar - GetBar(endBoundTime);
			
			high = High[CurrentBar - startBar];
			low = Low[CurrentBar - startBar];

			for (int i = startBar; i <= endBar; i++) {
				if (High[CurrentBar - i] > high)
					high = High[CurrentBar - i];
				if (Low[CurrentBar - i] < low)
					low = Low[CurrentBar - i];
			}
			
			Double delta = high - low;
			deltas.Clear();
			for (int i = 2; i < LevelAmount + 2; i++)
				deltas.Add(Math.Floor(delta * Math.Pow(1.618, i) / TickSize) * TickSize);
		}
		
		protected override void Initialize()
		{
			Overlay = true;
		}

		protected override void OnStartUp()
		{
			ChartControl.ChartPanel.MouseUp += MouseUpHandler;
			
			if (CalculateOnBarClose)
				drawBarsAgo = -1;
		}

		protected override void OnBarUpdate()
		{
			if (Historical)
				return;
			
			if (endBoundTime == DateTime.MinValue
					|| Time[0].TimeOfDay == startBoundTime.TimeOfDay
					|| Time[0].TimeOfDay == endBoundTime.TimeOfDay
					|| (Time[0] <= endBoundTime && DrawObjects.Count > 2)) {
				RemoveDrawObjects();
				makeBounds(true);
			}

			if (Time[0] <= endBoundTime)
				return;
			
			DrawRectangle("rect middle", false, CurrentBar - endBar, low,
				drawBarsAgo, high, Color.Transparent, Color.Red, 2);

			for (int i = 0; i < deltas.Count; i++) {
				double d = deltas[i];
				DrawRectangle(String.Format("rect up {0}", i), false,
					CurrentBar - endBar, low + d, drawBarsAgo, low + d - levelHeight * TickSize,
					Color.Transparent, Color.Blue, 2);
				DrawRectangle(String.Format("rect down {0}", i), false,
					CurrentBar - endBar, high - d, drawBarsAgo, high - d + levelHeight * TickSize,
					Color.Transparent, Color.Blue, 2);
			}
		}
		
		[GridCategory("Параметры")]
		[Gui.Design.DisplayNameAttribute("Начало")]
		[Description("Начало \"утренней\" сессии")]
		public TimeSpan StartTime
		{
			get { return startTime; }
			set { startTime = value; }
		}
	
		[GridCategory("Параметры")]
		[Gui.Design.DisplayNameAttribute("Продолжительность")]
		[Description("Продолжительность \"утренней\" сессии")]
		public TimeSpan Duration
		{
			get { return duration; }
			set { duration = value; }
		}

		[GridCategory("Параметры")]
		[Gui.Design.DisplayNameAttribute("Высота уровней")]
		[Description("Высота выделения уровней в пунктах")]
		public int LevelHeight
		{
			get { return levelHeight; }
			set { levelHeight = Math.Max(1, value); }
		}

		[GridCategory("Параметры")]
		[Gui.Design.DisplayNameAttribute("Количество уровней")]
		public int LevelAmount
		{
			get { return levelAmount; }
			set { levelAmount = Math.Max(2, value); }
		}

	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private i20m03[] cachei20m03 = null;

        private static i20m03 checki20m03 = new i20m03();

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public i20m03 i20m03(TimeSpan duration, int levelAmount, int levelHeight, TimeSpan startTime)
        {
            return i20m03(Input, duration, levelAmount, levelHeight, startTime);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public i20m03 i20m03(Data.IDataSeries input, TimeSpan duration, int levelAmount, int levelHeight, TimeSpan startTime)
        {
            if (cachei20m03 != null)
                for (int idx = 0; idx < cachei20m03.Length; idx++)
                    if (cachei20m03[idx].Duration == duration && cachei20m03[idx].LevelAmount == levelAmount && cachei20m03[idx].LevelHeight == levelHeight && cachei20m03[idx].StartTime == startTime && cachei20m03[idx].EqualsInput(input))
                        return cachei20m03[idx];

            lock (checki20m03)
            {
                checki20m03.Duration = duration;
                duration = checki20m03.Duration;
                checki20m03.LevelAmount = levelAmount;
                levelAmount = checki20m03.LevelAmount;
                checki20m03.LevelHeight = levelHeight;
                levelHeight = checki20m03.LevelHeight;
                checki20m03.StartTime = startTime;
                startTime = checki20m03.StartTime;

                if (cachei20m03 != null)
                    for (int idx = 0; idx < cachei20m03.Length; idx++)
                        if (cachei20m03[idx].Duration == duration && cachei20m03[idx].LevelAmount == levelAmount && cachei20m03[idx].LevelHeight == levelHeight && cachei20m03[idx].StartTime == startTime && cachei20m03[idx].EqualsInput(input))
                            return cachei20m03[idx];

                i20m03 indicator = new i20m03();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Duration = duration;
                indicator.LevelAmount = levelAmount;
                indicator.LevelHeight = levelHeight;
                indicator.StartTime = startTime;
                Indicators.Add(indicator);
                indicator.SetUp();

                i20m03[] tmp = new i20m03[cachei20m03 == null ? 1 : cachei20m03.Length + 1];
                if (cachei20m03 != null)
                    cachei20m03.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachei20m03 = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.i20m03 i20m03(TimeSpan duration, int levelAmount, int levelHeight, TimeSpan startTime)
        {
            return _indicator.i20m03(Input, duration, levelAmount, levelHeight, startTime);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.i20m03 i20m03(Data.IDataSeries input, TimeSpan duration, int levelAmount, int levelHeight, TimeSpan startTime)
        {
            return _indicator.i20m03(input, duration, levelAmount, levelHeight, startTime);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.i20m03 i20m03(TimeSpan duration, int levelAmount, int levelHeight, TimeSpan startTime)
        {
            return _indicator.i20m03(Input, duration, levelAmount, levelHeight, startTime);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.i20m03 i20m03(Data.IDataSeries input, TimeSpan duration, int levelAmount, int levelHeight, TimeSpan startTime)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.i20m03(input, duration, levelAmount, levelHeight, startTime);
        }
    }
}
#endregion
