using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;

namespace NinjaTrader.Indicator
{	
    public class i21: Indicator
    {
		int lastBar, tradesAmount = 50, tradesCounter = 0;
		double lastAsk = 0, lastBid = Double.MaxValue,
			bidVolume, askVolume, unknownVolume, tradesVolume = 0;
		Queue<MarketDataEventArgs> eventBuffer = new Queue<MarketDataEventArgs>();
		
		protected override void Initialize()
		{
			Add(new Plot(Color.Green, PlotStyle.Bar, "BidVolume"));
			Add(new Plot(Color.Red, PlotStyle.Bar, "AskVolume"));
			
			Add(PeriodType.Tick, 1);

			CalculateOnBarClose = false;
		}

        protected override void OnBarUpdate()
		{
			if (Historical)
				return;
			
			if (BarsInProgress == 1) {
				Print("--- Start --- ");
				while (eventBuffer.Count > 0) {
					MarketDataEventArgs e = eventBuffer.Dequeue();
					
					Print(" ----- " + e.MarketDataType.ToString() + " " + e.Time.ToString() + " " + e.Price.ToString() + 
						" " +e.Volume.ToString());
					
					if (e.MarketDataType != MarketDataType.Last) {
						tradesCounter = 0;
						tradesVolume = 0;
						//Print("Null tradesCounter-Volume");
					}
					
					if (e.MarketDataType == MarketDataType.Ask) {
						lastAsk = e.Price;
						//Print("Update lastAsk");
						continue;
					}
					else if (e.MarketDataType == MarketDataType.Bid) {
						lastBid = e.Price;
						//Print("Update lastBid");
						continue;
					}
					
					if (++tradesCounter < tradesAmount) {
						tradesVolume += e.Volume;
						Print("Summ tradesVolume");
						continue;
					}
					else if (tradesVolume > 0 && tradesCounter > tradesAmount){
						tradesVolume = 0;
						Print("Null tradesVolume");
					}
					
					if (e.Volume == Volume[0] && e.Price == Close[0]) {
						if (Close[0] >= lastAsk){
							Print("Summ bidVolume");
							bidVolume += e.Volume + tradesVolume;
						}
						else if (Close[0] <= lastBid){
							 
							askVolume += e.Volume + tradesVolume;
						}

						break;
					}
				}
				
				BidVolume.Set(bidVolume);
				AskVolume.Set(askVolume);
			}
			else if (lastBar < CurrentBar) {
				lastBar = CurrentBar;
				tradesCounter = 0;
				bidVolume = askVolume = tradesVolume = 0;
				Print("--- End --- ");
				Print(" ");
			}
			
		}
		
		protected override void OnMarketData(MarketDataEventArgs e)
		{
			if (e.MarketDataType == MarketDataType.Bid
					|| e.MarketDataType == MarketDataType.Ask
					|| e.MarketDataType == MarketDataType.Last)
				eventBuffer.Enqueue(e);
		}
		
		[GridCategory("Параметры")]
		[Description("Количество идущих подряд сделок")]
		[Gui.Design.DisplayNameAttribute("Количество сделок")]
		public int TradesAmount
		{
			get { return tradesAmount; }
			set { tradesAmount = Math.Max(1, value); }
		}

		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries BidVolume
        {
			get { return Values[0]; }
		}

		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries AskVolume
        {
			get { return Values[1]; }
		}

	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private i21[] cachei21 = null;

        private static i21 checki21 = new i21();

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public i21 i21(int tradesAmount)
        {
            return i21(Input, tradesAmount);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public i21 i21(Data.IDataSeries input, int tradesAmount)
        {
            if (cachei21 != null)
                for (int idx = 0; idx < cachei21.Length; idx++)
                    if (cachei21[idx].TradesAmount == tradesAmount && cachei21[idx].EqualsInput(input))
                        return cachei21[idx];

            lock (checki21)
            {
                checki21.TradesAmount = tradesAmount;
                tradesAmount = checki21.TradesAmount;

                if (cachei21 != null)
                    for (int idx = 0; idx < cachei21.Length; idx++)
                        if (cachei21[idx].TradesAmount == tradesAmount && cachei21[idx].EqualsInput(input))
                            return cachei21[idx];

                i21 indicator = new i21();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.TradesAmount = tradesAmount;
                Indicators.Add(indicator);
                indicator.SetUp();

                i21[] tmp = new i21[cachei21 == null ? 1 : cachei21.Length + 1];
                if (cachei21 != null)
                    cachei21.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachei21 = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.i21 i21(int tradesAmount)
        {
            return _indicator.i21(Input, tradesAmount);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.i21 i21(Data.IDataSeries input, int tradesAmount)
        {
            return _indicator.i21(input, tradesAmount);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.i21 i21(int tradesAmount)
        {
            return _indicator.i21(Input, tradesAmount);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.i21 i21(Data.IDataSeries input, int tradesAmount)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.i21(input, tradesAmount);
        }
    }
}
#endregion
