using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Linq;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;

namespace NinjaTrader.Indicator
{
    public class i22: Indicator
    {
		const int MAX_DRAW_COUNT = 4000;
		float[] dashPattern = {1, 5};
		float radiusStep = 5;
		string alertFilename = "";

		int drawCount = 0, length = 10, drawBarsAgo = 0, tradesAmount = 50;
		//int[] volumeLevels = {0, 200, 250, 300, 350};
        int minlevel = 20, maxlevel = 300;
		Color colorAboveAsk = Color.Red, colorUnderBid = Color.Green;
		
		DrawObject[] drawObjects = new DrawObject[MAX_DRAW_COUNT];

		ILine line;
		
		i21 volumes;
		
		class DrawObject {
			private DateTime time;
			private double price;
			private SolidBrush brush;
			private int level;
			
			public DrawObject(DateTime time, double price, SolidBrush brush, int level) {
				this.time = time;
				this.price = price;
				this.brush = brush;
				this.level = level;
			}
			
			public DateTime Time {
				get { return time; }
			}

			public double Price {
				get { return price; }
			}

			public SolidBrush Brush {
				get { return brush; }
			}
			
			public int Level {
				get { return level; }
			}
		}
		
		protected override void Initialize()
		{
			Overlay = true;

			Add(PeriodType.Custom2, 1);
		}

		protected override void OnStartUp()
		{
			volumes = i21(Inputs[1], tradesAmount);

			if (CalculateOnBarClose)
				drawBarsAgo = -1;
		}

		double getIfContain(DataSeries data, int barsAgo)
		{
			return data.ContainsValue(barsAgo) ? data[barsAgo] : 0;
		}

		double getIfContain(DataSeries data)
		{
			return getIfContain(data, 0);
		}
		
		/*int getVolumeLevel(double volume) {
			for (int i = 1; i < volumeLevels.Length; i++)
				if (volume < volumeLevels[i])
					return i;
			
			return volumeLevels.Length - 1;
		}*/
		
		void inform(double volume, Color color) {
			//int level = getVolumeLevel(volume);
            int level = 0;
            level = Convert.ToInt32(Math.Ceiling(volume));
            if (volume > maxlevel) level = maxlevel;
			line = DrawLine(String.Format("Line {0}", drawCount),
				false, drawBarsAgo, Close[0], -length, Close[0],
				color, DashStyle.Custom, 1);
			line.Pen.DashPattern = dashPattern;
			// DrawText(String.Format("Text {0}", drawCount),
				//volume.ToString(), drawBarsAgo + level,
				//Close[0] + TickSize * 2, Color.Black);
			if (alertFilename != "")
				Alert(Name + " alert", NinjaTrader.Cbi.Priority.Medium,
					volume.ToString(), alertFilename, 10, Color.White, Color.Black);
			
			drawObjects[drawCount++] = new i22.DrawObject(
				Time[0], Close[0], new SolidBrush(Color.FromArgb(70, color)), level);
		}

		public override void Plot(Graphics graphics, Rectangle bounds, double min, double max)
		{
			base.Plot(graphics, bounds, min, max);
			
			SmoothingMode oldSmoothingMode = graphics.SmoothingMode;
			graphics.SmoothingMode = SmoothingMode.AntiAlias;
			for (int i = 0; i < MAX_DRAW_COUNT; i++)
				if (drawObjects[i] != null) {
					float x = ChartControl.GetXByBarIdx(Bars, Bars.GetBar(drawObjects[i].Time));
					float y = ChartControl.GetYByValue(Bars, drawObjects[i].Price);
					/*graphics.FillEllipse(drawObjects[i].Brush,
						x - radiusStep * drawObjects[i].Level, y - radiusStep * drawObjects[i].Level,
						radiusStep * 2 * drawObjects[i].Level, radiusStep * 2 * drawObjects[i].Level);*/
                    graphics.FillEllipse(drawObjects[i].Brush,
                        x - drawObjects[i].Level / radiusStep, y - drawObjects[i].Level / radiusStep,
                        2 * drawObjects[i].Level / radiusStep, 2 * drawObjects[i].Level / radiusStep);
				}
			graphics.SmoothingMode = oldSmoothingMode;
		}

		protected override void OnBarUpdate()
		{
			if (Historical)
				return;
			
			if (BarsInProgress == 1) {
				Dictionary<double, Color> volumesWithColor = new Dictionary<double, Color>();
				volumesWithColor[getIfContain(volumes.AskVolume)] = colorAboveAsk;
				volumesWithColor[getIfContain(volumes.BidVolume)] = colorUnderBid;
				
				double v = volumesWithColor.Keys.Max();
				//if (v > volumeLevels[0]) {
                if (v >= minlevel)
                {
					Color c = volumesWithColor[v];
					inform(v, c);
				}

				if (drawCount > MAX_DRAW_COUNT)
					drawCount = 0;
			}
		}
		
        [XmlIgnore()]
        [GridCategory("Параметры")]
		[Gui.Design.DisplayNameAttribute("Цвет области, Ask")]
		[Description("Выброс на цене равной или выше Ask")]
		public Color ColorAboveAsk
		{
			get { return colorAboveAsk; }
			set { colorAboveAsk = (Color) value; }
		}

		[Browsable(false)]
		public string ColorAboveAskSerialize
		{
			get { return Gui.Design.SerializableColor.ToString(colorAboveAsk); }
			set { colorAboveAsk = Gui.Design.SerializableColor.FromString(value); }
		}

        [XmlIgnore()]
        [GridCategory("Параметры")]
		[Gui.Design.DisplayNameAttribute("Цвет области, Bid")]
		[Description("Выброс на цене равной или ниже Bid")]
		public Color ColorUnderBid
		{
			get { return colorUnderBid; }
			set { colorUnderBid = (Color) value; }
		}

		[Browsable(false)]
		public string ColorUnderBidSerialize
		{
			get { return Gui.Design.SerializableColor.ToString(colorUnderBid); }
			set { colorUnderBid = Gui.Design.SerializableColor.FromString(value); }
		}

        [GridCategory("Параметры")]
        [Gui.Design.DisplayNameAttribute("Минимальный объем лотов")]
        public int MinLevel
        {
            get { return minlevel; }
            set { minlevel = Math.Max(1, value); }
        }

        [GridCategory("Параметры")]
        [Gui.Design.DisplayNameAttribute("Максимальный объем лотов")]
        public int MaxLevel
        {
            get { return maxlevel; }
            set { maxlevel = Math.Max(1, value); }
        }

		/*[GridCategory("Параметры")]
		[Gui.Design.DisplayNameAttribute("1 уровень объёма")]
		public int VolumeLevel1
		{
			get { return volumeLevels[1]; }
			set { volumeLevels[1] = Math.Max(1, value); }
		}

        [GridCategory("Параметры")]
		[Gui.Design.DisplayNameAttribute("2 уровень объёма")]
		public int VolumeLevel2
		{
			get { return volumeLevels[2]; }
			set { volumeLevels[2] = Math.Max(1, value); }
		}

        [GridCategory("Параметры")]
		[Gui.Design.DisplayNameAttribute("3 уровень объёма")]
		public int VolumeLevel3
		{
			get { return volumeLevels[3]; }
			set { volumeLevels[3] = Math.Max(1, value); }
		}

        [GridCategory("Параметры")]
		[Gui.Design.DisplayNameAttribute("4 уровень объёма")]
		public int VolumeLevel4
		{
			get { return volumeLevels[4]; }
			set { volumeLevels[4] = Math.Max(1, value); }
		}*/

		[GridCategory("Параметры")]
		[Gui.Design.DisplayNameAttribute("Длина линии")]
		public int Length
		{
			get { return length; }
			set { length = Math.Max(1, value); }
		}

        [GridCategory("Параметры")]
		[Gui.Design.DisplayNameAttribute("Звук оповещения")]
		[Description("Имя wav-файла для оповещения")]
		public string AlertFilename
		{
			get { return alertFilename; }
			set { alertFilename = value; }
		}

		[GridCategory("Параметры")]
		[Gui.Design.DisplayNameAttribute("Количество сделок")]
		[Description("Количество идущих подряд сделок")]
		public int TradesAmount
		{
			get { return tradesAmount; }
			set { tradesAmount = Math.Max(1, value); }
		}

	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private i22[] cachei22 = null;

        private static i22 checki22 = new i22();

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        //public i22 i22(string alertFilename, Color colorAboveAsk, Color colorUnderBid, int length, int tradesAmount, int volumeLevel1, int volumeLevel2, int volumeLevel3, int volumeLevel4)
        public i22 i22(string alertFilename, Color colorAboveAsk, Color colorUnderBid, int length, int tradesAmount, int minlevel, int maxlevel)
        {
            //return i22(Input, alertFilename, colorAboveAsk, colorUnderBid, length, tradesAmount, volumeLevel1, volumeLevel2, volumeLevel3, volumeLevel4);
            return i22(Input, alertFilename, colorAboveAsk, colorUnderBid, length, tradesAmount, minlevel, maxlevel);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        //public i22 i22(Data.IDataSeries input, string alertFilename, Color colorAboveAsk, Color colorUnderBid, int length, int tradesAmount, int volumeLevel1, int volumeLevel2, int volumeLevel3, int volumeLevel4)
        public i22 i22(Data.IDataSeries input, string alertFilename, Color colorAboveAsk, Color colorUnderBid, int length, int tradesAmount, int minLevel, int maxLevel)
        {
            if (cachei22 != null)
                for (int idx = 0; idx < cachei22.Length; idx++)
                    if (cachei22[idx].AlertFilename == alertFilename && cachei22[idx].ColorAboveAsk == colorAboveAsk && cachei22[idx].ColorUnderBid == colorUnderBid && cachei22[idx].Length == length && cachei22[idx].TradesAmount == tradesAmount /*&& cachei22[idx].VolumeLevel1 == volumeLevel1 && cachei22[idx].VolumeLevel2 == volumeLevel2 && cachei22[idx].VolumeLevel3 == volumeLevel3 && cachei22[idx].VolumeLevel4 == volumeLevel4*/ && cachei22[idx].MinLevel == minLevel && cachei22[idx].MaxLevel == maxLevel && cachei22[idx].EqualsInput(input))
                        return cachei22[idx];

            lock (checki22)
            {
                checki22.AlertFilename = alertFilename;
                alertFilename = checki22.AlertFilename;
                checki22.ColorAboveAsk = colorAboveAsk;
                colorAboveAsk = checki22.ColorAboveAsk;
                checki22.ColorUnderBid = colorUnderBid;
                colorUnderBid = checki22.ColorUnderBid;
                checki22.Length = length;
                length = checki22.Length;
                checki22.TradesAmount = tradesAmount;
                tradesAmount = checki22.TradesAmount;
                /*checki22.VolumeLevel1 = volumeLevel1;
                volumeLevel1 = checki22.VolumeLevel1;
                checki22.VolumeLevel2 = volumeLevel2;
                volumeLevel2 = checki22.VolumeLevel2;
                checki22.VolumeLevel3 = volumeLevel3;
                volumeLevel3 = checki22.VolumeLevel3;
                checki22.VolumeLevel4 = volumeLevel4;
                volumeLevel4 = checki22.VolumeLevel4;*/
                checki22.MinLevel = minLevel;
                minLevel = checki22.MinLevel;
                checki22.MaxLevel = maxLevel;
                maxLevel = checki22.MaxLevel;

                if (cachei22 != null)
                    for (int idx = 0; idx < cachei22.Length; idx++)
                        if (cachei22[idx].AlertFilename == alertFilename && cachei22[idx].ColorAboveAsk == colorAboveAsk && cachei22[idx].ColorUnderBid == colorUnderBid && cachei22[idx].Length == length && cachei22[idx].TradesAmount == tradesAmount /*&& cachei22[idx].VolumeLevel1 == volumeLevel1 && cachei22[idx].VolumeLevel2 == volumeLevel2 && cachei22[idx].VolumeLevel3 == volumeLevel3 && cachei22[idx].VolumeLevel4 == volumeLevel4*/ && cachei22[idx].MinLevel == minLevel && cachei22[idx].MaxLevel == maxLevel && cachei22[idx].EqualsInput(input))
                            return cachei22[idx];

                i22 indicator = new i22();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.AlertFilename = alertFilename;
                indicator.ColorAboveAsk = colorAboveAsk;
                indicator.ColorUnderBid = colorUnderBid;
                indicator.Length = length;
                indicator.TradesAmount = tradesAmount;
                /*indicator.VolumeLevel1 = volumeLevel1;
                indicator.VolumeLevel2 = volumeLevel2;
                indicator.VolumeLevel3 = volumeLevel3;
                indicator.VolumeLevel4 = volumeLevel4;*/
                indicator.MinLevel = minLevel;
                indicator.MaxLevel = maxLevel;
                Indicators.Add(indicator);
                indicator.SetUp();

                i22[] tmp = new i22[cachei22 == null ? 1 : cachei22.Length + 1];
                if (cachei22 != null)
                    cachei22.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachei22 = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        /*public Indicator.i22 i22(string alertFilename, Color colorAboveAsk, Color colorUnderBid, int length, int tradesAmount, int volumeLevel1, int volumeLevel2, int volumeLevel3, int volumeLevel4)
        {
            return _indicator.i22(Input, alertFilename, colorAboveAsk, colorUnderBid, length, tradesAmount, volumeLevel1, volumeLevel2, volumeLevel3, volumeLevel4);
        }*/
        public Indicator.i22 i22(string alertFilename, Color colorAboveAsk, Color colorUnderBid, int length, int tradesAmount, int minLevel, int maxLevel)
        {
            return _indicator.i22(Input, alertFilename, colorAboveAsk, colorUnderBid, length, tradesAmount, minLevel, maxLevel);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        /*public Indicator.i22 i22(Data.IDataSeries input, string alertFilename, Color colorAboveAsk, Color colorUnderBid, int length, int tradesAmount, int volumeLevel1, int volumeLevel2, int volumeLevel3, int volumeLevel4)
        {
            return _indicator.i22(input, alertFilename, colorAboveAsk, colorUnderBid, length, tradesAmount, volumeLevel1, volumeLevel2, volumeLevel3, volumeLevel4);
        }*/
        public Indicator.i22 i22(Data.IDataSeries input, string alertFilename, Color colorAboveAsk, Color colorUnderBid, int length, int tradesAmount, int minLevel, int maxLevel)
        {
            return _indicator.i22(input, alertFilename, colorAboveAsk, colorUnderBid, length, tradesAmount, minLevel, maxLevel);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        //public Indicator.i22 i22(string alertFilename, Color colorAboveAsk, Color colorUnderBid, int length, int tradesAmount, int volumeLevel1, int volumeLevel2, int volumeLevel3, int volumeLevel4)
        public Indicator.i22 i22(string alertFilename, Color colorAboveAsk, Color colorUnderBid, int length, int tradesAmount, int minLevel, int maxLevel)
        {
            //return _indicator.i22(Input, alertFilename, colorAboveAsk, colorUnderBid, length, tradesAmount, volumeLevel1, volumeLevel2, volumeLevel3, volumeLevel4);
            return _indicator.i22(Input, alertFilename, colorAboveAsk, colorUnderBid, length, tradesAmount, minLevel, maxLevel);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        //public Indicator.i22 i22(Data.IDataSeries input, string alertFilename, Color colorAboveAsk, Color colorUnderBid, int length, int tradesAmount, int volumeLevel1, int volumeLevel2, int volumeLevel3, int volumeLevel4)
        public Indicator.i22 i22(Data.IDataSeries input, string alertFilename, Color colorAboveAsk, Color colorUnderBid, int length, int tradesAmount, int minLevel, int MaxLevel)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            //return _indicator.i22(input, alertFilename, colorAboveAsk, colorUnderBid, length, tradesAmount, volumeLevel1, volumeLevel2, volumeLevel3, volumeLevel4);
            return _indicator.i22(input, alertFilename, colorAboveAsk, colorUnderBid, length, tradesAmount, minLevel, MaxLevel);
        }
    }
}
#endregion
