using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;

namespace NinjaTrader.Indicator
{		
	public class i23: Indicator
    {
		bool firstBidEvent = true, firstAskEvent = true;
		List<long> bidRows = new List<long>(), askRows = new List<long>();
		
		protected override void Initialize()
		{
			Add(new Plot(Color.Red, PlotStyle.Line, "Средняя предложений Bid"));
			Add(new Plot(Color.Green, PlotStyle.Line, "Средняя предложений Ask"));
			
			if (BarsPeriod.Id != PeriodType.Tick
					|| BarsPeriod.BasePeriodValue != 1)
				Add(PeriodType.Tick, 1);

			CalculateOnBarClose = false;
            PriceTypeSupported	= false;
		}

        protected override void OnBarUpdate()
		{
			if (Historical)
				return;
			
			if ((BarsPeriod.Id == PeriodType.Tick && BarsPeriod.BasePeriodValue == 1)
					|| BarsInProgress == 1) {
				if (bidRows.Count >= 2)
					Bid.Set((bidRows[0] + bidRows[1]) / 2);
				if (askRows.Count >= 2)
					Ask.Set((askRows[0] + askRows[1]) / 2);
			}
		}
		
		protected override void OnMarketDepth(MarketDepthEventArgs e)
		{
			List<long> rows;

			// Due to race conditions, it is possible the first event
			// is an Update operation instead of an Insert.
			// When this happens, populate your Lists via e.MarketDepth first.
			// Lock the MarketDepth collection to prevent modification
			// to the collection while we are still processing it
			if (e.MarketDataType == MarketDataType.Bid) {
				rows = bidRows;
				if (firstBidEvent) {
					if (e.Operation == Operation.Update)
						lock (e.MarketDepth.Bid)
							for (int i = 0; i < e.MarketDepth.Bid.Count; i++)
								rows.Add(e.MarketDepth.Bid[i].Volume);
					firstBidEvent = false;
				}
			}
			else if (e.MarketDataType == MarketDataType.Ask) {
				rows = askRows;
				if (firstAskEvent) {
					if (e.Operation == Operation.Update)
						lock (e.MarketDepth.Ask)
							for (int i = 0; i < e.MarketDepth.Ask.Count; i++)
								rows.Add(e.MarketDepth.Ask[i].Volume);
					firstAskEvent = false;
				}
			}
			else
				return;
			
			if (e.Operation == Operation.Insert) {
				if (e.Position >= rows.Count)
					rows.Add(e.Volume);
				else
					rows.Insert(e.Position, e.Volume);
			}
			// Race conditions could occur, so check if e.Position is within valid range
			else if (e.Operation == Operation.Update && e.Position < rows.Count)
				rows[e.Position] = e.Volume;
			else if (e.Operation == Operation.Remove && e.Position < rows.Count)
				rows.RemoveAt(e.Position);
		}
		
		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries Bid
        {
			get { return Values[0]; }
		}

		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries Ask
        {
			get { return Values[1]; }
		}

	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private i23[] cachei23 = null;

        private static i23 checki23 = new i23();

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public i23 i23()
        {
            return i23(Input);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public i23 i23(Data.IDataSeries input)
        {
            if (cachei23 != null)
                for (int idx = 0; idx < cachei23.Length; idx++)
                    if (cachei23[idx].EqualsInput(input))
                        return cachei23[idx];

            lock (checki23)
            {
                if (cachei23 != null)
                    for (int idx = 0; idx < cachei23.Length; idx++)
                        if (cachei23[idx].EqualsInput(input))
                            return cachei23[idx];

                i23 indicator = new i23();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                Indicators.Add(indicator);
                indicator.SetUp();

                i23[] tmp = new i23[cachei23 == null ? 1 : cachei23.Length + 1];
                if (cachei23 != null)
                    cachei23.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachei23 = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.i23 i23()
        {
            return _indicator.i23(Input);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.i23 i23(Data.IDataSeries input)
        {
            return _indicator.i23(input);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.i23 i23()
        {
            return _indicator.i23(Input);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.i23 i23(Data.IDataSeries input)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.i23(input);
        }
    }
}
#endregion
