using System;
using NinjaTrader.Adapter;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;

namespace NinjaTrader.Indicator
{
	public class TickRecorder : Indicator
    {
		int _lastBar;
		DateTime _lastBarTime = DateTime.MinValue;
		private readonly TickFileSystemManager _tickFileSystemManager = new TickFileSystemManager();

		protected override void Initialize()
        {
        	Overlay = true;
			CalculateOnBarClose = false;
			_tickFileSystemManager.InstrumentName = Instrument.FullName;
		}

        protected override void OnBarUpdate()
        {
        	if (Historical) return;        	
			if (_lastBar != CurrentBar)
			{
				_lastBar = CurrentBar;
				_tickFileSystemManager.WriteHistoryLine(
					new TickProcessor.MarketTick
					{
						MarketDataEventType = TickProcessor.MarketDataEventType.NextBar,
						Time = _lastBarTime
					});
			}
			_lastBarTime = Time[0];
        }
		
        protected override void OnMarketData(MarketDataEventArgs e)
		{
			_tickFileSystemManager.WriteHistoryLine(
				new TickProcessor.MarketTick
				{
					MarketDataEventType = TickProcessor.MarketDataEventType.MarketData,
					Time = e.Time,
					MarketDataType = (TickProcessor.MarketDataType) e.MarketDataType,
					Price = e.Price,
					Volume = e.Volume
				});
		}
        
        protected override void OnMarketDepth(MarketDepthEventArgs e)
		{
			_tickFileSystemManager.WriteHistoryLine(
				new TickProcessor.MarketTick
				{
					MarketDataEventType = TickProcessor.MarketDataEventType.MarketDepth,
					Time = e.Time,
					MarketDataType = (TickProcessor.MarketDataType) e.MarketDataType,
					Operation = (TickProcessor.Operation) e.Operation,
					Position = e.Position,
					Price = e.Price,
					Volume = e.Volume
				});
        }

        protected override void OnTermination()
		{
        	if (_tickFileSystemManager != null)
        		_tickFileSystemManager.Dispose();
		}
    }
}