using System;
using System.Drawing;
using System.ComponentModel;
using System.Runtime.InteropServices;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Cbi;
using NinjaTrader.Gui.Chart;

namespace NinjaTrader.Indicator
{
    public class i14m04 : Indicator
    {
		int _lastBar;
		private readonly TickProcessor _tickProcessor = new TickProcessor();
		
		public i14m04()
		{
			Period = 100;
			Step = 10;
		}

        protected override void Initialize()
        {
			Add(new Plot(Color.Green,	PlotStyle.Line, "Предложения Bid"));
			Add(new Plot(Color.Red,		PlotStyle.Line, "Предложения Ask"));
			Add(new Plot(Color.Blue,	PlotStyle.Line, "Уровень"));
			Add(new Plot(Color.Cyan,	PlotStyle.Line, "Остаток Bid"));
			Add(new Plot(Color.Magenta,	PlotStyle.Line, "Остаток Ask"));
			CalculateOnBarClose = false;
			_tickProcessor.Print = this.Print;
			_tickProcessor.InstrumentName = Instrument.FullName;
        }

        protected override void OnTermination()
		{
        	if (_tickProcessor != null)
        		_tickProcessor.Dispose();
		}

        protected override void OnBarUpdate()
        {
			if (Historical)
			{
				_tickProcessor.NextHistoricalBar(Time[0]);
				UpdatePreviousDataSeries();
				_tickProcessor.NextBar();
				//Print(Time[0]);
				UpdateDataSeries();
				UpdateSupply();
				return;
			}
			
			if (_lastBar != CurrentBar)
			{
				_lastBar = CurrentBar;
				_tickProcessor.NextBar();
				UpdateDataSeries();
				UpdateSupply();
			}
        }

		protected override void OnMarketData(MarketDataEventArgs e)
		{
//			Print(string.Format("{0}: {1} {2} {3}",
//				e.Time,
//				e.MarketDataType,
//				e.Price,
//				e.Volume));

			_tickProcessor.MarketData(e.Time, (TickProcessor.MarketDataType) e.MarketDataType, e.Price, e.Volume);
			UpdateDataSeries();
			ChartControl.ChartPanel.Invalidate();
		}
		
		protected override void OnMarketDepth(MarketDepthEventArgs e)
		{
//			Print(string.Format("{0} {1} {2} {3} {4} {5}",
//				e.Time,
//				e.MarketDataType,
//				e.Operation,
//				e.Position,
//				e.Price,
//				e.Volume));

			if (!_tickProcessor.IsMarketDepthInitialized)
			{
				for (int i = 0; i < e.MarketDepth.Ask.Count; i++)
				{
					_tickProcessor.MarketDepth(
						e.Time,
						(TickProcessor.MarketDataType) MarketDataType.Ask,
						(TickProcessor.Operation) Operation.Insert,
						i,
						e.MarketDepth.Ask[i].Price,
						e.MarketDepth.Ask[i].Volume);
				}
				for (int i = 0; i < e.MarketDepth.Bid.Count; i++)
				{
					_tickProcessor.MarketDepth(
						e.Time,
						(TickProcessor.MarketDataType) MarketDataType.Bid,
						(TickProcessor.Operation) Operation.Insert,
						i,
						e.MarketDepth.Bid[i].Price,
						e.MarketDepth.Bid[i].Volume);
				}
			}
			
			_tickProcessor.MarketDepth(
				e.Time,
				(TickProcessor.MarketDataType) e.MarketDataType,
				(TickProcessor.Operation) e.Operation,
				e.Position,
				e.Price,
				e.Volume);
//			
//			for (int i = e.MarketDepth.Ask.Count - 1; i >= 0; i--)
//			{
//				Print(string.Format("Ask {0} {1}", e.MarketDepth.Ask[i].Price, e.MarketDepth.Ask[i].Volume));
//			}
//			for (int i = 0; i < e.MarketDepth.Bid.Count; i++)
//			{
//				Print(string.Format("Bid {0} {1}", e.MarketDepth.Bid[i].Price, e.MarketDepth.Bid[i].Volume));
//			}
		}
		
		private void UpdateDataSeries()
		{
			Bid.Set(_tickProcessor.BidVolume);
			Ask.Set(_tickProcessor.AskVolume);
			RemainingBid.Set(_tickProcessor.ComulatedRemainingBidVolume);
			RemainingAsk.Set(_tickProcessor.ComulatedRemainingAskVolume);
			if (RemainingBid.Count > 1)
				RemainingBid[1] = _tickProcessor.PreviousComulatedRemainingBidVolume;
			if (RemainingAsk.Count > 1)
				RemainingAsk[1] = _tickProcessor.PreviousComulatedRemainingAskVolume;
		}
		
		private void UpdatePreviousDataSeries()
		{
			if (Bid.Count > 1)
				Bid[1] = _tickProcessor.BidVolume;
			if (Ask.Count > 1)
				Ask[1] = _tickProcessor.AskVolume;
			if (RemainingBid.Count > 1)
				RemainingBid[1] = _tickProcessor.ComulatedRemainingBidVolume;
			if (RemainingAsk.Count > 1)
				RemainingAsk[1] = _tickProcessor.ComulatedRemainingAskVolume;
			if (RemainingBid.Count > 2)
				RemainingBid[2] = _tickProcessor.PreviousComulatedRemainingBidVolume;
			if (RemainingAsk.Count > 2)
				RemainingAsk[2] = _tickProcessor.PreviousComulatedRemainingAskVolume;
		}
		
		private void UpdateSupply()
		{
			double? supply = _tickProcessor.GetSupply();
			if (supply.HasValue) Supply.Set(supply.Value);
		}

        #region Properties
        [Browsable(false)]
        [XmlIgnore()]
        public DataSeries Bid
        {
            get { return Values[0]; }
        }

        [Browsable(false)]
        [XmlIgnore()]
        public DataSeries Ask
        {
            get { return Values[1]; }
        }

        [Browsable(false)]
        [XmlIgnore()]
        public DataSeries Supply
        {
            get { return Values[2]; }
        }

        [Browsable(false)]
        [XmlIgnore()]
        public DataSeries RemainingBid
        {
            get { return Values[3]; }
        }

        [Browsable(false)]
        [XmlIgnore()]
        public DataSeries RemainingAsk
        {
            get { return Values[4]; }
        }

        [Description("Период")]
        [GridCategory("Parameters")]
        public int Period
        {
            get { return _tickProcessor.SupplyPeriod; }
            set { _tickProcessor.SupplyPeriod = Math.Max(1, value); }
        }

        [Description("Шаг")]
        [GridCategory("Parameters")]
        public int Step
        {
            get { return _tickProcessor.SupplyStep; }
            set { _tickProcessor.SupplyStep = Math.Max(1, value); }
        }
        #endregion
    }
}
