﻿//
// Copyright (C) 2006, NinjaTrader LLC <ninjatrader@ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
	public partial class Indicator : IndicatorBase
	{
		private LT_DivDelta[] _LT_MPP_cacheDD = null;
		private LT_VWAPMarketProfile[] _LT_MPP_cacheVWAP = null;

		private static LT_DivDelta _LT_MPP_checkDD = new LT_DivDelta();
		private static LT_VWAPMarketProfile _LT_MPP_checkVWAP = new LT_VWAPMarketProfile();

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public LT_DivDelta LT_DivDelta(
			bool useSessionTimes, string sessionStartTime, string sessionEndTime, ESessionType sessionType, int sessionValue,
			EDeltaCalculationMode deltaCalculationMode, ETradeFilterMode tradeFilterMode, int tradeFilterSize, bool loadHistoricalData,
			bool enableAlerts, string alertDeltaValues)
		{
			return LT_DivDelta(Input, useSessionTimes, sessionStartTime, sessionEndTime, sessionType, sessionValue,
				deltaCalculationMode, tradeFilterMode, tradeFilterSize, loadHistoricalData, enableAlerts, alertDeltaValues);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public LT_DivDelta LT_DivDelta(Data.IDataSeries input,
			bool useSessionTimes, string sessionStartTime, string sessionEndTime, ESessionType sessionType, int sessionValue,
			EDeltaCalculationMode deltaCalculationMode, ETradeFilterMode tradeFilterMode, int tradeFilterSize, bool loadHistoricalData,
			bool enableAlerts, string alertDeltaValues)
		{
			if (_LT_MPP_cacheDD != null)
			{
				for (int idx = 0; idx < _LT_MPP_cacheDD.Length; idx++)
				{
					if (_LT_MPP_cacheDD[idx].UseSessionTimes == useSessionTimes &&
						_LT_MPP_cacheDD[idx].SessionStartTime == sessionStartTime &&
						_LT_MPP_cacheDD[idx].SessionEndTime == sessionEndTime &&
						_LT_MPP_cacheDD[idx].SessionType == sessionType &&
						_LT_MPP_cacheDD[idx].SessionValue == sessionValue &&
						_LT_MPP_cacheDD[idx].DeltaCalcMode == deltaCalculationMode &&
						_LT_MPP_cacheDD[idx].TradeFilterMode == tradeFilterMode &&
						_LT_MPP_cacheDD[idx].TradeFilterSize == tradeFilterSize &&
						_LT_MPP_cacheDD[idx].LoadHistoricalData == loadHistoricalData &&
						_LT_MPP_cacheDD[idx].EnableAlerts == enableAlerts &&
						_LT_MPP_cacheDD[idx].AlertDeltaValues == alertDeltaValues &&
						_LT_MPP_cacheDD[idx].EqualsInput(input))
					{
						return _LT_MPP_cacheDD[idx];
					}
				}
			}

			lock (_LT_MPP_checkDD)
			{
				_LT_MPP_checkDD.UseSessionTimes = useSessionTimes;
				useSessionTimes = _LT_MPP_checkDD.UseSessionTimes;
				_LT_MPP_checkDD.SessionStartTime = sessionStartTime;
				sessionStartTime = _LT_MPP_checkDD.SessionStartTime;
				_LT_MPP_checkDD.SessionEndTime = sessionEndTime;
				sessionEndTime = _LT_MPP_checkDD.SessionEndTime;
				_LT_MPP_checkDD.SessionType = sessionType;
				sessionType = _LT_MPP_checkDD.SessionType;
				_LT_MPP_checkDD.SessionValue = sessionValue;
				sessionValue = _LT_MPP_checkDD.SessionValue;
				_LT_MPP_checkDD.DeltaCalcMode = deltaCalculationMode;
				deltaCalculationMode = _LT_MPP_checkDD.DeltaCalcMode;
				_LT_MPP_checkDD.TradeFilterMode = tradeFilterMode;
				tradeFilterMode = _LT_MPP_checkDD.TradeFilterMode;
				_LT_MPP_checkDD.TradeFilterSize = tradeFilterSize;
				tradeFilterSize = _LT_MPP_checkDD.TradeFilterSize;
				_LT_MPP_checkDD.LoadHistoricalData = loadHistoricalData;
				loadHistoricalData = _LT_MPP_checkDD.LoadHistoricalData;
				_LT_MPP_checkDD.EnableAlerts = enableAlerts;
				enableAlerts = _LT_MPP_checkDD.EnableAlerts;
				_LT_MPP_checkDD.AlertDeltaValues = alertDeltaValues;
				alertDeltaValues = _LT_MPP_checkDD.AlertDeltaValues;

				if (_LT_MPP_cacheDD != null)
				{
					for (int idx = 0; idx < _LT_MPP_cacheDD.Length; idx++)
					{
						if (_LT_MPP_cacheDD[idx].UseSessionTimes == useSessionTimes &&
							_LT_MPP_cacheDD[idx].SessionStartTime == sessionStartTime &&
							_LT_MPP_cacheDD[idx].SessionEndTime == sessionEndTime &&
							_LT_MPP_cacheDD[idx].SessionType == sessionType &&
							_LT_MPP_cacheDD[idx].SessionValue == sessionValue &&
							_LT_MPP_cacheDD[idx].DeltaCalcMode == deltaCalculationMode &&
							_LT_MPP_cacheDD[idx].TradeFilterMode == tradeFilterMode &&
							_LT_MPP_cacheDD[idx].TradeFilterSize == tradeFilterSize &&
							_LT_MPP_cacheDD[idx].LoadHistoricalData == loadHistoricalData &&
							_LT_MPP_cacheDD[idx].EnableAlerts == enableAlerts &&
							_LT_MPP_cacheDD[idx].AlertDeltaValues == alertDeltaValues &&
							_LT_MPP_cacheDD[idx].EqualsInput(input))
						{
							return _LT_MPP_cacheDD[idx];
						}
					}
				}

				LT_DivDelta indicator = new LT_DivDelta();
				indicator.BarsRequired = BarsRequired;
				indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
				indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
				indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
				indicator.Input = input;

				indicator.UseSessionTimes = useSessionTimes;
				indicator.SessionStartTime = sessionStartTime;
				indicator.SessionEndTime = sessionEndTime;
				indicator.SessionType = sessionType;
				indicator.SessionValue = sessionValue;
				indicator.DeltaCalcMode = deltaCalculationMode;
				indicator.TradeFilterMode = tradeFilterMode;
				indicator.TradeFilterSize = tradeFilterSize;
				indicator.LoadHistoricalData = loadHistoricalData;
				indicator.EnableAlerts = enableAlerts;
				indicator.AlertDeltaValues = alertDeltaValues;

				Indicators.Add(indicator);
				indicator.SetUp();

				LT_DivDelta[] tmp = new LT_DivDelta[_LT_MPP_cacheDD == null ? 1 : _LT_MPP_cacheDD.Length + 1];
				if (_LT_MPP_cacheDD != null)
					_LT_MPP_cacheDD.CopyTo(tmp, 0);
				tmp[tmp.Length - 1] = indicator;
				_LT_MPP_cacheDD = tmp;
				return indicator;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public LT_VWAPMarketProfile LT_VWAPMarketProfile(
			bool useSessionTimes, string sessionStartTime, string sessionEndTime, ESessionType sessionType, int sessionValue,
			int openRangeLength, bool blankBetweenSessions, bool smoothPOC, bool openRangeFromFirstBar,
			EVACalculation vaCalculation, int va1Size, int va2Size, EVAAlgorithm vaAlgorithm, bool enableAlerts)
		{
			return LT_VWAPMarketProfile(Input, useSessionTimes, sessionStartTime, sessionEndTime, sessionType, sessionValue,
				openRangeLength, blankBetweenSessions, smoothPOC, openRangeFromFirstBar, vaCalculation,
				va1Size, va2Size, vaAlgorithm, enableAlerts);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public LT_VWAPMarketProfile LT_VWAPMarketProfile(Data.IDataSeries input,
			bool useSessionTimes, string sessionStartTime, string sessionEndTime, ESessionType sessionType, int sessionValue,
			int openRangeLength, bool blankBetweenSessions, bool smoothPOC, bool openRangeFromFirstBar,
			EVACalculation vaCalculation, int va1Size, int va2Size, EVAAlgorithm vaAlgorithm, bool enableAlerts)
		{
			if (_LT_MPP_cacheVWAP != null)
			{
				for (int idx = 0; idx < _LT_MPP_cacheVWAP.Length; idx++)
				{
					if (_LT_MPP_cacheVWAP[idx].UseSessionTimes == useSessionTimes &&
						_LT_MPP_cacheVWAP[idx].SessionStartTime == sessionStartTime &&
						_LT_MPP_cacheVWAP[idx].SessionEndTime == sessionEndTime &&
						_LT_MPP_cacheVWAP[idx].SessionType == sessionType &&
						_LT_MPP_cacheVWAP[idx].SessionValue == sessionValue &&
						_LT_MPP_cacheVWAP[idx].OpenRangeLength == openRangeLength &&
						_LT_MPP_cacheVWAP[idx].BlankBetweenSessions == blankBetweenSessions &&
						_LT_MPP_cacheVWAP[idx].SmoothPOC == smoothPOC &&
						_LT_MPP_cacheVWAP[idx].OpenRangeFromFirstBar == openRangeFromFirstBar &&
						_LT_MPP_cacheVWAP[idx].VACalculation == vaCalculation &&
						_LT_MPP_cacheVWAP[idx].VA1Size == va1Size &&
						_LT_MPP_cacheVWAP[idx].VA2Size == va2Size &&
						_LT_MPP_cacheVWAP[idx].VAAlgorithm == vaAlgorithm &&
						_LT_MPP_cacheVWAP[idx].EnableAlerts == enableAlerts &&
						_LT_MPP_cacheVWAP[idx].EqualsInput(input))
					{
						return _LT_MPP_cacheVWAP[idx];
					}
				}
			}

			lock (_LT_MPP_checkVWAP)
			{
				_LT_MPP_checkVWAP.UseSessionTimes = useSessionTimes;
				useSessionTimes = _LT_MPP_checkVWAP.UseSessionTimes;
				_LT_MPP_checkVWAP.SessionStartTime = sessionStartTime;
				sessionStartTime = _LT_MPP_checkVWAP.SessionStartTime;
				_LT_MPP_checkVWAP.SessionEndTime = sessionEndTime;
				sessionEndTime = _LT_MPP_checkVWAP.SessionEndTime;
				_LT_MPP_checkVWAP.SessionType = sessionType;
				sessionType = _LT_MPP_checkVWAP.SessionType;
				_LT_MPP_checkVWAP.SessionValue = sessionValue;
				sessionValue = _LT_MPP_checkVWAP.SessionValue;
				_LT_MPP_checkVWAP.OpenRangeLength = openRangeLength;
				openRangeLength = _LT_MPP_checkVWAP.OpenRangeLength;
				_LT_MPP_checkVWAP.OpenRangeFromFirstBar = openRangeFromFirstBar;
				openRangeFromFirstBar = _LT_MPP_checkVWAP.OpenRangeFromFirstBar;
				_LT_MPP_checkVWAP.BlankBetweenSessions = blankBetweenSessions;
				blankBetweenSessions = _LT_MPP_checkVWAP.BlankBetweenSessions;
				_LT_MPP_checkVWAP.SmoothPOC = smoothPOC;
				smoothPOC = _LT_MPP_checkVWAP.SmoothPOC;
				_LT_MPP_checkVWAP.VACalculation = vaCalculation;
				vaCalculation = _LT_MPP_checkVWAP.VACalculation;
				_LT_MPP_checkVWAP.VAAlgorithm = vaAlgorithm;
				vaAlgorithm = _LT_MPP_checkVWAP.VAAlgorithm;
				_LT_MPP_checkVWAP.VA1Size = va1Size;
				va1Size = _LT_MPP_checkVWAP.VA1Size;
				_LT_MPP_checkVWAP.VA2Size = va2Size;
				va2Size = _LT_MPP_checkVWAP.VA2Size;
				_LT_MPP_checkVWAP.EnableAlerts = enableAlerts;
				enableAlerts = _LT_MPP_checkVWAP.EnableAlerts;

				if (_LT_MPP_cacheVWAP != null)
				{
					for (int idx = 0; idx < _LT_MPP_cacheVWAP.Length; idx++)
					{
						if (_LT_MPP_cacheVWAP[idx].UseSessionTimes == useSessionTimes &&
							_LT_MPP_cacheVWAP[idx].SessionStartTime == sessionStartTime &&
							_LT_MPP_cacheVWAP[idx].SessionEndTime == sessionEndTime &&
							_LT_MPP_cacheVWAP[idx].SessionType == sessionType &&
							_LT_MPP_cacheVWAP[idx].SessionValue == sessionValue &&
							_LT_MPP_cacheVWAP[idx].OpenRangeLength == openRangeLength &&
							_LT_MPP_cacheVWAP[idx].BlankBetweenSessions == blankBetweenSessions &&
							_LT_MPP_cacheVWAP[idx].SmoothPOC == smoothPOC &&
							_LT_MPP_cacheVWAP[idx].OpenRangeFromFirstBar == openRangeFromFirstBar &&
							_LT_MPP_cacheVWAP[idx].VACalculation == vaCalculation &&
							_LT_MPP_cacheVWAP[idx].VA1Size == va1Size &&
							_LT_MPP_cacheVWAP[idx].VA2Size == va2Size &&
							_LT_MPP_cacheVWAP[idx].VAAlgorithm == vaAlgorithm &&
							_LT_MPP_cacheVWAP[idx].EnableAlerts == enableAlerts &&
							_LT_MPP_cacheVWAP[idx].EqualsInput(input))
						{
							return _LT_MPP_cacheVWAP[idx];
						}
					}
				}

				LT_VWAPMarketProfile indicator = new LT_VWAPMarketProfile();
				indicator.BarsRequired = BarsRequired;
				indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
				indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
				indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
				indicator.Input = input;

				indicator.UseSessionTimes = useSessionTimes;
				indicator.SessionStartTime = sessionStartTime;
				indicator.SessionEndTime = sessionEndTime;
				indicator.SessionType = sessionType;
				indicator.SessionValue = sessionValue;
				indicator.OpenRangeLength = openRangeLength;
				indicator.OpenRangeFromFirstBar = openRangeFromFirstBar;
				indicator.BlankBetweenSessions = blankBetweenSessions;
				indicator.SmoothPOC = smoothPOC;
				indicator.VACalculation = vaCalculation;
				indicator.VAAlgorithm = vaAlgorithm;
				indicator.VA1Size = va1Size;
				indicator.VA2Size = va2Size;
				indicator.EnableAlerts = enableAlerts;

				Indicators.Add(indicator);
				indicator.SetUp();

				LT_VWAPMarketProfile[] tmp = new LT_VWAPMarketProfile[_LT_MPP_cacheVWAP == null ? 1 : _LT_MPP_cacheVWAP.Length + 1];
				if (_LT_MPP_cacheVWAP != null)
					_LT_MPP_cacheVWAP.CopyTo(tmp, 0);
				tmp[tmp.Length - 1] = indicator;
				_LT_MPP_cacheVWAP = tmp;
				return indicator;
			}
		}
	}
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.LT_DivDelta LT_DivDelta(bool useSessionTimes, string sessionStartTime,
			string sessionEndTime, ESessionType sessionType, int sessionValue, EDeltaCalculationMode deltaCalculationMode,
			ETradeFilterMode tradeFilterMode, int tradeFilterSize, bool loadHistoricalData, bool enableAlerts, string alertDeltaValues)
        {
            return _indicator.LT_DivDelta(Input, useSessionTimes, sessionStartTime, sessionEndTime, sessionType, sessionValue,
				deltaCalculationMode, tradeFilterMode, tradeFilterSize, loadHistoricalData, enableAlerts, alertDeltaValues);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.LT_DivDelta LT_DivDelta(Data.IDataSeries input,
			bool useSessionTimes, string sessionStartTime, string sessionEndTime, ESessionType sessionType, int sessionValue,
			EDeltaCalculationMode deltaCalculationMode, ETradeFilterMode tradeFilterMode, int tradeFilterSize,
			bool loadHistoricalData, bool enableAlerts, string alertDeltaValues)
        {
            return _indicator.LT_DivDelta(input, useSessionTimes, sessionStartTime, sessionEndTime, sessionType, sessionValue,
				deltaCalculationMode, tradeFilterMode, tradeFilterSize, loadHistoricalData, enableAlerts, alertDeltaValues);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.LT_VWAPMarketProfile LT_VWAPMarketProfile(bool useSessionTimes, string sessionStartTime,
			string sessionEndTime, ESessionType sessionType, int sessionValue, int openRangeLength,
			bool blankBetweenSessions, bool smoothPOC, bool openRangeFromFirstBar, EVACalculation vaCalculation,
			int va1Size, int va2Size, EVAAlgorithm vaAlgorithm, bool enableAlerts)
        {
            return _indicator.LT_VWAPMarketProfile(Input, useSessionTimes, sessionStartTime, sessionEndTime,
					sessionType, sessionValue, openRangeLength, blankBetweenSessions, smoothPOC,
					openRangeFromFirstBar, vaCalculation, va1Size, va2Size, vaAlgorithm, enableAlerts);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.LT_VWAPMarketProfile LT_VWAPMarketProfile(Data.IDataSeries input,
			bool useSessionTimes, string sessionStartTime, string sessionEndTime, ESessionType sessionType, int sessionValue,
			int openRangeLength, bool blankBetweenSessions, bool smoothPOC, bool openRangeFromFirstBar,
			EVACalculation vaCalculation, int va1Size, int va2Size, EVAAlgorithm vaAlgorithm, bool enableAlerts)
        {
            return _indicator.LT_VWAPMarketProfile(input, useSessionTimes, sessionStartTime, sessionEndTime,
					sessionType, sessionValue, openRangeLength, blankBetweenSessions, smoothPOC,
					openRangeFromFirstBar, vaCalculation, va1Size, va2Size, vaAlgorithm, enableAlerts);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.LT_DivDelta LT_DivDelta(bool useSessionTimes, string sessionStartTime,
			string sessionEndTime, ESessionType sessionType, int sessionValue, EDeltaCalculationMode deltaCalculationMode,
			ETradeFilterMode tradeFilterMode, int tradeFilterSize, bool loadHistoricalData, bool enableAlerts, string alertDeltaValues)
        {
            return _indicator.LT_DivDelta(Input, useSessionTimes, sessionStartTime, sessionEndTime, sessionType, sessionValue,
				deltaCalculationMode, tradeFilterMode, tradeFilterSize, loadHistoricalData, enableAlerts, alertDeltaValues);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.LT_DivDelta LT_DivDelta(Data.IDataSeries input,
			bool useSessionTimes, string sessionStartTime, string sessionEndTime, ESessionType sessionType, int sessionValue,
			EDeltaCalculationMode deltaCalculationMode, ETradeFilterMode tradeFilterMode, int tradeFilterSize,
			bool loadHistoricalData, bool enableAlerts, string alertDeltaValues)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.LT_DivDelta(input, useSessionTimes, sessionStartTime, sessionEndTime, sessionType, sessionValue,
				deltaCalculationMode, tradeFilterMode, tradeFilterSize, loadHistoricalData, enableAlerts, alertDeltaValues);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.LT_VWAPMarketProfile LT_VWAPMarketProfile(bool useSessionTimes, string sessionStartTime,
			string sessionEndTime, ESessionType sessionType, int sessionValue, int openRangeLength,
			bool blankBetweenSessions, bool smoothPOC, bool openRangeFromFirstBar, EVACalculation vaCalculation,
			int va1Size, int va2Size, EVAAlgorithm vaAlgorithm, bool enableAlerts)
        {
            return _indicator.LT_VWAPMarketProfile(Input, useSessionTimes, sessionStartTime, sessionEndTime,
					sessionType, sessionValue, openRangeLength, blankBetweenSessions, smoothPOC,
					openRangeFromFirstBar, vaCalculation, va1Size, va2Size, vaAlgorithm, enableAlerts);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.LT_VWAPMarketProfile LT_VWAPMarketProfile(Data.IDataSeries input,
			bool useSessionTimes, string sessionStartTime, string sessionEndTime, ESessionType sessionType, int sessionValue,
			int openRangeLength, bool blankBetweenSessions, bool smoothPOC, bool openRangeFromFirstBar,
			EVACalculation vaCalculation, int va1Size, int va2Size, EVAAlgorithm vaAlgorithm, bool enableAlerts)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.LT_VWAPMarketProfile(input, useSessionTimes, sessionStartTime, sessionEndTime,
					sessionType, sessionValue, openRangeLength, blankBetweenSessions, smoothPOC,
					openRangeFromFirstBar, vaCalculation, va1Size, va2Size, vaAlgorithm, enableAlerts);
        }
    }
}
#endregion
