#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.Design;
using System.Windows.Forms;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    
    [Description("")]
    public class ScrollsLite : Indicator
    {
        #region Variables
            private double     as_margin = 0;   // margin to cover in autoscroll mode
		    private int        ct;
		    private int        cb;
		    private int        old_mouse_y;
		    private bool       scale_init;
		    private bool       auto_scroll = true;
		    private double     scale;
		    private double     margin_size;  //used by maximum/minimum price in dataseries and also by auto scroll feature.
		    private int        extra_margin = 10;
        #endregion

        
        protected override void Initialize()
        {
            Overlay				= true;
			CalculateOnBarClose = false;
			AutoScale           = true;
			scale_init          = false;
        }
		
		
		protected override void OnStartUp()
		{
			base.OnStartUp();
			this.ChartControl.YAxisRangeTypeRight = YAxisRangeType.Fixed;
			this.ChartControl.ChartPanel.MouseUp += new MouseEventHandler(MouseDrag_OnScale);
			this.ChartControl.ChartPanel.MouseDown += new MouseEventHandler(MouseDown_OnChart);
			this.ChartControl.ChartPanel.MouseMove += new MouseEventHandler(MouseDrag_OnChart);
			this.ChartControl.ChartPanel.MouseMove += new MouseEventHandler(EnableAutoScroll);
			margin_size = (double)(extra_margin*TickSize);
			UpdateScale();
		}
        
        protected override void OnBarUpdate()
        {
            if(CurrentBar < 0)return;
			if(!scale_init && CurrentBar == Count - 1)
			{
				UpdateScale();
				scale_init = true;
			}
			AutoScroll();
        }
		
		protected void UpdateScale()
		{
			ct = this.ChartControl.CanvasTop;
			cb = this.ChartControl.CanvasBottom;
			scale = (this.ChartControl.FixedPanelMaxRight - this.ChartControl.FixedPanelMinRight)/ ( cb - ct );
		}
		
		#region Event Handelers
		
		private void EnableAutoScroll(object sender, MouseEventArgs e)
		{
			if(e.Y <= this.ChartControl.CanvasTop)
			{
			    if(!auto_scroll)
			    {
			    	auto_scroll = true;
				    AutoScroll();          // added to make shift of chart when clicks.
			    }
			}
			else return;
			this.ChartControl.ChartPanel.Invalidate();
		}
		
		
		private void MouseDrag_OnScale(object sender, MouseEventArgs e)
		{
			if( this.ChartControl.CanvasRight < e.X  && e.X < this.ChartControl.Size.Width)
			{
				if(e.Button == MouseButtons.Left)
				{
					UpdateScale();
					this.ChartControl.ChartPanel.Invalidate();
				}
			}
		}
		
		private void MouseDown_OnChart(object sender, MouseEventArgs e)
		{
			if(e.Button == MouseButtons.Left)
			{
				if(!MouseOnChart(e.X,e.Y)) return;
				else old_mouse_y = e.Y;
			}
		}
		
		
		private void MouseDrag_OnChart(object sender, MouseEventArgs e)
		{
			
			if(e.Button == MouseButtons.Left)
			{
				if(!MouseOnChart(e.X,e.Y)) return;
				else
				{
					as_margin = (double) ( e.Y - old_mouse_y)*scale;
					this.ChartControl.FixedPanelMinRight = this.ChartControl.FixedPanelMinRight + as_margin;
					this.ChartControl.FixedPanelMaxRight = this.ChartControl.FixedPanelMaxRight + as_margin;
					as_margin = 0;
					old_mouse_y = e.Y;
				}
				auto_scroll = false;
			}
			this.ChartControl.ChartPanel.Invalidate();
		}
		
		protected bool MouseOnChart(int x, int y)
		{
			int temp_y;
			temp_y = this.ChartControl.GetYByValue(this,this.ChartControl.FixedPanelMinRight);   // restricted only in price panel
			if( x < this.ChartControl.CanvasLeft || x >= this.ChartControl.CanvasRight || y < this.ChartControl.CanvasTop || y > temp_y) return false;
			else return true;
		}
		#endregion
		
		protected void AutoScroll()
		{
			int rmb_index;
			rmb_index = CurrentBar - this.LastBarIndexPainted;
			if(auto_scroll)
			{
				if(this.ChartControl.FixedPanelMaxRight - High[rmb_index] < margin_size
				&& this.ChartControl.FixedPanelMaxRight + this.ChartControl.FixedPanelMinRight < 2*Close[rmb_index])
				
				          {
					         as_margin = (margin_size - this.ChartControl.FixedPanelMaxRight + High[rmb_index]);
					         this.ChartControl.FixedPanelMaxRight = this.ChartControl.FixedPanelMaxRight + as_margin;
					         this.ChartControl.FixedPanelMinRight = this.ChartControl.FixedPanelMinRight + as_margin;
					         
				          }
				
				if(Low[rmb_index] - this.ChartControl.FixedPanelMinRight  < margin_size
				&& this.ChartControl.FixedPanelMaxRight + this.ChartControl.FixedPanelMinRight > 2*Close[rmb_index]	)
				
				          {
					         as_margin = (margin_size - Low[rmb_index] + this.ChartControl.FixedPanelMinRight);
					         this.ChartControl.FixedPanelMinRight = this.ChartControl.FixedPanelMinRight - as_margin;
					         this.ChartControl.FixedPanelMaxRight = this.ChartControl.FixedPanelMaxRight - as_margin;
					         
				           }
				as_margin = 0;
			}
		}
		
		protected override void OnTermination()
		{
			this.ChartControl.ChartPanel.MouseUp -= MouseDrag_OnScale;
			this.ChartControl.ChartPanel.MouseDown -= MouseDown_OnChart;
			this.ChartControl.ChartPanel.MouseMove -= MouseDrag_OnChart;
			this.ChartControl.YAxisRangeTypeRight = YAxisRangeType.Automatic;
			this.ChartControl.ChartPanel.MouseMove -= EnableAutoScroll;
			base.OnTermination();
		}

        #region Properties
		[Description("Select extra ticks to have on beyond high/low of Current Bar during AutoScroll.")]
        [Category("Parameters")]
		[Gui.Design.DisplayName("Extra Ticks")]
        public int Extra_margin
        {
            get { return extra_margin; }
            set { extra_margin = Math.Max(1, value); }
        }
		

        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private ScrollsLite[] cacheScrollsLite = null;

        private static ScrollsLite checkScrollsLite = new ScrollsLite();

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public ScrollsLite ScrollsLite(int extra_margin)
        {
            return ScrollsLite(Input, extra_margin);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public ScrollsLite ScrollsLite(Data.IDataSeries input, int extra_margin)
        {
            if (cacheScrollsLite != null)
                for (int idx = 0; idx < cacheScrollsLite.Length; idx++)
                    if (cacheScrollsLite[idx].Extra_margin == extra_margin && cacheScrollsLite[idx].EqualsInput(input))
                        return cacheScrollsLite[idx];

            lock (checkScrollsLite)
            {
                checkScrollsLite.Extra_margin = extra_margin;
                extra_margin = checkScrollsLite.Extra_margin;

                if (cacheScrollsLite != null)
                    for (int idx = 0; idx < cacheScrollsLite.Length; idx++)
                        if (cacheScrollsLite[idx].Extra_margin == extra_margin && cacheScrollsLite[idx].EqualsInput(input))
                            return cacheScrollsLite[idx];

                ScrollsLite indicator = new ScrollsLite();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Extra_margin = extra_margin;
                Indicators.Add(indicator);
                indicator.SetUp();

                ScrollsLite[] tmp = new ScrollsLite[cacheScrollsLite == null ? 1 : cacheScrollsLite.Length + 1];
                if (cacheScrollsLite != null)
                    cacheScrollsLite.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheScrollsLite = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.ScrollsLite ScrollsLite(int extra_margin)
        {
            return _indicator.ScrollsLite(Input, extra_margin);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.ScrollsLite ScrollsLite(Data.IDataSeries input, int extra_margin)
        {
            return _indicator.ScrollsLite(input, extra_margin);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.ScrollsLite ScrollsLite(int extra_margin)
        {
            return _indicator.ScrollsLite(Input, extra_margin);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.ScrollsLite ScrollsLite(Data.IDataSeries input, int extra_margin)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.ScrollsLite(input, extra_margin);
        }
    }
}
#endregion
