//
// Copyright (C) 2006, NinjaTrader LLC <ninjatrader@ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private sbClusterChart[] cachesbClusterChart = null;

        private static sbClusterChart checksbClusterChart = new sbClusterChart();

        /// <summary>
        /// Cluster Chart by Anton Bazhenov\nhttp://protradestudio.ru
        /// </summary>
        /// <returns></returns>
        public sbClusterChart sbClusterChart(long aboveLimit1, Color aboveLimit1Color, long aboveLimit2, Color aboveLimit2Color, Color barColor, long belowLimit1, Color belowLimit1Color, long belowLimit2, Color belowLimit2Color, Font clusterFont, Color dodgeBarColor, Color downBarColor, bool fillAboveClusters, bool fillBelowClusters, bool fillClusters, bool fillMaxCluster, Pen hiLowPen, int horisontalVolMargin, long horisontalVolumeLimit, Color horisontalVolumeLimitColor, Color horVolColor, Color maxTickVolBarColor, long maxVolumeLimit, bool showBarFrame, bool showClusterCount, bool showDayHiLow, bool showHorisontalVolume, bool showHorisontalVolumeValue, bool showOpenClose, bool showTickVolume, bool showVerticalVolume, bool showVerticalVolumeValue, Color textColor, int ticksPerCluster, Color upBarColor, int verticalVolMargin, long verticalVolumeLimit, Color verticalVolumeLimitColor, Color vertVolColor, long volumeRangeMax, long volumeRangeMin)
        {
            return sbClusterChart(Input, aboveLimit1, aboveLimit1Color, aboveLimit2, aboveLimit2Color, barColor, belowLimit1, belowLimit1Color, belowLimit2, belowLimit2Color, clusterFont, dodgeBarColor, downBarColor, fillAboveClusters, fillBelowClusters, fillClusters, fillMaxCluster, hiLowPen, horisontalVolMargin, horisontalVolumeLimit, horisontalVolumeLimitColor, horVolColor, maxTickVolBarColor, maxVolumeLimit, showBarFrame, showClusterCount, showDayHiLow, showHorisontalVolume, showHorisontalVolumeValue, showOpenClose, showTickVolume, showVerticalVolume, showVerticalVolumeValue, textColor, ticksPerCluster, upBarColor, verticalVolMargin, verticalVolumeLimit, verticalVolumeLimitColor, vertVolColor, volumeRangeMax, volumeRangeMin);
        }

        /// <summary>
        /// Cluster Chart by Anton Bazhenov\nhttp://protradestudio.ru
        /// </summary>
        /// <returns></returns>
        public sbClusterChart sbClusterChart(Data.IDataSeries input, long aboveLimit1, Color aboveLimit1Color, long aboveLimit2, Color aboveLimit2Color, Color barColor, long belowLimit1, Color belowLimit1Color, long belowLimit2, Color belowLimit2Color, Font clusterFont, Color dodgeBarColor, Color downBarColor, bool fillAboveClusters, bool fillBelowClusters, bool fillClusters, bool fillMaxCluster, Pen hiLowPen, int horisontalVolMargin, long horisontalVolumeLimit, Color horisontalVolumeLimitColor, Color horVolColor, Color maxTickVolBarColor, long maxVolumeLimit, bool showBarFrame, bool showClusterCount, bool showDayHiLow, bool showHorisontalVolume, bool showHorisontalVolumeValue, bool showOpenClose, bool showTickVolume, bool showVerticalVolume, bool showVerticalVolumeValue, Color textColor, int ticksPerCluster, Color upBarColor, int verticalVolMargin, long verticalVolumeLimit, Color verticalVolumeLimitColor, Color vertVolColor, long volumeRangeMax, long volumeRangeMin)
        {
            if (cachesbClusterChart != null)
                for (int idx = 0; idx < cachesbClusterChart.Length; idx++)
                    if (cachesbClusterChart[idx].AboveLimit1 == aboveLimit1 && cachesbClusterChart[idx].AboveLimit1Color == aboveLimit1Color && cachesbClusterChart[idx].AboveLimit2 == aboveLimit2 && cachesbClusterChart[idx].AboveLimit2Color == aboveLimit2Color && cachesbClusterChart[idx].BarColor == barColor && cachesbClusterChart[idx].BelowLimit1 == belowLimit1 && cachesbClusterChart[idx].BelowLimit1Color == belowLimit1Color && cachesbClusterChart[idx].BelowLimit2 == belowLimit2 && cachesbClusterChart[idx].BelowLimit2Color == belowLimit2Color && cachesbClusterChart[idx].ClusterFont == clusterFont && cachesbClusterChart[idx].DodgeBarColor == dodgeBarColor && cachesbClusterChart[idx].DownBarColor == downBarColor && cachesbClusterChart[idx].FillAboveClusters == fillAboveClusters && cachesbClusterChart[idx].FillBelowClusters == fillBelowClusters && cachesbClusterChart[idx].FillClusters == fillClusters && cachesbClusterChart[idx].FillMaxCluster == fillMaxCluster && cachesbClusterChart[idx].HiLowPen == hiLowPen && cachesbClusterChart[idx].HorisontalVolMargin == horisontalVolMargin && cachesbClusterChart[idx].HorisontalVolumeLimit == horisontalVolumeLimit && cachesbClusterChart[idx].HorisontalVolumeLimitColor == horisontalVolumeLimitColor && cachesbClusterChart[idx].HorVolColor == horVolColor && cachesbClusterChart[idx].maxTickVolBarColor == maxTickVolBarColor && cachesbClusterChart[idx].MaxVolumeLimit == maxVolumeLimit && cachesbClusterChart[idx].ShowBarFrame == showBarFrame && cachesbClusterChart[idx].ShowClusterCount == showClusterCount && cachesbClusterChart[idx].ShowDayHiLow == showDayHiLow && cachesbClusterChart[idx].ShowHorisontalVolume == showHorisontalVolume && cachesbClusterChart[idx].ShowHorisontalVolumeValue == showHorisontalVolumeValue && cachesbClusterChart[idx].ShowOpenClose == showOpenClose && cachesbClusterChart[idx].ShowTickVolume == showTickVolume && cachesbClusterChart[idx].ShowVerticalVolume == showVerticalVolume && cachesbClusterChart[idx].ShowVerticalVolumeValue == showVerticalVolumeValue && cachesbClusterChart[idx].TextColor == textColor && cachesbClusterChart[idx].TicksPerCluster == ticksPerCluster && cachesbClusterChart[idx].UpBarColor == upBarColor && cachesbClusterChart[idx].VerticalVolMargin == verticalVolMargin && cachesbClusterChart[idx].VerticalVolumeLimit == verticalVolumeLimit && cachesbClusterChart[idx].VerticalVolumeLimitColor == verticalVolumeLimitColor && cachesbClusterChart[idx].VertVolColor == vertVolColor && cachesbClusterChart[idx].VolumeRangeMax == volumeRangeMax && cachesbClusterChart[idx].VolumeRangeMin == volumeRangeMin && cachesbClusterChart[idx].EqualsInput(input))
                        return cachesbClusterChart[idx];

            lock (checksbClusterChart)
            {
                checksbClusterChart.AboveLimit1 = aboveLimit1;
                aboveLimit1 = checksbClusterChart.AboveLimit1;
                checksbClusterChart.AboveLimit1Color = aboveLimit1Color;
                aboveLimit1Color = checksbClusterChart.AboveLimit1Color;
                checksbClusterChart.AboveLimit2 = aboveLimit2;
                aboveLimit2 = checksbClusterChart.AboveLimit2;
                checksbClusterChart.AboveLimit2Color = aboveLimit2Color;
                aboveLimit2Color = checksbClusterChart.AboveLimit2Color;
                checksbClusterChart.BarColor = barColor;
                barColor = checksbClusterChart.BarColor;
                checksbClusterChart.BelowLimit1 = belowLimit1;
                belowLimit1 = checksbClusterChart.BelowLimit1;
                checksbClusterChart.BelowLimit1Color = belowLimit1Color;
                belowLimit1Color = checksbClusterChart.BelowLimit1Color;
                checksbClusterChart.BelowLimit2 = belowLimit2;
                belowLimit2 = checksbClusterChart.BelowLimit2;
                checksbClusterChart.BelowLimit2Color = belowLimit2Color;
                belowLimit2Color = checksbClusterChart.BelowLimit2Color;
                checksbClusterChart.ClusterFont = clusterFont;
                clusterFont = checksbClusterChart.ClusterFont;
                checksbClusterChart.DodgeBarColor = dodgeBarColor;
                dodgeBarColor = checksbClusterChart.DodgeBarColor;
                checksbClusterChart.DownBarColor = downBarColor;
                downBarColor = checksbClusterChart.DownBarColor;
                checksbClusterChart.FillAboveClusters = fillAboveClusters;
                fillAboveClusters = checksbClusterChart.FillAboveClusters;
                checksbClusterChart.FillBelowClusters = fillBelowClusters;
                fillBelowClusters = checksbClusterChart.FillBelowClusters;
                checksbClusterChart.FillClusters = fillClusters;
                fillClusters = checksbClusterChart.FillClusters;
                checksbClusterChart.FillMaxCluster = fillMaxCluster;
                fillMaxCluster = checksbClusterChart.FillMaxCluster;
                checksbClusterChart.HiLowPen = hiLowPen;
                hiLowPen = checksbClusterChart.HiLowPen;
                checksbClusterChart.HorisontalVolMargin = horisontalVolMargin;
                horisontalVolMargin = checksbClusterChart.HorisontalVolMargin;
                checksbClusterChart.HorisontalVolumeLimit = horisontalVolumeLimit;
                horisontalVolumeLimit = checksbClusterChart.HorisontalVolumeLimit;
                checksbClusterChart.HorisontalVolumeLimitColor = horisontalVolumeLimitColor;
                horisontalVolumeLimitColor = checksbClusterChart.HorisontalVolumeLimitColor;
                checksbClusterChart.HorVolColor = horVolColor;
                horVolColor = checksbClusterChart.HorVolColor;
                checksbClusterChart.maxTickVolBarColor = maxTickVolBarColor;
                maxTickVolBarColor = checksbClusterChart.maxTickVolBarColor;
                checksbClusterChart.MaxVolumeLimit = maxVolumeLimit;
                maxVolumeLimit = checksbClusterChart.MaxVolumeLimit;
                checksbClusterChart.ShowBarFrame = showBarFrame;
                showBarFrame = checksbClusterChart.ShowBarFrame;
                checksbClusterChart.ShowClusterCount = showClusterCount;
                showClusterCount = checksbClusterChart.ShowClusterCount;
                checksbClusterChart.ShowDayHiLow = showDayHiLow;
                showDayHiLow = checksbClusterChart.ShowDayHiLow;
                checksbClusterChart.ShowHorisontalVolume = showHorisontalVolume;
                showHorisontalVolume = checksbClusterChart.ShowHorisontalVolume;
                checksbClusterChart.ShowHorisontalVolumeValue = showHorisontalVolumeValue;
                showHorisontalVolumeValue = checksbClusterChart.ShowHorisontalVolumeValue;
                checksbClusterChart.ShowOpenClose = showOpenClose;
                showOpenClose = checksbClusterChart.ShowOpenClose;
                checksbClusterChart.ShowTickVolume = showTickVolume;
                showTickVolume = checksbClusterChart.ShowTickVolume;
                checksbClusterChart.ShowVerticalVolume = showVerticalVolume;
                showVerticalVolume = checksbClusterChart.ShowVerticalVolume;
                checksbClusterChart.ShowVerticalVolumeValue = showVerticalVolumeValue;
                showVerticalVolumeValue = checksbClusterChart.ShowVerticalVolumeValue;
                checksbClusterChart.TextColor = textColor;
                textColor = checksbClusterChart.TextColor;
                checksbClusterChart.TicksPerCluster = ticksPerCluster;
                ticksPerCluster = checksbClusterChart.TicksPerCluster;
                checksbClusterChart.UpBarColor = upBarColor;
                upBarColor = checksbClusterChart.UpBarColor;
                checksbClusterChart.VerticalVolMargin = verticalVolMargin;
                verticalVolMargin = checksbClusterChart.VerticalVolMargin;
                checksbClusterChart.VerticalVolumeLimit = verticalVolumeLimit;
                verticalVolumeLimit = checksbClusterChart.VerticalVolumeLimit;
                checksbClusterChart.VerticalVolumeLimitColor = verticalVolumeLimitColor;
                verticalVolumeLimitColor = checksbClusterChart.VerticalVolumeLimitColor;
                checksbClusterChart.VertVolColor = vertVolColor;
                vertVolColor = checksbClusterChart.VertVolColor;
                checksbClusterChart.VolumeRangeMax = volumeRangeMax;
                volumeRangeMax = checksbClusterChart.VolumeRangeMax;
                checksbClusterChart.VolumeRangeMin = volumeRangeMin;
                volumeRangeMin = checksbClusterChart.VolumeRangeMin;

                if (cachesbClusterChart != null)
                    for (int idx = 0; idx < cachesbClusterChart.Length; idx++)
                        if (cachesbClusterChart[idx].AboveLimit1 == aboveLimit1 && cachesbClusterChart[idx].AboveLimit1Color == aboveLimit1Color && cachesbClusterChart[idx].AboveLimit2 == aboveLimit2 && cachesbClusterChart[idx].AboveLimit2Color == aboveLimit2Color && cachesbClusterChart[idx].BarColor == barColor && cachesbClusterChart[idx].BelowLimit1 == belowLimit1 && cachesbClusterChart[idx].BelowLimit1Color == belowLimit1Color && cachesbClusterChart[idx].BelowLimit2 == belowLimit2 && cachesbClusterChart[idx].BelowLimit2Color == belowLimit2Color && cachesbClusterChart[idx].ClusterFont == clusterFont && cachesbClusterChart[idx].DodgeBarColor == dodgeBarColor && cachesbClusterChart[idx].DownBarColor == downBarColor && cachesbClusterChart[idx].FillAboveClusters == fillAboveClusters && cachesbClusterChart[idx].FillBelowClusters == fillBelowClusters && cachesbClusterChart[idx].FillClusters == fillClusters && cachesbClusterChart[idx].FillMaxCluster == fillMaxCluster && cachesbClusterChart[idx].HiLowPen == hiLowPen && cachesbClusterChart[idx].HorisontalVolMargin == horisontalVolMargin && cachesbClusterChart[idx].HorisontalVolumeLimit == horisontalVolumeLimit && cachesbClusterChart[idx].HorisontalVolumeLimitColor == horisontalVolumeLimitColor && cachesbClusterChart[idx].HorVolColor == horVolColor && cachesbClusterChart[idx].maxTickVolBarColor == maxTickVolBarColor && cachesbClusterChart[idx].MaxVolumeLimit == maxVolumeLimit && cachesbClusterChart[idx].ShowBarFrame == showBarFrame && cachesbClusterChart[idx].ShowClusterCount == showClusterCount && cachesbClusterChart[idx].ShowDayHiLow == showDayHiLow && cachesbClusterChart[idx].ShowHorisontalVolume == showHorisontalVolume && cachesbClusterChart[idx].ShowHorisontalVolumeValue == showHorisontalVolumeValue && cachesbClusterChart[idx].ShowOpenClose == showOpenClose && cachesbClusterChart[idx].ShowTickVolume == showTickVolume && cachesbClusterChart[idx].ShowVerticalVolume == showVerticalVolume && cachesbClusterChart[idx].ShowVerticalVolumeValue == showVerticalVolumeValue && cachesbClusterChart[idx].TextColor == textColor && cachesbClusterChart[idx].TicksPerCluster == ticksPerCluster && cachesbClusterChart[idx].UpBarColor == upBarColor && cachesbClusterChart[idx].VerticalVolMargin == verticalVolMargin && cachesbClusterChart[idx].VerticalVolumeLimit == verticalVolumeLimit && cachesbClusterChart[idx].VerticalVolumeLimitColor == verticalVolumeLimitColor && cachesbClusterChart[idx].VertVolColor == vertVolColor && cachesbClusterChart[idx].VolumeRangeMax == volumeRangeMax && cachesbClusterChart[idx].VolumeRangeMin == volumeRangeMin && cachesbClusterChart[idx].EqualsInput(input))
                            return cachesbClusterChart[idx];

                sbClusterChart indicator = new sbClusterChart();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.AboveLimit1 = aboveLimit1;
                indicator.AboveLimit1Color = aboveLimit1Color;
                indicator.AboveLimit2 = aboveLimit2;
                indicator.AboveLimit2Color = aboveLimit2Color;
                indicator.BarColor = barColor;
                indicator.BelowLimit1 = belowLimit1;
                indicator.BelowLimit1Color = belowLimit1Color;
                indicator.BelowLimit2 = belowLimit2;
                indicator.BelowLimit2Color = belowLimit2Color;
                indicator.ClusterFont = clusterFont;
                indicator.DodgeBarColor = dodgeBarColor;
                indicator.DownBarColor = downBarColor;
                indicator.FillAboveClusters = fillAboveClusters;
                indicator.FillBelowClusters = fillBelowClusters;
                indicator.FillClusters = fillClusters;
                indicator.FillMaxCluster = fillMaxCluster;
                indicator.HiLowPen = hiLowPen;
                indicator.HorisontalVolMargin = horisontalVolMargin;
                indicator.HorisontalVolumeLimit = horisontalVolumeLimit;
                indicator.HorisontalVolumeLimitColor = horisontalVolumeLimitColor;
                indicator.HorVolColor = horVolColor;
                indicator.maxTickVolBarColor = maxTickVolBarColor;
                indicator.MaxVolumeLimit = maxVolumeLimit;
                indicator.ShowBarFrame = showBarFrame;
                indicator.ShowClusterCount = showClusterCount;
                indicator.ShowDayHiLow = showDayHiLow;
                indicator.ShowHorisontalVolume = showHorisontalVolume;
                indicator.ShowHorisontalVolumeValue = showHorisontalVolumeValue;
                indicator.ShowOpenClose = showOpenClose;
                indicator.ShowTickVolume = showTickVolume;
                indicator.ShowVerticalVolume = showVerticalVolume;
                indicator.ShowVerticalVolumeValue = showVerticalVolumeValue;
                indicator.TextColor = textColor;
                indicator.TicksPerCluster = ticksPerCluster;
                indicator.UpBarColor = upBarColor;
                indicator.VerticalVolMargin = verticalVolMargin;
                indicator.VerticalVolumeLimit = verticalVolumeLimit;
                indicator.VerticalVolumeLimitColor = verticalVolumeLimitColor;
                indicator.VertVolColor = vertVolColor;
                indicator.VolumeRangeMax = volumeRangeMax;
                indicator.VolumeRangeMin = volumeRangeMin;
                Indicators.Add(indicator);
                indicator.SetUp();

                sbClusterChart[] tmp = new sbClusterChart[cachesbClusterChart == null ? 1 : cachesbClusterChart.Length + 1];
                if (cachesbClusterChart != null)
                    cachesbClusterChart.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachesbClusterChart = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Cluster Chart by Anton Bazhenov\nhttp://protradestudio.ru
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.sbClusterChart sbClusterChart(long aboveLimit1, Color aboveLimit1Color, long aboveLimit2, Color aboveLimit2Color, Color barColor, long belowLimit1, Color belowLimit1Color, long belowLimit2, Color belowLimit2Color, Font clusterFont, Color dodgeBarColor, Color downBarColor, bool fillAboveClusters, bool fillBelowClusters, bool fillClusters, bool fillMaxCluster, Pen hiLowPen, int horisontalVolMargin, long horisontalVolumeLimit, Color horisontalVolumeLimitColor, Color horVolColor, Color maxTickVolBarColor, long maxVolumeLimit, bool showBarFrame, bool showClusterCount, bool showDayHiLow, bool showHorisontalVolume, bool showHorisontalVolumeValue, bool showOpenClose, bool showTickVolume, bool showVerticalVolume, bool showVerticalVolumeValue, Color textColor, int ticksPerCluster, Color upBarColor, int verticalVolMargin, long verticalVolumeLimit, Color verticalVolumeLimitColor, Color vertVolColor, long volumeRangeMax, long volumeRangeMin)
        {
            return _indicator.sbClusterChart(Input, aboveLimit1, aboveLimit1Color, aboveLimit2, aboveLimit2Color, barColor, belowLimit1, belowLimit1Color, belowLimit2, belowLimit2Color, clusterFont, dodgeBarColor, downBarColor, fillAboveClusters, fillBelowClusters, fillClusters, fillMaxCluster, hiLowPen, horisontalVolMargin, horisontalVolumeLimit, horisontalVolumeLimitColor, horVolColor, maxTickVolBarColor, maxVolumeLimit, showBarFrame, showClusterCount, showDayHiLow, showHorisontalVolume, showHorisontalVolumeValue, showOpenClose, showTickVolume, showVerticalVolume, showVerticalVolumeValue, textColor, ticksPerCluster, upBarColor, verticalVolMargin, verticalVolumeLimit, verticalVolumeLimitColor, vertVolColor, volumeRangeMax, volumeRangeMin);
        }

        /// <summary>
        /// Cluster Chart by Anton Bazhenov\nhttp://protradestudio.ru
        /// </summary>
        /// <returns></returns>
        public Indicator.sbClusterChart sbClusterChart(Data.IDataSeries input, long aboveLimit1, Color aboveLimit1Color, long aboveLimit2, Color aboveLimit2Color, Color barColor, long belowLimit1, Color belowLimit1Color, long belowLimit2, Color belowLimit2Color, Font clusterFont, Color dodgeBarColor, Color downBarColor, bool fillAboveClusters, bool fillBelowClusters, bool fillClusters, bool fillMaxCluster, Pen hiLowPen, int horisontalVolMargin, long horisontalVolumeLimit, Color horisontalVolumeLimitColor, Color horVolColor, Color maxTickVolBarColor, long maxVolumeLimit, bool showBarFrame, bool showClusterCount, bool showDayHiLow, bool showHorisontalVolume, bool showHorisontalVolumeValue, bool showOpenClose, bool showTickVolume, bool showVerticalVolume, bool showVerticalVolumeValue, Color textColor, int ticksPerCluster, Color upBarColor, int verticalVolMargin, long verticalVolumeLimit, Color verticalVolumeLimitColor, Color vertVolColor, long volumeRangeMax, long volumeRangeMin)
        {
            return _indicator.sbClusterChart(input, aboveLimit1, aboveLimit1Color, aboveLimit2, aboveLimit2Color, barColor, belowLimit1, belowLimit1Color, belowLimit2, belowLimit2Color, clusterFont, dodgeBarColor, downBarColor, fillAboveClusters, fillBelowClusters, fillClusters, fillMaxCluster, hiLowPen, horisontalVolMargin, horisontalVolumeLimit, horisontalVolumeLimitColor, horVolColor, maxTickVolBarColor, maxVolumeLimit, showBarFrame, showClusterCount, showDayHiLow, showHorisontalVolume, showHorisontalVolumeValue, showOpenClose, showTickVolume, showVerticalVolume, showVerticalVolumeValue, textColor, ticksPerCluster, upBarColor, verticalVolMargin, verticalVolumeLimit, verticalVolumeLimitColor, vertVolColor, volumeRangeMax, volumeRangeMin);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Cluster Chart by Anton Bazhenov\nhttp://protradestudio.ru
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.sbClusterChart sbClusterChart(long aboveLimit1, Color aboveLimit1Color, long aboveLimit2, Color aboveLimit2Color, Color barColor, long belowLimit1, Color belowLimit1Color, long belowLimit2, Color belowLimit2Color, Font clusterFont, Color dodgeBarColor, Color downBarColor, bool fillAboveClusters, bool fillBelowClusters, bool fillClusters, bool fillMaxCluster, Pen hiLowPen, int horisontalVolMargin, long horisontalVolumeLimit, Color horisontalVolumeLimitColor, Color horVolColor, Color maxTickVolBarColor, long maxVolumeLimit, bool showBarFrame, bool showClusterCount, bool showDayHiLow, bool showHorisontalVolume, bool showHorisontalVolumeValue, bool showOpenClose, bool showTickVolume, bool showVerticalVolume, bool showVerticalVolumeValue, Color textColor, int ticksPerCluster, Color upBarColor, int verticalVolMargin, long verticalVolumeLimit, Color verticalVolumeLimitColor, Color vertVolColor, long volumeRangeMax, long volumeRangeMin)
        {
            return _indicator.sbClusterChart(Input, aboveLimit1, aboveLimit1Color, aboveLimit2, aboveLimit2Color, barColor, belowLimit1, belowLimit1Color, belowLimit2, belowLimit2Color, clusterFont, dodgeBarColor, downBarColor, fillAboveClusters, fillBelowClusters, fillClusters, fillMaxCluster, hiLowPen, horisontalVolMargin, horisontalVolumeLimit, horisontalVolumeLimitColor, horVolColor, maxTickVolBarColor, maxVolumeLimit, showBarFrame, showClusterCount, showDayHiLow, showHorisontalVolume, showHorisontalVolumeValue, showOpenClose, showTickVolume, showVerticalVolume, showVerticalVolumeValue, textColor, ticksPerCluster, upBarColor, verticalVolMargin, verticalVolumeLimit, verticalVolumeLimitColor, vertVolColor, volumeRangeMax, volumeRangeMin);
        }

        /// <summary>
        /// Cluster Chart by Anton Bazhenov\nhttp://protradestudio.ru
        /// </summary>
        /// <returns></returns>
        public Indicator.sbClusterChart sbClusterChart(Data.IDataSeries input, long aboveLimit1, Color aboveLimit1Color, long aboveLimit2, Color aboveLimit2Color, Color barColor, long belowLimit1, Color belowLimit1Color, long belowLimit2, Color belowLimit2Color, Font clusterFont, Color dodgeBarColor, Color downBarColor, bool fillAboveClusters, bool fillBelowClusters, bool fillClusters, bool fillMaxCluster, Pen hiLowPen, int horisontalVolMargin, long horisontalVolumeLimit, Color horisontalVolumeLimitColor, Color horVolColor, Color maxTickVolBarColor, long maxVolumeLimit, bool showBarFrame, bool showClusterCount, bool showDayHiLow, bool showHorisontalVolume, bool showHorisontalVolumeValue, bool showOpenClose, bool showTickVolume, bool showVerticalVolume, bool showVerticalVolumeValue, Color textColor, int ticksPerCluster, Color upBarColor, int verticalVolMargin, long verticalVolumeLimit, Color verticalVolumeLimitColor, Color vertVolColor, long volumeRangeMax, long volumeRangeMin)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.sbClusterChart(input, aboveLimit1, aboveLimit1Color, aboveLimit2, aboveLimit2Color, barColor, belowLimit1, belowLimit1Color, belowLimit2, belowLimit2Color, clusterFont, dodgeBarColor, downBarColor, fillAboveClusters, fillBelowClusters, fillClusters, fillMaxCluster, hiLowPen, horisontalVolMargin, horisontalVolumeLimit, horisontalVolumeLimitColor, horVolColor, maxTickVolBarColor, maxVolumeLimit, showBarFrame, showClusterCount, showDayHiLow, showHorisontalVolume, showHorisontalVolumeValue, showOpenClose, showTickVolume, showVerticalVolume, showVerticalVolumeValue, textColor, ticksPerCluster, upBarColor, verticalVolMargin, verticalVolumeLimit, verticalVolumeLimitColor, vertVolColor, volumeRangeMax, volumeRangeMin);
        }
    }
}
#endregion
