//
// Copyright (C) 2006, NinjaTrader LLC <ninjatrader@ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private sbClusterVolume[] cachesbClusterVolume = null;

        private static sbClusterVolume checksbClusterVolume = new sbClusterVolume();

        /// <summary>
        /// Cluster Volume by Anton Bazhenov\nhttp://protradestudio.ru
        /// </summary>
        /// <returns></returns>
        public sbClusterVolume sbClusterVolume(long aboveLimit1, Color aboveLimit1Color, long aboveLimit2, Color aboveLimit2Color, Color barColor, long belowLimit1, Color belowLimit1Color, long belowLimit2, Color belowLimit2Color, Font clusterFont, Color dodgeBarColor, Color downBarColor, Pen hiLowPen, int horisontalVolMargin, long horisontalVolumeLimit, Color horisontalVolumeLimitColor, Color horVolColor, Color maxTickVolBarColor, bool showDayHiLow, bool showHorisontalVolume, bool showHorisontalVolumeValue, bool showOpenClose, bool showTickVolume, bool showVerticalVolume, bool showVerticalVolumeValue, Color textColor, int ticksPerCluster, Color upBarColor, int verticalVolMargin, long verticalVolumeLimit, Color verticalVolumeLimitColor, Color vertVolColor, long volumeRangeMax, long volumeRangeMin)
        {
            return sbClusterVolume(Input, aboveLimit1, aboveLimit1Color, aboveLimit2, aboveLimit2Color, barColor, belowLimit1, belowLimit1Color, belowLimit2, belowLimit2Color, clusterFont, dodgeBarColor, downBarColor, hiLowPen, horisontalVolMargin, horisontalVolumeLimit, horisontalVolumeLimitColor, horVolColor, maxTickVolBarColor, showDayHiLow, showHorisontalVolume, showHorisontalVolumeValue, showOpenClose, showTickVolume, showVerticalVolume, showVerticalVolumeValue, textColor, ticksPerCluster, upBarColor, verticalVolMargin, verticalVolumeLimit, verticalVolumeLimitColor, vertVolColor, volumeRangeMax, volumeRangeMin);
        }

        /// <summary>
        /// Cluster Volume by Anton Bazhenov\nhttp://protradestudio.ru
        /// </summary>
        /// <returns></returns>
        public sbClusterVolume sbClusterVolume(Data.IDataSeries input, long aboveLimit1, Color aboveLimit1Color, long aboveLimit2, Color aboveLimit2Color, Color barColor, long belowLimit1, Color belowLimit1Color, long belowLimit2, Color belowLimit2Color, Font clusterFont, Color dodgeBarColor, Color downBarColor, Pen hiLowPen, int horisontalVolMargin, long horisontalVolumeLimit, Color horisontalVolumeLimitColor, Color horVolColor, Color maxTickVolBarColor, bool showDayHiLow, bool showHorisontalVolume, bool showHorisontalVolumeValue, bool showOpenClose, bool showTickVolume, bool showVerticalVolume, bool showVerticalVolumeValue, Color textColor, int ticksPerCluster, Color upBarColor, int verticalVolMargin, long verticalVolumeLimit, Color verticalVolumeLimitColor, Color vertVolColor, long volumeRangeMax, long volumeRangeMin)
        {
            if (cachesbClusterVolume != null)
                for (int idx = 0; idx < cachesbClusterVolume.Length; idx++)
                    if (cachesbClusterVolume[idx].AboveLimit1 == aboveLimit1 && cachesbClusterVolume[idx].AboveLimit1Color == aboveLimit1Color && cachesbClusterVolume[idx].AboveLimit2 == aboveLimit2 && cachesbClusterVolume[idx].AboveLimit2Color == aboveLimit2Color && cachesbClusterVolume[idx].BarColor == barColor && cachesbClusterVolume[idx].BelowLimit1 == belowLimit1 && cachesbClusterVolume[idx].BelowLimit1Color == belowLimit1Color && cachesbClusterVolume[idx].BelowLimit2 == belowLimit2 && cachesbClusterVolume[idx].BelowLimit2Color == belowLimit2Color && cachesbClusterVolume[idx].ClusterFont == clusterFont && cachesbClusterVolume[idx].DodgeBarColor == dodgeBarColor && cachesbClusterVolume[idx].DownBarColor == downBarColor && cachesbClusterVolume[idx].HiLowPen == hiLowPen && cachesbClusterVolume[idx].HorisontalVolMargin == horisontalVolMargin && cachesbClusterVolume[idx].HorisontalVolumeLimit == horisontalVolumeLimit && cachesbClusterVolume[idx].HorisontalVolumeLimitColor == horisontalVolumeLimitColor && cachesbClusterVolume[idx].HorVolColor == horVolColor && cachesbClusterVolume[idx].maxTickVolBarColor == maxTickVolBarColor && cachesbClusterVolume[idx].ShowDayHiLow == showDayHiLow && cachesbClusterVolume[idx].ShowHorisontalVolume == showHorisontalVolume && cachesbClusterVolume[idx].ShowHorisontalVolumeValue == showHorisontalVolumeValue && cachesbClusterVolume[idx].ShowOpenClose == showOpenClose && cachesbClusterVolume[idx].ShowTickVolume == showTickVolume && cachesbClusterVolume[idx].ShowVerticalVolume == showVerticalVolume && cachesbClusterVolume[idx].ShowVerticalVolumeValue == showVerticalVolumeValue && cachesbClusterVolume[idx].TextColor == textColor && cachesbClusterVolume[idx].TicksPerCluster == ticksPerCluster && cachesbClusterVolume[idx].UpBarColor == upBarColor && cachesbClusterVolume[idx].VerticalVolMargin == verticalVolMargin && cachesbClusterVolume[idx].VerticalVolumeLimit == verticalVolumeLimit && cachesbClusterVolume[idx].VerticalVolumeLimitColor == verticalVolumeLimitColor && cachesbClusterVolume[idx].VertVolColor == vertVolColor && cachesbClusterVolume[idx].VolumeRangeMax == volumeRangeMax && cachesbClusterVolume[idx].VolumeRangeMin == volumeRangeMin && cachesbClusterVolume[idx].EqualsInput(input))
                        return cachesbClusterVolume[idx];

            lock (checksbClusterVolume)
            {
                checksbClusterVolume.AboveLimit1 = aboveLimit1;
                aboveLimit1 = checksbClusterVolume.AboveLimit1;
                checksbClusterVolume.AboveLimit1Color = aboveLimit1Color;
                aboveLimit1Color = checksbClusterVolume.AboveLimit1Color;
                checksbClusterVolume.AboveLimit2 = aboveLimit2;
                aboveLimit2 = checksbClusterVolume.AboveLimit2;
                checksbClusterVolume.AboveLimit2Color = aboveLimit2Color;
                aboveLimit2Color = checksbClusterVolume.AboveLimit2Color;
                checksbClusterVolume.BarColor = barColor;
                barColor = checksbClusterVolume.BarColor;
                checksbClusterVolume.BelowLimit1 = belowLimit1;
                belowLimit1 = checksbClusterVolume.BelowLimit1;
                checksbClusterVolume.BelowLimit1Color = belowLimit1Color;
                belowLimit1Color = checksbClusterVolume.BelowLimit1Color;
                checksbClusterVolume.BelowLimit2 = belowLimit2;
                belowLimit2 = checksbClusterVolume.BelowLimit2;
                checksbClusterVolume.BelowLimit2Color = belowLimit2Color;
                belowLimit2Color = checksbClusterVolume.BelowLimit2Color;
                checksbClusterVolume.ClusterFont = clusterFont;
                clusterFont = checksbClusterVolume.ClusterFont;
                checksbClusterVolume.DodgeBarColor = dodgeBarColor;
                dodgeBarColor = checksbClusterVolume.DodgeBarColor;
                checksbClusterVolume.DownBarColor = downBarColor;
                downBarColor = checksbClusterVolume.DownBarColor;
                checksbClusterVolume.HiLowPen = hiLowPen;
                hiLowPen = checksbClusterVolume.HiLowPen;
                checksbClusterVolume.HorisontalVolMargin = horisontalVolMargin;
                horisontalVolMargin = checksbClusterVolume.HorisontalVolMargin;
                checksbClusterVolume.HorisontalVolumeLimit = horisontalVolumeLimit;
                horisontalVolumeLimit = checksbClusterVolume.HorisontalVolumeLimit;
                checksbClusterVolume.HorisontalVolumeLimitColor = horisontalVolumeLimitColor;
                horisontalVolumeLimitColor = checksbClusterVolume.HorisontalVolumeLimitColor;
                checksbClusterVolume.HorVolColor = horVolColor;
                horVolColor = checksbClusterVolume.HorVolColor;
                checksbClusterVolume.maxTickVolBarColor = maxTickVolBarColor;
                maxTickVolBarColor = checksbClusterVolume.maxTickVolBarColor;
                checksbClusterVolume.ShowDayHiLow = showDayHiLow;
                showDayHiLow = checksbClusterVolume.ShowDayHiLow;
                checksbClusterVolume.ShowHorisontalVolume = showHorisontalVolume;
                showHorisontalVolume = checksbClusterVolume.ShowHorisontalVolume;
                checksbClusterVolume.ShowHorisontalVolumeValue = showHorisontalVolumeValue;
                showHorisontalVolumeValue = checksbClusterVolume.ShowHorisontalVolumeValue;
                checksbClusterVolume.ShowOpenClose = showOpenClose;
                showOpenClose = checksbClusterVolume.ShowOpenClose;
                checksbClusterVolume.ShowTickVolume = showTickVolume;
                showTickVolume = checksbClusterVolume.ShowTickVolume;
                checksbClusterVolume.ShowVerticalVolume = showVerticalVolume;
                showVerticalVolume = checksbClusterVolume.ShowVerticalVolume;
                checksbClusterVolume.ShowVerticalVolumeValue = showVerticalVolumeValue;
                showVerticalVolumeValue = checksbClusterVolume.ShowVerticalVolumeValue;
                checksbClusterVolume.TextColor = textColor;
                textColor = checksbClusterVolume.TextColor;
                checksbClusterVolume.TicksPerCluster = ticksPerCluster;
                ticksPerCluster = checksbClusterVolume.TicksPerCluster;
                checksbClusterVolume.UpBarColor = upBarColor;
                upBarColor = checksbClusterVolume.UpBarColor;
                checksbClusterVolume.VerticalVolMargin = verticalVolMargin;
                verticalVolMargin = checksbClusterVolume.VerticalVolMargin;
                checksbClusterVolume.VerticalVolumeLimit = verticalVolumeLimit;
                verticalVolumeLimit = checksbClusterVolume.VerticalVolumeLimit;
                checksbClusterVolume.VerticalVolumeLimitColor = verticalVolumeLimitColor;
                verticalVolumeLimitColor = checksbClusterVolume.VerticalVolumeLimitColor;
                checksbClusterVolume.VertVolColor = vertVolColor;
                vertVolColor = checksbClusterVolume.VertVolColor;
                checksbClusterVolume.VolumeRangeMax = volumeRangeMax;
                volumeRangeMax = checksbClusterVolume.VolumeRangeMax;
                checksbClusterVolume.VolumeRangeMin = volumeRangeMin;
                volumeRangeMin = checksbClusterVolume.VolumeRangeMin;

                if (cachesbClusterVolume != null)
                    for (int idx = 0; idx < cachesbClusterVolume.Length; idx++)
                        if (cachesbClusterVolume[idx].AboveLimit1 == aboveLimit1 && cachesbClusterVolume[idx].AboveLimit1Color == aboveLimit1Color && cachesbClusterVolume[idx].AboveLimit2 == aboveLimit2 && cachesbClusterVolume[idx].AboveLimit2Color == aboveLimit2Color && cachesbClusterVolume[idx].BarColor == barColor && cachesbClusterVolume[idx].BelowLimit1 == belowLimit1 && cachesbClusterVolume[idx].BelowLimit1Color == belowLimit1Color && cachesbClusterVolume[idx].BelowLimit2 == belowLimit2 && cachesbClusterVolume[idx].BelowLimit2Color == belowLimit2Color && cachesbClusterVolume[idx].ClusterFont == clusterFont && cachesbClusterVolume[idx].DodgeBarColor == dodgeBarColor && cachesbClusterVolume[idx].DownBarColor == downBarColor && cachesbClusterVolume[idx].HiLowPen == hiLowPen && cachesbClusterVolume[idx].HorisontalVolMargin == horisontalVolMargin && cachesbClusterVolume[idx].HorisontalVolumeLimit == horisontalVolumeLimit && cachesbClusterVolume[idx].HorisontalVolumeLimitColor == horisontalVolumeLimitColor && cachesbClusterVolume[idx].HorVolColor == horVolColor && cachesbClusterVolume[idx].maxTickVolBarColor == maxTickVolBarColor && cachesbClusterVolume[idx].ShowDayHiLow == showDayHiLow && cachesbClusterVolume[idx].ShowHorisontalVolume == showHorisontalVolume && cachesbClusterVolume[idx].ShowHorisontalVolumeValue == showHorisontalVolumeValue && cachesbClusterVolume[idx].ShowOpenClose == showOpenClose && cachesbClusterVolume[idx].ShowTickVolume == showTickVolume && cachesbClusterVolume[idx].ShowVerticalVolume == showVerticalVolume && cachesbClusterVolume[idx].ShowVerticalVolumeValue == showVerticalVolumeValue && cachesbClusterVolume[idx].TextColor == textColor && cachesbClusterVolume[idx].TicksPerCluster == ticksPerCluster && cachesbClusterVolume[idx].UpBarColor == upBarColor && cachesbClusterVolume[idx].VerticalVolMargin == verticalVolMargin && cachesbClusterVolume[idx].VerticalVolumeLimit == verticalVolumeLimit && cachesbClusterVolume[idx].VerticalVolumeLimitColor == verticalVolumeLimitColor && cachesbClusterVolume[idx].VertVolColor == vertVolColor && cachesbClusterVolume[idx].VolumeRangeMax == volumeRangeMax && cachesbClusterVolume[idx].VolumeRangeMin == volumeRangeMin && cachesbClusterVolume[idx].EqualsInput(input))
                            return cachesbClusterVolume[idx];

                sbClusterVolume indicator = new sbClusterVolume();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.AboveLimit1 = aboveLimit1;
                indicator.AboveLimit1Color = aboveLimit1Color;
                indicator.AboveLimit2 = aboveLimit2;
                indicator.AboveLimit2Color = aboveLimit2Color;
                indicator.BarColor = barColor;
                indicator.BelowLimit1 = belowLimit1;
                indicator.BelowLimit1Color = belowLimit1Color;
                indicator.BelowLimit2 = belowLimit2;
                indicator.BelowLimit2Color = belowLimit2Color;
                indicator.ClusterFont = clusterFont;
                indicator.DodgeBarColor = dodgeBarColor;
                indicator.DownBarColor = downBarColor;
                indicator.HiLowPen = hiLowPen;
                indicator.HorisontalVolMargin = horisontalVolMargin;
                indicator.HorisontalVolumeLimit = horisontalVolumeLimit;
                indicator.HorisontalVolumeLimitColor = horisontalVolumeLimitColor;
                indicator.HorVolColor = horVolColor;
                indicator.maxTickVolBarColor = maxTickVolBarColor;
                indicator.ShowDayHiLow = showDayHiLow;
                indicator.ShowHorisontalVolume = showHorisontalVolume;
                indicator.ShowHorisontalVolumeValue = showHorisontalVolumeValue;
                indicator.ShowOpenClose = showOpenClose;
                indicator.ShowTickVolume = showTickVolume;
                indicator.ShowVerticalVolume = showVerticalVolume;
                indicator.ShowVerticalVolumeValue = showVerticalVolumeValue;
                indicator.TextColor = textColor;
                indicator.TicksPerCluster = ticksPerCluster;
                indicator.UpBarColor = upBarColor;
                indicator.VerticalVolMargin = verticalVolMargin;
                indicator.VerticalVolumeLimit = verticalVolumeLimit;
                indicator.VerticalVolumeLimitColor = verticalVolumeLimitColor;
                indicator.VertVolColor = vertVolColor;
                indicator.VolumeRangeMax = volumeRangeMax;
                indicator.VolumeRangeMin = volumeRangeMin;
                Indicators.Add(indicator);
                indicator.SetUp();

                sbClusterVolume[] tmp = new sbClusterVolume[cachesbClusterVolume == null ? 1 : cachesbClusterVolume.Length + 1];
                if (cachesbClusterVolume != null)
                    cachesbClusterVolume.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachesbClusterVolume = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Cluster Volume by Anton Bazhenov\nhttp://protradestudio.ru
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.sbClusterVolume sbClusterVolume(long aboveLimit1, Color aboveLimit1Color, long aboveLimit2, Color aboveLimit2Color, Color barColor, long belowLimit1, Color belowLimit1Color, long belowLimit2, Color belowLimit2Color, Font clusterFont, Color dodgeBarColor, Color downBarColor, Pen hiLowPen, int horisontalVolMargin, long horisontalVolumeLimit, Color horisontalVolumeLimitColor, Color horVolColor, Color maxTickVolBarColor, bool showDayHiLow, bool showHorisontalVolume, bool showHorisontalVolumeValue, bool showOpenClose, bool showTickVolume, bool showVerticalVolume, bool showVerticalVolumeValue, Color textColor, int ticksPerCluster, Color upBarColor, int verticalVolMargin, long verticalVolumeLimit, Color verticalVolumeLimitColor, Color vertVolColor, long volumeRangeMax, long volumeRangeMin)
        {
            return _indicator.sbClusterVolume(Input, aboveLimit1, aboveLimit1Color, aboveLimit2, aboveLimit2Color, barColor, belowLimit1, belowLimit1Color, belowLimit2, belowLimit2Color, clusterFont, dodgeBarColor, downBarColor, hiLowPen, horisontalVolMargin, horisontalVolumeLimit, horisontalVolumeLimitColor, horVolColor, maxTickVolBarColor, showDayHiLow, showHorisontalVolume, showHorisontalVolumeValue, showOpenClose, showTickVolume, showVerticalVolume, showVerticalVolumeValue, textColor, ticksPerCluster, upBarColor, verticalVolMargin, verticalVolumeLimit, verticalVolumeLimitColor, vertVolColor, volumeRangeMax, volumeRangeMin);
        }

        /// <summary>
        /// Cluster Volume by Anton Bazhenov\nhttp://protradestudio.ru
        /// </summary>
        /// <returns></returns>
        public Indicator.sbClusterVolume sbClusterVolume(Data.IDataSeries input, long aboveLimit1, Color aboveLimit1Color, long aboveLimit2, Color aboveLimit2Color, Color barColor, long belowLimit1, Color belowLimit1Color, long belowLimit2, Color belowLimit2Color, Font clusterFont, Color dodgeBarColor, Color downBarColor, Pen hiLowPen, int horisontalVolMargin, long horisontalVolumeLimit, Color horisontalVolumeLimitColor, Color horVolColor, Color maxTickVolBarColor, bool showDayHiLow, bool showHorisontalVolume, bool showHorisontalVolumeValue, bool showOpenClose, bool showTickVolume, bool showVerticalVolume, bool showVerticalVolumeValue, Color textColor, int ticksPerCluster, Color upBarColor, int verticalVolMargin, long verticalVolumeLimit, Color verticalVolumeLimitColor, Color vertVolColor, long volumeRangeMax, long volumeRangeMin)
        {
            return _indicator.sbClusterVolume(input, aboveLimit1, aboveLimit1Color, aboveLimit2, aboveLimit2Color, barColor, belowLimit1, belowLimit1Color, belowLimit2, belowLimit2Color, clusterFont, dodgeBarColor, downBarColor, hiLowPen, horisontalVolMargin, horisontalVolumeLimit, horisontalVolumeLimitColor, horVolColor, maxTickVolBarColor, showDayHiLow, showHorisontalVolume, showHorisontalVolumeValue, showOpenClose, showTickVolume, showVerticalVolume, showVerticalVolumeValue, textColor, ticksPerCluster, upBarColor, verticalVolMargin, verticalVolumeLimit, verticalVolumeLimitColor, vertVolColor, volumeRangeMax, volumeRangeMin);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Cluster Volume by Anton Bazhenov\nhttp://protradestudio.ru
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.sbClusterVolume sbClusterVolume(long aboveLimit1, Color aboveLimit1Color, long aboveLimit2, Color aboveLimit2Color, Color barColor, long belowLimit1, Color belowLimit1Color, long belowLimit2, Color belowLimit2Color, Font clusterFont, Color dodgeBarColor, Color downBarColor, Pen hiLowPen, int horisontalVolMargin, long horisontalVolumeLimit, Color horisontalVolumeLimitColor, Color horVolColor, Color maxTickVolBarColor, bool showDayHiLow, bool showHorisontalVolume, bool showHorisontalVolumeValue, bool showOpenClose, bool showTickVolume, bool showVerticalVolume, bool showVerticalVolumeValue, Color textColor, int ticksPerCluster, Color upBarColor, int verticalVolMargin, long verticalVolumeLimit, Color verticalVolumeLimitColor, Color vertVolColor, long volumeRangeMax, long volumeRangeMin)
        {
            return _indicator.sbClusterVolume(Input, aboveLimit1, aboveLimit1Color, aboveLimit2, aboveLimit2Color, barColor, belowLimit1, belowLimit1Color, belowLimit2, belowLimit2Color, clusterFont, dodgeBarColor, downBarColor, hiLowPen, horisontalVolMargin, horisontalVolumeLimit, horisontalVolumeLimitColor, horVolColor, maxTickVolBarColor, showDayHiLow, showHorisontalVolume, showHorisontalVolumeValue, showOpenClose, showTickVolume, showVerticalVolume, showVerticalVolumeValue, textColor, ticksPerCluster, upBarColor, verticalVolMargin, verticalVolumeLimit, verticalVolumeLimitColor, vertVolColor, volumeRangeMax, volumeRangeMin);
        }

        /// <summary>
        /// Cluster Volume by Anton Bazhenov\nhttp://protradestudio.ru
        /// </summary>
        /// <returns></returns>
        public Indicator.sbClusterVolume sbClusterVolume(Data.IDataSeries input, long aboveLimit1, Color aboveLimit1Color, long aboveLimit2, Color aboveLimit2Color, Color barColor, long belowLimit1, Color belowLimit1Color, long belowLimit2, Color belowLimit2Color, Font clusterFont, Color dodgeBarColor, Color downBarColor, Pen hiLowPen, int horisontalVolMargin, long horisontalVolumeLimit, Color horisontalVolumeLimitColor, Color horVolColor, Color maxTickVolBarColor, bool showDayHiLow, bool showHorisontalVolume, bool showHorisontalVolumeValue, bool showOpenClose, bool showTickVolume, bool showVerticalVolume, bool showVerticalVolumeValue, Color textColor, int ticksPerCluster, Color upBarColor, int verticalVolMargin, long verticalVolumeLimit, Color verticalVolumeLimitColor, Color vertVolColor, long volumeRangeMax, long volumeRangeMin)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.sbClusterVolume(input, aboveLimit1, aboveLimit1Color, aboveLimit2, aboveLimit2Color, barColor, belowLimit1, belowLimit1Color, belowLimit2, belowLimit2Color, clusterFont, dodgeBarColor, downBarColor, hiLowPen, horisontalVolMargin, horisontalVolumeLimit, horisontalVolumeLimitColor, horVolColor, maxTickVolBarColor, showDayHiLow, showHorisontalVolume, showHorisontalVolumeValue, showOpenClose, showTickVolume, showVerticalVolume, showVerticalVolumeValue, textColor, ticksPerCluster, upBarColor, verticalVolMargin, verticalVolumeLimit, verticalVolumeLimitColor, vertVolColor, volumeRangeMax, volumeRangeMin);
        }
    }
}
#endregion
