//
// Copyright (C) 2006, NinjaTrader LLC <ninjatrader@ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private sbPriceLine[] cachesbPriceLine = null;

        private static sbPriceLine checksbPriceLine = new sbPriceLine();

        /// <summary>
        /// Price Line  by Anton Bazhenov\nhttp://protradestudio.ru
        /// </summary>
        /// <returns></returns>
        public sbPriceLine sbPriceLine()
        {
            return sbPriceLine(Input);
        }

        /// <summary>
        /// Price Line  by Anton Bazhenov\nhttp://protradestudio.ru
        /// </summary>
        /// <returns></returns>
        public sbPriceLine sbPriceLine(Data.IDataSeries input)
        {
            if (cachesbPriceLine != null)
                for (int idx = 0; idx < cachesbPriceLine.Length; idx++)
                    if (cachesbPriceLine[idx].EqualsInput(input))
                        return cachesbPriceLine[idx];

            lock (checksbPriceLine)
            {
                if (cachesbPriceLine != null)
                    for (int idx = 0; idx < cachesbPriceLine.Length; idx++)
                        if (cachesbPriceLine[idx].EqualsInput(input))
                            return cachesbPriceLine[idx];

                sbPriceLine indicator = new sbPriceLine();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                Indicators.Add(indicator);
                indicator.SetUp();

                sbPriceLine[] tmp = new sbPriceLine[cachesbPriceLine == null ? 1 : cachesbPriceLine.Length + 1];
                if (cachesbPriceLine != null)
                    cachesbPriceLine.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachesbPriceLine = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Price Line  by Anton Bazhenov\nhttp://protradestudio.ru
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.sbPriceLine sbPriceLine()
        {
            return _indicator.sbPriceLine(Input);
        }

        /// <summary>
        /// Price Line  by Anton Bazhenov\nhttp://protradestudio.ru
        /// </summary>
        /// <returns></returns>
        public Indicator.sbPriceLine sbPriceLine(Data.IDataSeries input)
        {
            return _indicator.sbPriceLine(input);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Price Line  by Anton Bazhenov\nhttp://protradestudio.ru
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.sbPriceLine sbPriceLine()
        {
            return _indicator.sbPriceLine(Input);
        }

        /// <summary>
        /// Price Line  by Anton Bazhenov\nhttp://protradestudio.ru
        /// </summary>
        /// <returns></returns>
        public Indicator.sbPriceLine sbPriceLine(Data.IDataSeries input)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.sbPriceLine(input);
        }
    }
}
#endregion
