//
// Copyright (C) 2006, NinjaTrader LLC <ninjatrader@ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private sbPriceMarker[] cachesbPriceMarker = null;

        private static sbPriceMarker checksbPriceMarker = new sbPriceMarker();

        /// <summary>
        /// Price Marker  by Anton Bazhenov\nhttp://protradestudio.ru
        /// </summary>
        /// <returns></returns>
        public sbPriceMarker sbPriceMarker()
        {
            return sbPriceMarker(Input);
        }

        /// <summary>
        /// Price Marker  by Anton Bazhenov\nhttp://protradestudio.ru
        /// </summary>
        /// <returns></returns>
        public sbPriceMarker sbPriceMarker(Data.IDataSeries input)
        {
            if (cachesbPriceMarker != null)
                for (int idx = 0; idx < cachesbPriceMarker.Length; idx++)
                    if (cachesbPriceMarker[idx].EqualsInput(input))
                        return cachesbPriceMarker[idx];

            lock (checksbPriceMarker)
            {
                if (cachesbPriceMarker != null)
                    for (int idx = 0; idx < cachesbPriceMarker.Length; idx++)
                        if (cachesbPriceMarker[idx].EqualsInput(input))
                            return cachesbPriceMarker[idx];

                sbPriceMarker indicator = new sbPriceMarker();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                Indicators.Add(indicator);
                indicator.SetUp();

                sbPriceMarker[] tmp = new sbPriceMarker[cachesbPriceMarker == null ? 1 : cachesbPriceMarker.Length + 1];
                if (cachesbPriceMarker != null)
                    cachesbPriceMarker.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachesbPriceMarker = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Price Marker  by Anton Bazhenov\nhttp://protradestudio.ru
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.sbPriceMarker sbPriceMarker()
        {
            return _indicator.sbPriceMarker(Input);
        }

        /// <summary>
        /// Price Marker  by Anton Bazhenov\nhttp://protradestudio.ru
        /// </summary>
        /// <returns></returns>
        public Indicator.sbPriceMarker sbPriceMarker(Data.IDataSeries input)
        {
            return _indicator.sbPriceMarker(input);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Price Marker  by Anton Bazhenov\nhttp://protradestudio.ru
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.sbPriceMarker sbPriceMarker()
        {
            return _indicator.sbPriceMarker(Input);
        }

        /// <summary>
        /// Price Marker  by Anton Bazhenov\nhttp://protradestudio.ru
        /// </summary>
        /// <returns></returns>
        public Indicator.sbPriceMarker sbPriceMarker(Data.IDataSeries input)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.sbPriceMarker(input);
        }
    }
}
#endregion
