//
// Copyright (C) 2006, NinjaTrader LLC <ninjatrader@ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private sbSessionsBackGround[] cachesbSessionsBackGround = null;

        private static sbSessionsBackGround checksbSessionsBackGround = new sbSessionsBackGround();

        /// <summary>
        /// Sessions Background by Anton Bazhenov \nhttp://protradestudio.ru
        /// </summary>
        /// <returns></returns>
        public sbSessionsBackGround sbSessionsBackGround()
        {
            return sbSessionsBackGround(Input);
        }

        /// <summary>
        /// Sessions Background by Anton Bazhenov \nhttp://protradestudio.ru
        /// </summary>
        /// <returns></returns>
        public sbSessionsBackGround sbSessionsBackGround(Data.IDataSeries input)
        {
            if (cachesbSessionsBackGround != null)
                for (int idx = 0; idx < cachesbSessionsBackGround.Length; idx++)
                    if (cachesbSessionsBackGround[idx].EqualsInput(input))
                        return cachesbSessionsBackGround[idx];

            lock (checksbSessionsBackGround)
            {
                if (cachesbSessionsBackGround != null)
                    for (int idx = 0; idx < cachesbSessionsBackGround.Length; idx++)
                        if (cachesbSessionsBackGround[idx].EqualsInput(input))
                            return cachesbSessionsBackGround[idx];

                sbSessionsBackGround indicator = new sbSessionsBackGround();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                Indicators.Add(indicator);
                indicator.SetUp();

                sbSessionsBackGround[] tmp = new sbSessionsBackGround[cachesbSessionsBackGround == null ? 1 : cachesbSessionsBackGround.Length + 1];
                if (cachesbSessionsBackGround != null)
                    cachesbSessionsBackGround.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachesbSessionsBackGround = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Sessions Background by Anton Bazhenov \nhttp://protradestudio.ru
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.sbSessionsBackGround sbSessionsBackGround()
        {
            return _indicator.sbSessionsBackGround(Input);
        }

        /// <summary>
        /// Sessions Background by Anton Bazhenov \nhttp://protradestudio.ru
        /// </summary>
        /// <returns></returns>
        public Indicator.sbSessionsBackGround sbSessionsBackGround(Data.IDataSeries input)
        {
            return _indicator.sbSessionsBackGround(input);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Sessions Background by Anton Bazhenov \nhttp://protradestudio.ru
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.sbSessionsBackGround sbSessionsBackGround()
        {
            return _indicator.sbSessionsBackGround(Input);
        }

        /// <summary>
        /// Sessions Background by Anton Bazhenov \nhttp://protradestudio.ru
        /// </summary>
        /// <returns></returns>
        public Indicator.sbSessionsBackGround sbSessionsBackGround(Data.IDataSeries input)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.sbSessionsBackGround(input);
        }
    }
}
#endregion
