#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Enter the description of your new custom indicator here
    /// </summary>
    [Description("Enter the description of your new custom indicator here")]
    public class LargeTrades : Indicator
    {
        #region Variables 
		private int vol = 50;
		private int fix = 1; 
		Color color = Color.Red;
		Color shadowcolor = Color.Red;
		int opacity = 1;
		private bool useAlerts = true;
		private bool useEllipse = true;
		private bool ShowTime = true;
		private string stringtoAlert = "Alert4.wav";
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
		/// 
        protected override void Initialize()
        {                
            CalculateOnBarClose	= true;
			Overlay				= true;	
			
			Add(PeriodType.Second,1);			
        }
        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
       protected override void OnBarUpdate()
        {
	        if (CurrentBar < 2) return;
			if (BarsInProgress == 1)
				
			{			
				TimeSpan ts1 = Time[0] - new DateTime(1970,1,1,0,0,0);
			    TimeSpan ts2 = Time[1] - new DateTime(1970,1,1,0,0,0);

			   // int timeGap=(int)Time[0].Second-(int)Time[1].Second;
				int timeGap=(int)ts1.TotalSeconds-(int)ts2.TotalSeconds;

			if (Volume[0]>=vol && timeGap<=fix)
			    {	
				if(useEllipse)	
			    DrawEllipse("ellipse"+CurrentBar, true, 3, High[0], -3, Low[0], color, shadowcolor, opacity);
			    if(useAlerts)	
				Alert("myAlert"+CurrentBar, NinjaTrader.Cbi.Priority.High, "DownwardCross", stringtoAlert, 1, Color.Black, Color.Yellow);
				if(ShowTime)	
				{
				//DrawText("TFx"+CurrentBar, true, Convert.ToString(Volume[0]), 0, Median[0], 0,Color.White, 
					DrawText("TFx"+CurrentBar, true, Convert.ToString(Time[0]), 0, Median[0], 0,Color.White, 
				new Font("Small Fonts", 7, FontStyle.Regular), StringAlignment.Far,	Color.Transparent, Color.Transparent, 0);
				}
				else
				{
				DrawText("TFx"+CurrentBar, true, Convert.ToString(Volume[0]), 0, Median[0], 0,Color.White, 
						new Font("Small Fonts", 7, FontStyle.Regular), StringAlignment.Far,	Color.Transparent, Color.Transparent, 0);
				}
				}
        
		}
			}
		#region Properties	
		[Description("Объём сделки")]
		[Gui.Design.DisplayName("1.Объём сделки")]
        [GridCategory("Parameters")]
        public int Объём
        {
            get { return vol; }
            set { vol = Math.Max(1, value); }
        }
		[Description("Время, в течение которого произошла сделка")]
        [Category("Parameters")]
		[Gui.Design.DisplayName("2.Время")]
        public int Время
        {
            get { return fix; }
            set { fix = Math.Max(1, value); }
        }
		[XmlIgnore()]
		[Description("Цвет метки сделки")]
		[Gui.Design.DisplayName("3.Цвет")]
		[Category("Parameters")]
		public Color Цвет
		{
			get{return color;}
			set{color = value;}
		}
		[Description("Отображение сделки")]
        [GridCategory("Parameters-Other")]
		[Gui.Design.DisplayName("1.Отображение сделки")]
        public bool Эллипс
        {
            get { return useEllipse; }
            set {useEllipse = value; }
        }	
		[Description("Отображать значение объёма/время в сделке")]
        [GridCategory("Parameters-Other")]
		[Gui.Design.DisplayName("2.Значение объёма или время")]
        public bool Значения_объёма
        {
            get { return ShowTime; }
            set {ShowTime = value; }
        }	
		[Description("Звуковой сигнал")]
        [GridCategory("Parameters-Other")]
		[Gui.Design.DisplayName("3.Звуковой сигнал")]
        public bool Звуковой_сигнал
        {
            get { return useAlerts; }
            set {useAlerts = value; }
        }			
        [Description("Имя звукового файла")]
        [GridCategory("Parameters-Other")]
		[Gui.Design.DisplayName("4.Имя звукового файла")]
        public string StringtoAlert
        {
            get { return stringtoAlert; }
            set {stringtoAlert = value; }
        }		
        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private LargeTrades[] cacheLargeTrades = null;

        private static LargeTrades checkLargeTrades = new LargeTrades();

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public LargeTrades LargeTrades(string stringtoAlert, int время, bool звуковой_сигнал, bool значения_объёма, int объём, Color цвет, bool эллипс)
        {
            return LargeTrades(Input, stringtoAlert, время, звуковой_сигнал, значения_объёма, объём, цвет, эллипс);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public LargeTrades LargeTrades(Data.IDataSeries input, string stringtoAlert, int время, bool звуковой_сигнал, bool значения_объёма, int объём, Color цвет, bool эллипс)
        {
            if (cacheLargeTrades != null)
                for (int idx = 0; idx < cacheLargeTrades.Length; idx++)
                    if (cacheLargeTrades[idx].StringtoAlert == stringtoAlert && cacheLargeTrades[idx].Время == время && cacheLargeTrades[idx].Звуковой_сигнал == звуковой_сигнал && cacheLargeTrades[idx].Значения_объёма == значения_объёма && cacheLargeTrades[idx].Объём == объём && cacheLargeTrades[idx].Цвет == цвет && cacheLargeTrades[idx].Эллипс == эллипс && cacheLargeTrades[idx].EqualsInput(input))
                        return cacheLargeTrades[idx];

            lock (checkLargeTrades)
            {
                checkLargeTrades.StringtoAlert = stringtoAlert;
                stringtoAlert = checkLargeTrades.StringtoAlert;
                checkLargeTrades.Время = время;
                время = checkLargeTrades.Время;
                checkLargeTrades.Звуковой_сигнал = звуковой_сигнал;
                звуковой_сигнал = checkLargeTrades.Звуковой_сигнал;
                checkLargeTrades.Значения_объёма = значения_объёма;
                значения_объёма = checkLargeTrades.Значения_объёма;
                checkLargeTrades.Объём = объём;
                объём = checkLargeTrades.Объём;
                checkLargeTrades.Цвет = цвет;
                цвет = checkLargeTrades.Цвет;
                checkLargeTrades.Эллипс = эллипс;
                эллипс = checkLargeTrades.Эллипс;

                if (cacheLargeTrades != null)
                    for (int idx = 0; idx < cacheLargeTrades.Length; idx++)
                        if (cacheLargeTrades[idx].StringtoAlert == stringtoAlert && cacheLargeTrades[idx].Время == время && cacheLargeTrades[idx].Звуковой_сигнал == звуковой_сигнал && cacheLargeTrades[idx].Значения_объёма == значения_объёма && cacheLargeTrades[idx].Объём == объём && cacheLargeTrades[idx].Цвет == цвет && cacheLargeTrades[idx].Эллипс == эллипс && cacheLargeTrades[idx].EqualsInput(input))
                            return cacheLargeTrades[idx];

                LargeTrades indicator = new LargeTrades();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.StringtoAlert = stringtoAlert;
                indicator.Время = время;
                indicator.Звуковой_сигнал = звуковой_сигнал;
                indicator.Значения_объёма = значения_объёма;
                indicator.Объём = объём;
                indicator.Цвет = цвет;
                indicator.Эллипс = эллипс;
                Indicators.Add(indicator);
                indicator.SetUp();

                LargeTrades[] tmp = new LargeTrades[cacheLargeTrades == null ? 1 : cacheLargeTrades.Length + 1];
                if (cacheLargeTrades != null)
                    cacheLargeTrades.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheLargeTrades = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.LargeTrades LargeTrades(string stringtoAlert, int время, bool звуковой_сигнал, bool значения_объёма, int объём, Color цвет, bool эллипс)
        {
            return _indicator.LargeTrades(Input, stringtoAlert, время, звуковой_сигнал, значения_объёма, объём, цвет, эллипс);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.LargeTrades LargeTrades(Data.IDataSeries input, string stringtoAlert, int время, bool звуковой_сигнал, bool значения_объёма, int объём, Color цвет, bool эллипс)
        {
            return _indicator.LargeTrades(input, stringtoAlert, время, звуковой_сигнал, значения_объёма, объём, цвет, эллипс);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.LargeTrades LargeTrades(string stringtoAlert, int время, bool звуковой_сигнал, bool значения_объёма, int объём, Color цвет, bool эллипс)
        {
            return _indicator.LargeTrades(Input, stringtoAlert, время, звуковой_сигнал, значения_объёма, объём, цвет, эллипс);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.LargeTrades LargeTrades(Data.IDataSeries input, string stringtoAlert, int время, bool звуковой_сигнал, bool значения_объёма, int объём, Color цвет, bool эллипс)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.LargeTrades(input, stringtoAlert, время, звуковой_сигнал, значения_объёма, объём, цвет, эллипс);
        }
    }
}
#endregion
