//
// Copyright (C) 2006, NinjaTrader LLC <ninjatrader@ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private AuctionDashboard[] cacheAuctionDashboard = null;

        private static AuctionDashboard checkAuctionDashboard = new AuctionDashboard();

        /// <summary>
        /// The Auction Dashboard\u2122 indicator. See www.AuctionDashboard.com for more.
        /// </summary>
        /// <returns></returns>
        public AuctionDashboard AuctionDashboard()
        {
            return AuctionDashboard(Input);
        }

        /// <summary>
        /// The Auction Dashboard\u2122 indicator. See www.AuctionDashboard.com for more.
        /// </summary>
        /// <returns></returns>
        public AuctionDashboard AuctionDashboard(Data.IDataSeries input)
        {
            if (cacheAuctionDashboard != null)
                for (int idx = 0; idx < cacheAuctionDashboard.Length; idx++)
                    if (cacheAuctionDashboard[idx].EqualsInput(input))
                        return cacheAuctionDashboard[idx];

            lock (checkAuctionDashboard)
            {
                if (cacheAuctionDashboard != null)
                    for (int idx = 0; idx < cacheAuctionDashboard.Length; idx++)
                        if (cacheAuctionDashboard[idx].EqualsInput(input))
                            return cacheAuctionDashboard[idx];

                AuctionDashboard indicator = new AuctionDashboard();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                Indicators.Add(indicator);
                indicator.SetUp();

                AuctionDashboard[] tmp = new AuctionDashboard[cacheAuctionDashboard == null ? 1 : cacheAuctionDashboard.Length + 1];
                if (cacheAuctionDashboard != null)
                    cacheAuctionDashboard.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheAuctionDashboard = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// The Auction Dashboard\u2122 indicator. See www.AuctionDashboard.com for more.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.AuctionDashboard AuctionDashboard()
        {
            return _indicator.AuctionDashboard(Input);
        }

        /// <summary>
        /// The Auction Dashboard\u2122 indicator. See www.AuctionDashboard.com for more.
        /// </summary>
        /// <returns></returns>
        public Indicator.AuctionDashboard AuctionDashboard(Data.IDataSeries input)
        {
            return _indicator.AuctionDashboard(input);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// The Auction Dashboard\u2122 indicator. See www.AuctionDashboard.com for more.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.AuctionDashboard AuctionDashboard()
        {
            return _indicator.AuctionDashboard(Input);
        }

        /// <summary>
        /// The Auction Dashboard\u2122 indicator. See www.AuctionDashboard.com for more.
        /// </summary>
        /// <returns></returns>
        public Indicator.AuctionDashboard AuctionDashboard(Data.IDataSeries input)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.AuctionDashboard(input);
        }
    }
}
#endregion
