//
// Copyright (C) 2006, NinjaTrader LLC <ninjatrader@ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private AcmeLevelBand[] cacheAcmeLevelBand = null;

        private static AcmeLevelBand checkAcmeLevelBand = new AcmeLevelBand();

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public AcmeLevelBand AcmeLevelBand(Color bandColor, int opacity, double price, int ticks)
        {
            return AcmeLevelBand(Input, bandColor, opacity, price, ticks);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public AcmeLevelBand AcmeLevelBand(Data.IDataSeries input, Color bandColor, int opacity, double price, int ticks)
        {
            if (cacheAcmeLevelBand != null)
                for (int idx = 0; idx < cacheAcmeLevelBand.Length; idx++)
                    if (cacheAcmeLevelBand[idx].BandColor == bandColor && cacheAcmeLevelBand[idx].Opacity == opacity && Math.Abs(cacheAcmeLevelBand[idx].Price - price) <= double.Epsilon && cacheAcmeLevelBand[idx].Ticks == ticks && cacheAcmeLevelBand[idx].EqualsInput(input))
                        return cacheAcmeLevelBand[idx];

            lock (checkAcmeLevelBand)
            {
                checkAcmeLevelBand.BandColor = bandColor;
                bandColor = checkAcmeLevelBand.BandColor;
                checkAcmeLevelBand.Opacity = opacity;
                opacity = checkAcmeLevelBand.Opacity;
                checkAcmeLevelBand.Price = price;
                price = checkAcmeLevelBand.Price;
                checkAcmeLevelBand.Ticks = ticks;
                ticks = checkAcmeLevelBand.Ticks;

                if (cacheAcmeLevelBand != null)
                    for (int idx = 0; idx < cacheAcmeLevelBand.Length; idx++)
                        if (cacheAcmeLevelBand[idx].BandColor == bandColor && cacheAcmeLevelBand[idx].Opacity == opacity && Math.Abs(cacheAcmeLevelBand[idx].Price - price) <= double.Epsilon && cacheAcmeLevelBand[idx].Ticks == ticks && cacheAcmeLevelBand[idx].EqualsInput(input))
                            return cacheAcmeLevelBand[idx];

                AcmeLevelBand indicator = new AcmeLevelBand();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.BandColor = bandColor;
                indicator.Opacity = opacity;
                indicator.Price = price;
                indicator.Ticks = ticks;
                Indicators.Add(indicator);
                indicator.SetUp();

                AcmeLevelBand[] tmp = new AcmeLevelBand[cacheAcmeLevelBand == null ? 1 : cacheAcmeLevelBand.Length + 1];
                if (cacheAcmeLevelBand != null)
                    cacheAcmeLevelBand.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheAcmeLevelBand = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.AcmeLevelBand AcmeLevelBand(Color bandColor, int opacity, double price, int ticks)
        {
            return _indicator.AcmeLevelBand(Input, bandColor, opacity, price, ticks);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.AcmeLevelBand AcmeLevelBand(Data.IDataSeries input, Color bandColor, int opacity, double price, int ticks)
        {
            return _indicator.AcmeLevelBand(input, bandColor, opacity, price, ticks);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.AcmeLevelBand AcmeLevelBand(Color bandColor, int opacity, double price, int ticks)
        {
            return _indicator.AcmeLevelBand(Input, bandColor, opacity, price, ticks);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.AcmeLevelBand AcmeLevelBand(Data.IDataSeries input, Color bandColor, int opacity, double price, int ticks)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.AcmeLevelBand(input, bandColor, opacity, price, ticks);
        }
    }
}
#endregion
