//
// Copyright (C) 2006, NinjaTrader LLC <ninjatrader@ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private AcmeFibonacciWave[] cacheAcmeFibonacciWave = null;

        private static AcmeFibonacciWave checkAcmeFibonacciWave = new AcmeFibonacciWave();

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public AcmeFibonacciWave AcmeFibonacciWave(Color bearishColorDown, Color bearishColorUp, Color bullishColorDown, Color bullishColorUp, bool colorBars, bool hideWave, Color neutralColorDown, Color neutralColorUp, int period)
        {
            return AcmeFibonacciWave(Input, bearishColorDown, bearishColorUp, bullishColorDown, bullishColorUp, colorBars, hideWave, neutralColorDown, neutralColorUp, period);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public AcmeFibonacciWave AcmeFibonacciWave(Data.IDataSeries input, Color bearishColorDown, Color bearishColorUp, Color bullishColorDown, Color bullishColorUp, bool colorBars, bool hideWave, Color neutralColorDown, Color neutralColorUp, int period)
        {
            if (cacheAcmeFibonacciWave != null)
                for (int idx = 0; idx < cacheAcmeFibonacciWave.Length; idx++)
                    if (cacheAcmeFibonacciWave[idx].BearishColorDown == bearishColorDown && cacheAcmeFibonacciWave[idx].BearishColorUp == bearishColorUp && cacheAcmeFibonacciWave[idx].BullishColorDown == bullishColorDown && cacheAcmeFibonacciWave[idx].BullishColorUp == bullishColorUp && cacheAcmeFibonacciWave[idx].ColorBars == colorBars && cacheAcmeFibonacciWave[idx].HideWave == hideWave && cacheAcmeFibonacciWave[idx].NeutralColorDown == neutralColorDown && cacheAcmeFibonacciWave[idx].NeutralColorUp == neutralColorUp && cacheAcmeFibonacciWave[idx].Period == period && cacheAcmeFibonacciWave[idx].EqualsInput(input))
                        return cacheAcmeFibonacciWave[idx];

            lock (checkAcmeFibonacciWave)
            {
                checkAcmeFibonacciWave.BearishColorDown = bearishColorDown;
                bearishColorDown = checkAcmeFibonacciWave.BearishColorDown;
                checkAcmeFibonacciWave.BearishColorUp = bearishColorUp;
                bearishColorUp = checkAcmeFibonacciWave.BearishColorUp;
                checkAcmeFibonacciWave.BullishColorDown = bullishColorDown;
                bullishColorDown = checkAcmeFibonacciWave.BullishColorDown;
                checkAcmeFibonacciWave.BullishColorUp = bullishColorUp;
                bullishColorUp = checkAcmeFibonacciWave.BullishColorUp;
                checkAcmeFibonacciWave.ColorBars = colorBars;
                colorBars = checkAcmeFibonacciWave.ColorBars;
                checkAcmeFibonacciWave.HideWave = hideWave;
                hideWave = checkAcmeFibonacciWave.HideWave;
                checkAcmeFibonacciWave.NeutralColorDown = neutralColorDown;
                neutralColorDown = checkAcmeFibonacciWave.NeutralColorDown;
                checkAcmeFibonacciWave.NeutralColorUp = neutralColorUp;
                neutralColorUp = checkAcmeFibonacciWave.NeutralColorUp;
                checkAcmeFibonacciWave.Period = period;
                period = checkAcmeFibonacciWave.Period;

                if (cacheAcmeFibonacciWave != null)
                    for (int idx = 0; idx < cacheAcmeFibonacciWave.Length; idx++)
                        if (cacheAcmeFibonacciWave[idx].BearishColorDown == bearishColorDown && cacheAcmeFibonacciWave[idx].BearishColorUp == bearishColorUp && cacheAcmeFibonacciWave[idx].BullishColorDown == bullishColorDown && cacheAcmeFibonacciWave[idx].BullishColorUp == bullishColorUp && cacheAcmeFibonacciWave[idx].ColorBars == colorBars && cacheAcmeFibonacciWave[idx].HideWave == hideWave && cacheAcmeFibonacciWave[idx].NeutralColorDown == neutralColorDown && cacheAcmeFibonacciWave[idx].NeutralColorUp == neutralColorUp && cacheAcmeFibonacciWave[idx].Period == period && cacheAcmeFibonacciWave[idx].EqualsInput(input))
                            return cacheAcmeFibonacciWave[idx];

                AcmeFibonacciWave indicator = new AcmeFibonacciWave();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.BearishColorDown = bearishColorDown;
                indicator.BearishColorUp = bearishColorUp;
                indicator.BullishColorDown = bullishColorDown;
                indicator.BullishColorUp = bullishColorUp;
                indicator.ColorBars = colorBars;
                indicator.HideWave = hideWave;
                indicator.NeutralColorDown = neutralColorDown;
                indicator.NeutralColorUp = neutralColorUp;
                indicator.Period = period;
                Indicators.Add(indicator);
                indicator.SetUp();

                AcmeFibonacciWave[] tmp = new AcmeFibonacciWave[cacheAcmeFibonacciWave == null ? 1 : cacheAcmeFibonacciWave.Length + 1];
                if (cacheAcmeFibonacciWave != null)
                    cacheAcmeFibonacciWave.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheAcmeFibonacciWave = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.AcmeFibonacciWave AcmeFibonacciWave(Color bearishColorDown, Color bearishColorUp, Color bullishColorDown, Color bullishColorUp, bool colorBars, bool hideWave, Color neutralColorDown, Color neutralColorUp, int period)
        {
            return _indicator.AcmeFibonacciWave(Input, bearishColorDown, bearishColorUp, bullishColorDown, bullishColorUp, colorBars, hideWave, neutralColorDown, neutralColorUp, period);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.AcmeFibonacciWave AcmeFibonacciWave(Data.IDataSeries input, Color bearishColorDown, Color bearishColorUp, Color bullishColorDown, Color bullishColorUp, bool colorBars, bool hideWave, Color neutralColorDown, Color neutralColorUp, int period)
        {
            return _indicator.AcmeFibonacciWave(input, bearishColorDown, bearishColorUp, bullishColorDown, bullishColorUp, colorBars, hideWave, neutralColorDown, neutralColorUp, period);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.AcmeFibonacciWave AcmeFibonacciWave(Color bearishColorDown, Color bearishColorUp, Color bullishColorDown, Color bullishColorUp, bool colorBars, bool hideWave, Color neutralColorDown, Color neutralColorUp, int period)
        {
            return _indicator.AcmeFibonacciWave(Input, bearishColorDown, bearishColorUp, bullishColorDown, bullishColorUp, colorBars, hideWave, neutralColorDown, neutralColorUp, period);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.AcmeFibonacciWave AcmeFibonacciWave(Data.IDataSeries input, Color bearishColorDown, Color bearishColorUp, Color bullishColorDown, Color bullishColorUp, bool colorBars, bool hideWave, Color neutralColorDown, Color neutralColorUp, int period)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.AcmeFibonacciWave(input, bearishColorDown, bearishColorUp, bullishColorDown, bullishColorUp, colorBars, hideWave, neutralColorDown, neutralColorUp, period);
        }
    }
}
#endregion
