--константы
data_file = "shares.txt"	--путь к файлу со списком акций и кодов классов



--переменные скрипта
is_run = true		--Режим работы скрипта, работает или остановлен
shares = {}		--Список акций
shares_count = 0	--Количество акций
table_data = nil	--Данные для визуальной таблицы
t = nil			--Указатель на визуальную таблицу


--Дополнительый поток
function main()
	while is_run do
		sleep(500)
	end;
end




--События основного потока

function OnConnected()
end


function OnDisconnected()
end


function OnInit(quik_path)
	--читаем из файла акции и коды классов
	for line in io.lines(data_file) do
		pos = string.find(line, ";")
		share = string.sub(line, 0, pos-1)

		line = string.sub(line, pos+1)
		pos = string.find(line, ";")
		class = string.sub(line, 0, pos-1)

		extrem_count = string.sub(line, pos+1)

		--message(share .. " - " .. class .. " - " .. extrem_count, 1)
		share_item = {}
		share_item["class"] = class
		share_item["extrem_count"] = extrem_count
		shares[share] = share_item
		shares_count = shares_count + 1
	end

	table.sort(shares)

	--содержимое таблицы	
	table_data = {}


	--Создаем структуру, описывающую таблицу
	t = AllocTable()

	--столбцы
	AddColumn(t, 1, "Ticker", true, QTABLE_STRING_TYPE, 15)
	AddColumn(t, 2, "Count Bid", true, QTABLE_INT_TYPE, 15)
	AddColumn(t, 3, "Bid Price", true, QTABLE_STRING_TYPE, 15)
	AddColumn(t, 4, "Count Ask", true, QTABLE_INT_TYPE, 15)
	AddColumn(t, 5, "Ask Price", true, QTABLE_STRING_TYPE, 15)

	CreateWindow(t)
	SetWindowCaption(t, "Density")
	SetWindowPos(t, 200, 200, 500, 600)

	for i=1, shares_count do
		InsertRow(t, -1)
	end


	i = 0

	-- заполняем таблицу используя сортировку по ключам
	for key, value in spairs(shares) do
	--for key, value in pairs(shares) do
		i = i + 1
		sec_code = key

		SetCell(t, i, 1, tostring(sec_code))
		SetColor(t, i, 1, RGB(150, 150, 150), QTABLE_DEFAULT_COLOR, QTABLE_DEFAULT_COLOR, QTABLE_DEFAULT_COLOR)
	end

end


function OnStop()
	is_run = false
end


function OnTrade(trade)
	--message("New trade", 1)
end


function OnOrder(order)
 	--message("New order - ".. os.date() ..";".. order.ordernum ..";".. order.seccode ..";".. order.price ..";".. order.qty ..";".. order.balance, 1)
end


function OnQuote(class, sec)

	for key, value in pairs(shares) do

		sec_code = key
		sec_class = value["class"]
		sec_extrem_count = value["extrem_count"]

		if (class == sec_class and sec == key) then

			ql2 = getQuoteLevel2(class, sec)

			bid_count = tonumber(ql2["bid_count"])
			ask_count = tonumber(ql2["offer_count"])

			bid = ql2["bid"]	--покупатели
			ask = ql2["offer"]	--продавцы

			max_bid_count = 0		--количество лотов (максимальный спрос)
			max_ask_count = 0		--количество лотов (максимальное предложение)
			max_bid_price = ""	--цена максимального спроса
			max_ask_price = ""	--цена максимального предложения


			--перебираем всех покупателей и находим самое большое число спроса
			for i=1, bid_count, 1 do
				bid_quantity = tonumber( bid[i]["quantity"] )

				if (bid_quantity > max_bid_count) then
					max_bid_count = bid_quantity
					max_bid_price = bid[i]["price"]
				end
			end


			--перебираем всех продавцов находим самое большое число предложений
			for i=1, ask_count, 1 do
				ask_quantity = tonumber( ask[i]["quantity"] )

				if (ask_quantity > max_ask_count) then
					max_ask_count = ask_quantity
					max_ask_price = ask[i]["price"]
				end
			end


			table_data[sec_code] = {}
			
			--если количество покупателей больше экстремального значения
			if (max_bid_count > tonumber(sec_extrem_count)) then
				--изменяем эмитент в списке table_data
				table_data[sec_code]["max_bid_count"] = max_bid_count
				table_data[sec_code]["max_bid_price"] = max_bid_price
			else
				table_data[sec_code]["max_bid_count"] = 0
				table_data[sec_code]["max_bid_price"] = 0
			end


			--если количество продавцов больше экстремального значения
			if (max_ask_count > tonumber(sec_extrem_count)) then
				--изменяем эмитент в списке table_data
				table_data[sec_code]["max_ask_count"] = max_ask_count
				table_data[sec_code]["max_ask_price"] = max_ask_price
			else
				table_data[sec_code]["max_ask_count"] = 0
				table_data[sec_code]["max_ask_price"] = 0
			end
			

			--message(sec, 1)



			--находим строку с нужным эмитентом и меняем значения
			for i=1, shares_count do

				local row = GetCell(t, i, 1)
				--message(tostring(row["image"]), 1)

				row_sec = tostring(row["image"])

				if (row_sec == sec_code) then
					if (table_data[sec_code]["max_bid_count"] ~= 0) then
						SetCell(t, i, 2, tostring(max_bid_count))
						SetColor(t, i, 2, RGB(50, 250, 50), QTABLE_DEFAULT_COLOR, QTABLE_DEFAULT_COLOR, QTABLE_DEFAULT_COLOR)
						SetCell(t, i, 3, tostring(max_bid_price))
						SetColor(t, i, 3, RGB(50, 250, 50), QTABLE_DEFAULT_COLOR, QTABLE_DEFAULT_COLOR, QTABLE_DEFAULT_COLOR)
					else
						SetCell(t, i, 2, "")
						SetColor(t, i, 2, RGB(255, 255, 255), QTABLE_DEFAULT_COLOR, QTABLE_DEFAULT_COLOR, QTABLE_DEFAULT_COLOR)
						SetCell(t, i, 3, "")
						SetColor(t, i, 3, RGB(255, 255, 255), QTABLE_DEFAULT_COLOR, QTABLE_DEFAULT_COLOR, QTABLE_DEFAULT_COLOR)
					end


					if (table_data[sec_code]["max_ask_count"] ~= 0) then
						SetCell(t, i, 4, tostring(max_ask_count))
						SetColor(t, i, 4, RGB(255, 164, 164), QTABLE_DEFAULT_COLOR, QTABLE_DEFAULT_COLOR, QTABLE_DEFAULT_COLOR)
						SetCell(t, i, 5, tostring(max_ask_price))
						SetColor(t, i, 5, RGB(255, 164, 164), QTABLE_DEFAULT_COLOR, QTABLE_DEFAULT_COLOR, QTABLE_DEFAULT_COLOR)
					else
						SetCell(t, i, 4, "")
						SetColor(t, i, 4, RGB(255, 255, 255), QTABLE_DEFAULT_COLOR, QTABLE_DEFAULT_COLOR, QTABLE_DEFAULT_COLOR)
						SetCell(t, i, 5, "")
						SetColor(t, i, 5, RGB(255, 255, 255), QTABLE_DEFAULT_COLOR, QTABLE_DEFAULT_COLOR, QTABLE_DEFAULT_COLOR)
					end
				end

			end

			--message( tostring(max_bid_count) .. " [" .. max_bid_price .. "]\n" .. tostring(max_ask_count) .. " [" .. max_ask_price .. "]\n", 1)
		end

	end

end



--служебные функции

--Функция преобразования значения элемента таблицы в строку
function table.value_to_str ( v )
	if "string" == type( v ) then
	v = string.gsub( v, "\n", "\\n" )
	if string.match( string.gsub(v,"[^'\"]",""), '^"+$' ) then
		return "'" .. v .. "'"
	end
	return '"' .. string.gsub(v,'"', '\\"' ) .. '"'
	else
	return "table" == type( v ) and table.tostring( v ) or
		tostring( v )
	end
end


--Функция преобразования ключа таблицы в строку
function table.key_to_str ( k )
	if "string" == type( k ) and string.match( k, "^[_%a][_%a%d]*$" ) then
		return k
	else
		return "[" .. table.value_to_str( k ) .. "]"
	end
end


--Функция преобразования таблицы в строку
function table.tostring( tbl )
	local result, done = {}, {}
	for k, v in ipairs( tbl ) do
		table.insert( result, table.value_to_str( v ) )
		done[ k ] = true
	end
	for k, v in pairs( tbl ) do
		if not done[ k ] then
			table.insert( result,
			table.key_to_str( k ) .. "=" .. table.value_to_str( v ) )
		end
	end
	return "{" .. table.concat( result, "," ) .. "}"
end


--Функция для сортировки справочника по ключам
function spairs(t, order)
	-- collect the keys
	local keys = {}
	for k in pairs(t) do
		keys[#keys+1] = k
	end

	-- if order function given, sort by it by passing the table and keys a, b, otherwise just sort the keys 
	if order then
		table.sort(keys, function(a,b) return order(t, a, b) end)
	else
		table.sort(keys)
	end

	-- return the iterator function
	local i = 0
	return function()
		i = i + 1
		if keys[i] then
			return keys[i], t[keys[i]]
		end
	end
end