#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Enter the description of your new custom indicator here
    /// </summary>
    [Description("Enter the description of your new custom indicator here")]
     public class GomCDMA : Indicator
{
#region Variables 
 Indicator maindic;
 GomCD gcd;

	
 int period=5;
 GomMATypeEnum maType=GomMATypeEnum.EMA;
	
	bool initdone=false;
	
#endregion
 
protected override void Initialize()
{
	Add(new Plot(new Pen(Color.FromKnownColor(KnownColor.Red),1),  PlotStyle.Line, "GCDMADown"));
	Add(new Plot(new Pen(Color.FromKnownColor(KnownColor.Green),1),  PlotStyle.Line, "GCDMAUp"));
	Add(new Plot(new Pen(Color.Gray,2),  PlotStyle.Line, "GCDMA"));
	CalculateOnBarClose = false;
 	Overlay = false;
 	PriceTypeSupported = false; 
}

void PlotChart()
{

	if (CurrentBar<1) return;
	
	if (Rising(maindic))
	{
		GCDMAUp.Set(maindic[0]);
		GCDMAUp.Set(1,maindic[1]);
		GCDMADown.Reset(0);
	}
	else
	{
		GCDMADown.Set(maindic[0]);
		GCDMADown.Set(1,maindic[1]);
		GCDMAUp.Reset(0);	
	}
	
	GCDMA.Set(maindic[0]);
}

 
protected override void OnBarUpdate()
{ 		
	if (!initdone)
		{

			gcd=GomCD(GomCDCalculationModeType.BidAsk,GomCDChartType.CumulativeChart,GomFileFormat.Binary,GomFilterModeType.None,1,false);
				
			if (maType==GomMATypeEnum.SMA)
				maindic=SMA(gcd.DeltaClose,period);
			else if (maType==GomMATypeEnum.EMA)
				maindic=EMA(gcd.DeltaClose,period);

			initdone=true;
		}
		
	double dummy=gcd.DeltaValue[0];	
	
	PlotChart();

}

		#region Properties
		/// <summary>
		/// </summary>
		[Description("Numbers of bars used for calculations")]
        [Category("Parameters")]
		public int Period
		{
			get { return period; }
			set { period = Math.Max(1, value); }
		}
		
				
		[Description("Numbers of bars used for calculations")]
        [Category("Parameters")]
        public GomMATypeEnum MAType 
        {
            get { return maType; }
            set { maType = value; }
		}
		

		[Browsable(false)] 
		[XmlIgnore()]
		public DataSeries GCDMADown
		{
 			get { return Values[0]; }
		}
		
		[Browsable(false)] 
		[XmlIgnore()]
		public DataSeries GCDMAUp
		{
 			get { return Values[1]; }
		}
		
		[Browsable(false)] 
		[XmlIgnore()]
		public DataSeries GCDMA
		{
 			get { return Values[2]; }
		}


		
        #endregion
				
}

}

public enum GomMATypeEnum
	{
		SMA,
		EMA
	}
	
#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private GomCDMA[] cacheGomCDMA = null;

        private static GomCDMA checkGomCDMA = new GomCDMA();

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public GomCDMA GomCDMA(GomMATypeEnum mAType, int period)
        {
            return GomCDMA(Input, mAType, period);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public GomCDMA GomCDMA(Data.IDataSeries input, GomMATypeEnum mAType, int period)
        {
            if (cacheGomCDMA != null)
                for (int idx = 0; idx < cacheGomCDMA.Length; idx++)
                    if (cacheGomCDMA[idx].MAType == mAType && cacheGomCDMA[idx].Period == period && cacheGomCDMA[idx].EqualsInput(input))
                        return cacheGomCDMA[idx];

            lock (checkGomCDMA)
            {
                checkGomCDMA.MAType = mAType;
                mAType = checkGomCDMA.MAType;
                checkGomCDMA.Period = period;
                period = checkGomCDMA.Period;

                if (cacheGomCDMA != null)
                    for (int idx = 0; idx < cacheGomCDMA.Length; idx++)
                        if (cacheGomCDMA[idx].MAType == mAType && cacheGomCDMA[idx].Period == period && cacheGomCDMA[idx].EqualsInput(input))
                            return cacheGomCDMA[idx];

                GomCDMA indicator = new GomCDMA();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.MAType = mAType;
                indicator.Period = period;
                Indicators.Add(indicator);
                indicator.SetUp();

                GomCDMA[] tmp = new GomCDMA[cacheGomCDMA == null ? 1 : cacheGomCDMA.Length + 1];
                if (cacheGomCDMA != null)
                    cacheGomCDMA.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheGomCDMA = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.GomCDMA GomCDMA(GomMATypeEnum mAType, int period)
        {
            return _indicator.GomCDMA(Input, mAType, period);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.GomCDMA GomCDMA(Data.IDataSeries input, GomMATypeEnum mAType, int period)
        {
            return _indicator.GomCDMA(input, mAType, period);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.GomCDMA GomCDMA(GomMATypeEnum mAType, int period)
        {
            return _indicator.GomCDMA(Input, mAType, period);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.GomCDMA GomCDMA(Data.IDataSeries input, GomMATypeEnum mAType, int period)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.GomCDMA(input, mAType, period);
        }
    }
}
#endregion
