#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
using System.Collections.Generic;
using System.Windows.Forms;

#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Enter the description of your new custom indicator here
    /// </summary>
    [Description("Downloaded from http://www.brokerfib.ru/")]
	
	public class GomMP : GomDeltaIndicator
    {
		
		const short PRE_RTH=-1;
		const short POST_RTH=-2;
		
		class VolElement
		{
			
			private ushort positivevolume,negativevolume;

			public ushort PositiveVolume {get {return positivevolume;}}
			public ushort NegativeVolume {get {return negativevolume;}}	
			public ushort TotalVolume{get {return (ushort)(positivevolume+negativevolume);}}
			
			public VolElement(int v) 
			{
				AddVolume(v);	
			}
			
			public void AddVolume(int v)
			{
				if (v>0) 	positivevolume += Convert.ToUInt16(v); 
				if (v<0)	negativevolume += Convert.ToUInt16(-v);
			}
			
		};
		
		
		class VolumeAtPrice
		{
			public SortedDictionary<short, VolElement> volumes;
			private ushort positivevolume,negativevolume;
			 
			public ushort PositiveVolume {get {return positivevolume;}}
			public ushort NegativeVolume {get {return negativevolume;}}	
			public ushort TotalVolume {get {return (ushort)(positivevolume+negativevolume);}}				
			
			private GraphicalHelper helper;			
			
			public VolumeAtPrice(int volume, short minute)
			{
				volumes=new SortedDictionary<short,VolElement>();
				volumes.Add(minute,new VolElement(volume));
			}
			
			public void AddVolume(int volume, short minute)
				
			{	
				if (volumes.ContainsKey(minute))
					volumes[minute].AddVolume(volume);						
				else
					volumes.Add(minute,new VolElement(volume));
				
				if (volume>0) 	positivevolume += Convert.ToUInt16(volume); 
				if (volume<0)	negativevolume += Convert.ToUInt16(-volume);			
				
			}			
		}
		
		
		class VolAtPriceBar//OHLC Bar
		{
			private SortedDictionary<ushort,VolumeAtPrice> list;
			private GraphicalHelper helper;		
			
			ushort maxpricetick=UInt16.MinValue;
			ushort minpricetick=UInt16.MaxValue;
			
			public VolAtPriceBar(GraphicalHelper param)
			{
				list=new SortedDictionary<ushort,VolumeAtPrice>();
				helper=param;
			}			
				
			public void AddVolume(ushort pricetick, int volume, short minute)
			{	
				if (!list.ContainsKey(pricetick))	
				{
					if (!list.ContainsKey(pricetick))
						list.Add(pricetick, new VolumeAtPrice(volume,minute));
					
					for (ushort i=1;i<=helper.nbSmooth;i++)
					{
						if (!list.ContainsKey((ushort)(pricetick+i)))
							list.Add((ushort)(pricetick+i), new VolumeAtPrice(0,minute));
						
						if (!list.ContainsKey((ushort)(pricetick-i)))
							list.Add((ushort)(pricetick-i), new VolumeAtPrice(0,minute));
					}
					
					if (pricetick>maxpricetick)
						maxpricetick=pricetick;
					
					if (pricetick<minpricetick)
						minpricetick=pricetick;	
				}
				else		
					list[pricetick].AddVolume(volume,minute);
				
			}			
			
			
			public bool isRTH (short timeclass)
			{
				return ((timeclass !=PRE_RTH) && timeclass != POST_RTH);
			}
				
			
			public void Draw(float scale, int x, Dictionary<ushort,int> lastVolumes)
			{		
				int vol2add=0;
				double divisor=1.0/((helper.nbSmooth+1)*(helper.nbSmooth+1));
				
				foreach(KeyValuePair<ushort,VolumeAtPrice> priceiterator in list)
				{
					VolumeAtPrice curlist=priceiterator.Value;
					ushort curprice=priceiterator.Key;
					
					if (!lastVolumes.ContainsKey(curprice))
						lastVolumes.Add(curprice,0);
					
					if ((helper.colorMode==GomMPColorModeEnum.NoColor) || (helper.colorMode==GomMPColorModeEnum.TimeColor))
					{	
						foreach(KeyValuePair<short,VolElement> minuteiterator in curlist.volumes)
						{		
							short curminute=minuteiterator.Key;
							VolElement curvolelt=minuteiterator.Value;
							
							if (helper.showAH ||isRTH(curminute))
							{
								Color color;
							
								if (!isRTH(curminute)||(helper.colorMode==GomMPColorModeEnum.NoColor))
									color=helper.neutralColor;
								else
									color=helper.ColorMapper[curminute*helper.minutestep];
								
								
								int totalplottedvol=0;
								
								for (ushort i=1;i<=helper.nbSmooth;i++)
								{
									vol2add  = Convert.ToInt32((double) (curvolelt.TotalVolume*(helper.nbSmooth+1-i))*divisor);
							
									
									if (!lastVolumes.ContainsKey((ushort)(curprice+i)))
										lastVolumes.Add((ushort)(curprice+i),0);
									if (!lastVolumes.ContainsKey((ushort)(curprice-i)))
										lastVolumes.Add((ushort)(curprice-i),0);
									
									helper.FillRectangle(curprice+i,color,x,lastVolumes[(ushort)(curprice+i)],vol2add,scale);
									helper.FillRectangle(curprice-i,color,x,lastVolumes[(ushort)(curprice-i)],vol2add,scale);
									
									lastVolumes[(ushort)(curprice+i)]+=vol2add;
									lastVolumes[(ushort)(curprice-i)]+=vol2add;
									
									totalplottedvol +=2*vol2add;
								
								}
								
								vol2add = curvolelt.TotalVolume-totalplottedvol;
								
								helper.FillRectangle(curprice,color,x,lastVolumes[curprice],vol2add,scale);
								
								lastVolumes[curprice]+=vol2add;									
							}
						}
					}

					if ((helper.colorMode==GomMPColorModeEnum.Delta))
					{
						int positivevolume=curlist.PositiveVolume;
						int negativevolume=curlist.NegativeVolume;
						
						if (positivevolume>negativevolume)
								helper.FillRectangle(curprice,helper.chartcontrol.UpColor, x,lastVolumes[curprice],positivevolume-negativevolume,scale);	
						if (positivevolume<negativevolume)
								helper.FillRectangle(curprice,helper.chartcontrol.DownColor, x,lastVolumes[curprice],-positivevolume+negativevolume,scale);	
								
						helper.FillRectangle(curprice,helper.neutralColor, x,lastVolumes[curprice]+Math.Abs(positivevolume-negativevolume), 2*Math.Min(negativevolume,positivevolume),scale);	
					
						vol2add=curlist.TotalVolume;	
						lastVolumes[curprice]+=vol2add;	
														
					}		
				}
			}	
		}
			
		
		class VolAtPriceBars: Dictionary<int,VolAtPriceBar> 
		{
			
			private GraphicalHelper helper;		
			
			public VolAtPriceBars(GraphicalHelper param):base()
			{
				helper=param;
			}
			
			
			public void DrawBars(int firstBar, int lastBar,float scale, int x0)
			{
				Dictionary<ushort,int> lastVolumes=new Dictionary<ushort,int>(); 
					
				for (int i= firstBar;i<=lastBar;i++)
					this[i].Draw(scale,x0,lastVolumes);		
			
			
				if ((helper.showPoc)||(helper.showVa)||(helper.showVwap))
				{
					int max=0;
					int totvol=0;
					ushort maxtick=0;
					long weightedsum=0;
					
					SortedList<ushort, int> vols=new SortedList<ushort, int>();	
						
					foreach(KeyValuePair<ushort,int> iterator in lastVolumes)
					{
	
						totvol+=iterator.Value;
						vols.Add(iterator.Key,iterator.Value);
						weightedsum+=iterator.Key*iterator.Value;
						
						if (iterator.Value>max)
						{
							max=iterator.Value;
							maxtick=iterator.Key;
						}
					}
					
					if (max>0)
					{
	
						if (helper.showVa)
						{
							int startindex=vols.IndexOfKey(maxtick);
							int lastCommittedUpPrice=startindex;
							int lastCommittedDownPrice=startindex;		
							int CommittedVolume=max;
							int Vol_70Pcent=(int)(0.7*totvol);
							
							bool overflowwith2=false;
							
							int upvol,downvol;
							
							while (CommittedVolume<Vol_70Pcent)
							{	// 2 bars
								if ((!overflowwith2) && (lastCommittedUpPrice<vols.Count-2) && (lastCommittedDownPrice>=2))
								{
									upvol=vols.Values[lastCommittedUpPrice+1]+vols.Values[lastCommittedUpPrice+2];
									downvol=vols.Values[lastCommittedDownPrice-1]+vols.Values[lastCommittedDownPrice-2];
									
									if (((CommittedVolume+upvol)>Vol_70Pcent) || ((CommittedVolume+downvol)>Vol_70Pcent))
										overflowwith2=true;
									else
									{
										if (upvol>downvol)
										{
											lastCommittedUpPrice+=2;
											CommittedVolume+=upvol;
										}
										else if (upvol<downvol)
										{
											lastCommittedDownPrice-=2;
											CommittedVolume+=downvol;
										}
										else
											if ((CommittedVolume+upvol+downvol)>Vol_70Pcent)
												overflowwith2=true;
											else
											{
												lastCommittedUpPrice+=2;
												lastCommittedDownPrice-=2;
												CommittedVolume += upvol+downvol;
											}
									}
								}
								else
								{
									if (lastCommittedUpPrice==vols.Count-1)
									{
										CommittedVolume+=vols.Values[lastCommittedDownPrice-1];
										lastCommittedDownPrice -=1;
									}
									else if (lastCommittedDownPrice==0)
									{
										CommittedVolume+=vols.Values[lastCommittedUpPrice+1];
										lastCommittedUpPrice +=1;							
									}
									else
									{
										upvol=vols.Values[lastCommittedUpPrice+1];
										downvol=vols.Values[lastCommittedDownPrice-1];
			
										if (upvol>downvol)
										{
											lastCommittedUpPrice+=1;
											CommittedVolume+=upvol;
										}
										else if (upvol<downvol)
										{
											lastCommittedDownPrice-=1;
											CommittedVolume+=downvol;
										}
										else
		
											{
												lastCommittedUpPrice+=1;
												lastCommittedDownPrice-=1;
												CommittedVolume += upvol+downvol;
											}
									}
									
									
								}
									
							}	
									
							helper.FillRectangleSpecialBars(vols.Keys[lastCommittedUpPrice],helper.colorVa, x0,(helper.allPocVolume)?max:vols.Values[lastCommittedUpPrice],scale);	

							helper.FillRectangleSpecialBars(vols.Keys[lastCommittedDownPrice],helper.colorVa, x0,(helper.allPocVolume)?max:vols.Values[lastCommittedDownPrice],scale);	
						}
						
						if ((totvol>0)&&(helper.showVwap))
						{	ushort price=Convert.ToUInt16((double)weightedsum/(double)totvol);
							if (vols.ContainsKey(price))
								helper.FillRectangleSpecialBars(price,helper.colorVwap, x0,(helper.allPocVolume)?max:vols[price],scale);	
						}
						
						if (helper.showPoc)
							helper.FillRectangleSpecialBars(maxtick,helper.colorPoc, x0,max,scale);	

					}	
					
				}
				
			}
			
		}
		
					
		class GraphicalHelper
		{
			public Graphics graphics;
			public ChartControl chartcontrol;
			public double min,max;
			public double TickSize;
			public Rectangle bounds;
			public int BarSpacing=0;
			public Color[] ColorMapper=new Color[1440]; 
			public bool showAH=true;
			public Color neutralColor=Color.Black;
			public short alpha=128;
			public bool showall=true;
			public bool dailyBarMode=true;
			public int minutestep=15;
			public double starthue=0;
			public double endhue=360;
			public Indicator indic;
			public GomMPColorModeEnum colorMode=GomMPColorModeEnum.TimeColor;
			public int rthlengthminutes;
			public bool rtl=false;
			public bool showPoc=true;
			public bool showVa=true;
			public bool showVwap=true;
			public bool showLastPrice=true;
			public int pocSize=3;
			public bool allPocVolume=true;
			public Color colorPoc=Color.Red;
			public Color colorVa=Color.Blue;			
			public Color colorVwap=Color.Green;
			public ushort accCount=1;
			public ushort nbSmooth=0;
			
			static public int bool2int(bool param)
			{
				if (param) return 1; else return -1;	
			}
			
			static private  Color ColorFromHSV(double hue)
			{
				int hi = Convert.ToInt32(Math.Floor(hue / 60)) % 6;
				double f = hue / 60 - Math.Floor(hue / 60);
			
				int v = 255;
				int p = 0;
				int q = Convert.ToInt32(255 * (1 - f));
				int t = Convert.ToInt32(255 * f);
			
				if (hi == 0) return Color.FromArgb(255, v, t, p);
				else if (hi == 1) return Color.FromArgb(255, q, v, p);
				else if (hi == 2) return Color.FromArgb(255, p, v, t);
				else if (hi == 3) return Color.FromArgb(255, p, q, v);
				else if (hi == 4) return Color.FromArgb(255, t, p, v);
				else return Color.FromArgb(255, v, p, q);
			}
			
			
			public void FillRectangle(int priceTick,Color color,float x0, int initialvolume,int volume,float scale)
			{
				double priceLower = ((double)priceTick-0.5)*TickSize ; //;- GHelper.TickSize / 2;
				float yLower = GetYPos(priceLower);
				float yUpper = GetYPos(priceLower+ TickSize);
				float height = Math.Max(1, Math.Abs(yUpper - yLower)-BarSpacing );
				
				if (!rtl)
					graphics.FillRectangle(new SolidBrush(Color.FromArgb(alpha,color)), x0+initialvolume*scale, yUpper, volume*scale, height);
				else
					graphics.FillRectangle(new SolidBrush(Color.FromArgb(alpha,color)), x0-(initialvolume+volume)*scale, yUpper, volume*scale, height);				
			}
			
			public void FillRectangleSpecialBars(int priceTick,Color color,float x0,int volume,float scale)
			{
				double priceLower = ((double)priceTick-0.5)*TickSize ; 
				float yLower = GetYPos(priceLower);
				float yUpper = GetYPos(priceLower+ TickSize);
				float height = Math.Max(1, Math.Abs(yUpper - yLower)-BarSpacing );
				
				if (height<pocSize)
				{
					yUpper=GetYPos(priceTick*TickSize)-(float)Math.Ceiling(pocSize/2.0F);
					height=pocSize;
				}
				
					
				if (!rtl)
					graphics.FillRectangle(new SolidBrush(color), x0, yUpper, volume*scale, height);
				else
					graphics.FillRectangle(new SolidBrush(color), x0-volume*scale, yUpper, volume*scale, height);				
			}
			
			
			 public float GetYPos(double price)
			{
				#if NT7
					return chartcontrol.GetYByValue(indic, price);
				#else			
					return (float) ((bounds.Y + bounds.Height) - 
						((price - min) / ChartControl.MaxMinusMin(max, min)) * bounds.Height);
				#endif
			}
					
			
			public void ComputeColorMapper()
			{
				double hue;
				
				int nbclasses=rthlengthminutes/minutestep;
				
				if (nbclasses*minutestep<rthlengthminutes) 
					nbclasses++;
				
				double step=(endhue-starthue)/(nbclasses-1);
				
				for (int j=0;j<rthlengthminutes;j++)
				{
				 	hue=starthue+(j/minutestep)*step;
					
					if (hue>359) hue-=360;
					if (hue<0) hue +=360;				
					
					ColorMapper[j]=ColorFromHSV(hue);
				}
			}		
		}
		
		protected int startbar=-1;
		protected int lastcalcbar=-1;
		bool firstinitdone=false;
		System.Windows.Forms.KeyEventHandler keyEvtH;
			
		VolAtPriceBars barvols;
		
		private List<int> sessions=new List<int>();
		
		VolAtPriceBar curvolatprice;
			
		private TimeSpan startTime=new TimeSpan(15,30,00);
		private int starttimeminutes;
		
		private TimeSpan rthLength=new TimeSpan(6,45,00);
		
		private DateTime curDay;
  
		public float scale=0.005F; 
		
		GraphicalHelper GHelper=new GraphicalHelper();
		
		private void chart_KeyDown (object sender, KeyEventArgs e)
		{
			
			if (e.KeyCode==Keys.Space)
				GHelper.showAH=!GHelper.showAH;
			
			if (e.KeyCode==Keys.Multiply)
				GHelper.showall=!GHelper.showall;
			
			if (e.KeyCode==Keys.Divide)
				GHelper.dailyBarMode=!GHelper.dailyBarMode;
			
			if (e.KeyCode==Keys.Add)
			{	
				if (e.Modifiers==Keys.Control)
					GHelper.nbSmooth++;
				else if (e.Modifiers==Keys.Alt)
					GHelper.accCount++;
				else
					scale *= 1.1F;

			}
			
			if (e.KeyCode==Keys.Subtract)
			{
				if (e.Modifiers==Keys.Control)
				{
					if (GHelper.nbSmooth>0)
						GHelper.nbSmooth--;
				}
				else if (e.Modifiers==Keys.Alt)
				{
					if (GHelper.accCount>1)
					GHelper.accCount--;

				}			
				else 
				{
					scale *= 0.9F;	
				}
			}
					
			if (e.KeyCode==Keys.Decimal)
			{
				if (GHelper.colorMode>=GomMPColorModeEnum.Delta)
					GHelper.colorMode=GomMPColorModeEnum.NoColor;
				else	
					GHelper.colorMode++;
			}
		}
		
        protected override void GomInitialize()
        {
            CalculateOnBarClose	= false;
            Overlay				= true;
            PriceTypeSupported	= false;
			
			starttimeminutes=(int)startTime.TotalMinutes;
			GHelper.rthlengthminutes=(int)rthLength.TotalMinutes;
			
			GHelper.ComputeColorMapper();
			
			barvols=new VolAtPriceBars(GHelper);
			
			sessions.Add(0);
			
		}
				
		
        protected override void GomOnBarUpdate()
        {
			
			if (curDay.Ticks==0L)
				curDay=Time[0].Date;
			
			if ((lastcalcbar<CurrentBar)) 
			{
				barvols.Add(CurrentBar,new VolAtPriceBar(GHelper));
				curvolatprice=barvols[CurrentBar];
			}
						
			
			if (Bars.SessionBreak)
				sessions.Add(CurrentBar);
				
			if (startbar==-1)
				startbar=CurrentBar;
			
			lastcalcbar=CurrentBar;
        }

		
		protected override void GomOnMarketDataWithTime(DateTime tickTime,TickTypeEnum tickType,double price,int volume,bool firstTickOfBar)	
		{
			
			if (volume==0) return;
			
			short minute=Convert.ToInt16(Math.Floor((tickTime-curDay).TotalMinutes)-starttimeminutes);
			
			if (minute > GHelper.rthlengthminutes)
				curDay=tickTime.Date;
				
			short timeclass;
				if (minute<0) 
					timeclass=PRE_RTH;
				else if (minute >= GHelper.rthlengthminutes)
					timeclass=POST_RTH;
				else
					timeclass=Convert.ToInt16(minute/GHelper.minutestep);

						
			curvolatprice.AddVolume(Convert.ToUInt16(price/Bars.Instrument.MasterInstrument.TickSize),CalcDelta(tickType,price,volume),timeclass);

		}

		
		private int GetXPos(int barNum)
		{
			#if NT7 
				return ChartControl.GetXByBarIdx(BarsArray[0],barNum);
			#else
				return ChartControl.GetXByBarIdx(barNum);
			#endif
		}
	
		
		public override void Plot(Graphics graphics, Rectangle bounds, double min, double max)
		{

			GHelper.chartcontrol=ChartControl;
			GHelper.graphics=graphics;
			GHelper.max=max;
			GHelper.min=min;
			GHelper.TickSize=Bars.Instrument.MasterInstrument.TickSize;
			GHelper.bounds=bounds;
			GHelper.indic=this;
						
			if (Bars==null)	return;

			#if NT7
				int lastBar		= Math.Min(this.LastBarIndexPainted, Bars.Count - 1);
				int firstBar	= this.FirstBarIndexPainted;
			#else
				int lastBar		= Math.Min(ChartControl.LastBarPainted, Bars.Count - 1);
				int firstBar	= Math.Max((lastBar - ChartControl.BarsPainted) + 1,0);
			#endif
								
			
			if (!firstinitdone)
			{	
				firstinitdone=true;
				keyEvtH=new System.Windows.Forms.KeyEventHandler(this.chart_KeyDown);				
				this.ChartControl.ChartPanel.KeyDown += keyEvtH;
			}			
			
			int x0;
			SortedDictionary <ushort,int> lastvol=new SortedDictionary <ushort,int>();
			
			//last daily profile
			if ((!GHelper.showall)&&(GHelper.dailyBarMode))
			{
				int lastsessionindex=sessions.Count;
				
				do
				{
					lastsessionindex--;
				}while ((sessions[lastsessionindex]>lastBar)&&(lastsessionindex>0));
				

				int startsession=Math.Max(0,lastsessionindex-(GHelper.accCount-1));
				
				if (!GHelper.rtl)
					barvols.DrawBars(sessions[startsession],lastBar,scale,bounds.Left);
				else
					barvols.DrawBars(sessions[startsession],lastBar,scale,bounds.Right);
			}
			
			
			//last Bar profile
			if ((!GHelper.showall)&&(!GHelper.dailyBarMode))
			{
				int startbar=Math.Max(0,lastBar-(GHelper.accCount-1));
				if (!GHelper.rtl)
					barvols.DrawBars(startbar,lastBar,scale,bounds.Left);
				else
					barvols.DrawBars(startbar,lastBar,scale,bounds.Right);
			}
			
			//all daily profiles
			if ((GHelper.showall)&&(GHelper.dailyBarMode))
			{			
				int firstsessionindex=-1;
			
				do
				{
					firstsessionindex++;
				}while ((sessions[firstsessionindex]<firstBar)&&(firstsessionindex<(sessions.Count-1)));

				if ((firstsessionindex>0) && ((sessions[firstsessionindex]>lastBar)||GHelper.rtl))
					firstsessionindex--;
				
				do
				{	
					if (sessions[firstsessionindex]<lastBar)
					{
						if (!GHelper.rtl)
							x0=Math.Max(GetXPos(sessions[firstsessionindex]),bounds.Left);
						else
						{	
							if ((firstsessionindex==(sessions.Count-1))||(sessions[firstsessionindex+1]>lastBar))
								x0=bounds.Right;
							else
								x0=GetXPos(sessions[firstsessionindex+1]);
						}
						
						int startsession=Math.Max(0,firstsessionindex-(GHelper.accCount-1));
						
						if (firstsessionindex<(sessions.Count-1))
							barvols.DrawBars(sessions[startsession],Math.Min(sessions[firstsessionindex+1],lastBar),scale/5.0F,x0);
						else
							barvols.DrawBars(sessions[startsession],lastBar,scale/5.0F,x0);						
					}
					firstsessionindex++;
				}while (firstsessionindex<sessions.Count) ;
			}
			
			//all bar profiles
			if ((GHelper.showall)&&(!GHelper.dailyBarMode))
			{
				for (int j=firstBar;j<=lastBar;j++)
				{						
					x0=GetXPos(j)+((GHelper.rtl)?-1:1)*2;		
					barvols.DrawBars(Math.Max(0,j-(GHelper.accCount-1)),j,scale/5.0F,x0);
					}		
			
			}
		}
		
	
		public override void Dispose()
        {
			if (keyEvtH != null)
			{	
				this.ChartControl.ChartPanel.KeyDown -= keyEvtH;
			   	keyEvtH=null;
			}
				base.Dispose();
		}
		
        #region Properties

		
		[Description("RTH Start Time")]
        [Category("1. Timing Settings")]
		[Gui.Design.DisplayNameAttribute("1. RTH Start Time")]
		[XmlIgnore()]
        public TimeSpan StartTime
        {
            get { return startTime; }
            set { startTime = value;
				  starttimeminutes=(int)startTime.TotalMinutes;
				}
        }
		
		[Browsable(false)]
		public string StartTimeSerialize
			{
    			get { return startTime.ToString(); }
     			set { startTime = TimeSpan.Parse(value); }
			}
			
		[Description("RTH Session Length")]
        [Category("1. Timing Settings")]
		[Gui.Design.DisplayNameAttribute("2. RTH Session Length")]
		[XmlIgnore()]
        public TimeSpan RTHLength
        {
            get { return rthLength; }
            set { 
					rthLength = value; 
					GHelper.rthlengthminutes=(int)rthLength.TotalMinutes;
					GHelper.ComputeColorMapper();
				}
        }
		
		[Browsable(false)]
		public string RTHLengthSerialize
			{
    			get { return rthLength.ToString(); }
     			set { rthLength = TimeSpan.Parse(value); }
			}
			
		[Description("Show AH trades. Can be toggled using space bar")]
        [Category("1. Timing Settings")]
		[Gui.Design.DisplayNameAttribute("3. Show AH Trades")]
        public bool ShowAH
        {
            get { return GHelper.showAH; }
            set { GHelper.showAH = value; }
        }	
			
		[XmlIgnore()]
		[Description("Neutral Color. Used as a clor for AH and if fancy colors is disabled")]
		[Category("3. Color Management")]
		[Gui.Design.DisplayName("1. Neutral Color")]
		
		public Color NeutralColor
		{
			get { return GHelper.neutralColor; }
			set {  GHelper.neutralColor=value;}
		}
		
		[Browsable(false)]
		public string NeutralColorSerialize
			{
    			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(GHelper.neutralColor); }
     			set { GHelper.neutralColor = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
			}

		[Description("Alpha Channel for the color. 0-255 (0= full transparent, 255= full opacity")]
		[Category("3. Color Management")]
		[Gui.Design.DisplayNameAttribute("2. Alpha")]
        public short Alpha
        {
            get { return GHelper.alpha; }
            set { 
					GHelper.alpha = value;
					GHelper.ComputeColorMapper();
				}
        }
		
		[Description("Color Mode. Time Based color change, Delta and NoColor. Can be toggled using . Key")]
		[Category("0. Main Settings")]
		[Gui.Design.DisplayNameAttribute("1. Color Bar Mode")]
        public GomMPColorModeEnum ColorMode
        {
            get { return GHelper.colorMode; }
            set { GHelper.colorMode = value; }
        }
		
		[Description("Show All Bars. If true, will show all bar profile or all daily profile. If false, will only show latest bar or day, on the left of the chart. Can be toggled using * key")]
		[Category("0. Main Settings")]
		[Gui.Design.DisplayNameAttribute("3. Show All Bars")]
        public bool ShowAll
        {
            get { return GHelper.showall; }
            set { GHelper.showall = value; }
        }
		
		[Description("Daily Bar Mode. If false, profiles are displayed bar by bar. If true, profiles are daily. Can be toggled using / key")]
		[Category("0. Main Settings")]
		[Gui.Design.DisplayNameAttribute("2. Daily Bar Mode")]
        public bool DailyBarMode
        {
            get { return GHelper.dailyBarMode; }
            set { GHelper.dailyBarMode = value; }
        }
	
		[Description("Days/Bars to accumulate. Can be incremented/decremented using Alt + and Alt - keys")]
		[Category("0. Main Settings")]
		[Gui.Design.DisplayNameAttribute("3. Days/Bars to accumulate")]
        public ushort AccCount
        {
            get { return GHelper.accCount; }
            set { if (value>0) GHelper.accCount = value; }
        }
		
		[Description("Number of smoothing bars. Can be toggled using Ctrl + and Ctrl -")]
		[Category("0. Main Settings")]
		[Gui.Design.DisplayNameAttribute("4. Nb smoothing bars")]
        public ushort NbSmooth
        {
            get { return GHelper.nbSmooth; }
            set { if (value>=0) GHelper.nbSmooth = value; }
        }
		
		
		[Description("Spacing between the volume bars.")]
		[Category("2. Display Settings")]
		[Gui.Design.DisplayNameAttribute("1. Bar spacing")]
		public int BarSpacing
		{
			get { return GHelper.BarSpacing; }
			set 
			{ 
				GHelper.BarSpacing = Math.Min(5, Math.Max(0,  value));
			}
		}
		
			
		[Description("RTL Mode : If true Right to Left, if false Left To Right")]
		[Category("2. Display Settings")]
		[Gui.Design.DisplayNameAttribute("2. Right To Left")]
        public bool RTL
        {
            get { return GHelper.rtl; }
            set { GHelper.rtl = value; }
        }
		
		
		
		[Description("Plotting Scale. Determines lengths of bars. Can be modified using + and - keys")]
		[Category("2. Display Settings")]
		[Gui.Design.DisplayNameAttribute("3. Plotting Scale")]
        public float Scale
        {
            get { return scale; }
            set { scale = value; }
        }
		
		
		[Description("Show POC")]
		[Category("2. Display Settings")]
		[Gui.Design.DisplayNameAttribute("4. Show POC")]
        public bool ShowsPOC
        {
            get { return GHelper.showPoc; }
            set { GHelper.showPoc = value; }
        }
		
		[Description("Show VA")]
		[Category("2. Display Settings")]
		[Gui.Design.DisplayNameAttribute("5. Show VA")]
        public bool ShowsVA
        {
            get { return GHelper.showVa; }
            set { GHelper.showVa = value; }
        }
		
		[Description("Show VWAP")]
		[Category("2. Display Settings")]
		[Gui.Design.DisplayNameAttribute("6. Show VWAP")]
        public bool ShowsVWAP
        {
            get { return GHelper.showVwap; }
            set { GHelper.showVwap = value; }
        }

		[Description("Minimum size of POC bar and others (vwap etc)")]
		[Category("2. Display Settings")]
		[Gui.Design.DisplayNameAttribute("8. POC etc bar min height")]
        public int PocSize
        {
            get { return GHelper.pocSize; }
            set { 
					if (value>0)
					GHelper.pocSize = value; 
			}
        }
		
		[Description("Make all special bars POC size")]
		[Category("2. Display Settings")]
		[Gui.Design.DisplayNameAttribute("9.All bars POC size")]
        public bool AllPocVolume
        {
            get { return GHelper.allPocVolume; }
            set { GHelper.allPocVolume = value; }
        }
		
		
		[Description("Color Resolution in minutes (must be >=1). If set to 15, there is one different color every 15 minutes. Lowering the setting will increase color smoothness but will increase memory footprint ")]
		[Category("3. Color Management")]
		[Gui.Design.DisplayNameAttribute("4. Color Resolution")]
        public int MinuteStep
        {
            get { return GHelper.minutestep; }
            set {  
					GHelper.minutestep = value; 
				    GHelper.ComputeColorMapper();
				}
        }
		
		[Description("Starting Color Hue. Must be between 0-360 (see Wikipedia on color Hue")]
		[Category("3. Color Management")]
		[Gui.Design.DisplayNameAttribute("5. Starting Hue")]
        public double StartHue
        {
            get { return GHelper.starthue; }
            set {  
					GHelper.starthue = value; 
					GHelper.ComputeColorMapper();
       			 }
		}
		
		[Description("Ending Color Hue. Must be between 0-360 (see Wikipedia on color Hue")]        
		[Category("3. Color Management")]
		[Gui.Design.DisplayNameAttribute("6. Ending Hue")]
        public double EndHue
        {
            get { return GHelper.endhue; }
            set { 
					GHelper.endhue= value; 
					GHelper.ComputeColorMapper();
				}
        }
		
		
		
		[Description("POC Color")]        
		[Category("3. Color Management")]
		[Gui.Design.DisplayNameAttribute("7. POC Color")]
		[XmlIgnore()]	
		public Color ColorPOC
		{
			get { return GHelper.colorPoc; }
			set {  GHelper.colorPoc=value; }
		}
			
		[Browsable(false)]
		public string ColorPOCSerialize
			{
    			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(GHelper.colorPoc); }
     			set { GHelper.colorPoc = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
			}

		[Description("VA Color")]        
		[Category("3. Color Management")]
		[Gui.Design.DisplayNameAttribute("8. VA Color")]
		[XmlIgnore()]	
		public Color ColorVA
		{
			get { return GHelper.colorVa; }
			set {  GHelper.colorVa=value; }
		}
			
		[Browsable(false)]
		public string ColorVASerialize
			{
    			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(GHelper.colorVa); }
     			set { GHelper.colorVa = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
			}
			
		[Description("VWAP Color")]        
		[Category("3. Color Management")]
		[Gui.Design.DisplayNameAttribute("9. VWAP Color")]
		[XmlIgnore()]	
		public Color ColorVWAP
		{
			get { return GHelper.colorVwap; }
			set {  GHelper.colorVwap=value; }
		}
			
		[Browsable(false)]
		public string ColorVWAPSerialize
			{
    			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(GHelper.colorVwap); }
     			set { GHelper.colorVwap = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
			}
		
        #endregion
    }
}

public enum GomMPColorModeEnum
	{
		NoColor,
		TimeColor,
		Delta
	}
	


#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private GomMP[] cacheGomMP = null;

        private static GomMP checkGomMP = new GomMP();

        /// <summary>
        /// Downloaded from http://www.brokerfib.ru/
        /// </summary>
        /// <returns></returns>
        public GomMP GomMP()
        {
            return GomMP(Input);
        }

        /// <summary>
        /// Downloaded from http://www.brokerfib.ru/
        /// </summary>
        /// <returns></returns>
        public GomMP GomMP(Data.IDataSeries input)
        {
            if (cacheGomMP != null)
                for (int idx = 0; idx < cacheGomMP.Length; idx++)
                    if (cacheGomMP[idx].EqualsInput(input))
                        return cacheGomMP[idx];

            lock (checkGomMP)
            {
                if (cacheGomMP != null)
                    for (int idx = 0; idx < cacheGomMP.Length; idx++)
                        if (cacheGomMP[idx].EqualsInput(input))
                            return cacheGomMP[idx];

                GomMP indicator = new GomMP();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                Indicators.Add(indicator);
                indicator.SetUp();

                GomMP[] tmp = new GomMP[cacheGomMP == null ? 1 : cacheGomMP.Length + 1];
                if (cacheGomMP != null)
                    cacheGomMP.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheGomMP = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Downloaded from http://www.brokerfib.ru/
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.GomMP GomMP()
        {
            return _indicator.GomMP(Input);
        }

        /// <summary>
        /// Downloaded from http://www.brokerfib.ru/
        /// </summary>
        /// <returns></returns>
        public Indicator.GomMP GomMP(Data.IDataSeries input)
        {
            return _indicator.GomMP(input);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Downloaded from http://www.brokerfib.ru/
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.GomMP GomMP()
        {
            return _indicator.GomMP(Input);
        }

        /// <summary>
        /// Downloaded from http://www.brokerfib.ru/
        /// </summary>
        /// <returns></returns>
        public Indicator.GomMP GomMP(Data.IDataSeries input)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.GomMP(input);
        }
    }
}
#endregion
