#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Enter the description of your new custom indicator here
    /// </summary>
    [Description("Enter the description of your new custom indicator here")]
    public class GomVWAP : GomRecorderIndicator
    {
        #region Variables
			
		int totvol=0;
		double pondprice=0;  
		
		TimeSpan resetTime;
		DateTime lastResetDate=new DateTime(0L);
		
		double curVWAP=0.0f;

		
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void GomInitialize()
        {
            Add(new Plot(Color.Orange,"VWAP"));
			
            CalculateOnBarClose	= false;
            Overlay				= true;
            PriceTypeSupported	= false;
			
        }
		
		private void PlotChart()		
		{
			if (totvol>0)
				VWAP.Set(curVWAP);
		}
				
        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void GomOnBarUpdate()
        {	
			PlotChart();
        }
			
		
		protected override void GomOnMarketDataWithTime(DateTime tickTime,TickTypeEnum tickType,double price,int volume,bool firstTickOfBar)	
		{				
			if ((tickTime.TimeOfDay>=resetTime) && (tickTime.Date > lastResetDate))
			{
				totvol=0;
				pondprice=0;
				lastResetDate=tickTime.Date;
			}
						
			totvol+=volume;
			pondprice+=price*volume;
			
			curVWAP=pondprice/(double)totvol;

			PlotChart();			
		
		}

       #region Properties
       [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries VWAP
        {
            get { return Values[0]; }
        }
		
		[Description("Reset Time")]
        [Category("Parameters")]
		[Gui.Design.DisplayNameAttribute("Reset Time")]
		[XmlIgnore()]
        public TimeSpan ResetTime
        {
            get { return resetTime; }
            set { resetTime = value; }
        }
		
		[Browsable(false)]
		public string ResetTimeSerialize
			{
    			get { return resetTime.ToString(); }
     			set { resetTime = TimeSpan.Parse(value); }
			}
		
       #endregion
    }
}
		
#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private GomVWAP[] cacheGomVWAP = null;

        private static GomVWAP checkGomVWAP = new GomVWAP();

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public GomVWAP GomVWAP(TimeSpan resetTime)
        {
            return GomVWAP(Input, resetTime);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public GomVWAP GomVWAP(Data.IDataSeries input, TimeSpan resetTime)
        {
            if (cacheGomVWAP != null)
                for (int idx = 0; idx < cacheGomVWAP.Length; idx++)
                    if (cacheGomVWAP[idx].ResetTime == resetTime && cacheGomVWAP[idx].EqualsInput(input))
                        return cacheGomVWAP[idx];

            lock (checkGomVWAP)
            {
                checkGomVWAP.ResetTime = resetTime;
                resetTime = checkGomVWAP.ResetTime;

                if (cacheGomVWAP != null)
                    for (int idx = 0; idx < cacheGomVWAP.Length; idx++)
                        if (cacheGomVWAP[idx].ResetTime == resetTime && cacheGomVWAP[idx].EqualsInput(input))
                            return cacheGomVWAP[idx];

                GomVWAP indicator = new GomVWAP();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.ResetTime = resetTime;
                Indicators.Add(indicator);
                indicator.SetUp();

                GomVWAP[] tmp = new GomVWAP[cacheGomVWAP == null ? 1 : cacheGomVWAP.Length + 1];
                if (cacheGomVWAP != null)
                    cacheGomVWAP.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheGomVWAP = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.GomVWAP GomVWAP(TimeSpan resetTime)
        {
            return _indicator.GomVWAP(Input, resetTime);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.GomVWAP GomVWAP(Data.IDataSeries input, TimeSpan resetTime)
        {
            return _indicator.GomVWAP(input, resetTime);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.GomVWAP GomVWAP(TimeSpan resetTime)
        {
            return _indicator.GomVWAP(Input, resetTime);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.GomVWAP GomVWAP(Data.IDataSeries input, TimeSpan resetTime)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.GomVWAP(input, resetTime);
        }
    }
}
#endregion
