#region Using declarations
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
using SharpDX;
using SharpDX.Direct2D1;
using System;

//added
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Xml.Serialization;
using NinjaTrader.Gui;
#endregion

//This namespace holds Chart styles in this folder and is required. Do not change it. 
namespace NinjaTrader.NinjaScript.ChartStyles
{
	public class GradientBar : ChartStyle
	{
		private object icon;
		
		
		
		protected override void OnStateChange()
		{
			if (State == State.SetDefaults)
			{
				Description									= @"Enter the description for your new custom Chart style here.";
				Name										= "Gradient Bar";
				ChartStyleType								= (ChartStyleType) 4277;
				BarWidth									= 2;
				
				this.StartClr		= System.Windows.Media.Brushes.PaleGreen;
				this.EndClr 		= System.Windows.Media.Brushes.Green;
				
				this.StartClr2		= System.Windows.Media.Brushes.MistyRose;
				this.EndClr2 		= System.Windows.Media.Brushes.Red;
				
				Opacity				= 100;
				
				this.UpOutBrush 	= System.Windows.Media.Brushes.DarkGreen;
				this.DnOutBrush 	= System.Windows.Media.Brushes.Red;
				
				WidthOutline		= 1f;
			}
			else if (State == State.Configure)
			{
				Properties.Remove(Properties.Find("Stroke", true));
				Properties.Remove(Properties.Find("Stroke2", true));
				Properties.Remove(Properties.Find("DownBrush", true));
				Properties.Remove(Properties.Find("UpBrush", true));
			}
			
		}

		public override bool IsTransparent { get { return false; } } // replace with your logic to check if entire style is transparent

		public override int GetBarPaintWidth(int barWidth)
		{
			return 1 + 2 * (barWidth - 1) + 2 * (int) Math.Round(Stroke.Width);
		}

		public override object Icon
		{
			get
			{
				if (icon == null)
				{
					icon = NinjaTrader.Gui.Tools.Icons.ChartChartStyle;
				}
				return icon;
			}
		}
		
		private SharpDX.Color ToDxColor(System.Windows.Media.Brush brush)
        {
            System.Windows.Media.Color tempColor = ((System.Windows.Media.SolidColorBrush) brush).Color;
            return new SharpDX.Color()
            {
                A = tempColor.A,
                B = tempColor.B,
                G = tempColor.G,
                R = tempColor.R
            };
        }
		
		public override void OnRender(ChartControl chartControl, ChartScale chartScale, ChartBars chartBars)
		{
			Bars			bars			= chartBars.Bars;
			float			barWidth		= GetBarPaintWidth(BarWidthUI);
			Vector2			point0			= new Vector2();
			Vector2			point1			= new Vector2();
			RectangleF		rect			= new RectangleF();

			for (int idx = chartBars.FromIndex; idx <= chartBars.ToIndex; idx++)
			{
				Brush		overriddenBarBrush		= chartControl.GetBarOverrideBrush(chartBars, idx);
				Brush		overriddenOutlineBrush	= chartControl.GetCandleOutlineOverrideBrush(chartBars, idx);
				double		closeValue				= bars.GetClose(idx);
				float		close					= chartScale.GetYByValue(closeValue);
				float		high					= chartScale.GetYByValue(bars.GetHigh(idx));
				float		low						= chartScale.GetYByValue(bars.GetLow(idx));
				double		openValue				= bars.GetOpen(idx);
				float		open					= chartScale.GetYByValue(openValue);
				float		x						= chartControl.GetXByBarIndex(chartBars, idx);

				BrushProperties bpRange=new BrushProperties();
					bpRange.Opacity=1;
					SharpDX.Direct2D1.SolidColorBrush sbR=new SharpDX.Direct2D1.SolidColorBrush(RenderTarget,SharpDX.Color.Black,bpRange);
					
					if (closeValue < openValue)
						sbR.Color=ToDxColor(DnOutBrush);
					else
						sbR.Color=ToDxColor(UpOutBrush);
					
				if (Math.Abs(open - close) < 0.0000001)
				{
					// Line 
					point0.X = x - barWidth * 0.5f;
					point0.Y = close;
					point1.X = x + barWidth * 0.5f;
					point1.Y = close;
					TransformBrush(overriddenOutlineBrush ?? Stroke.BrushDX, new RectangleF(point0.X, point0.Y - Stroke.Width, barWidth, Stroke.Width));
					RenderTarget.DrawLine(point0, point1, overriddenOutlineBrush ?? Stroke.BrushDX, Stroke.Width, Stroke.StrokeStyle);
				}
				else
				{
					// Candle
					Brush brush	= closeValue >= openValue ? UpBrushDX : DownBrushDX;
					rect.X		= x - barWidth * 0.5f + 0.5f;
					rect.Y		= Math.Min(close, open);
					rect.Width	= barWidth - 1;
					rect.Height	= Math.Max(open, close) - Math.Min(close, open);
					TransformBrush(overriddenBarBrush ?? brush, rect);
					TransformBrush(overriddenOutlineBrush ?? Stroke.BrushDX, rect);
					
					System.Windows.Media.Brush Start=StartClr;
					System.Windows.Media.Brush End=EndClr;
					if (closeValue < openValue)
					{
						Start=StartClr2;
						End=EndClr2;
					}
					
					SharpDX.Direct2D1.LinearGradientBrush  linearGradientBrush = new SharpDX.Direct2D1.LinearGradientBrush(RenderTarget, 
						new SharpDX.Direct2D1.LinearGradientBrushProperties()
					{
						StartPoint = new SharpDX.Vector2(rect.X, 0),
						EndPoint = new SharpDX. Vector2(rect.X+rect.Width, 0),
					},
					new 	SharpDX.Direct2D1.GradientStopCollection(RenderTarget, new SharpDX.Direct2D1.GradientStop[]
					{
						new	SharpDX.Direct2D1. GradientStop()
						{
							Color = ToDxColor(Start),
							Position = 0,
						},
						new 	SharpDX.Direct2D1. GradientStop()
						{
							Color = ToDxColor(End),
							Position = 1,
						}
					}));
					linearGradientBrush.Opacity	= Opacity * 0.01f;
					RenderTarget.FillRectangle(rect, linearGradientBrush);
					
					
					
					RenderTarget.DrawRectangle(rect, sbR, WidthOutline);
					

				}

				// High wick
				if (high < Math.Min(open, close))
				{
					point0.X = x;
					point0.Y = high;
					point1.X = x;
					point1.Y = Math.Min(open, close);
					TransformBrush(overriddenOutlineBrush ?? Stroke2.BrushDX, new RectangleF(point0.X - Stroke2.Width, point0.Y, Stroke2.Width, point1.Y - point0.Y));
					RenderTarget.DrawLine(point0, point1, sbR,WidthOutline);//Stroke2.Width, Stroke2.StrokeStyle);
				}

				// Low wick
				if (low > Math.Max(open, close))
				{
					point0.X = x;
					point0.Y = low;
					point1.X = x;
					point1.Y = Math.Max(open, close);
					TransformBrush(overriddenOutlineBrush ?? Stroke2.BrushDX, new RectangleF(point1.X - Stroke2.Width, point1.Y, Stroke2.Width, point0.Y - point1.Y));
					RenderTarget.DrawLine(point0, point1, sbR,WidthOutline);//, Stroke2.Width, Stroke2.StrokeStyle);
				}
			}
		}


		#region Properties
		[Range(1.0f, 20.0f),NinjaScriptProperty]
		[Display(Name="Outline width", Description="Outline width.", Order=6, GroupName="Chart Style")]
		public float WidthOutline
		{ get; set; }
		
		[XmlIgnore]
		[Display(Name="Colors - Down bar outline", Description="Outline color of down bar", Order=5, GroupName="Chart Style")]
		public System.Windows.Media.Brush DnOutBrush
		{ get; set; }

		[Browsable(false)]
		public string DnOutBrushSerializable
		{
			get { return Serialize.BrushToString(DnOutBrush); }
			set { DnOutBrush = Serialize.StringToBrush(value); }
		}
		
		[XmlIgnore]
		[Display(Name="Colors - Up bar outline", Description="Outline color of up bar", Order=6, GroupName="Chart Style")]
		public System.Windows.Media.Brush UpOutBrush
		{ get; set; }

		[Browsable(false)]
		public string UpOutBrushSerializable
		{
			get { return Serialize.BrushToString(UpOutBrush); }
			set { UpOutBrush = Serialize.StringToBrush(value); }
		}
		
		[Range(0, 100),NinjaScriptProperty]
		[Display(Name="Opacity % (0-100)", Description="Opacity of bar.", Order=7, GroupName="Chart Style")]
		public int Opacity
		{ get; set; }
		
		/*
		[NinjaScriptProperty]
		[Browsable(false)]
		[Range(1, int.MaxValue)]
		[Display(Name="C", Order=1, GroupName="Parameters")]
		public int C
		{ get; set; }
		*/
		[XmlIgnore]
		[Display(Name="Start gradient Up bars", Description="", Order=1, GroupName="Chart Style")]
		public System.Windows.Media.Brush StartClr
		{ get; set; }

		[Browsable(false)]
		public string StartClrSerializable
		{
			get { return Serialize.BrushToString(StartClr); }
			set { StartClr = Serialize.StringToBrush(value); }
		}
		
		[XmlIgnore]
		[Display(Name="End gradient Up bars", Description="", Order=2, GroupName="Chart Style")]
		public System.Windows.Media.Brush EndClr
		{ get; set; }

		[Browsable(false)]
		public string EndClrSerializable
		{
			get { return Serialize.BrushToString(EndClr); }
			set { EndClr = Serialize.StringToBrush(value); }
		}
		
		
		
		[XmlIgnore]
		[Display(Name="Start gradient Down bars", Description="", Order=3, GroupName="Chart Style")]
		public System.Windows.Media.Brush StartClr2
		{ get; set; }

		[Browsable(false)]
		public string StartClr2Serializable
		{
			get { return Serialize.BrushToString(StartClr2); }
			set { StartClr2 = Serialize.StringToBrush(value); }
		}
		
		[XmlIgnore]
		[Display(Name="End gradient Down bars", Description="", Order=4, GroupName="Chart Style")]
		public System.Windows.Media.Brush EndClr2
		{ get; set; }

		[Browsable(false)]
		public string EndClr2Serializable
		{
			get { return Serialize.BrushToString(EndClr2); }
			set { EndClr2 = Serialize.StringToBrush(value); }
		}
		#endregion

	}
}
