//
// Copyright (C) 2006, NinjaTrader LLC <ninjatrader@ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private ctsPriceLevelAlert[] cachectsPriceLevelAlert = null;

        private static ctsPriceLevelAlert checkctsPriceLevelAlert = new ctsPriceLevelAlert();

        /// <summary>
        /// Alert via sound and/or email when price levels are hit
        /// </summary>
        /// <returns></returns>
        public ctsPriceLevelAlert ctsPriceLevelAlert(bool logToOutputWindow, string marker, Color markerColor, int maxAlertNumberPerBar, double priceLevel1, string recipientEmail, string soundFile)
        {
            return ctsPriceLevelAlert(Input, logToOutputWindow, marker, markerColor, maxAlertNumberPerBar, priceLevel1, recipientEmail, soundFile);
        }

        /// <summary>
        /// Alert via sound and/or email when price levels are hit
        /// </summary>
        /// <returns></returns>
        public ctsPriceLevelAlert ctsPriceLevelAlert(Data.IDataSeries input, bool logToOutputWindow, string marker, Color markerColor, int maxAlertNumberPerBar, double priceLevel1, string recipientEmail, string soundFile)
        {
            if (cachectsPriceLevelAlert != null)
                for (int idx = 0; idx < cachectsPriceLevelAlert.Length; idx++)
                    if (cachectsPriceLevelAlert[idx].LogToOutputWindow == logToOutputWindow && cachectsPriceLevelAlert[idx].Marker == marker && cachectsPriceLevelAlert[idx].MarkerColor == markerColor && cachectsPriceLevelAlert[idx].MaxAlertNumberPerBar == maxAlertNumberPerBar && Math.Abs(cachectsPriceLevelAlert[idx].PriceLevel1 - priceLevel1) <= double.Epsilon && cachectsPriceLevelAlert[idx].RecipientEmail == recipientEmail && cachectsPriceLevelAlert[idx].SoundFile == soundFile && cachectsPriceLevelAlert[idx].EqualsInput(input))
                        return cachectsPriceLevelAlert[idx];

            lock (checkctsPriceLevelAlert)
            {
                checkctsPriceLevelAlert.LogToOutputWindow = logToOutputWindow;
                logToOutputWindow = checkctsPriceLevelAlert.LogToOutputWindow;
                checkctsPriceLevelAlert.Marker = marker;
                marker = checkctsPriceLevelAlert.Marker;
                checkctsPriceLevelAlert.MarkerColor = markerColor;
                markerColor = checkctsPriceLevelAlert.MarkerColor;
                checkctsPriceLevelAlert.MaxAlertNumberPerBar = maxAlertNumberPerBar;
                maxAlertNumberPerBar = checkctsPriceLevelAlert.MaxAlertNumberPerBar;
                checkctsPriceLevelAlert.PriceLevel1 = priceLevel1;
                priceLevel1 = checkctsPriceLevelAlert.PriceLevel1;
                checkctsPriceLevelAlert.RecipientEmail = recipientEmail;
                recipientEmail = checkctsPriceLevelAlert.RecipientEmail;
                checkctsPriceLevelAlert.SoundFile = soundFile;
                soundFile = checkctsPriceLevelAlert.SoundFile;

                if (cachectsPriceLevelAlert != null)
                    for (int idx = 0; idx < cachectsPriceLevelAlert.Length; idx++)
                        if (cachectsPriceLevelAlert[idx].LogToOutputWindow == logToOutputWindow && cachectsPriceLevelAlert[idx].Marker == marker && cachectsPriceLevelAlert[idx].MarkerColor == markerColor && cachectsPriceLevelAlert[idx].MaxAlertNumberPerBar == maxAlertNumberPerBar && Math.Abs(cachectsPriceLevelAlert[idx].PriceLevel1 - priceLevel1) <= double.Epsilon && cachectsPriceLevelAlert[idx].RecipientEmail == recipientEmail && cachectsPriceLevelAlert[idx].SoundFile == soundFile && cachectsPriceLevelAlert[idx].EqualsInput(input))
                            return cachectsPriceLevelAlert[idx];

                ctsPriceLevelAlert indicator = new ctsPriceLevelAlert();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.LogToOutputWindow = logToOutputWindow;
                indicator.Marker = marker;
                indicator.MarkerColor = markerColor;
                indicator.MaxAlertNumberPerBar = maxAlertNumberPerBar;
                indicator.PriceLevel1 = priceLevel1;
                indicator.RecipientEmail = recipientEmail;
                indicator.SoundFile = soundFile;
                Indicators.Add(indicator);
                indicator.SetUp();

                ctsPriceLevelAlert[] tmp = new ctsPriceLevelAlert[cachectsPriceLevelAlert == null ? 1 : cachectsPriceLevelAlert.Length + 1];
                if (cachectsPriceLevelAlert != null)
                    cachectsPriceLevelAlert.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachectsPriceLevelAlert = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Alert via sound and/or email when price levels are hit
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.ctsPriceLevelAlert ctsPriceLevelAlert(bool logToOutputWindow, string marker, Color markerColor, int maxAlertNumberPerBar, double priceLevel1, string recipientEmail, string soundFile)
        {
            return _indicator.ctsPriceLevelAlert(Input, logToOutputWindow, marker, markerColor, maxAlertNumberPerBar, priceLevel1, recipientEmail, soundFile);
        }

        /// <summary>
        /// Alert via sound and/or email when price levels are hit
        /// </summary>
        /// <returns></returns>
        public Indicator.ctsPriceLevelAlert ctsPriceLevelAlert(Data.IDataSeries input, bool logToOutputWindow, string marker, Color markerColor, int maxAlertNumberPerBar, double priceLevel1, string recipientEmail, string soundFile)
        {
            return _indicator.ctsPriceLevelAlert(input, logToOutputWindow, marker, markerColor, maxAlertNumberPerBar, priceLevel1, recipientEmail, soundFile);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Alert via sound and/or email when price levels are hit
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.ctsPriceLevelAlert ctsPriceLevelAlert(bool logToOutputWindow, string marker, Color markerColor, int maxAlertNumberPerBar, double priceLevel1, string recipientEmail, string soundFile)
        {
            return _indicator.ctsPriceLevelAlert(Input, logToOutputWindow, marker, markerColor, maxAlertNumberPerBar, priceLevel1, recipientEmail, soundFile);
        }

        /// <summary>
        /// Alert via sound and/or email when price levels are hit
        /// </summary>
        /// <returns></returns>
        public Indicator.ctsPriceLevelAlert ctsPriceLevelAlert(Data.IDataSeries input, bool logToOutputWindow, string marker, Color markerColor, int maxAlertNumberPerBar, double priceLevel1, string recipientEmail, string soundFile)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.ctsPriceLevelAlert(input, logToOutputWindow, marker, markerColor, maxAlertNumberPerBar, priceLevel1, recipientEmail, soundFile);
        }
    }
}
#endregion
