#region Using declarations

using System;
using System.Collections.Generic;
using System.ComponentModel;

#endregion

namespace Sim22EnumUtilities
{
    /// <summary>
    ///     Thanks to ChelseaB who provided this code for the NT8 community http://ninjatrader.com/support/forum/showpost.php?p=490303&amp;postcount=2
    /// </summary>
    public class EnumDescriptionConverter : EnumConverter
    {
        private Type enumType;

        public EnumDescriptionConverter(Type type) : base(type)
        {
            enumType = type;
        }

        public override bool CanConvertFrom(ITypeDescriptorContext context, Type srcType)
        {
            return srcType == typeof(string);
        }

        public override bool CanConvertTo(ITypeDescriptorContext context, Type destType)
        {
            return destType == typeof(string);
        }

        public override object ConvertFrom(ITypeDescriptorContext context, System.Globalization.CultureInfo culture, object value)
        {
            foreach (System.Reflection.FieldInfo fi in enumType.GetFields())
            {
                DescriptionAttribute dna = (DescriptionAttribute)Attribute.GetCustomAttribute(fi, typeof(DescriptionAttribute));
                if (dna != null && (string)value == dna.Description)
                    return Enum.Parse(enumType, fi.Name);
            }
            return Enum.Parse(enumType, (string)value);
        }

        public override object ConvertTo(ITypeDescriptorContext context, System.Globalization.CultureInfo culture, object value, Type destType)
        {
            System.Reflection.FieldInfo fi = enumType.GetField(value.ToString());
            DescriptionAttribute dna = (DescriptionAttribute)Attribute.GetCustomAttribute(fi, typeof(DescriptionAttribute));
            return dna != null ? dna.Description : value.ToString();
        }

        public override StandardValuesCollection GetStandardValues(ITypeDescriptorContext context)
        {
            List<string> values = new List<string>();
            foreach (var v in Enum.GetValues(enumType))
            {
                System.Reflection.FieldInfo fi = enumType.GetField(v.ToString());
                DescriptionAttribute dna = (DescriptionAttribute)Attribute.GetCustomAttribute(fi, typeof(DescriptionAttribute));
                values.Add(dna != null ? dna.Description : v.ToString());
            }
            return new StandardValuesCollection(values);
        }
    }
}