#region Using declarations
using System;
using System.Windows.Media;
using System.Linq;
using NinjaTrader.Core.FloatingPoint;
using NinjaTrader.Gui;
using SharpDX;
using SharpDX.Direct2D1;
using Brush = System.Windows.Media.Brush;
using Color = System.Windows.Media.Color;
using GradientStop = System.Windows.Media.GradientStop;
using LinearGradientBrush = System.Windows.Media.LinearGradientBrush;
using Point = System.Windows.Point;
using SolidColorBrush = System.Windows.Media.SolidColorBrush;

#endregion

//This namespace holds Indicators in this folder and is required. Do not change it. 
namespace NinjaTrader.NinjaScript.AddOns
{
    /// <summary>
    /// Functions for brush related calculations by Sim22 Dec 2016.
    /// </summary>
    
    public static class Sim22_BrushUtilitiesStat
    {
       
        public static LinearGradientBrush MakeLinearGradientBrush(Point startPoint, Point endPoint, Brush brush1, double gradStop1, Brush brush2, double gradStop2)
        {
            LinearGradientBrush linBrush = new LinearGradientBrush
            {
                StartPoint = startPoint,
                EndPoint = endPoint
            };

            GradientStop gs1 = new GradientStop {Offset = gradStop1};

            //Offset must be between 0.0 - 1.0
            SolidColorBrush gs1Scb = (SolidColorBrush)brush1;
            //gs1Scb.Freeze();
            gs1.Color = gs1Scb.Color;
            linBrush.GradientStops.Add(gs1);

            GradientStop gs2 = new GradientStop {Offset = gradStop2};

            //Offset must be between 0.0 - 1.0
            SolidColorBrush gs2Scb = (SolidColorBrush)brush2;
            //gs2Scb.Freeze();
            gs2.Color = gs2Scb.Color;
            linBrush.GradientStops.Add(gs2);

            return linBrush;

        }

        public static LinearGradientBrush MakeLinearGradientBrush(Point startPoint, Point endPoint, Brush brush1, double gradStop1, Brush brush2, double gradStop2, Brush brush3, double gradStop3, Brush brush4, double gradStop4)
        {
            LinearGradientBrush linBrush = new LinearGradientBrush
            {
                StartPoint = startPoint,
                EndPoint = endPoint
            };

            GradientStop gs1 = new GradientStop { Offset = gradStop1 };
            SolidColorBrush gs1Scb = (SolidColorBrush)brush1;
            gs1Scb.Freeze();
            gs1.Color = gs1Scb.Color;
            linBrush.GradientStops.Add(gs1);

            var gs2 = new GradientStop { Offset = gradStop2 };
            var gs2Scb = (SolidColorBrush)brush2;
            gs2Scb.Freeze();
            gs2.Color = gs2Scb.Color;
            linBrush.GradientStops.Add(gs2);

            var gs3 = new GradientStop { Offset = gradStop3 };
            var gs3Scb = (SolidColorBrush)brush3;
            gs3Scb.Freeze();
            gs3.Color = gs3Scb.Color;
            linBrush.GradientStops.Add(gs3);

            var gs4 = new GradientStop { Offset = gradStop4 };
            var gs4Scb = (SolidColorBrush)brush4;
            gs4Scb.Freeze();
            gs4.Color = gs4Scb.Color;
            linBrush.GradientStops.Add(gs4);

            return linBrush;

        }

        public static LinearGradientBrush MakeLinearGradientBrush(Point startPoint, Point endPoint, Brush brush1, double gradStop1, Brush brush2, double gradStop2, Brush brush3, double gradStop3, Brush brush4, double gradStop4, Brush brush5, double gradStop5, Brush brush6, double gradStop6)
        {
            LinearGradientBrush linBrush = new LinearGradientBrush
            {
                StartPoint = startPoint,
                EndPoint = endPoint
            };

            GradientStop gs1 = new GradientStop {Offset = gradStop1};
            SolidColorBrush gs1Scb = (SolidColorBrush)brush1;
            gs1Scb.Freeze();
            gs1.Color = gs1Scb.Color;
            linBrush.GradientStops.Add(gs1);

            var gs2 = new GradientStop {Offset = gradStop2};
            var gs2Scb = (SolidColorBrush) brush2;
            gs2Scb.Freeze();
            gs2.Color = gs2Scb.Color;
            linBrush.GradientStops.Add(gs2);

            var gs3 = new GradientStop {Offset = gradStop3};
            var gs3Scb = (SolidColorBrush) brush3;
            gs3Scb.Freeze();
            gs3.Color = gs3Scb.Color;
            linBrush.GradientStops.Add(gs3);

            var gs4 = new GradientStop {Offset = gradStop4};
            var gs4Scb = (SolidColorBrush) brush4;
            gs4Scb.Freeze();
            gs4.Color = gs4Scb.Color;
            linBrush.GradientStops.Add(gs4);

            var gs5 = new GradientStop {Offset = gradStop5};
            var gs5Scb = (SolidColorBrush) brush5;
            gs5Scb.Freeze();
            gs5.Color = gs5Scb.Color;
            linBrush.GradientStops.Add(gs5);

            var gs6 = new GradientStop {Offset = gradStop6};
            var gs6Scb = (SolidColorBrush) brush6;
            gs6Scb.Freeze();
            gs6.Color = gs6Scb.Color;
            linBrush.GradientStops.Add(gs6);

            return linBrush;

        }

        private static double Dist(System.Windows.Point px, System.Windows.Point po, System.Windows.Point pf)
        {
            double d = Math.Sqrt((px.Y - po.Y) * (px.Y - po.Y) + (px.X - po.X) * (px.X - po.X));

            if (((px.Y < po.Y) && (pf.Y > po.Y)) ||
                ((px.Y > po.Y) && (pf.Y < po.Y)) ||
                ((px.Y.ApproxCompare(po.Y) == 0) && (px.X < po.X) && (pf.X > po.X)) ||
                ((px.Y.ApproxCompare(po.Y) == 0) && (px.X > po.X) && (pf.X < po.X)))
            {
                d = -d;
            }
            return d;
        }

        public static Color GetColorAtPoint(LinearGradientBrush linearGradientBrush, Point point1, Point point2, Point valuePoint)
        {
            //Get properties
            double y3 = valuePoint.Y;
            double x3 = valuePoint.X;
            double x1 = point1.X;
            double y1 = point1.Y;
            double x2 = point2.X;
            double y2 = point2.Y;


            //Calculate intersecting points 
            Point p4; //with tangent

            if (y1.ApproxCompare(y2) == 0) //Horizontal case
            {
                p4 = new Point(x3, y1);
            }
            else if (x1.ApproxCompare(x2) == 0) //Vertical case
            {
                p4 = new Point(x1, y3);
            }
            else //Diagnonal case
            {
                double m = (y2 - y1) / (x2 - x1);
                double m2 = -1 / m;
                double b = y1 - m * x1;
                double c = y3 - m2 * x3;
                double x4 = (c - b) / (m - m2);
                double y4 = m * x4 + b;
                p4 = new Point(x4, y4);
            }
            //Calculate distances relative to the vector start
            double d4 = Dist(p4, point1, point2);
            double d2 = Dist(point2, point1, point2);
            double x = d4 / d2;
            //Clip the input if before or after the max/min offset values
            double max = linearGradientBrush.GradientStops.Max(n => n.Offset);
            if (x > max)
            {
                x = max;
            }
            double min = linearGradientBrush.GradientStops.Min(n => n.Offset);
            if (x < min)
            {
                x = min;
            }
            //Find gradient stops that surround the input value
            GradientStop gs0 = linearGradientBrush.GradientStops.Where(n => n.Offset <= x).OrderBy(n => n.Offset).Last();
            GradientStop gs1 = linearGradientBrush.GradientStops.Where(n => n.Offset >= x).OrderBy(n => n.Offset).First();
            float y = 0f;
            if (gs0.Offset.ApproxCompare(gs1.Offset) != 0)
            {
                y = (float)((x - gs0.Offset) / (gs1.Offset - gs0.Offset));
            }
            
            if (linearGradientBrush.ColorInterpolationMode == ColorInterpolationMode.ScRgbLinearInterpolation)
            {
                float aVal = (gs1.Color.ScA - gs0.Color.ScA) * y + gs0.Color.ScA;
                float rVal = (gs1.Color.ScR - gs0.Color.ScR) * y + gs0.Color.ScR;
                float gVal = (gs1.Color.ScG - gs0.Color.ScG) * y + gs0.Color.ScG;
                float bVal = (gs1.Color.ScB - gs0.Color.ScB) * y + gs0.Color.ScB;
                return Color.FromScRgb(aVal, rVal, gVal, bVal);
            }
            else
            {
                byte aVal = (byte)((gs1.Color.A - gs0.Color.A) * y + gs0.Color.A);
                byte rVal = (byte)((gs1.Color.R - gs0.Color.R) * y + gs0.Color.R);
                byte gVal = (byte)((gs1.Color.G - gs0.Color.G) * y + gs0.Color.G);
                byte bVal = (byte)((gs1.Color.B - gs0.Color.B) * y + gs0.Color.B);
                return Color.FromArgb(aVal, rVal, gVal, bVal);
            }

            ///Thanks to "https://dotupdate.wordpress.com" for information on finding the color for a particular point.
        }

        public static float GetBrightness(Color color)
        {
            float num1 = ((float)color.R) / 255f;
            float num2 = ((float)color.G) / 255f;
            float num3 = ((float)color.B) / 255f;
            float num4 = num1;
            float num5 = num1;
            if (num2 > num4)
                num4 = num2;
            if (num3 > num4)
                num4 = num3;
            if (num2 < num5)
                num5 = num2;
            if (num3 < num5)
                num5 = num3;
            return ((num4 + num5) / 2f);
        }

        public static float GetBrightness(Brush brush)
        {
            SolidColorBrush solidColorBrush = (SolidColorBrush)brush;

            float num1 = ((float) solidColorBrush.Color.R) / 255f;
            float num2 = ((float) solidColorBrush.Color.G) / 255f;
            float num3 = ((float) solidColorBrush.Color.B) / 255f;
            float num4 = num1;
            float num5 = num1;
            if (num2 > num4)
                num4 = num2;
            if (num3 > num4)
                num4 = num3;
            if (num2 < num5)
                num5 = num2;
            if (num3 < num5)
                num5 = num3;
            return ((num4 + num5) / 2f);

        }
        [CLSCompliant(false)]
        public static float GetBrightness(SharpDX.Direct2D1.Brush brushDx)
        {
            SharpDX.Direct2D1.SolidColorBrush scb = (SharpDX.Direct2D1.SolidColorBrush) brushDx;

            var color = (SharpDX.Color)scb.Color;

            return color.GetBrightness();

            /*** Original code ***/
            //float num1 = scb.Color.Red;
            //float num2 = scb.Color.Green;
            //float num3 = scb.Color.Blue;
            //float num4 = num1;
            //float num5 = num1;
            //if (num2 > num4)
            //    num4 = num2;
            //if (num3 > num4)
            //    num4 = num3;
            //if (num2 < num5)
            //    num5 = num2;
            //if (num3 < num5)
            //    num5 = num3;
            //return ((num4 + num5) / 2f);

        }
        [CLSCompliant(false)]
        public static SharpDX.Direct2D1.SolidColorBrush ReturnBrushFromBrightness(RenderTarget renderTarget, SharpDX.Direct2D1.Brush brushDx, float threshold)
        {
            SharpDX.Direct2D1.SolidColorBrush scb = (SharpDX.Direct2D1.SolidColorBrush)brushDx;

            var color = (SharpDX.Color) scb.Color;

            float brightness = color.GetBrightness();

            if (brightness > threshold)
                return new SharpDX.Direct2D1.SolidColorBrush(renderTarget, Color4.Black);

            return new SharpDX.Direct2D1.SolidColorBrush(renderTarget, Color4.White);
        }

        public static float GetBrightnessRatio(SharpDX.Direct2D1.Brush brushDX1, SharpDX.Direct2D1.Brush brushDX2)
        {
            SharpDX.Direct2D1.SolidColorBrush scb = (SharpDX.Direct2D1.SolidColorBrush)brushDX1;
            var color1 = (SharpDX.Color)scb.Color;
            float brightness1 = color1.GetBrightness();

            /*** Original code ***/
            //float num1 = scb.Color.Red;
            //float num2 = scb.Color.Green;
            //float num3 = scb.Color.Blue;
            //float num4 = num1;
            //float num5 = num1;
            //if (num2 > num4)
            //    num4 = num2;
            //if (num3 > num4)
            //    num4 = num3;
            //if (num2 < num5)
            //    num5 = num2;
            //if (num3 < num5)
            //    num5 = num3;
            //float brightness1 =  ((num4 + num5) / 2f);

            scb = (SharpDX.Direct2D1.SolidColorBrush)brushDX2;
            var color2 = (SharpDX.Color)scb.Color;
            float brightness2 = color2.GetBrightness();

            /*** Original code ***/
            //num1 = scb.Color.Red;
            //num2 = scb.Color.Green;
            //num3 = scb.Color.Blue;
            //num4 = num1;
            //num5 = num1;
            //if (num2 > num4)
            //    num4 = num2;
            //if (num3 > num4)
            //    num4 = num3;
            //if (num2 < num5)
            //    num5 = num2;
            //if (num3 < num5)
            //    num5 = num3;
            //float brightness2 = ((num4 + num5) / 2f);

            return brightness1 /brightness2;
        }

        [CLSCompliant(false)]
        public static float GetBrightnessDifference(SharpDX.Direct2D1.Brush brushDx1, SharpDX.Direct2D1.Brush brushDx2)
        {
            SharpDX.Direct2D1.SolidColorBrush scb = (SharpDX.Direct2D1.SolidColorBrush)brushDx1;
            var color1 = (SharpDX.Color)scb.Color;
            float brightness1 = color1.GetBrightness();

            /*** Original code ***/
            //float num1 = scb.Color.Red;
            //float num2 = scb.Color.Green;
            //float num3 = scb.Color.Blue;
            //float num4 = num1;
            //float num5 = num1;
            //if (num2 > num4)
            //    num4 = num2;
            //if (num3 > num4)
            //    num4 = num3;
            //if (num2 < num5)
            //    num5 = num2;
            //if (num3 < num5)
            //    num5 = num3;
            //float brightness1 = ((num4 + num5) / 2f);

            scb = (SharpDX.Direct2D1.SolidColorBrush)brushDx2;
            var color2 = (SharpDX.Color)scb.Color;
            float brightness2 = color2.GetBrightness();

            /*** Original code ***/
            //num1 = scb.Color.Red;
            //num2 = scb.Color.Green;
            //num3 = scb.Color.Blue;
            //num4 = num1;
            //num5 = num1;
            //if (num2 > num4)
            //    num4 = num2;
            //if (num3 > num4)
            //    num4 = num3;
            //if (num2 < num5)
            //    num5 = num2;
            //if (num3 < num5)
            //    num5 = num3;
            //float brightness2 = ((num4 + num5) / 2f);

            return brightness1 - brightness2;
        }
       
        public static Color ToneChangeColor(Color color, float percentToneChange)
        {
            if (percentToneChange < 0f)
                return color;

            byte red	= Convert.ToByte(Math.Min(255, color.R * percentToneChange * 0.01));
            byte green	= Convert.ToByte(Math.Min(255, color.G * percentToneChange * 0.01));
            byte blue	= Convert.ToByte(Math.Min(255, color.B * percentToneChange * 0.01));

            return Color.FromArgb(color.A, red, green, blue);
        }

        public static Brush ToneChangeBrush(Brush brush, float percentToneChange)
        {
            if (percentToneChange < 0f)
                return brush;

            SolidColorBrush solidColorBrush = (SolidColorBrush)brush;

            byte red = Convert.ToByte(Math.Max(0, Math.Min(255, Math.Max((byte)1, solidColorBrush.Color.R) * percentToneChange * 0.01)));
            byte green = Convert.ToByte(Math.Max(0, Math.Min(255, Math.Max((byte)1, solidColorBrush.Color.G) * percentToneChange * 0.01)));
            byte blue = Convert.ToByte(Math.Max(0, Math.Min(255, Math.Max((byte)1, solidColorBrush.Color.B) * percentToneChange * 0.01)));

            return new SolidColorBrush(Color.FromArgb(solidColorBrush.Color.A, red, green, blue));
        }

        public static Brush ToneChangeColorToBrush(Color color, float percentToneChange)
        {
            if (percentToneChange < 0f)
                return new SolidColorBrush(color);

            byte red = Convert.ToByte(Math.Min(255, color.R * percentToneChange * 0.01));
            byte green = Convert.ToByte(Math.Min(255, color.G * percentToneChange * 0.01));
            byte blue = Convert.ToByte(Math.Min(255, color.B * percentToneChange * 0.01));

            return new SolidColorBrush(Color.FromArgb(color.A, red, green, blue));
        }

        public static Color LerpColor(Color color, Color toColor, float correctionFactor)
        {
            // start colors as lerp-able floats
            float sr = color.R, sg = color.G, sb = color.B;

            // end colors as lerp-able floats
            float er = toColor.R, eg = toColor.G, eb = toColor.B;

            // lerp the colors to get the difference

            byte r = (byte)Lerp(sr, er, correctionFactor);
            byte g = (byte)Lerp(sg, eg, correctionFactor);
            byte b = (byte)Lerp(sb, eb, correctionFactor);

            // return the new color
            return Color.FromArgb(color.A, r, g, b);
        }

        public static Brush LerpBrush(Brush brush, Brush toBrush, float correctionFactor)
        {
            SolidColorBrush solidColorBrush = (SolidColorBrush)brush;
            SolidColorBrush solidColorBrushTo = (SolidColorBrush)brush;

            // start colors as lerp-able floats
            float sr = solidColorBrush.Color.R, sg = solidColorBrush.Color.G, sb = solidColorBrush.Color.B;

            // end colors as lerp-able floats
            float er = solidColorBrushTo.Color.R, eg = solidColorBrushTo.Color.G, eb = solidColorBrushTo.Color.B;

            // lerp the colors

            byte r = (byte)Lerp(sr, er, correctionFactor);
            byte g = (byte)Lerp(sg, eg, correctionFactor);
            byte b = (byte)Lerp(sb, eb, correctionFactor);

            // return the new color
            return new SolidColorBrush(Color.FromArgb(solidColorBrush.Color.A, r, g, b));
        }

        //http://stackoverflow.com/questions/97646/how-do-i-determine-darker-or-lighter-color-variant-of-a-given-color/2690026#2690026

        public static Brush LerpColorToBrush(Color color, bool brighten, float correctionFactor)
        {

            // start colors as lerp-able floats
            float sr = color.R, sg = color.G, sb = color.B;

            float er = 255f, eg = 255f, eb = 255f;

            if (!brighten)
            {
                er = 0f;
                eg = 0f;
                eb = 0f;
            }

            // lerp the colors

            byte r = (byte)Lerp(sr, er, correctionFactor);
            byte g = (byte)Lerp(sg, eg, correctionFactor);
            byte b = (byte)Lerp(sb, eb, correctionFactor);

            // return the new color
            return new SolidColorBrush(Color.FromArgb(color.A, r, g, b));
        }

        private static float Lerp(float value1, float value2, float correctionFactor)
        {
            return value1 + (value2 - value1) * correctionFactor;
        }

        public static Color ChangeColorBrightness(Color color, float correctionFactor)
        {
            float red = (float)color.R;
            float green = (float)color.G;
            float blue = (float)color.B;

            if (correctionFactor < 0)
            {
                correctionFactor = 1 + correctionFactor;
                red *= correctionFactor;
                green *= correctionFactor;
                blue *= correctionFactor;
            }
            else
            {
                red = (255 - red) * correctionFactor + red;
                green = (255 - green) * correctionFactor + green;
                blue = (255 - blue) * correctionFactor + blue;
            }

            return Color.FromArgb(color.A, (byte)red, (byte)green, (byte)blue);
        }
        //http://www.pvladov.com/2012/09/make-color-lighter-or-darker.html


        [CLSCompliant(false)]
        public static SharpDX.Direct2D1.Brush LerpSharpDxBrush(RenderTarget renderTarget, SharpDX.Direct2D1.Brush brushDx, bool lighten, float amount)
        {
            SharpDX.Direct2D1.SolidColorBrush scb = (SharpDX.Direct2D1.SolidColorBrush)brushDx;
            SharpDX.Color colorStart = (SharpDX.Color)scb.Color;
            SharpDX.Color colorEnd = lighten ? SharpDX.Color.White : SharpDX.Color.Black;
            SharpDX.Color colorResult;
            SharpDX.Color.Lerp(ref colorStart, ref colorEnd, amount, out colorResult);
            scb = new SharpDX.Direct2D1.SolidColorBrush(renderTarget, colorResult);

            return scb;
        }
        [CLSCompliant(false)]
        public static SharpDX.Color LerpSharpDxBrushToColor(SharpDX.Direct2D1.Brush brushDx, bool lighten, float amount)
        {

            SharpDX.Direct2D1.SolidColorBrush scb = (SharpDX.Direct2D1.SolidColorBrush)brushDx;
            SharpDX.Color colorStart = (SharpDX.Color)scb.Color;
            SharpDX.Color colorEnd = lighten ? SharpDX.Color.White : SharpDX.Color.Black;
            SharpDX.Color colorResult;
            SharpDX.Color.Lerp(ref colorStart, ref colorEnd, amount, out colorResult);

            return colorResult;
        }
        [CLSCompliant(false)]
        public static SharpDX.Color ToDxColor(System.Windows.Media.Brush brush)
        {
            return new SharpDX.Color()
            {
                A = ((System.Windows.Media.SolidColorBrush)brush).Color.A,
                B = ((System.Windows.Media.SolidColorBrush)brush).Color.B,
                G = ((System.Windows.Media.SolidColorBrush)brush).Color.G,
                R = ((System.Windows.Media.SolidColorBrush)brush).Color.R
            };
        }
        //public class DxBrushExtensions
        //{
        //    public SharpDX.Color ToDxColor(SharpDX.Direct2D1.Brush dxBrush)
        //    {
        //        return (SharpDX.Color)((SharpDX.Direct2D1.SolidColorBrush)dxBrush).Color;
        //    }
        //    public SharpDX.Color ToDxColor(System.Windows.Media.Brush brush, SharpDX.Direct2D1.RenderTarget renderTarget)
        //    {
        //        return (SharpDX.Color)((SharpDX.Direct2D1.SolidColorBrush)brush.ToDxBrush(renderTarget)).Color;
        //    }
        //}

        //public 
        ////public SharpDX.Color4 Color4DXLerp(SharpDX.Color4 color4DXStart, SharpDX.Color4 color4DXEnd, float amount)
        ////{

        ////    SharpDX.Color4.Lerp(ref color4DXStart, ref color4DXEnd, amount, out colorOut);

        ////    return colorOut;
        ////}
    }
}
