#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;

using System.Windows.Forms;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Enter the description of your new custom indicator here
    /// </summary>
    [Description("Enter the description of your new custom indicator here")]
    public class ToolbarShortcut : Indicator
    {
        #region Variables
		
		string[] strLines = {"btnmnuRuler", "btnmnuLine", "btnmnuRay", "btnmnuExtendedLine", "btnmnuArrowLine", "btnmnuHorizontalLine", "btnmnuVerticalLine" };
		string[] strFibs = {"btnmnuFibonacciRetracements",	"btnmnuFibonacciExtensions", "btnmnuFibonacciTimeExtension", "btnmnuFibonacciCircle"};
		string[] strChannels = {"btnmnuAndrewsPitchfork", "btnmnuGannFan", "btnregressionChannel", "btnmnuTrendChannel"};
		string[] strShapes = {"btnmmnuEllipse", "btnmnuRectangle", "btnmnuTriangle", "btnmnuArc", "btnmnuText"};
		string[] strMarkers = {"btnmnuArrowUp", "btnmnuArrowDown", "btnmnuDiamond", "btnmnuDot", "btnmnuSquare", "btnmnuTriangleUp", "btnmnuTriangleDown"};
		
		ToolStrip ts = null;
		
		bool showLines = true;
		bool showFibs = true;
		bool showChannels = true;
		bool showShapes = true;
		bool showMarkers = true;
		
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
            Overlay				= true;
			this.BarsRequired = 0;
        }

		protected override void OnStartUp()
		{
			if (!showLines && !showFibs && !showChannels && !showShapes && !showMarkers) return;
			
			ts = new ToolStrip();
			ts.Name = "ts";
			ts.Dock = DockStyle.Left;

			if (showLines)
			{
				foreach (string lines in strLines)
				{
					this.AddButtons(lines);
				}
				AddSeparator();
			}
			
			if (showFibs)
			{
				foreach (string fibs in strFibs)
				{
					AddButtons(fibs);
				}
				AddSeparator();
			}
			
			if (showChannels)
			{
				foreach (string channels in strChannels)
				{
					AddButtons(channels);
				}
				AddSeparator();
			}
			
			if (showShapes)
			{
				foreach (string shapes in strShapes)
				{
					AddButtons(shapes);
				}
				AddSeparator();
			}
			
			if (showMarkers)
			{
				foreach (string markers in strMarkers)
				{
					AddMarkers(markers);
				}
				AddSeparator();
			}
			
			
			AddButtons("btnmnuRemoveAllDrawObjects");
			
			ChartControl.Controls.Add(ts);
								
		}
		
		private void AddSeparator()
		{
			if (ChartControl == null || ts == null) return;
			
			ToolStripSeparator sep = new ToolStripSeparator();
			ts.Items.Add(sep);
		}
		
		private void AddButtons(string btnName)
		{
			if (ChartControl == null || ts == null) return;
			
			ToolStripDropDownItem btnDraw = (ToolStripDropDownItem)((ToolStrip)ChartControl.Controls["tsrTool"]).Items["btnDraw"];
			if (btnDraw == null) return;
			
			ToolStripItem item = btnDraw.DropDownItems[btnName.Replace("btn", string.Empty)];
			if (item == null) return;
			
			ToolStripButton btn = new ToolStripButton();
			btn.Name = btnName;
			btn.Text = btnName.Replace("btn", string.Empty).Replace("mmnu", string.Empty).Replace("mnu", string.Empty);
			btn.DisplayStyle = ToolStripItemDisplayStyle.Image;
			btn.Image = item.Image;
			btn.Click += new EventHandler(btn_Click);
			
			ts.Items.Add(btn);
			
		}
		
		private void AddMarkers(string btnMarker)
		{
			if (ChartControl == null || ts == null) return;
			
			ToolStripDropDownItem btnDraw = (ToolStripDropDownItem)((ToolStripDropDownItem)((ToolStrip)ChartControl.Controls["tsrTool"]).Items["btnDraw"]).DropDownItems["mnuChartMarker"];
			if (btnDraw == null) return;		
			
			ToolStripItem item = btnDraw.DropDownItems[btnMarker.Replace("btn", string.Empty)];
			if (item == null) return;
			
			ToolStripButton btn = new ToolStripButton();
			btn.Name = btnMarker;
			btn.Text = btnMarker.Replace("btn", string.Empty).Replace("mnu", string.Empty);
			btn.DisplayStyle = ToolStripItemDisplayStyle.Image;
			btn.Image = item.Image;
			btn.Click += new EventHandler(btn1_Click);
			
			ts.Items.Add(btn);
		
		}
		
		
		private void btn_Click(object sender, EventArgs e)
		{
			
			ToolStripItem item = (ToolStripItem)sender;
			ToolStripDropDownItem btnDraw = (ToolStripDropDownItem)((ToolStrip)ChartControl.Controls["tsrTool"]).Items["btnDraw"];
			
			foreach (ToolStripItem drawItem in btnDraw.DropDownItems)
			{
				if (item.Name.Replace("btn", string.Empty) == drawItem.Name)
				{
					drawItem.PerformClick();
					return;
				}
			}
		}
		
		private void btn1_Click(object sender, EventArgs e)
		{
			ToolStripItem item = (ToolStripItem)sender;
			ToolStripDropDownItem btnDraw = (ToolStripDropDownItem)((ToolStripDropDownItem)((ToolStrip)ChartControl.Controls["tsrTool"]).Items["btnDraw"]).DropDownItems["mnuChartMarker"];
			
			foreach (ToolStripItem drawItem in btnDraw.DropDownItems)
			{
				
				if (item.Name.Replace("btn", string.Empty) == drawItem.Name)
				{
					drawItem.PerformClick();
					return;
				}
			}
		}
		
        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
            
        }
		
		protected override void OnTermination()
		{
			if (ChartControl == null) return;
			if (!showLines && !showFibs && !showChannels && !showShapes && !showMarkers) return;
			
			if (ts != null) 
			{
				ts.Items.Clear();
				ChartControl.Controls.Remove(ts);
				ts.Dispose();
				ts = null;
			}
		}

        #region Properties
        [Description("")]
        [GridCategory("Parameters")]
		public bool ShowLines
		{
			get{ return showLines;}
			set{showLines = value;}
		}
		
		[Description("")]
        [GridCategory("Parameters")]
		public bool ShowFibs
		{
			get{ return showFibs;}
			set{showFibs = value;}
		}
		
		[Description("")]
        [GridCategory("Parameters")]
		public bool ShowChannels
		{
			get{ return showChannels;}
			set{showChannels = value;}
		}
		
		[Description("")]
        [GridCategory("Parameters")]
		public bool ShowShapes
		{
			get{ return showShapes;}
			set{showShapes = value;}
		}
		
		[Description("")]
        [GridCategory("Parameters")]
		public bool ShowMarkers
		{
			get{ return showMarkers;}
			set{showMarkers = value;}
		}
	
        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private ToolbarShortcut[] cacheToolbarShortcut = null;

        private static ToolbarShortcut checkToolbarShortcut = new ToolbarShortcut();

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public ToolbarShortcut ToolbarShortcut(bool showChannels, bool showFibs, bool showLines, bool showMarkers, bool showShapes)
        {
            return ToolbarShortcut(Input, showChannels, showFibs, showLines, showMarkers, showShapes);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public ToolbarShortcut ToolbarShortcut(Data.IDataSeries input, bool showChannels, bool showFibs, bool showLines, bool showMarkers, bool showShapes)
        {
            if (cacheToolbarShortcut != null)
                for (int idx = 0; idx < cacheToolbarShortcut.Length; idx++)
                    if (cacheToolbarShortcut[idx].ShowChannels == showChannels && cacheToolbarShortcut[idx].ShowFibs == showFibs && cacheToolbarShortcut[idx].ShowLines == showLines && cacheToolbarShortcut[idx].ShowMarkers == showMarkers && cacheToolbarShortcut[idx].ShowShapes == showShapes && cacheToolbarShortcut[idx].EqualsInput(input))
                        return cacheToolbarShortcut[idx];

            lock (checkToolbarShortcut)
            {
                checkToolbarShortcut.ShowChannels = showChannels;
                showChannels = checkToolbarShortcut.ShowChannels;
                checkToolbarShortcut.ShowFibs = showFibs;
                showFibs = checkToolbarShortcut.ShowFibs;
                checkToolbarShortcut.ShowLines = showLines;
                showLines = checkToolbarShortcut.ShowLines;
                checkToolbarShortcut.ShowMarkers = showMarkers;
                showMarkers = checkToolbarShortcut.ShowMarkers;
                checkToolbarShortcut.ShowShapes = showShapes;
                showShapes = checkToolbarShortcut.ShowShapes;

                if (cacheToolbarShortcut != null)
                    for (int idx = 0; idx < cacheToolbarShortcut.Length; idx++)
                        if (cacheToolbarShortcut[idx].ShowChannels == showChannels && cacheToolbarShortcut[idx].ShowFibs == showFibs && cacheToolbarShortcut[idx].ShowLines == showLines && cacheToolbarShortcut[idx].ShowMarkers == showMarkers && cacheToolbarShortcut[idx].ShowShapes == showShapes && cacheToolbarShortcut[idx].EqualsInput(input))
                            return cacheToolbarShortcut[idx];

                ToolbarShortcut indicator = new ToolbarShortcut();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.ShowChannels = showChannels;
                indicator.ShowFibs = showFibs;
                indicator.ShowLines = showLines;
                indicator.ShowMarkers = showMarkers;
                indicator.ShowShapes = showShapes;
                Indicators.Add(indicator);
                indicator.SetUp();

                ToolbarShortcut[] tmp = new ToolbarShortcut[cacheToolbarShortcut == null ? 1 : cacheToolbarShortcut.Length + 1];
                if (cacheToolbarShortcut != null)
                    cacheToolbarShortcut.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheToolbarShortcut = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.ToolbarShortcut ToolbarShortcut(bool showChannels, bool showFibs, bool showLines, bool showMarkers, bool showShapes)
        {
            return _indicator.ToolbarShortcut(Input, showChannels, showFibs, showLines, showMarkers, showShapes);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.ToolbarShortcut ToolbarShortcut(Data.IDataSeries input, bool showChannels, bool showFibs, bool showLines, bool showMarkers, bool showShapes)
        {
            return _indicator.ToolbarShortcut(input, showChannels, showFibs, showLines, showMarkers, showShapes);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.ToolbarShortcut ToolbarShortcut(bool showChannels, bool showFibs, bool showLines, bool showMarkers, bool showShapes)
        {
            return _indicator.ToolbarShortcut(Input, showChannels, showFibs, showLines, showMarkers, showShapes);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.ToolbarShortcut ToolbarShortcut(Data.IDataSeries input, bool showChannels, bool showFibs, bool showLines, bool showMarkers, bool showShapes)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.ToolbarShortcut(input, showChannels, showFibs, showLines, showMarkers, showShapes);
        }
    }
}
#endregion
