//
// Copyright (C) 2006, NinjaTrader LLC <ninjatrader@ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private AcmeMagicTape2[] cacheAcmeMagicTape2 = null;

        private static AcmeMagicTape2 checkAcmeMagicTape2 = new AcmeMagicTape2();

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public AcmeMagicTape2 AcmeMagicTape2(int blockSize, string buyBlockSound, AMT2HorizontalStyle horizontalAttachment, Color imbalanceMarkerColor, int maxRows, int maxScaleOpacity, int maxTapeOpacity, Color megablockColor, int megaBlockSize, long minimumSize, bool refreshRealTime, string sellBlockSound, bool showImbalance, int tapeFontSize, AMT2TapeMode tapeMode, Color textColorBuy, Color textColorSell)
        {
            return AcmeMagicTape2(Input, blockSize, buyBlockSound, horizontalAttachment, imbalanceMarkerColor, maxRows, maxScaleOpacity, maxTapeOpacity, megablockColor, megaBlockSize, minimumSize, refreshRealTime, sellBlockSound, showImbalance, tapeFontSize, tapeMode, textColorBuy, textColorSell);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public AcmeMagicTape2 AcmeMagicTape2(Data.IDataSeries input, int blockSize, string buyBlockSound, AMT2HorizontalStyle horizontalAttachment, Color imbalanceMarkerColor, int maxRows, int maxScaleOpacity, int maxTapeOpacity, Color megablockColor, int megaBlockSize, long minimumSize, bool refreshRealTime, string sellBlockSound, bool showImbalance, int tapeFontSize, AMT2TapeMode tapeMode, Color textColorBuy, Color textColorSell)
        {
            if (cacheAcmeMagicTape2 != null)
                for (int idx = 0; idx < cacheAcmeMagicTape2.Length; idx++)
                    if (cacheAcmeMagicTape2[idx].BlockSize == blockSize && cacheAcmeMagicTape2[idx].BuyBlockSound == buyBlockSound && cacheAcmeMagicTape2[idx].HorizontalAttachment == horizontalAttachment && cacheAcmeMagicTape2[idx].ImbalanceMarkerColor == imbalanceMarkerColor && cacheAcmeMagicTape2[idx].MaxRows == maxRows && cacheAcmeMagicTape2[idx].MaxScaleOpacity == maxScaleOpacity && cacheAcmeMagicTape2[idx].MaxTapeOpacity == maxTapeOpacity && cacheAcmeMagicTape2[idx].MegablockColor == megablockColor && cacheAcmeMagicTape2[idx].MegaBlockSize == megaBlockSize && cacheAcmeMagicTape2[idx].MinimumSize == minimumSize && cacheAcmeMagicTape2[idx].RefreshRealTime == refreshRealTime && cacheAcmeMagicTape2[idx].SellBlockSound == sellBlockSound && cacheAcmeMagicTape2[idx].ShowImbalance == showImbalance && cacheAcmeMagicTape2[idx].TapeFontSize == tapeFontSize && cacheAcmeMagicTape2[idx].TapeMode == tapeMode && cacheAcmeMagicTape2[idx].TextColorBuy == textColorBuy && cacheAcmeMagicTape2[idx].TextColorSell == textColorSell && cacheAcmeMagicTape2[idx].EqualsInput(input))
                        return cacheAcmeMagicTape2[idx];

            lock (checkAcmeMagicTape2)
            {
                checkAcmeMagicTape2.BlockSize = blockSize;
                blockSize = checkAcmeMagicTape2.BlockSize;
                checkAcmeMagicTape2.BuyBlockSound = buyBlockSound;
                buyBlockSound = checkAcmeMagicTape2.BuyBlockSound;
                checkAcmeMagicTape2.HorizontalAttachment = horizontalAttachment;
                horizontalAttachment = checkAcmeMagicTape2.HorizontalAttachment;
                checkAcmeMagicTape2.ImbalanceMarkerColor = imbalanceMarkerColor;
                imbalanceMarkerColor = checkAcmeMagicTape2.ImbalanceMarkerColor;
                checkAcmeMagicTape2.MaxRows = maxRows;
                maxRows = checkAcmeMagicTape2.MaxRows;
                checkAcmeMagicTape2.MaxScaleOpacity = maxScaleOpacity;
                maxScaleOpacity = checkAcmeMagicTape2.MaxScaleOpacity;
                checkAcmeMagicTape2.MaxTapeOpacity = maxTapeOpacity;
                maxTapeOpacity = checkAcmeMagicTape2.MaxTapeOpacity;
                checkAcmeMagicTape2.MegablockColor = megablockColor;
                megablockColor = checkAcmeMagicTape2.MegablockColor;
                checkAcmeMagicTape2.MegaBlockSize = megaBlockSize;
                megaBlockSize = checkAcmeMagicTape2.MegaBlockSize;
                checkAcmeMagicTape2.MinimumSize = minimumSize;
                minimumSize = checkAcmeMagicTape2.MinimumSize;
                checkAcmeMagicTape2.RefreshRealTime = refreshRealTime;
                refreshRealTime = checkAcmeMagicTape2.RefreshRealTime;
                checkAcmeMagicTape2.SellBlockSound = sellBlockSound;
                sellBlockSound = checkAcmeMagicTape2.SellBlockSound;
                checkAcmeMagicTape2.ShowImbalance = showImbalance;
                showImbalance = checkAcmeMagicTape2.ShowImbalance;
                checkAcmeMagicTape2.TapeFontSize = tapeFontSize;
                tapeFontSize = checkAcmeMagicTape2.TapeFontSize;
                checkAcmeMagicTape2.TapeMode = tapeMode;
                tapeMode = checkAcmeMagicTape2.TapeMode;
                checkAcmeMagicTape2.TextColorBuy = textColorBuy;
                textColorBuy = checkAcmeMagicTape2.TextColorBuy;
                checkAcmeMagicTape2.TextColorSell = textColorSell;
                textColorSell = checkAcmeMagicTape2.TextColorSell;

                if (cacheAcmeMagicTape2 != null)
                    for (int idx = 0; idx < cacheAcmeMagicTape2.Length; idx++)
                        if (cacheAcmeMagicTape2[idx].BlockSize == blockSize && cacheAcmeMagicTape2[idx].BuyBlockSound == buyBlockSound && cacheAcmeMagicTape2[idx].HorizontalAttachment == horizontalAttachment && cacheAcmeMagicTape2[idx].ImbalanceMarkerColor == imbalanceMarkerColor && cacheAcmeMagicTape2[idx].MaxRows == maxRows && cacheAcmeMagicTape2[idx].MaxScaleOpacity == maxScaleOpacity && cacheAcmeMagicTape2[idx].MaxTapeOpacity == maxTapeOpacity && cacheAcmeMagicTape2[idx].MegablockColor == megablockColor && cacheAcmeMagicTape2[idx].MegaBlockSize == megaBlockSize && cacheAcmeMagicTape2[idx].MinimumSize == minimumSize && cacheAcmeMagicTape2[idx].RefreshRealTime == refreshRealTime && cacheAcmeMagicTape2[idx].SellBlockSound == sellBlockSound && cacheAcmeMagicTape2[idx].ShowImbalance == showImbalance && cacheAcmeMagicTape2[idx].TapeFontSize == tapeFontSize && cacheAcmeMagicTape2[idx].TapeMode == tapeMode && cacheAcmeMagicTape2[idx].TextColorBuy == textColorBuy && cacheAcmeMagicTape2[idx].TextColorSell == textColorSell && cacheAcmeMagicTape2[idx].EqualsInput(input))
                            return cacheAcmeMagicTape2[idx];

                AcmeMagicTape2 indicator = new AcmeMagicTape2();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.BlockSize = blockSize;
                indicator.BuyBlockSound = buyBlockSound;
                indicator.HorizontalAttachment = horizontalAttachment;
                indicator.ImbalanceMarkerColor = imbalanceMarkerColor;
                indicator.MaxRows = maxRows;
                indicator.MaxScaleOpacity = maxScaleOpacity;
                indicator.MaxTapeOpacity = maxTapeOpacity;
                indicator.MegablockColor = megablockColor;
                indicator.MegaBlockSize = megaBlockSize;
                indicator.MinimumSize = minimumSize;
                indicator.RefreshRealTime = refreshRealTime;
                indicator.SellBlockSound = sellBlockSound;
                indicator.ShowImbalance = showImbalance;
                indicator.TapeFontSize = tapeFontSize;
                indicator.TapeMode = tapeMode;
                indicator.TextColorBuy = textColorBuy;
                indicator.TextColorSell = textColorSell;
                Indicators.Add(indicator);
                indicator.SetUp();

                AcmeMagicTape2[] tmp = new AcmeMagicTape2[cacheAcmeMagicTape2 == null ? 1 : cacheAcmeMagicTape2.Length + 1];
                if (cacheAcmeMagicTape2 != null)
                    cacheAcmeMagicTape2.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheAcmeMagicTape2 = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.AcmeMagicTape2 AcmeMagicTape2(int blockSize, string buyBlockSound, AMT2HorizontalStyle horizontalAttachment, Color imbalanceMarkerColor, int maxRows, int maxScaleOpacity, int maxTapeOpacity, Color megablockColor, int megaBlockSize, long minimumSize, bool refreshRealTime, string sellBlockSound, bool showImbalance, int tapeFontSize, AMT2TapeMode tapeMode, Color textColorBuy, Color textColorSell)
        {
            return _indicator.AcmeMagicTape2(Input, blockSize, buyBlockSound, horizontalAttachment, imbalanceMarkerColor, maxRows, maxScaleOpacity, maxTapeOpacity, megablockColor, megaBlockSize, minimumSize, refreshRealTime, sellBlockSound, showImbalance, tapeFontSize, tapeMode, textColorBuy, textColorSell);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.AcmeMagicTape2 AcmeMagicTape2(Data.IDataSeries input, int blockSize, string buyBlockSound, AMT2HorizontalStyle horizontalAttachment, Color imbalanceMarkerColor, int maxRows, int maxScaleOpacity, int maxTapeOpacity, Color megablockColor, int megaBlockSize, long minimumSize, bool refreshRealTime, string sellBlockSound, bool showImbalance, int tapeFontSize, AMT2TapeMode tapeMode, Color textColorBuy, Color textColorSell)
        {
            return _indicator.AcmeMagicTape2(input, blockSize, buyBlockSound, horizontalAttachment, imbalanceMarkerColor, maxRows, maxScaleOpacity, maxTapeOpacity, megablockColor, megaBlockSize, minimumSize, refreshRealTime, sellBlockSound, showImbalance, tapeFontSize, tapeMode, textColorBuy, textColorSell);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.AcmeMagicTape2 AcmeMagicTape2(int blockSize, string buyBlockSound, AMT2HorizontalStyle horizontalAttachment, Color imbalanceMarkerColor, int maxRows, int maxScaleOpacity, int maxTapeOpacity, Color megablockColor, int megaBlockSize, long minimumSize, bool refreshRealTime, string sellBlockSound, bool showImbalance, int tapeFontSize, AMT2TapeMode tapeMode, Color textColorBuy, Color textColorSell)
        {
            return _indicator.AcmeMagicTape2(Input, blockSize, buyBlockSound, horizontalAttachment, imbalanceMarkerColor, maxRows, maxScaleOpacity, maxTapeOpacity, megablockColor, megaBlockSize, minimumSize, refreshRealTime, sellBlockSound, showImbalance, tapeFontSize, tapeMode, textColorBuy, textColorSell);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.AcmeMagicTape2 AcmeMagicTape2(Data.IDataSeries input, int blockSize, string buyBlockSound, AMT2HorizontalStyle horizontalAttachment, Color imbalanceMarkerColor, int maxRows, int maxScaleOpacity, int maxTapeOpacity, Color megablockColor, int megaBlockSize, long minimumSize, bool refreshRealTime, string sellBlockSound, bool showImbalance, int tapeFontSize, AMT2TapeMode tapeMode, Color textColorBuy, Color textColorSell)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.AcmeMagicTape2(input, blockSize, buyBlockSound, horizontalAttachment, imbalanceMarkerColor, maxRows, maxScaleOpacity, maxTapeOpacity, megablockColor, megaBlockSize, minimumSize, refreshRealTime, sellBlockSound, showImbalance, tapeFontSize, tapeMode, textColorBuy, textColorSell);
        }
    }
}
#endregion
