//
// Copyright (C) 2006, NinjaTrader LLC <ninjatrader@ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private AcmeMarketPressure[] cacheAcmeMarketPressure = null;
        private AcmeTickAccumulator[] cacheAcmeTickAccumulator = null;
        private AcmeTickGuides[] cacheAcmeTickGuides = null;

        private static AcmeMarketPressure checkAcmeMarketPressure = new AcmeMarketPressure();
        private static AcmeTickAccumulator checkAcmeTickAccumulator = new AcmeTickAccumulator();
        private static AcmeTickGuides checkAcmeTickGuides = new AcmeTickGuides();

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public AcmeMarketPressure AcmeMarketPressure(bool alertLevelMinus3, bool alertLevelPlus3, string displayName, float fontSize, int gaugeHeight, string level3Sound, string levelMinus3Sound, Color needleOffColor, Color needleOnColor, float needleWidth, Color negativeColor, AMPPosition position, Color positiveColor, AMPProportions proportions, int sensitivity, bool soundRTHOnly, string symbol, Color textLabelColor)
        {
            return AcmeMarketPressure(Input, alertLevelMinus3, alertLevelPlus3, displayName, fontSize, gaugeHeight, level3Sound, levelMinus3Sound, needleOffColor, needleOnColor, needleWidth, negativeColor, position, positiveColor, proportions, sensitivity, soundRTHOnly, symbol, textLabelColor);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public AcmeMarketPressure AcmeMarketPressure(Data.IDataSeries input, bool alertLevelMinus3, bool alertLevelPlus3, string displayName, float fontSize, int gaugeHeight, string level3Sound, string levelMinus3Sound, Color needleOffColor, Color needleOnColor, float needleWidth, Color negativeColor, AMPPosition position, Color positiveColor, AMPProportions proportions, int sensitivity, bool soundRTHOnly, string symbol, Color textLabelColor)
        {
            if (cacheAcmeMarketPressure != null)
                for (int idx = 0; idx < cacheAcmeMarketPressure.Length; idx++)
                    if (cacheAcmeMarketPressure[idx].AlertLevelMinus3 == alertLevelMinus3 && cacheAcmeMarketPressure[idx].AlertLevelPlus3 == alertLevelPlus3 && cacheAcmeMarketPressure[idx].DisplayName == displayName && cacheAcmeMarketPressure[idx].FontSize == fontSize && cacheAcmeMarketPressure[idx].GaugeHeight == gaugeHeight && cacheAcmeMarketPressure[idx].Level3Sound == level3Sound && cacheAcmeMarketPressure[idx].LevelMinus3Sound == levelMinus3Sound && cacheAcmeMarketPressure[idx].NeedleOffColor == needleOffColor && cacheAcmeMarketPressure[idx].NeedleOnColor == needleOnColor && cacheAcmeMarketPressure[idx].NeedleWidth == needleWidth && cacheAcmeMarketPressure[idx].NegativeColor == negativeColor && cacheAcmeMarketPressure[idx].Position == position && cacheAcmeMarketPressure[idx].PositiveColor == positiveColor && cacheAcmeMarketPressure[idx].Proportions == proportions && cacheAcmeMarketPressure[idx].Sensitivity == sensitivity && cacheAcmeMarketPressure[idx].SoundRTHOnly == soundRTHOnly && cacheAcmeMarketPressure[idx].Symbol == symbol && cacheAcmeMarketPressure[idx].TextLabelColor == textLabelColor && cacheAcmeMarketPressure[idx].EqualsInput(input))
                        return cacheAcmeMarketPressure[idx];

            lock (checkAcmeMarketPressure)
            {
                checkAcmeMarketPressure.AlertLevelMinus3 = alertLevelMinus3;
                alertLevelMinus3 = checkAcmeMarketPressure.AlertLevelMinus3;
                checkAcmeMarketPressure.AlertLevelPlus3 = alertLevelPlus3;
                alertLevelPlus3 = checkAcmeMarketPressure.AlertLevelPlus3;
                checkAcmeMarketPressure.DisplayName = displayName;
                displayName = checkAcmeMarketPressure.DisplayName;
                checkAcmeMarketPressure.FontSize = fontSize;
                fontSize = checkAcmeMarketPressure.FontSize;
                checkAcmeMarketPressure.GaugeHeight = gaugeHeight;
                gaugeHeight = checkAcmeMarketPressure.GaugeHeight;
                checkAcmeMarketPressure.Level3Sound = level3Sound;
                level3Sound = checkAcmeMarketPressure.Level3Sound;
                checkAcmeMarketPressure.LevelMinus3Sound = levelMinus3Sound;
                levelMinus3Sound = checkAcmeMarketPressure.LevelMinus3Sound;
                checkAcmeMarketPressure.NeedleOffColor = needleOffColor;
                needleOffColor = checkAcmeMarketPressure.NeedleOffColor;
                checkAcmeMarketPressure.NeedleOnColor = needleOnColor;
                needleOnColor = checkAcmeMarketPressure.NeedleOnColor;
                checkAcmeMarketPressure.NeedleWidth = needleWidth;
                needleWidth = checkAcmeMarketPressure.NeedleWidth;
                checkAcmeMarketPressure.NegativeColor = negativeColor;
                negativeColor = checkAcmeMarketPressure.NegativeColor;
                checkAcmeMarketPressure.Position = position;
                position = checkAcmeMarketPressure.Position;
                checkAcmeMarketPressure.PositiveColor = positiveColor;
                positiveColor = checkAcmeMarketPressure.PositiveColor;
                checkAcmeMarketPressure.Proportions = proportions;
                proportions = checkAcmeMarketPressure.Proportions;
                checkAcmeMarketPressure.Sensitivity = sensitivity;
                sensitivity = checkAcmeMarketPressure.Sensitivity;
                checkAcmeMarketPressure.SoundRTHOnly = soundRTHOnly;
                soundRTHOnly = checkAcmeMarketPressure.SoundRTHOnly;
                checkAcmeMarketPressure.Symbol = symbol;
                symbol = checkAcmeMarketPressure.Symbol;
                checkAcmeMarketPressure.TextLabelColor = textLabelColor;
                textLabelColor = checkAcmeMarketPressure.TextLabelColor;

                if (cacheAcmeMarketPressure != null)
                    for (int idx = 0; idx < cacheAcmeMarketPressure.Length; idx++)
                        if (cacheAcmeMarketPressure[idx].AlertLevelMinus3 == alertLevelMinus3 && cacheAcmeMarketPressure[idx].AlertLevelPlus3 == alertLevelPlus3 && cacheAcmeMarketPressure[idx].DisplayName == displayName && cacheAcmeMarketPressure[idx].FontSize == fontSize && cacheAcmeMarketPressure[idx].GaugeHeight == gaugeHeight && cacheAcmeMarketPressure[idx].Level3Sound == level3Sound && cacheAcmeMarketPressure[idx].LevelMinus3Sound == levelMinus3Sound && cacheAcmeMarketPressure[idx].NeedleOffColor == needleOffColor && cacheAcmeMarketPressure[idx].NeedleOnColor == needleOnColor && cacheAcmeMarketPressure[idx].NeedleWidth == needleWidth && cacheAcmeMarketPressure[idx].NegativeColor == negativeColor && cacheAcmeMarketPressure[idx].Position == position && cacheAcmeMarketPressure[idx].PositiveColor == positiveColor && cacheAcmeMarketPressure[idx].Proportions == proportions && cacheAcmeMarketPressure[idx].Sensitivity == sensitivity && cacheAcmeMarketPressure[idx].SoundRTHOnly == soundRTHOnly && cacheAcmeMarketPressure[idx].Symbol == symbol && cacheAcmeMarketPressure[idx].TextLabelColor == textLabelColor && cacheAcmeMarketPressure[idx].EqualsInput(input))
                            return cacheAcmeMarketPressure[idx];

                AcmeMarketPressure indicator = new AcmeMarketPressure();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.AlertLevelMinus3 = alertLevelMinus3;
                indicator.AlertLevelPlus3 = alertLevelPlus3;
                indicator.DisplayName = displayName;
                indicator.FontSize = fontSize;
                indicator.GaugeHeight = gaugeHeight;
                indicator.Level3Sound = level3Sound;
                indicator.LevelMinus3Sound = levelMinus3Sound;
                indicator.NeedleOffColor = needleOffColor;
                indicator.NeedleOnColor = needleOnColor;
                indicator.NeedleWidth = needleWidth;
                indicator.NegativeColor = negativeColor;
                indicator.Position = position;
                indicator.PositiveColor = positiveColor;
                indicator.Proportions = proportions;
                indicator.Sensitivity = sensitivity;
                indicator.SoundRTHOnly = soundRTHOnly;
                indicator.Symbol = symbol;
                indicator.TextLabelColor = textLabelColor;
                Indicators.Add(indicator);
                indicator.SetUp();

                AcmeMarketPressure[] tmp = new AcmeMarketPressure[cacheAcmeMarketPressure == null ? 1 : cacheAcmeMarketPressure.Length + 1];
                if (cacheAcmeMarketPressure != null)
                    cacheAcmeMarketPressure.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheAcmeMarketPressure = tmp;
                return indicator;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public AcmeTickAccumulator AcmeTickAccumulator(Color negativeTrendColor, Color positiveTrendColor)
        {
            return AcmeTickAccumulator(Input, negativeTrendColor, positiveTrendColor);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public AcmeTickAccumulator AcmeTickAccumulator(Data.IDataSeries input, Color negativeTrendColor, Color positiveTrendColor)
        {
            if (cacheAcmeTickAccumulator != null)
                for (int idx = 0; idx < cacheAcmeTickAccumulator.Length; idx++)
                    if (cacheAcmeTickAccumulator[idx].NegativeTrendColor == negativeTrendColor && cacheAcmeTickAccumulator[idx].PositiveTrendColor == positiveTrendColor && cacheAcmeTickAccumulator[idx].EqualsInput(input))
                        return cacheAcmeTickAccumulator[idx];

            lock (checkAcmeTickAccumulator)
            {
                checkAcmeTickAccumulator.NegativeTrendColor = negativeTrendColor;
                negativeTrendColor = checkAcmeTickAccumulator.NegativeTrendColor;
                checkAcmeTickAccumulator.PositiveTrendColor = positiveTrendColor;
                positiveTrendColor = checkAcmeTickAccumulator.PositiveTrendColor;

                if (cacheAcmeTickAccumulator != null)
                    for (int idx = 0; idx < cacheAcmeTickAccumulator.Length; idx++)
                        if (cacheAcmeTickAccumulator[idx].NegativeTrendColor == negativeTrendColor && cacheAcmeTickAccumulator[idx].PositiveTrendColor == positiveTrendColor && cacheAcmeTickAccumulator[idx].EqualsInput(input))
                            return cacheAcmeTickAccumulator[idx];

                AcmeTickAccumulator indicator = new AcmeTickAccumulator();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.NegativeTrendColor = negativeTrendColor;
                indicator.PositiveTrendColor = positiveTrendColor;
                Indicators.Add(indicator);
                indicator.SetUp();

                AcmeTickAccumulator[] tmp = new AcmeTickAccumulator[cacheAcmeTickAccumulator == null ? 1 : cacheAcmeTickAccumulator.Length + 1];
                if (cacheAcmeTickAccumulator != null)
                    cacheAcmeTickAccumulator.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheAcmeTickAccumulator = tmp;
                return indicator;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public AcmeTickGuides AcmeTickGuides(int level2Max, string level2SoundHi, string level2SoundLow, int level3Max, string level3SoundHi, string level3SoundLow, ATGMAType movingAverageType, Color negativeTrendColor, int period, Color positiveTrendColor)
        {
            return AcmeTickGuides(Input, level2Max, level2SoundHi, level2SoundLow, level3Max, level3SoundHi, level3SoundLow, movingAverageType, negativeTrendColor, period, positiveTrendColor);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public AcmeTickGuides AcmeTickGuides(Data.IDataSeries input, int level2Max, string level2SoundHi, string level2SoundLow, int level3Max, string level3SoundHi, string level3SoundLow, ATGMAType movingAverageType, Color negativeTrendColor, int period, Color positiveTrendColor)
        {
            if (cacheAcmeTickGuides != null)
                for (int idx = 0; idx < cacheAcmeTickGuides.Length; idx++)
                    if (cacheAcmeTickGuides[idx].Level2Max == level2Max && cacheAcmeTickGuides[idx].Level2SoundHi == level2SoundHi && cacheAcmeTickGuides[idx].Level2SoundLow == level2SoundLow && cacheAcmeTickGuides[idx].Level3Max == level3Max && cacheAcmeTickGuides[idx].Level3SoundHi == level3SoundHi && cacheAcmeTickGuides[idx].Level3SoundLow == level3SoundLow && cacheAcmeTickGuides[idx].MovingAverageType == movingAverageType && cacheAcmeTickGuides[idx].NegativeTrendColor == negativeTrendColor && cacheAcmeTickGuides[idx].Period == period && cacheAcmeTickGuides[idx].PositiveTrendColor == positiveTrendColor && cacheAcmeTickGuides[idx].EqualsInput(input))
                        return cacheAcmeTickGuides[idx];

            lock (checkAcmeTickGuides)
            {
                checkAcmeTickGuides.Level2Max = level2Max;
                level2Max = checkAcmeTickGuides.Level2Max;
                checkAcmeTickGuides.Level2SoundHi = level2SoundHi;
                level2SoundHi = checkAcmeTickGuides.Level2SoundHi;
                checkAcmeTickGuides.Level2SoundLow = level2SoundLow;
                level2SoundLow = checkAcmeTickGuides.Level2SoundLow;
                checkAcmeTickGuides.Level3Max = level3Max;
                level3Max = checkAcmeTickGuides.Level3Max;
                checkAcmeTickGuides.Level3SoundHi = level3SoundHi;
                level3SoundHi = checkAcmeTickGuides.Level3SoundHi;
                checkAcmeTickGuides.Level3SoundLow = level3SoundLow;
                level3SoundLow = checkAcmeTickGuides.Level3SoundLow;
                checkAcmeTickGuides.MovingAverageType = movingAverageType;
                movingAverageType = checkAcmeTickGuides.MovingAverageType;
                checkAcmeTickGuides.NegativeTrendColor = negativeTrendColor;
                negativeTrendColor = checkAcmeTickGuides.NegativeTrendColor;
                checkAcmeTickGuides.Period = period;
                period = checkAcmeTickGuides.Period;
                checkAcmeTickGuides.PositiveTrendColor = positiveTrendColor;
                positiveTrendColor = checkAcmeTickGuides.PositiveTrendColor;

                if (cacheAcmeTickGuides != null)
                    for (int idx = 0; idx < cacheAcmeTickGuides.Length; idx++)
                        if (cacheAcmeTickGuides[idx].Level2Max == level2Max && cacheAcmeTickGuides[idx].Level2SoundHi == level2SoundHi && cacheAcmeTickGuides[idx].Level2SoundLow == level2SoundLow && cacheAcmeTickGuides[idx].Level3Max == level3Max && cacheAcmeTickGuides[idx].Level3SoundHi == level3SoundHi && cacheAcmeTickGuides[idx].Level3SoundLow == level3SoundLow && cacheAcmeTickGuides[idx].MovingAverageType == movingAverageType && cacheAcmeTickGuides[idx].NegativeTrendColor == negativeTrendColor && cacheAcmeTickGuides[idx].Period == period && cacheAcmeTickGuides[idx].PositiveTrendColor == positiveTrendColor && cacheAcmeTickGuides[idx].EqualsInput(input))
                            return cacheAcmeTickGuides[idx];

                AcmeTickGuides indicator = new AcmeTickGuides();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Level2Max = level2Max;
                indicator.Level2SoundHi = level2SoundHi;
                indicator.Level2SoundLow = level2SoundLow;
                indicator.Level3Max = level3Max;
                indicator.Level3SoundHi = level3SoundHi;
                indicator.Level3SoundLow = level3SoundLow;
                indicator.MovingAverageType = movingAverageType;
                indicator.NegativeTrendColor = negativeTrendColor;
                indicator.Period = period;
                indicator.PositiveTrendColor = positiveTrendColor;
                Indicators.Add(indicator);
                indicator.SetUp();

                AcmeTickGuides[] tmp = new AcmeTickGuides[cacheAcmeTickGuides == null ? 1 : cacheAcmeTickGuides.Length + 1];
                if (cacheAcmeTickGuides != null)
                    cacheAcmeTickGuides.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheAcmeTickGuides = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.AcmeMarketPressure AcmeMarketPressure(bool alertLevelMinus3, bool alertLevelPlus3, string displayName, float fontSize, int gaugeHeight, string level3Sound, string levelMinus3Sound, Color needleOffColor, Color needleOnColor, float needleWidth, Color negativeColor, AMPPosition position, Color positiveColor, AMPProportions proportions, int sensitivity, bool soundRTHOnly, string symbol, Color textLabelColor)
        {
            return _indicator.AcmeMarketPressure(Input, alertLevelMinus3, alertLevelPlus3, displayName, fontSize, gaugeHeight, level3Sound, levelMinus3Sound, needleOffColor, needleOnColor, needleWidth, negativeColor, position, positiveColor, proportions, sensitivity, soundRTHOnly, symbol, textLabelColor);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.AcmeMarketPressure AcmeMarketPressure(Data.IDataSeries input, bool alertLevelMinus3, bool alertLevelPlus3, string displayName, float fontSize, int gaugeHeight, string level3Sound, string levelMinus3Sound, Color needleOffColor, Color needleOnColor, float needleWidth, Color negativeColor, AMPPosition position, Color positiveColor, AMPProportions proportions, int sensitivity, bool soundRTHOnly, string symbol, Color textLabelColor)
        {
            return _indicator.AcmeMarketPressure(input, alertLevelMinus3, alertLevelPlus3, displayName, fontSize, gaugeHeight, level3Sound, levelMinus3Sound, needleOffColor, needleOnColor, needleWidth, negativeColor, position, positiveColor, proportions, sensitivity, soundRTHOnly, symbol, textLabelColor);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.AcmeTickAccumulator AcmeTickAccumulator(Color negativeTrendColor, Color positiveTrendColor)
        {
            return _indicator.AcmeTickAccumulator(Input, negativeTrendColor, positiveTrendColor);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.AcmeTickAccumulator AcmeTickAccumulator(Data.IDataSeries input, Color negativeTrendColor, Color positiveTrendColor)
        {
            return _indicator.AcmeTickAccumulator(input, negativeTrendColor, positiveTrendColor);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.AcmeTickGuides AcmeTickGuides(int level2Max, string level2SoundHi, string level2SoundLow, int level3Max, string level3SoundHi, string level3SoundLow, ATGMAType movingAverageType, Color negativeTrendColor, int period, Color positiveTrendColor)
        {
            return _indicator.AcmeTickGuides(Input, level2Max, level2SoundHi, level2SoundLow, level3Max, level3SoundHi, level3SoundLow, movingAverageType, negativeTrendColor, period, positiveTrendColor);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.AcmeTickGuides AcmeTickGuides(Data.IDataSeries input, int level2Max, string level2SoundHi, string level2SoundLow, int level3Max, string level3SoundHi, string level3SoundLow, ATGMAType movingAverageType, Color negativeTrendColor, int period, Color positiveTrendColor)
        {
            return _indicator.AcmeTickGuides(input, level2Max, level2SoundHi, level2SoundLow, level3Max, level3SoundHi, level3SoundLow, movingAverageType, negativeTrendColor, period, positiveTrendColor);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.AcmeMarketPressure AcmeMarketPressure(bool alertLevelMinus3, bool alertLevelPlus3, string displayName, float fontSize, int gaugeHeight, string level3Sound, string levelMinus3Sound, Color needleOffColor, Color needleOnColor, float needleWidth, Color negativeColor, AMPPosition position, Color positiveColor, AMPProportions proportions, int sensitivity, bool soundRTHOnly, string symbol, Color textLabelColor)
        {
            return _indicator.AcmeMarketPressure(Input, alertLevelMinus3, alertLevelPlus3, displayName, fontSize, gaugeHeight, level3Sound, levelMinus3Sound, needleOffColor, needleOnColor, needleWidth, negativeColor, position, positiveColor, proportions, sensitivity, soundRTHOnly, symbol, textLabelColor);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.AcmeMarketPressure AcmeMarketPressure(Data.IDataSeries input, bool alertLevelMinus3, bool alertLevelPlus3, string displayName, float fontSize, int gaugeHeight, string level3Sound, string levelMinus3Sound, Color needleOffColor, Color needleOnColor, float needleWidth, Color negativeColor, AMPPosition position, Color positiveColor, AMPProportions proportions, int sensitivity, bool soundRTHOnly, string symbol, Color textLabelColor)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.AcmeMarketPressure(input, alertLevelMinus3, alertLevelPlus3, displayName, fontSize, gaugeHeight, level3Sound, levelMinus3Sound, needleOffColor, needleOnColor, needleWidth, negativeColor, position, positiveColor, proportions, sensitivity, soundRTHOnly, symbol, textLabelColor);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.AcmeTickAccumulator AcmeTickAccumulator(Color negativeTrendColor, Color positiveTrendColor)
        {
            return _indicator.AcmeTickAccumulator(Input, negativeTrendColor, positiveTrendColor);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.AcmeTickAccumulator AcmeTickAccumulator(Data.IDataSeries input, Color negativeTrendColor, Color positiveTrendColor)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.AcmeTickAccumulator(input, negativeTrendColor, positiveTrendColor);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.AcmeTickGuides AcmeTickGuides(int level2Max, string level2SoundHi, string level2SoundLow, int level3Max, string level3SoundHi, string level3SoundLow, ATGMAType movingAverageType, Color negativeTrendColor, int period, Color positiveTrendColor)
        {
            return _indicator.AcmeTickGuides(Input, level2Max, level2SoundHi, level2SoundLow, level3Max, level3SoundHi, level3SoundLow, movingAverageType, negativeTrendColor, period, positiveTrendColor);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.AcmeTickGuides AcmeTickGuides(Data.IDataSeries input, int level2Max, string level2SoundHi, string level2SoundLow, int level3Max, string level3SoundHi, string level3SoundLow, ATGMAType movingAverageType, Color negativeTrendColor, int period, Color positiveTrendColor)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.AcmeTickGuides(input, level2Max, level2SoundHi, level2SoundLow, level3Max, level3SoundHi, level3SoundLow, movingAverageType, negativeTrendColor, period, positiveTrendColor);
        }
    }
}
#endregion
