#region Using declarations
using System;
using System.Reflection;
using System.Windows.Forms;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// v1.0
namespace NinjaTrader.Indicator
{
    		/// <summary>
    /// Enter the description of your new custom indicator here
    /// </summary>
    [Description("Enter the description of your new custom indicator here")]
    public class vvShowToolBarRight : Indicator
    {
        #region Variables
        // Wizard generated variables
         private StringFormat  			FormatCenter	= new StringFormat();
		private static SolidBrush 		Red    		= new SolidBrush(Color.Red);
		private static SolidBrush 		Black    		= new SolidBrush(Color.Black);
		private static SolidBrush 		Lime    		= new SolidBrush(Color.Lime);
		private static SolidBrush 		SkyBlue			= new SolidBrush(Color.SkyBlue);
		private System.Drawing.Font smallFont 	= new Font("Arial Narpanel_top", 8,System.Drawing.FontStyle.Bold);
		 Pen redPen  = new Pen(Color.Red, 1); 
		 Pen grePen  = new Pen(Color.Lime, 1); 
		//Button struct
		public struct MY_BUTTON 
		{
		   public int X, Y, Width, Height;
		   public SolidBrush color;
		   public string text;
		   public string cmd;

		   public MY_BUTTON(string t, int x, int y, int w, int h, SolidBrush c, string s) {
		      text = t; X = x; Y = y; Width = w; Height = h; color = c; cmd = s; 
		   }
		}

		   //Window vars
		
		
		public int panel_left;			//Start X pixel (from right margin) of trade panel
		const  int TOP_MARGIN = 4;		//Top Window Margin
		const  int panel_top = 4;		//Y pixel Start of trade panel (from top of window)
		
		   //Mouse and Keyboard vars
		bool   button_press = false;	//Was user click on a user button
		bool   user_click   = false;	//Was moused button just clicked
		string user_click_modifiers="";	//Any Control keys pressed with mouse click

			//Panel Buttons array
		MY_BUTTON[] buttons = {
			   //Entry Buttons
		new MY_BUTTON("S", 35, 10,  20, 20, SkyBlue,"S")
		}	
		;

		private System.Windows.Forms.Timer	timer;	// System Timer
		
		int barNumber=0;
		
		
		
		
	
	
		
		
		//--- do not freeze on button click vars
		private bool buttonc1 = false;
		private bool buttonc2 = false;
		
		
		
		private int mouseclick = 0;
		
		private bool show = true;
		
	
			
		
	
		
		private int yMouse = 0;
	
		private int yMouseB = 0;
		private int xMouseB = 0;
		
			
		
	
		
		private StringFormat				stringFormat		= new StringFormat();
		private SolidBrush					textBrush			= new SolidBrush(Color.Green);
		private SolidBrush					textBrush2			= new SolidBrush(Color.Red);
		private SolidBrush					textBrush3			= new SolidBrush(Color.White);
		private Font						textFont			= new Font("Arial", 30);
		
		// Default setting for MyInput0
        // User defined variables (add any user defined variables below)
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void OnStartUp() 
		{
		
 
		this.ChartControl.ChartPanel.MouseUp += new MouseEventHandler(chart_MouseClick);
		
			
		}
		
		protected override void Initialize()
        {
            Add(new Plot(Color.FromKnownColor(KnownColor.Orange), PlotStyle.Line, "Plot0"));
           
			CalculateOnBarClose = false;		//### Run on every Tick 
            Overlay				= true;	
			PaintPriceMarkers   = false;
			DisplayInDataBox    = false;
			
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
       protected override void OnBarUpdate()
        {
			       
			
				
			
		}
			//--------------------------------------------------------------------trap click	
		private void chart_MouseClick(object sender, MouseEventArgs e)
        {            
                                    
          
				
				
				//------------------------freeze	
				 if (e.Clicks == 1 && (e.Button == MouseButtons.Left))
			{
				yMouseB=	e.Y;
				xMouseB=	e.X;
				//---------check click
				int x,y;	
				double d;
				x = xMouseB-panel_left;
				y = yMouseB-panel_top;	
					
		
			    	//### Check button
				
 

				//displaybutton
				for(int i=0; i < buttons.Length; i++) {
					if ( x > buttons[i].X && x < buttons[i].X+buttons[i].Width && y > buttons[i].Y && y < buttons[i].Y+buttons[i].Height)
						{
							buttonc1 = true;
				    	if (show==true)
					{
						show=false;
					
						
					}
					else
					{
						show=true;	
						
					}
						
						
					}
						else
							buttonc1 = false;
					
				}
				
				
				
				//Lines logic
				if( show==true )
				{
					ChartControl.ToolBarEnabled=true;
					
				}
				if( show==false )
				{
				ChartControl.ToolBarEnabled=false;
				}
			
			}
			
			
			
		}
			
			
		
		public override void Plot(Graphics graphics, Rectangle bounds, double min, double max)
        {
            //----------Button
			base.Plot(graphics, bounds, min, max);
			int i,x,y; double d,f,price;
			Rectangle rect = new Rectangle(); 
			Brush brush;
			

		      //### Draw trade panel button
		    panel_left = bounds.Width+ChartControl.CanvasLeft-92;
		   
			
			
			
			for(i=0; i < buttons.Length; i++) {
					
					
				
				graphics.FillRectangle(Black, panel_left+buttons[i].X+1,  buttons[i].Y+panel_top+1,  buttons[i].Width-5,  buttons[i].Height-5);
					if(show==true)
					{
					graphics.DrawRectangle(redPen, panel_left+buttons[i].X,  buttons[i].Y+panel_top,  buttons[i].Width-4,  buttons[i].Height-4);
					graphics.DrawString( "▲", smallFont, Red, panel_left + buttons[i].X, buttons[i].Y+panel_top+2);
					
					}
					
					if(show==false)
					{
					graphics.DrawRectangle(grePen, panel_left+buttons[i].X,  buttons[i].Y+panel_top,  buttons[i].Width-4,  buttons[i].Height-4);	
					graphics.DrawString( "▼", smallFont, Lime, panel_left + buttons[i].X, buttons[i].Y+panel_top+2);
					}
				}
			
		
			

				
		
			
			
			
			
			
				
					
		}
	
		protected override void OnTermination() 
		{
 		
		this.ChartControl.ChartPanel.MouseUp -= new MouseEventHandler(chart_MouseClick);
		} 
		
		
		
		

        #region Properties
       
		
		
		
		
        #endregion
	
	}
}


#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private vvShowToolBarRight[] cachevvShowToolBarRight = null;

        private static vvShowToolBarRight checkvvShowToolBarRight = new vvShowToolBarRight();

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public vvShowToolBarRight vvShowToolBarRight()
        {
            return vvShowToolBarRight(Input);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public vvShowToolBarRight vvShowToolBarRight(Data.IDataSeries input)
        {
            if (cachevvShowToolBarRight != null)
                for (int idx = 0; idx < cachevvShowToolBarRight.Length; idx++)
                    if (cachevvShowToolBarRight[idx].EqualsInput(input))
                        return cachevvShowToolBarRight[idx];

            lock (checkvvShowToolBarRight)
            {
                if (cachevvShowToolBarRight != null)
                    for (int idx = 0; idx < cachevvShowToolBarRight.Length; idx++)
                        if (cachevvShowToolBarRight[idx].EqualsInput(input))
                            return cachevvShowToolBarRight[idx];

                vvShowToolBarRight indicator = new vvShowToolBarRight();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                Indicators.Add(indicator);
                indicator.SetUp();

                vvShowToolBarRight[] tmp = new vvShowToolBarRight[cachevvShowToolBarRight == null ? 1 : cachevvShowToolBarRight.Length + 1];
                if (cachevvShowToolBarRight != null)
                    cachevvShowToolBarRight.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachevvShowToolBarRight = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.vvShowToolBarRight vvShowToolBarRight()
        {
            return _indicator.vvShowToolBarRight(Input);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.vvShowToolBarRight vvShowToolBarRight(Data.IDataSeries input)
        {
            return _indicator.vvShowToolBarRight(input);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.vvShowToolBarRight vvShowToolBarRight()
        {
            return _indicator.vvShowToolBarRight(Input);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.vvShowToolBarRight vvShowToolBarRight(Data.IDataSeries input)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.vvShowToolBarRight(input);
        }
    }
}
#endregion
