#region Using declarations
using System;
using System.ComponentModel;
using System.IO;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion


#region GREX

public static class rfkGREX
{
	public static List<string> tagList = new List<string>();
	public static int modifier = 0;
	public static int mcount = 0;
	public static bool loaded = false;
	public static bool saved = false;
}

#endregion


namespace NinjaTrader.Indicator
{
    [Description("Enter the description of your new custom indicator here")]
    public class rfkExtendRects : Indicator
    {
		private string versionInfo = "ExtendRects v1.0";
		
        #region Variables
         
		private string chartName = "";
		private string hotKeyString = "Ctrl-E";
		private string onOffKeyString = "Ctrl-O";
		private string mouseModString = "Ctrl";
		
		private Keys hotKey = Keys.E;
		private Keys onOffKey = Keys.O;
		
		private int margin = 0;
		private int opacity = 0;
		
		private bool showLines = true;
		
		private int areaOpacity;
		private bool extensionsOn = true;
		
		private bool shiftKeyDown;
		private bool ctrlKeyDown;
		private bool altKeyDown;
		
		private bool keyShiftNeeded = false;
		private bool keyCtrlNeeded = true;
		private bool keyAltNeeded = false;
				
		private bool onShiftNeeded = false;
		private bool onCtrlNeeded = true;
		private bool onAltNeeded = false;
				
		private bool mouseShiftNeeded = false;
		private bool mouseCtrlNeeded = true;
		private bool mouseAltNeeded = false;
				
		private int mouseX;
		private int mouseY;
		
		private List<string> tagList = new List<string>();

		private System.Windows.Forms.Timer gTimer = new System.Windows.Forms.Timer();
		
		private int myChart;
		
		private System.Drawing.Font bigFont = new Font("Arial Narpanel_top", 16,System.Drawing.FontStyle.Bold);
		
		private string diagnostics = "";
		
		private bool debugKeys;

		#endregion
		
		
		#region INITS and TERMINATION
		
        protected override void Initialize()
        {
            Overlay	= true;
        }
		
		
		protected override void OnStartUp ()
		{
			debugKeys = diagnostics.Contains("keys");
			
			ChartControl.ChartPanel.MouseMove += new MouseEventHandler (chartMouseMove);
			ChartControl.ChartPanel.MouseDown += new MouseEventHandler (chartMouseClickDown);
			ChartControl.ChartPanel.MouseUp += new MouseEventHandler (chartMouseClickUp);
			ChartControl.ChartPanel.KeyDown += new KeyEventHandler (chartKeyDown);
			ChartControl.ChartPanel.KeyUp += new KeyEventHandler (chartKeyUp);
			
			myChart = (int) ChartControl.FindForm().Handle;
			
			if (convertKeyAndMouse())
			{
				loadTagLists();
				
				gTimer.Interval = 1000;
				gTimer.Tick += slowTimerTick;
				gTimer.Start();
				
				areaOpacity = (opacity * 255) / 10;
			}
		}
		
		
		protected override void OnTermination()
        {
			ChartControl.ChartPanel.MouseMove -= new MouseEventHandler (chartMouseMove);
			ChartControl.ChartPanel.MouseDown -= new MouseEventHandler(chartMouseClickDown);
			ChartControl.ChartPanel.MouseUp -= new MouseEventHandler(chartMouseClickUp);
			ChartControl.ChartPanel.KeyDown -= new KeyEventHandler(chartKeyDown);
			ChartControl.ChartPanel.KeyUp -= new KeyEventHandler(chartKeyUp);
			
			gTimer.Stop();
			gTimer.Tick -= slowTimerTick;
			
			saveTagLists();
		}
		
		#endregion
		
		
		#region SAVE and RESTORE
		
		private void saveTagLists ()
		{
			if (chartName != "")
			{
				string path = getUserDataFolder() + @"\" + chartName + ".txt";
				
				try
				{
					System.IO.StreamWriter file;
				
					file = new System.IO.StreamWriter(path);
					
					foreach (string tag in tagList)
					{
						file.WriteLine(tag);
					}
					
					file.Close();
				}
				catch { Print("saveTagLists failed " + path); }
			}
				
			if (!rfkGREX.saved)
			{
				string path = getUserDataFolder() + @"\GREXtags.txt";
				
				try
				{
					System.IO.StreamWriter file = new System.IO.StreamWriter(path);
					
					foreach (string tag in rfkGREX.tagList)
					{
						file.WriteLine(tag);
					}
					
					file.Close();
				}
				catch { Print("saveTagLists failed " + path); }
			
				rfkGREX.saved = true;
			}
		}
		
		
		private void loadTagLists ()
		{
			if (chartName != "")
			{
				string path = getUserDataFolder() + @"\" + chartName + ".txt";
				
				if (File.Exists(path))
				{
					try
					{
						string str;
						System.IO.StreamReader file = new System.IO.StreamReader(path);
						
						while ((str = file.ReadLine()) != null)
						{
							tagList.Add(str);
						}
						
						file.Close();
					}
					catch { Print("loadTagLists failed " + path); }
				}
			}
			
			if (!rfkGREX.loaded)
			{
				string path = getUserDataFolder() + @"\GREXtags.txt";
				
				if (File.Exists(path))
				{
					try
					{
						string str;
						System.IO.StreamReader file = new System.IO.StreamReader(path);
						
						while ((str = file.ReadLine()) != null)
						{
							rfkGREX.tagList.Add(str);
						}
						
						file.Close();
					}
					catch { Print("loadTagLists failed " + path); }
				}
				
				rfkGREX.loaded = true;
			}
		}
		
		
		private string getUserDataFolder ()
		{
			try
			{
				string path = Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData);
				
				path += @"\RectangleExtender";
				if (!Directory.Exists(path))
				{
					Directory.CreateDirectory(path);
				}
				
				return (path);
			}
			catch (Exception ex)
			{
				Print("getUserDataFolder failed " + ex);
				return ("");
			}
		}
		
		#endregion
		
		
		#region TIMER
		
		private void slowTimerTick(object sender, EventArgs e)
        {
			if (rfkGREX.mcount > 0)
			{
				ChartControl.Refresh();
			
				if (rfkGREX.modifier == myChart)
				{
					--rfkGREX.mcount;
				}
				
				rfkGREX.saved = false;
			}
		}
		
		#endregion
		
		
		#region OBU
		
       protected override void OnBarUpdate()
        {
        }
		
		#endregion
		
		
		#region KEYS and CLICKS
		
		private void chartMouseMove (object sender, MouseEventArgs e)
        {            
			//Print("chartMouseMove "  + e.X + ", " + e.Y);
			
			mouseX = e.X;
			mouseY = e.Y;
		}
		
		
		private void chartMouseClickDown (object sender, MouseEventArgs e)
        {            
			//Print("chartMouseClickDown " + e.Clicks + " " + e.Button + " " + e.X + ", " + e.Y);
			
			if (e.Button == MouseButtons.Left)
			{
				if (shiftKeyDown == mouseShiftNeeded && ctrlKeyDown == mouseCtrlNeeded && altKeyDown == mouseAltNeeded)
				{
					checkFlipRect();
				}
			}
		}
		

		private void chartMouseClickUp (object sender, MouseEventArgs e)
        {            
			//Print("chartMouseClickUp " + e.Clicks + " " + e.Button + " " + e.X + ", " + e.Y);
		}
		
		
		private void chartKeyUp (object sender, KeyEventArgs e)
		{
			//Print("chartKeyUp " + e.Shift + " " + e.Control + " " + e.Alt + " " + e.KeyCode);
			
			if ((e.KeyCode == hotKey && shiftKeyDown == keyShiftNeeded && ctrlKeyDown == keyCtrlNeeded && altKeyDown == keyAltNeeded)
			|| (e.KeyCode == onOffKey && shiftKeyDown == onShiftNeeded && ctrlKeyDown == onCtrlNeeded && altKeyDown == onAltNeeded))
			{
				e.Handled = true;
				e.SuppressKeyPress = true;
			}
			
			shiftKeyDown = e.Shift;
			ctrlKeyDown = e.Control;
			altKeyDown = e.Alt;
		}
			
		
		private void chartKeyDown (object sender, KeyEventArgs e)
		{
			//Print("chartKeyDown " + e.Shift + " " + e.Control + " " + e.Alt + " " + e.KeyCode);
			
			shiftKeyDown = e.Shift;
			ctrlKeyDown = e.Control;
			altKeyDown = e.Alt;
			
			if (e.KeyCode == hotKey && shiftKeyDown == keyShiftNeeded && ctrlKeyDown == keyCtrlNeeded && altKeyDown == keyAltNeeded)
			{
				e.Handled = true;
				e.SuppressKeyPress = true;
				
				checkFlipRect();
			}
			else if (e.KeyCode == onOffKey && shiftKeyDown == onShiftNeeded && ctrlKeyDown == onCtrlNeeded && altKeyDown == onAltNeeded)
			{
				e.Handled = true;
				e.SuppressKeyPress = true;
				
				extensionsOn = !extensionsOn;
			}
		}
		
		
		private bool convertKeyAndMouse ()
		{
			bool converted = true;			
			KeysConverter kc = new KeysConverter();	
			
			Keys mod1 = Keys.None;
			Keys mod2 = Keys.None;
			Keys mod3 = Keys.None;
			Keys key = Keys.None;

			try
			{
				string[] parts = hotKeyString.Split('-');
				
				if (debugKeys)
				{
					Print("hk " + hotKeyString + " parts " + parts.Length);
					for (int i = 0; i < parts.Length; i++)
					{
						Print(parts[i]);
					}
				}
				
				if (parts.Length == 1)
				{
					key = (Keys) kc.ConvertFromString(parts[0]);
				}
				else if (parts.Length == 2)
				{
					mod1 = (Keys) kc.ConvertFromString(parts[0]);
					key = (Keys) kc.ConvertFromString(parts[1]);
				}
				else if (parts.Length == 3)
				{
					mod1 = (Keys) kc.ConvertFromString(parts[0]);
					mod2 = (Keys) kc.ConvertFromString(parts[1]);
					key = (Keys) kc.ConvertFromString(parts[2]);
				}
				else
				{
					warnError("HotKey, joking? " + hotKeyString, "");
					converted = false;
				}
			}
			catch (Exception ex)
			{
				warnError("Sorry, can't convert HotKey from " + hotKeyString, ex.ToString());
				converted = false;
			}			
			
			if (converted)
			{
				hotKey = key;
				keyShiftNeeded = (mod1 == Keys.Shift || mod2 == Keys.Shift);
				keyCtrlNeeded = (mod1 == Keys.Control || mod2 == Keys.Control);
				keyAltNeeded = (mod1 == Keys.Alt || mod2 == Keys.Alt);
			}
			else
			{
				return false;
			}

			mod1 = Keys.None;
			mod2 = Keys.None;
			key = Keys.None;

			try
			{
				string[] parts = onOffKeyString.Split('-');
				
				if (debugKeys)
				{
					Print("on " + onOffKeyString + " parts " + parts.Length);
					for (int i = 0; i < parts.Length; i++)
					{
						Print(parts[i]);
					}
				}
				
				if (parts.Length == 1)
				{
					key = (Keys) kc.ConvertFromString(parts[0]);
				}
				else if (parts.Length == 2)
				{
					mod1 = (Keys) kc.ConvertFromString(parts[0]);
					key = (Keys) kc.ConvertFromString(parts[1]);
				}
				else if (parts.Length == 3)
				{
					mod1 = (Keys) kc.ConvertFromString(parts[0]);
					mod2 = (Keys) kc.ConvertFromString(parts[1]);
					key = (Keys) kc.ConvertFromString(parts[2]);
				}
				else
				{
					warnError("OnOffKey, joking? " + onOffKeyString, "");
					converted = false;
				}
			}
			catch (Exception ex)
			{
				warnError("Sorry, can't convert OnOffKey from " + onOffKeyString, ex.ToString());
				converted = false;
			}			
			
			if (converted)
			{
				onOffKey = key;
				onShiftNeeded = (mod1 == Keys.Shift || mod2 == Keys.Shift);
				onCtrlNeeded = (mod1 == Keys.Control || mod2 == Keys.Control);
				onAltNeeded = (mod1 == Keys.Alt || mod2 == Keys.Alt);
			}
			else
			{
				return false;
			}

			mod1 = Keys.None;
			mod2 = Keys.None;
			mod3 = Keys.None;

			try
			{
				string[] parts = mouseModString.Split('-');
				
				if (debugKeys)
				{
					Print("ms " + mouseModString + " parts " + parts.Length);
					for (int i = 0; i < parts.Length; i++)
					{
						Print(parts[i]);
					}
				}
				
				if (parts.Length == 1)
				{
					mod1 = (Keys) kc.ConvertFromString(parts[0]);
				}
				else if (parts.Length == 2)
				{
					mod1 = (Keys) kc.ConvertFromString(parts[0]);
					mod2 = (Keys) kc.ConvertFromString(parts[1]);
				}
				else if (parts.Length == 3)
				{
					mod1 = (Keys) kc.ConvertFromString(parts[0]);
					mod2 = (Keys) kc.ConvertFromString(parts[1]);
					mod3 = (Keys) kc.ConvertFromString(parts[2]);
				}
				else
				{
					warnError("MouseModifiers, joking? " + mouseModString, "");
					converted = false;
				}
			}
			catch (Exception ex)
			{
				warnError("Sorry, can't convert MouseModifiers from " + mouseModString, ex.ToString());
				converted = false;
			}			
			
			if ((mod1 != Keys.None && mod1 != Keys.Shift && mod1 != Keys.Control && mod1 != Keys.Alt) ||
				(mod2 != Keys.None && mod2 != Keys.Shift && mod2 != Keys.Control && mod2 != Keys.Alt) ||
				(mod3 != Keys.None && mod3 != Keys.Shift && mod3 != Keys.Control && mod3 != Keys.Alt))
			{
				warnError("Invalid MouseModifiers " + mouseModString, "");
				converted = false;
			}
			
			if (converted)
			{
				mouseShiftNeeded = (mod1 == Keys.Shift || mod2 == Keys.Shift || mod3 == Keys.Shift);
				mouseCtrlNeeded = (mod1 == Keys.Control || mod2 == Keys.Control || mod3 == Keys.Control);
				mouseAltNeeded = (mod1 == Keys.Alt || mod2 == Keys.Alt || mod3 == Keys.Alt);
			}
			
			return true;
		}
		
		
		private void warnError (string msg, string exstr)
		{
			if (msg != "")
			{
				Print(msg);
				if (exstr != "") Print(exstr);
				
				DrawTextFixed("et", msg, TextPosition.Center, Color.Black, 
												bigFont, Color.Transparent, Color.Transparent, 0);
			}
		}
		
		#endregion
		
		
		#region FLIPRECT
		
		private void checkFlipRect ()
		{
			foreach (IDrawObject draw in DrawObjects)
			{
				if (draw.DrawType == DrawType.Rectangle && draw.UserDrawn)
				{
					IRectangle rect = (IRectangle) draw;
					int upperY, lowerY;
					
					//Print(draw.Tag);
					
					// NB price <-> pixel Y inversion
					if (rect.StartY < rect.EndY)
					{
						upperY = ChartControl.GetYByValue(this, rect.StartY);
						lowerY = ChartControl.GetYByValue(this, rect.EndY);
					}
					else
					{
						upperY = ChartControl.GetYByValue(this, rect.EndY);
						lowerY = ChartControl.GetYByValue(this, rect.StartY);
					}
					
					if (mouseY >= lowerY && mouseY <= upperY)
					{
						int firstX, lastX;
						
						//Print("In Y " + rect.Tag);
						
						if (rect.StartTime < rect.EndTime)
						{
							firstX = ChartControl.GetXByTime(rect.StartTime);
							lastX = ChartControl.GetXByTime(rect.EndTime);
						}
						else
						{
							firstX = ChartControl.GetXByTime(rect.EndTime);
							lastX = ChartControl.GetXByTime(rect.StartTime);
						}
						
						if (mouseX >= firstX && mouseX <= lastX)
						{
							//Print("In X " + rect.Tag);
							
							if (rect.Tag.StartsWith("@"))
							{
								string tag = gtagRef(rect);
								
								if (rfkGREX.tagList.Contains(tag))
								{
									rfkGREX.tagList.Remove(tag);
								}
								else
								{
									rfkGREX.tagList.Add(tag);
								}
								
								rfkGREX.modifier = myChart;
								rfkGREX.mcount = 3;
							}
							else
							{
								if (tagList.Contains(rect.Tag))
								{
									tagList.Remove(rect.Tag);
								}
								else
								{
									tagList.Add(rect.Tag);
								}
							}
							break;
						}
					}
				}
			}
		}
		
		
		private string gtagRef (IRectangle rect)
		{
			return (Instrument.FullName + rect.EndTime.Ticks/1000000 + rect.StartY.ToString("0.000"));
		}
		
		#endregion
		
		
		#region PLOT
			
		public override void Plot(Graphics graphics, Rectangle bounds, double min, double max)
		{
			if (InHitTest || !extensionsOn)
			{
				return;
			}
			
			foreach (IDrawObject draw in DrawObjects)
			{
				if (draw.UserDrawn && draw.DrawType == DrawType.Rectangle)
				{
					IRectangle rect = (IRectangle) draw;
				
					if (tagList.Contains(rect.Tag) || (rect.Tag.StartsWith("@") && rfkGREX.tagList.Contains(gtagRef(rect))))
					{
						int upperY, lowerY;
						
						if (rect.StartY < rect.EndY)
						{
							upperY = ChartControl.GetYByValue(this, rect.StartY);
							lowerY = ChartControl.GetYByValue(this, rect.EndY);
						}
						else
						{
							upperY = ChartControl.GetYByValue(this, rect.EndY);
							lowerY = ChartControl.GetYByValue(this, rect.StartY);
						}
						
						if ((upperY >= bounds.Y && upperY <= bounds.Y + bounds.Height) || 
							(lowerY >= bounds.Y && lowerY <= bounds.Y + bounds.Height))			// at least part visible, so draw the extension
						{
							int lastX;
							
							if (rect.StartTime < rect.EndTime)
							{
								lastX = ChartControl.GetXByTime(rect.EndTime);
							}
							else
							{
								lastX = ChartControl.GetXByTime(rect.StartTime);
							}
							
							Rectangle eRect = new Rectangle(lastX,  lowerY, bounds.Width - lastX + 1 - margin, upperY - lowerY + 1);
							
							if (areaOpacity > 0)
							{
								SolidBrush brush = new SolidBrush(Color.FromArgb(areaOpacity, rect.AreaColor.R, rect.AreaColor.G, rect.AreaColor.B));
								graphics.FillRectangle(brush, eRect);
								brush.Dispose();
							}
							else if (areaOpacity < 0)
							{
								SolidBrush brush = new SolidBrush(Color.FromArgb(Math.Max(0, rect.AreaOpacity + areaOpacity), rect.AreaColor.R, rect.AreaColor.G, rect.AreaColor.B));
								graphics.FillRectangle(brush, eRect);
								brush.Dispose();
							}
							else
							{
								SolidBrush brush = new SolidBrush(Color.FromArgb(rect.AreaOpacity, rect.AreaColor.R, rect.AreaColor.G, rect.AreaColor.B));
								graphics.FillRectangle(brush, eRect);
								brush.Dispose();
							}
							
							if (showLines)
							{
								graphics.DrawLine(rect.Pen, lastX, lowerY, bounds.Width - margin, lowerY);
								graphics.DrawLine(rect.Pen, lastX, upperY, bounds.Width - margin, upperY);
								
								if (margin != 0)
								{
									graphics.DrawLine(rect.Pen, bounds.Width - margin, lowerY, bounds.Width - margin, upperY);
								}		
							}
						}
					}
				}
			}
 		}
		
		#endregion
		
		
        #region Properties
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries Plot0
        {
            get { return Values[0]; }
        }

        [Description("")]
        [GridCategory("Parameters")]
        public string ChartName
        {
            get { return chartName; }
            set { chartName = value; }
        }

		
        [Description("")]
        [GridCategory("Parameters")]
        public string Diagnostics
        {
            get { return diagnostics; }
            set { diagnostics = value; }
        }
		

        [Description("")]
        [GridCategory("Parameters")]
        public string HotKey
        {
            get { return hotKeyString; }
            set { hotKeyString = value; }
        }
		

        [Description("")]
        [GridCategory("Parameters")]
        public string OnOffKey
        {
            get { return onOffKeyString; }
            set { onOffKeyString = value; }
        }
		

        [Description("")]
        [GridCategory("Parameters")]
        public string MouseMods
        {
            get { return mouseModString; }
            set { mouseModString = value; }
        }
		

        [Description("RHS Margin (pixels)")]
        [GridCategory("Parameters")]
		[Gui.Design.DisplayNameAttribute("RHS Margin")]
        public int Margin
        {
            get { return margin; }
            set { margin = Math.Max(0, value); }
        }
		
		
        [Description("")]
        [GridCategory("Parameters")]
        public bool ShowLines
        {
            get { return showLines; }
            set { showLines = value; }
        }
		
		
        [Description("")]
        [GridCategory("Parameters")]
        public int Opacity
        {
            get { return opacity; }
            set { opacity = Math.Max(-9, Math.Min(10, value)); }
        }
		
		
		[GridCategory("Version")]
		[Gui.Design.DisplayNameAttribute("Info")]
		public string Versioninfo
		{
			get { return versionInfo; }
			set {  }
		}
		
        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private rfkExtendRects[] cacherfkExtendRects = null;

        private static rfkExtendRects checkrfkExtendRects = new rfkExtendRects();

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public rfkExtendRects rfkExtendRects(string chartName, string diagnostics, string hotKey, int margin, string mouseMods, string onOffKey, int opacity, bool showLines, string versioninfo)
        {
            return rfkExtendRects(Input, chartName, diagnostics, hotKey, margin, mouseMods, onOffKey, opacity, showLines, versioninfo);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public rfkExtendRects rfkExtendRects(Data.IDataSeries input, string chartName, string diagnostics, string hotKey, int margin, string mouseMods, string onOffKey, int opacity, bool showLines, string versioninfo)
        {
            if (cacherfkExtendRects != null)
                for (int idx = 0; idx < cacherfkExtendRects.Length; idx++)
                    if (cacherfkExtendRects[idx].ChartName == chartName && cacherfkExtendRects[idx].Diagnostics == diagnostics && cacherfkExtendRects[idx].HotKey == hotKey && cacherfkExtendRects[idx].Margin == margin && cacherfkExtendRects[idx].MouseMods == mouseMods && cacherfkExtendRects[idx].OnOffKey == onOffKey && cacherfkExtendRects[idx].Opacity == opacity && cacherfkExtendRects[idx].ShowLines == showLines && cacherfkExtendRects[idx].Versioninfo == versioninfo && cacherfkExtendRects[idx].EqualsInput(input))
                        return cacherfkExtendRects[idx];

            lock (checkrfkExtendRects)
            {
                checkrfkExtendRects.ChartName = chartName;
                chartName = checkrfkExtendRects.ChartName;
                checkrfkExtendRects.Diagnostics = diagnostics;
                diagnostics = checkrfkExtendRects.Diagnostics;
                checkrfkExtendRects.HotKey = hotKey;
                hotKey = checkrfkExtendRects.HotKey;
                checkrfkExtendRects.Margin = margin;
                margin = checkrfkExtendRects.Margin;
                checkrfkExtendRects.MouseMods = mouseMods;
                mouseMods = checkrfkExtendRects.MouseMods;
                checkrfkExtendRects.OnOffKey = onOffKey;
                onOffKey = checkrfkExtendRects.OnOffKey;
                checkrfkExtendRects.Opacity = opacity;
                opacity = checkrfkExtendRects.Opacity;
                checkrfkExtendRects.ShowLines = showLines;
                showLines = checkrfkExtendRects.ShowLines;
                checkrfkExtendRects.Versioninfo = versioninfo;
                versioninfo = checkrfkExtendRects.Versioninfo;

                if (cacherfkExtendRects != null)
                    for (int idx = 0; idx < cacherfkExtendRects.Length; idx++)
                        if (cacherfkExtendRects[idx].ChartName == chartName && cacherfkExtendRects[idx].Diagnostics == diagnostics && cacherfkExtendRects[idx].HotKey == hotKey && cacherfkExtendRects[idx].Margin == margin && cacherfkExtendRects[idx].MouseMods == mouseMods && cacherfkExtendRects[idx].OnOffKey == onOffKey && cacherfkExtendRects[idx].Opacity == opacity && cacherfkExtendRects[idx].ShowLines == showLines && cacherfkExtendRects[idx].Versioninfo == versioninfo && cacherfkExtendRects[idx].EqualsInput(input))
                            return cacherfkExtendRects[idx];

                rfkExtendRects indicator = new rfkExtendRects();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.ChartName = chartName;
                indicator.Diagnostics = diagnostics;
                indicator.HotKey = hotKey;
                indicator.Margin = margin;
                indicator.MouseMods = mouseMods;
                indicator.OnOffKey = onOffKey;
                indicator.Opacity = opacity;
                indicator.ShowLines = showLines;
                indicator.Versioninfo = versioninfo;
                Indicators.Add(indicator);
                indicator.SetUp();

                rfkExtendRects[] tmp = new rfkExtendRects[cacherfkExtendRects == null ? 1 : cacherfkExtendRects.Length + 1];
                if (cacherfkExtendRects != null)
                    cacherfkExtendRects.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacherfkExtendRects = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.rfkExtendRects rfkExtendRects(string chartName, string diagnostics, string hotKey, int margin, string mouseMods, string onOffKey, int opacity, bool showLines, string versioninfo)
        {
            return _indicator.rfkExtendRects(Input, chartName, diagnostics, hotKey, margin, mouseMods, onOffKey, opacity, showLines, versioninfo);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.rfkExtendRects rfkExtendRects(Data.IDataSeries input, string chartName, string diagnostics, string hotKey, int margin, string mouseMods, string onOffKey, int opacity, bool showLines, string versioninfo)
        {
            return _indicator.rfkExtendRects(input, chartName, diagnostics, hotKey, margin, mouseMods, onOffKey, opacity, showLines, versioninfo);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.rfkExtendRects rfkExtendRects(string chartName, string diagnostics, string hotKey, int margin, string mouseMods, string onOffKey, int opacity, bool showLines, string versioninfo)
        {
            return _indicator.rfkExtendRects(Input, chartName, diagnostics, hotKey, margin, mouseMods, onOffKey, opacity, showLines, versioninfo);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.rfkExtendRects rfkExtendRects(Data.IDataSeries input, string chartName, string diagnostics, string hotKey, int margin, string mouseMods, string onOffKey, int opacity, bool showLines, string versioninfo)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.rfkExtendRects(input, chartName, diagnostics, hotKey, margin, mouseMods, onOffKey, opacity, showLines, versioninfo);
        }
    }
}
#endregion
