//
// Copyright (C) 2006, NinjaTrader LLC <ninjatrader@ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private DeltaScalper[] cacheDeltaScalper = null;

        private static DeltaScalper checkDeltaScalper = new DeltaScalper();

        /// <summary>
        /// Order Flows Delta Scalper
        /// </summary>
        /// <returns></returns>
        public DeltaScalper DeltaScalper(string filename1, bool checkMinMax, int lookBackBars, int negativeThresholdRatio, double positiveThresholdRatio, int signalBoxHeight, int signalBoxWidth, int signalDisplacement)
        {
            return DeltaScalper(Input, filename1, checkMinMax, lookBackBars, negativeThresholdRatio, positiveThresholdRatio, signalBoxHeight, signalBoxWidth, signalDisplacement);
        }

        /// <summary>
        /// Order Flows Delta Scalper
        /// </summary>
        /// <returns></returns>
        public DeltaScalper DeltaScalper(Data.IDataSeries input, string filename1, bool checkMinMax, int lookBackBars, int negativeThresholdRatio, double positiveThresholdRatio, int signalBoxHeight, int signalBoxWidth, int signalDisplacement)
        {
            if (cacheDeltaScalper != null)
                for (int idx = 0; idx < cacheDeltaScalper.Length; idx++)
                    if (cacheDeltaScalper[idx].Filename1 == filename1 && cacheDeltaScalper[idx].CheckMinMax == checkMinMax && cacheDeltaScalper[idx].LookBackBars == lookBackBars && cacheDeltaScalper[idx].NegativeThresholdRatio == negativeThresholdRatio && Math.Abs(cacheDeltaScalper[idx].PositiveThresholdRatio - positiveThresholdRatio) <= double.Epsilon && cacheDeltaScalper[idx].SignalBoxHeight == signalBoxHeight && cacheDeltaScalper[idx].SignalBoxWidth == signalBoxWidth && cacheDeltaScalper[idx].SignalDisplacement == signalDisplacement && cacheDeltaScalper[idx].EqualsInput(input))
                        return cacheDeltaScalper[idx];

            lock (checkDeltaScalper)
            {
                checkDeltaScalper.Filename1 = filename1;
                filename1 = checkDeltaScalper.Filename1;
                checkDeltaScalper.CheckMinMax = checkMinMax;
                checkMinMax = checkDeltaScalper.CheckMinMax;
                checkDeltaScalper.LookBackBars = lookBackBars;
                lookBackBars = checkDeltaScalper.LookBackBars;
                checkDeltaScalper.NegativeThresholdRatio = negativeThresholdRatio;
                negativeThresholdRatio = checkDeltaScalper.NegativeThresholdRatio;
                checkDeltaScalper.PositiveThresholdRatio = positiveThresholdRatio;
                positiveThresholdRatio = checkDeltaScalper.PositiveThresholdRatio;
                checkDeltaScalper.SignalBoxHeight = signalBoxHeight;
                signalBoxHeight = checkDeltaScalper.SignalBoxHeight;
                checkDeltaScalper.SignalBoxWidth = signalBoxWidth;
                signalBoxWidth = checkDeltaScalper.SignalBoxWidth;
                checkDeltaScalper.SignalDisplacement = signalDisplacement;
                signalDisplacement = checkDeltaScalper.SignalDisplacement;

                if (cacheDeltaScalper != null)
                    for (int idx = 0; idx < cacheDeltaScalper.Length; idx++)
                        if (cacheDeltaScalper[idx].Filename1 == filename1 && cacheDeltaScalper[idx].CheckMinMax == checkMinMax && cacheDeltaScalper[idx].LookBackBars == lookBackBars && cacheDeltaScalper[idx].NegativeThresholdRatio == negativeThresholdRatio && Math.Abs(cacheDeltaScalper[idx].PositiveThresholdRatio - positiveThresholdRatio) <= double.Epsilon && cacheDeltaScalper[idx].SignalBoxHeight == signalBoxHeight && cacheDeltaScalper[idx].SignalBoxWidth == signalBoxWidth && cacheDeltaScalper[idx].SignalDisplacement == signalDisplacement && cacheDeltaScalper[idx].EqualsInput(input))
                            return cacheDeltaScalper[idx];

                DeltaScalper indicator = new DeltaScalper();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Filename1 = filename1;
                indicator.CheckMinMax = checkMinMax;
                indicator.LookBackBars = lookBackBars;
                indicator.NegativeThresholdRatio = negativeThresholdRatio;
                indicator.PositiveThresholdRatio = positiveThresholdRatio;
                indicator.SignalBoxHeight = signalBoxHeight;
                indicator.SignalBoxWidth = signalBoxWidth;
                indicator.SignalDisplacement = signalDisplacement;
                Indicators.Add(indicator);
                indicator.SetUp();

                DeltaScalper[] tmp = new DeltaScalper[cacheDeltaScalper == null ? 1 : cacheDeltaScalper.Length + 1];
                if (cacheDeltaScalper != null)
                    cacheDeltaScalper.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheDeltaScalper = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Order Flows Delta Scalper
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.DeltaScalper DeltaScalper(string filename1, bool checkMinMax, int lookBackBars, int negativeThresholdRatio, double positiveThresholdRatio, int signalBoxHeight, int signalBoxWidth, int signalDisplacement)
        {
            return _indicator.DeltaScalper(Input, filename1, checkMinMax, lookBackBars, negativeThresholdRatio, positiveThresholdRatio, signalBoxHeight, signalBoxWidth, signalDisplacement);
        }

        /// <summary>
        /// Order Flows Delta Scalper
        /// </summary>
        /// <returns></returns>
        public Indicator.DeltaScalper DeltaScalper(Data.IDataSeries input, string filename1, bool checkMinMax, int lookBackBars, int negativeThresholdRatio, double positiveThresholdRatio, int signalBoxHeight, int signalBoxWidth, int signalDisplacement)
        {
            return _indicator.DeltaScalper(input, filename1, checkMinMax, lookBackBars, negativeThresholdRatio, positiveThresholdRatio, signalBoxHeight, signalBoxWidth, signalDisplacement);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Order Flows Delta Scalper
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.DeltaScalper DeltaScalper(string filename1, bool checkMinMax, int lookBackBars, int negativeThresholdRatio, double positiveThresholdRatio, int signalBoxHeight, int signalBoxWidth, int signalDisplacement)
        {
            return _indicator.DeltaScalper(Input, filename1, checkMinMax, lookBackBars, negativeThresholdRatio, positiveThresholdRatio, signalBoxHeight, signalBoxWidth, signalDisplacement);
        }

        /// <summary>
        /// Order Flows Delta Scalper
        /// </summary>
        /// <returns></returns>
        public Indicator.DeltaScalper DeltaScalper(Data.IDataSeries input, string filename1, bool checkMinMax, int lookBackBars, int negativeThresholdRatio, double positiveThresholdRatio, int signalBoxHeight, int signalBoxWidth, int signalDisplacement)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.DeltaScalper(input, filename1, checkMinMax, lookBackBars, negativeThresholdRatio, positiveThresholdRatio, signalBoxHeight, signalBoxWidth, signalDisplacement);
        }
    }
}
#endregion
