//
// Copyright (C) 2006, NinjaTrader LLC <ninjatrader@ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private QuantumCSI[] cacheQuantumCSI = null;
        private QuantumCurrencyArray[] cacheQuantumCurrencyArray = null;
        private QuantumCurrencyHeatmap[] cacheQuantumCurrencyHeatmap = null;
        private QuantumCurrencyMatrix[] cacheQuantumCurrencyMatrix = null;
        private QuantumDynamicAccumulationAndDistribution[] cacheQuantumDynamicAccumulationAndDistribution = null;
        private QuantumDynamicPricePivots[] cacheQuantumDynamicPricePivots = null;
        private QuantumDynamicVolatility[] cacheQuantumDynamicVolatility = null;
        private QuantumEURX[] cacheQuantumEURX = null;
        private QuantumJPYX[] cacheQuantumJPYX = null;
        private QuantumTickSpeedometer[] cacheQuantumTickSpeedometer = null;
        private QuantumTrendMonitor[] cacheQuantumTrendMonitor = null;
        private QuantumTrends[] cacheQuantumTrends = null;
        private QuantumUSDX[] cacheQuantumUSDX = null;
        private QuantumVPOC[] cacheQuantumVPOC = null;

        private static QuantumCSI checkQuantumCSI = new QuantumCSI();
        private static QuantumCurrencyArray checkQuantumCurrencyArray = new QuantumCurrencyArray();
        private static QuantumCurrencyHeatmap checkQuantumCurrencyHeatmap = new QuantumCurrencyHeatmap();
        private static QuantumCurrencyMatrix checkQuantumCurrencyMatrix = new QuantumCurrencyMatrix();
        private static QuantumDynamicAccumulationAndDistribution checkQuantumDynamicAccumulationAndDistribution = new QuantumDynamicAccumulationAndDistribution();
        private static QuantumDynamicPricePivots checkQuantumDynamicPricePivots = new QuantumDynamicPricePivots();
        private static QuantumDynamicVolatility checkQuantumDynamicVolatility = new QuantumDynamicVolatility();
        private static QuantumEURX checkQuantumEURX = new QuantumEURX();
        private static QuantumJPYX checkQuantumJPYX = new QuantumJPYX();
        private static QuantumTickSpeedometer checkQuantumTickSpeedometer = new QuantumTickSpeedometer();
        private static QuantumTrendMonitor checkQuantumTrendMonitor = new QuantumTrendMonitor();
        private static QuantumTrends checkQuantumTrends = new QuantumTrends();
        private static QuantumUSDX checkQuantumUSDX = new QuantumUSDX();
        private static QuantumVPOC checkQuantumVPOC = new QuantumVPOC();

        /// <summary>
        /// Currency Strength Indicator by Quantum
        /// </summary>
        /// <returns></returns>
        public QuantumCSI QuantumCSI(int barsAgo, int period, bool showAUD, bool showCAD, bool showCHF, bool showEUR, bool showGBP, bool showJPY, bool showNZD, bool showUSD)
        {
            return QuantumCSI(Input, barsAgo, period, showAUD, showCAD, showCHF, showEUR, showGBP, showJPY, showNZD, showUSD);
        }

        /// <summary>
        /// Currency Strength Indicator by Quantum
        /// </summary>
        /// <returns></returns>
        public QuantumCSI QuantumCSI(Data.IDataSeries input, int barsAgo, int period, bool showAUD, bool showCAD, bool showCHF, bool showEUR, bool showGBP, bool showJPY, bool showNZD, bool showUSD)
        {
            if (cacheQuantumCSI != null)
                for (int idx = 0; idx < cacheQuantumCSI.Length; idx++)
                    if (cacheQuantumCSI[idx].BarsAgo == barsAgo && cacheQuantumCSI[idx].Period == period && cacheQuantumCSI[idx].ShowAUD == showAUD && cacheQuantumCSI[idx].ShowCAD == showCAD && cacheQuantumCSI[idx].ShowCHF == showCHF && cacheQuantumCSI[idx].ShowEUR == showEUR && cacheQuantumCSI[idx].ShowGBP == showGBP && cacheQuantumCSI[idx].ShowJPY == showJPY && cacheQuantumCSI[idx].ShowNZD == showNZD && cacheQuantumCSI[idx].ShowUSD == showUSD && cacheQuantumCSI[idx].EqualsInput(input))
                        return cacheQuantumCSI[idx];

            lock (checkQuantumCSI)
            {
                checkQuantumCSI.BarsAgo = barsAgo;
                barsAgo = checkQuantumCSI.BarsAgo;
                checkQuantumCSI.Period = period;
                period = checkQuantumCSI.Period;
                checkQuantumCSI.ShowAUD = showAUD;
                showAUD = checkQuantumCSI.ShowAUD;
                checkQuantumCSI.ShowCAD = showCAD;
                showCAD = checkQuantumCSI.ShowCAD;
                checkQuantumCSI.ShowCHF = showCHF;
                showCHF = checkQuantumCSI.ShowCHF;
                checkQuantumCSI.ShowEUR = showEUR;
                showEUR = checkQuantumCSI.ShowEUR;
                checkQuantumCSI.ShowGBP = showGBP;
                showGBP = checkQuantumCSI.ShowGBP;
                checkQuantumCSI.ShowJPY = showJPY;
                showJPY = checkQuantumCSI.ShowJPY;
                checkQuantumCSI.ShowNZD = showNZD;
                showNZD = checkQuantumCSI.ShowNZD;
                checkQuantumCSI.ShowUSD = showUSD;
                showUSD = checkQuantumCSI.ShowUSD;

                if (cacheQuantumCSI != null)
                    for (int idx = 0; idx < cacheQuantumCSI.Length; idx++)
                        if (cacheQuantumCSI[idx].BarsAgo == barsAgo && cacheQuantumCSI[idx].Period == period && cacheQuantumCSI[idx].ShowAUD == showAUD && cacheQuantumCSI[idx].ShowCAD == showCAD && cacheQuantumCSI[idx].ShowCHF == showCHF && cacheQuantumCSI[idx].ShowEUR == showEUR && cacheQuantumCSI[idx].ShowGBP == showGBP && cacheQuantumCSI[idx].ShowJPY == showJPY && cacheQuantumCSI[idx].ShowNZD == showNZD && cacheQuantumCSI[idx].ShowUSD == showUSD && cacheQuantumCSI[idx].EqualsInput(input))
                            return cacheQuantumCSI[idx];

                QuantumCSI indicator = new QuantumCSI();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.BarsAgo = barsAgo;
                indicator.Period = period;
                indicator.ShowAUD = showAUD;
                indicator.ShowCAD = showCAD;
                indicator.ShowCHF = showCHF;
                indicator.ShowEUR = showEUR;
                indicator.ShowGBP = showGBP;
                indicator.ShowJPY = showJPY;
                indicator.ShowNZD = showNZD;
                indicator.ShowUSD = showUSD;
                Indicators.Add(indicator);
                indicator.SetUp();

                QuantumCSI[] tmp = new QuantumCSI[cacheQuantumCSI == null ? 1 : cacheQuantumCSI.Length + 1];
                if (cacheQuantumCSI != null)
                    cacheQuantumCSI.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheQuantumCSI = tmp;
                return indicator;
            }
        }

        /// <summary>
        /// First, it shows you instantly and clearly the strength of the buying or selling in the 28 currency pairs – in real time. Second, with a single click whether this is reflected across the related pairs. Third, whether this applies to both the base and counter currency of the currency pair you are considering. If it is, then the risk on the trade is low, and away you go.
        /// </summary>
        /// <returns></returns>
        public QuantumCurrencyArray QuantumCurrencyArray(bool dockToLeft, int lookBack, int oBOSPeriod)
        {
            return QuantumCurrencyArray(Input, dockToLeft, lookBack, oBOSPeriod);
        }

        /// <summary>
        /// First, it shows you instantly and clearly the strength of the buying or selling in the 28 currency pairs – in real time. Second, with a single click whether this is reflected across the related pairs. Third, whether this applies to both the base and counter currency of the currency pair you are considering. If it is, then the risk on the trade is low, and away you go.
        /// </summary>
        /// <returns></returns>
        public QuantumCurrencyArray QuantumCurrencyArray(Data.IDataSeries input, bool dockToLeft, int lookBack, int oBOSPeriod)
        {
            if (cacheQuantumCurrencyArray != null)
                for (int idx = 0; idx < cacheQuantumCurrencyArray.Length; idx++)
                    if (cacheQuantumCurrencyArray[idx].DockToLeft == dockToLeft && cacheQuantumCurrencyArray[idx].LookBack == lookBack && cacheQuantumCurrencyArray[idx].OBOSPeriod == oBOSPeriod && cacheQuantumCurrencyArray[idx].EqualsInput(input))
                        return cacheQuantumCurrencyArray[idx];

            lock (checkQuantumCurrencyArray)
            {
                checkQuantumCurrencyArray.DockToLeft = dockToLeft;
                dockToLeft = checkQuantumCurrencyArray.DockToLeft;
                checkQuantumCurrencyArray.LookBack = lookBack;
                lookBack = checkQuantumCurrencyArray.LookBack;
                checkQuantumCurrencyArray.OBOSPeriod = oBOSPeriod;
                oBOSPeriod = checkQuantumCurrencyArray.OBOSPeriod;

                if (cacheQuantumCurrencyArray != null)
                    for (int idx = 0; idx < cacheQuantumCurrencyArray.Length; idx++)
                        if (cacheQuantumCurrencyArray[idx].DockToLeft == dockToLeft && cacheQuantumCurrencyArray[idx].LookBack == lookBack && cacheQuantumCurrencyArray[idx].OBOSPeriod == oBOSPeriod && cacheQuantumCurrencyArray[idx].EqualsInput(input))
                            return cacheQuantumCurrencyArray[idx];

                QuantumCurrencyArray indicator = new QuantumCurrencyArray();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.DockToLeft = dockToLeft;
                indicator.LookBack = lookBack;
                indicator.OBOSPeriod = oBOSPeriod;
                Indicators.Add(indicator);
                indicator.SetUp();

                QuantumCurrencyArray[] tmp = new QuantumCurrencyArray[cacheQuantumCurrencyArray == null ? 1 : cacheQuantumCurrencyArray.Length + 1];
                if (cacheQuantumCurrencyArray != null)
                    cacheQuantumCurrencyArray.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheQuantumCurrencyArray = tmp;
                return indicator;
            }
        }

        /// <summary>
        /// First, it shows you instantly and clearly the strength of the buying or selling in the 28 currency pairs – in real time. Second, with a single click whether this is reflected across the related pairs. Third, whether this applies to both the base and counter currency of the currency pair you are considering. If it is, then the risk on the trade is low, and away you go.
        /// </summary>
        /// <returns></returns>
        public QuantumCurrencyHeatmap QuantumCurrencyHeatmap(bool dockToLeft, int lookBack)
        {
            return QuantumCurrencyHeatmap(Input, dockToLeft, lookBack);
        }

        /// <summary>
        /// First, it shows you instantly and clearly the strength of the buying or selling in the 28 currency pairs – in real time. Second, with a single click whether this is reflected across the related pairs. Third, whether this applies to both the base and counter currency of the currency pair you are considering. If it is, then the risk on the trade is low, and away you go.
        /// </summary>
        /// <returns></returns>
        public QuantumCurrencyHeatmap QuantumCurrencyHeatmap(Data.IDataSeries input, bool dockToLeft, int lookBack)
        {
            if (cacheQuantumCurrencyHeatmap != null)
                for (int idx = 0; idx < cacheQuantumCurrencyHeatmap.Length; idx++)
                    if (cacheQuantumCurrencyHeatmap[idx].DockToLeft == dockToLeft && cacheQuantumCurrencyHeatmap[idx].LookBack == lookBack && cacheQuantumCurrencyHeatmap[idx].EqualsInput(input))
                        return cacheQuantumCurrencyHeatmap[idx];

            lock (checkQuantumCurrencyHeatmap)
            {
                checkQuantumCurrencyHeatmap.DockToLeft = dockToLeft;
                dockToLeft = checkQuantumCurrencyHeatmap.DockToLeft;
                checkQuantumCurrencyHeatmap.LookBack = lookBack;
                lookBack = checkQuantumCurrencyHeatmap.LookBack;

                if (cacheQuantumCurrencyHeatmap != null)
                    for (int idx = 0; idx < cacheQuantumCurrencyHeatmap.Length; idx++)
                        if (cacheQuantumCurrencyHeatmap[idx].DockToLeft == dockToLeft && cacheQuantumCurrencyHeatmap[idx].LookBack == lookBack && cacheQuantumCurrencyHeatmap[idx].EqualsInput(input))
                            return cacheQuantumCurrencyHeatmap[idx];

                QuantumCurrencyHeatmap indicator = new QuantumCurrencyHeatmap();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.DockToLeft = dockToLeft;
                indicator.LookBack = lookBack;
                Indicators.Add(indicator);
                indicator.SetUp();

                QuantumCurrencyHeatmap[] tmp = new QuantumCurrencyHeatmap[cacheQuantumCurrencyHeatmap == null ? 1 : cacheQuantumCurrencyHeatmap.Length + 1];
                if (cacheQuantumCurrencyHeatmap != null)
                    cacheQuantumCurrencyHeatmap.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheQuantumCurrencyHeatmap = tmp;
                return indicator;
            }
        }

        /// <summary>
        /// First, it shows you instantly and clearly the strength of the buying or selling in the 28 currency pairs – in real time. Second, with a single click whether this is reflected across the related pairs. Third, whether this applies to both the base and counter currency of the currency pair you are considering. If it is, then the risk on the trade is low, and away you go.
        /// </summary>
        /// <returns></returns>
        public QuantumCurrencyMatrix QuantumCurrencyMatrix(bool classicColors, bool dockToLeft, int lookBack)
        {
            return QuantumCurrencyMatrix(Input, classicColors, dockToLeft, lookBack);
        }

        /// <summary>
        /// First, it shows you instantly and clearly the strength of the buying or selling in the 28 currency pairs – in real time. Second, with a single click whether this is reflected across the related pairs. Third, whether this applies to both the base and counter currency of the currency pair you are considering. If it is, then the risk on the trade is low, and away you go.
        /// </summary>
        /// <returns></returns>
        public QuantumCurrencyMatrix QuantumCurrencyMatrix(Data.IDataSeries input, bool classicColors, bool dockToLeft, int lookBack)
        {
            if (cacheQuantumCurrencyMatrix != null)
                for (int idx = 0; idx < cacheQuantumCurrencyMatrix.Length; idx++)
                    if (cacheQuantumCurrencyMatrix[idx].ClassicColors == classicColors && cacheQuantumCurrencyMatrix[idx].DockToLeft == dockToLeft && cacheQuantumCurrencyMatrix[idx].LookBack == lookBack && cacheQuantumCurrencyMatrix[idx].EqualsInput(input))
                        return cacheQuantumCurrencyMatrix[idx];

            lock (checkQuantumCurrencyMatrix)
            {
                checkQuantumCurrencyMatrix.ClassicColors = classicColors;
                classicColors = checkQuantumCurrencyMatrix.ClassicColors;
                checkQuantumCurrencyMatrix.DockToLeft = dockToLeft;
                dockToLeft = checkQuantumCurrencyMatrix.DockToLeft;
                checkQuantumCurrencyMatrix.LookBack = lookBack;
                lookBack = checkQuantumCurrencyMatrix.LookBack;

                if (cacheQuantumCurrencyMatrix != null)
                    for (int idx = 0; idx < cacheQuantumCurrencyMatrix.Length; idx++)
                        if (cacheQuantumCurrencyMatrix[idx].ClassicColors == classicColors && cacheQuantumCurrencyMatrix[idx].DockToLeft == dockToLeft && cacheQuantumCurrencyMatrix[idx].LookBack == lookBack && cacheQuantumCurrencyMatrix[idx].EqualsInput(input))
                            return cacheQuantumCurrencyMatrix[idx];

                QuantumCurrencyMatrix indicator = new QuantumCurrencyMatrix();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.ClassicColors = classicColors;
                indicator.DockToLeft = dockToLeft;
                indicator.LookBack = lookBack;
                Indicators.Add(indicator);
                indicator.SetUp();

                QuantumCurrencyMatrix[] tmp = new QuantumCurrencyMatrix[cacheQuantumCurrencyMatrix == null ? 1 : cacheQuantumCurrencyMatrix.Length + 1];
                if (cacheQuantumCurrencyMatrix != null)
                    cacheQuantumCurrencyMatrix.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheQuantumCurrencyMatrix = tmp;
                return indicator;
            }
        }

        /// <summary>
        /// Support and resistance indicator by Quantum
        /// </summary>
        /// <returns></returns>
        public QuantumDynamicAccumulationAndDistribution QuantumDynamicAccumulationAndDistribution(double clusterFactor, int labelOffset, DashStyle lineStyle, int period, Color resistanceLineColor, Color supportLineColor)
        {
            return QuantumDynamicAccumulationAndDistribution(Input, clusterFactor, labelOffset, lineStyle, period, resistanceLineColor, supportLineColor);
        }

        /// <summary>
        /// Support and resistance indicator by Quantum
        /// </summary>
        /// <returns></returns>
        public QuantumDynamicAccumulationAndDistribution QuantumDynamicAccumulationAndDistribution(Data.IDataSeries input, double clusterFactor, int labelOffset, DashStyle lineStyle, int period, Color resistanceLineColor, Color supportLineColor)
        {
            if (cacheQuantumDynamicAccumulationAndDistribution != null)
                for (int idx = 0; idx < cacheQuantumDynamicAccumulationAndDistribution.Length; idx++)
                    if (Math.Abs(cacheQuantumDynamicAccumulationAndDistribution[idx].ClusterFactor - clusterFactor) <= double.Epsilon && cacheQuantumDynamicAccumulationAndDistribution[idx].LabelOffset == labelOffset && cacheQuantumDynamicAccumulationAndDistribution[idx].LineStyle == lineStyle && cacheQuantumDynamicAccumulationAndDistribution[idx].Period == period && cacheQuantumDynamicAccumulationAndDistribution[idx].ResistanceLineColor == resistanceLineColor && cacheQuantumDynamicAccumulationAndDistribution[idx].SupportLineColor == supportLineColor && cacheQuantumDynamicAccumulationAndDistribution[idx].EqualsInput(input))
                        return cacheQuantumDynamicAccumulationAndDistribution[idx];

            lock (checkQuantumDynamicAccumulationAndDistribution)
            {
                checkQuantumDynamicAccumulationAndDistribution.ClusterFactor = clusterFactor;
                clusterFactor = checkQuantumDynamicAccumulationAndDistribution.ClusterFactor;
                checkQuantumDynamicAccumulationAndDistribution.LabelOffset = labelOffset;
                labelOffset = checkQuantumDynamicAccumulationAndDistribution.LabelOffset;
                checkQuantumDynamicAccumulationAndDistribution.LineStyle = lineStyle;
                lineStyle = checkQuantumDynamicAccumulationAndDistribution.LineStyle;
                checkQuantumDynamicAccumulationAndDistribution.Period = period;
                period = checkQuantumDynamicAccumulationAndDistribution.Period;
                checkQuantumDynamicAccumulationAndDistribution.ResistanceLineColor = resistanceLineColor;
                resistanceLineColor = checkQuantumDynamicAccumulationAndDistribution.ResistanceLineColor;
                checkQuantumDynamicAccumulationAndDistribution.SupportLineColor = supportLineColor;
                supportLineColor = checkQuantumDynamicAccumulationAndDistribution.SupportLineColor;

                if (cacheQuantumDynamicAccumulationAndDistribution != null)
                    for (int idx = 0; idx < cacheQuantumDynamicAccumulationAndDistribution.Length; idx++)
                        if (Math.Abs(cacheQuantumDynamicAccumulationAndDistribution[idx].ClusterFactor - clusterFactor) <= double.Epsilon && cacheQuantumDynamicAccumulationAndDistribution[idx].LabelOffset == labelOffset && cacheQuantumDynamicAccumulationAndDistribution[idx].LineStyle == lineStyle && cacheQuantumDynamicAccumulationAndDistribution[idx].Period == period && cacheQuantumDynamicAccumulationAndDistribution[idx].ResistanceLineColor == resistanceLineColor && cacheQuantumDynamicAccumulationAndDistribution[idx].SupportLineColor == supportLineColor && cacheQuantumDynamicAccumulationAndDistribution[idx].EqualsInput(input))
                            return cacheQuantumDynamicAccumulationAndDistribution[idx];

                QuantumDynamicAccumulationAndDistribution indicator = new QuantumDynamicAccumulationAndDistribution();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.ClusterFactor = clusterFactor;
                indicator.LabelOffset = labelOffset;
                indicator.LineStyle = lineStyle;
                indicator.Period = period;
                indicator.ResistanceLineColor = resistanceLineColor;
                indicator.SupportLineColor = supportLineColor;
                Indicators.Add(indicator);
                indicator.SetUp();

                QuantumDynamicAccumulationAndDistribution[] tmp = new QuantumDynamicAccumulationAndDistribution[cacheQuantumDynamicAccumulationAndDistribution == null ? 1 : cacheQuantumDynamicAccumulationAndDistribution.Length + 1];
                if (cacheQuantumDynamicAccumulationAndDistribution != null)
                    cacheQuantumDynamicAccumulationAndDistribution.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheQuantumDynamicAccumulationAndDistribution = tmp;
                return indicator;
            }
        }

        /// <summary>
        /// Pivots indicator by Quantum
        /// </summary>
        /// <returns></returns>
        public QuantumDynamicPricePivots QuantumDynamicPricePivots(double offset)
        {
            return QuantumDynamicPricePivots(Input, offset);
        }

        /// <summary>
        /// Pivots indicator by Quantum
        /// </summary>
        /// <returns></returns>
        public QuantumDynamicPricePivots QuantumDynamicPricePivots(Data.IDataSeries input, double offset)
        {
            if (cacheQuantumDynamicPricePivots != null)
                for (int idx = 0; idx < cacheQuantumDynamicPricePivots.Length; idx++)
                    if (Math.Abs(cacheQuantumDynamicPricePivots[idx].Offset - offset) <= double.Epsilon && cacheQuantumDynamicPricePivots[idx].EqualsInput(input))
                        return cacheQuantumDynamicPricePivots[idx];

            lock (checkQuantumDynamicPricePivots)
            {
                checkQuantumDynamicPricePivots.Offset = offset;
                offset = checkQuantumDynamicPricePivots.Offset;

                if (cacheQuantumDynamicPricePivots != null)
                    for (int idx = 0; idx < cacheQuantumDynamicPricePivots.Length; idx++)
                        if (Math.Abs(cacheQuantumDynamicPricePivots[idx].Offset - offset) <= double.Epsilon && cacheQuantumDynamicPricePivots[idx].EqualsInput(input))
                            return cacheQuantumDynamicPricePivots[idx];

                QuantumDynamicPricePivots indicator = new QuantumDynamicPricePivots();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Offset = offset;
                Indicators.Add(indicator);
                indicator.SetUp();

                QuantumDynamicPricePivots[] tmp = new QuantumDynamicPricePivots[cacheQuantumDynamicPricePivots == null ? 1 : cacheQuantumDynamicPricePivots.Length + 1];
                if (cacheQuantumDynamicPricePivots != null)
                    cacheQuantumDynamicPricePivots.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheQuantumDynamicPricePivots = tmp;
                return indicator;
            }
        }

        /// <summary>
        /// Wide range bars indicator by Quantum
        /// </summary>
        /// <returns></returns>
        public QuantumDynamicVolatility QuantumDynamicVolatility(double offset)
        {
            return QuantumDynamicVolatility(Input, offset);
        }

        /// <summary>
        /// Wide range bars indicator by Quantum
        /// </summary>
        /// <returns></returns>
        public QuantumDynamicVolatility QuantumDynamicVolatility(Data.IDataSeries input, double offset)
        {
            if (cacheQuantumDynamicVolatility != null)
                for (int idx = 0; idx < cacheQuantumDynamicVolatility.Length; idx++)
                    if (Math.Abs(cacheQuantumDynamicVolatility[idx].Offset - offset) <= double.Epsilon && cacheQuantumDynamicVolatility[idx].EqualsInput(input))
                        return cacheQuantumDynamicVolatility[idx];

            lock (checkQuantumDynamicVolatility)
            {
                checkQuantumDynamicVolatility.Offset = offset;
                offset = checkQuantumDynamicVolatility.Offset;

                if (cacheQuantumDynamicVolatility != null)
                    for (int idx = 0; idx < cacheQuantumDynamicVolatility.Length; idx++)
                        if (Math.Abs(cacheQuantumDynamicVolatility[idx].Offset - offset) <= double.Epsilon && cacheQuantumDynamicVolatility[idx].EqualsInput(input))
                            return cacheQuantumDynamicVolatility[idx];

                QuantumDynamicVolatility indicator = new QuantumDynamicVolatility();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Offset = offset;
                Indicators.Add(indicator);
                indicator.SetUp();

                QuantumDynamicVolatility[] tmp = new QuantumDynamicVolatility[cacheQuantumDynamicVolatility == null ? 1 : cacheQuantumDynamicVolatility.Length + 1];
                if (cacheQuantumDynamicVolatility != null)
                    cacheQuantumDynamicVolatility.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheQuantumDynamicVolatility = tmp;
                return indicator;
            }
        }

        /// <summary>
        /// Euro Index indicator by Quantum
        /// </summary>
        /// <returns></returns>
        public QuantumEURX QuantumEURX(int mAPeriod1, int mAPeriod2, QuantumEURXMAPriceType mAPriceType)
        {
            return QuantumEURX(Input, mAPeriod1, mAPeriod2, mAPriceType);
        }

        /// <summary>
        /// Euro Index indicator by Quantum
        /// </summary>
        /// <returns></returns>
        public QuantumEURX QuantumEURX(Data.IDataSeries input, int mAPeriod1, int mAPeriod2, QuantumEURXMAPriceType mAPriceType)
        {
            if (cacheQuantumEURX != null)
                for (int idx = 0; idx < cacheQuantumEURX.Length; idx++)
                    if (cacheQuantumEURX[idx].MAPeriod1 == mAPeriod1 && cacheQuantumEURX[idx].MAPeriod2 == mAPeriod2 && cacheQuantumEURX[idx].MAPriceType == mAPriceType && cacheQuantumEURX[idx].EqualsInput(input))
                        return cacheQuantumEURX[idx];

            lock (checkQuantumEURX)
            {
                checkQuantumEURX.MAPeriod1 = mAPeriod1;
                mAPeriod1 = checkQuantumEURX.MAPeriod1;
                checkQuantumEURX.MAPeriod2 = mAPeriod2;
                mAPeriod2 = checkQuantumEURX.MAPeriod2;
                checkQuantumEURX.MAPriceType = mAPriceType;
                mAPriceType = checkQuantumEURX.MAPriceType;

                if (cacheQuantumEURX != null)
                    for (int idx = 0; idx < cacheQuantumEURX.Length; idx++)
                        if (cacheQuantumEURX[idx].MAPeriod1 == mAPeriod1 && cacheQuantumEURX[idx].MAPeriod2 == mAPeriod2 && cacheQuantumEURX[idx].MAPriceType == mAPriceType && cacheQuantumEURX[idx].EqualsInput(input))
                            return cacheQuantumEURX[idx];

                QuantumEURX indicator = new QuantumEURX();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.MAPeriod1 = mAPeriod1;
                indicator.MAPeriod2 = mAPeriod2;
                indicator.MAPriceType = mAPriceType;
                Indicators.Add(indicator);
                indicator.SetUp();

                QuantumEURX[] tmp = new QuantumEURX[cacheQuantumEURX == null ? 1 : cacheQuantumEURX.Length + 1];
                if (cacheQuantumEURX != null)
                    cacheQuantumEURX.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheQuantumEURX = tmp;
                return indicator;
            }
        }

        /// <summary>
        /// Japanese Yen Index indicator by Quantum
        /// </summary>
        /// <returns></returns>
        public QuantumJPYX QuantumJPYX(int mAPeriod1, int mAPeriod2, QuantumJPYXMAPriceType mAPriceType)
        {
            return QuantumJPYX(Input, mAPeriod1, mAPeriod2, mAPriceType);
        }

        /// <summary>
        /// Japanese Yen Index indicator by Quantum
        /// </summary>
        /// <returns></returns>
        public QuantumJPYX QuantumJPYX(Data.IDataSeries input, int mAPeriod1, int mAPeriod2, QuantumJPYXMAPriceType mAPriceType)
        {
            if (cacheQuantumJPYX != null)
                for (int idx = 0; idx < cacheQuantumJPYX.Length; idx++)
                    if (cacheQuantumJPYX[idx].MAPeriod1 == mAPeriod1 && cacheQuantumJPYX[idx].MAPeriod2 == mAPeriod2 && cacheQuantumJPYX[idx].MAPriceType == mAPriceType && cacheQuantumJPYX[idx].EqualsInput(input))
                        return cacheQuantumJPYX[idx];

            lock (checkQuantumJPYX)
            {
                checkQuantumJPYX.MAPeriod1 = mAPeriod1;
                mAPeriod1 = checkQuantumJPYX.MAPeriod1;
                checkQuantumJPYX.MAPeriod2 = mAPeriod2;
                mAPeriod2 = checkQuantumJPYX.MAPeriod2;
                checkQuantumJPYX.MAPriceType = mAPriceType;
                mAPriceType = checkQuantumJPYX.MAPriceType;

                if (cacheQuantumJPYX != null)
                    for (int idx = 0; idx < cacheQuantumJPYX.Length; idx++)
                        if (cacheQuantumJPYX[idx].MAPeriod1 == mAPeriod1 && cacheQuantumJPYX[idx].MAPeriod2 == mAPeriod2 && cacheQuantumJPYX[idx].MAPriceType == mAPriceType && cacheQuantumJPYX[idx].EqualsInput(input))
                            return cacheQuantumJPYX[idx];

                QuantumJPYX indicator = new QuantumJPYX();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.MAPeriod1 = mAPeriod1;
                indicator.MAPeriod2 = mAPeriod2;
                indicator.MAPriceType = mAPriceType;
                Indicators.Add(indicator);
                indicator.SetUp();

                QuantumJPYX[] tmp = new QuantumJPYX[cacheQuantumJPYX == null ? 1 : cacheQuantumJPYX.Length + 1];
                if (cacheQuantumJPYX != null)
                    cacheQuantumJPYX.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheQuantumJPYX = tmp;
                return indicator;
            }
        }

        /// <summary>
        /// Tick speed meter by Quantum
        /// </summary>
        /// <returns></returns>
        public QuantumTickSpeedometer QuantumTickSpeedometer(int period)
        {
            return QuantumTickSpeedometer(Input, period);
        }

        /// <summary>
        /// Tick speed meter by Quantum
        /// </summary>
        /// <returns></returns>
        public QuantumTickSpeedometer QuantumTickSpeedometer(Data.IDataSeries input, int period)
        {
            if (cacheQuantumTickSpeedometer != null)
                for (int idx = 0; idx < cacheQuantumTickSpeedometer.Length; idx++)
                    if (cacheQuantumTickSpeedometer[idx].Period == period && cacheQuantumTickSpeedometer[idx].EqualsInput(input))
                        return cacheQuantumTickSpeedometer[idx];

            lock (checkQuantumTickSpeedometer)
            {
                checkQuantumTickSpeedometer.Period = period;
                period = checkQuantumTickSpeedometer.Period;

                if (cacheQuantumTickSpeedometer != null)
                    for (int idx = 0; idx < cacheQuantumTickSpeedometer.Length; idx++)
                        if (cacheQuantumTickSpeedometer[idx].Period == period && cacheQuantumTickSpeedometer[idx].EqualsInput(input))
                            return cacheQuantumTickSpeedometer[idx];

                QuantumTickSpeedometer indicator = new QuantumTickSpeedometer();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Period = period;
                Indicators.Add(indicator);
                indicator.SetUp();

                QuantumTickSpeedometer[] tmp = new QuantumTickSpeedometer[cacheQuantumTickSpeedometer == null ? 1 : cacheQuantumTickSpeedometer.Length + 1];
                if (cacheQuantumTickSpeedometer != null)
                    cacheQuantumTickSpeedometer.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheQuantumTickSpeedometer = tmp;
                return indicator;
            }
        }

        /// <summary>
        /// Trend momentum indicator by Quantum
        /// </summary>
        /// <returns></returns>
        public QuantumTrendMonitor QuantumTrendMonitor(QuantumTrendMonitorMode mode, double neutralConstant)
        {
            return QuantumTrendMonitor(Input, mode, neutralConstant);
        }

        /// <summary>
        /// Trend momentum indicator by Quantum
        /// </summary>
        /// <returns></returns>
        public QuantumTrendMonitor QuantumTrendMonitor(Data.IDataSeries input, QuantumTrendMonitorMode mode, double neutralConstant)
        {
            if (cacheQuantumTrendMonitor != null)
                for (int idx = 0; idx < cacheQuantumTrendMonitor.Length; idx++)
                    if (cacheQuantumTrendMonitor[idx].Mode == mode && Math.Abs(cacheQuantumTrendMonitor[idx].NeutralConstant - neutralConstant) <= double.Epsilon && cacheQuantumTrendMonitor[idx].EqualsInput(input))
                        return cacheQuantumTrendMonitor[idx];

            lock (checkQuantumTrendMonitor)
            {
                checkQuantumTrendMonitor.Mode = mode;
                mode = checkQuantumTrendMonitor.Mode;
                checkQuantumTrendMonitor.NeutralConstant = neutralConstant;
                neutralConstant = checkQuantumTrendMonitor.NeutralConstant;

                if (cacheQuantumTrendMonitor != null)
                    for (int idx = 0; idx < cacheQuantumTrendMonitor.Length; idx++)
                        if (cacheQuantumTrendMonitor[idx].Mode == mode && Math.Abs(cacheQuantumTrendMonitor[idx].NeutralConstant - neutralConstant) <= double.Epsilon && cacheQuantumTrendMonitor[idx].EqualsInput(input))
                            return cacheQuantumTrendMonitor[idx];

                QuantumTrendMonitor indicator = new QuantumTrendMonitor();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Mode = mode;
                indicator.NeutralConstant = neutralConstant;
                Indicators.Add(indicator);
                indicator.SetUp();

                QuantumTrendMonitor[] tmp = new QuantumTrendMonitor[cacheQuantumTrendMonitor == null ? 1 : cacheQuantumTrendMonitor.Length + 1];
                if (cacheQuantumTrendMonitor != null)
                    cacheQuantumTrendMonitor.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheQuantumTrendMonitor = tmp;
                return indicator;
            }
        }

        /// <summary>
        /// Trend dots indicator by Quantum
        /// </summary>
        /// <returns></returns>
        public QuantumTrends QuantumTrends(double neutralConstant)
        {
            return QuantumTrends(Input, neutralConstant);
        }

        /// <summary>
        /// Trend dots indicator by Quantum
        /// </summary>
        /// <returns></returns>
        public QuantumTrends QuantumTrends(Data.IDataSeries input, double neutralConstant)
        {
            if (cacheQuantumTrends != null)
                for (int idx = 0; idx < cacheQuantumTrends.Length; idx++)
                    if (Math.Abs(cacheQuantumTrends[idx].NeutralConstant - neutralConstant) <= double.Epsilon && cacheQuantumTrends[idx].EqualsInput(input))
                        return cacheQuantumTrends[idx];

            lock (checkQuantumTrends)
            {
                checkQuantumTrends.NeutralConstant = neutralConstant;
                neutralConstant = checkQuantumTrends.NeutralConstant;

                if (cacheQuantumTrends != null)
                    for (int idx = 0; idx < cacheQuantumTrends.Length; idx++)
                        if (Math.Abs(cacheQuantumTrends[idx].NeutralConstant - neutralConstant) <= double.Epsilon && cacheQuantumTrends[idx].EqualsInput(input))
                            return cacheQuantumTrends[idx];

                QuantumTrends indicator = new QuantumTrends();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.NeutralConstant = neutralConstant;
                Indicators.Add(indicator);
                indicator.SetUp();

                QuantumTrends[] tmp = new QuantumTrends[cacheQuantumTrends == null ? 1 : cacheQuantumTrends.Length + 1];
                if (cacheQuantumTrends != null)
                    cacheQuantumTrends.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheQuantumTrends = tmp;
                return indicator;
            }
        }

        /// <summary>
        /// US Dollar Index indicator by Quantum
        /// </summary>
        /// <returns></returns>
        public QuantumUSDX QuantumUSDX(int mAPeriod1, int mAPeriod2, QuantumUSDXMAPriceType mAPriceType)
        {
            return QuantumUSDX(Input, mAPeriod1, mAPeriod2, mAPriceType);
        }

        /// <summary>
        /// US Dollar Index indicator by Quantum
        /// </summary>
        /// <returns></returns>
        public QuantumUSDX QuantumUSDX(Data.IDataSeries input, int mAPeriod1, int mAPeriod2, QuantumUSDXMAPriceType mAPriceType)
        {
            if (cacheQuantumUSDX != null)
                for (int idx = 0; idx < cacheQuantumUSDX.Length; idx++)
                    if (cacheQuantumUSDX[idx].MAPeriod1 == mAPeriod1 && cacheQuantumUSDX[idx].MAPeriod2 == mAPeriod2 && cacheQuantumUSDX[idx].MAPriceType == mAPriceType && cacheQuantumUSDX[idx].EqualsInput(input))
                        return cacheQuantumUSDX[idx];

            lock (checkQuantumUSDX)
            {
                checkQuantumUSDX.MAPeriod1 = mAPeriod1;
                mAPeriod1 = checkQuantumUSDX.MAPeriod1;
                checkQuantumUSDX.MAPeriod2 = mAPeriod2;
                mAPeriod2 = checkQuantumUSDX.MAPeriod2;
                checkQuantumUSDX.MAPriceType = mAPriceType;
                mAPriceType = checkQuantumUSDX.MAPriceType;

                if (cacheQuantumUSDX != null)
                    for (int idx = 0; idx < cacheQuantumUSDX.Length; idx++)
                        if (cacheQuantumUSDX[idx].MAPeriod1 == mAPeriod1 && cacheQuantumUSDX[idx].MAPeriod2 == mAPeriod2 && cacheQuantumUSDX[idx].MAPriceType == mAPriceType && cacheQuantumUSDX[idx].EqualsInput(input))
                            return cacheQuantumUSDX[idx];

                QuantumUSDX indicator = new QuantumUSDX();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.MAPeriod1 = mAPeriod1;
                indicator.MAPeriod2 = mAPeriod2;
                indicator.MAPriceType = mAPriceType;
                Indicators.Add(indicator);
                indicator.SetUp();

                QuantumUSDX[] tmp = new QuantumUSDX[cacheQuantumUSDX == null ? 1 : cacheQuantumUSDX.Length + 1];
                if (cacheQuantumUSDX != null)
                    cacheQuantumUSDX.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheQuantumUSDX = tmp;
                return indicator;
            }
        }

        /// <summary>
        /// Volume Point of Control by Quantum Trading
        /// </summary>
        /// <returns></returns>
        public QuantumVPOC QuantumVPOC(int lookBackPeriod, int regionCount, bool showSupportResistance, bool showVolumePointOfControl, bool showVolumeProfile, Color sRColor1, Color sRColor2, Color volumeProfileColor1, Color volumeProfileColor2, Color vPOCColor, QuantumVPOCSRLineCount vPOCSRLineCount)
        {
            return QuantumVPOC(Input, lookBackPeriod, regionCount, showSupportResistance, showVolumePointOfControl, showVolumeProfile, sRColor1, sRColor2, volumeProfileColor1, volumeProfileColor2, vPOCColor, vPOCSRLineCount);
        }

        /// <summary>
        /// Volume Point of Control by Quantum Trading
        /// </summary>
        /// <returns></returns>
        public QuantumVPOC QuantumVPOC(Data.IDataSeries input, int lookBackPeriod, int regionCount, bool showSupportResistance, bool showVolumePointOfControl, bool showVolumeProfile, Color sRColor1, Color sRColor2, Color volumeProfileColor1, Color volumeProfileColor2, Color vPOCColor, QuantumVPOCSRLineCount vPOCSRLineCount)
        {
            if (cacheQuantumVPOC != null)
                for (int idx = 0; idx < cacheQuantumVPOC.Length; idx++)
                    if (cacheQuantumVPOC[idx].LookBackPeriod == lookBackPeriod && cacheQuantumVPOC[idx].RegionCount == regionCount && cacheQuantumVPOC[idx].ShowSupportResistance == showSupportResistance && cacheQuantumVPOC[idx].ShowVolumePointOfControl == showVolumePointOfControl && cacheQuantumVPOC[idx].ShowVolumeProfile == showVolumeProfile && cacheQuantumVPOC[idx].SRColor1 == sRColor1 && cacheQuantumVPOC[idx].SRColor2 == sRColor2 && cacheQuantumVPOC[idx].VolumeProfileColor1 == volumeProfileColor1 && cacheQuantumVPOC[idx].VolumeProfileColor2 == volumeProfileColor2 && cacheQuantumVPOC[idx].VPOCColor == vPOCColor && cacheQuantumVPOC[idx].VPOCSRLineCount == vPOCSRLineCount && cacheQuantumVPOC[idx].EqualsInput(input))
                        return cacheQuantumVPOC[idx];

            lock (checkQuantumVPOC)
            {
                checkQuantumVPOC.LookBackPeriod = lookBackPeriod;
                lookBackPeriod = checkQuantumVPOC.LookBackPeriod;
                checkQuantumVPOC.RegionCount = regionCount;
                regionCount = checkQuantumVPOC.RegionCount;
                checkQuantumVPOC.ShowSupportResistance = showSupportResistance;
                showSupportResistance = checkQuantumVPOC.ShowSupportResistance;
                checkQuantumVPOC.ShowVolumePointOfControl = showVolumePointOfControl;
                showVolumePointOfControl = checkQuantumVPOC.ShowVolumePointOfControl;
                checkQuantumVPOC.ShowVolumeProfile = showVolumeProfile;
                showVolumeProfile = checkQuantumVPOC.ShowVolumeProfile;
                checkQuantumVPOC.SRColor1 = sRColor1;
                sRColor1 = checkQuantumVPOC.SRColor1;
                checkQuantumVPOC.SRColor2 = sRColor2;
                sRColor2 = checkQuantumVPOC.SRColor2;
                checkQuantumVPOC.VolumeProfileColor1 = volumeProfileColor1;
                volumeProfileColor1 = checkQuantumVPOC.VolumeProfileColor1;
                checkQuantumVPOC.VolumeProfileColor2 = volumeProfileColor2;
                volumeProfileColor2 = checkQuantumVPOC.VolumeProfileColor2;
                checkQuantumVPOC.VPOCColor = vPOCColor;
                vPOCColor = checkQuantumVPOC.VPOCColor;
                checkQuantumVPOC.VPOCSRLineCount = vPOCSRLineCount;
                vPOCSRLineCount = checkQuantumVPOC.VPOCSRLineCount;

                if (cacheQuantumVPOC != null)
                    for (int idx = 0; idx < cacheQuantumVPOC.Length; idx++)
                        if (cacheQuantumVPOC[idx].LookBackPeriod == lookBackPeriod && cacheQuantumVPOC[idx].RegionCount == regionCount && cacheQuantumVPOC[idx].ShowSupportResistance == showSupportResistance && cacheQuantumVPOC[idx].ShowVolumePointOfControl == showVolumePointOfControl && cacheQuantumVPOC[idx].ShowVolumeProfile == showVolumeProfile && cacheQuantumVPOC[idx].SRColor1 == sRColor1 && cacheQuantumVPOC[idx].SRColor2 == sRColor2 && cacheQuantumVPOC[idx].VolumeProfileColor1 == volumeProfileColor1 && cacheQuantumVPOC[idx].VolumeProfileColor2 == volumeProfileColor2 && cacheQuantumVPOC[idx].VPOCColor == vPOCColor && cacheQuantumVPOC[idx].VPOCSRLineCount == vPOCSRLineCount && cacheQuantumVPOC[idx].EqualsInput(input))
                            return cacheQuantumVPOC[idx];

                QuantumVPOC indicator = new QuantumVPOC();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.LookBackPeriod = lookBackPeriod;
                indicator.RegionCount = regionCount;
                indicator.ShowSupportResistance = showSupportResistance;
                indicator.ShowVolumePointOfControl = showVolumePointOfControl;
                indicator.ShowVolumeProfile = showVolumeProfile;
                indicator.SRColor1 = sRColor1;
                indicator.SRColor2 = sRColor2;
                indicator.VolumeProfileColor1 = volumeProfileColor1;
                indicator.VolumeProfileColor2 = volumeProfileColor2;
                indicator.VPOCColor = vPOCColor;
                indicator.VPOCSRLineCount = vPOCSRLineCount;
                Indicators.Add(indicator);
                indicator.SetUp();

                QuantumVPOC[] tmp = new QuantumVPOC[cacheQuantumVPOC == null ? 1 : cacheQuantumVPOC.Length + 1];
                if (cacheQuantumVPOC != null)
                    cacheQuantumVPOC.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheQuantumVPOC = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Currency Strength Indicator by Quantum
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.QuantumCSI QuantumCSI(int barsAgo, int period, bool showAUD, bool showCAD, bool showCHF, bool showEUR, bool showGBP, bool showJPY, bool showNZD, bool showUSD)
        {
            return _indicator.QuantumCSI(Input, barsAgo, period, showAUD, showCAD, showCHF, showEUR, showGBP, showJPY, showNZD, showUSD);
        }

        /// <summary>
        /// Currency Strength Indicator by Quantum
        /// </summary>
        /// <returns></returns>
        public Indicator.QuantumCSI QuantumCSI(Data.IDataSeries input, int barsAgo, int period, bool showAUD, bool showCAD, bool showCHF, bool showEUR, bool showGBP, bool showJPY, bool showNZD, bool showUSD)
        {
            return _indicator.QuantumCSI(input, barsAgo, period, showAUD, showCAD, showCHF, showEUR, showGBP, showJPY, showNZD, showUSD);
        }

        /// <summary>
        /// First, it shows you instantly and clearly the strength of the buying or selling in the 28 currency pairs – in real time. Second, with a single click whether this is reflected across the related pairs. Third, whether this applies to both the base and counter currency of the currency pair you are considering. If it is, then the risk on the trade is low, and away you go.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.QuantumCurrencyArray QuantumCurrencyArray(bool dockToLeft, int lookBack, int oBOSPeriod)
        {
            return _indicator.QuantumCurrencyArray(Input, dockToLeft, lookBack, oBOSPeriod);
        }

        /// <summary>
        /// First, it shows you instantly and clearly the strength of the buying or selling in the 28 currency pairs – in real time. Second, with a single click whether this is reflected across the related pairs. Third, whether this applies to both the base and counter currency of the currency pair you are considering. If it is, then the risk on the trade is low, and away you go.
        /// </summary>
        /// <returns></returns>
        public Indicator.QuantumCurrencyArray QuantumCurrencyArray(Data.IDataSeries input, bool dockToLeft, int lookBack, int oBOSPeriod)
        {
            return _indicator.QuantumCurrencyArray(input, dockToLeft, lookBack, oBOSPeriod);
        }

        /// <summary>
        /// First, it shows you instantly and clearly the strength of the buying or selling in the 28 currency pairs – in real time. Second, with a single click whether this is reflected across the related pairs. Third, whether this applies to both the base and counter currency of the currency pair you are considering. If it is, then the risk on the trade is low, and away you go.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.QuantumCurrencyHeatmap QuantumCurrencyHeatmap(bool dockToLeft, int lookBack)
        {
            return _indicator.QuantumCurrencyHeatmap(Input, dockToLeft, lookBack);
        }

        /// <summary>
        /// First, it shows you instantly and clearly the strength of the buying or selling in the 28 currency pairs – in real time. Second, with a single click whether this is reflected across the related pairs. Third, whether this applies to both the base and counter currency of the currency pair you are considering. If it is, then the risk on the trade is low, and away you go.
        /// </summary>
        /// <returns></returns>
        public Indicator.QuantumCurrencyHeatmap QuantumCurrencyHeatmap(Data.IDataSeries input, bool dockToLeft, int lookBack)
        {
            return _indicator.QuantumCurrencyHeatmap(input, dockToLeft, lookBack);
        }

        /// <summary>
        /// First, it shows you instantly and clearly the strength of the buying or selling in the 28 currency pairs – in real time. Second, with a single click whether this is reflected across the related pairs. Third, whether this applies to both the base and counter currency of the currency pair you are considering. If it is, then the risk on the trade is low, and away you go.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.QuantumCurrencyMatrix QuantumCurrencyMatrix(bool classicColors, bool dockToLeft, int lookBack)
        {
            return _indicator.QuantumCurrencyMatrix(Input, classicColors, dockToLeft, lookBack);
        }

        /// <summary>
        /// First, it shows you instantly and clearly the strength of the buying or selling in the 28 currency pairs – in real time. Second, with a single click whether this is reflected across the related pairs. Third, whether this applies to both the base and counter currency of the currency pair you are considering. If it is, then the risk on the trade is low, and away you go.
        /// </summary>
        /// <returns></returns>
        public Indicator.QuantumCurrencyMatrix QuantumCurrencyMatrix(Data.IDataSeries input, bool classicColors, bool dockToLeft, int lookBack)
        {
            return _indicator.QuantumCurrencyMatrix(input, classicColors, dockToLeft, lookBack);
        }

        /// <summary>
        /// Support and resistance indicator by Quantum
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.QuantumDynamicAccumulationAndDistribution QuantumDynamicAccumulationAndDistribution(double clusterFactor, int labelOffset, DashStyle lineStyle, int period, Color resistanceLineColor, Color supportLineColor)
        {
            return _indicator.QuantumDynamicAccumulationAndDistribution(Input, clusterFactor, labelOffset, lineStyle, period, resistanceLineColor, supportLineColor);
        }

        /// <summary>
        /// Support and resistance indicator by Quantum
        /// </summary>
        /// <returns></returns>
        public Indicator.QuantumDynamicAccumulationAndDistribution QuantumDynamicAccumulationAndDistribution(Data.IDataSeries input, double clusterFactor, int labelOffset, DashStyle lineStyle, int period, Color resistanceLineColor, Color supportLineColor)
        {
            return _indicator.QuantumDynamicAccumulationAndDistribution(input, clusterFactor, labelOffset, lineStyle, period, resistanceLineColor, supportLineColor);
        }

        /// <summary>
        /// Pivots indicator by Quantum
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.QuantumDynamicPricePivots QuantumDynamicPricePivots(double offset)
        {
            return _indicator.QuantumDynamicPricePivots(Input, offset);
        }

        /// <summary>
        /// Pivots indicator by Quantum
        /// </summary>
        /// <returns></returns>
        public Indicator.QuantumDynamicPricePivots QuantumDynamicPricePivots(Data.IDataSeries input, double offset)
        {
            return _indicator.QuantumDynamicPricePivots(input, offset);
        }

        /// <summary>
        /// Wide range bars indicator by Quantum
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.QuantumDynamicVolatility QuantumDynamicVolatility(double offset)
        {
            return _indicator.QuantumDynamicVolatility(Input, offset);
        }

        /// <summary>
        /// Wide range bars indicator by Quantum
        /// </summary>
        /// <returns></returns>
        public Indicator.QuantumDynamicVolatility QuantumDynamicVolatility(Data.IDataSeries input, double offset)
        {
            return _indicator.QuantumDynamicVolatility(input, offset);
        }

        /// <summary>
        /// Euro Index indicator by Quantum
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.QuantumEURX QuantumEURX(int mAPeriod1, int mAPeriod2, QuantumEURXMAPriceType mAPriceType)
        {
            return _indicator.QuantumEURX(Input, mAPeriod1, mAPeriod2, mAPriceType);
        }

        /// <summary>
        /// Euro Index indicator by Quantum
        /// </summary>
        /// <returns></returns>
        public Indicator.QuantumEURX QuantumEURX(Data.IDataSeries input, int mAPeriod1, int mAPeriod2, QuantumEURXMAPriceType mAPriceType)
        {
            return _indicator.QuantumEURX(input, mAPeriod1, mAPeriod2, mAPriceType);
        }

        /// <summary>
        /// Japanese Yen Index indicator by Quantum
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.QuantumJPYX QuantumJPYX(int mAPeriod1, int mAPeriod2, QuantumJPYXMAPriceType mAPriceType)
        {
            return _indicator.QuantumJPYX(Input, mAPeriod1, mAPeriod2, mAPriceType);
        }

        /// <summary>
        /// Japanese Yen Index indicator by Quantum
        /// </summary>
        /// <returns></returns>
        public Indicator.QuantumJPYX QuantumJPYX(Data.IDataSeries input, int mAPeriod1, int mAPeriod2, QuantumJPYXMAPriceType mAPriceType)
        {
            return _indicator.QuantumJPYX(input, mAPeriod1, mAPeriod2, mAPriceType);
        }

        /// <summary>
        /// Tick speed meter by Quantum
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.QuantumTickSpeedometer QuantumTickSpeedometer(int period)
        {
            return _indicator.QuantumTickSpeedometer(Input, period);
        }

        /// <summary>
        /// Tick speed meter by Quantum
        /// </summary>
        /// <returns></returns>
        public Indicator.QuantumTickSpeedometer QuantumTickSpeedometer(Data.IDataSeries input, int period)
        {
            return _indicator.QuantumTickSpeedometer(input, period);
        }

        /// <summary>
        /// Trend momentum indicator by Quantum
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.QuantumTrendMonitor QuantumTrendMonitor(QuantumTrendMonitorMode mode, double neutralConstant)
        {
            return _indicator.QuantumTrendMonitor(Input, mode, neutralConstant);
        }

        /// <summary>
        /// Trend momentum indicator by Quantum
        /// </summary>
        /// <returns></returns>
        public Indicator.QuantumTrendMonitor QuantumTrendMonitor(Data.IDataSeries input, QuantumTrendMonitorMode mode, double neutralConstant)
        {
            return _indicator.QuantumTrendMonitor(input, mode, neutralConstant);
        }

        /// <summary>
        /// Trend dots indicator by Quantum
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.QuantumTrends QuantumTrends(double neutralConstant)
        {
            return _indicator.QuantumTrends(Input, neutralConstant);
        }

        /// <summary>
        /// Trend dots indicator by Quantum
        /// </summary>
        /// <returns></returns>
        public Indicator.QuantumTrends QuantumTrends(Data.IDataSeries input, double neutralConstant)
        {
            return _indicator.QuantumTrends(input, neutralConstant);
        }

        /// <summary>
        /// US Dollar Index indicator by Quantum
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.QuantumUSDX QuantumUSDX(int mAPeriod1, int mAPeriod2, QuantumUSDXMAPriceType mAPriceType)
        {
            return _indicator.QuantumUSDX(Input, mAPeriod1, mAPeriod2, mAPriceType);
        }

        /// <summary>
        /// US Dollar Index indicator by Quantum
        /// </summary>
        /// <returns></returns>
        public Indicator.QuantumUSDX QuantumUSDX(Data.IDataSeries input, int mAPeriod1, int mAPeriod2, QuantumUSDXMAPriceType mAPriceType)
        {
            return _indicator.QuantumUSDX(input, mAPeriod1, mAPeriod2, mAPriceType);
        }

        /// <summary>
        /// Volume Point of Control by Quantum Trading
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.QuantumVPOC QuantumVPOC(int lookBackPeriod, int regionCount, bool showSupportResistance, bool showVolumePointOfControl, bool showVolumeProfile, Color sRColor1, Color sRColor2, Color volumeProfileColor1, Color volumeProfileColor2, Color vPOCColor, QuantumVPOCSRLineCount vPOCSRLineCount)
        {
            return _indicator.QuantumVPOC(Input, lookBackPeriod, regionCount, showSupportResistance, showVolumePointOfControl, showVolumeProfile, sRColor1, sRColor2, volumeProfileColor1, volumeProfileColor2, vPOCColor, vPOCSRLineCount);
        }

        /// <summary>
        /// Volume Point of Control by Quantum Trading
        /// </summary>
        /// <returns></returns>
        public Indicator.QuantumVPOC QuantumVPOC(Data.IDataSeries input, int lookBackPeriod, int regionCount, bool showSupportResistance, bool showVolumePointOfControl, bool showVolumeProfile, Color sRColor1, Color sRColor2, Color volumeProfileColor1, Color volumeProfileColor2, Color vPOCColor, QuantumVPOCSRLineCount vPOCSRLineCount)
        {
            return _indicator.QuantumVPOC(input, lookBackPeriod, regionCount, showSupportResistance, showVolumePointOfControl, showVolumeProfile, sRColor1, sRColor2, volumeProfileColor1, volumeProfileColor2, vPOCColor, vPOCSRLineCount);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Currency Strength Indicator by Quantum
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.QuantumCSI QuantumCSI(int barsAgo, int period, bool showAUD, bool showCAD, bool showCHF, bool showEUR, bool showGBP, bool showJPY, bool showNZD, bool showUSD)
        {
            return _indicator.QuantumCSI(Input, barsAgo, period, showAUD, showCAD, showCHF, showEUR, showGBP, showJPY, showNZD, showUSD);
        }

        /// <summary>
        /// Currency Strength Indicator by Quantum
        /// </summary>
        /// <returns></returns>
        public Indicator.QuantumCSI QuantumCSI(Data.IDataSeries input, int barsAgo, int period, bool showAUD, bool showCAD, bool showCHF, bool showEUR, bool showGBP, bool showJPY, bool showNZD, bool showUSD)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.QuantumCSI(input, barsAgo, period, showAUD, showCAD, showCHF, showEUR, showGBP, showJPY, showNZD, showUSD);
        }

        /// <summary>
        /// First, it shows you instantly and clearly the strength of the buying or selling in the 28 currency pairs – in real time. Second, with a single click whether this is reflected across the related pairs. Third, whether this applies to both the base and counter currency of the currency pair you are considering. If it is, then the risk on the trade is low, and away you go.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.QuantumCurrencyArray QuantumCurrencyArray(bool dockToLeft, int lookBack, int oBOSPeriod)
        {
            return _indicator.QuantumCurrencyArray(Input, dockToLeft, lookBack, oBOSPeriod);
        }

        /// <summary>
        /// First, it shows you instantly and clearly the strength of the buying or selling in the 28 currency pairs – in real time. Second, with a single click whether this is reflected across the related pairs. Third, whether this applies to both the base and counter currency of the currency pair you are considering. If it is, then the risk on the trade is low, and away you go.
        /// </summary>
        /// <returns></returns>
        public Indicator.QuantumCurrencyArray QuantumCurrencyArray(Data.IDataSeries input, bool dockToLeft, int lookBack, int oBOSPeriod)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.QuantumCurrencyArray(input, dockToLeft, lookBack, oBOSPeriod);
        }

        /// <summary>
        /// First, it shows you instantly and clearly the strength of the buying or selling in the 28 currency pairs – in real time. Second, with a single click whether this is reflected across the related pairs. Third, whether this applies to both the base and counter currency of the currency pair you are considering. If it is, then the risk on the trade is low, and away you go.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.QuantumCurrencyHeatmap QuantumCurrencyHeatmap(bool dockToLeft, int lookBack)
        {
            return _indicator.QuantumCurrencyHeatmap(Input, dockToLeft, lookBack);
        }

        /// <summary>
        /// First, it shows you instantly and clearly the strength of the buying or selling in the 28 currency pairs – in real time. Second, with a single click whether this is reflected across the related pairs. Third, whether this applies to both the base and counter currency of the currency pair you are considering. If it is, then the risk on the trade is low, and away you go.
        /// </summary>
        /// <returns></returns>
        public Indicator.QuantumCurrencyHeatmap QuantumCurrencyHeatmap(Data.IDataSeries input, bool dockToLeft, int lookBack)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.QuantumCurrencyHeatmap(input, dockToLeft, lookBack);
        }

        /// <summary>
        /// First, it shows you instantly and clearly the strength of the buying or selling in the 28 currency pairs – in real time. Second, with a single click whether this is reflected across the related pairs. Third, whether this applies to both the base and counter currency of the currency pair you are considering. If it is, then the risk on the trade is low, and away you go.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.QuantumCurrencyMatrix QuantumCurrencyMatrix(bool classicColors, bool dockToLeft, int lookBack)
        {
            return _indicator.QuantumCurrencyMatrix(Input, classicColors, dockToLeft, lookBack);
        }

        /// <summary>
        /// First, it shows you instantly and clearly the strength of the buying or selling in the 28 currency pairs – in real time. Second, with a single click whether this is reflected across the related pairs. Third, whether this applies to both the base and counter currency of the currency pair you are considering. If it is, then the risk on the trade is low, and away you go.
        /// </summary>
        /// <returns></returns>
        public Indicator.QuantumCurrencyMatrix QuantumCurrencyMatrix(Data.IDataSeries input, bool classicColors, bool dockToLeft, int lookBack)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.QuantumCurrencyMatrix(input, classicColors, dockToLeft, lookBack);
        }

        /// <summary>
        /// Support and resistance indicator by Quantum
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.QuantumDynamicAccumulationAndDistribution QuantumDynamicAccumulationAndDistribution(double clusterFactor, int labelOffset, DashStyle lineStyle, int period, Color resistanceLineColor, Color supportLineColor)
        {
            return _indicator.QuantumDynamicAccumulationAndDistribution(Input, clusterFactor, labelOffset, lineStyle, period, resistanceLineColor, supportLineColor);
        }

        /// <summary>
        /// Support and resistance indicator by Quantum
        /// </summary>
        /// <returns></returns>
        public Indicator.QuantumDynamicAccumulationAndDistribution QuantumDynamicAccumulationAndDistribution(Data.IDataSeries input, double clusterFactor, int labelOffset, DashStyle lineStyle, int period, Color resistanceLineColor, Color supportLineColor)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.QuantumDynamicAccumulationAndDistribution(input, clusterFactor, labelOffset, lineStyle, period, resistanceLineColor, supportLineColor);
        }

        /// <summary>
        /// Pivots indicator by Quantum
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.QuantumDynamicPricePivots QuantumDynamicPricePivots(double offset)
        {
            return _indicator.QuantumDynamicPricePivots(Input, offset);
        }

        /// <summary>
        /// Pivots indicator by Quantum
        /// </summary>
        /// <returns></returns>
        public Indicator.QuantumDynamicPricePivots QuantumDynamicPricePivots(Data.IDataSeries input, double offset)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.QuantumDynamicPricePivots(input, offset);
        }

        /// <summary>
        /// Wide range bars indicator by Quantum
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.QuantumDynamicVolatility QuantumDynamicVolatility(double offset)
        {
            return _indicator.QuantumDynamicVolatility(Input, offset);
        }

        /// <summary>
        /// Wide range bars indicator by Quantum
        /// </summary>
        /// <returns></returns>
        public Indicator.QuantumDynamicVolatility QuantumDynamicVolatility(Data.IDataSeries input, double offset)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.QuantumDynamicVolatility(input, offset);
        }

        /// <summary>
        /// Euro Index indicator by Quantum
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.QuantumEURX QuantumEURX(int mAPeriod1, int mAPeriod2, QuantumEURXMAPriceType mAPriceType)
        {
            return _indicator.QuantumEURX(Input, mAPeriod1, mAPeriod2, mAPriceType);
        }

        /// <summary>
        /// Euro Index indicator by Quantum
        /// </summary>
        /// <returns></returns>
        public Indicator.QuantumEURX QuantumEURX(Data.IDataSeries input, int mAPeriod1, int mAPeriod2, QuantumEURXMAPriceType mAPriceType)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.QuantumEURX(input, mAPeriod1, mAPeriod2, mAPriceType);
        }

        /// <summary>
        /// Japanese Yen Index indicator by Quantum
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.QuantumJPYX QuantumJPYX(int mAPeriod1, int mAPeriod2, QuantumJPYXMAPriceType mAPriceType)
        {
            return _indicator.QuantumJPYX(Input, mAPeriod1, mAPeriod2, mAPriceType);
        }

        /// <summary>
        /// Japanese Yen Index indicator by Quantum
        /// </summary>
        /// <returns></returns>
        public Indicator.QuantumJPYX QuantumJPYX(Data.IDataSeries input, int mAPeriod1, int mAPeriod2, QuantumJPYXMAPriceType mAPriceType)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.QuantumJPYX(input, mAPeriod1, mAPeriod2, mAPriceType);
        }

        /// <summary>
        /// Tick speed meter by Quantum
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.QuantumTickSpeedometer QuantumTickSpeedometer(int period)
        {
            return _indicator.QuantumTickSpeedometer(Input, period);
        }

        /// <summary>
        /// Tick speed meter by Quantum
        /// </summary>
        /// <returns></returns>
        public Indicator.QuantumTickSpeedometer QuantumTickSpeedometer(Data.IDataSeries input, int period)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.QuantumTickSpeedometer(input, period);
        }

        /// <summary>
        /// Trend momentum indicator by Quantum
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.QuantumTrendMonitor QuantumTrendMonitor(QuantumTrendMonitorMode mode, double neutralConstant)
        {
            return _indicator.QuantumTrendMonitor(Input, mode, neutralConstant);
        }

        /// <summary>
        /// Trend momentum indicator by Quantum
        /// </summary>
        /// <returns></returns>
        public Indicator.QuantumTrendMonitor QuantumTrendMonitor(Data.IDataSeries input, QuantumTrendMonitorMode mode, double neutralConstant)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.QuantumTrendMonitor(input, mode, neutralConstant);
        }

        /// <summary>
        /// Trend dots indicator by Quantum
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.QuantumTrends QuantumTrends(double neutralConstant)
        {
            return _indicator.QuantumTrends(Input, neutralConstant);
        }

        /// <summary>
        /// Trend dots indicator by Quantum
        /// </summary>
        /// <returns></returns>
        public Indicator.QuantumTrends QuantumTrends(Data.IDataSeries input, double neutralConstant)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.QuantumTrends(input, neutralConstant);
        }

        /// <summary>
        /// US Dollar Index indicator by Quantum
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.QuantumUSDX QuantumUSDX(int mAPeriod1, int mAPeriod2, QuantumUSDXMAPriceType mAPriceType)
        {
            return _indicator.QuantumUSDX(Input, mAPeriod1, mAPeriod2, mAPriceType);
        }

        /// <summary>
        /// US Dollar Index indicator by Quantum
        /// </summary>
        /// <returns></returns>
        public Indicator.QuantumUSDX QuantumUSDX(Data.IDataSeries input, int mAPeriod1, int mAPeriod2, QuantumUSDXMAPriceType mAPriceType)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.QuantumUSDX(input, mAPeriod1, mAPeriod2, mAPriceType);
        }

        /// <summary>
        /// Volume Point of Control by Quantum Trading
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.QuantumVPOC QuantumVPOC(int lookBackPeriod, int regionCount, bool showSupportResistance, bool showVolumePointOfControl, bool showVolumeProfile, Color sRColor1, Color sRColor2, Color volumeProfileColor1, Color volumeProfileColor2, Color vPOCColor, QuantumVPOCSRLineCount vPOCSRLineCount)
        {
            return _indicator.QuantumVPOC(Input, lookBackPeriod, regionCount, showSupportResistance, showVolumePointOfControl, showVolumeProfile, sRColor1, sRColor2, volumeProfileColor1, volumeProfileColor2, vPOCColor, vPOCSRLineCount);
        }

        /// <summary>
        /// Volume Point of Control by Quantum Trading
        /// </summary>
        /// <returns></returns>
        public Indicator.QuantumVPOC QuantumVPOC(Data.IDataSeries input, int lookBackPeriod, int regionCount, bool showSupportResistance, bool showVolumePointOfControl, bool showVolumeProfile, Color sRColor1, Color sRColor2, Color volumeProfileColor1, Color volumeProfileColor2, Color vPOCColor, QuantumVPOCSRLineCount vPOCSRLineCount)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.QuantumVPOC(input, lookBackPeriod, regionCount, showSupportResistance, showVolumePointOfControl, showVolumeProfile, sRColor1, sRColor2, volumeProfileColor1, volumeProfileColor2, vPOCColor, vPOCSRLineCount);
        }
    }
}
#endregion
