//
// Copyright (C) 2006, NinjaTrader LLC <ninjatrader@ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private CDA_BlackgoldImpulse[] cacheCDA_BlackgoldImpulse = null;

        private static CDA_BlackgoldImpulse checkCDA_BlackgoldImpulse = new CDA_BlackgoldImpulse();

        /// <summary>
        /// Crude Oil 9 Range Impulse Trade Signal
        /// </summary>
        /// <returns></returns>
        public CDA_BlackgoldImpulse CDA_BlackgoldImpulse(bool alertEnabled, int arrowOffset, bool debug, string debugFileDir, string debugFileNamePrefix, int debugLevel, Color defaultBarColor, bool drawLines, string emailAddress, bool enableEntrySignal, bool enableFasterDetection, bool enableMacdFilter, bool enableRunLog, Color fallingBarColor, string impulseAlertSoundFile, Color impulseDownStartedColor, string impulseSpeechMessage, DashStyle impulseStartLineDashStyle, int impulseStartLineWidth, Color impulseUpStartedColor, CDA_BlackgoldImpulse_Licensor licensor, bool paintPriceBars, Color risingBarColor, string runLogFileDir, string runLogFilename, string signalAlertSoundFile, int signalMargin, bool speechEnabled, string version)
        {
            return CDA_BlackgoldImpulse(Input, alertEnabled, arrowOffset, debug, debugFileDir, debugFileNamePrefix, debugLevel, defaultBarColor, drawLines, emailAddress, enableEntrySignal, enableFasterDetection, enableMacdFilter, enableRunLog, fallingBarColor, impulseAlertSoundFile, impulseDownStartedColor, impulseSpeechMessage, impulseStartLineDashStyle, impulseStartLineWidth, impulseUpStartedColor, licensor, paintPriceBars, risingBarColor, runLogFileDir, runLogFilename, signalAlertSoundFile, signalMargin, speechEnabled, version);
        }

        /// <summary>
        /// Crude Oil 9 Range Impulse Trade Signal
        /// </summary>
        /// <returns></returns>
        public CDA_BlackgoldImpulse CDA_BlackgoldImpulse(Data.IDataSeries input, bool alertEnabled, int arrowOffset, bool debug, string debugFileDir, string debugFileNamePrefix, int debugLevel, Color defaultBarColor, bool drawLines, string emailAddress, bool enableEntrySignal, bool enableFasterDetection, bool enableMacdFilter, bool enableRunLog, Color fallingBarColor, string impulseAlertSoundFile, Color impulseDownStartedColor, string impulseSpeechMessage, DashStyle impulseStartLineDashStyle, int impulseStartLineWidth, Color impulseUpStartedColor, CDA_BlackgoldImpulse_Licensor licensor, bool paintPriceBars, Color risingBarColor, string runLogFileDir, string runLogFilename, string signalAlertSoundFile, int signalMargin, bool speechEnabled, string version)
        {
            if (cacheCDA_BlackgoldImpulse != null)
                for (int idx = 0; idx < cacheCDA_BlackgoldImpulse.Length; idx++)
                    if (cacheCDA_BlackgoldImpulse[idx].AlertEnabled == alertEnabled && cacheCDA_BlackgoldImpulse[idx].ArrowOffset == arrowOffset && cacheCDA_BlackgoldImpulse[idx].Debug == debug && cacheCDA_BlackgoldImpulse[idx].DebugFileDir == debugFileDir && cacheCDA_BlackgoldImpulse[idx].DebugFileNamePrefix == debugFileNamePrefix && cacheCDA_BlackgoldImpulse[idx].DebugLevel == debugLevel && cacheCDA_BlackgoldImpulse[idx].DefaultBarColor == defaultBarColor && cacheCDA_BlackgoldImpulse[idx].DrawLines == drawLines && cacheCDA_BlackgoldImpulse[idx].EmailAddress == emailAddress && cacheCDA_BlackgoldImpulse[idx].EnableEntrySignal == enableEntrySignal && cacheCDA_BlackgoldImpulse[idx].EnableFasterDetection == enableFasterDetection && cacheCDA_BlackgoldImpulse[idx].EnableMacdFilter == enableMacdFilter && cacheCDA_BlackgoldImpulse[idx].EnableRunLog == enableRunLog && cacheCDA_BlackgoldImpulse[idx].FallingBarColor == fallingBarColor && cacheCDA_BlackgoldImpulse[idx].ImpulseAlertSoundFile == impulseAlertSoundFile && cacheCDA_BlackgoldImpulse[idx].ImpulseDownStartedColor == impulseDownStartedColor && cacheCDA_BlackgoldImpulse[idx].ImpulseSpeechMessage == impulseSpeechMessage && cacheCDA_BlackgoldImpulse[idx].ImpulseStartLineDashStyle == impulseStartLineDashStyle && cacheCDA_BlackgoldImpulse[idx].ImpulseStartLineWidth == impulseStartLineWidth && cacheCDA_BlackgoldImpulse[idx].ImpulseUpStartedColor == impulseUpStartedColor && cacheCDA_BlackgoldImpulse[idx].Licensor == licensor && cacheCDA_BlackgoldImpulse[idx].PaintPriceBars == paintPriceBars && cacheCDA_BlackgoldImpulse[idx].RisingBarColor == risingBarColor && cacheCDA_BlackgoldImpulse[idx].RunLogFileDir == runLogFileDir && cacheCDA_BlackgoldImpulse[idx].RunLogFilename == runLogFilename && cacheCDA_BlackgoldImpulse[idx].SignalAlertSoundFile == signalAlertSoundFile && cacheCDA_BlackgoldImpulse[idx].SignalMargin == signalMargin && cacheCDA_BlackgoldImpulse[idx].SpeechEnabled == speechEnabled && cacheCDA_BlackgoldImpulse[idx].Version == version && cacheCDA_BlackgoldImpulse[idx].EqualsInput(input))
                        return cacheCDA_BlackgoldImpulse[idx];

            lock (checkCDA_BlackgoldImpulse)
            {
                checkCDA_BlackgoldImpulse.AlertEnabled = alertEnabled;
                alertEnabled = checkCDA_BlackgoldImpulse.AlertEnabled;
                checkCDA_BlackgoldImpulse.ArrowOffset = arrowOffset;
                arrowOffset = checkCDA_BlackgoldImpulse.ArrowOffset;
                checkCDA_BlackgoldImpulse.Debug = debug;
                debug = checkCDA_BlackgoldImpulse.Debug;
                checkCDA_BlackgoldImpulse.DebugFileDir = debugFileDir;
                debugFileDir = checkCDA_BlackgoldImpulse.DebugFileDir;
                checkCDA_BlackgoldImpulse.DebugFileNamePrefix = debugFileNamePrefix;
                debugFileNamePrefix = checkCDA_BlackgoldImpulse.DebugFileNamePrefix;
                checkCDA_BlackgoldImpulse.DebugLevel = debugLevel;
                debugLevel = checkCDA_BlackgoldImpulse.DebugLevel;
                checkCDA_BlackgoldImpulse.DefaultBarColor = defaultBarColor;
                defaultBarColor = checkCDA_BlackgoldImpulse.DefaultBarColor;
                checkCDA_BlackgoldImpulse.DrawLines = drawLines;
                drawLines = checkCDA_BlackgoldImpulse.DrawLines;
                checkCDA_BlackgoldImpulse.EmailAddress = emailAddress;
                emailAddress = checkCDA_BlackgoldImpulse.EmailAddress;
                checkCDA_BlackgoldImpulse.EnableEntrySignal = enableEntrySignal;
                enableEntrySignal = checkCDA_BlackgoldImpulse.EnableEntrySignal;
                checkCDA_BlackgoldImpulse.EnableFasterDetection = enableFasterDetection;
                enableFasterDetection = checkCDA_BlackgoldImpulse.EnableFasterDetection;
                checkCDA_BlackgoldImpulse.EnableMacdFilter = enableMacdFilter;
                enableMacdFilter = checkCDA_BlackgoldImpulse.EnableMacdFilter;
                checkCDA_BlackgoldImpulse.EnableRunLog = enableRunLog;
                enableRunLog = checkCDA_BlackgoldImpulse.EnableRunLog;
                checkCDA_BlackgoldImpulse.FallingBarColor = fallingBarColor;
                fallingBarColor = checkCDA_BlackgoldImpulse.FallingBarColor;
                checkCDA_BlackgoldImpulse.ImpulseAlertSoundFile = impulseAlertSoundFile;
                impulseAlertSoundFile = checkCDA_BlackgoldImpulse.ImpulseAlertSoundFile;
                checkCDA_BlackgoldImpulse.ImpulseDownStartedColor = impulseDownStartedColor;
                impulseDownStartedColor = checkCDA_BlackgoldImpulse.ImpulseDownStartedColor;
                checkCDA_BlackgoldImpulse.ImpulseSpeechMessage = impulseSpeechMessage;
                impulseSpeechMessage = checkCDA_BlackgoldImpulse.ImpulseSpeechMessage;
                checkCDA_BlackgoldImpulse.ImpulseStartLineDashStyle = impulseStartLineDashStyle;
                impulseStartLineDashStyle = checkCDA_BlackgoldImpulse.ImpulseStartLineDashStyle;
                checkCDA_BlackgoldImpulse.ImpulseStartLineWidth = impulseStartLineWidth;
                impulseStartLineWidth = checkCDA_BlackgoldImpulse.ImpulseStartLineWidth;
                checkCDA_BlackgoldImpulse.ImpulseUpStartedColor = impulseUpStartedColor;
                impulseUpStartedColor = checkCDA_BlackgoldImpulse.ImpulseUpStartedColor;
                checkCDA_BlackgoldImpulse.Licensor = licensor;
                licensor = checkCDA_BlackgoldImpulse.Licensor;
                checkCDA_BlackgoldImpulse.PaintPriceBars = paintPriceBars;
                paintPriceBars = checkCDA_BlackgoldImpulse.PaintPriceBars;
                checkCDA_BlackgoldImpulse.RisingBarColor = risingBarColor;
                risingBarColor = checkCDA_BlackgoldImpulse.RisingBarColor;
                checkCDA_BlackgoldImpulse.RunLogFileDir = runLogFileDir;
                runLogFileDir = checkCDA_BlackgoldImpulse.RunLogFileDir;
                checkCDA_BlackgoldImpulse.RunLogFilename = runLogFilename;
                runLogFilename = checkCDA_BlackgoldImpulse.RunLogFilename;
                checkCDA_BlackgoldImpulse.SignalAlertSoundFile = signalAlertSoundFile;
                signalAlertSoundFile = checkCDA_BlackgoldImpulse.SignalAlertSoundFile;
                checkCDA_BlackgoldImpulse.SignalMargin = signalMargin;
                signalMargin = checkCDA_BlackgoldImpulse.SignalMargin;
                checkCDA_BlackgoldImpulse.SpeechEnabled = speechEnabled;
                speechEnabled = checkCDA_BlackgoldImpulse.SpeechEnabled;
                checkCDA_BlackgoldImpulse.Version = version;
                version = checkCDA_BlackgoldImpulse.Version;

                if (cacheCDA_BlackgoldImpulse != null)
                    for (int idx = 0; idx < cacheCDA_BlackgoldImpulse.Length; idx++)
                        if (cacheCDA_BlackgoldImpulse[idx].AlertEnabled == alertEnabled && cacheCDA_BlackgoldImpulse[idx].ArrowOffset == arrowOffset && cacheCDA_BlackgoldImpulse[idx].Debug == debug && cacheCDA_BlackgoldImpulse[idx].DebugFileDir == debugFileDir && cacheCDA_BlackgoldImpulse[idx].DebugFileNamePrefix == debugFileNamePrefix && cacheCDA_BlackgoldImpulse[idx].DebugLevel == debugLevel && cacheCDA_BlackgoldImpulse[idx].DefaultBarColor == defaultBarColor && cacheCDA_BlackgoldImpulse[idx].DrawLines == drawLines && cacheCDA_BlackgoldImpulse[idx].EmailAddress == emailAddress && cacheCDA_BlackgoldImpulse[idx].EnableEntrySignal == enableEntrySignal && cacheCDA_BlackgoldImpulse[idx].EnableFasterDetection == enableFasterDetection && cacheCDA_BlackgoldImpulse[idx].EnableMacdFilter == enableMacdFilter && cacheCDA_BlackgoldImpulse[idx].EnableRunLog == enableRunLog && cacheCDA_BlackgoldImpulse[idx].FallingBarColor == fallingBarColor && cacheCDA_BlackgoldImpulse[idx].ImpulseAlertSoundFile == impulseAlertSoundFile && cacheCDA_BlackgoldImpulse[idx].ImpulseDownStartedColor == impulseDownStartedColor && cacheCDA_BlackgoldImpulse[idx].ImpulseSpeechMessage == impulseSpeechMessage && cacheCDA_BlackgoldImpulse[idx].ImpulseStartLineDashStyle == impulseStartLineDashStyle && cacheCDA_BlackgoldImpulse[idx].ImpulseStartLineWidth == impulseStartLineWidth && cacheCDA_BlackgoldImpulse[idx].ImpulseUpStartedColor == impulseUpStartedColor && cacheCDA_BlackgoldImpulse[idx].Licensor == licensor && cacheCDA_BlackgoldImpulse[idx].PaintPriceBars == paintPriceBars && cacheCDA_BlackgoldImpulse[idx].RisingBarColor == risingBarColor && cacheCDA_BlackgoldImpulse[idx].RunLogFileDir == runLogFileDir && cacheCDA_BlackgoldImpulse[idx].RunLogFilename == runLogFilename && cacheCDA_BlackgoldImpulse[idx].SignalAlertSoundFile == signalAlertSoundFile && cacheCDA_BlackgoldImpulse[idx].SignalMargin == signalMargin && cacheCDA_BlackgoldImpulse[idx].SpeechEnabled == speechEnabled && cacheCDA_BlackgoldImpulse[idx].Version == version && cacheCDA_BlackgoldImpulse[idx].EqualsInput(input))
                            return cacheCDA_BlackgoldImpulse[idx];

                CDA_BlackgoldImpulse indicator = new CDA_BlackgoldImpulse();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.AlertEnabled = alertEnabled;
                indicator.ArrowOffset = arrowOffset;
                indicator.Debug = debug;
                indicator.DebugFileDir = debugFileDir;
                indicator.DebugFileNamePrefix = debugFileNamePrefix;
                indicator.DebugLevel = debugLevel;
                indicator.DefaultBarColor = defaultBarColor;
                indicator.DrawLines = drawLines;
                indicator.EmailAddress = emailAddress;
                indicator.EnableEntrySignal = enableEntrySignal;
                indicator.EnableFasterDetection = enableFasterDetection;
                indicator.EnableMacdFilter = enableMacdFilter;
                indicator.EnableRunLog = enableRunLog;
                indicator.FallingBarColor = fallingBarColor;
                indicator.ImpulseAlertSoundFile = impulseAlertSoundFile;
                indicator.ImpulseDownStartedColor = impulseDownStartedColor;
                indicator.ImpulseSpeechMessage = impulseSpeechMessage;
                indicator.ImpulseStartLineDashStyle = impulseStartLineDashStyle;
                indicator.ImpulseStartLineWidth = impulseStartLineWidth;
                indicator.ImpulseUpStartedColor = impulseUpStartedColor;
                indicator.Licensor = licensor;
                indicator.PaintPriceBars = paintPriceBars;
                indicator.RisingBarColor = risingBarColor;
                indicator.RunLogFileDir = runLogFileDir;
                indicator.RunLogFilename = runLogFilename;
                indicator.SignalAlertSoundFile = signalAlertSoundFile;
                indicator.SignalMargin = signalMargin;
                indicator.SpeechEnabled = speechEnabled;
                indicator.Version = version;
                Indicators.Add(indicator);
                indicator.SetUp();

                CDA_BlackgoldImpulse[] tmp = new CDA_BlackgoldImpulse[cacheCDA_BlackgoldImpulse == null ? 1 : cacheCDA_BlackgoldImpulse.Length + 1];
                if (cacheCDA_BlackgoldImpulse != null)
                    cacheCDA_BlackgoldImpulse.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheCDA_BlackgoldImpulse = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Crude Oil 9 Range Impulse Trade Signal
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.CDA_BlackgoldImpulse CDA_BlackgoldImpulse(bool alertEnabled, int arrowOffset, bool debug, string debugFileDir, string debugFileNamePrefix, int debugLevel, Color defaultBarColor, bool drawLines, string emailAddress, bool enableEntrySignal, bool enableFasterDetection, bool enableMacdFilter, bool enableRunLog, Color fallingBarColor, string impulseAlertSoundFile, Color impulseDownStartedColor, string impulseSpeechMessage, DashStyle impulseStartLineDashStyle, int impulseStartLineWidth, Color impulseUpStartedColor, CDA_BlackgoldImpulse_Licensor licensor, bool paintPriceBars, Color risingBarColor, string runLogFileDir, string runLogFilename, string signalAlertSoundFile, int signalMargin, bool speechEnabled, string version)
        {
            return _indicator.CDA_BlackgoldImpulse(Input, alertEnabled, arrowOffset, debug, debugFileDir, debugFileNamePrefix, debugLevel, defaultBarColor, drawLines, emailAddress, enableEntrySignal, enableFasterDetection, enableMacdFilter, enableRunLog, fallingBarColor, impulseAlertSoundFile, impulseDownStartedColor, impulseSpeechMessage, impulseStartLineDashStyle, impulseStartLineWidth, impulseUpStartedColor, licensor, paintPriceBars, risingBarColor, runLogFileDir, runLogFilename, signalAlertSoundFile, signalMargin, speechEnabled, version);
        }

        /// <summary>
        /// Crude Oil 9 Range Impulse Trade Signal
        /// </summary>
        /// <returns></returns>
        public Indicator.CDA_BlackgoldImpulse CDA_BlackgoldImpulse(Data.IDataSeries input, bool alertEnabled, int arrowOffset, bool debug, string debugFileDir, string debugFileNamePrefix, int debugLevel, Color defaultBarColor, bool drawLines, string emailAddress, bool enableEntrySignal, bool enableFasterDetection, bool enableMacdFilter, bool enableRunLog, Color fallingBarColor, string impulseAlertSoundFile, Color impulseDownStartedColor, string impulseSpeechMessage, DashStyle impulseStartLineDashStyle, int impulseStartLineWidth, Color impulseUpStartedColor, CDA_BlackgoldImpulse_Licensor licensor, bool paintPriceBars, Color risingBarColor, string runLogFileDir, string runLogFilename, string signalAlertSoundFile, int signalMargin, bool speechEnabled, string version)
        {
            return _indicator.CDA_BlackgoldImpulse(input, alertEnabled, arrowOffset, debug, debugFileDir, debugFileNamePrefix, debugLevel, defaultBarColor, drawLines, emailAddress, enableEntrySignal, enableFasterDetection, enableMacdFilter, enableRunLog, fallingBarColor, impulseAlertSoundFile, impulseDownStartedColor, impulseSpeechMessage, impulseStartLineDashStyle, impulseStartLineWidth, impulseUpStartedColor, licensor, paintPriceBars, risingBarColor, runLogFileDir, runLogFilename, signalAlertSoundFile, signalMargin, speechEnabled, version);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Crude Oil 9 Range Impulse Trade Signal
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.CDA_BlackgoldImpulse CDA_BlackgoldImpulse(bool alertEnabled, int arrowOffset, bool debug, string debugFileDir, string debugFileNamePrefix, int debugLevel, Color defaultBarColor, bool drawLines, string emailAddress, bool enableEntrySignal, bool enableFasterDetection, bool enableMacdFilter, bool enableRunLog, Color fallingBarColor, string impulseAlertSoundFile, Color impulseDownStartedColor, string impulseSpeechMessage, DashStyle impulseStartLineDashStyle, int impulseStartLineWidth, Color impulseUpStartedColor, CDA_BlackgoldImpulse_Licensor licensor, bool paintPriceBars, Color risingBarColor, string runLogFileDir, string runLogFilename, string signalAlertSoundFile, int signalMargin, bool speechEnabled, string version)
        {
            return _indicator.CDA_BlackgoldImpulse(Input, alertEnabled, arrowOffset, debug, debugFileDir, debugFileNamePrefix, debugLevel, defaultBarColor, drawLines, emailAddress, enableEntrySignal, enableFasterDetection, enableMacdFilter, enableRunLog, fallingBarColor, impulseAlertSoundFile, impulseDownStartedColor, impulseSpeechMessage, impulseStartLineDashStyle, impulseStartLineWidth, impulseUpStartedColor, licensor, paintPriceBars, risingBarColor, runLogFileDir, runLogFilename, signalAlertSoundFile, signalMargin, speechEnabled, version);
        }

        /// <summary>
        /// Crude Oil 9 Range Impulse Trade Signal
        /// </summary>
        /// <returns></returns>
        public Indicator.CDA_BlackgoldImpulse CDA_BlackgoldImpulse(Data.IDataSeries input, bool alertEnabled, int arrowOffset, bool debug, string debugFileDir, string debugFileNamePrefix, int debugLevel, Color defaultBarColor, bool drawLines, string emailAddress, bool enableEntrySignal, bool enableFasterDetection, bool enableMacdFilter, bool enableRunLog, Color fallingBarColor, string impulseAlertSoundFile, Color impulseDownStartedColor, string impulseSpeechMessage, DashStyle impulseStartLineDashStyle, int impulseStartLineWidth, Color impulseUpStartedColor, CDA_BlackgoldImpulse_Licensor licensor, bool paintPriceBars, Color risingBarColor, string runLogFileDir, string runLogFilename, string signalAlertSoundFile, int signalMargin, bool speechEnabled, string version)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.CDA_BlackgoldImpulse(input, alertEnabled, arrowOffset, debug, debugFileDir, debugFileNamePrefix, debugLevel, defaultBarColor, drawLines, emailAddress, enableEntrySignal, enableFasterDetection, enableMacdFilter, enableRunLog, fallingBarColor, impulseAlertSoundFile, impulseDownStartedColor, impulseSpeechMessage, impulseStartLineDashStyle, impulseStartLineWidth, impulseUpStartedColor, licensor, paintPriceBars, risingBarColor, runLogFileDir, runLogFilename, signalAlertSoundFile, signalMargin, speechEnabled, version);
        }
    }
}
#endregion
