//
// Copyright (C) 2006, NinjaTrader LLC <ninjatrader@ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private CDA_FuzzyPivots[] cacheCDA_FuzzyPivots = null;

        private static CDA_FuzzyPivots checkCDA_FuzzyPivots = new CDA_FuzzyPivots();

        /// <summary>
        /// Displays dynamically ranked overlapping DPTL zones based on sets of intersecting pivots. A fuzzy zone indicates an area of frequent consolidation and brightness of the zone suggesting relative strength.   A darker zone suggests SR levels of higher degree with less frequent overlaps but more major LSP and BOB levels.
        /// </summary>
        /// <returns></returns>
        public CDA_FuzzyPivots CDA_FuzzyPivots(bool debug, string debugFileDir, string debugFileNamePrefix, int debugLevel, int dPTLVolumeRegulator, string emailAddress, bool enableRunLog, Color highColor, CDA_FuzzyPivots_Licensor licensor, Color lowColor, int pivotIntersectMargin, int pivotStrength, Color resistanceZoneColor, string runLogFileDir, string runLogFilename, bool showPivotIDs, bool showPivots, Color supportZoneColor, string version)
        {
            return CDA_FuzzyPivots(Input, debug, debugFileDir, debugFileNamePrefix, debugLevel, dPTLVolumeRegulator, emailAddress, enableRunLog, highColor, licensor, lowColor, pivotIntersectMargin, pivotStrength, resistanceZoneColor, runLogFileDir, runLogFilename, showPivotIDs, showPivots, supportZoneColor, version);
        }

        /// <summary>
        /// Displays dynamically ranked overlapping DPTL zones based on sets of intersecting pivots. A fuzzy zone indicates an area of frequent consolidation and brightness of the zone suggesting relative strength.   A darker zone suggests SR levels of higher degree with less frequent overlaps but more major LSP and BOB levels.
        /// </summary>
        /// <returns></returns>
        public CDA_FuzzyPivots CDA_FuzzyPivots(Data.IDataSeries input, bool debug, string debugFileDir, string debugFileNamePrefix, int debugLevel, int dPTLVolumeRegulator, string emailAddress, bool enableRunLog, Color highColor, CDA_FuzzyPivots_Licensor licensor, Color lowColor, int pivotIntersectMargin, int pivotStrength, Color resistanceZoneColor, string runLogFileDir, string runLogFilename, bool showPivotIDs, bool showPivots, Color supportZoneColor, string version)
        {
            if (cacheCDA_FuzzyPivots != null)
                for (int idx = 0; idx < cacheCDA_FuzzyPivots.Length; idx++)
                    if (cacheCDA_FuzzyPivots[idx].Debug == debug && cacheCDA_FuzzyPivots[idx].DebugFileDir == debugFileDir && cacheCDA_FuzzyPivots[idx].DebugFileNamePrefix == debugFileNamePrefix && cacheCDA_FuzzyPivots[idx].DebugLevel == debugLevel && cacheCDA_FuzzyPivots[idx].DPTLVolumeRegulator == dPTLVolumeRegulator && cacheCDA_FuzzyPivots[idx].EmailAddress == emailAddress && cacheCDA_FuzzyPivots[idx].EnableRunLog == enableRunLog && cacheCDA_FuzzyPivots[idx].HighColor == highColor && cacheCDA_FuzzyPivots[idx].Licensor == licensor && cacheCDA_FuzzyPivots[idx].LowColor == lowColor && cacheCDA_FuzzyPivots[idx].PivotIntersectMargin == pivotIntersectMargin && cacheCDA_FuzzyPivots[idx].PivotStrength == pivotStrength && cacheCDA_FuzzyPivots[idx].ResistanceZoneColor == resistanceZoneColor && cacheCDA_FuzzyPivots[idx].RunLogFileDir == runLogFileDir && cacheCDA_FuzzyPivots[idx].RunLogFilename == runLogFilename && cacheCDA_FuzzyPivots[idx].ShowPivotIDs == showPivotIDs && cacheCDA_FuzzyPivots[idx].ShowPivots == showPivots && cacheCDA_FuzzyPivots[idx].SupportZoneColor == supportZoneColor && cacheCDA_FuzzyPivots[idx].Version == version && cacheCDA_FuzzyPivots[idx].EqualsInput(input))
                        return cacheCDA_FuzzyPivots[idx];

            lock (checkCDA_FuzzyPivots)
            {
                checkCDA_FuzzyPivots.Debug = debug;
                debug = checkCDA_FuzzyPivots.Debug;
                checkCDA_FuzzyPivots.DebugFileDir = debugFileDir;
                debugFileDir = checkCDA_FuzzyPivots.DebugFileDir;
                checkCDA_FuzzyPivots.DebugFileNamePrefix = debugFileNamePrefix;
                debugFileNamePrefix = checkCDA_FuzzyPivots.DebugFileNamePrefix;
                checkCDA_FuzzyPivots.DebugLevel = debugLevel;
                debugLevel = checkCDA_FuzzyPivots.DebugLevel;
                checkCDA_FuzzyPivots.DPTLVolumeRegulator = dPTLVolumeRegulator;
                dPTLVolumeRegulator = checkCDA_FuzzyPivots.DPTLVolumeRegulator;
                checkCDA_FuzzyPivots.EmailAddress = emailAddress;
                emailAddress = checkCDA_FuzzyPivots.EmailAddress;
                checkCDA_FuzzyPivots.EnableRunLog = enableRunLog;
                enableRunLog = checkCDA_FuzzyPivots.EnableRunLog;
                checkCDA_FuzzyPivots.HighColor = highColor;
                highColor = checkCDA_FuzzyPivots.HighColor;
                checkCDA_FuzzyPivots.Licensor = licensor;
                licensor = checkCDA_FuzzyPivots.Licensor;
                checkCDA_FuzzyPivots.LowColor = lowColor;
                lowColor = checkCDA_FuzzyPivots.LowColor;
                checkCDA_FuzzyPivots.PivotIntersectMargin = pivotIntersectMargin;
                pivotIntersectMargin = checkCDA_FuzzyPivots.PivotIntersectMargin;
                checkCDA_FuzzyPivots.PivotStrength = pivotStrength;
                pivotStrength = checkCDA_FuzzyPivots.PivotStrength;
                checkCDA_FuzzyPivots.ResistanceZoneColor = resistanceZoneColor;
                resistanceZoneColor = checkCDA_FuzzyPivots.ResistanceZoneColor;
                checkCDA_FuzzyPivots.RunLogFileDir = runLogFileDir;
                runLogFileDir = checkCDA_FuzzyPivots.RunLogFileDir;
                checkCDA_FuzzyPivots.RunLogFilename = runLogFilename;
                runLogFilename = checkCDA_FuzzyPivots.RunLogFilename;
                checkCDA_FuzzyPivots.ShowPivotIDs = showPivotIDs;
                showPivotIDs = checkCDA_FuzzyPivots.ShowPivotIDs;
                checkCDA_FuzzyPivots.ShowPivots = showPivots;
                showPivots = checkCDA_FuzzyPivots.ShowPivots;
                checkCDA_FuzzyPivots.SupportZoneColor = supportZoneColor;
                supportZoneColor = checkCDA_FuzzyPivots.SupportZoneColor;
                checkCDA_FuzzyPivots.Version = version;
                version = checkCDA_FuzzyPivots.Version;

                if (cacheCDA_FuzzyPivots != null)
                    for (int idx = 0; idx < cacheCDA_FuzzyPivots.Length; idx++)
                        if (cacheCDA_FuzzyPivots[idx].Debug == debug && cacheCDA_FuzzyPivots[idx].DebugFileDir == debugFileDir && cacheCDA_FuzzyPivots[idx].DebugFileNamePrefix == debugFileNamePrefix && cacheCDA_FuzzyPivots[idx].DebugLevel == debugLevel && cacheCDA_FuzzyPivots[idx].DPTLVolumeRegulator == dPTLVolumeRegulator && cacheCDA_FuzzyPivots[idx].EmailAddress == emailAddress && cacheCDA_FuzzyPivots[idx].EnableRunLog == enableRunLog && cacheCDA_FuzzyPivots[idx].HighColor == highColor && cacheCDA_FuzzyPivots[idx].Licensor == licensor && cacheCDA_FuzzyPivots[idx].LowColor == lowColor && cacheCDA_FuzzyPivots[idx].PivotIntersectMargin == pivotIntersectMargin && cacheCDA_FuzzyPivots[idx].PivotStrength == pivotStrength && cacheCDA_FuzzyPivots[idx].ResistanceZoneColor == resistanceZoneColor && cacheCDA_FuzzyPivots[idx].RunLogFileDir == runLogFileDir && cacheCDA_FuzzyPivots[idx].RunLogFilename == runLogFilename && cacheCDA_FuzzyPivots[idx].ShowPivotIDs == showPivotIDs && cacheCDA_FuzzyPivots[idx].ShowPivots == showPivots && cacheCDA_FuzzyPivots[idx].SupportZoneColor == supportZoneColor && cacheCDA_FuzzyPivots[idx].Version == version && cacheCDA_FuzzyPivots[idx].EqualsInput(input))
                            return cacheCDA_FuzzyPivots[idx];

                CDA_FuzzyPivots indicator = new CDA_FuzzyPivots();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Debug = debug;
                indicator.DebugFileDir = debugFileDir;
                indicator.DebugFileNamePrefix = debugFileNamePrefix;
                indicator.DebugLevel = debugLevel;
                indicator.DPTLVolumeRegulator = dPTLVolumeRegulator;
                indicator.EmailAddress = emailAddress;
                indicator.EnableRunLog = enableRunLog;
                indicator.HighColor = highColor;
                indicator.Licensor = licensor;
                indicator.LowColor = lowColor;
                indicator.PivotIntersectMargin = pivotIntersectMargin;
                indicator.PivotStrength = pivotStrength;
                indicator.ResistanceZoneColor = resistanceZoneColor;
                indicator.RunLogFileDir = runLogFileDir;
                indicator.RunLogFilename = runLogFilename;
                indicator.ShowPivotIDs = showPivotIDs;
                indicator.ShowPivots = showPivots;
                indicator.SupportZoneColor = supportZoneColor;
                indicator.Version = version;
                Indicators.Add(indicator);
                indicator.SetUp();

                CDA_FuzzyPivots[] tmp = new CDA_FuzzyPivots[cacheCDA_FuzzyPivots == null ? 1 : cacheCDA_FuzzyPivots.Length + 1];
                if (cacheCDA_FuzzyPivots != null)
                    cacheCDA_FuzzyPivots.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheCDA_FuzzyPivots = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Displays dynamically ranked overlapping DPTL zones based on sets of intersecting pivots. A fuzzy zone indicates an area of frequent consolidation and brightness of the zone suggesting relative strength.   A darker zone suggests SR levels of higher degree with less frequent overlaps but more major LSP and BOB levels.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.CDA_FuzzyPivots CDA_FuzzyPivots(bool debug, string debugFileDir, string debugFileNamePrefix, int debugLevel, int dPTLVolumeRegulator, string emailAddress, bool enableRunLog, Color highColor, CDA_FuzzyPivots_Licensor licensor, Color lowColor, int pivotIntersectMargin, int pivotStrength, Color resistanceZoneColor, string runLogFileDir, string runLogFilename, bool showPivotIDs, bool showPivots, Color supportZoneColor, string version)
        {
            return _indicator.CDA_FuzzyPivots(Input, debug, debugFileDir, debugFileNamePrefix, debugLevel, dPTLVolumeRegulator, emailAddress, enableRunLog, highColor, licensor, lowColor, pivotIntersectMargin, pivotStrength, resistanceZoneColor, runLogFileDir, runLogFilename, showPivotIDs, showPivots, supportZoneColor, version);
        }

        /// <summary>
        /// Displays dynamically ranked overlapping DPTL zones based on sets of intersecting pivots. A fuzzy zone indicates an area of frequent consolidation and brightness of the zone suggesting relative strength.   A darker zone suggests SR levels of higher degree with less frequent overlaps but more major LSP and BOB levels.
        /// </summary>
        /// <returns></returns>
        public Indicator.CDA_FuzzyPivots CDA_FuzzyPivots(Data.IDataSeries input, bool debug, string debugFileDir, string debugFileNamePrefix, int debugLevel, int dPTLVolumeRegulator, string emailAddress, bool enableRunLog, Color highColor, CDA_FuzzyPivots_Licensor licensor, Color lowColor, int pivotIntersectMargin, int pivotStrength, Color resistanceZoneColor, string runLogFileDir, string runLogFilename, bool showPivotIDs, bool showPivots, Color supportZoneColor, string version)
        {
            return _indicator.CDA_FuzzyPivots(input, debug, debugFileDir, debugFileNamePrefix, debugLevel, dPTLVolumeRegulator, emailAddress, enableRunLog, highColor, licensor, lowColor, pivotIntersectMargin, pivotStrength, resistanceZoneColor, runLogFileDir, runLogFilename, showPivotIDs, showPivots, supportZoneColor, version);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Displays dynamically ranked overlapping DPTL zones based on sets of intersecting pivots. A fuzzy zone indicates an area of frequent consolidation and brightness of the zone suggesting relative strength.   A darker zone suggests SR levels of higher degree with less frequent overlaps but more major LSP and BOB levels.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.CDA_FuzzyPivots CDA_FuzzyPivots(bool debug, string debugFileDir, string debugFileNamePrefix, int debugLevel, int dPTLVolumeRegulator, string emailAddress, bool enableRunLog, Color highColor, CDA_FuzzyPivots_Licensor licensor, Color lowColor, int pivotIntersectMargin, int pivotStrength, Color resistanceZoneColor, string runLogFileDir, string runLogFilename, bool showPivotIDs, bool showPivots, Color supportZoneColor, string version)
        {
            return _indicator.CDA_FuzzyPivots(Input, debug, debugFileDir, debugFileNamePrefix, debugLevel, dPTLVolumeRegulator, emailAddress, enableRunLog, highColor, licensor, lowColor, pivotIntersectMargin, pivotStrength, resistanceZoneColor, runLogFileDir, runLogFilename, showPivotIDs, showPivots, supportZoneColor, version);
        }

        /// <summary>
        /// Displays dynamically ranked overlapping DPTL zones based on sets of intersecting pivots. A fuzzy zone indicates an area of frequent consolidation and brightness of the zone suggesting relative strength.   A darker zone suggests SR levels of higher degree with less frequent overlaps but more major LSP and BOB levels.
        /// </summary>
        /// <returns></returns>
        public Indicator.CDA_FuzzyPivots CDA_FuzzyPivots(Data.IDataSeries input, bool debug, string debugFileDir, string debugFileNamePrefix, int debugLevel, int dPTLVolumeRegulator, string emailAddress, bool enableRunLog, Color highColor, CDA_FuzzyPivots_Licensor licensor, Color lowColor, int pivotIntersectMargin, int pivotStrength, Color resistanceZoneColor, string runLogFileDir, string runLogFilename, bool showPivotIDs, bool showPivots, Color supportZoneColor, string version)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.CDA_FuzzyPivots(input, debug, debugFileDir, debugFileNamePrefix, debugLevel, dPTLVolumeRegulator, emailAddress, enableRunLog, highColor, licensor, lowColor, pivotIntersectMargin, pivotStrength, resistanceZoneColor, runLogFileDir, runLogFilename, showPivotIDs, showPivots, supportZoneColor, version);
        }
    }
}
#endregion
