//
// Copyright (C) 2006, NinjaTrader LLC <ninjatrader@ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private CDA_DFibX[] cacheCDA_DFibX = null;

        private static CDA_DFibX checkCDA_DFibX = new CDA_DFibX();

        /// <summary>
        /// Displays multitple degrees of Dynamically adjusting Fibonacci Extensions relative to most recent or specified pivots.
        /// </summary>
        /// <returns></returns>
        public CDA_DFibX CDA_DFibX(string alertMessageForAnchorPivot, string alertMessageForDFibX, string alertSoundLocation, Color anchorColor, DashStyle anchorDashStyle, string anchorDateTimeStr, bool anchorOnDateTime, bool anchorPivotAlertEnabled, int anchorWidth, bool appendDFibXLabelToMessage, bool appendMessageToInstrument, bool appendPriceToMessage, int confirmationMargin, Color confirmationWaveColor, bool confirmWithDFibX1382, int degrees, CDA_DFibX_ForSRType dFibsAboveBelow, bool dFibX0786AlertEnabled, Color dFibX0786Color, DashStyle dFibX0786DashStyle, int dFibX0786HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX0786LabelJust, string dFibX0786LineLabel, double dFibX0786VerticalTextOffset, int dFibX0786Width, bool dFibX1191AlertEnabled, Color dFibX1191Color, DashStyle dFibX1191DashStyle, int dFibX1191HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX1191LabelJust, string dFibX1191LineLabel, double dFibX1191VerticalTextOffset, int dFibX1191Width, bool dFibX127AlertEnabled, Color dFibX127Color, DashStyle dFibX127DashStyle, int dFibX127HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX127LabelJust, string dFibX127LineLabel, double dFibX127VerticalTextOffset, int dFibX127Width, bool dFibX1382AlertEnabled, Color dFibX1382Color, DashStyle dFibX1382DashStyle, int dFibX1382HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX1382LabelJust, string dFibX1382LineLabel, double dFibX1382VerticalTextOffset, int dFibX1382Width, bool dFibX1618AlertEnabled, Color dFibX1618Color, DashStyle dFibX1618DashStyle, int dFibX1618HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX1618LabelJust, string dFibX1618LineLabel, double dFibX1618VerticalTextOffset, int dFibX1618Width, bool dFibX1AlertEnabled, Color dFibX1Color, DashStyle dFibX1DashStyle, int dFibX1HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX1LabelJust, string dFibX1LineLabel, double dFibX1VerticalTextOffset, int dFibX1Width, bool dFibX2618AlertEnabled, Color dFibX2618Color, DashStyle dFibX2618DashStyle, int dFibX2618HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX2618LabelJust, string dFibX2618LineLabel, double dFibX2618VerticalTextOffset, int dFibX2618Width, bool dFibX2AlertEnabled, Color dFibX2Color, DashStyle dFibX2DashStyle, int dFibX2HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX2LabelJust, string dFibX2LineLabel, double dFibX2VerticalTextOffset, int dFibX2Width, Font dFibXFont, string emailAddress, string emailToAddress, bool enableRunLog, bool finesseSW1Selection, Color highColor, CDA_DFibX_Licensor licensor, Color lowColor, double maxBiggerFactor, double minBiggerFactor, int minConfirmations, int pivotStrength, string runLogFileDir, string runLogFilename, bool showAnchor, bool showCandidateWavess, bool showConfirmationWaves, bool showDFibX0786, bool showDFibX1, bool showDFibX1191, bool showDFibX127, bool showDFibX1382, bool showDFibX1618, bool showDFibX2, bool showDFibX2618, bool showPivotIDs, bool showPivots, bool showSourceWaves, bool showStartupMessages, Color sourceWaveColor, string sourceWaveLabel, bool speechEnabled)
        {
            return CDA_DFibX(Input, alertMessageForAnchorPivot, alertMessageForDFibX, alertSoundLocation, anchorColor, anchorDashStyle, anchorDateTimeStr, anchorOnDateTime, anchorPivotAlertEnabled, anchorWidth, appendDFibXLabelToMessage, appendMessageToInstrument, appendPriceToMessage, confirmationMargin, confirmationWaveColor, confirmWithDFibX1382, degrees, dFibsAboveBelow, dFibX0786AlertEnabled, dFibX0786Color, dFibX0786DashStyle, dFibX0786HorizontalTextOffset, dFibX0786LabelJust, dFibX0786LineLabel, dFibX0786VerticalTextOffset, dFibX0786Width, dFibX1191AlertEnabled, dFibX1191Color, dFibX1191DashStyle, dFibX1191HorizontalTextOffset, dFibX1191LabelJust, dFibX1191LineLabel, dFibX1191VerticalTextOffset, dFibX1191Width, dFibX127AlertEnabled, dFibX127Color, dFibX127DashStyle, dFibX127HorizontalTextOffset, dFibX127LabelJust, dFibX127LineLabel, dFibX127VerticalTextOffset, dFibX127Width, dFibX1382AlertEnabled, dFibX1382Color, dFibX1382DashStyle, dFibX1382HorizontalTextOffset, dFibX1382LabelJust, dFibX1382LineLabel, dFibX1382VerticalTextOffset, dFibX1382Width, dFibX1618AlertEnabled, dFibX1618Color, dFibX1618DashStyle, dFibX1618HorizontalTextOffset, dFibX1618LabelJust, dFibX1618LineLabel, dFibX1618VerticalTextOffset, dFibX1618Width, dFibX1AlertEnabled, dFibX1Color, dFibX1DashStyle, dFibX1HorizontalTextOffset, dFibX1LabelJust, dFibX1LineLabel, dFibX1VerticalTextOffset, dFibX1Width, dFibX2618AlertEnabled, dFibX2618Color, dFibX2618DashStyle, dFibX2618HorizontalTextOffset, dFibX2618LabelJust, dFibX2618LineLabel, dFibX2618VerticalTextOffset, dFibX2618Width, dFibX2AlertEnabled, dFibX2Color, dFibX2DashStyle, dFibX2HorizontalTextOffset, dFibX2LabelJust, dFibX2LineLabel, dFibX2VerticalTextOffset, dFibX2Width, dFibXFont, emailAddress, emailToAddress, enableRunLog, finesseSW1Selection, highColor, licensor, lowColor, maxBiggerFactor, minBiggerFactor, minConfirmations, pivotStrength, runLogFileDir, runLogFilename, showAnchor, showCandidateWavess, showConfirmationWaves, showDFibX0786, showDFibX1, showDFibX1191, showDFibX127, showDFibX1382, showDFibX1618, showDFibX2, showDFibX2618, showPivotIDs, showPivots, showSourceWaves, showStartupMessages, sourceWaveColor, sourceWaveLabel, speechEnabled);
        }

        /// <summary>
        /// Displays multitple degrees of Dynamically adjusting Fibonacci Extensions relative to most recent or specified pivots.
        /// </summary>
        /// <returns></returns>
        public CDA_DFibX CDA_DFibX(Data.IDataSeries input, string alertMessageForAnchorPivot, string alertMessageForDFibX, string alertSoundLocation, Color anchorColor, DashStyle anchorDashStyle, string anchorDateTimeStr, bool anchorOnDateTime, bool anchorPivotAlertEnabled, int anchorWidth, bool appendDFibXLabelToMessage, bool appendMessageToInstrument, bool appendPriceToMessage, int confirmationMargin, Color confirmationWaveColor, bool confirmWithDFibX1382, int degrees, CDA_DFibX_ForSRType dFibsAboveBelow, bool dFibX0786AlertEnabled, Color dFibX0786Color, DashStyle dFibX0786DashStyle, int dFibX0786HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX0786LabelJust, string dFibX0786LineLabel, double dFibX0786VerticalTextOffset, int dFibX0786Width, bool dFibX1191AlertEnabled, Color dFibX1191Color, DashStyle dFibX1191DashStyle, int dFibX1191HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX1191LabelJust, string dFibX1191LineLabel, double dFibX1191VerticalTextOffset, int dFibX1191Width, bool dFibX127AlertEnabled, Color dFibX127Color, DashStyle dFibX127DashStyle, int dFibX127HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX127LabelJust, string dFibX127LineLabel, double dFibX127VerticalTextOffset, int dFibX127Width, bool dFibX1382AlertEnabled, Color dFibX1382Color, DashStyle dFibX1382DashStyle, int dFibX1382HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX1382LabelJust, string dFibX1382LineLabel, double dFibX1382VerticalTextOffset, int dFibX1382Width, bool dFibX1618AlertEnabled, Color dFibX1618Color, DashStyle dFibX1618DashStyle, int dFibX1618HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX1618LabelJust, string dFibX1618LineLabel, double dFibX1618VerticalTextOffset, int dFibX1618Width, bool dFibX1AlertEnabled, Color dFibX1Color, DashStyle dFibX1DashStyle, int dFibX1HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX1LabelJust, string dFibX1LineLabel, double dFibX1VerticalTextOffset, int dFibX1Width, bool dFibX2618AlertEnabled, Color dFibX2618Color, DashStyle dFibX2618DashStyle, int dFibX2618HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX2618LabelJust, string dFibX2618LineLabel, double dFibX2618VerticalTextOffset, int dFibX2618Width, bool dFibX2AlertEnabled, Color dFibX2Color, DashStyle dFibX2DashStyle, int dFibX2HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX2LabelJust, string dFibX2LineLabel, double dFibX2VerticalTextOffset, int dFibX2Width, Font dFibXFont, string emailAddress, string emailToAddress, bool enableRunLog, bool finesseSW1Selection, Color highColor, CDA_DFibX_Licensor licensor, Color lowColor, double maxBiggerFactor, double minBiggerFactor, int minConfirmations, int pivotStrength, string runLogFileDir, string runLogFilename, bool showAnchor, bool showCandidateWavess, bool showConfirmationWaves, bool showDFibX0786, bool showDFibX1, bool showDFibX1191, bool showDFibX127, bool showDFibX1382, bool showDFibX1618, bool showDFibX2, bool showDFibX2618, bool showPivotIDs, bool showPivots, bool showSourceWaves, bool showStartupMessages, Color sourceWaveColor, string sourceWaveLabel, bool speechEnabled)
        {
            if (cacheCDA_DFibX != null)
                for (int idx = 0; idx < cacheCDA_DFibX.Length; idx++)
                    if (cacheCDA_DFibX[idx].AlertMessageForAnchorPivot == alertMessageForAnchorPivot && cacheCDA_DFibX[idx].AlertMessageForDFibX == alertMessageForDFibX && cacheCDA_DFibX[idx].AlertSoundLocation == alertSoundLocation && cacheCDA_DFibX[idx].AnchorColor == anchorColor && cacheCDA_DFibX[idx].AnchorDashStyle == anchorDashStyle && cacheCDA_DFibX[idx].AnchorDateTimeStr == anchorDateTimeStr && cacheCDA_DFibX[idx].AnchorOnDateTime == anchorOnDateTime && cacheCDA_DFibX[idx].AnchorPivotAlertEnabled == anchorPivotAlertEnabled && cacheCDA_DFibX[idx].AnchorWidth == anchorWidth && cacheCDA_DFibX[idx].AppendDFibXLabelToMessage == appendDFibXLabelToMessage && cacheCDA_DFibX[idx].AppendMessageToInstrument == appendMessageToInstrument && cacheCDA_DFibX[idx].AppendPriceToMessage == appendPriceToMessage && cacheCDA_DFibX[idx].ConfirmationMargin == confirmationMargin && cacheCDA_DFibX[idx].ConfirmationWaveColor == confirmationWaveColor && cacheCDA_DFibX[idx].ConfirmWithDFibX1382 == confirmWithDFibX1382 && cacheCDA_DFibX[idx].Degrees == degrees && cacheCDA_DFibX[idx].DFibsAboveBelow == dFibsAboveBelow && cacheCDA_DFibX[idx].DFibX0786AlertEnabled == dFibX0786AlertEnabled && cacheCDA_DFibX[idx].DFibX0786Color == dFibX0786Color && cacheCDA_DFibX[idx].DFibX0786DashStyle == dFibX0786DashStyle && cacheCDA_DFibX[idx].DFibX0786HorizontalTextOffset == dFibX0786HorizontalTextOffset && cacheCDA_DFibX[idx].DFibX0786LabelJust == dFibX0786LabelJust && cacheCDA_DFibX[idx].DFibX0786LineLabel == dFibX0786LineLabel && Math.Abs(cacheCDA_DFibX[idx].DFibX0786VerticalTextOffset - dFibX0786VerticalTextOffset) <= double.Epsilon && cacheCDA_DFibX[idx].DFibX0786Width == dFibX0786Width && cacheCDA_DFibX[idx].DFibX1191AlertEnabled == dFibX1191AlertEnabled && cacheCDA_DFibX[idx].DFibX1191Color == dFibX1191Color && cacheCDA_DFibX[idx].DFibX1191DashStyle == dFibX1191DashStyle && cacheCDA_DFibX[idx].DFibX1191HorizontalTextOffset == dFibX1191HorizontalTextOffset && cacheCDA_DFibX[idx].DFibX1191LabelJust == dFibX1191LabelJust && cacheCDA_DFibX[idx].DFibX1191LineLabel == dFibX1191LineLabel && Math.Abs(cacheCDA_DFibX[idx].DFibX1191VerticalTextOffset - dFibX1191VerticalTextOffset) <= double.Epsilon && cacheCDA_DFibX[idx].DFibX1191Width == dFibX1191Width && cacheCDA_DFibX[idx].DFibX127AlertEnabled == dFibX127AlertEnabled && cacheCDA_DFibX[idx].DFibX127Color == dFibX127Color && cacheCDA_DFibX[idx].DFibX127DashStyle == dFibX127DashStyle && cacheCDA_DFibX[idx].DFibX127HorizontalTextOffset == dFibX127HorizontalTextOffset && cacheCDA_DFibX[idx].DFibX127LabelJust == dFibX127LabelJust && cacheCDA_DFibX[idx].DFibX127LineLabel == dFibX127LineLabel && Math.Abs(cacheCDA_DFibX[idx].DFibX127VerticalTextOffset - dFibX127VerticalTextOffset) <= double.Epsilon && cacheCDA_DFibX[idx].DFibX127Width == dFibX127Width && cacheCDA_DFibX[idx].DFibX1382AlertEnabled == dFibX1382AlertEnabled && cacheCDA_DFibX[idx].DFibX1382Color == dFibX1382Color && cacheCDA_DFibX[idx].DFibX1382DashStyle == dFibX1382DashStyle && cacheCDA_DFibX[idx].DFibX1382HorizontalTextOffset == dFibX1382HorizontalTextOffset && cacheCDA_DFibX[idx].DFibX1382LabelJust == dFibX1382LabelJust && cacheCDA_DFibX[idx].DFibX1382LineLabel == dFibX1382LineLabel && Math.Abs(cacheCDA_DFibX[idx].DFibX1382VerticalTextOffset - dFibX1382VerticalTextOffset) <= double.Epsilon && cacheCDA_DFibX[idx].DFibX1382Width == dFibX1382Width && cacheCDA_DFibX[idx].DFibX1618AlertEnabled == dFibX1618AlertEnabled && cacheCDA_DFibX[idx].DFibX1618Color == dFibX1618Color && cacheCDA_DFibX[idx].DFibX1618DashStyle == dFibX1618DashStyle && cacheCDA_DFibX[idx].DFibX1618HorizontalTextOffset == dFibX1618HorizontalTextOffset && cacheCDA_DFibX[idx].DFibX1618LabelJust == dFibX1618LabelJust && cacheCDA_DFibX[idx].DFibX1618LineLabel == dFibX1618LineLabel && Math.Abs(cacheCDA_DFibX[idx].DFibX1618VerticalTextOffset - dFibX1618VerticalTextOffset) <= double.Epsilon && cacheCDA_DFibX[idx].DFibX1618Width == dFibX1618Width && cacheCDA_DFibX[idx].DFibX1AlertEnabled == dFibX1AlertEnabled && cacheCDA_DFibX[idx].DFibX1Color == dFibX1Color && cacheCDA_DFibX[idx].DFibX1DashStyle == dFibX1DashStyle && cacheCDA_DFibX[idx].DFibX1HorizontalTextOffset == dFibX1HorizontalTextOffset && cacheCDA_DFibX[idx].DFibX1LabelJust == dFibX1LabelJust && cacheCDA_DFibX[idx].DFibX1LineLabel == dFibX1LineLabel && Math.Abs(cacheCDA_DFibX[idx].DFibX1VerticalTextOffset - dFibX1VerticalTextOffset) <= double.Epsilon && cacheCDA_DFibX[idx].DFibX1Width == dFibX1Width && cacheCDA_DFibX[idx].DFibX2618AlertEnabled == dFibX2618AlertEnabled && cacheCDA_DFibX[idx].DFibX2618Color == dFibX2618Color && cacheCDA_DFibX[idx].DFibX2618DashStyle == dFibX2618DashStyle && cacheCDA_DFibX[idx].DFibX2618HorizontalTextOffset == dFibX2618HorizontalTextOffset && cacheCDA_DFibX[idx].DFibX2618LabelJust == dFibX2618LabelJust && cacheCDA_DFibX[idx].DFibX2618LineLabel == dFibX2618LineLabel && Math.Abs(cacheCDA_DFibX[idx].DFibX2618VerticalTextOffset - dFibX2618VerticalTextOffset) <= double.Epsilon && cacheCDA_DFibX[idx].DFibX2618Width == dFibX2618Width && cacheCDA_DFibX[idx].DFibX2AlertEnabled == dFibX2AlertEnabled && cacheCDA_DFibX[idx].DFibX2Color == dFibX2Color && cacheCDA_DFibX[idx].DFibX2DashStyle == dFibX2DashStyle && cacheCDA_DFibX[idx].DFibX2HorizontalTextOffset == dFibX2HorizontalTextOffset && cacheCDA_DFibX[idx].DFibX2LabelJust == dFibX2LabelJust && cacheCDA_DFibX[idx].DFibX2LineLabel == dFibX2LineLabel && Math.Abs(cacheCDA_DFibX[idx].DFibX2VerticalTextOffset - dFibX2VerticalTextOffset) <= double.Epsilon && cacheCDA_DFibX[idx].DFibX2Width == dFibX2Width && cacheCDA_DFibX[idx].DFibXFont == dFibXFont && cacheCDA_DFibX[idx].EmailAddress == emailAddress && cacheCDA_DFibX[idx].EmailToAddress == emailToAddress && cacheCDA_DFibX[idx].EnableRunLog == enableRunLog && cacheCDA_DFibX[idx].FinesseSW1Selection == finesseSW1Selection && cacheCDA_DFibX[idx].HighColor == highColor && cacheCDA_DFibX[idx].Licensor == licensor && cacheCDA_DFibX[idx].LowColor == lowColor && Math.Abs(cacheCDA_DFibX[idx].MaxBiggerFactor - maxBiggerFactor) <= double.Epsilon && Math.Abs(cacheCDA_DFibX[idx].MinBiggerFactor - minBiggerFactor) <= double.Epsilon && cacheCDA_DFibX[idx].MinConfirmations == minConfirmations && cacheCDA_DFibX[idx].PivotStrength == pivotStrength && cacheCDA_DFibX[idx].RunLogFileDir == runLogFileDir && cacheCDA_DFibX[idx].RunLogFilename == runLogFilename && cacheCDA_DFibX[idx].ShowAnchor == showAnchor && cacheCDA_DFibX[idx].ShowCandidateWavess == showCandidateWavess && cacheCDA_DFibX[idx].ShowConfirmationWaves == showConfirmationWaves && cacheCDA_DFibX[idx].ShowDFibX0786 == showDFibX0786 && cacheCDA_DFibX[idx].ShowDFibX1 == showDFibX1 && cacheCDA_DFibX[idx].ShowDFibX1191 == showDFibX1191 && cacheCDA_DFibX[idx].ShowDFibX127 == showDFibX127 && cacheCDA_DFibX[idx].ShowDFibX1382 == showDFibX1382 && cacheCDA_DFibX[idx].ShowDFibX1618 == showDFibX1618 && cacheCDA_DFibX[idx].ShowDFibX2 == showDFibX2 && cacheCDA_DFibX[idx].ShowDFibX2618 == showDFibX2618 && cacheCDA_DFibX[idx].ShowPivotIDs == showPivotIDs && cacheCDA_DFibX[idx].ShowPivots == showPivots && cacheCDA_DFibX[idx].ShowSourceWaves == showSourceWaves && cacheCDA_DFibX[idx].ShowStartupMessages == showStartupMessages && cacheCDA_DFibX[idx].SourceWaveColor == sourceWaveColor && cacheCDA_DFibX[idx].SourceWaveLabel == sourceWaveLabel && cacheCDA_DFibX[idx].SpeechEnabled == speechEnabled && cacheCDA_DFibX[idx].EqualsInput(input))
                        return cacheCDA_DFibX[idx];

            lock (checkCDA_DFibX)
            {
                checkCDA_DFibX.AlertMessageForAnchorPivot = alertMessageForAnchorPivot;
                alertMessageForAnchorPivot = checkCDA_DFibX.AlertMessageForAnchorPivot;
                checkCDA_DFibX.AlertMessageForDFibX = alertMessageForDFibX;
                alertMessageForDFibX = checkCDA_DFibX.AlertMessageForDFibX;
                checkCDA_DFibX.AlertSoundLocation = alertSoundLocation;
                alertSoundLocation = checkCDA_DFibX.AlertSoundLocation;
                checkCDA_DFibX.AnchorColor = anchorColor;
                anchorColor = checkCDA_DFibX.AnchorColor;
                checkCDA_DFibX.AnchorDashStyle = anchorDashStyle;
                anchorDashStyle = checkCDA_DFibX.AnchorDashStyle;
                checkCDA_DFibX.AnchorDateTimeStr = anchorDateTimeStr;
                anchorDateTimeStr = checkCDA_DFibX.AnchorDateTimeStr;
                checkCDA_DFibX.AnchorOnDateTime = anchorOnDateTime;
                anchorOnDateTime = checkCDA_DFibX.AnchorOnDateTime;
                checkCDA_DFibX.AnchorPivotAlertEnabled = anchorPivotAlertEnabled;
                anchorPivotAlertEnabled = checkCDA_DFibX.AnchorPivotAlertEnabled;
                checkCDA_DFibX.AnchorWidth = anchorWidth;
                anchorWidth = checkCDA_DFibX.AnchorWidth;
                checkCDA_DFibX.AppendDFibXLabelToMessage = appendDFibXLabelToMessage;
                appendDFibXLabelToMessage = checkCDA_DFibX.AppendDFibXLabelToMessage;
                checkCDA_DFibX.AppendMessageToInstrument = appendMessageToInstrument;
                appendMessageToInstrument = checkCDA_DFibX.AppendMessageToInstrument;
                checkCDA_DFibX.AppendPriceToMessage = appendPriceToMessage;
                appendPriceToMessage = checkCDA_DFibX.AppendPriceToMessage;
                checkCDA_DFibX.ConfirmationMargin = confirmationMargin;
                confirmationMargin = checkCDA_DFibX.ConfirmationMargin;
                checkCDA_DFibX.ConfirmationWaveColor = confirmationWaveColor;
                confirmationWaveColor = checkCDA_DFibX.ConfirmationWaveColor;
                checkCDA_DFibX.ConfirmWithDFibX1382 = confirmWithDFibX1382;
                confirmWithDFibX1382 = checkCDA_DFibX.ConfirmWithDFibX1382;
                checkCDA_DFibX.Degrees = degrees;
                degrees = checkCDA_DFibX.Degrees;
                checkCDA_DFibX.DFibsAboveBelow = dFibsAboveBelow;
                dFibsAboveBelow = checkCDA_DFibX.DFibsAboveBelow;
                checkCDA_DFibX.DFibX0786AlertEnabled = dFibX0786AlertEnabled;
                dFibX0786AlertEnabled = checkCDA_DFibX.DFibX0786AlertEnabled;
                checkCDA_DFibX.DFibX0786Color = dFibX0786Color;
                dFibX0786Color = checkCDA_DFibX.DFibX0786Color;
                checkCDA_DFibX.DFibX0786DashStyle = dFibX0786DashStyle;
                dFibX0786DashStyle = checkCDA_DFibX.DFibX0786DashStyle;
                checkCDA_DFibX.DFibX0786HorizontalTextOffset = dFibX0786HorizontalTextOffset;
                dFibX0786HorizontalTextOffset = checkCDA_DFibX.DFibX0786HorizontalTextOffset;
                checkCDA_DFibX.DFibX0786LabelJust = dFibX0786LabelJust;
                dFibX0786LabelJust = checkCDA_DFibX.DFibX0786LabelJust;
                checkCDA_DFibX.DFibX0786LineLabel = dFibX0786LineLabel;
                dFibX0786LineLabel = checkCDA_DFibX.DFibX0786LineLabel;
                checkCDA_DFibX.DFibX0786VerticalTextOffset = dFibX0786VerticalTextOffset;
                dFibX0786VerticalTextOffset = checkCDA_DFibX.DFibX0786VerticalTextOffset;
                checkCDA_DFibX.DFibX0786Width = dFibX0786Width;
                dFibX0786Width = checkCDA_DFibX.DFibX0786Width;
                checkCDA_DFibX.DFibX1191AlertEnabled = dFibX1191AlertEnabled;
                dFibX1191AlertEnabled = checkCDA_DFibX.DFibX1191AlertEnabled;
                checkCDA_DFibX.DFibX1191Color = dFibX1191Color;
                dFibX1191Color = checkCDA_DFibX.DFibX1191Color;
                checkCDA_DFibX.DFibX1191DashStyle = dFibX1191DashStyle;
                dFibX1191DashStyle = checkCDA_DFibX.DFibX1191DashStyle;
                checkCDA_DFibX.DFibX1191HorizontalTextOffset = dFibX1191HorizontalTextOffset;
                dFibX1191HorizontalTextOffset = checkCDA_DFibX.DFibX1191HorizontalTextOffset;
                checkCDA_DFibX.DFibX1191LabelJust = dFibX1191LabelJust;
                dFibX1191LabelJust = checkCDA_DFibX.DFibX1191LabelJust;
                checkCDA_DFibX.DFibX1191LineLabel = dFibX1191LineLabel;
                dFibX1191LineLabel = checkCDA_DFibX.DFibX1191LineLabel;
                checkCDA_DFibX.DFibX1191VerticalTextOffset = dFibX1191VerticalTextOffset;
                dFibX1191VerticalTextOffset = checkCDA_DFibX.DFibX1191VerticalTextOffset;
                checkCDA_DFibX.DFibX1191Width = dFibX1191Width;
                dFibX1191Width = checkCDA_DFibX.DFibX1191Width;
                checkCDA_DFibX.DFibX127AlertEnabled = dFibX127AlertEnabled;
                dFibX127AlertEnabled = checkCDA_DFibX.DFibX127AlertEnabled;
                checkCDA_DFibX.DFibX127Color = dFibX127Color;
                dFibX127Color = checkCDA_DFibX.DFibX127Color;
                checkCDA_DFibX.DFibX127DashStyle = dFibX127DashStyle;
                dFibX127DashStyle = checkCDA_DFibX.DFibX127DashStyle;
                checkCDA_DFibX.DFibX127HorizontalTextOffset = dFibX127HorizontalTextOffset;
                dFibX127HorizontalTextOffset = checkCDA_DFibX.DFibX127HorizontalTextOffset;
                checkCDA_DFibX.DFibX127LabelJust = dFibX127LabelJust;
                dFibX127LabelJust = checkCDA_DFibX.DFibX127LabelJust;
                checkCDA_DFibX.DFibX127LineLabel = dFibX127LineLabel;
                dFibX127LineLabel = checkCDA_DFibX.DFibX127LineLabel;
                checkCDA_DFibX.DFibX127VerticalTextOffset = dFibX127VerticalTextOffset;
                dFibX127VerticalTextOffset = checkCDA_DFibX.DFibX127VerticalTextOffset;
                checkCDA_DFibX.DFibX127Width = dFibX127Width;
                dFibX127Width = checkCDA_DFibX.DFibX127Width;
                checkCDA_DFibX.DFibX1382AlertEnabled = dFibX1382AlertEnabled;
                dFibX1382AlertEnabled = checkCDA_DFibX.DFibX1382AlertEnabled;
                checkCDA_DFibX.DFibX1382Color = dFibX1382Color;
                dFibX1382Color = checkCDA_DFibX.DFibX1382Color;
                checkCDA_DFibX.DFibX1382DashStyle = dFibX1382DashStyle;
                dFibX1382DashStyle = checkCDA_DFibX.DFibX1382DashStyle;
                checkCDA_DFibX.DFibX1382HorizontalTextOffset = dFibX1382HorizontalTextOffset;
                dFibX1382HorizontalTextOffset = checkCDA_DFibX.DFibX1382HorizontalTextOffset;
                checkCDA_DFibX.DFibX1382LabelJust = dFibX1382LabelJust;
                dFibX1382LabelJust = checkCDA_DFibX.DFibX1382LabelJust;
                checkCDA_DFibX.DFibX1382LineLabel = dFibX1382LineLabel;
                dFibX1382LineLabel = checkCDA_DFibX.DFibX1382LineLabel;
                checkCDA_DFibX.DFibX1382VerticalTextOffset = dFibX1382VerticalTextOffset;
                dFibX1382VerticalTextOffset = checkCDA_DFibX.DFibX1382VerticalTextOffset;
                checkCDA_DFibX.DFibX1382Width = dFibX1382Width;
                dFibX1382Width = checkCDA_DFibX.DFibX1382Width;
                checkCDA_DFibX.DFibX1618AlertEnabled = dFibX1618AlertEnabled;
                dFibX1618AlertEnabled = checkCDA_DFibX.DFibX1618AlertEnabled;
                checkCDA_DFibX.DFibX1618Color = dFibX1618Color;
                dFibX1618Color = checkCDA_DFibX.DFibX1618Color;
                checkCDA_DFibX.DFibX1618DashStyle = dFibX1618DashStyle;
                dFibX1618DashStyle = checkCDA_DFibX.DFibX1618DashStyle;
                checkCDA_DFibX.DFibX1618HorizontalTextOffset = dFibX1618HorizontalTextOffset;
                dFibX1618HorizontalTextOffset = checkCDA_DFibX.DFibX1618HorizontalTextOffset;
                checkCDA_DFibX.DFibX1618LabelJust = dFibX1618LabelJust;
                dFibX1618LabelJust = checkCDA_DFibX.DFibX1618LabelJust;
                checkCDA_DFibX.DFibX1618LineLabel = dFibX1618LineLabel;
                dFibX1618LineLabel = checkCDA_DFibX.DFibX1618LineLabel;
                checkCDA_DFibX.DFibX1618VerticalTextOffset = dFibX1618VerticalTextOffset;
                dFibX1618VerticalTextOffset = checkCDA_DFibX.DFibX1618VerticalTextOffset;
                checkCDA_DFibX.DFibX1618Width = dFibX1618Width;
                dFibX1618Width = checkCDA_DFibX.DFibX1618Width;
                checkCDA_DFibX.DFibX1AlertEnabled = dFibX1AlertEnabled;
                dFibX1AlertEnabled = checkCDA_DFibX.DFibX1AlertEnabled;
                checkCDA_DFibX.DFibX1Color = dFibX1Color;
                dFibX1Color = checkCDA_DFibX.DFibX1Color;
                checkCDA_DFibX.DFibX1DashStyle = dFibX1DashStyle;
                dFibX1DashStyle = checkCDA_DFibX.DFibX1DashStyle;
                checkCDA_DFibX.DFibX1HorizontalTextOffset = dFibX1HorizontalTextOffset;
                dFibX1HorizontalTextOffset = checkCDA_DFibX.DFibX1HorizontalTextOffset;
                checkCDA_DFibX.DFibX1LabelJust = dFibX1LabelJust;
                dFibX1LabelJust = checkCDA_DFibX.DFibX1LabelJust;
                checkCDA_DFibX.DFibX1LineLabel = dFibX1LineLabel;
                dFibX1LineLabel = checkCDA_DFibX.DFibX1LineLabel;
                checkCDA_DFibX.DFibX1VerticalTextOffset = dFibX1VerticalTextOffset;
                dFibX1VerticalTextOffset = checkCDA_DFibX.DFibX1VerticalTextOffset;
                checkCDA_DFibX.DFibX1Width = dFibX1Width;
                dFibX1Width = checkCDA_DFibX.DFibX1Width;
                checkCDA_DFibX.DFibX2618AlertEnabled = dFibX2618AlertEnabled;
                dFibX2618AlertEnabled = checkCDA_DFibX.DFibX2618AlertEnabled;
                checkCDA_DFibX.DFibX2618Color = dFibX2618Color;
                dFibX2618Color = checkCDA_DFibX.DFibX2618Color;
                checkCDA_DFibX.DFibX2618DashStyle = dFibX2618DashStyle;
                dFibX2618DashStyle = checkCDA_DFibX.DFibX2618DashStyle;
                checkCDA_DFibX.DFibX2618HorizontalTextOffset = dFibX2618HorizontalTextOffset;
                dFibX2618HorizontalTextOffset = checkCDA_DFibX.DFibX2618HorizontalTextOffset;
                checkCDA_DFibX.DFibX2618LabelJust = dFibX2618LabelJust;
                dFibX2618LabelJust = checkCDA_DFibX.DFibX2618LabelJust;
                checkCDA_DFibX.DFibX2618LineLabel = dFibX2618LineLabel;
                dFibX2618LineLabel = checkCDA_DFibX.DFibX2618LineLabel;
                checkCDA_DFibX.DFibX2618VerticalTextOffset = dFibX2618VerticalTextOffset;
                dFibX2618VerticalTextOffset = checkCDA_DFibX.DFibX2618VerticalTextOffset;
                checkCDA_DFibX.DFibX2618Width = dFibX2618Width;
                dFibX2618Width = checkCDA_DFibX.DFibX2618Width;
                checkCDA_DFibX.DFibX2AlertEnabled = dFibX2AlertEnabled;
                dFibX2AlertEnabled = checkCDA_DFibX.DFibX2AlertEnabled;
                checkCDA_DFibX.DFibX2Color = dFibX2Color;
                dFibX2Color = checkCDA_DFibX.DFibX2Color;
                checkCDA_DFibX.DFibX2DashStyle = dFibX2DashStyle;
                dFibX2DashStyle = checkCDA_DFibX.DFibX2DashStyle;
                checkCDA_DFibX.DFibX2HorizontalTextOffset = dFibX2HorizontalTextOffset;
                dFibX2HorizontalTextOffset = checkCDA_DFibX.DFibX2HorizontalTextOffset;
                checkCDA_DFibX.DFibX2LabelJust = dFibX2LabelJust;
                dFibX2LabelJust = checkCDA_DFibX.DFibX2LabelJust;
                checkCDA_DFibX.DFibX2LineLabel = dFibX2LineLabel;
                dFibX2LineLabel = checkCDA_DFibX.DFibX2LineLabel;
                checkCDA_DFibX.DFibX2VerticalTextOffset = dFibX2VerticalTextOffset;
                dFibX2VerticalTextOffset = checkCDA_DFibX.DFibX2VerticalTextOffset;
                checkCDA_DFibX.DFibX2Width = dFibX2Width;
                dFibX2Width = checkCDA_DFibX.DFibX2Width;
                checkCDA_DFibX.DFibXFont = dFibXFont;
                dFibXFont = checkCDA_DFibX.DFibXFont;
                checkCDA_DFibX.EmailAddress = emailAddress;
                emailAddress = checkCDA_DFibX.EmailAddress;
                checkCDA_DFibX.EmailToAddress = emailToAddress;
                emailToAddress = checkCDA_DFibX.EmailToAddress;
                checkCDA_DFibX.EnableRunLog = enableRunLog;
                enableRunLog = checkCDA_DFibX.EnableRunLog;
                checkCDA_DFibX.FinesseSW1Selection = finesseSW1Selection;
                finesseSW1Selection = checkCDA_DFibX.FinesseSW1Selection;
                checkCDA_DFibX.HighColor = highColor;
                highColor = checkCDA_DFibX.HighColor;
                checkCDA_DFibX.Licensor = licensor;
                licensor = checkCDA_DFibX.Licensor;
                checkCDA_DFibX.LowColor = lowColor;
                lowColor = checkCDA_DFibX.LowColor;
                checkCDA_DFibX.MaxBiggerFactor = maxBiggerFactor;
                maxBiggerFactor = checkCDA_DFibX.MaxBiggerFactor;
                checkCDA_DFibX.MinBiggerFactor = minBiggerFactor;
                minBiggerFactor = checkCDA_DFibX.MinBiggerFactor;
                checkCDA_DFibX.MinConfirmations = minConfirmations;
                minConfirmations = checkCDA_DFibX.MinConfirmations;
                checkCDA_DFibX.PivotStrength = pivotStrength;
                pivotStrength = checkCDA_DFibX.PivotStrength;
                checkCDA_DFibX.RunLogFileDir = runLogFileDir;
                runLogFileDir = checkCDA_DFibX.RunLogFileDir;
                checkCDA_DFibX.RunLogFilename = runLogFilename;
                runLogFilename = checkCDA_DFibX.RunLogFilename;
                checkCDA_DFibX.ShowAnchor = showAnchor;
                showAnchor = checkCDA_DFibX.ShowAnchor;
                checkCDA_DFibX.ShowCandidateWavess = showCandidateWavess;
                showCandidateWavess = checkCDA_DFibX.ShowCandidateWavess;
                checkCDA_DFibX.ShowConfirmationWaves = showConfirmationWaves;
                showConfirmationWaves = checkCDA_DFibX.ShowConfirmationWaves;
                checkCDA_DFibX.ShowDFibX0786 = showDFibX0786;
                showDFibX0786 = checkCDA_DFibX.ShowDFibX0786;
                checkCDA_DFibX.ShowDFibX1 = showDFibX1;
                showDFibX1 = checkCDA_DFibX.ShowDFibX1;
                checkCDA_DFibX.ShowDFibX1191 = showDFibX1191;
                showDFibX1191 = checkCDA_DFibX.ShowDFibX1191;
                checkCDA_DFibX.ShowDFibX127 = showDFibX127;
                showDFibX127 = checkCDA_DFibX.ShowDFibX127;
                checkCDA_DFibX.ShowDFibX1382 = showDFibX1382;
                showDFibX1382 = checkCDA_DFibX.ShowDFibX1382;
                checkCDA_DFibX.ShowDFibX1618 = showDFibX1618;
                showDFibX1618 = checkCDA_DFibX.ShowDFibX1618;
                checkCDA_DFibX.ShowDFibX2 = showDFibX2;
                showDFibX2 = checkCDA_DFibX.ShowDFibX2;
                checkCDA_DFibX.ShowDFibX2618 = showDFibX2618;
                showDFibX2618 = checkCDA_DFibX.ShowDFibX2618;
                checkCDA_DFibX.ShowPivotIDs = showPivotIDs;
                showPivotIDs = checkCDA_DFibX.ShowPivotIDs;
                checkCDA_DFibX.ShowPivots = showPivots;
                showPivots = checkCDA_DFibX.ShowPivots;
                checkCDA_DFibX.ShowSourceWaves = showSourceWaves;
                showSourceWaves = checkCDA_DFibX.ShowSourceWaves;
                checkCDA_DFibX.ShowStartupMessages = showStartupMessages;
                showStartupMessages = checkCDA_DFibX.ShowStartupMessages;
                checkCDA_DFibX.SourceWaveColor = sourceWaveColor;
                sourceWaveColor = checkCDA_DFibX.SourceWaveColor;
                checkCDA_DFibX.SourceWaveLabel = sourceWaveLabel;
                sourceWaveLabel = checkCDA_DFibX.SourceWaveLabel;
                checkCDA_DFibX.SpeechEnabled = speechEnabled;
                speechEnabled = checkCDA_DFibX.SpeechEnabled;

                if (cacheCDA_DFibX != null)
                    for (int idx = 0; idx < cacheCDA_DFibX.Length; idx++)
                        if (cacheCDA_DFibX[idx].AlertMessageForAnchorPivot == alertMessageForAnchorPivot && cacheCDA_DFibX[idx].AlertMessageForDFibX == alertMessageForDFibX && cacheCDA_DFibX[idx].AlertSoundLocation == alertSoundLocation && cacheCDA_DFibX[idx].AnchorColor == anchorColor && cacheCDA_DFibX[idx].AnchorDashStyle == anchorDashStyle && cacheCDA_DFibX[idx].AnchorDateTimeStr == anchorDateTimeStr && cacheCDA_DFibX[idx].AnchorOnDateTime == anchorOnDateTime && cacheCDA_DFibX[idx].AnchorPivotAlertEnabled == anchorPivotAlertEnabled && cacheCDA_DFibX[idx].AnchorWidth == anchorWidth && cacheCDA_DFibX[idx].AppendDFibXLabelToMessage == appendDFibXLabelToMessage && cacheCDA_DFibX[idx].AppendMessageToInstrument == appendMessageToInstrument && cacheCDA_DFibX[idx].AppendPriceToMessage == appendPriceToMessage && cacheCDA_DFibX[idx].ConfirmationMargin == confirmationMargin && cacheCDA_DFibX[idx].ConfirmationWaveColor == confirmationWaveColor && cacheCDA_DFibX[idx].ConfirmWithDFibX1382 == confirmWithDFibX1382 && cacheCDA_DFibX[idx].Degrees == degrees && cacheCDA_DFibX[idx].DFibsAboveBelow == dFibsAboveBelow && cacheCDA_DFibX[idx].DFibX0786AlertEnabled == dFibX0786AlertEnabled && cacheCDA_DFibX[idx].DFibX0786Color == dFibX0786Color && cacheCDA_DFibX[idx].DFibX0786DashStyle == dFibX0786DashStyle && cacheCDA_DFibX[idx].DFibX0786HorizontalTextOffset == dFibX0786HorizontalTextOffset && cacheCDA_DFibX[idx].DFibX0786LabelJust == dFibX0786LabelJust && cacheCDA_DFibX[idx].DFibX0786LineLabel == dFibX0786LineLabel && Math.Abs(cacheCDA_DFibX[idx].DFibX0786VerticalTextOffset - dFibX0786VerticalTextOffset) <= double.Epsilon && cacheCDA_DFibX[idx].DFibX0786Width == dFibX0786Width && cacheCDA_DFibX[idx].DFibX1191AlertEnabled == dFibX1191AlertEnabled && cacheCDA_DFibX[idx].DFibX1191Color == dFibX1191Color && cacheCDA_DFibX[idx].DFibX1191DashStyle == dFibX1191DashStyle && cacheCDA_DFibX[idx].DFibX1191HorizontalTextOffset == dFibX1191HorizontalTextOffset && cacheCDA_DFibX[idx].DFibX1191LabelJust == dFibX1191LabelJust && cacheCDA_DFibX[idx].DFibX1191LineLabel == dFibX1191LineLabel && Math.Abs(cacheCDA_DFibX[idx].DFibX1191VerticalTextOffset - dFibX1191VerticalTextOffset) <= double.Epsilon && cacheCDA_DFibX[idx].DFibX1191Width == dFibX1191Width && cacheCDA_DFibX[idx].DFibX127AlertEnabled == dFibX127AlertEnabled && cacheCDA_DFibX[idx].DFibX127Color == dFibX127Color && cacheCDA_DFibX[idx].DFibX127DashStyle == dFibX127DashStyle && cacheCDA_DFibX[idx].DFibX127HorizontalTextOffset == dFibX127HorizontalTextOffset && cacheCDA_DFibX[idx].DFibX127LabelJust == dFibX127LabelJust && cacheCDA_DFibX[idx].DFibX127LineLabel == dFibX127LineLabel && Math.Abs(cacheCDA_DFibX[idx].DFibX127VerticalTextOffset - dFibX127VerticalTextOffset) <= double.Epsilon && cacheCDA_DFibX[idx].DFibX127Width == dFibX127Width && cacheCDA_DFibX[idx].DFibX1382AlertEnabled == dFibX1382AlertEnabled && cacheCDA_DFibX[idx].DFibX1382Color == dFibX1382Color && cacheCDA_DFibX[idx].DFibX1382DashStyle == dFibX1382DashStyle && cacheCDA_DFibX[idx].DFibX1382HorizontalTextOffset == dFibX1382HorizontalTextOffset && cacheCDA_DFibX[idx].DFibX1382LabelJust == dFibX1382LabelJust && cacheCDA_DFibX[idx].DFibX1382LineLabel == dFibX1382LineLabel && Math.Abs(cacheCDA_DFibX[idx].DFibX1382VerticalTextOffset - dFibX1382VerticalTextOffset) <= double.Epsilon && cacheCDA_DFibX[idx].DFibX1382Width == dFibX1382Width && cacheCDA_DFibX[idx].DFibX1618AlertEnabled == dFibX1618AlertEnabled && cacheCDA_DFibX[idx].DFibX1618Color == dFibX1618Color && cacheCDA_DFibX[idx].DFibX1618DashStyle == dFibX1618DashStyle && cacheCDA_DFibX[idx].DFibX1618HorizontalTextOffset == dFibX1618HorizontalTextOffset && cacheCDA_DFibX[idx].DFibX1618LabelJust == dFibX1618LabelJust && cacheCDA_DFibX[idx].DFibX1618LineLabel == dFibX1618LineLabel && Math.Abs(cacheCDA_DFibX[idx].DFibX1618VerticalTextOffset - dFibX1618VerticalTextOffset) <= double.Epsilon && cacheCDA_DFibX[idx].DFibX1618Width == dFibX1618Width && cacheCDA_DFibX[idx].DFibX1AlertEnabled == dFibX1AlertEnabled && cacheCDA_DFibX[idx].DFibX1Color == dFibX1Color && cacheCDA_DFibX[idx].DFibX1DashStyle == dFibX1DashStyle && cacheCDA_DFibX[idx].DFibX1HorizontalTextOffset == dFibX1HorizontalTextOffset && cacheCDA_DFibX[idx].DFibX1LabelJust == dFibX1LabelJust && cacheCDA_DFibX[idx].DFibX1LineLabel == dFibX1LineLabel && Math.Abs(cacheCDA_DFibX[idx].DFibX1VerticalTextOffset - dFibX1VerticalTextOffset) <= double.Epsilon && cacheCDA_DFibX[idx].DFibX1Width == dFibX1Width && cacheCDA_DFibX[idx].DFibX2618AlertEnabled == dFibX2618AlertEnabled && cacheCDA_DFibX[idx].DFibX2618Color == dFibX2618Color && cacheCDA_DFibX[idx].DFibX2618DashStyle == dFibX2618DashStyle && cacheCDA_DFibX[idx].DFibX2618HorizontalTextOffset == dFibX2618HorizontalTextOffset && cacheCDA_DFibX[idx].DFibX2618LabelJust == dFibX2618LabelJust && cacheCDA_DFibX[idx].DFibX2618LineLabel == dFibX2618LineLabel && Math.Abs(cacheCDA_DFibX[idx].DFibX2618VerticalTextOffset - dFibX2618VerticalTextOffset) <= double.Epsilon && cacheCDA_DFibX[idx].DFibX2618Width == dFibX2618Width && cacheCDA_DFibX[idx].DFibX2AlertEnabled == dFibX2AlertEnabled && cacheCDA_DFibX[idx].DFibX2Color == dFibX2Color && cacheCDA_DFibX[idx].DFibX2DashStyle == dFibX2DashStyle && cacheCDA_DFibX[idx].DFibX2HorizontalTextOffset == dFibX2HorizontalTextOffset && cacheCDA_DFibX[idx].DFibX2LabelJust == dFibX2LabelJust && cacheCDA_DFibX[idx].DFibX2LineLabel == dFibX2LineLabel && Math.Abs(cacheCDA_DFibX[idx].DFibX2VerticalTextOffset - dFibX2VerticalTextOffset) <= double.Epsilon && cacheCDA_DFibX[idx].DFibX2Width == dFibX2Width && cacheCDA_DFibX[idx].DFibXFont == dFibXFont && cacheCDA_DFibX[idx].EmailAddress == emailAddress && cacheCDA_DFibX[idx].EmailToAddress == emailToAddress && cacheCDA_DFibX[idx].EnableRunLog == enableRunLog && cacheCDA_DFibX[idx].FinesseSW1Selection == finesseSW1Selection && cacheCDA_DFibX[idx].HighColor == highColor && cacheCDA_DFibX[idx].Licensor == licensor && cacheCDA_DFibX[idx].LowColor == lowColor && Math.Abs(cacheCDA_DFibX[idx].MaxBiggerFactor - maxBiggerFactor) <= double.Epsilon && Math.Abs(cacheCDA_DFibX[idx].MinBiggerFactor - minBiggerFactor) <= double.Epsilon && cacheCDA_DFibX[idx].MinConfirmations == minConfirmations && cacheCDA_DFibX[idx].PivotStrength == pivotStrength && cacheCDA_DFibX[idx].RunLogFileDir == runLogFileDir && cacheCDA_DFibX[idx].RunLogFilename == runLogFilename && cacheCDA_DFibX[idx].ShowAnchor == showAnchor && cacheCDA_DFibX[idx].ShowCandidateWavess == showCandidateWavess && cacheCDA_DFibX[idx].ShowConfirmationWaves == showConfirmationWaves && cacheCDA_DFibX[idx].ShowDFibX0786 == showDFibX0786 && cacheCDA_DFibX[idx].ShowDFibX1 == showDFibX1 && cacheCDA_DFibX[idx].ShowDFibX1191 == showDFibX1191 && cacheCDA_DFibX[idx].ShowDFibX127 == showDFibX127 && cacheCDA_DFibX[idx].ShowDFibX1382 == showDFibX1382 && cacheCDA_DFibX[idx].ShowDFibX1618 == showDFibX1618 && cacheCDA_DFibX[idx].ShowDFibX2 == showDFibX2 && cacheCDA_DFibX[idx].ShowDFibX2618 == showDFibX2618 && cacheCDA_DFibX[idx].ShowPivotIDs == showPivotIDs && cacheCDA_DFibX[idx].ShowPivots == showPivots && cacheCDA_DFibX[idx].ShowSourceWaves == showSourceWaves && cacheCDA_DFibX[idx].ShowStartupMessages == showStartupMessages && cacheCDA_DFibX[idx].SourceWaveColor == sourceWaveColor && cacheCDA_DFibX[idx].SourceWaveLabel == sourceWaveLabel && cacheCDA_DFibX[idx].SpeechEnabled == speechEnabled && cacheCDA_DFibX[idx].EqualsInput(input))
                            return cacheCDA_DFibX[idx];

                CDA_DFibX indicator = new CDA_DFibX();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.AlertMessageForAnchorPivot = alertMessageForAnchorPivot;
                indicator.AlertMessageForDFibX = alertMessageForDFibX;
                indicator.AlertSoundLocation = alertSoundLocation;
                indicator.AnchorColor = anchorColor;
                indicator.AnchorDashStyle = anchorDashStyle;
                indicator.AnchorDateTimeStr = anchorDateTimeStr;
                indicator.AnchorOnDateTime = anchorOnDateTime;
                indicator.AnchorPivotAlertEnabled = anchorPivotAlertEnabled;
                indicator.AnchorWidth = anchorWidth;
                indicator.AppendDFibXLabelToMessage = appendDFibXLabelToMessage;
                indicator.AppendMessageToInstrument = appendMessageToInstrument;
                indicator.AppendPriceToMessage = appendPriceToMessage;
                indicator.ConfirmationMargin = confirmationMargin;
                indicator.ConfirmationWaveColor = confirmationWaveColor;
                indicator.ConfirmWithDFibX1382 = confirmWithDFibX1382;
                indicator.Degrees = degrees;
                indicator.DFibsAboveBelow = dFibsAboveBelow;
                indicator.DFibX0786AlertEnabled = dFibX0786AlertEnabled;
                indicator.DFibX0786Color = dFibX0786Color;
                indicator.DFibX0786DashStyle = dFibX0786DashStyle;
                indicator.DFibX0786HorizontalTextOffset = dFibX0786HorizontalTextOffset;
                indicator.DFibX0786LabelJust = dFibX0786LabelJust;
                indicator.DFibX0786LineLabel = dFibX0786LineLabel;
                indicator.DFibX0786VerticalTextOffset = dFibX0786VerticalTextOffset;
                indicator.DFibX0786Width = dFibX0786Width;
                indicator.DFibX1191AlertEnabled = dFibX1191AlertEnabled;
                indicator.DFibX1191Color = dFibX1191Color;
                indicator.DFibX1191DashStyle = dFibX1191DashStyle;
                indicator.DFibX1191HorizontalTextOffset = dFibX1191HorizontalTextOffset;
                indicator.DFibX1191LabelJust = dFibX1191LabelJust;
                indicator.DFibX1191LineLabel = dFibX1191LineLabel;
                indicator.DFibX1191VerticalTextOffset = dFibX1191VerticalTextOffset;
                indicator.DFibX1191Width = dFibX1191Width;
                indicator.DFibX127AlertEnabled = dFibX127AlertEnabled;
                indicator.DFibX127Color = dFibX127Color;
                indicator.DFibX127DashStyle = dFibX127DashStyle;
                indicator.DFibX127HorizontalTextOffset = dFibX127HorizontalTextOffset;
                indicator.DFibX127LabelJust = dFibX127LabelJust;
                indicator.DFibX127LineLabel = dFibX127LineLabel;
                indicator.DFibX127VerticalTextOffset = dFibX127VerticalTextOffset;
                indicator.DFibX127Width = dFibX127Width;
                indicator.DFibX1382AlertEnabled = dFibX1382AlertEnabled;
                indicator.DFibX1382Color = dFibX1382Color;
                indicator.DFibX1382DashStyle = dFibX1382DashStyle;
                indicator.DFibX1382HorizontalTextOffset = dFibX1382HorizontalTextOffset;
                indicator.DFibX1382LabelJust = dFibX1382LabelJust;
                indicator.DFibX1382LineLabel = dFibX1382LineLabel;
                indicator.DFibX1382VerticalTextOffset = dFibX1382VerticalTextOffset;
                indicator.DFibX1382Width = dFibX1382Width;
                indicator.DFibX1618AlertEnabled = dFibX1618AlertEnabled;
                indicator.DFibX1618Color = dFibX1618Color;
                indicator.DFibX1618DashStyle = dFibX1618DashStyle;
                indicator.DFibX1618HorizontalTextOffset = dFibX1618HorizontalTextOffset;
                indicator.DFibX1618LabelJust = dFibX1618LabelJust;
                indicator.DFibX1618LineLabel = dFibX1618LineLabel;
                indicator.DFibX1618VerticalTextOffset = dFibX1618VerticalTextOffset;
                indicator.DFibX1618Width = dFibX1618Width;
                indicator.DFibX1AlertEnabled = dFibX1AlertEnabled;
                indicator.DFibX1Color = dFibX1Color;
                indicator.DFibX1DashStyle = dFibX1DashStyle;
                indicator.DFibX1HorizontalTextOffset = dFibX1HorizontalTextOffset;
                indicator.DFibX1LabelJust = dFibX1LabelJust;
                indicator.DFibX1LineLabel = dFibX1LineLabel;
                indicator.DFibX1VerticalTextOffset = dFibX1VerticalTextOffset;
                indicator.DFibX1Width = dFibX1Width;
                indicator.DFibX2618AlertEnabled = dFibX2618AlertEnabled;
                indicator.DFibX2618Color = dFibX2618Color;
                indicator.DFibX2618DashStyle = dFibX2618DashStyle;
                indicator.DFibX2618HorizontalTextOffset = dFibX2618HorizontalTextOffset;
                indicator.DFibX2618LabelJust = dFibX2618LabelJust;
                indicator.DFibX2618LineLabel = dFibX2618LineLabel;
                indicator.DFibX2618VerticalTextOffset = dFibX2618VerticalTextOffset;
                indicator.DFibX2618Width = dFibX2618Width;
                indicator.DFibX2AlertEnabled = dFibX2AlertEnabled;
                indicator.DFibX2Color = dFibX2Color;
                indicator.DFibX2DashStyle = dFibX2DashStyle;
                indicator.DFibX2HorizontalTextOffset = dFibX2HorizontalTextOffset;
                indicator.DFibX2LabelJust = dFibX2LabelJust;
                indicator.DFibX2LineLabel = dFibX2LineLabel;
                indicator.DFibX2VerticalTextOffset = dFibX2VerticalTextOffset;
                indicator.DFibX2Width = dFibX2Width;
                indicator.DFibXFont = dFibXFont;
                indicator.EmailAddress = emailAddress;
                indicator.EmailToAddress = emailToAddress;
                indicator.EnableRunLog = enableRunLog;
                indicator.FinesseSW1Selection = finesseSW1Selection;
                indicator.HighColor = highColor;
                indicator.Licensor = licensor;
                indicator.LowColor = lowColor;
                indicator.MaxBiggerFactor = maxBiggerFactor;
                indicator.MinBiggerFactor = minBiggerFactor;
                indicator.MinConfirmations = minConfirmations;
                indicator.PivotStrength = pivotStrength;
                indicator.RunLogFileDir = runLogFileDir;
                indicator.RunLogFilename = runLogFilename;
                indicator.ShowAnchor = showAnchor;
                indicator.ShowCandidateWavess = showCandidateWavess;
                indicator.ShowConfirmationWaves = showConfirmationWaves;
                indicator.ShowDFibX0786 = showDFibX0786;
                indicator.ShowDFibX1 = showDFibX1;
                indicator.ShowDFibX1191 = showDFibX1191;
                indicator.ShowDFibX127 = showDFibX127;
                indicator.ShowDFibX1382 = showDFibX1382;
                indicator.ShowDFibX1618 = showDFibX1618;
                indicator.ShowDFibX2 = showDFibX2;
                indicator.ShowDFibX2618 = showDFibX2618;
                indicator.ShowPivotIDs = showPivotIDs;
                indicator.ShowPivots = showPivots;
                indicator.ShowSourceWaves = showSourceWaves;
                indicator.ShowStartupMessages = showStartupMessages;
                indicator.SourceWaveColor = sourceWaveColor;
                indicator.SourceWaveLabel = sourceWaveLabel;
                indicator.SpeechEnabled = speechEnabled;
                Indicators.Add(indicator);
                indicator.SetUp();

                CDA_DFibX[] tmp = new CDA_DFibX[cacheCDA_DFibX == null ? 1 : cacheCDA_DFibX.Length + 1];
                if (cacheCDA_DFibX != null)
                    cacheCDA_DFibX.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheCDA_DFibX = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Displays multitple degrees of Dynamically adjusting Fibonacci Extensions relative to most recent or specified pivots.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.CDA_DFibX CDA_DFibX(string alertMessageForAnchorPivot, string alertMessageForDFibX, string alertSoundLocation, Color anchorColor, DashStyle anchorDashStyle, string anchorDateTimeStr, bool anchorOnDateTime, bool anchorPivotAlertEnabled, int anchorWidth, bool appendDFibXLabelToMessage, bool appendMessageToInstrument, bool appendPriceToMessage, int confirmationMargin, Color confirmationWaveColor, bool confirmWithDFibX1382, int degrees, CDA_DFibX_ForSRType dFibsAboveBelow, bool dFibX0786AlertEnabled, Color dFibX0786Color, DashStyle dFibX0786DashStyle, int dFibX0786HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX0786LabelJust, string dFibX0786LineLabel, double dFibX0786VerticalTextOffset, int dFibX0786Width, bool dFibX1191AlertEnabled, Color dFibX1191Color, DashStyle dFibX1191DashStyle, int dFibX1191HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX1191LabelJust, string dFibX1191LineLabel, double dFibX1191VerticalTextOffset, int dFibX1191Width, bool dFibX127AlertEnabled, Color dFibX127Color, DashStyle dFibX127DashStyle, int dFibX127HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX127LabelJust, string dFibX127LineLabel, double dFibX127VerticalTextOffset, int dFibX127Width, bool dFibX1382AlertEnabled, Color dFibX1382Color, DashStyle dFibX1382DashStyle, int dFibX1382HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX1382LabelJust, string dFibX1382LineLabel, double dFibX1382VerticalTextOffset, int dFibX1382Width, bool dFibX1618AlertEnabled, Color dFibX1618Color, DashStyle dFibX1618DashStyle, int dFibX1618HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX1618LabelJust, string dFibX1618LineLabel, double dFibX1618VerticalTextOffset, int dFibX1618Width, bool dFibX1AlertEnabled, Color dFibX1Color, DashStyle dFibX1DashStyle, int dFibX1HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX1LabelJust, string dFibX1LineLabel, double dFibX1VerticalTextOffset, int dFibX1Width, bool dFibX2618AlertEnabled, Color dFibX2618Color, DashStyle dFibX2618DashStyle, int dFibX2618HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX2618LabelJust, string dFibX2618LineLabel, double dFibX2618VerticalTextOffset, int dFibX2618Width, bool dFibX2AlertEnabled, Color dFibX2Color, DashStyle dFibX2DashStyle, int dFibX2HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX2LabelJust, string dFibX2LineLabel, double dFibX2VerticalTextOffset, int dFibX2Width, Font dFibXFont, string emailAddress, string emailToAddress, bool enableRunLog, bool finesseSW1Selection, Color highColor, CDA_DFibX_Licensor licensor, Color lowColor, double maxBiggerFactor, double minBiggerFactor, int minConfirmations, int pivotStrength, string runLogFileDir, string runLogFilename, bool showAnchor, bool showCandidateWavess, bool showConfirmationWaves, bool showDFibX0786, bool showDFibX1, bool showDFibX1191, bool showDFibX127, bool showDFibX1382, bool showDFibX1618, bool showDFibX2, bool showDFibX2618, bool showPivotIDs, bool showPivots, bool showSourceWaves, bool showStartupMessages, Color sourceWaveColor, string sourceWaveLabel, bool speechEnabled)
        {
            return _indicator.CDA_DFibX(Input, alertMessageForAnchorPivot, alertMessageForDFibX, alertSoundLocation, anchorColor, anchorDashStyle, anchorDateTimeStr, anchorOnDateTime, anchorPivotAlertEnabled, anchorWidth, appendDFibXLabelToMessage, appendMessageToInstrument, appendPriceToMessage, confirmationMargin, confirmationWaveColor, confirmWithDFibX1382, degrees, dFibsAboveBelow, dFibX0786AlertEnabled, dFibX0786Color, dFibX0786DashStyle, dFibX0786HorizontalTextOffset, dFibX0786LabelJust, dFibX0786LineLabel, dFibX0786VerticalTextOffset, dFibX0786Width, dFibX1191AlertEnabled, dFibX1191Color, dFibX1191DashStyle, dFibX1191HorizontalTextOffset, dFibX1191LabelJust, dFibX1191LineLabel, dFibX1191VerticalTextOffset, dFibX1191Width, dFibX127AlertEnabled, dFibX127Color, dFibX127DashStyle, dFibX127HorizontalTextOffset, dFibX127LabelJust, dFibX127LineLabel, dFibX127VerticalTextOffset, dFibX127Width, dFibX1382AlertEnabled, dFibX1382Color, dFibX1382DashStyle, dFibX1382HorizontalTextOffset, dFibX1382LabelJust, dFibX1382LineLabel, dFibX1382VerticalTextOffset, dFibX1382Width, dFibX1618AlertEnabled, dFibX1618Color, dFibX1618DashStyle, dFibX1618HorizontalTextOffset, dFibX1618LabelJust, dFibX1618LineLabel, dFibX1618VerticalTextOffset, dFibX1618Width, dFibX1AlertEnabled, dFibX1Color, dFibX1DashStyle, dFibX1HorizontalTextOffset, dFibX1LabelJust, dFibX1LineLabel, dFibX1VerticalTextOffset, dFibX1Width, dFibX2618AlertEnabled, dFibX2618Color, dFibX2618DashStyle, dFibX2618HorizontalTextOffset, dFibX2618LabelJust, dFibX2618LineLabel, dFibX2618VerticalTextOffset, dFibX2618Width, dFibX2AlertEnabled, dFibX2Color, dFibX2DashStyle, dFibX2HorizontalTextOffset, dFibX2LabelJust, dFibX2LineLabel, dFibX2VerticalTextOffset, dFibX2Width, dFibXFont, emailAddress, emailToAddress, enableRunLog, finesseSW1Selection, highColor, licensor, lowColor, maxBiggerFactor, minBiggerFactor, minConfirmations, pivotStrength, runLogFileDir, runLogFilename, showAnchor, showCandidateWavess, showConfirmationWaves, showDFibX0786, showDFibX1, showDFibX1191, showDFibX127, showDFibX1382, showDFibX1618, showDFibX2, showDFibX2618, showPivotIDs, showPivots, showSourceWaves, showStartupMessages, sourceWaveColor, sourceWaveLabel, speechEnabled);
        }

        /// <summary>
        /// Displays multitple degrees of Dynamically adjusting Fibonacci Extensions relative to most recent or specified pivots.
        /// </summary>
        /// <returns></returns>
        public Indicator.CDA_DFibX CDA_DFibX(Data.IDataSeries input, string alertMessageForAnchorPivot, string alertMessageForDFibX, string alertSoundLocation, Color anchorColor, DashStyle anchorDashStyle, string anchorDateTimeStr, bool anchorOnDateTime, bool anchorPivotAlertEnabled, int anchorWidth, bool appendDFibXLabelToMessage, bool appendMessageToInstrument, bool appendPriceToMessage, int confirmationMargin, Color confirmationWaveColor, bool confirmWithDFibX1382, int degrees, CDA_DFibX_ForSRType dFibsAboveBelow, bool dFibX0786AlertEnabled, Color dFibX0786Color, DashStyle dFibX0786DashStyle, int dFibX0786HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX0786LabelJust, string dFibX0786LineLabel, double dFibX0786VerticalTextOffset, int dFibX0786Width, bool dFibX1191AlertEnabled, Color dFibX1191Color, DashStyle dFibX1191DashStyle, int dFibX1191HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX1191LabelJust, string dFibX1191LineLabel, double dFibX1191VerticalTextOffset, int dFibX1191Width, bool dFibX127AlertEnabled, Color dFibX127Color, DashStyle dFibX127DashStyle, int dFibX127HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX127LabelJust, string dFibX127LineLabel, double dFibX127VerticalTextOffset, int dFibX127Width, bool dFibX1382AlertEnabled, Color dFibX1382Color, DashStyle dFibX1382DashStyle, int dFibX1382HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX1382LabelJust, string dFibX1382LineLabel, double dFibX1382VerticalTextOffset, int dFibX1382Width, bool dFibX1618AlertEnabled, Color dFibX1618Color, DashStyle dFibX1618DashStyle, int dFibX1618HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX1618LabelJust, string dFibX1618LineLabel, double dFibX1618VerticalTextOffset, int dFibX1618Width, bool dFibX1AlertEnabled, Color dFibX1Color, DashStyle dFibX1DashStyle, int dFibX1HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX1LabelJust, string dFibX1LineLabel, double dFibX1VerticalTextOffset, int dFibX1Width, bool dFibX2618AlertEnabled, Color dFibX2618Color, DashStyle dFibX2618DashStyle, int dFibX2618HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX2618LabelJust, string dFibX2618LineLabel, double dFibX2618VerticalTextOffset, int dFibX2618Width, bool dFibX2AlertEnabled, Color dFibX2Color, DashStyle dFibX2DashStyle, int dFibX2HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX2LabelJust, string dFibX2LineLabel, double dFibX2VerticalTextOffset, int dFibX2Width, Font dFibXFont, string emailAddress, string emailToAddress, bool enableRunLog, bool finesseSW1Selection, Color highColor, CDA_DFibX_Licensor licensor, Color lowColor, double maxBiggerFactor, double minBiggerFactor, int minConfirmations, int pivotStrength, string runLogFileDir, string runLogFilename, bool showAnchor, bool showCandidateWavess, bool showConfirmationWaves, bool showDFibX0786, bool showDFibX1, bool showDFibX1191, bool showDFibX127, bool showDFibX1382, bool showDFibX1618, bool showDFibX2, bool showDFibX2618, bool showPivotIDs, bool showPivots, bool showSourceWaves, bool showStartupMessages, Color sourceWaveColor, string sourceWaveLabel, bool speechEnabled)
        {
            return _indicator.CDA_DFibX(input, alertMessageForAnchorPivot, alertMessageForDFibX, alertSoundLocation, anchorColor, anchorDashStyle, anchorDateTimeStr, anchorOnDateTime, anchorPivotAlertEnabled, anchorWidth, appendDFibXLabelToMessage, appendMessageToInstrument, appendPriceToMessage, confirmationMargin, confirmationWaveColor, confirmWithDFibX1382, degrees, dFibsAboveBelow, dFibX0786AlertEnabled, dFibX0786Color, dFibX0786DashStyle, dFibX0786HorizontalTextOffset, dFibX0786LabelJust, dFibX0786LineLabel, dFibX0786VerticalTextOffset, dFibX0786Width, dFibX1191AlertEnabled, dFibX1191Color, dFibX1191DashStyle, dFibX1191HorizontalTextOffset, dFibX1191LabelJust, dFibX1191LineLabel, dFibX1191VerticalTextOffset, dFibX1191Width, dFibX127AlertEnabled, dFibX127Color, dFibX127DashStyle, dFibX127HorizontalTextOffset, dFibX127LabelJust, dFibX127LineLabel, dFibX127VerticalTextOffset, dFibX127Width, dFibX1382AlertEnabled, dFibX1382Color, dFibX1382DashStyle, dFibX1382HorizontalTextOffset, dFibX1382LabelJust, dFibX1382LineLabel, dFibX1382VerticalTextOffset, dFibX1382Width, dFibX1618AlertEnabled, dFibX1618Color, dFibX1618DashStyle, dFibX1618HorizontalTextOffset, dFibX1618LabelJust, dFibX1618LineLabel, dFibX1618VerticalTextOffset, dFibX1618Width, dFibX1AlertEnabled, dFibX1Color, dFibX1DashStyle, dFibX1HorizontalTextOffset, dFibX1LabelJust, dFibX1LineLabel, dFibX1VerticalTextOffset, dFibX1Width, dFibX2618AlertEnabled, dFibX2618Color, dFibX2618DashStyle, dFibX2618HorizontalTextOffset, dFibX2618LabelJust, dFibX2618LineLabel, dFibX2618VerticalTextOffset, dFibX2618Width, dFibX2AlertEnabled, dFibX2Color, dFibX2DashStyle, dFibX2HorizontalTextOffset, dFibX2LabelJust, dFibX2LineLabel, dFibX2VerticalTextOffset, dFibX2Width, dFibXFont, emailAddress, emailToAddress, enableRunLog, finesseSW1Selection, highColor, licensor, lowColor, maxBiggerFactor, minBiggerFactor, minConfirmations, pivotStrength, runLogFileDir, runLogFilename, showAnchor, showCandidateWavess, showConfirmationWaves, showDFibX0786, showDFibX1, showDFibX1191, showDFibX127, showDFibX1382, showDFibX1618, showDFibX2, showDFibX2618, showPivotIDs, showPivots, showSourceWaves, showStartupMessages, sourceWaveColor, sourceWaveLabel, speechEnabled);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Displays multitple degrees of Dynamically adjusting Fibonacci Extensions relative to most recent or specified pivots.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.CDA_DFibX CDA_DFibX(string alertMessageForAnchorPivot, string alertMessageForDFibX, string alertSoundLocation, Color anchorColor, DashStyle anchorDashStyle, string anchorDateTimeStr, bool anchorOnDateTime, bool anchorPivotAlertEnabled, int anchorWidth, bool appendDFibXLabelToMessage, bool appendMessageToInstrument, bool appendPriceToMessage, int confirmationMargin, Color confirmationWaveColor, bool confirmWithDFibX1382, int degrees, CDA_DFibX_ForSRType dFibsAboveBelow, bool dFibX0786AlertEnabled, Color dFibX0786Color, DashStyle dFibX0786DashStyle, int dFibX0786HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX0786LabelJust, string dFibX0786LineLabel, double dFibX0786VerticalTextOffset, int dFibX0786Width, bool dFibX1191AlertEnabled, Color dFibX1191Color, DashStyle dFibX1191DashStyle, int dFibX1191HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX1191LabelJust, string dFibX1191LineLabel, double dFibX1191VerticalTextOffset, int dFibX1191Width, bool dFibX127AlertEnabled, Color dFibX127Color, DashStyle dFibX127DashStyle, int dFibX127HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX127LabelJust, string dFibX127LineLabel, double dFibX127VerticalTextOffset, int dFibX127Width, bool dFibX1382AlertEnabled, Color dFibX1382Color, DashStyle dFibX1382DashStyle, int dFibX1382HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX1382LabelJust, string dFibX1382LineLabel, double dFibX1382VerticalTextOffset, int dFibX1382Width, bool dFibX1618AlertEnabled, Color dFibX1618Color, DashStyle dFibX1618DashStyle, int dFibX1618HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX1618LabelJust, string dFibX1618LineLabel, double dFibX1618VerticalTextOffset, int dFibX1618Width, bool dFibX1AlertEnabled, Color dFibX1Color, DashStyle dFibX1DashStyle, int dFibX1HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX1LabelJust, string dFibX1LineLabel, double dFibX1VerticalTextOffset, int dFibX1Width, bool dFibX2618AlertEnabled, Color dFibX2618Color, DashStyle dFibX2618DashStyle, int dFibX2618HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX2618LabelJust, string dFibX2618LineLabel, double dFibX2618VerticalTextOffset, int dFibX2618Width, bool dFibX2AlertEnabled, Color dFibX2Color, DashStyle dFibX2DashStyle, int dFibX2HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX2LabelJust, string dFibX2LineLabel, double dFibX2VerticalTextOffset, int dFibX2Width, Font dFibXFont, string emailAddress, string emailToAddress, bool enableRunLog, bool finesseSW1Selection, Color highColor, CDA_DFibX_Licensor licensor, Color lowColor, double maxBiggerFactor, double minBiggerFactor, int minConfirmations, int pivotStrength, string runLogFileDir, string runLogFilename, bool showAnchor, bool showCandidateWavess, bool showConfirmationWaves, bool showDFibX0786, bool showDFibX1, bool showDFibX1191, bool showDFibX127, bool showDFibX1382, bool showDFibX1618, bool showDFibX2, bool showDFibX2618, bool showPivotIDs, bool showPivots, bool showSourceWaves, bool showStartupMessages, Color sourceWaveColor, string sourceWaveLabel, bool speechEnabled)
        {
            return _indicator.CDA_DFibX(Input, alertMessageForAnchorPivot, alertMessageForDFibX, alertSoundLocation, anchorColor, anchorDashStyle, anchorDateTimeStr, anchorOnDateTime, anchorPivotAlertEnabled, anchorWidth, appendDFibXLabelToMessage, appendMessageToInstrument, appendPriceToMessage, confirmationMargin, confirmationWaveColor, confirmWithDFibX1382, degrees, dFibsAboveBelow, dFibX0786AlertEnabled, dFibX0786Color, dFibX0786DashStyle, dFibX0786HorizontalTextOffset, dFibX0786LabelJust, dFibX0786LineLabel, dFibX0786VerticalTextOffset, dFibX0786Width, dFibX1191AlertEnabled, dFibX1191Color, dFibX1191DashStyle, dFibX1191HorizontalTextOffset, dFibX1191LabelJust, dFibX1191LineLabel, dFibX1191VerticalTextOffset, dFibX1191Width, dFibX127AlertEnabled, dFibX127Color, dFibX127DashStyle, dFibX127HorizontalTextOffset, dFibX127LabelJust, dFibX127LineLabel, dFibX127VerticalTextOffset, dFibX127Width, dFibX1382AlertEnabled, dFibX1382Color, dFibX1382DashStyle, dFibX1382HorizontalTextOffset, dFibX1382LabelJust, dFibX1382LineLabel, dFibX1382VerticalTextOffset, dFibX1382Width, dFibX1618AlertEnabled, dFibX1618Color, dFibX1618DashStyle, dFibX1618HorizontalTextOffset, dFibX1618LabelJust, dFibX1618LineLabel, dFibX1618VerticalTextOffset, dFibX1618Width, dFibX1AlertEnabled, dFibX1Color, dFibX1DashStyle, dFibX1HorizontalTextOffset, dFibX1LabelJust, dFibX1LineLabel, dFibX1VerticalTextOffset, dFibX1Width, dFibX2618AlertEnabled, dFibX2618Color, dFibX2618DashStyle, dFibX2618HorizontalTextOffset, dFibX2618LabelJust, dFibX2618LineLabel, dFibX2618VerticalTextOffset, dFibX2618Width, dFibX2AlertEnabled, dFibX2Color, dFibX2DashStyle, dFibX2HorizontalTextOffset, dFibX2LabelJust, dFibX2LineLabel, dFibX2VerticalTextOffset, dFibX2Width, dFibXFont, emailAddress, emailToAddress, enableRunLog, finesseSW1Selection, highColor, licensor, lowColor, maxBiggerFactor, minBiggerFactor, minConfirmations, pivotStrength, runLogFileDir, runLogFilename, showAnchor, showCandidateWavess, showConfirmationWaves, showDFibX0786, showDFibX1, showDFibX1191, showDFibX127, showDFibX1382, showDFibX1618, showDFibX2, showDFibX2618, showPivotIDs, showPivots, showSourceWaves, showStartupMessages, sourceWaveColor, sourceWaveLabel, speechEnabled);
        }

        /// <summary>
        /// Displays multitple degrees of Dynamically adjusting Fibonacci Extensions relative to most recent or specified pivots.
        /// </summary>
        /// <returns></returns>
        public Indicator.CDA_DFibX CDA_DFibX(Data.IDataSeries input, string alertMessageForAnchorPivot, string alertMessageForDFibX, string alertSoundLocation, Color anchorColor, DashStyle anchorDashStyle, string anchorDateTimeStr, bool anchorOnDateTime, bool anchorPivotAlertEnabled, int anchorWidth, bool appendDFibXLabelToMessage, bool appendMessageToInstrument, bool appendPriceToMessage, int confirmationMargin, Color confirmationWaveColor, bool confirmWithDFibX1382, int degrees, CDA_DFibX_ForSRType dFibsAboveBelow, bool dFibX0786AlertEnabled, Color dFibX0786Color, DashStyle dFibX0786DashStyle, int dFibX0786HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX0786LabelJust, string dFibX0786LineLabel, double dFibX0786VerticalTextOffset, int dFibX0786Width, bool dFibX1191AlertEnabled, Color dFibX1191Color, DashStyle dFibX1191DashStyle, int dFibX1191HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX1191LabelJust, string dFibX1191LineLabel, double dFibX1191VerticalTextOffset, int dFibX1191Width, bool dFibX127AlertEnabled, Color dFibX127Color, DashStyle dFibX127DashStyle, int dFibX127HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX127LabelJust, string dFibX127LineLabel, double dFibX127VerticalTextOffset, int dFibX127Width, bool dFibX1382AlertEnabled, Color dFibX1382Color, DashStyle dFibX1382DashStyle, int dFibX1382HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX1382LabelJust, string dFibX1382LineLabel, double dFibX1382VerticalTextOffset, int dFibX1382Width, bool dFibX1618AlertEnabled, Color dFibX1618Color, DashStyle dFibX1618DashStyle, int dFibX1618HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX1618LabelJust, string dFibX1618LineLabel, double dFibX1618VerticalTextOffset, int dFibX1618Width, bool dFibX1AlertEnabled, Color dFibX1Color, DashStyle dFibX1DashStyle, int dFibX1HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX1LabelJust, string dFibX1LineLabel, double dFibX1VerticalTextOffset, int dFibX1Width, bool dFibX2618AlertEnabled, Color dFibX2618Color, DashStyle dFibX2618DashStyle, int dFibX2618HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX2618LabelJust, string dFibX2618LineLabel, double dFibX2618VerticalTextOffset, int dFibX2618Width, bool dFibX2AlertEnabled, Color dFibX2Color, DashStyle dFibX2DashStyle, int dFibX2HorizontalTextOffset, CDA_DFibX_LabelJustification dFibX2LabelJust, string dFibX2LineLabel, double dFibX2VerticalTextOffset, int dFibX2Width, Font dFibXFont, string emailAddress, string emailToAddress, bool enableRunLog, bool finesseSW1Selection, Color highColor, CDA_DFibX_Licensor licensor, Color lowColor, double maxBiggerFactor, double minBiggerFactor, int minConfirmations, int pivotStrength, string runLogFileDir, string runLogFilename, bool showAnchor, bool showCandidateWavess, bool showConfirmationWaves, bool showDFibX0786, bool showDFibX1, bool showDFibX1191, bool showDFibX127, bool showDFibX1382, bool showDFibX1618, bool showDFibX2, bool showDFibX2618, bool showPivotIDs, bool showPivots, bool showSourceWaves, bool showStartupMessages, Color sourceWaveColor, string sourceWaveLabel, bool speechEnabled)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.CDA_DFibX(input, alertMessageForAnchorPivot, alertMessageForDFibX, alertSoundLocation, anchorColor, anchorDashStyle, anchorDateTimeStr, anchorOnDateTime, anchorPivotAlertEnabled, anchorWidth, appendDFibXLabelToMessage, appendMessageToInstrument, appendPriceToMessage, confirmationMargin, confirmationWaveColor, confirmWithDFibX1382, degrees, dFibsAboveBelow, dFibX0786AlertEnabled, dFibX0786Color, dFibX0786DashStyle, dFibX0786HorizontalTextOffset, dFibX0786LabelJust, dFibX0786LineLabel, dFibX0786VerticalTextOffset, dFibX0786Width, dFibX1191AlertEnabled, dFibX1191Color, dFibX1191DashStyle, dFibX1191HorizontalTextOffset, dFibX1191LabelJust, dFibX1191LineLabel, dFibX1191VerticalTextOffset, dFibX1191Width, dFibX127AlertEnabled, dFibX127Color, dFibX127DashStyle, dFibX127HorizontalTextOffset, dFibX127LabelJust, dFibX127LineLabel, dFibX127VerticalTextOffset, dFibX127Width, dFibX1382AlertEnabled, dFibX1382Color, dFibX1382DashStyle, dFibX1382HorizontalTextOffset, dFibX1382LabelJust, dFibX1382LineLabel, dFibX1382VerticalTextOffset, dFibX1382Width, dFibX1618AlertEnabled, dFibX1618Color, dFibX1618DashStyle, dFibX1618HorizontalTextOffset, dFibX1618LabelJust, dFibX1618LineLabel, dFibX1618VerticalTextOffset, dFibX1618Width, dFibX1AlertEnabled, dFibX1Color, dFibX1DashStyle, dFibX1HorizontalTextOffset, dFibX1LabelJust, dFibX1LineLabel, dFibX1VerticalTextOffset, dFibX1Width, dFibX2618AlertEnabled, dFibX2618Color, dFibX2618DashStyle, dFibX2618HorizontalTextOffset, dFibX2618LabelJust, dFibX2618LineLabel, dFibX2618VerticalTextOffset, dFibX2618Width, dFibX2AlertEnabled, dFibX2Color, dFibX2DashStyle, dFibX2HorizontalTextOffset, dFibX2LabelJust, dFibX2LineLabel, dFibX2VerticalTextOffset, dFibX2Width, dFibXFont, emailAddress, emailToAddress, enableRunLog, finesseSW1Selection, highColor, licensor, lowColor, maxBiggerFactor, minBiggerFactor, minConfirmations, pivotStrength, runLogFileDir, runLogFilename, showAnchor, showCandidateWavess, showConfirmationWaves, showDFibX0786, showDFibX1, showDFibX1191, showDFibX127, showDFibX1382, showDFibX1618, showDFibX2, showDFibX2618, showPivotIDs, showPivots, showSourceWaves, showStartupMessages, sourceWaveColor, sourceWaveLabel, speechEnabled);
        }
    }
}
#endregion
