//
// Copyright (C) 2006, NinjaTrader LLC <ninjatrader@ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private CDA_VolumeProfile[] cacheCDA_VolumeProfile = null;

        private static CDA_VolumeProfile checkCDA_VolumeProfile = new CDA_VolumeProfile();

        /// <summary>
        /// Plots histograms of volume-at-price on price bars panel.
        /// </summary>
        /// <returns></returns>
        public CDA_VolumeProfile CDA_VolumeProfile(Color aboveAskColor, Color atAskColor, Color atBidColor, bool autoSaveMicroCompositeSettings, bool autoUpdateMCEndDate, Color belowBidColor, string bigPrintsFileDir, bool bPAlertEnabled, string bPAlertSoundFile, int bPDisplayCount, CDA_VolumeProfile_BigPrintDisplayMode bPDisplayMode, CDA_VolumeProfile_BigPrintDisplayPosition bPDisplayPosition, CDA_VolumeProfile_BigPrintFilterMode bPFilterMode, DashStyle bPHLineStyle, int bPHLineWidth, string bPLabel, Color bPLabelColor, Font bPLabelFont, int bPLabelOffset, int bPMinVolume, int bPMulipleAboveMultipleOfAverageVolume, DashStyle bPVLineStyle, int bPVLineWidth, CDA_VolumeProfile_CDCalculationModeType calcMode, string cD0Label, Color cD0LineColor, DashStyle cD0LineStyle, int cD0LineWidth, Color cDDownColor, Color cDHeadingsColor, Font cDHeadingsFont, string cDHighLabel, Color cDHighLineColor, DashStyle cDHighLineStyle, int cDHighLineWidth, DashStyle cDLineStyle, int cDLineWidth, CDA_VolumeProfile_CDLocation cDLocation, string cDLowLabel, Color cDLowLineColor, DashStyle cDLowLineStyle, int cDLowLineWidth, Color cDNeutralColor, string cDPlotLabel, Color cDUpColor, Font cDValueFont, Color cHVNBandColor, int cHVNBandOpacity, string cHVNBandOpacityToolLabel, int cHVNBandWidth, Color cHVNLineColor, DashStyle cHVNLineStyle, int cHVNLineWidth, Color closeColor, string closeLabel, DashStyle closeLineStyle, int closeLineWidth, Color cLVNBandColor, int cLVNBandOpacity, string cLVNBandOpacityToolLabel, int cLVNBandWidth, Color cLVNLineColor, DashStyle cLVNLineStyle, int cLVNLineWidth, int compositeAnchorOffset, string compositeAnchorOffsetToolLabel, CDA_VolumeProfile_CAnchorPosition compositeAnchorPosition, string compositeAnchorPositionToolLabel, DateTime compositeBeginDate, string compositeBeginDateToolLabel, Color compositeFillColor, int compositeOpacity, string compositeOpacityToolLabel, Color compositeOutlineColor, double compositeScale, string compositeScaleToolLabel, double compositeSmoothingFactor, string compositeSmoothingFactorToolLabel, bool compositeSquareOutline, string compositeVNToolLabel, int compValueNodeStrength, CDA_VolumeProfile_AnchorPositionCurrentSession currentSessionAnchorPosition, Color cVPOCColor, string cVPOCLabel, DashStyle cVPOCLineStyle, int cVPOCLineWidth, string dataFileDir, bool displayComputedAtBar, bool displayComputedAtPrice, bool displaySD1, bool displaySD2, bool displaySD3, bool displayVABand, bool drawCD0, bool drawCDHighLow, string emailAddress, string emailToAddress, bool enableCD, bool enableCHVNOpacityTool, bool enableCLVNOpacityTool, bool enableCompositeAnchorOffsetTool, bool enableCompositeAnchorPositionTool, bool enableCompositeBeginDateTool, CDA_VolumeProfile_Heatmap enableCompositeHeatmap, bool enableCompositeOpacityTool, bool enableCompositeScaleTool, bool enableCompositeSmoothingFactorTool, bool enableCompositeVNTool, bool enableHideBlockTradesButton, bool enableHideCDsButton, bool enableHideCompositeProfileButton, bool enableHideCompositeProfileValueNodesButton, bool enableHideMicroCompositeProfilesButton, bool enableHideMicroCompositeProfileValueAreasButton, bool enableHideMicroCompositeProfileValueNodesButton, bool enableHideOvernightStatsButton, bool enableHideSessionProfilesButton, bool enableMicroCompositeAnchorEdgeTool, bool enableMicroCompositeAnchorOffsetTool, bool enableMicroCompositeAnchorPositionTool, bool enableMicroCompositeDateRangeTool, CDA_VolumeProfile_Heatmap enableMicroCompositeHeatmap, bool enableMicroCompositeOpacityTool, bool enableMicroCompositeScaleTool, bool enableMicroCompositeSmoothingFactorTool, bool enableMicroCompositeVNTool, bool enablePrecisionRangeProfiling, bool enableRunLog, bool enableSessionAnchorOffsetTool, bool enableSessionAnchorPositionTool, CDA_VolumeProfile_Heatmap enableSessionHeatmap, bool enableSessionOpacityTool, bool enableSessionScaleTool, bool enableVWAP, string exportFileDir, CDA_VolumeProfile_RebuildCache exportStats, int fastPeriod, bool gAPAlertEnabled, string gAPAlertSoundFile, bool gAPAppendDate, bool gAPAppendPrice, Color gAPColor, Font gAPFont, string gAPLabel, DashStyle gAPLineStyle, int gAPLineWidth, Color highColor, string highLabel, bool highlightIB, bool highlightMCVA, bool highlightVA, DashStyle highLineStyle, int highLineWidth, Color iB15xColor, DashStyle iB15xLineStyle, int iB15xLineWidth, Color iB2xColor, DashStyle iB2xLineStyle, int iB2xLineWidth, Color iBColor, string iBH15xLabel, string iBH2xLabel, string iBHLabel, string iBL15xLabel, string iBL2xLabel, DashStyle iBLineStyle, int iBLineWidth, string iBLLabel, int iBMinutes, Color insideColor, int labelDelay, int labelDisplacement, Font labelFont, bool loadVBCache, Color lowColor, string lowLabel, DashStyle lowLineStyle, int lowLineWidth, bool mCAnchorPositionLabelFollowsValue, bool mCBeginEndByManualRect, string mCRectangleTagPrefix, Color mcVAColor, string mcVAHLabel, DashStyle mcVALineStyle, int mcVALineWidth, string mcVALLabel, double mcVAPercent, Color microCHVNColor, DashStyle microCHVNLineStyle, int microCHVNLineWidth, Color microCLVNColor, DashStyle microCLVNLineStyle, int microCLVNLineWidth, CDA_VolumeProfile_AnchorPosition microCompositeAnchorBar, CDA_VolumeProfile_AnchorEdge microCompositeAnchorEdge, string microCompositeAnchorEdgeToolLabel, int microCompositeAnchorOffset, string microCompositeAnchorOffsetToolLabel, CDA_VolumeProfile_MCAnchorPosition microCompositeAnchorPosition, string microCompositeAnchorPositionToolLabel, DateTime microCompositeBeginDate, string microCompositeDateRangeToolLabel, DateTime microCompositeEndDate, Color microCompositeFillColor, int microCompositeOpacity, string microCompositeOpacityToolLabel, Color microCompositeOutlineColor, double microCompositeScale, string microCompositeScaleToolLabel, string microCompositeSelectToolLabel, string microCompositeSmoothingFactorToolLabel, string microCompositeVNToolLabel, double microCompSmoothingFactor, bool microCompSquareOutline, Color microCVPOCColor, string microCVPOCLabel, DashStyle microCVPOCLineStyle, int microCVPOCLineWidth, int microValueNodeStrength, Color midPtColor, string midPtLabel, DashStyle midPtLineStyle, int midPtLineWidth, DateTime minVAPCacheFileDate, DateTime minVBCacheFileDate, double multiplierStdDev1, double multiplierStdDev2, double multiplierStdDev3, Color nHighColor, string nHighLabel, bool nHLAlertEnabled, string nHLAlertSoundFile, bool nHLAppendDate, bool nHLAppendPrice, Font nHLFont, DashStyle nHLLineStyle, int nHLLineWidth, bool nIBAlertEnabled, string nIBAlertSoundFile, bool nIBAppendDate, bool nIBAppendPrice, Color nIBColor, Font nIBFont, string nIBHLabel, DashStyle nIBLineStyle, int nIBLineWidth, string nIBLLabel, Color nLowColor, string nLowLabel, bool nVAAlertEnabled, string nVAAlertSoundFile, bool nVAAppendDate, bool nVAAppendPrice, Color nVAColor, Font nVAFont, string nVAHLabel, DashStyle nVALineStyle, int nVALineWidth, string nVALLabel, bool nVPOCAlertEnabled, string nVPOCAlertSoundFile, bool nVPOCAppendDate, bool nVPOCAppendPrice, Color nVPOCColor, Font nVPOCFont, string nVPOCLabel, DashStyle nVPOCLineStyle, int nVPOCLineWidth, int opacitySD1, int opacitySD2, int opacitySD3, Color openColor, string openLabel, DashStyle openLineStyle, int openLineWidth, int openSwingMaxMinutes, CDA_VolumeProfile_OperationalMode operationalMode, Color oSColor, string oSHLabel, DashStyle oSLineStyle, int oSLineWidth, string oSLLabel, Color overnightDefaultColor, int overnightDisplayPeriodHL, int overnightDisplayPeriodVPOC, Font overnightFont, Color overnightHighColor, string overnightHighLabel, DashStyle overnightHighLineStyle, int overnightHighLineWidth, Color overnightLowColor, string overnightLowLabel, DashStyle overnightLowLineStyle, int overnightLowLineWidth, string overnightStatsSessionName, Color overnightVPOCColor, string overnightVPOCLabel, DashStyle overnightVPOCLineStyle, int overnightVPOCLineWidth, bool plotCD, CDA_VolumeProfile_RebuildCache rebuildVAPCache, CDA_VolumeProfile_RebuildCache rebuildVBCache, CDA_VolumeProfile_RefreshWhen refreshCompositeCacheFile, CDA_VolumeProfile_CDReset resetCDatBar, double rolloverOffset, string rolloverToContractMonth, bool rolloverVAPCache, string rootFolder, string runLogFileDir, string runLogFilename, bool saveVBData, int sessionAnchorOffset, string sessionAnchorOffsetToolLabel, CDA_VolumeProfile_AnchorPosition sessionAnchorPosition, string sessionAnchorPositionToolLabel, string sessionCDvapHeading, Color sessionFillColor, int sessionOpacity, string sessionOpacityToolLabel, Color sessionOutlineColor, double sessionScale, string sessionScaleToolLabel, bool sessionSquareOutline, Font sessionVolumeFont, bool showBigPrints, bool showBPHLine, bool showBPVLine, bool showCDAtEachPrice, bool showCompositeBeginDate, bool showCompositeProfile, bool showCompositeVolumes, bool showCompValueNodePrice, CDA_VolumeProfile_VNMode showCompValueNodes, bool showGaps, CDA_VolumeProfile_ShowInSessions showIB, bool showIB15x, bool showIB2x, bool showIBRange, CDA_VolumeProfile_ShowInSessions showLabels, bool showMCVA, CDA_VolumeProfile_MCDatesPosition showMicroCompositeDates, bool showMicroCompositeProfile, bool showMicroCompositeVolumes, bool showMicroCompValueNodePrice, bool showMicroCompValueNodes, bool showNHLs, bool showNIBs, bool showNVAs, bool showNVPOCs, CDA_VolumeProfile_ShowInSessions showOHMLC, CDA_VolumeProfile_ShowInSessions showOS, bool showOvernightStats, bool showPriceWithLabel, bool showSessionImbalanceFactor, CDA_VolumeProfile_ShowInSessions showSessionProfile, bool showSessionRange, bool showSessionVolumes, bool showStartupMessages, bool showToolBar, bool showTrendChange, CDA_VolumeProfile_ShowInSessions showVA, bool showVARange, bool showVPOC, bool showVPOCTrack, int slowPeriod, string standardCDHeading, bool staticMCEnabled, int threshold, string toolBarHideDropDownLabel, Color toolBarTextColor, Font toolBarTextFont, Font toolBarTextFontOnFocus, string trendCDvapHeading, Color trendChangeDownColor, Color trendChangeUpColor, bool updateInRealtimeEnabled, Color vAColor, string vAHLabel, DashStyle vALineStyle, int vALineWidth, string vALLabel, int vAOpacity, double vAPercent, Color vPOCColor, string vPOCLabel, DashStyle vPOCLineStyle, int vPOCLineWidth, Color vWAPColor, string vWAPLabel, DashStyle vWAPLineStyle, int vWAPLineWidth, Color vWAPSD1Color, DashStyle vWAPSD1LineStyle, int vWAPSD1LineWidth, Color vWAPSD2Color, DashStyle vWAPSD2LineStyle, int vWAPSD2LineWidth, Color vWAPSD3Color, DashStyle vWAPSD3LineStyle, int vWAPSD3LineWidth)
        {
            return CDA_VolumeProfile(Input, aboveAskColor, atAskColor, atBidColor, autoSaveMicroCompositeSettings, autoUpdateMCEndDate, belowBidColor, bigPrintsFileDir, bPAlertEnabled, bPAlertSoundFile, bPDisplayCount, bPDisplayMode, bPDisplayPosition, bPFilterMode, bPHLineStyle, bPHLineWidth, bPLabel, bPLabelColor, bPLabelFont, bPLabelOffset, bPMinVolume, bPMulipleAboveMultipleOfAverageVolume, bPVLineStyle, bPVLineWidth, calcMode, cD0Label, cD0LineColor, cD0LineStyle, cD0LineWidth, cDDownColor, cDHeadingsColor, cDHeadingsFont, cDHighLabel, cDHighLineColor, cDHighLineStyle, cDHighLineWidth, cDLineStyle, cDLineWidth, cDLocation, cDLowLabel, cDLowLineColor, cDLowLineStyle, cDLowLineWidth, cDNeutralColor, cDPlotLabel, cDUpColor, cDValueFont, cHVNBandColor, cHVNBandOpacity, cHVNBandOpacityToolLabel, cHVNBandWidth, cHVNLineColor, cHVNLineStyle, cHVNLineWidth, closeColor, closeLabel, closeLineStyle, closeLineWidth, cLVNBandColor, cLVNBandOpacity, cLVNBandOpacityToolLabel, cLVNBandWidth, cLVNLineColor, cLVNLineStyle, cLVNLineWidth, compositeAnchorOffset, compositeAnchorOffsetToolLabel, compositeAnchorPosition, compositeAnchorPositionToolLabel, compositeBeginDate, compositeBeginDateToolLabel, compositeFillColor, compositeOpacity, compositeOpacityToolLabel, compositeOutlineColor, compositeScale, compositeScaleToolLabel, compositeSmoothingFactor, compositeSmoothingFactorToolLabel, compositeSquareOutline, compositeVNToolLabel, compValueNodeStrength, currentSessionAnchorPosition, cVPOCColor, cVPOCLabel, cVPOCLineStyle, cVPOCLineWidth, dataFileDir, displayComputedAtBar, displayComputedAtPrice, displaySD1, displaySD2, displaySD3, displayVABand, drawCD0, drawCDHighLow, emailAddress, emailToAddress, enableCD, enableCHVNOpacityTool, enableCLVNOpacityTool, enableCompositeAnchorOffsetTool, enableCompositeAnchorPositionTool, enableCompositeBeginDateTool, enableCompositeHeatmap, enableCompositeOpacityTool, enableCompositeScaleTool, enableCompositeSmoothingFactorTool, enableCompositeVNTool, enableHideBlockTradesButton, enableHideCDsButton, enableHideCompositeProfileButton, enableHideCompositeProfileValueNodesButton, enableHideMicroCompositeProfilesButton, enableHideMicroCompositeProfileValueAreasButton, enableHideMicroCompositeProfileValueNodesButton, enableHideOvernightStatsButton, enableHideSessionProfilesButton, enableMicroCompositeAnchorEdgeTool, enableMicroCompositeAnchorOffsetTool, enableMicroCompositeAnchorPositionTool, enableMicroCompositeDateRangeTool, enableMicroCompositeHeatmap, enableMicroCompositeOpacityTool, enableMicroCompositeScaleTool, enableMicroCompositeSmoothingFactorTool, enableMicroCompositeVNTool, enablePrecisionRangeProfiling, enableRunLog, enableSessionAnchorOffsetTool, enableSessionAnchorPositionTool, enableSessionHeatmap, enableSessionOpacityTool, enableSessionScaleTool, enableVWAP, exportFileDir, exportStats, fastPeriod, gAPAlertEnabled, gAPAlertSoundFile, gAPAppendDate, gAPAppendPrice, gAPColor, gAPFont, gAPLabel, gAPLineStyle, gAPLineWidth, highColor, highLabel, highlightIB, highlightMCVA, highlightVA, highLineStyle, highLineWidth, iB15xColor, iB15xLineStyle, iB15xLineWidth, iB2xColor, iB2xLineStyle, iB2xLineWidth, iBColor, iBH15xLabel, iBH2xLabel, iBHLabel, iBL15xLabel, iBL2xLabel, iBLineStyle, iBLineWidth, iBLLabel, iBMinutes, insideColor, labelDelay, labelDisplacement, labelFont, loadVBCache, lowColor, lowLabel, lowLineStyle, lowLineWidth, mCAnchorPositionLabelFollowsValue, mCBeginEndByManualRect, mCRectangleTagPrefix, mcVAColor, mcVAHLabel, mcVALineStyle, mcVALineWidth, mcVALLabel, mcVAPercent, microCHVNColor, microCHVNLineStyle, microCHVNLineWidth, microCLVNColor, microCLVNLineStyle, microCLVNLineWidth, microCompositeAnchorBar, microCompositeAnchorEdge, microCompositeAnchorEdgeToolLabel, microCompositeAnchorOffset, microCompositeAnchorOffsetToolLabel, microCompositeAnchorPosition, microCompositeAnchorPositionToolLabel, microCompositeBeginDate, microCompositeDateRangeToolLabel, microCompositeEndDate, microCompositeFillColor, microCompositeOpacity, microCompositeOpacityToolLabel, microCompositeOutlineColor, microCompositeScale, microCompositeScaleToolLabel, microCompositeSelectToolLabel, microCompositeSmoothingFactorToolLabel, microCompositeVNToolLabel, microCompSmoothingFactor, microCompSquareOutline, microCVPOCColor, microCVPOCLabel, microCVPOCLineStyle, microCVPOCLineWidth, microValueNodeStrength, midPtColor, midPtLabel, midPtLineStyle, midPtLineWidth, minVAPCacheFileDate, minVBCacheFileDate, multiplierStdDev1, multiplierStdDev2, multiplierStdDev3, nHighColor, nHighLabel, nHLAlertEnabled, nHLAlertSoundFile, nHLAppendDate, nHLAppendPrice, nHLFont, nHLLineStyle, nHLLineWidth, nIBAlertEnabled, nIBAlertSoundFile, nIBAppendDate, nIBAppendPrice, nIBColor, nIBFont, nIBHLabel, nIBLineStyle, nIBLineWidth, nIBLLabel, nLowColor, nLowLabel, nVAAlertEnabled, nVAAlertSoundFile, nVAAppendDate, nVAAppendPrice, nVAColor, nVAFont, nVAHLabel, nVALineStyle, nVALineWidth, nVALLabel, nVPOCAlertEnabled, nVPOCAlertSoundFile, nVPOCAppendDate, nVPOCAppendPrice, nVPOCColor, nVPOCFont, nVPOCLabel, nVPOCLineStyle, nVPOCLineWidth, opacitySD1, opacitySD2, opacitySD3, openColor, openLabel, openLineStyle, openLineWidth, openSwingMaxMinutes, operationalMode, oSColor, oSHLabel, oSLineStyle, oSLineWidth, oSLLabel, overnightDefaultColor, overnightDisplayPeriodHL, overnightDisplayPeriodVPOC, overnightFont, overnightHighColor, overnightHighLabel, overnightHighLineStyle, overnightHighLineWidth, overnightLowColor, overnightLowLabel, overnightLowLineStyle, overnightLowLineWidth, overnightStatsSessionName, overnightVPOCColor, overnightVPOCLabel, overnightVPOCLineStyle, overnightVPOCLineWidth, plotCD, rebuildVAPCache, rebuildVBCache, refreshCompositeCacheFile, resetCDatBar, rolloverOffset, rolloverToContractMonth, rolloverVAPCache, rootFolder, runLogFileDir, runLogFilename, saveVBData, sessionAnchorOffset, sessionAnchorOffsetToolLabel, sessionAnchorPosition, sessionAnchorPositionToolLabel, sessionCDvapHeading, sessionFillColor, sessionOpacity, sessionOpacityToolLabel, sessionOutlineColor, sessionScale, sessionScaleToolLabel, sessionSquareOutline, sessionVolumeFont, showBigPrints, showBPHLine, showBPVLine, showCDAtEachPrice, showCompositeBeginDate, showCompositeProfile, showCompositeVolumes, showCompValueNodePrice, showCompValueNodes, showGaps, showIB, showIB15x, showIB2x, showIBRange, showLabels, showMCVA, showMicroCompositeDates, showMicroCompositeProfile, showMicroCompositeVolumes, showMicroCompValueNodePrice, showMicroCompValueNodes, showNHLs, showNIBs, showNVAs, showNVPOCs, showOHMLC, showOS, showOvernightStats, showPriceWithLabel, showSessionImbalanceFactor, showSessionProfile, showSessionRange, showSessionVolumes, showStartupMessages, showToolBar, showTrendChange, showVA, showVARange, showVPOC, showVPOCTrack, slowPeriod, standardCDHeading, staticMCEnabled, threshold, toolBarHideDropDownLabel, toolBarTextColor, toolBarTextFont, toolBarTextFontOnFocus, trendCDvapHeading, trendChangeDownColor, trendChangeUpColor, updateInRealtimeEnabled, vAColor, vAHLabel, vALineStyle, vALineWidth, vALLabel, vAOpacity, vAPercent, vPOCColor, vPOCLabel, vPOCLineStyle, vPOCLineWidth, vWAPColor, vWAPLabel, vWAPLineStyle, vWAPLineWidth, vWAPSD1Color, vWAPSD1LineStyle, vWAPSD1LineWidth, vWAPSD2Color, vWAPSD2LineStyle, vWAPSD2LineWidth, vWAPSD3Color, vWAPSD3LineStyle, vWAPSD3LineWidth);
        }

        /// <summary>
        /// Plots histograms of volume-at-price on price bars panel.
        /// </summary>
        /// <returns></returns>
        public CDA_VolumeProfile CDA_VolumeProfile(Data.IDataSeries input, Color aboveAskColor, Color atAskColor, Color atBidColor, bool autoSaveMicroCompositeSettings, bool autoUpdateMCEndDate, Color belowBidColor, string bigPrintsFileDir, bool bPAlertEnabled, string bPAlertSoundFile, int bPDisplayCount, CDA_VolumeProfile_BigPrintDisplayMode bPDisplayMode, CDA_VolumeProfile_BigPrintDisplayPosition bPDisplayPosition, CDA_VolumeProfile_BigPrintFilterMode bPFilterMode, DashStyle bPHLineStyle, int bPHLineWidth, string bPLabel, Color bPLabelColor, Font bPLabelFont, int bPLabelOffset, int bPMinVolume, int bPMulipleAboveMultipleOfAverageVolume, DashStyle bPVLineStyle, int bPVLineWidth, CDA_VolumeProfile_CDCalculationModeType calcMode, string cD0Label, Color cD0LineColor, DashStyle cD0LineStyle, int cD0LineWidth, Color cDDownColor, Color cDHeadingsColor, Font cDHeadingsFont, string cDHighLabel, Color cDHighLineColor, DashStyle cDHighLineStyle, int cDHighLineWidth, DashStyle cDLineStyle, int cDLineWidth, CDA_VolumeProfile_CDLocation cDLocation, string cDLowLabel, Color cDLowLineColor, DashStyle cDLowLineStyle, int cDLowLineWidth, Color cDNeutralColor, string cDPlotLabel, Color cDUpColor, Font cDValueFont, Color cHVNBandColor, int cHVNBandOpacity, string cHVNBandOpacityToolLabel, int cHVNBandWidth, Color cHVNLineColor, DashStyle cHVNLineStyle, int cHVNLineWidth, Color closeColor, string closeLabel, DashStyle closeLineStyle, int closeLineWidth, Color cLVNBandColor, int cLVNBandOpacity, string cLVNBandOpacityToolLabel, int cLVNBandWidth, Color cLVNLineColor, DashStyle cLVNLineStyle, int cLVNLineWidth, int compositeAnchorOffset, string compositeAnchorOffsetToolLabel, CDA_VolumeProfile_CAnchorPosition compositeAnchorPosition, string compositeAnchorPositionToolLabel, DateTime compositeBeginDate, string compositeBeginDateToolLabel, Color compositeFillColor, int compositeOpacity, string compositeOpacityToolLabel, Color compositeOutlineColor, double compositeScale, string compositeScaleToolLabel, double compositeSmoothingFactor, string compositeSmoothingFactorToolLabel, bool compositeSquareOutline, string compositeVNToolLabel, int compValueNodeStrength, CDA_VolumeProfile_AnchorPositionCurrentSession currentSessionAnchorPosition, Color cVPOCColor, string cVPOCLabel, DashStyle cVPOCLineStyle, int cVPOCLineWidth, string dataFileDir, bool displayComputedAtBar, bool displayComputedAtPrice, bool displaySD1, bool displaySD2, bool displaySD3, bool displayVABand, bool drawCD0, bool drawCDHighLow, string emailAddress, string emailToAddress, bool enableCD, bool enableCHVNOpacityTool, bool enableCLVNOpacityTool, bool enableCompositeAnchorOffsetTool, bool enableCompositeAnchorPositionTool, bool enableCompositeBeginDateTool, CDA_VolumeProfile_Heatmap enableCompositeHeatmap, bool enableCompositeOpacityTool, bool enableCompositeScaleTool, bool enableCompositeSmoothingFactorTool, bool enableCompositeVNTool, bool enableHideBlockTradesButton, bool enableHideCDsButton, bool enableHideCompositeProfileButton, bool enableHideCompositeProfileValueNodesButton, bool enableHideMicroCompositeProfilesButton, bool enableHideMicroCompositeProfileValueAreasButton, bool enableHideMicroCompositeProfileValueNodesButton, bool enableHideOvernightStatsButton, bool enableHideSessionProfilesButton, bool enableMicroCompositeAnchorEdgeTool, bool enableMicroCompositeAnchorOffsetTool, bool enableMicroCompositeAnchorPositionTool, bool enableMicroCompositeDateRangeTool, CDA_VolumeProfile_Heatmap enableMicroCompositeHeatmap, bool enableMicroCompositeOpacityTool, bool enableMicroCompositeScaleTool, bool enableMicroCompositeSmoothingFactorTool, bool enableMicroCompositeVNTool, bool enablePrecisionRangeProfiling, bool enableRunLog, bool enableSessionAnchorOffsetTool, bool enableSessionAnchorPositionTool, CDA_VolumeProfile_Heatmap enableSessionHeatmap, bool enableSessionOpacityTool, bool enableSessionScaleTool, bool enableVWAP, string exportFileDir, CDA_VolumeProfile_RebuildCache exportStats, int fastPeriod, bool gAPAlertEnabled, string gAPAlertSoundFile, bool gAPAppendDate, bool gAPAppendPrice, Color gAPColor, Font gAPFont, string gAPLabel, DashStyle gAPLineStyle, int gAPLineWidth, Color highColor, string highLabel, bool highlightIB, bool highlightMCVA, bool highlightVA, DashStyle highLineStyle, int highLineWidth, Color iB15xColor, DashStyle iB15xLineStyle, int iB15xLineWidth, Color iB2xColor, DashStyle iB2xLineStyle, int iB2xLineWidth, Color iBColor, string iBH15xLabel, string iBH2xLabel, string iBHLabel, string iBL15xLabel, string iBL2xLabel, DashStyle iBLineStyle, int iBLineWidth, string iBLLabel, int iBMinutes, Color insideColor, int labelDelay, int labelDisplacement, Font labelFont, bool loadVBCache, Color lowColor, string lowLabel, DashStyle lowLineStyle, int lowLineWidth, bool mCAnchorPositionLabelFollowsValue, bool mCBeginEndByManualRect, string mCRectangleTagPrefix, Color mcVAColor, string mcVAHLabel, DashStyle mcVALineStyle, int mcVALineWidth, string mcVALLabel, double mcVAPercent, Color microCHVNColor, DashStyle microCHVNLineStyle, int microCHVNLineWidth, Color microCLVNColor, DashStyle microCLVNLineStyle, int microCLVNLineWidth, CDA_VolumeProfile_AnchorPosition microCompositeAnchorBar, CDA_VolumeProfile_AnchorEdge microCompositeAnchorEdge, string microCompositeAnchorEdgeToolLabel, int microCompositeAnchorOffset, string microCompositeAnchorOffsetToolLabel, CDA_VolumeProfile_MCAnchorPosition microCompositeAnchorPosition, string microCompositeAnchorPositionToolLabel, DateTime microCompositeBeginDate, string microCompositeDateRangeToolLabel, DateTime microCompositeEndDate, Color microCompositeFillColor, int microCompositeOpacity, string microCompositeOpacityToolLabel, Color microCompositeOutlineColor, double microCompositeScale, string microCompositeScaleToolLabel, string microCompositeSelectToolLabel, string microCompositeSmoothingFactorToolLabel, string microCompositeVNToolLabel, double microCompSmoothingFactor, bool microCompSquareOutline, Color microCVPOCColor, string microCVPOCLabel, DashStyle microCVPOCLineStyle, int microCVPOCLineWidth, int microValueNodeStrength, Color midPtColor, string midPtLabel, DashStyle midPtLineStyle, int midPtLineWidth, DateTime minVAPCacheFileDate, DateTime minVBCacheFileDate, double multiplierStdDev1, double multiplierStdDev2, double multiplierStdDev3, Color nHighColor, string nHighLabel, bool nHLAlertEnabled, string nHLAlertSoundFile, bool nHLAppendDate, bool nHLAppendPrice, Font nHLFont, DashStyle nHLLineStyle, int nHLLineWidth, bool nIBAlertEnabled, string nIBAlertSoundFile, bool nIBAppendDate, bool nIBAppendPrice, Color nIBColor, Font nIBFont, string nIBHLabel, DashStyle nIBLineStyle, int nIBLineWidth, string nIBLLabel, Color nLowColor, string nLowLabel, bool nVAAlertEnabled, string nVAAlertSoundFile, bool nVAAppendDate, bool nVAAppendPrice, Color nVAColor, Font nVAFont, string nVAHLabel, DashStyle nVALineStyle, int nVALineWidth, string nVALLabel, bool nVPOCAlertEnabled, string nVPOCAlertSoundFile, bool nVPOCAppendDate, bool nVPOCAppendPrice, Color nVPOCColor, Font nVPOCFont, string nVPOCLabel, DashStyle nVPOCLineStyle, int nVPOCLineWidth, int opacitySD1, int opacitySD2, int opacitySD3, Color openColor, string openLabel, DashStyle openLineStyle, int openLineWidth, int openSwingMaxMinutes, CDA_VolumeProfile_OperationalMode operationalMode, Color oSColor, string oSHLabel, DashStyle oSLineStyle, int oSLineWidth, string oSLLabel, Color overnightDefaultColor, int overnightDisplayPeriodHL, int overnightDisplayPeriodVPOC, Font overnightFont, Color overnightHighColor, string overnightHighLabel, DashStyle overnightHighLineStyle, int overnightHighLineWidth, Color overnightLowColor, string overnightLowLabel, DashStyle overnightLowLineStyle, int overnightLowLineWidth, string overnightStatsSessionName, Color overnightVPOCColor, string overnightVPOCLabel, DashStyle overnightVPOCLineStyle, int overnightVPOCLineWidth, bool plotCD, CDA_VolumeProfile_RebuildCache rebuildVAPCache, CDA_VolumeProfile_RebuildCache rebuildVBCache, CDA_VolumeProfile_RefreshWhen refreshCompositeCacheFile, CDA_VolumeProfile_CDReset resetCDatBar, double rolloverOffset, string rolloverToContractMonth, bool rolloverVAPCache, string rootFolder, string runLogFileDir, string runLogFilename, bool saveVBData, int sessionAnchorOffset, string sessionAnchorOffsetToolLabel, CDA_VolumeProfile_AnchorPosition sessionAnchorPosition, string sessionAnchorPositionToolLabel, string sessionCDvapHeading, Color sessionFillColor, int sessionOpacity, string sessionOpacityToolLabel, Color sessionOutlineColor, double sessionScale, string sessionScaleToolLabel, bool sessionSquareOutline, Font sessionVolumeFont, bool showBigPrints, bool showBPHLine, bool showBPVLine, bool showCDAtEachPrice, bool showCompositeBeginDate, bool showCompositeProfile, bool showCompositeVolumes, bool showCompValueNodePrice, CDA_VolumeProfile_VNMode showCompValueNodes, bool showGaps, CDA_VolumeProfile_ShowInSessions showIB, bool showIB15x, bool showIB2x, bool showIBRange, CDA_VolumeProfile_ShowInSessions showLabels, bool showMCVA, CDA_VolumeProfile_MCDatesPosition showMicroCompositeDates, bool showMicroCompositeProfile, bool showMicroCompositeVolumes, bool showMicroCompValueNodePrice, bool showMicroCompValueNodes, bool showNHLs, bool showNIBs, bool showNVAs, bool showNVPOCs, CDA_VolumeProfile_ShowInSessions showOHMLC, CDA_VolumeProfile_ShowInSessions showOS, bool showOvernightStats, bool showPriceWithLabel, bool showSessionImbalanceFactor, CDA_VolumeProfile_ShowInSessions showSessionProfile, bool showSessionRange, bool showSessionVolumes, bool showStartupMessages, bool showToolBar, bool showTrendChange, CDA_VolumeProfile_ShowInSessions showVA, bool showVARange, bool showVPOC, bool showVPOCTrack, int slowPeriod, string standardCDHeading, bool staticMCEnabled, int threshold, string toolBarHideDropDownLabel, Color toolBarTextColor, Font toolBarTextFont, Font toolBarTextFontOnFocus, string trendCDvapHeading, Color trendChangeDownColor, Color trendChangeUpColor, bool updateInRealtimeEnabled, Color vAColor, string vAHLabel, DashStyle vALineStyle, int vALineWidth, string vALLabel, int vAOpacity, double vAPercent, Color vPOCColor, string vPOCLabel, DashStyle vPOCLineStyle, int vPOCLineWidth, Color vWAPColor, string vWAPLabel, DashStyle vWAPLineStyle, int vWAPLineWidth, Color vWAPSD1Color, DashStyle vWAPSD1LineStyle, int vWAPSD1LineWidth, Color vWAPSD2Color, DashStyle vWAPSD2LineStyle, int vWAPSD2LineWidth, Color vWAPSD3Color, DashStyle vWAPSD3LineStyle, int vWAPSD3LineWidth)
        {
            if (cacheCDA_VolumeProfile != null)
                for (int idx = 0; idx < cacheCDA_VolumeProfile.Length; idx++)
                    if (cacheCDA_VolumeProfile[idx].AboveAskColor == aboveAskColor && cacheCDA_VolumeProfile[idx].AtAskColor == atAskColor && cacheCDA_VolumeProfile[idx].AtBidColor == atBidColor && cacheCDA_VolumeProfile[idx].AutoSaveMicroCompositeSettings == autoSaveMicroCompositeSettings && cacheCDA_VolumeProfile[idx].AutoUpdateMCEndDate == autoUpdateMCEndDate && cacheCDA_VolumeProfile[idx].BelowBidColor == belowBidColor && cacheCDA_VolumeProfile[idx].BigPrintsFileDir == bigPrintsFileDir && cacheCDA_VolumeProfile[idx].BPAlertEnabled == bPAlertEnabled && cacheCDA_VolumeProfile[idx].BPAlertSoundFile == bPAlertSoundFile && cacheCDA_VolumeProfile[idx].BPDisplayCount == bPDisplayCount && cacheCDA_VolumeProfile[idx].BPDisplayMode == bPDisplayMode && cacheCDA_VolumeProfile[idx].BPDisplayPosition == bPDisplayPosition && cacheCDA_VolumeProfile[idx].BPFilterMode == bPFilterMode && cacheCDA_VolumeProfile[idx].BPHLineStyle == bPHLineStyle && cacheCDA_VolumeProfile[idx].BPHLineWidth == bPHLineWidth && cacheCDA_VolumeProfile[idx].BPLabel == bPLabel && cacheCDA_VolumeProfile[idx].BPLabelColor == bPLabelColor && cacheCDA_VolumeProfile[idx].BPLabelFont == bPLabelFont && cacheCDA_VolumeProfile[idx].BPLabelOffset == bPLabelOffset && cacheCDA_VolumeProfile[idx].BPMinVolume == bPMinVolume && cacheCDA_VolumeProfile[idx].BPMulipleAboveMultipleOfAverageVolume == bPMulipleAboveMultipleOfAverageVolume && cacheCDA_VolumeProfile[idx].BPVLineStyle == bPVLineStyle && cacheCDA_VolumeProfile[idx].BPVLineWidth == bPVLineWidth && cacheCDA_VolumeProfile[idx].CalcMode == calcMode && cacheCDA_VolumeProfile[idx].CD0Label == cD0Label && cacheCDA_VolumeProfile[idx].CD0LineColor == cD0LineColor && cacheCDA_VolumeProfile[idx].CD0LineStyle == cD0LineStyle && cacheCDA_VolumeProfile[idx].CD0LineWidth == cD0LineWidth && cacheCDA_VolumeProfile[idx].CDDownColor == cDDownColor && cacheCDA_VolumeProfile[idx].CDHeadingsColor == cDHeadingsColor && cacheCDA_VolumeProfile[idx].CDHeadingsFont == cDHeadingsFont && cacheCDA_VolumeProfile[idx].CDHighLabel == cDHighLabel && cacheCDA_VolumeProfile[idx].CDHighLineColor == cDHighLineColor && cacheCDA_VolumeProfile[idx].CDHighLineStyle == cDHighLineStyle && cacheCDA_VolumeProfile[idx].CDHighLineWidth == cDHighLineWidth && cacheCDA_VolumeProfile[idx].CDLineStyle == cDLineStyle && cacheCDA_VolumeProfile[idx].CDLineWidth == cDLineWidth && cacheCDA_VolumeProfile[idx].CDLocation == cDLocation && cacheCDA_VolumeProfile[idx].CDLowLabel == cDLowLabel && cacheCDA_VolumeProfile[idx].CDLowLineColor == cDLowLineColor && cacheCDA_VolumeProfile[idx].CDLowLineStyle == cDLowLineStyle && cacheCDA_VolumeProfile[idx].CDLowLineWidth == cDLowLineWidth && cacheCDA_VolumeProfile[idx].CDNeutralColor == cDNeutralColor && cacheCDA_VolumeProfile[idx].CDPlotLabel == cDPlotLabel && cacheCDA_VolumeProfile[idx].CDUpColor == cDUpColor && cacheCDA_VolumeProfile[idx].CDValueFont == cDValueFont && cacheCDA_VolumeProfile[idx].CHVNBandColor == cHVNBandColor && cacheCDA_VolumeProfile[idx].CHVNBandOpacity == cHVNBandOpacity && cacheCDA_VolumeProfile[idx].CHVNBandOpacityToolLabel == cHVNBandOpacityToolLabel && cacheCDA_VolumeProfile[idx].CHVNBandWidth == cHVNBandWidth && cacheCDA_VolumeProfile[idx].CHVNLineColor == cHVNLineColor && cacheCDA_VolumeProfile[idx].CHVNLineStyle == cHVNLineStyle && cacheCDA_VolumeProfile[idx].CHVNLineWidth == cHVNLineWidth && cacheCDA_VolumeProfile[idx].CloseColor == closeColor && cacheCDA_VolumeProfile[idx].CloseLabel == closeLabel && cacheCDA_VolumeProfile[idx].CloseLineStyle == closeLineStyle && cacheCDA_VolumeProfile[idx].CloseLineWidth == closeLineWidth && cacheCDA_VolumeProfile[idx].CLVNBandColor == cLVNBandColor && cacheCDA_VolumeProfile[idx].CLVNBandOpacity == cLVNBandOpacity && cacheCDA_VolumeProfile[idx].CLVNBandOpacityToolLabel == cLVNBandOpacityToolLabel && cacheCDA_VolumeProfile[idx].CLVNBandWidth == cLVNBandWidth && cacheCDA_VolumeProfile[idx].CLVNLineColor == cLVNLineColor && cacheCDA_VolumeProfile[idx].CLVNLineStyle == cLVNLineStyle && cacheCDA_VolumeProfile[idx].CLVNLineWidth == cLVNLineWidth && cacheCDA_VolumeProfile[idx].CompositeAnchorOffset == compositeAnchorOffset && cacheCDA_VolumeProfile[idx].CompositeAnchorOffsetToolLabel == compositeAnchorOffsetToolLabel && cacheCDA_VolumeProfile[idx].CompositeAnchorPosition == compositeAnchorPosition && cacheCDA_VolumeProfile[idx].CompositeAnchorPositionToolLabel == compositeAnchorPositionToolLabel && cacheCDA_VolumeProfile[idx].CompositeBeginDate == compositeBeginDate && cacheCDA_VolumeProfile[idx].CompositeBeginDateToolLabel == compositeBeginDateToolLabel && cacheCDA_VolumeProfile[idx].CompositeFillColor == compositeFillColor && cacheCDA_VolumeProfile[idx].CompositeOpacity == compositeOpacity && cacheCDA_VolumeProfile[idx].CompositeOpacityToolLabel == compositeOpacityToolLabel && cacheCDA_VolumeProfile[idx].CompositeOutlineColor == compositeOutlineColor && Math.Abs(cacheCDA_VolumeProfile[idx].CompositeScale - compositeScale) <= double.Epsilon && cacheCDA_VolumeProfile[idx].CompositeScaleToolLabel == compositeScaleToolLabel && Math.Abs(cacheCDA_VolumeProfile[idx].CompositeSmoothingFactor - compositeSmoothingFactor) <= double.Epsilon && cacheCDA_VolumeProfile[idx].CompositeSmoothingFactorToolLabel == compositeSmoothingFactorToolLabel && cacheCDA_VolumeProfile[idx].CompositeSquareOutline == compositeSquareOutline && cacheCDA_VolumeProfile[idx].CompositeVNToolLabel == compositeVNToolLabel && cacheCDA_VolumeProfile[idx].CompValueNodeStrength == compValueNodeStrength && cacheCDA_VolumeProfile[idx].CurrentSessionAnchorPosition == currentSessionAnchorPosition && cacheCDA_VolumeProfile[idx].CVPOCColor == cVPOCColor && cacheCDA_VolumeProfile[idx].CVPOCLabel == cVPOCLabel && cacheCDA_VolumeProfile[idx].CVPOCLineStyle == cVPOCLineStyle && cacheCDA_VolumeProfile[idx].CVPOCLineWidth == cVPOCLineWidth && cacheCDA_VolumeProfile[idx].DataFileDir == dataFileDir && cacheCDA_VolumeProfile[idx].DisplayComputedAtBar == displayComputedAtBar && cacheCDA_VolumeProfile[idx].DisplayComputedAtPrice == displayComputedAtPrice && cacheCDA_VolumeProfile[idx].DisplaySD1 == displaySD1 && cacheCDA_VolumeProfile[idx].DisplaySD2 == displaySD2 && cacheCDA_VolumeProfile[idx].DisplaySD3 == displaySD3 && cacheCDA_VolumeProfile[idx].DisplayVABand == displayVABand && cacheCDA_VolumeProfile[idx].DrawCD0 == drawCD0 && cacheCDA_VolumeProfile[idx].DrawCDHighLow == drawCDHighLow && cacheCDA_VolumeProfile[idx].EmailAddress == emailAddress && cacheCDA_VolumeProfile[idx].EmailToAddress == emailToAddress && cacheCDA_VolumeProfile[idx].EnableCD == enableCD && cacheCDA_VolumeProfile[idx].EnableCHVNOpacityTool == enableCHVNOpacityTool && cacheCDA_VolumeProfile[idx].EnableCLVNOpacityTool == enableCLVNOpacityTool && cacheCDA_VolumeProfile[idx].EnableCompositeAnchorOffsetTool == enableCompositeAnchorOffsetTool && cacheCDA_VolumeProfile[idx].EnableCompositeAnchorPositionTool == enableCompositeAnchorPositionTool && cacheCDA_VolumeProfile[idx].EnableCompositeBeginDateTool == enableCompositeBeginDateTool && cacheCDA_VolumeProfile[idx].EnableCompositeHeatmap == enableCompositeHeatmap && cacheCDA_VolumeProfile[idx].EnableCompositeOpacityTool == enableCompositeOpacityTool && cacheCDA_VolumeProfile[idx].EnableCompositeScaleTool == enableCompositeScaleTool && cacheCDA_VolumeProfile[idx].EnableCompositeSmoothingFactorTool == enableCompositeSmoothingFactorTool && cacheCDA_VolumeProfile[idx].EnableCompositeVNTool == enableCompositeVNTool && cacheCDA_VolumeProfile[idx].EnableHideBlockTradesButton == enableHideBlockTradesButton && cacheCDA_VolumeProfile[idx].EnableHideCDsButton == enableHideCDsButton && cacheCDA_VolumeProfile[idx].EnableHideCompositeProfileButton == enableHideCompositeProfileButton && cacheCDA_VolumeProfile[idx].EnableHideCompositeProfileValueNodesButton == enableHideCompositeProfileValueNodesButton && cacheCDA_VolumeProfile[idx].EnableHideMicroCompositeProfilesButton == enableHideMicroCompositeProfilesButton && cacheCDA_VolumeProfile[idx].EnableHideMicroCompositeProfileValueAreasButton == enableHideMicroCompositeProfileValueAreasButton && cacheCDA_VolumeProfile[idx].EnableHideMicroCompositeProfileValueNodesButton == enableHideMicroCompositeProfileValueNodesButton && cacheCDA_VolumeProfile[idx].EnableHideOvernightStatsButton == enableHideOvernightStatsButton && cacheCDA_VolumeProfile[idx].EnableHideSessionProfilesButton == enableHideSessionProfilesButton && cacheCDA_VolumeProfile[idx].EnableMicroCompositeAnchorEdgeTool == enableMicroCompositeAnchorEdgeTool && cacheCDA_VolumeProfile[idx].EnableMicroCompositeAnchorOffsetTool == enableMicroCompositeAnchorOffsetTool && cacheCDA_VolumeProfile[idx].EnableMicroCompositeAnchorPositionTool == enableMicroCompositeAnchorPositionTool && cacheCDA_VolumeProfile[idx].EnableMicroCompositeDateRangeTool == enableMicroCompositeDateRangeTool && cacheCDA_VolumeProfile[idx].EnableMicroCompositeHeatmap == enableMicroCompositeHeatmap && cacheCDA_VolumeProfile[idx].EnableMicroCompositeOpacityTool == enableMicroCompositeOpacityTool && cacheCDA_VolumeProfile[idx].EnableMicroCompositeScaleTool == enableMicroCompositeScaleTool && cacheCDA_VolumeProfile[idx].EnableMicroCompositeSmoothingFactorTool == enableMicroCompositeSmoothingFactorTool && cacheCDA_VolumeProfile[idx].EnableMicroCompositeVNTool == enableMicroCompositeVNTool && cacheCDA_VolumeProfile[idx].EnablePrecisionRangeProfiling == enablePrecisionRangeProfiling && cacheCDA_VolumeProfile[idx].EnableRunLog == enableRunLog && cacheCDA_VolumeProfile[idx].EnableSessionAnchorOffsetTool == enableSessionAnchorOffsetTool && cacheCDA_VolumeProfile[idx].EnableSessionAnchorPositionTool == enableSessionAnchorPositionTool && cacheCDA_VolumeProfile[idx].EnableSessionHeatmap == enableSessionHeatmap && cacheCDA_VolumeProfile[idx].EnableSessionOpacityTool == enableSessionOpacityTool && cacheCDA_VolumeProfile[idx].EnableSessionScaleTool == enableSessionScaleTool && cacheCDA_VolumeProfile[idx].EnableVWAP == enableVWAP && cacheCDA_VolumeProfile[idx].ExportFileDir == exportFileDir && cacheCDA_VolumeProfile[idx].ExportStats == exportStats && cacheCDA_VolumeProfile[idx].FastPeriod == fastPeriod && cacheCDA_VolumeProfile[idx].GAPAlertEnabled == gAPAlertEnabled && cacheCDA_VolumeProfile[idx].GAPAlertSoundFile == gAPAlertSoundFile && cacheCDA_VolumeProfile[idx].GAPAppendDate == gAPAppendDate && cacheCDA_VolumeProfile[idx].GAPAppendPrice == gAPAppendPrice && cacheCDA_VolumeProfile[idx].GAPColor == gAPColor && cacheCDA_VolumeProfile[idx].GAPFont == gAPFont && cacheCDA_VolumeProfile[idx].GAPLabel == gAPLabel && cacheCDA_VolumeProfile[idx].GAPLineStyle == gAPLineStyle && cacheCDA_VolumeProfile[idx].GAPLineWidth == gAPLineWidth && cacheCDA_VolumeProfile[idx].HighColor == highColor && cacheCDA_VolumeProfile[idx].HighLabel == highLabel && cacheCDA_VolumeProfile[idx].HighlightIB == highlightIB && cacheCDA_VolumeProfile[idx].HighlightMCVA == highlightMCVA && cacheCDA_VolumeProfile[idx].HighlightVA == highlightVA && cacheCDA_VolumeProfile[idx].HighLineStyle == highLineStyle && cacheCDA_VolumeProfile[idx].HighLineWidth == highLineWidth && cacheCDA_VolumeProfile[idx].IB15xColor == iB15xColor && cacheCDA_VolumeProfile[idx].IB15xLineStyle == iB15xLineStyle && cacheCDA_VolumeProfile[idx].IB15xLineWidth == iB15xLineWidth && cacheCDA_VolumeProfile[idx].IB2xColor == iB2xColor && cacheCDA_VolumeProfile[idx].IB2xLineStyle == iB2xLineStyle && cacheCDA_VolumeProfile[idx].IB2xLineWidth == iB2xLineWidth && cacheCDA_VolumeProfile[idx].IBColor == iBColor && cacheCDA_VolumeProfile[idx].IBH15xLabel == iBH15xLabel && cacheCDA_VolumeProfile[idx].IBH2xLabel == iBH2xLabel && cacheCDA_VolumeProfile[idx].IBHLabel == iBHLabel && cacheCDA_VolumeProfile[idx].IBL15xLabel == iBL15xLabel && cacheCDA_VolumeProfile[idx].IBL2xLabel == iBL2xLabel && cacheCDA_VolumeProfile[idx].IBLineStyle == iBLineStyle && cacheCDA_VolumeProfile[idx].IBLineWidth == iBLineWidth && cacheCDA_VolumeProfile[idx].IBLLabel == iBLLabel && cacheCDA_VolumeProfile[idx].IBMinutes == iBMinutes && cacheCDA_VolumeProfile[idx].InsideColor == insideColor && cacheCDA_VolumeProfile[idx].LabelDelay == labelDelay && cacheCDA_VolumeProfile[idx].LabelDisplacement == labelDisplacement && cacheCDA_VolumeProfile[idx].LabelFont == labelFont && cacheCDA_VolumeProfile[idx].LoadVBCache == loadVBCache && cacheCDA_VolumeProfile[idx].LowColor == lowColor && cacheCDA_VolumeProfile[idx].LowLabel == lowLabel && cacheCDA_VolumeProfile[idx].LowLineStyle == lowLineStyle && cacheCDA_VolumeProfile[idx].LowLineWidth == lowLineWidth && cacheCDA_VolumeProfile[idx].MCAnchorPositionLabelFollowsValue == mCAnchorPositionLabelFollowsValue && cacheCDA_VolumeProfile[idx].MCBeginEndByManualRect == mCBeginEndByManualRect && cacheCDA_VolumeProfile[idx].MCRectangleTagPrefix == mCRectangleTagPrefix && cacheCDA_VolumeProfile[idx].mcVAColor == mcVAColor && cacheCDA_VolumeProfile[idx].mcVAHLabel == mcVAHLabel && cacheCDA_VolumeProfile[idx].mcVALineStyle == mcVALineStyle && cacheCDA_VolumeProfile[idx].mcVALineWidth == mcVALineWidth && cacheCDA_VolumeProfile[idx].mcVALLabel == mcVALLabel && Math.Abs(cacheCDA_VolumeProfile[idx].mcVAPercent - mcVAPercent) <= double.Epsilon && cacheCDA_VolumeProfile[idx].MicroCHVNColor == microCHVNColor && cacheCDA_VolumeProfile[idx].MicroCHVNLineStyle == microCHVNLineStyle && cacheCDA_VolumeProfile[idx].MicroCHVNLineWidth == microCHVNLineWidth && cacheCDA_VolumeProfile[idx].MicroCLVNColor == microCLVNColor && cacheCDA_VolumeProfile[idx].MicroCLVNLineStyle == microCLVNLineStyle && cacheCDA_VolumeProfile[idx].MicroCLVNLineWidth == microCLVNLineWidth && cacheCDA_VolumeProfile[idx].MicroCompositeAnchorBar == microCompositeAnchorBar && cacheCDA_VolumeProfile[idx].MicroCompositeAnchorEdge == microCompositeAnchorEdge && cacheCDA_VolumeProfile[idx].MicroCompositeAnchorEdgeToolLabel == microCompositeAnchorEdgeToolLabel && cacheCDA_VolumeProfile[idx].MicroCompositeAnchorOffset == microCompositeAnchorOffset && cacheCDA_VolumeProfile[idx].MicroCompositeAnchorOffsetToolLabel == microCompositeAnchorOffsetToolLabel && cacheCDA_VolumeProfile[idx].MicroCompositeAnchorPosition == microCompositeAnchorPosition && cacheCDA_VolumeProfile[idx].MicroCompositeAnchorPositionToolLabel == microCompositeAnchorPositionToolLabel && cacheCDA_VolumeProfile[idx].MicroCompositeBeginDate == microCompositeBeginDate && cacheCDA_VolumeProfile[idx].MicroCompositeDateRangeToolLabel == microCompositeDateRangeToolLabel && cacheCDA_VolumeProfile[idx].MicroCompositeEndDate == microCompositeEndDate && cacheCDA_VolumeProfile[idx].MicroCompositeFillColor == microCompositeFillColor && cacheCDA_VolumeProfile[idx].MicroCompositeOpacity == microCompositeOpacity && cacheCDA_VolumeProfile[idx].MicroCompositeOpacityToolLabel == microCompositeOpacityToolLabel && cacheCDA_VolumeProfile[idx].MicroCompositeOutlineColor == microCompositeOutlineColor && Math.Abs(cacheCDA_VolumeProfile[idx].MicroCompositeScale - microCompositeScale) <= double.Epsilon && cacheCDA_VolumeProfile[idx].MicroCompositeScaleToolLabel == microCompositeScaleToolLabel && cacheCDA_VolumeProfile[idx].MicroCompositeSelectToolLabel == microCompositeSelectToolLabel && cacheCDA_VolumeProfile[idx].MicroCompositeSmoothingFactorToolLabel == microCompositeSmoothingFactorToolLabel && cacheCDA_VolumeProfile[idx].MicroCompositeVNToolLabel == microCompositeVNToolLabel && Math.Abs(cacheCDA_VolumeProfile[idx].MicroCompSmoothingFactor - microCompSmoothingFactor) <= double.Epsilon && cacheCDA_VolumeProfile[idx].MicroCompSquareOutline == microCompSquareOutline && cacheCDA_VolumeProfile[idx].MicroCVPOCColor == microCVPOCColor && cacheCDA_VolumeProfile[idx].MicroCVPOCLabel == microCVPOCLabel && cacheCDA_VolumeProfile[idx].MicroCVPOCLineStyle == microCVPOCLineStyle && cacheCDA_VolumeProfile[idx].MicroCVPOCLineWidth == microCVPOCLineWidth && cacheCDA_VolumeProfile[idx].MicroValueNodeStrength == microValueNodeStrength && cacheCDA_VolumeProfile[idx].MidPtColor == midPtColor && cacheCDA_VolumeProfile[idx].MidPtLabel == midPtLabel && cacheCDA_VolumeProfile[idx].MidPtLineStyle == midPtLineStyle && cacheCDA_VolumeProfile[idx].MidPtLineWidth == midPtLineWidth && cacheCDA_VolumeProfile[idx].MinVAPCacheFileDate == minVAPCacheFileDate && cacheCDA_VolumeProfile[idx].MinVBCacheFileDate == minVBCacheFileDate && Math.Abs(cacheCDA_VolumeProfile[idx].MultiplierStdDev1 - multiplierStdDev1) <= double.Epsilon && Math.Abs(cacheCDA_VolumeProfile[idx].MultiplierStdDev2 - multiplierStdDev2) <= double.Epsilon && Math.Abs(cacheCDA_VolumeProfile[idx].MultiplierStdDev3 - multiplierStdDev3) <= double.Epsilon && cacheCDA_VolumeProfile[idx].NHighColor == nHighColor && cacheCDA_VolumeProfile[idx].NHighLabel == nHighLabel && cacheCDA_VolumeProfile[idx].NHLAlertEnabled == nHLAlertEnabled && cacheCDA_VolumeProfile[idx].NHLAlertSoundFile == nHLAlertSoundFile && cacheCDA_VolumeProfile[idx].NHLAppendDate == nHLAppendDate && cacheCDA_VolumeProfile[idx].NHLAppendPrice == nHLAppendPrice && cacheCDA_VolumeProfile[idx].NHLFont == nHLFont && cacheCDA_VolumeProfile[idx].NHLLineStyle == nHLLineStyle && cacheCDA_VolumeProfile[idx].NHLLineWidth == nHLLineWidth && cacheCDA_VolumeProfile[idx].NIBAlertEnabled == nIBAlertEnabled && cacheCDA_VolumeProfile[idx].NIBAlertSoundFile == nIBAlertSoundFile && cacheCDA_VolumeProfile[idx].NIBAppendDate == nIBAppendDate && cacheCDA_VolumeProfile[idx].NIBAppendPrice == nIBAppendPrice && cacheCDA_VolumeProfile[idx].NIBColor == nIBColor && cacheCDA_VolumeProfile[idx].NIBFont == nIBFont && cacheCDA_VolumeProfile[idx].NIBHLabel == nIBHLabel && cacheCDA_VolumeProfile[idx].NIBLineStyle == nIBLineStyle && cacheCDA_VolumeProfile[idx].NIBLineWidth == nIBLineWidth && cacheCDA_VolumeProfile[idx].NIBLLabel == nIBLLabel && cacheCDA_VolumeProfile[idx].NLowColor == nLowColor && cacheCDA_VolumeProfile[idx].NLowLabel == nLowLabel && cacheCDA_VolumeProfile[idx].NVAAlertEnabled == nVAAlertEnabled && cacheCDA_VolumeProfile[idx].NVAAlertSoundFile == nVAAlertSoundFile && cacheCDA_VolumeProfile[idx].NVAAppendDate == nVAAppendDate && cacheCDA_VolumeProfile[idx].NVAAppendPrice == nVAAppendPrice && cacheCDA_VolumeProfile[idx].NVAColor == nVAColor && cacheCDA_VolumeProfile[idx].NVAFont == nVAFont && cacheCDA_VolumeProfile[idx].NVAHLabel == nVAHLabel && cacheCDA_VolumeProfile[idx].NVALineStyle == nVALineStyle && cacheCDA_VolumeProfile[idx].NVALineWidth == nVALineWidth && cacheCDA_VolumeProfile[idx].NVALLabel == nVALLabel && cacheCDA_VolumeProfile[idx].NVPOCAlertEnabled == nVPOCAlertEnabled && cacheCDA_VolumeProfile[idx].NVPOCAlertSoundFile == nVPOCAlertSoundFile && cacheCDA_VolumeProfile[idx].NVPOCAppendDate == nVPOCAppendDate && cacheCDA_VolumeProfile[idx].NVPOCAppendPrice == nVPOCAppendPrice && cacheCDA_VolumeProfile[idx].NVPOCColor == nVPOCColor && cacheCDA_VolumeProfile[idx].NVPOCFont == nVPOCFont && cacheCDA_VolumeProfile[idx].NVPOCLabel == nVPOCLabel && cacheCDA_VolumeProfile[idx].NVPOCLineStyle == nVPOCLineStyle && cacheCDA_VolumeProfile[idx].NVPOCLineWidth == nVPOCLineWidth && cacheCDA_VolumeProfile[idx].OpacitySD1 == opacitySD1 && cacheCDA_VolumeProfile[idx].OpacitySD2 == opacitySD2 && cacheCDA_VolumeProfile[idx].OpacitySD3 == opacitySD3 && cacheCDA_VolumeProfile[idx].OpenColor == openColor && cacheCDA_VolumeProfile[idx].OpenLabel == openLabel && cacheCDA_VolumeProfile[idx].OpenLineStyle == openLineStyle && cacheCDA_VolumeProfile[idx].OpenLineWidth == openLineWidth && cacheCDA_VolumeProfile[idx].OpenSwingMaxMinutes == openSwingMaxMinutes && cacheCDA_VolumeProfile[idx].OperationalMode == operationalMode && cacheCDA_VolumeProfile[idx].OSColor == oSColor && cacheCDA_VolumeProfile[idx].OSHLabel == oSHLabel && cacheCDA_VolumeProfile[idx].OSLineStyle == oSLineStyle && cacheCDA_VolumeProfile[idx].OSLineWidth == oSLineWidth && cacheCDA_VolumeProfile[idx].OSLLabel == oSLLabel && cacheCDA_VolumeProfile[idx].OvernightDefaultColor == overnightDefaultColor && cacheCDA_VolumeProfile[idx].OvernightDisplayPeriodHL == overnightDisplayPeriodHL && cacheCDA_VolumeProfile[idx].OvernightDisplayPeriodVPOC == overnightDisplayPeriodVPOC && cacheCDA_VolumeProfile[idx].OvernightFont == overnightFont && cacheCDA_VolumeProfile[idx].OvernightHighColor == overnightHighColor && cacheCDA_VolumeProfile[idx].OvernightHighLabel == overnightHighLabel && cacheCDA_VolumeProfile[idx].OvernightHighLineStyle == overnightHighLineStyle && cacheCDA_VolumeProfile[idx].OvernightHighLineWidth == overnightHighLineWidth && cacheCDA_VolumeProfile[idx].OvernightLowColor == overnightLowColor && cacheCDA_VolumeProfile[idx].OvernightLowLabel == overnightLowLabel && cacheCDA_VolumeProfile[idx].OvernightLowLineStyle == overnightLowLineStyle && cacheCDA_VolumeProfile[idx].OvernightLowLineWidth == overnightLowLineWidth && cacheCDA_VolumeProfile[idx].OvernightStatsSessionName == overnightStatsSessionName && cacheCDA_VolumeProfile[idx].OvernightVPOCColor == overnightVPOCColor && cacheCDA_VolumeProfile[idx].OvernightVPOCLabel == overnightVPOCLabel && cacheCDA_VolumeProfile[idx].OvernightVPOCLineStyle == overnightVPOCLineStyle && cacheCDA_VolumeProfile[idx].OvernightVPOCLineWidth == overnightVPOCLineWidth && cacheCDA_VolumeProfile[idx].PlotCD == plotCD && cacheCDA_VolumeProfile[idx].RebuildVAPCache == rebuildVAPCache && cacheCDA_VolumeProfile[idx].RebuildVBCache == rebuildVBCache && cacheCDA_VolumeProfile[idx].RefreshCompositeCacheFile == refreshCompositeCacheFile && cacheCDA_VolumeProfile[idx].ResetCDatBar == resetCDatBar && Math.Abs(cacheCDA_VolumeProfile[idx].RolloverOffset - rolloverOffset) <= double.Epsilon && cacheCDA_VolumeProfile[idx].RolloverToContractMonth == rolloverToContractMonth && cacheCDA_VolumeProfile[idx].RolloverVAPCache == rolloverVAPCache && cacheCDA_VolumeProfile[idx].RootFolder == rootFolder && cacheCDA_VolumeProfile[idx].RunLogFileDir == runLogFileDir && cacheCDA_VolumeProfile[idx].RunLogFilename == runLogFilename && cacheCDA_VolumeProfile[idx].SaveVBData == saveVBData && cacheCDA_VolumeProfile[idx].SessionAnchorOffset == sessionAnchorOffset && cacheCDA_VolumeProfile[idx].SessionAnchorOffsetToolLabel == sessionAnchorOffsetToolLabel && cacheCDA_VolumeProfile[idx].SessionAnchorPosition == sessionAnchorPosition && cacheCDA_VolumeProfile[idx].SessionAnchorPositionToolLabel == sessionAnchorPositionToolLabel && cacheCDA_VolumeProfile[idx].SessionCDvapHeading == sessionCDvapHeading && cacheCDA_VolumeProfile[idx].SessionFillColor == sessionFillColor && cacheCDA_VolumeProfile[idx].SessionOpacity == sessionOpacity && cacheCDA_VolumeProfile[idx].SessionOpacityToolLabel == sessionOpacityToolLabel && cacheCDA_VolumeProfile[idx].SessionOutlineColor == sessionOutlineColor && Math.Abs(cacheCDA_VolumeProfile[idx].SessionScale - sessionScale) <= double.Epsilon && cacheCDA_VolumeProfile[idx].SessionScaleToolLabel == sessionScaleToolLabel && cacheCDA_VolumeProfile[idx].SessionSquareOutline == sessionSquareOutline && cacheCDA_VolumeProfile[idx].SessionVolumeFont == sessionVolumeFont && cacheCDA_VolumeProfile[idx].ShowBigPrints == showBigPrints && cacheCDA_VolumeProfile[idx].ShowBPHLine == showBPHLine && cacheCDA_VolumeProfile[idx].ShowBPVLine == showBPVLine && cacheCDA_VolumeProfile[idx].ShowCDAtEachPrice == showCDAtEachPrice && cacheCDA_VolumeProfile[idx].ShowCompositeBeginDate == showCompositeBeginDate && cacheCDA_VolumeProfile[idx].ShowCompositeProfile == showCompositeProfile && cacheCDA_VolumeProfile[idx].ShowCompositeVolumes == showCompositeVolumes && cacheCDA_VolumeProfile[idx].ShowCompValueNodePrice == showCompValueNodePrice && cacheCDA_VolumeProfile[idx].ShowCompValueNodes == showCompValueNodes && cacheCDA_VolumeProfile[idx].ShowGaps == showGaps && cacheCDA_VolumeProfile[idx].ShowIB == showIB && cacheCDA_VolumeProfile[idx].ShowIB15x == showIB15x && cacheCDA_VolumeProfile[idx].ShowIB2x == showIB2x && cacheCDA_VolumeProfile[idx].ShowIBRange == showIBRange && cacheCDA_VolumeProfile[idx].ShowLabels == showLabels && cacheCDA_VolumeProfile[idx].ShowMCVA == showMCVA && cacheCDA_VolumeProfile[idx].ShowMicroCompositeDates == showMicroCompositeDates && cacheCDA_VolumeProfile[idx].ShowMicroCompositeProfile == showMicroCompositeProfile && cacheCDA_VolumeProfile[idx].ShowMicroCompositeVolumes == showMicroCompositeVolumes && cacheCDA_VolumeProfile[idx].ShowMicroCompValueNodePrice == showMicroCompValueNodePrice && cacheCDA_VolumeProfile[idx].ShowMicroCompValueNodes == showMicroCompValueNodes && cacheCDA_VolumeProfile[idx].ShowNHLs == showNHLs && cacheCDA_VolumeProfile[idx].ShowNIBs == showNIBs && cacheCDA_VolumeProfile[idx].ShowNVAs == showNVAs && cacheCDA_VolumeProfile[idx].ShowNVPOCs == showNVPOCs && cacheCDA_VolumeProfile[idx].ShowOHMLC == showOHMLC && cacheCDA_VolumeProfile[idx].ShowOS == showOS && cacheCDA_VolumeProfile[idx].ShowOvernightStats == showOvernightStats && cacheCDA_VolumeProfile[idx].ShowPriceWithLabel == showPriceWithLabel && cacheCDA_VolumeProfile[idx].ShowSessionImbalanceFactor == showSessionImbalanceFactor && cacheCDA_VolumeProfile[idx].ShowSessionProfile == showSessionProfile && cacheCDA_VolumeProfile[idx].ShowSessionRange == showSessionRange && cacheCDA_VolumeProfile[idx].ShowSessionVolumes == showSessionVolumes && cacheCDA_VolumeProfile[idx].ShowStartupMessages == showStartupMessages && cacheCDA_VolumeProfile[idx].ShowToolBar == showToolBar && cacheCDA_VolumeProfile[idx].ShowTrendChange == showTrendChange && cacheCDA_VolumeProfile[idx].ShowVA == showVA && cacheCDA_VolumeProfile[idx].ShowVARange == showVARange && cacheCDA_VolumeProfile[idx].ShowVPOC == showVPOC && cacheCDA_VolumeProfile[idx].ShowVPOCTrack == showVPOCTrack && cacheCDA_VolumeProfile[idx].SlowPeriod == slowPeriod && cacheCDA_VolumeProfile[idx].StandardCDHeading == standardCDHeading && cacheCDA_VolumeProfile[idx].StaticMCEnabled == staticMCEnabled && cacheCDA_VolumeProfile[idx].Threshold == threshold && cacheCDA_VolumeProfile[idx].ToolBarHideDropDownLabel == toolBarHideDropDownLabel && cacheCDA_VolumeProfile[idx].ToolBarTextColor == toolBarTextColor && cacheCDA_VolumeProfile[idx].ToolBarTextFont == toolBarTextFont && cacheCDA_VolumeProfile[idx].ToolBarTextFontOnFocus == toolBarTextFontOnFocus && cacheCDA_VolumeProfile[idx].TrendCDvapHeading == trendCDvapHeading && cacheCDA_VolumeProfile[idx].TrendChangeDownColor == trendChangeDownColor && cacheCDA_VolumeProfile[idx].TrendChangeUpColor == trendChangeUpColor && cacheCDA_VolumeProfile[idx].UpdateInRealtimeEnabled == updateInRealtimeEnabled && cacheCDA_VolumeProfile[idx].VAColor == vAColor && cacheCDA_VolumeProfile[idx].VAHLabel == vAHLabel && cacheCDA_VolumeProfile[idx].VALineStyle == vALineStyle && cacheCDA_VolumeProfile[idx].VALineWidth == vALineWidth && cacheCDA_VolumeProfile[idx].VALLabel == vALLabel && cacheCDA_VolumeProfile[idx].VAOpacity == vAOpacity && Math.Abs(cacheCDA_VolumeProfile[idx].VAPercent - vAPercent) <= double.Epsilon && cacheCDA_VolumeProfile[idx].VPOCColor == vPOCColor && cacheCDA_VolumeProfile[idx].VPOCLabel == vPOCLabel && cacheCDA_VolumeProfile[idx].VPOCLineStyle == vPOCLineStyle && cacheCDA_VolumeProfile[idx].VPOCLineWidth == vPOCLineWidth && cacheCDA_VolumeProfile[idx].VWAPColor == vWAPColor && cacheCDA_VolumeProfile[idx].VWAPLabel == vWAPLabel && cacheCDA_VolumeProfile[idx].VWAPLineStyle == vWAPLineStyle && cacheCDA_VolumeProfile[idx].VWAPLineWidth == vWAPLineWidth && cacheCDA_VolumeProfile[idx].VWAPSD1Color == vWAPSD1Color && cacheCDA_VolumeProfile[idx].VWAPSD1LineStyle == vWAPSD1LineStyle && cacheCDA_VolumeProfile[idx].VWAPSD1LineWidth == vWAPSD1LineWidth && cacheCDA_VolumeProfile[idx].VWAPSD2Color == vWAPSD2Color && cacheCDA_VolumeProfile[idx].VWAPSD2LineStyle == vWAPSD2LineStyle && cacheCDA_VolumeProfile[idx].VWAPSD2LineWidth == vWAPSD2LineWidth && cacheCDA_VolumeProfile[idx].VWAPSD3Color == vWAPSD3Color && cacheCDA_VolumeProfile[idx].VWAPSD3LineStyle == vWAPSD3LineStyle && cacheCDA_VolumeProfile[idx].VWAPSD3LineWidth == vWAPSD3LineWidth && cacheCDA_VolumeProfile[idx].EqualsInput(input))
                        return cacheCDA_VolumeProfile[idx];

            lock (checkCDA_VolumeProfile)
            {
                checkCDA_VolumeProfile.AboveAskColor = aboveAskColor;
                aboveAskColor = checkCDA_VolumeProfile.AboveAskColor;
                checkCDA_VolumeProfile.AtAskColor = atAskColor;
                atAskColor = checkCDA_VolumeProfile.AtAskColor;
                checkCDA_VolumeProfile.AtBidColor = atBidColor;
                atBidColor = checkCDA_VolumeProfile.AtBidColor;
                checkCDA_VolumeProfile.AutoSaveMicroCompositeSettings = autoSaveMicroCompositeSettings;
                autoSaveMicroCompositeSettings = checkCDA_VolumeProfile.AutoSaveMicroCompositeSettings;
                checkCDA_VolumeProfile.AutoUpdateMCEndDate = autoUpdateMCEndDate;
                autoUpdateMCEndDate = checkCDA_VolumeProfile.AutoUpdateMCEndDate;
                checkCDA_VolumeProfile.BelowBidColor = belowBidColor;
                belowBidColor = checkCDA_VolumeProfile.BelowBidColor;
                checkCDA_VolumeProfile.BigPrintsFileDir = bigPrintsFileDir;
                bigPrintsFileDir = checkCDA_VolumeProfile.BigPrintsFileDir;
                checkCDA_VolumeProfile.BPAlertEnabled = bPAlertEnabled;
                bPAlertEnabled = checkCDA_VolumeProfile.BPAlertEnabled;
                checkCDA_VolumeProfile.BPAlertSoundFile = bPAlertSoundFile;
                bPAlertSoundFile = checkCDA_VolumeProfile.BPAlertSoundFile;
                checkCDA_VolumeProfile.BPDisplayCount = bPDisplayCount;
                bPDisplayCount = checkCDA_VolumeProfile.BPDisplayCount;
                checkCDA_VolumeProfile.BPDisplayMode = bPDisplayMode;
                bPDisplayMode = checkCDA_VolumeProfile.BPDisplayMode;
                checkCDA_VolumeProfile.BPDisplayPosition = bPDisplayPosition;
                bPDisplayPosition = checkCDA_VolumeProfile.BPDisplayPosition;
                checkCDA_VolumeProfile.BPFilterMode = bPFilterMode;
                bPFilterMode = checkCDA_VolumeProfile.BPFilterMode;
                checkCDA_VolumeProfile.BPHLineStyle = bPHLineStyle;
                bPHLineStyle = checkCDA_VolumeProfile.BPHLineStyle;
                checkCDA_VolumeProfile.BPHLineWidth = bPHLineWidth;
                bPHLineWidth = checkCDA_VolumeProfile.BPHLineWidth;
                checkCDA_VolumeProfile.BPLabel = bPLabel;
                bPLabel = checkCDA_VolumeProfile.BPLabel;
                checkCDA_VolumeProfile.BPLabelColor = bPLabelColor;
                bPLabelColor = checkCDA_VolumeProfile.BPLabelColor;
                checkCDA_VolumeProfile.BPLabelFont = bPLabelFont;
                bPLabelFont = checkCDA_VolumeProfile.BPLabelFont;
                checkCDA_VolumeProfile.BPLabelOffset = bPLabelOffset;
                bPLabelOffset = checkCDA_VolumeProfile.BPLabelOffset;
                checkCDA_VolumeProfile.BPMinVolume = bPMinVolume;
                bPMinVolume = checkCDA_VolumeProfile.BPMinVolume;
                checkCDA_VolumeProfile.BPMulipleAboveMultipleOfAverageVolume = bPMulipleAboveMultipleOfAverageVolume;
                bPMulipleAboveMultipleOfAverageVolume = checkCDA_VolumeProfile.BPMulipleAboveMultipleOfAverageVolume;
                checkCDA_VolumeProfile.BPVLineStyle = bPVLineStyle;
                bPVLineStyle = checkCDA_VolumeProfile.BPVLineStyle;
                checkCDA_VolumeProfile.BPVLineWidth = bPVLineWidth;
                bPVLineWidth = checkCDA_VolumeProfile.BPVLineWidth;
                checkCDA_VolumeProfile.CalcMode = calcMode;
                calcMode = checkCDA_VolumeProfile.CalcMode;
                checkCDA_VolumeProfile.CD0Label = cD0Label;
                cD0Label = checkCDA_VolumeProfile.CD0Label;
                checkCDA_VolumeProfile.CD0LineColor = cD0LineColor;
                cD0LineColor = checkCDA_VolumeProfile.CD0LineColor;
                checkCDA_VolumeProfile.CD0LineStyle = cD0LineStyle;
                cD0LineStyle = checkCDA_VolumeProfile.CD0LineStyle;
                checkCDA_VolumeProfile.CD0LineWidth = cD0LineWidth;
                cD0LineWidth = checkCDA_VolumeProfile.CD0LineWidth;
                checkCDA_VolumeProfile.CDDownColor = cDDownColor;
                cDDownColor = checkCDA_VolumeProfile.CDDownColor;
                checkCDA_VolumeProfile.CDHeadingsColor = cDHeadingsColor;
                cDHeadingsColor = checkCDA_VolumeProfile.CDHeadingsColor;
                checkCDA_VolumeProfile.CDHeadingsFont = cDHeadingsFont;
                cDHeadingsFont = checkCDA_VolumeProfile.CDHeadingsFont;
                checkCDA_VolumeProfile.CDHighLabel = cDHighLabel;
                cDHighLabel = checkCDA_VolumeProfile.CDHighLabel;
                checkCDA_VolumeProfile.CDHighLineColor = cDHighLineColor;
                cDHighLineColor = checkCDA_VolumeProfile.CDHighLineColor;
                checkCDA_VolumeProfile.CDHighLineStyle = cDHighLineStyle;
                cDHighLineStyle = checkCDA_VolumeProfile.CDHighLineStyle;
                checkCDA_VolumeProfile.CDHighLineWidth = cDHighLineWidth;
                cDHighLineWidth = checkCDA_VolumeProfile.CDHighLineWidth;
                checkCDA_VolumeProfile.CDLineStyle = cDLineStyle;
                cDLineStyle = checkCDA_VolumeProfile.CDLineStyle;
                checkCDA_VolumeProfile.CDLineWidth = cDLineWidth;
                cDLineWidth = checkCDA_VolumeProfile.CDLineWidth;
                checkCDA_VolumeProfile.CDLocation = cDLocation;
                cDLocation = checkCDA_VolumeProfile.CDLocation;
                checkCDA_VolumeProfile.CDLowLabel = cDLowLabel;
                cDLowLabel = checkCDA_VolumeProfile.CDLowLabel;
                checkCDA_VolumeProfile.CDLowLineColor = cDLowLineColor;
                cDLowLineColor = checkCDA_VolumeProfile.CDLowLineColor;
                checkCDA_VolumeProfile.CDLowLineStyle = cDLowLineStyle;
                cDLowLineStyle = checkCDA_VolumeProfile.CDLowLineStyle;
                checkCDA_VolumeProfile.CDLowLineWidth = cDLowLineWidth;
                cDLowLineWidth = checkCDA_VolumeProfile.CDLowLineWidth;
                checkCDA_VolumeProfile.CDNeutralColor = cDNeutralColor;
                cDNeutralColor = checkCDA_VolumeProfile.CDNeutralColor;
                checkCDA_VolumeProfile.CDPlotLabel = cDPlotLabel;
                cDPlotLabel = checkCDA_VolumeProfile.CDPlotLabel;
                checkCDA_VolumeProfile.CDUpColor = cDUpColor;
                cDUpColor = checkCDA_VolumeProfile.CDUpColor;
                checkCDA_VolumeProfile.CDValueFont = cDValueFont;
                cDValueFont = checkCDA_VolumeProfile.CDValueFont;
                checkCDA_VolumeProfile.CHVNBandColor = cHVNBandColor;
                cHVNBandColor = checkCDA_VolumeProfile.CHVNBandColor;
                checkCDA_VolumeProfile.CHVNBandOpacity = cHVNBandOpacity;
                cHVNBandOpacity = checkCDA_VolumeProfile.CHVNBandOpacity;
                checkCDA_VolumeProfile.CHVNBandOpacityToolLabel = cHVNBandOpacityToolLabel;
                cHVNBandOpacityToolLabel = checkCDA_VolumeProfile.CHVNBandOpacityToolLabel;
                checkCDA_VolumeProfile.CHVNBandWidth = cHVNBandWidth;
                cHVNBandWidth = checkCDA_VolumeProfile.CHVNBandWidth;
                checkCDA_VolumeProfile.CHVNLineColor = cHVNLineColor;
                cHVNLineColor = checkCDA_VolumeProfile.CHVNLineColor;
                checkCDA_VolumeProfile.CHVNLineStyle = cHVNLineStyle;
                cHVNLineStyle = checkCDA_VolumeProfile.CHVNLineStyle;
                checkCDA_VolumeProfile.CHVNLineWidth = cHVNLineWidth;
                cHVNLineWidth = checkCDA_VolumeProfile.CHVNLineWidth;
                checkCDA_VolumeProfile.CloseColor = closeColor;
                closeColor = checkCDA_VolumeProfile.CloseColor;
                checkCDA_VolumeProfile.CloseLabel = closeLabel;
                closeLabel = checkCDA_VolumeProfile.CloseLabel;
                checkCDA_VolumeProfile.CloseLineStyle = closeLineStyle;
                closeLineStyle = checkCDA_VolumeProfile.CloseLineStyle;
                checkCDA_VolumeProfile.CloseLineWidth = closeLineWidth;
                closeLineWidth = checkCDA_VolumeProfile.CloseLineWidth;
                checkCDA_VolumeProfile.CLVNBandColor = cLVNBandColor;
                cLVNBandColor = checkCDA_VolumeProfile.CLVNBandColor;
                checkCDA_VolumeProfile.CLVNBandOpacity = cLVNBandOpacity;
                cLVNBandOpacity = checkCDA_VolumeProfile.CLVNBandOpacity;
                checkCDA_VolumeProfile.CLVNBandOpacityToolLabel = cLVNBandOpacityToolLabel;
                cLVNBandOpacityToolLabel = checkCDA_VolumeProfile.CLVNBandOpacityToolLabel;
                checkCDA_VolumeProfile.CLVNBandWidth = cLVNBandWidth;
                cLVNBandWidth = checkCDA_VolumeProfile.CLVNBandWidth;
                checkCDA_VolumeProfile.CLVNLineColor = cLVNLineColor;
                cLVNLineColor = checkCDA_VolumeProfile.CLVNLineColor;
                checkCDA_VolumeProfile.CLVNLineStyle = cLVNLineStyle;
                cLVNLineStyle = checkCDA_VolumeProfile.CLVNLineStyle;
                checkCDA_VolumeProfile.CLVNLineWidth = cLVNLineWidth;
                cLVNLineWidth = checkCDA_VolumeProfile.CLVNLineWidth;
                checkCDA_VolumeProfile.CompositeAnchorOffset = compositeAnchorOffset;
                compositeAnchorOffset = checkCDA_VolumeProfile.CompositeAnchorOffset;
                checkCDA_VolumeProfile.CompositeAnchorOffsetToolLabel = compositeAnchorOffsetToolLabel;
                compositeAnchorOffsetToolLabel = checkCDA_VolumeProfile.CompositeAnchorOffsetToolLabel;
                checkCDA_VolumeProfile.CompositeAnchorPosition = compositeAnchorPosition;
                compositeAnchorPosition = checkCDA_VolumeProfile.CompositeAnchorPosition;
                checkCDA_VolumeProfile.CompositeAnchorPositionToolLabel = compositeAnchorPositionToolLabel;
                compositeAnchorPositionToolLabel = checkCDA_VolumeProfile.CompositeAnchorPositionToolLabel;
                checkCDA_VolumeProfile.CompositeBeginDate = compositeBeginDate;
                compositeBeginDate = checkCDA_VolumeProfile.CompositeBeginDate;
                checkCDA_VolumeProfile.CompositeBeginDateToolLabel = compositeBeginDateToolLabel;
                compositeBeginDateToolLabel = checkCDA_VolumeProfile.CompositeBeginDateToolLabel;
                checkCDA_VolumeProfile.CompositeFillColor = compositeFillColor;
                compositeFillColor = checkCDA_VolumeProfile.CompositeFillColor;
                checkCDA_VolumeProfile.CompositeOpacity = compositeOpacity;
                compositeOpacity = checkCDA_VolumeProfile.CompositeOpacity;
                checkCDA_VolumeProfile.CompositeOpacityToolLabel = compositeOpacityToolLabel;
                compositeOpacityToolLabel = checkCDA_VolumeProfile.CompositeOpacityToolLabel;
                checkCDA_VolumeProfile.CompositeOutlineColor = compositeOutlineColor;
                compositeOutlineColor = checkCDA_VolumeProfile.CompositeOutlineColor;
                checkCDA_VolumeProfile.CompositeScale = compositeScale;
                compositeScale = checkCDA_VolumeProfile.CompositeScale;
                checkCDA_VolumeProfile.CompositeScaleToolLabel = compositeScaleToolLabel;
                compositeScaleToolLabel = checkCDA_VolumeProfile.CompositeScaleToolLabel;
                checkCDA_VolumeProfile.CompositeSmoothingFactor = compositeSmoothingFactor;
                compositeSmoothingFactor = checkCDA_VolumeProfile.CompositeSmoothingFactor;
                checkCDA_VolumeProfile.CompositeSmoothingFactorToolLabel = compositeSmoothingFactorToolLabel;
                compositeSmoothingFactorToolLabel = checkCDA_VolumeProfile.CompositeSmoothingFactorToolLabel;
                checkCDA_VolumeProfile.CompositeSquareOutline = compositeSquareOutline;
                compositeSquareOutline = checkCDA_VolumeProfile.CompositeSquareOutline;
                checkCDA_VolumeProfile.CompositeVNToolLabel = compositeVNToolLabel;
                compositeVNToolLabel = checkCDA_VolumeProfile.CompositeVNToolLabel;
                checkCDA_VolumeProfile.CompValueNodeStrength = compValueNodeStrength;
                compValueNodeStrength = checkCDA_VolumeProfile.CompValueNodeStrength;
                checkCDA_VolumeProfile.CurrentSessionAnchorPosition = currentSessionAnchorPosition;
                currentSessionAnchorPosition = checkCDA_VolumeProfile.CurrentSessionAnchorPosition;
                checkCDA_VolumeProfile.CVPOCColor = cVPOCColor;
                cVPOCColor = checkCDA_VolumeProfile.CVPOCColor;
                checkCDA_VolumeProfile.CVPOCLabel = cVPOCLabel;
                cVPOCLabel = checkCDA_VolumeProfile.CVPOCLabel;
                checkCDA_VolumeProfile.CVPOCLineStyle = cVPOCLineStyle;
                cVPOCLineStyle = checkCDA_VolumeProfile.CVPOCLineStyle;
                checkCDA_VolumeProfile.CVPOCLineWidth = cVPOCLineWidth;
                cVPOCLineWidth = checkCDA_VolumeProfile.CVPOCLineWidth;
                checkCDA_VolumeProfile.DataFileDir = dataFileDir;
                dataFileDir = checkCDA_VolumeProfile.DataFileDir;
                checkCDA_VolumeProfile.DisplayComputedAtBar = displayComputedAtBar;
                displayComputedAtBar = checkCDA_VolumeProfile.DisplayComputedAtBar;
                checkCDA_VolumeProfile.DisplayComputedAtPrice = displayComputedAtPrice;
                displayComputedAtPrice = checkCDA_VolumeProfile.DisplayComputedAtPrice;
                checkCDA_VolumeProfile.DisplaySD1 = displaySD1;
                displaySD1 = checkCDA_VolumeProfile.DisplaySD1;
                checkCDA_VolumeProfile.DisplaySD2 = displaySD2;
                displaySD2 = checkCDA_VolumeProfile.DisplaySD2;
                checkCDA_VolumeProfile.DisplaySD3 = displaySD3;
                displaySD3 = checkCDA_VolumeProfile.DisplaySD3;
                checkCDA_VolumeProfile.DisplayVABand = displayVABand;
                displayVABand = checkCDA_VolumeProfile.DisplayVABand;
                checkCDA_VolumeProfile.DrawCD0 = drawCD0;
                drawCD0 = checkCDA_VolumeProfile.DrawCD0;
                checkCDA_VolumeProfile.DrawCDHighLow = drawCDHighLow;
                drawCDHighLow = checkCDA_VolumeProfile.DrawCDHighLow;
                checkCDA_VolumeProfile.EmailAddress = emailAddress;
                emailAddress = checkCDA_VolumeProfile.EmailAddress;
                checkCDA_VolumeProfile.EmailToAddress = emailToAddress;
                emailToAddress = checkCDA_VolumeProfile.EmailToAddress;
                checkCDA_VolumeProfile.EnableCD = enableCD;
                enableCD = checkCDA_VolumeProfile.EnableCD;
                checkCDA_VolumeProfile.EnableCHVNOpacityTool = enableCHVNOpacityTool;
                enableCHVNOpacityTool = checkCDA_VolumeProfile.EnableCHVNOpacityTool;
                checkCDA_VolumeProfile.EnableCLVNOpacityTool = enableCLVNOpacityTool;
                enableCLVNOpacityTool = checkCDA_VolumeProfile.EnableCLVNOpacityTool;
                checkCDA_VolumeProfile.EnableCompositeAnchorOffsetTool = enableCompositeAnchorOffsetTool;
                enableCompositeAnchorOffsetTool = checkCDA_VolumeProfile.EnableCompositeAnchorOffsetTool;
                checkCDA_VolumeProfile.EnableCompositeAnchorPositionTool = enableCompositeAnchorPositionTool;
                enableCompositeAnchorPositionTool = checkCDA_VolumeProfile.EnableCompositeAnchorPositionTool;
                checkCDA_VolumeProfile.EnableCompositeBeginDateTool = enableCompositeBeginDateTool;
                enableCompositeBeginDateTool = checkCDA_VolumeProfile.EnableCompositeBeginDateTool;
                checkCDA_VolumeProfile.EnableCompositeHeatmap = enableCompositeHeatmap;
                enableCompositeHeatmap = checkCDA_VolumeProfile.EnableCompositeHeatmap;
                checkCDA_VolumeProfile.EnableCompositeOpacityTool = enableCompositeOpacityTool;
                enableCompositeOpacityTool = checkCDA_VolumeProfile.EnableCompositeOpacityTool;
                checkCDA_VolumeProfile.EnableCompositeScaleTool = enableCompositeScaleTool;
                enableCompositeScaleTool = checkCDA_VolumeProfile.EnableCompositeScaleTool;
                checkCDA_VolumeProfile.EnableCompositeSmoothingFactorTool = enableCompositeSmoothingFactorTool;
                enableCompositeSmoothingFactorTool = checkCDA_VolumeProfile.EnableCompositeSmoothingFactorTool;
                checkCDA_VolumeProfile.EnableCompositeVNTool = enableCompositeVNTool;
                enableCompositeVNTool = checkCDA_VolumeProfile.EnableCompositeVNTool;
                checkCDA_VolumeProfile.EnableHideBlockTradesButton = enableHideBlockTradesButton;
                enableHideBlockTradesButton = checkCDA_VolumeProfile.EnableHideBlockTradesButton;
                checkCDA_VolumeProfile.EnableHideCDsButton = enableHideCDsButton;
                enableHideCDsButton = checkCDA_VolumeProfile.EnableHideCDsButton;
                checkCDA_VolumeProfile.EnableHideCompositeProfileButton = enableHideCompositeProfileButton;
                enableHideCompositeProfileButton = checkCDA_VolumeProfile.EnableHideCompositeProfileButton;
                checkCDA_VolumeProfile.EnableHideCompositeProfileValueNodesButton = enableHideCompositeProfileValueNodesButton;
                enableHideCompositeProfileValueNodesButton = checkCDA_VolumeProfile.EnableHideCompositeProfileValueNodesButton;
                checkCDA_VolumeProfile.EnableHideMicroCompositeProfilesButton = enableHideMicroCompositeProfilesButton;
                enableHideMicroCompositeProfilesButton = checkCDA_VolumeProfile.EnableHideMicroCompositeProfilesButton;
                checkCDA_VolumeProfile.EnableHideMicroCompositeProfileValueAreasButton = enableHideMicroCompositeProfileValueAreasButton;
                enableHideMicroCompositeProfileValueAreasButton = checkCDA_VolumeProfile.EnableHideMicroCompositeProfileValueAreasButton;
                checkCDA_VolumeProfile.EnableHideMicroCompositeProfileValueNodesButton = enableHideMicroCompositeProfileValueNodesButton;
                enableHideMicroCompositeProfileValueNodesButton = checkCDA_VolumeProfile.EnableHideMicroCompositeProfileValueNodesButton;
                checkCDA_VolumeProfile.EnableHideOvernightStatsButton = enableHideOvernightStatsButton;
                enableHideOvernightStatsButton = checkCDA_VolumeProfile.EnableHideOvernightStatsButton;
                checkCDA_VolumeProfile.EnableHideSessionProfilesButton = enableHideSessionProfilesButton;
                enableHideSessionProfilesButton = checkCDA_VolumeProfile.EnableHideSessionProfilesButton;
                checkCDA_VolumeProfile.EnableMicroCompositeAnchorEdgeTool = enableMicroCompositeAnchorEdgeTool;
                enableMicroCompositeAnchorEdgeTool = checkCDA_VolumeProfile.EnableMicroCompositeAnchorEdgeTool;
                checkCDA_VolumeProfile.EnableMicroCompositeAnchorOffsetTool = enableMicroCompositeAnchorOffsetTool;
                enableMicroCompositeAnchorOffsetTool = checkCDA_VolumeProfile.EnableMicroCompositeAnchorOffsetTool;
                checkCDA_VolumeProfile.EnableMicroCompositeAnchorPositionTool = enableMicroCompositeAnchorPositionTool;
                enableMicroCompositeAnchorPositionTool = checkCDA_VolumeProfile.EnableMicroCompositeAnchorPositionTool;
                checkCDA_VolumeProfile.EnableMicroCompositeDateRangeTool = enableMicroCompositeDateRangeTool;
                enableMicroCompositeDateRangeTool = checkCDA_VolumeProfile.EnableMicroCompositeDateRangeTool;
                checkCDA_VolumeProfile.EnableMicroCompositeHeatmap = enableMicroCompositeHeatmap;
                enableMicroCompositeHeatmap = checkCDA_VolumeProfile.EnableMicroCompositeHeatmap;
                checkCDA_VolumeProfile.EnableMicroCompositeOpacityTool = enableMicroCompositeOpacityTool;
                enableMicroCompositeOpacityTool = checkCDA_VolumeProfile.EnableMicroCompositeOpacityTool;
                checkCDA_VolumeProfile.EnableMicroCompositeScaleTool = enableMicroCompositeScaleTool;
                enableMicroCompositeScaleTool = checkCDA_VolumeProfile.EnableMicroCompositeScaleTool;
                checkCDA_VolumeProfile.EnableMicroCompositeSmoothingFactorTool = enableMicroCompositeSmoothingFactorTool;
                enableMicroCompositeSmoothingFactorTool = checkCDA_VolumeProfile.EnableMicroCompositeSmoothingFactorTool;
                checkCDA_VolumeProfile.EnableMicroCompositeVNTool = enableMicroCompositeVNTool;
                enableMicroCompositeVNTool = checkCDA_VolumeProfile.EnableMicroCompositeVNTool;
                checkCDA_VolumeProfile.EnablePrecisionRangeProfiling = enablePrecisionRangeProfiling;
                enablePrecisionRangeProfiling = checkCDA_VolumeProfile.EnablePrecisionRangeProfiling;
                checkCDA_VolumeProfile.EnableRunLog = enableRunLog;
                enableRunLog = checkCDA_VolumeProfile.EnableRunLog;
                checkCDA_VolumeProfile.EnableSessionAnchorOffsetTool = enableSessionAnchorOffsetTool;
                enableSessionAnchorOffsetTool = checkCDA_VolumeProfile.EnableSessionAnchorOffsetTool;
                checkCDA_VolumeProfile.EnableSessionAnchorPositionTool = enableSessionAnchorPositionTool;
                enableSessionAnchorPositionTool = checkCDA_VolumeProfile.EnableSessionAnchorPositionTool;
                checkCDA_VolumeProfile.EnableSessionHeatmap = enableSessionHeatmap;
                enableSessionHeatmap = checkCDA_VolumeProfile.EnableSessionHeatmap;
                checkCDA_VolumeProfile.EnableSessionOpacityTool = enableSessionOpacityTool;
                enableSessionOpacityTool = checkCDA_VolumeProfile.EnableSessionOpacityTool;
                checkCDA_VolumeProfile.EnableSessionScaleTool = enableSessionScaleTool;
                enableSessionScaleTool = checkCDA_VolumeProfile.EnableSessionScaleTool;
                checkCDA_VolumeProfile.EnableVWAP = enableVWAP;
                enableVWAP = checkCDA_VolumeProfile.EnableVWAP;
                checkCDA_VolumeProfile.ExportFileDir = exportFileDir;
                exportFileDir = checkCDA_VolumeProfile.ExportFileDir;
                checkCDA_VolumeProfile.ExportStats = exportStats;
                exportStats = checkCDA_VolumeProfile.ExportStats;
                checkCDA_VolumeProfile.FastPeriod = fastPeriod;
                fastPeriod = checkCDA_VolumeProfile.FastPeriod;
                checkCDA_VolumeProfile.GAPAlertEnabled = gAPAlertEnabled;
                gAPAlertEnabled = checkCDA_VolumeProfile.GAPAlertEnabled;
                checkCDA_VolumeProfile.GAPAlertSoundFile = gAPAlertSoundFile;
                gAPAlertSoundFile = checkCDA_VolumeProfile.GAPAlertSoundFile;
                checkCDA_VolumeProfile.GAPAppendDate = gAPAppendDate;
                gAPAppendDate = checkCDA_VolumeProfile.GAPAppendDate;
                checkCDA_VolumeProfile.GAPAppendPrice = gAPAppendPrice;
                gAPAppendPrice = checkCDA_VolumeProfile.GAPAppendPrice;
                checkCDA_VolumeProfile.GAPColor = gAPColor;
                gAPColor = checkCDA_VolumeProfile.GAPColor;
                checkCDA_VolumeProfile.GAPFont = gAPFont;
                gAPFont = checkCDA_VolumeProfile.GAPFont;
                checkCDA_VolumeProfile.GAPLabel = gAPLabel;
                gAPLabel = checkCDA_VolumeProfile.GAPLabel;
                checkCDA_VolumeProfile.GAPLineStyle = gAPLineStyle;
                gAPLineStyle = checkCDA_VolumeProfile.GAPLineStyle;
                checkCDA_VolumeProfile.GAPLineWidth = gAPLineWidth;
                gAPLineWidth = checkCDA_VolumeProfile.GAPLineWidth;
                checkCDA_VolumeProfile.HighColor = highColor;
                highColor = checkCDA_VolumeProfile.HighColor;
                checkCDA_VolumeProfile.HighLabel = highLabel;
                highLabel = checkCDA_VolumeProfile.HighLabel;
                checkCDA_VolumeProfile.HighlightIB = highlightIB;
                highlightIB = checkCDA_VolumeProfile.HighlightIB;
                checkCDA_VolumeProfile.HighlightMCVA = highlightMCVA;
                highlightMCVA = checkCDA_VolumeProfile.HighlightMCVA;
                checkCDA_VolumeProfile.HighlightVA = highlightVA;
                highlightVA = checkCDA_VolumeProfile.HighlightVA;
                checkCDA_VolumeProfile.HighLineStyle = highLineStyle;
                highLineStyle = checkCDA_VolumeProfile.HighLineStyle;
                checkCDA_VolumeProfile.HighLineWidth = highLineWidth;
                highLineWidth = checkCDA_VolumeProfile.HighLineWidth;
                checkCDA_VolumeProfile.IB15xColor = iB15xColor;
                iB15xColor = checkCDA_VolumeProfile.IB15xColor;
                checkCDA_VolumeProfile.IB15xLineStyle = iB15xLineStyle;
                iB15xLineStyle = checkCDA_VolumeProfile.IB15xLineStyle;
                checkCDA_VolumeProfile.IB15xLineWidth = iB15xLineWidth;
                iB15xLineWidth = checkCDA_VolumeProfile.IB15xLineWidth;
                checkCDA_VolumeProfile.IB2xColor = iB2xColor;
                iB2xColor = checkCDA_VolumeProfile.IB2xColor;
                checkCDA_VolumeProfile.IB2xLineStyle = iB2xLineStyle;
                iB2xLineStyle = checkCDA_VolumeProfile.IB2xLineStyle;
                checkCDA_VolumeProfile.IB2xLineWidth = iB2xLineWidth;
                iB2xLineWidth = checkCDA_VolumeProfile.IB2xLineWidth;
                checkCDA_VolumeProfile.IBColor = iBColor;
                iBColor = checkCDA_VolumeProfile.IBColor;
                checkCDA_VolumeProfile.IBH15xLabel = iBH15xLabel;
                iBH15xLabel = checkCDA_VolumeProfile.IBH15xLabel;
                checkCDA_VolumeProfile.IBH2xLabel = iBH2xLabel;
                iBH2xLabel = checkCDA_VolumeProfile.IBH2xLabel;
                checkCDA_VolumeProfile.IBHLabel = iBHLabel;
                iBHLabel = checkCDA_VolumeProfile.IBHLabel;
                checkCDA_VolumeProfile.IBL15xLabel = iBL15xLabel;
                iBL15xLabel = checkCDA_VolumeProfile.IBL15xLabel;
                checkCDA_VolumeProfile.IBL2xLabel = iBL2xLabel;
                iBL2xLabel = checkCDA_VolumeProfile.IBL2xLabel;
                checkCDA_VolumeProfile.IBLineStyle = iBLineStyle;
                iBLineStyle = checkCDA_VolumeProfile.IBLineStyle;
                checkCDA_VolumeProfile.IBLineWidth = iBLineWidth;
                iBLineWidth = checkCDA_VolumeProfile.IBLineWidth;
                checkCDA_VolumeProfile.IBLLabel = iBLLabel;
                iBLLabel = checkCDA_VolumeProfile.IBLLabel;
                checkCDA_VolumeProfile.IBMinutes = iBMinutes;
                iBMinutes = checkCDA_VolumeProfile.IBMinutes;
                checkCDA_VolumeProfile.InsideColor = insideColor;
                insideColor = checkCDA_VolumeProfile.InsideColor;
                checkCDA_VolumeProfile.LabelDelay = labelDelay;
                labelDelay = checkCDA_VolumeProfile.LabelDelay;
                checkCDA_VolumeProfile.LabelDisplacement = labelDisplacement;
                labelDisplacement = checkCDA_VolumeProfile.LabelDisplacement;
                checkCDA_VolumeProfile.LabelFont = labelFont;
                labelFont = checkCDA_VolumeProfile.LabelFont;
                checkCDA_VolumeProfile.LoadVBCache = loadVBCache;
                loadVBCache = checkCDA_VolumeProfile.LoadVBCache;
                checkCDA_VolumeProfile.LowColor = lowColor;
                lowColor = checkCDA_VolumeProfile.LowColor;
                checkCDA_VolumeProfile.LowLabel = lowLabel;
                lowLabel = checkCDA_VolumeProfile.LowLabel;
                checkCDA_VolumeProfile.LowLineStyle = lowLineStyle;
                lowLineStyle = checkCDA_VolumeProfile.LowLineStyle;
                checkCDA_VolumeProfile.LowLineWidth = lowLineWidth;
                lowLineWidth = checkCDA_VolumeProfile.LowLineWidth;
                checkCDA_VolumeProfile.MCAnchorPositionLabelFollowsValue = mCAnchorPositionLabelFollowsValue;
                mCAnchorPositionLabelFollowsValue = checkCDA_VolumeProfile.MCAnchorPositionLabelFollowsValue;
                checkCDA_VolumeProfile.MCBeginEndByManualRect = mCBeginEndByManualRect;
                mCBeginEndByManualRect = checkCDA_VolumeProfile.MCBeginEndByManualRect;
                checkCDA_VolumeProfile.MCRectangleTagPrefix = mCRectangleTagPrefix;
                mCRectangleTagPrefix = checkCDA_VolumeProfile.MCRectangleTagPrefix;
                checkCDA_VolumeProfile.mcVAColor = mcVAColor;
                mcVAColor = checkCDA_VolumeProfile.mcVAColor;
                checkCDA_VolumeProfile.mcVAHLabel = mcVAHLabel;
                mcVAHLabel = checkCDA_VolumeProfile.mcVAHLabel;
                checkCDA_VolumeProfile.mcVALineStyle = mcVALineStyle;
                mcVALineStyle = checkCDA_VolumeProfile.mcVALineStyle;
                checkCDA_VolumeProfile.mcVALineWidth = mcVALineWidth;
                mcVALineWidth = checkCDA_VolumeProfile.mcVALineWidth;
                checkCDA_VolumeProfile.mcVALLabel = mcVALLabel;
                mcVALLabel = checkCDA_VolumeProfile.mcVALLabel;
                checkCDA_VolumeProfile.mcVAPercent = mcVAPercent;
                mcVAPercent = checkCDA_VolumeProfile.mcVAPercent;
                checkCDA_VolumeProfile.MicroCHVNColor = microCHVNColor;
                microCHVNColor = checkCDA_VolumeProfile.MicroCHVNColor;
                checkCDA_VolumeProfile.MicroCHVNLineStyle = microCHVNLineStyle;
                microCHVNLineStyle = checkCDA_VolumeProfile.MicroCHVNLineStyle;
                checkCDA_VolumeProfile.MicroCHVNLineWidth = microCHVNLineWidth;
                microCHVNLineWidth = checkCDA_VolumeProfile.MicroCHVNLineWidth;
                checkCDA_VolumeProfile.MicroCLVNColor = microCLVNColor;
                microCLVNColor = checkCDA_VolumeProfile.MicroCLVNColor;
                checkCDA_VolumeProfile.MicroCLVNLineStyle = microCLVNLineStyle;
                microCLVNLineStyle = checkCDA_VolumeProfile.MicroCLVNLineStyle;
                checkCDA_VolumeProfile.MicroCLVNLineWidth = microCLVNLineWidth;
                microCLVNLineWidth = checkCDA_VolumeProfile.MicroCLVNLineWidth;
                checkCDA_VolumeProfile.MicroCompositeAnchorBar = microCompositeAnchorBar;
                microCompositeAnchorBar = checkCDA_VolumeProfile.MicroCompositeAnchorBar;
                checkCDA_VolumeProfile.MicroCompositeAnchorEdge = microCompositeAnchorEdge;
                microCompositeAnchorEdge = checkCDA_VolumeProfile.MicroCompositeAnchorEdge;
                checkCDA_VolumeProfile.MicroCompositeAnchorEdgeToolLabel = microCompositeAnchorEdgeToolLabel;
                microCompositeAnchorEdgeToolLabel = checkCDA_VolumeProfile.MicroCompositeAnchorEdgeToolLabel;
                checkCDA_VolumeProfile.MicroCompositeAnchorOffset = microCompositeAnchorOffset;
                microCompositeAnchorOffset = checkCDA_VolumeProfile.MicroCompositeAnchorOffset;
                checkCDA_VolumeProfile.MicroCompositeAnchorOffsetToolLabel = microCompositeAnchorOffsetToolLabel;
                microCompositeAnchorOffsetToolLabel = checkCDA_VolumeProfile.MicroCompositeAnchorOffsetToolLabel;
                checkCDA_VolumeProfile.MicroCompositeAnchorPosition = microCompositeAnchorPosition;
                microCompositeAnchorPosition = checkCDA_VolumeProfile.MicroCompositeAnchorPosition;
                checkCDA_VolumeProfile.MicroCompositeAnchorPositionToolLabel = microCompositeAnchorPositionToolLabel;
                microCompositeAnchorPositionToolLabel = checkCDA_VolumeProfile.MicroCompositeAnchorPositionToolLabel;
                checkCDA_VolumeProfile.MicroCompositeBeginDate = microCompositeBeginDate;
                microCompositeBeginDate = checkCDA_VolumeProfile.MicroCompositeBeginDate;
                checkCDA_VolumeProfile.MicroCompositeDateRangeToolLabel = microCompositeDateRangeToolLabel;
                microCompositeDateRangeToolLabel = checkCDA_VolumeProfile.MicroCompositeDateRangeToolLabel;
                checkCDA_VolumeProfile.MicroCompositeEndDate = microCompositeEndDate;
                microCompositeEndDate = checkCDA_VolumeProfile.MicroCompositeEndDate;
                checkCDA_VolumeProfile.MicroCompositeFillColor = microCompositeFillColor;
                microCompositeFillColor = checkCDA_VolumeProfile.MicroCompositeFillColor;
                checkCDA_VolumeProfile.MicroCompositeOpacity = microCompositeOpacity;
                microCompositeOpacity = checkCDA_VolumeProfile.MicroCompositeOpacity;
                checkCDA_VolumeProfile.MicroCompositeOpacityToolLabel = microCompositeOpacityToolLabel;
                microCompositeOpacityToolLabel = checkCDA_VolumeProfile.MicroCompositeOpacityToolLabel;
                checkCDA_VolumeProfile.MicroCompositeOutlineColor = microCompositeOutlineColor;
                microCompositeOutlineColor = checkCDA_VolumeProfile.MicroCompositeOutlineColor;
                checkCDA_VolumeProfile.MicroCompositeScale = microCompositeScale;
                microCompositeScale = checkCDA_VolumeProfile.MicroCompositeScale;
                checkCDA_VolumeProfile.MicroCompositeScaleToolLabel = microCompositeScaleToolLabel;
                microCompositeScaleToolLabel = checkCDA_VolumeProfile.MicroCompositeScaleToolLabel;
                checkCDA_VolumeProfile.MicroCompositeSelectToolLabel = microCompositeSelectToolLabel;
                microCompositeSelectToolLabel = checkCDA_VolumeProfile.MicroCompositeSelectToolLabel;
                checkCDA_VolumeProfile.MicroCompositeSmoothingFactorToolLabel = microCompositeSmoothingFactorToolLabel;
                microCompositeSmoothingFactorToolLabel = checkCDA_VolumeProfile.MicroCompositeSmoothingFactorToolLabel;
                checkCDA_VolumeProfile.MicroCompositeVNToolLabel = microCompositeVNToolLabel;
                microCompositeVNToolLabel = checkCDA_VolumeProfile.MicroCompositeVNToolLabel;
                checkCDA_VolumeProfile.MicroCompSmoothingFactor = microCompSmoothingFactor;
                microCompSmoothingFactor = checkCDA_VolumeProfile.MicroCompSmoothingFactor;
                checkCDA_VolumeProfile.MicroCompSquareOutline = microCompSquareOutline;
                microCompSquareOutline = checkCDA_VolumeProfile.MicroCompSquareOutline;
                checkCDA_VolumeProfile.MicroCVPOCColor = microCVPOCColor;
                microCVPOCColor = checkCDA_VolumeProfile.MicroCVPOCColor;
                checkCDA_VolumeProfile.MicroCVPOCLabel = microCVPOCLabel;
                microCVPOCLabel = checkCDA_VolumeProfile.MicroCVPOCLabel;
                checkCDA_VolumeProfile.MicroCVPOCLineStyle = microCVPOCLineStyle;
                microCVPOCLineStyle = checkCDA_VolumeProfile.MicroCVPOCLineStyle;
                checkCDA_VolumeProfile.MicroCVPOCLineWidth = microCVPOCLineWidth;
                microCVPOCLineWidth = checkCDA_VolumeProfile.MicroCVPOCLineWidth;
                checkCDA_VolumeProfile.MicroValueNodeStrength = microValueNodeStrength;
                microValueNodeStrength = checkCDA_VolumeProfile.MicroValueNodeStrength;
                checkCDA_VolumeProfile.MidPtColor = midPtColor;
                midPtColor = checkCDA_VolumeProfile.MidPtColor;
                checkCDA_VolumeProfile.MidPtLabel = midPtLabel;
                midPtLabel = checkCDA_VolumeProfile.MidPtLabel;
                checkCDA_VolumeProfile.MidPtLineStyle = midPtLineStyle;
                midPtLineStyle = checkCDA_VolumeProfile.MidPtLineStyle;
                checkCDA_VolumeProfile.MidPtLineWidth = midPtLineWidth;
                midPtLineWidth = checkCDA_VolumeProfile.MidPtLineWidth;
                checkCDA_VolumeProfile.MinVAPCacheFileDate = minVAPCacheFileDate;
                minVAPCacheFileDate = checkCDA_VolumeProfile.MinVAPCacheFileDate;
                checkCDA_VolumeProfile.MinVBCacheFileDate = minVBCacheFileDate;
                minVBCacheFileDate = checkCDA_VolumeProfile.MinVBCacheFileDate;
                checkCDA_VolumeProfile.MultiplierStdDev1 = multiplierStdDev1;
                multiplierStdDev1 = checkCDA_VolumeProfile.MultiplierStdDev1;
                checkCDA_VolumeProfile.MultiplierStdDev2 = multiplierStdDev2;
                multiplierStdDev2 = checkCDA_VolumeProfile.MultiplierStdDev2;
                checkCDA_VolumeProfile.MultiplierStdDev3 = multiplierStdDev3;
                multiplierStdDev3 = checkCDA_VolumeProfile.MultiplierStdDev3;
                checkCDA_VolumeProfile.NHighColor = nHighColor;
                nHighColor = checkCDA_VolumeProfile.NHighColor;
                checkCDA_VolumeProfile.NHighLabel = nHighLabel;
                nHighLabel = checkCDA_VolumeProfile.NHighLabel;
                checkCDA_VolumeProfile.NHLAlertEnabled = nHLAlertEnabled;
                nHLAlertEnabled = checkCDA_VolumeProfile.NHLAlertEnabled;
                checkCDA_VolumeProfile.NHLAlertSoundFile = nHLAlertSoundFile;
                nHLAlertSoundFile = checkCDA_VolumeProfile.NHLAlertSoundFile;
                checkCDA_VolumeProfile.NHLAppendDate = nHLAppendDate;
                nHLAppendDate = checkCDA_VolumeProfile.NHLAppendDate;
                checkCDA_VolumeProfile.NHLAppendPrice = nHLAppendPrice;
                nHLAppendPrice = checkCDA_VolumeProfile.NHLAppendPrice;
                checkCDA_VolumeProfile.NHLFont = nHLFont;
                nHLFont = checkCDA_VolumeProfile.NHLFont;
                checkCDA_VolumeProfile.NHLLineStyle = nHLLineStyle;
                nHLLineStyle = checkCDA_VolumeProfile.NHLLineStyle;
                checkCDA_VolumeProfile.NHLLineWidth = nHLLineWidth;
                nHLLineWidth = checkCDA_VolumeProfile.NHLLineWidth;
                checkCDA_VolumeProfile.NIBAlertEnabled = nIBAlertEnabled;
                nIBAlertEnabled = checkCDA_VolumeProfile.NIBAlertEnabled;
                checkCDA_VolumeProfile.NIBAlertSoundFile = nIBAlertSoundFile;
                nIBAlertSoundFile = checkCDA_VolumeProfile.NIBAlertSoundFile;
                checkCDA_VolumeProfile.NIBAppendDate = nIBAppendDate;
                nIBAppendDate = checkCDA_VolumeProfile.NIBAppendDate;
                checkCDA_VolumeProfile.NIBAppendPrice = nIBAppendPrice;
                nIBAppendPrice = checkCDA_VolumeProfile.NIBAppendPrice;
                checkCDA_VolumeProfile.NIBColor = nIBColor;
                nIBColor = checkCDA_VolumeProfile.NIBColor;
                checkCDA_VolumeProfile.NIBFont = nIBFont;
                nIBFont = checkCDA_VolumeProfile.NIBFont;
                checkCDA_VolumeProfile.NIBHLabel = nIBHLabel;
                nIBHLabel = checkCDA_VolumeProfile.NIBHLabel;
                checkCDA_VolumeProfile.NIBLineStyle = nIBLineStyle;
                nIBLineStyle = checkCDA_VolumeProfile.NIBLineStyle;
                checkCDA_VolumeProfile.NIBLineWidth = nIBLineWidth;
                nIBLineWidth = checkCDA_VolumeProfile.NIBLineWidth;
                checkCDA_VolumeProfile.NIBLLabel = nIBLLabel;
                nIBLLabel = checkCDA_VolumeProfile.NIBLLabel;
                checkCDA_VolumeProfile.NLowColor = nLowColor;
                nLowColor = checkCDA_VolumeProfile.NLowColor;
                checkCDA_VolumeProfile.NLowLabel = nLowLabel;
                nLowLabel = checkCDA_VolumeProfile.NLowLabel;
                checkCDA_VolumeProfile.NVAAlertEnabled = nVAAlertEnabled;
                nVAAlertEnabled = checkCDA_VolumeProfile.NVAAlertEnabled;
                checkCDA_VolumeProfile.NVAAlertSoundFile = nVAAlertSoundFile;
                nVAAlertSoundFile = checkCDA_VolumeProfile.NVAAlertSoundFile;
                checkCDA_VolumeProfile.NVAAppendDate = nVAAppendDate;
                nVAAppendDate = checkCDA_VolumeProfile.NVAAppendDate;
                checkCDA_VolumeProfile.NVAAppendPrice = nVAAppendPrice;
                nVAAppendPrice = checkCDA_VolumeProfile.NVAAppendPrice;
                checkCDA_VolumeProfile.NVAColor = nVAColor;
                nVAColor = checkCDA_VolumeProfile.NVAColor;
                checkCDA_VolumeProfile.NVAFont = nVAFont;
                nVAFont = checkCDA_VolumeProfile.NVAFont;
                checkCDA_VolumeProfile.NVAHLabel = nVAHLabel;
                nVAHLabel = checkCDA_VolumeProfile.NVAHLabel;
                checkCDA_VolumeProfile.NVALineStyle = nVALineStyle;
                nVALineStyle = checkCDA_VolumeProfile.NVALineStyle;
                checkCDA_VolumeProfile.NVALineWidth = nVALineWidth;
                nVALineWidth = checkCDA_VolumeProfile.NVALineWidth;
                checkCDA_VolumeProfile.NVALLabel = nVALLabel;
                nVALLabel = checkCDA_VolumeProfile.NVALLabel;
                checkCDA_VolumeProfile.NVPOCAlertEnabled = nVPOCAlertEnabled;
                nVPOCAlertEnabled = checkCDA_VolumeProfile.NVPOCAlertEnabled;
                checkCDA_VolumeProfile.NVPOCAlertSoundFile = nVPOCAlertSoundFile;
                nVPOCAlertSoundFile = checkCDA_VolumeProfile.NVPOCAlertSoundFile;
                checkCDA_VolumeProfile.NVPOCAppendDate = nVPOCAppendDate;
                nVPOCAppendDate = checkCDA_VolumeProfile.NVPOCAppendDate;
                checkCDA_VolumeProfile.NVPOCAppendPrice = nVPOCAppendPrice;
                nVPOCAppendPrice = checkCDA_VolumeProfile.NVPOCAppendPrice;
                checkCDA_VolumeProfile.NVPOCColor = nVPOCColor;
                nVPOCColor = checkCDA_VolumeProfile.NVPOCColor;
                checkCDA_VolumeProfile.NVPOCFont = nVPOCFont;
                nVPOCFont = checkCDA_VolumeProfile.NVPOCFont;
                checkCDA_VolumeProfile.NVPOCLabel = nVPOCLabel;
                nVPOCLabel = checkCDA_VolumeProfile.NVPOCLabel;
                checkCDA_VolumeProfile.NVPOCLineStyle = nVPOCLineStyle;
                nVPOCLineStyle = checkCDA_VolumeProfile.NVPOCLineStyle;
                checkCDA_VolumeProfile.NVPOCLineWidth = nVPOCLineWidth;
                nVPOCLineWidth = checkCDA_VolumeProfile.NVPOCLineWidth;
                checkCDA_VolumeProfile.OpacitySD1 = opacitySD1;
                opacitySD1 = checkCDA_VolumeProfile.OpacitySD1;
                checkCDA_VolumeProfile.OpacitySD2 = opacitySD2;
                opacitySD2 = checkCDA_VolumeProfile.OpacitySD2;
                checkCDA_VolumeProfile.OpacitySD3 = opacitySD3;
                opacitySD3 = checkCDA_VolumeProfile.OpacitySD3;
                checkCDA_VolumeProfile.OpenColor = openColor;
                openColor = checkCDA_VolumeProfile.OpenColor;
                checkCDA_VolumeProfile.OpenLabel = openLabel;
                openLabel = checkCDA_VolumeProfile.OpenLabel;
                checkCDA_VolumeProfile.OpenLineStyle = openLineStyle;
                openLineStyle = checkCDA_VolumeProfile.OpenLineStyle;
                checkCDA_VolumeProfile.OpenLineWidth = openLineWidth;
                openLineWidth = checkCDA_VolumeProfile.OpenLineWidth;
                checkCDA_VolumeProfile.OpenSwingMaxMinutes = openSwingMaxMinutes;
                openSwingMaxMinutes = checkCDA_VolumeProfile.OpenSwingMaxMinutes;
                checkCDA_VolumeProfile.OperationalMode = operationalMode;
                operationalMode = checkCDA_VolumeProfile.OperationalMode;
                checkCDA_VolumeProfile.OSColor = oSColor;
                oSColor = checkCDA_VolumeProfile.OSColor;
                checkCDA_VolumeProfile.OSHLabel = oSHLabel;
                oSHLabel = checkCDA_VolumeProfile.OSHLabel;
                checkCDA_VolumeProfile.OSLineStyle = oSLineStyle;
                oSLineStyle = checkCDA_VolumeProfile.OSLineStyle;
                checkCDA_VolumeProfile.OSLineWidth = oSLineWidth;
                oSLineWidth = checkCDA_VolumeProfile.OSLineWidth;
                checkCDA_VolumeProfile.OSLLabel = oSLLabel;
                oSLLabel = checkCDA_VolumeProfile.OSLLabel;
                checkCDA_VolumeProfile.OvernightDefaultColor = overnightDefaultColor;
                overnightDefaultColor = checkCDA_VolumeProfile.OvernightDefaultColor;
                checkCDA_VolumeProfile.OvernightDisplayPeriodHL = overnightDisplayPeriodHL;
                overnightDisplayPeriodHL = checkCDA_VolumeProfile.OvernightDisplayPeriodHL;
                checkCDA_VolumeProfile.OvernightDisplayPeriodVPOC = overnightDisplayPeriodVPOC;
                overnightDisplayPeriodVPOC = checkCDA_VolumeProfile.OvernightDisplayPeriodVPOC;
                checkCDA_VolumeProfile.OvernightFont = overnightFont;
                overnightFont = checkCDA_VolumeProfile.OvernightFont;
                checkCDA_VolumeProfile.OvernightHighColor = overnightHighColor;
                overnightHighColor = checkCDA_VolumeProfile.OvernightHighColor;
                checkCDA_VolumeProfile.OvernightHighLabel = overnightHighLabel;
                overnightHighLabel = checkCDA_VolumeProfile.OvernightHighLabel;
                checkCDA_VolumeProfile.OvernightHighLineStyle = overnightHighLineStyle;
                overnightHighLineStyle = checkCDA_VolumeProfile.OvernightHighLineStyle;
                checkCDA_VolumeProfile.OvernightHighLineWidth = overnightHighLineWidth;
                overnightHighLineWidth = checkCDA_VolumeProfile.OvernightHighLineWidth;
                checkCDA_VolumeProfile.OvernightLowColor = overnightLowColor;
                overnightLowColor = checkCDA_VolumeProfile.OvernightLowColor;
                checkCDA_VolumeProfile.OvernightLowLabel = overnightLowLabel;
                overnightLowLabel = checkCDA_VolumeProfile.OvernightLowLabel;
                checkCDA_VolumeProfile.OvernightLowLineStyle = overnightLowLineStyle;
                overnightLowLineStyle = checkCDA_VolumeProfile.OvernightLowLineStyle;
                checkCDA_VolumeProfile.OvernightLowLineWidth = overnightLowLineWidth;
                overnightLowLineWidth = checkCDA_VolumeProfile.OvernightLowLineWidth;
                checkCDA_VolumeProfile.OvernightStatsSessionName = overnightStatsSessionName;
                overnightStatsSessionName = checkCDA_VolumeProfile.OvernightStatsSessionName;
                checkCDA_VolumeProfile.OvernightVPOCColor = overnightVPOCColor;
                overnightVPOCColor = checkCDA_VolumeProfile.OvernightVPOCColor;
                checkCDA_VolumeProfile.OvernightVPOCLabel = overnightVPOCLabel;
                overnightVPOCLabel = checkCDA_VolumeProfile.OvernightVPOCLabel;
                checkCDA_VolumeProfile.OvernightVPOCLineStyle = overnightVPOCLineStyle;
                overnightVPOCLineStyle = checkCDA_VolumeProfile.OvernightVPOCLineStyle;
                checkCDA_VolumeProfile.OvernightVPOCLineWidth = overnightVPOCLineWidth;
                overnightVPOCLineWidth = checkCDA_VolumeProfile.OvernightVPOCLineWidth;
                checkCDA_VolumeProfile.PlotCD = plotCD;
                plotCD = checkCDA_VolumeProfile.PlotCD;
                checkCDA_VolumeProfile.RebuildVAPCache = rebuildVAPCache;
                rebuildVAPCache = checkCDA_VolumeProfile.RebuildVAPCache;
                checkCDA_VolumeProfile.RebuildVBCache = rebuildVBCache;
                rebuildVBCache = checkCDA_VolumeProfile.RebuildVBCache;
                checkCDA_VolumeProfile.RefreshCompositeCacheFile = refreshCompositeCacheFile;
                refreshCompositeCacheFile = checkCDA_VolumeProfile.RefreshCompositeCacheFile;
                checkCDA_VolumeProfile.ResetCDatBar = resetCDatBar;
                resetCDatBar = checkCDA_VolumeProfile.ResetCDatBar;
                checkCDA_VolumeProfile.RolloverOffset = rolloverOffset;
                rolloverOffset = checkCDA_VolumeProfile.RolloverOffset;
                checkCDA_VolumeProfile.RolloverToContractMonth = rolloverToContractMonth;
                rolloverToContractMonth = checkCDA_VolumeProfile.RolloverToContractMonth;
                checkCDA_VolumeProfile.RolloverVAPCache = rolloverVAPCache;
                rolloverVAPCache = checkCDA_VolumeProfile.RolloverVAPCache;
                checkCDA_VolumeProfile.RootFolder = rootFolder;
                rootFolder = checkCDA_VolumeProfile.RootFolder;
                checkCDA_VolumeProfile.RunLogFileDir = runLogFileDir;
                runLogFileDir = checkCDA_VolumeProfile.RunLogFileDir;
                checkCDA_VolumeProfile.RunLogFilename = runLogFilename;
                runLogFilename = checkCDA_VolumeProfile.RunLogFilename;
                checkCDA_VolumeProfile.SaveVBData = saveVBData;
                saveVBData = checkCDA_VolumeProfile.SaveVBData;
                checkCDA_VolumeProfile.SessionAnchorOffset = sessionAnchorOffset;
                sessionAnchorOffset = checkCDA_VolumeProfile.SessionAnchorOffset;
                checkCDA_VolumeProfile.SessionAnchorOffsetToolLabel = sessionAnchorOffsetToolLabel;
                sessionAnchorOffsetToolLabel = checkCDA_VolumeProfile.SessionAnchorOffsetToolLabel;
                checkCDA_VolumeProfile.SessionAnchorPosition = sessionAnchorPosition;
                sessionAnchorPosition = checkCDA_VolumeProfile.SessionAnchorPosition;
                checkCDA_VolumeProfile.SessionAnchorPositionToolLabel = sessionAnchorPositionToolLabel;
                sessionAnchorPositionToolLabel = checkCDA_VolumeProfile.SessionAnchorPositionToolLabel;
                checkCDA_VolumeProfile.SessionCDvapHeading = sessionCDvapHeading;
                sessionCDvapHeading = checkCDA_VolumeProfile.SessionCDvapHeading;
                checkCDA_VolumeProfile.SessionFillColor = sessionFillColor;
                sessionFillColor = checkCDA_VolumeProfile.SessionFillColor;
                checkCDA_VolumeProfile.SessionOpacity = sessionOpacity;
                sessionOpacity = checkCDA_VolumeProfile.SessionOpacity;
                checkCDA_VolumeProfile.SessionOpacityToolLabel = sessionOpacityToolLabel;
                sessionOpacityToolLabel = checkCDA_VolumeProfile.SessionOpacityToolLabel;
                checkCDA_VolumeProfile.SessionOutlineColor = sessionOutlineColor;
                sessionOutlineColor = checkCDA_VolumeProfile.SessionOutlineColor;
                checkCDA_VolumeProfile.SessionScale = sessionScale;
                sessionScale = checkCDA_VolumeProfile.SessionScale;
                checkCDA_VolumeProfile.SessionScaleToolLabel = sessionScaleToolLabel;
                sessionScaleToolLabel = checkCDA_VolumeProfile.SessionScaleToolLabel;
                checkCDA_VolumeProfile.SessionSquareOutline = sessionSquareOutline;
                sessionSquareOutline = checkCDA_VolumeProfile.SessionSquareOutline;
                checkCDA_VolumeProfile.SessionVolumeFont = sessionVolumeFont;
                sessionVolumeFont = checkCDA_VolumeProfile.SessionVolumeFont;
                checkCDA_VolumeProfile.ShowBigPrints = showBigPrints;
                showBigPrints = checkCDA_VolumeProfile.ShowBigPrints;
                checkCDA_VolumeProfile.ShowBPHLine = showBPHLine;
                showBPHLine = checkCDA_VolumeProfile.ShowBPHLine;
                checkCDA_VolumeProfile.ShowBPVLine = showBPVLine;
                showBPVLine = checkCDA_VolumeProfile.ShowBPVLine;
                checkCDA_VolumeProfile.ShowCDAtEachPrice = showCDAtEachPrice;
                showCDAtEachPrice = checkCDA_VolumeProfile.ShowCDAtEachPrice;
                checkCDA_VolumeProfile.ShowCompositeBeginDate = showCompositeBeginDate;
                showCompositeBeginDate = checkCDA_VolumeProfile.ShowCompositeBeginDate;
                checkCDA_VolumeProfile.ShowCompositeProfile = showCompositeProfile;
                showCompositeProfile = checkCDA_VolumeProfile.ShowCompositeProfile;
                checkCDA_VolumeProfile.ShowCompositeVolumes = showCompositeVolumes;
                showCompositeVolumes = checkCDA_VolumeProfile.ShowCompositeVolumes;
                checkCDA_VolumeProfile.ShowCompValueNodePrice = showCompValueNodePrice;
                showCompValueNodePrice = checkCDA_VolumeProfile.ShowCompValueNodePrice;
                checkCDA_VolumeProfile.ShowCompValueNodes = showCompValueNodes;
                showCompValueNodes = checkCDA_VolumeProfile.ShowCompValueNodes;
                checkCDA_VolumeProfile.ShowGaps = showGaps;
                showGaps = checkCDA_VolumeProfile.ShowGaps;
                checkCDA_VolumeProfile.ShowIB = showIB;
                showIB = checkCDA_VolumeProfile.ShowIB;
                checkCDA_VolumeProfile.ShowIB15x = showIB15x;
                showIB15x = checkCDA_VolumeProfile.ShowIB15x;
                checkCDA_VolumeProfile.ShowIB2x = showIB2x;
                showIB2x = checkCDA_VolumeProfile.ShowIB2x;
                checkCDA_VolumeProfile.ShowIBRange = showIBRange;
                showIBRange = checkCDA_VolumeProfile.ShowIBRange;
                checkCDA_VolumeProfile.ShowLabels = showLabels;
                showLabels = checkCDA_VolumeProfile.ShowLabels;
                checkCDA_VolumeProfile.ShowMCVA = showMCVA;
                showMCVA = checkCDA_VolumeProfile.ShowMCVA;
                checkCDA_VolumeProfile.ShowMicroCompositeDates = showMicroCompositeDates;
                showMicroCompositeDates = checkCDA_VolumeProfile.ShowMicroCompositeDates;
                checkCDA_VolumeProfile.ShowMicroCompositeProfile = showMicroCompositeProfile;
                showMicroCompositeProfile = checkCDA_VolumeProfile.ShowMicroCompositeProfile;
                checkCDA_VolumeProfile.ShowMicroCompositeVolumes = showMicroCompositeVolumes;
                showMicroCompositeVolumes = checkCDA_VolumeProfile.ShowMicroCompositeVolumes;
                checkCDA_VolumeProfile.ShowMicroCompValueNodePrice = showMicroCompValueNodePrice;
                showMicroCompValueNodePrice = checkCDA_VolumeProfile.ShowMicroCompValueNodePrice;
                checkCDA_VolumeProfile.ShowMicroCompValueNodes = showMicroCompValueNodes;
                showMicroCompValueNodes = checkCDA_VolumeProfile.ShowMicroCompValueNodes;
                checkCDA_VolumeProfile.ShowNHLs = showNHLs;
                showNHLs = checkCDA_VolumeProfile.ShowNHLs;
                checkCDA_VolumeProfile.ShowNIBs = showNIBs;
                showNIBs = checkCDA_VolumeProfile.ShowNIBs;
                checkCDA_VolumeProfile.ShowNVAs = showNVAs;
                showNVAs = checkCDA_VolumeProfile.ShowNVAs;
                checkCDA_VolumeProfile.ShowNVPOCs = showNVPOCs;
                showNVPOCs = checkCDA_VolumeProfile.ShowNVPOCs;
                checkCDA_VolumeProfile.ShowOHMLC = showOHMLC;
                showOHMLC = checkCDA_VolumeProfile.ShowOHMLC;
                checkCDA_VolumeProfile.ShowOS = showOS;
                showOS = checkCDA_VolumeProfile.ShowOS;
                checkCDA_VolumeProfile.ShowOvernightStats = showOvernightStats;
                showOvernightStats = checkCDA_VolumeProfile.ShowOvernightStats;
                checkCDA_VolumeProfile.ShowPriceWithLabel = showPriceWithLabel;
                showPriceWithLabel = checkCDA_VolumeProfile.ShowPriceWithLabel;
                checkCDA_VolumeProfile.ShowSessionImbalanceFactor = showSessionImbalanceFactor;
                showSessionImbalanceFactor = checkCDA_VolumeProfile.ShowSessionImbalanceFactor;
                checkCDA_VolumeProfile.ShowSessionProfile = showSessionProfile;
                showSessionProfile = checkCDA_VolumeProfile.ShowSessionProfile;
                checkCDA_VolumeProfile.ShowSessionRange = showSessionRange;
                showSessionRange = checkCDA_VolumeProfile.ShowSessionRange;
                checkCDA_VolumeProfile.ShowSessionVolumes = showSessionVolumes;
                showSessionVolumes = checkCDA_VolumeProfile.ShowSessionVolumes;
                checkCDA_VolumeProfile.ShowStartupMessages = showStartupMessages;
                showStartupMessages = checkCDA_VolumeProfile.ShowStartupMessages;
                checkCDA_VolumeProfile.ShowToolBar = showToolBar;
                showToolBar = checkCDA_VolumeProfile.ShowToolBar;
                checkCDA_VolumeProfile.ShowTrendChange = showTrendChange;
                showTrendChange = checkCDA_VolumeProfile.ShowTrendChange;
                checkCDA_VolumeProfile.ShowVA = showVA;
                showVA = checkCDA_VolumeProfile.ShowVA;
                checkCDA_VolumeProfile.ShowVARange = showVARange;
                showVARange = checkCDA_VolumeProfile.ShowVARange;
                checkCDA_VolumeProfile.ShowVPOC = showVPOC;
                showVPOC = checkCDA_VolumeProfile.ShowVPOC;
                checkCDA_VolumeProfile.ShowVPOCTrack = showVPOCTrack;
                showVPOCTrack = checkCDA_VolumeProfile.ShowVPOCTrack;
                checkCDA_VolumeProfile.SlowPeriod = slowPeriod;
                slowPeriod = checkCDA_VolumeProfile.SlowPeriod;
                checkCDA_VolumeProfile.StandardCDHeading = standardCDHeading;
                standardCDHeading = checkCDA_VolumeProfile.StandardCDHeading;
                checkCDA_VolumeProfile.StaticMCEnabled = staticMCEnabled;
                staticMCEnabled = checkCDA_VolumeProfile.StaticMCEnabled;
                checkCDA_VolumeProfile.Threshold = threshold;
                threshold = checkCDA_VolumeProfile.Threshold;
                checkCDA_VolumeProfile.ToolBarHideDropDownLabel = toolBarHideDropDownLabel;
                toolBarHideDropDownLabel = checkCDA_VolumeProfile.ToolBarHideDropDownLabel;
                checkCDA_VolumeProfile.ToolBarTextColor = toolBarTextColor;
                toolBarTextColor = checkCDA_VolumeProfile.ToolBarTextColor;
                checkCDA_VolumeProfile.ToolBarTextFont = toolBarTextFont;
                toolBarTextFont = checkCDA_VolumeProfile.ToolBarTextFont;
                checkCDA_VolumeProfile.ToolBarTextFontOnFocus = toolBarTextFontOnFocus;
                toolBarTextFontOnFocus = checkCDA_VolumeProfile.ToolBarTextFontOnFocus;
                checkCDA_VolumeProfile.TrendCDvapHeading = trendCDvapHeading;
                trendCDvapHeading = checkCDA_VolumeProfile.TrendCDvapHeading;
                checkCDA_VolumeProfile.TrendChangeDownColor = trendChangeDownColor;
                trendChangeDownColor = checkCDA_VolumeProfile.TrendChangeDownColor;
                checkCDA_VolumeProfile.TrendChangeUpColor = trendChangeUpColor;
                trendChangeUpColor = checkCDA_VolumeProfile.TrendChangeUpColor;
                checkCDA_VolumeProfile.UpdateInRealtimeEnabled = updateInRealtimeEnabled;
                updateInRealtimeEnabled = checkCDA_VolumeProfile.UpdateInRealtimeEnabled;
                checkCDA_VolumeProfile.VAColor = vAColor;
                vAColor = checkCDA_VolumeProfile.VAColor;
                checkCDA_VolumeProfile.VAHLabel = vAHLabel;
                vAHLabel = checkCDA_VolumeProfile.VAHLabel;
                checkCDA_VolumeProfile.VALineStyle = vALineStyle;
                vALineStyle = checkCDA_VolumeProfile.VALineStyle;
                checkCDA_VolumeProfile.VALineWidth = vALineWidth;
                vALineWidth = checkCDA_VolumeProfile.VALineWidth;
                checkCDA_VolumeProfile.VALLabel = vALLabel;
                vALLabel = checkCDA_VolumeProfile.VALLabel;
                checkCDA_VolumeProfile.VAOpacity = vAOpacity;
                vAOpacity = checkCDA_VolumeProfile.VAOpacity;
                checkCDA_VolumeProfile.VAPercent = vAPercent;
                vAPercent = checkCDA_VolumeProfile.VAPercent;
                checkCDA_VolumeProfile.VPOCColor = vPOCColor;
                vPOCColor = checkCDA_VolumeProfile.VPOCColor;
                checkCDA_VolumeProfile.VPOCLabel = vPOCLabel;
                vPOCLabel = checkCDA_VolumeProfile.VPOCLabel;
                checkCDA_VolumeProfile.VPOCLineStyle = vPOCLineStyle;
                vPOCLineStyle = checkCDA_VolumeProfile.VPOCLineStyle;
                checkCDA_VolumeProfile.VPOCLineWidth = vPOCLineWidth;
                vPOCLineWidth = checkCDA_VolumeProfile.VPOCLineWidth;
                checkCDA_VolumeProfile.VWAPColor = vWAPColor;
                vWAPColor = checkCDA_VolumeProfile.VWAPColor;
                checkCDA_VolumeProfile.VWAPLabel = vWAPLabel;
                vWAPLabel = checkCDA_VolumeProfile.VWAPLabel;
                checkCDA_VolumeProfile.VWAPLineStyle = vWAPLineStyle;
                vWAPLineStyle = checkCDA_VolumeProfile.VWAPLineStyle;
                checkCDA_VolumeProfile.VWAPLineWidth = vWAPLineWidth;
                vWAPLineWidth = checkCDA_VolumeProfile.VWAPLineWidth;
                checkCDA_VolumeProfile.VWAPSD1Color = vWAPSD1Color;
                vWAPSD1Color = checkCDA_VolumeProfile.VWAPSD1Color;
                checkCDA_VolumeProfile.VWAPSD1LineStyle = vWAPSD1LineStyle;
                vWAPSD1LineStyle = checkCDA_VolumeProfile.VWAPSD1LineStyle;
                checkCDA_VolumeProfile.VWAPSD1LineWidth = vWAPSD1LineWidth;
                vWAPSD1LineWidth = checkCDA_VolumeProfile.VWAPSD1LineWidth;
                checkCDA_VolumeProfile.VWAPSD2Color = vWAPSD2Color;
                vWAPSD2Color = checkCDA_VolumeProfile.VWAPSD2Color;
                checkCDA_VolumeProfile.VWAPSD2LineStyle = vWAPSD2LineStyle;
                vWAPSD2LineStyle = checkCDA_VolumeProfile.VWAPSD2LineStyle;
                checkCDA_VolumeProfile.VWAPSD2LineWidth = vWAPSD2LineWidth;
                vWAPSD2LineWidth = checkCDA_VolumeProfile.VWAPSD2LineWidth;
                checkCDA_VolumeProfile.VWAPSD3Color = vWAPSD3Color;
                vWAPSD3Color = checkCDA_VolumeProfile.VWAPSD3Color;
                checkCDA_VolumeProfile.VWAPSD3LineStyle = vWAPSD3LineStyle;
                vWAPSD3LineStyle = checkCDA_VolumeProfile.VWAPSD3LineStyle;
                checkCDA_VolumeProfile.VWAPSD3LineWidth = vWAPSD3LineWidth;
                vWAPSD3LineWidth = checkCDA_VolumeProfile.VWAPSD3LineWidth;

                if (cacheCDA_VolumeProfile != null)
                    for (int idx = 0; idx < cacheCDA_VolumeProfile.Length; idx++)
                        if (cacheCDA_VolumeProfile[idx].AboveAskColor == aboveAskColor && cacheCDA_VolumeProfile[idx].AtAskColor == atAskColor && cacheCDA_VolumeProfile[idx].AtBidColor == atBidColor && cacheCDA_VolumeProfile[idx].AutoSaveMicroCompositeSettings == autoSaveMicroCompositeSettings && cacheCDA_VolumeProfile[idx].AutoUpdateMCEndDate == autoUpdateMCEndDate && cacheCDA_VolumeProfile[idx].BelowBidColor == belowBidColor && cacheCDA_VolumeProfile[idx].BigPrintsFileDir == bigPrintsFileDir && cacheCDA_VolumeProfile[idx].BPAlertEnabled == bPAlertEnabled && cacheCDA_VolumeProfile[idx].BPAlertSoundFile == bPAlertSoundFile && cacheCDA_VolumeProfile[idx].BPDisplayCount == bPDisplayCount && cacheCDA_VolumeProfile[idx].BPDisplayMode == bPDisplayMode && cacheCDA_VolumeProfile[idx].BPDisplayPosition == bPDisplayPosition && cacheCDA_VolumeProfile[idx].BPFilterMode == bPFilterMode && cacheCDA_VolumeProfile[idx].BPHLineStyle == bPHLineStyle && cacheCDA_VolumeProfile[idx].BPHLineWidth == bPHLineWidth && cacheCDA_VolumeProfile[idx].BPLabel == bPLabel && cacheCDA_VolumeProfile[idx].BPLabelColor == bPLabelColor && cacheCDA_VolumeProfile[idx].BPLabelFont == bPLabelFont && cacheCDA_VolumeProfile[idx].BPLabelOffset == bPLabelOffset && cacheCDA_VolumeProfile[idx].BPMinVolume == bPMinVolume && cacheCDA_VolumeProfile[idx].BPMulipleAboveMultipleOfAverageVolume == bPMulipleAboveMultipleOfAverageVolume && cacheCDA_VolumeProfile[idx].BPVLineStyle == bPVLineStyle && cacheCDA_VolumeProfile[idx].BPVLineWidth == bPVLineWidth && cacheCDA_VolumeProfile[idx].CalcMode == calcMode && cacheCDA_VolumeProfile[idx].CD0Label == cD0Label && cacheCDA_VolumeProfile[idx].CD0LineColor == cD0LineColor && cacheCDA_VolumeProfile[idx].CD0LineStyle == cD0LineStyle && cacheCDA_VolumeProfile[idx].CD0LineWidth == cD0LineWidth && cacheCDA_VolumeProfile[idx].CDDownColor == cDDownColor && cacheCDA_VolumeProfile[idx].CDHeadingsColor == cDHeadingsColor && cacheCDA_VolumeProfile[idx].CDHeadingsFont == cDHeadingsFont && cacheCDA_VolumeProfile[idx].CDHighLabel == cDHighLabel && cacheCDA_VolumeProfile[idx].CDHighLineColor == cDHighLineColor && cacheCDA_VolumeProfile[idx].CDHighLineStyle == cDHighLineStyle && cacheCDA_VolumeProfile[idx].CDHighLineWidth == cDHighLineWidth && cacheCDA_VolumeProfile[idx].CDLineStyle == cDLineStyle && cacheCDA_VolumeProfile[idx].CDLineWidth == cDLineWidth && cacheCDA_VolumeProfile[idx].CDLocation == cDLocation && cacheCDA_VolumeProfile[idx].CDLowLabel == cDLowLabel && cacheCDA_VolumeProfile[idx].CDLowLineColor == cDLowLineColor && cacheCDA_VolumeProfile[idx].CDLowLineStyle == cDLowLineStyle && cacheCDA_VolumeProfile[idx].CDLowLineWidth == cDLowLineWidth && cacheCDA_VolumeProfile[idx].CDNeutralColor == cDNeutralColor && cacheCDA_VolumeProfile[idx].CDPlotLabel == cDPlotLabel && cacheCDA_VolumeProfile[idx].CDUpColor == cDUpColor && cacheCDA_VolumeProfile[idx].CDValueFont == cDValueFont && cacheCDA_VolumeProfile[idx].CHVNBandColor == cHVNBandColor && cacheCDA_VolumeProfile[idx].CHVNBandOpacity == cHVNBandOpacity && cacheCDA_VolumeProfile[idx].CHVNBandOpacityToolLabel == cHVNBandOpacityToolLabel && cacheCDA_VolumeProfile[idx].CHVNBandWidth == cHVNBandWidth && cacheCDA_VolumeProfile[idx].CHVNLineColor == cHVNLineColor && cacheCDA_VolumeProfile[idx].CHVNLineStyle == cHVNLineStyle && cacheCDA_VolumeProfile[idx].CHVNLineWidth == cHVNLineWidth && cacheCDA_VolumeProfile[idx].CloseColor == closeColor && cacheCDA_VolumeProfile[idx].CloseLabel == closeLabel && cacheCDA_VolumeProfile[idx].CloseLineStyle == closeLineStyle && cacheCDA_VolumeProfile[idx].CloseLineWidth == closeLineWidth && cacheCDA_VolumeProfile[idx].CLVNBandColor == cLVNBandColor && cacheCDA_VolumeProfile[idx].CLVNBandOpacity == cLVNBandOpacity && cacheCDA_VolumeProfile[idx].CLVNBandOpacityToolLabel == cLVNBandOpacityToolLabel && cacheCDA_VolumeProfile[idx].CLVNBandWidth == cLVNBandWidth && cacheCDA_VolumeProfile[idx].CLVNLineColor == cLVNLineColor && cacheCDA_VolumeProfile[idx].CLVNLineStyle == cLVNLineStyle && cacheCDA_VolumeProfile[idx].CLVNLineWidth == cLVNLineWidth && cacheCDA_VolumeProfile[idx].CompositeAnchorOffset == compositeAnchorOffset && cacheCDA_VolumeProfile[idx].CompositeAnchorOffsetToolLabel == compositeAnchorOffsetToolLabel && cacheCDA_VolumeProfile[idx].CompositeAnchorPosition == compositeAnchorPosition && cacheCDA_VolumeProfile[idx].CompositeAnchorPositionToolLabel == compositeAnchorPositionToolLabel && cacheCDA_VolumeProfile[idx].CompositeBeginDate == compositeBeginDate && cacheCDA_VolumeProfile[idx].CompositeBeginDateToolLabel == compositeBeginDateToolLabel && cacheCDA_VolumeProfile[idx].CompositeFillColor == compositeFillColor && cacheCDA_VolumeProfile[idx].CompositeOpacity == compositeOpacity && cacheCDA_VolumeProfile[idx].CompositeOpacityToolLabel == compositeOpacityToolLabel && cacheCDA_VolumeProfile[idx].CompositeOutlineColor == compositeOutlineColor && Math.Abs(cacheCDA_VolumeProfile[idx].CompositeScale - compositeScale) <= double.Epsilon && cacheCDA_VolumeProfile[idx].CompositeScaleToolLabel == compositeScaleToolLabel && Math.Abs(cacheCDA_VolumeProfile[idx].CompositeSmoothingFactor - compositeSmoothingFactor) <= double.Epsilon && cacheCDA_VolumeProfile[idx].CompositeSmoothingFactorToolLabel == compositeSmoothingFactorToolLabel && cacheCDA_VolumeProfile[idx].CompositeSquareOutline == compositeSquareOutline && cacheCDA_VolumeProfile[idx].CompositeVNToolLabel == compositeVNToolLabel && cacheCDA_VolumeProfile[idx].CompValueNodeStrength == compValueNodeStrength && cacheCDA_VolumeProfile[idx].CurrentSessionAnchorPosition == currentSessionAnchorPosition && cacheCDA_VolumeProfile[idx].CVPOCColor == cVPOCColor && cacheCDA_VolumeProfile[idx].CVPOCLabel == cVPOCLabel && cacheCDA_VolumeProfile[idx].CVPOCLineStyle == cVPOCLineStyle && cacheCDA_VolumeProfile[idx].CVPOCLineWidth == cVPOCLineWidth && cacheCDA_VolumeProfile[idx].DataFileDir == dataFileDir && cacheCDA_VolumeProfile[idx].DisplayComputedAtBar == displayComputedAtBar && cacheCDA_VolumeProfile[idx].DisplayComputedAtPrice == displayComputedAtPrice && cacheCDA_VolumeProfile[idx].DisplaySD1 == displaySD1 && cacheCDA_VolumeProfile[idx].DisplaySD2 == displaySD2 && cacheCDA_VolumeProfile[idx].DisplaySD3 == displaySD3 && cacheCDA_VolumeProfile[idx].DisplayVABand == displayVABand && cacheCDA_VolumeProfile[idx].DrawCD0 == drawCD0 && cacheCDA_VolumeProfile[idx].DrawCDHighLow == drawCDHighLow && cacheCDA_VolumeProfile[idx].EmailAddress == emailAddress && cacheCDA_VolumeProfile[idx].EmailToAddress == emailToAddress && cacheCDA_VolumeProfile[idx].EnableCD == enableCD && cacheCDA_VolumeProfile[idx].EnableCHVNOpacityTool == enableCHVNOpacityTool && cacheCDA_VolumeProfile[idx].EnableCLVNOpacityTool == enableCLVNOpacityTool && cacheCDA_VolumeProfile[idx].EnableCompositeAnchorOffsetTool == enableCompositeAnchorOffsetTool && cacheCDA_VolumeProfile[idx].EnableCompositeAnchorPositionTool == enableCompositeAnchorPositionTool && cacheCDA_VolumeProfile[idx].EnableCompositeBeginDateTool == enableCompositeBeginDateTool && cacheCDA_VolumeProfile[idx].EnableCompositeHeatmap == enableCompositeHeatmap && cacheCDA_VolumeProfile[idx].EnableCompositeOpacityTool == enableCompositeOpacityTool && cacheCDA_VolumeProfile[idx].EnableCompositeScaleTool == enableCompositeScaleTool && cacheCDA_VolumeProfile[idx].EnableCompositeSmoothingFactorTool == enableCompositeSmoothingFactorTool && cacheCDA_VolumeProfile[idx].EnableCompositeVNTool == enableCompositeVNTool && cacheCDA_VolumeProfile[idx].EnableHideBlockTradesButton == enableHideBlockTradesButton && cacheCDA_VolumeProfile[idx].EnableHideCDsButton == enableHideCDsButton && cacheCDA_VolumeProfile[idx].EnableHideCompositeProfileButton == enableHideCompositeProfileButton && cacheCDA_VolumeProfile[idx].EnableHideCompositeProfileValueNodesButton == enableHideCompositeProfileValueNodesButton && cacheCDA_VolumeProfile[idx].EnableHideMicroCompositeProfilesButton == enableHideMicroCompositeProfilesButton && cacheCDA_VolumeProfile[idx].EnableHideMicroCompositeProfileValueAreasButton == enableHideMicroCompositeProfileValueAreasButton && cacheCDA_VolumeProfile[idx].EnableHideMicroCompositeProfileValueNodesButton == enableHideMicroCompositeProfileValueNodesButton && cacheCDA_VolumeProfile[idx].EnableHideOvernightStatsButton == enableHideOvernightStatsButton && cacheCDA_VolumeProfile[idx].EnableHideSessionProfilesButton == enableHideSessionProfilesButton && cacheCDA_VolumeProfile[idx].EnableMicroCompositeAnchorEdgeTool == enableMicroCompositeAnchorEdgeTool && cacheCDA_VolumeProfile[idx].EnableMicroCompositeAnchorOffsetTool == enableMicroCompositeAnchorOffsetTool && cacheCDA_VolumeProfile[idx].EnableMicroCompositeAnchorPositionTool == enableMicroCompositeAnchorPositionTool && cacheCDA_VolumeProfile[idx].EnableMicroCompositeDateRangeTool == enableMicroCompositeDateRangeTool && cacheCDA_VolumeProfile[idx].EnableMicroCompositeHeatmap == enableMicroCompositeHeatmap && cacheCDA_VolumeProfile[idx].EnableMicroCompositeOpacityTool == enableMicroCompositeOpacityTool && cacheCDA_VolumeProfile[idx].EnableMicroCompositeScaleTool == enableMicroCompositeScaleTool && cacheCDA_VolumeProfile[idx].EnableMicroCompositeSmoothingFactorTool == enableMicroCompositeSmoothingFactorTool && cacheCDA_VolumeProfile[idx].EnableMicroCompositeVNTool == enableMicroCompositeVNTool && cacheCDA_VolumeProfile[idx].EnablePrecisionRangeProfiling == enablePrecisionRangeProfiling && cacheCDA_VolumeProfile[idx].EnableRunLog == enableRunLog && cacheCDA_VolumeProfile[idx].EnableSessionAnchorOffsetTool == enableSessionAnchorOffsetTool && cacheCDA_VolumeProfile[idx].EnableSessionAnchorPositionTool == enableSessionAnchorPositionTool && cacheCDA_VolumeProfile[idx].EnableSessionHeatmap == enableSessionHeatmap && cacheCDA_VolumeProfile[idx].EnableSessionOpacityTool == enableSessionOpacityTool && cacheCDA_VolumeProfile[idx].EnableSessionScaleTool == enableSessionScaleTool && cacheCDA_VolumeProfile[idx].EnableVWAP == enableVWAP && cacheCDA_VolumeProfile[idx].ExportFileDir == exportFileDir && cacheCDA_VolumeProfile[idx].ExportStats == exportStats && cacheCDA_VolumeProfile[idx].FastPeriod == fastPeriod && cacheCDA_VolumeProfile[idx].GAPAlertEnabled == gAPAlertEnabled && cacheCDA_VolumeProfile[idx].GAPAlertSoundFile == gAPAlertSoundFile && cacheCDA_VolumeProfile[idx].GAPAppendDate == gAPAppendDate && cacheCDA_VolumeProfile[idx].GAPAppendPrice == gAPAppendPrice && cacheCDA_VolumeProfile[idx].GAPColor == gAPColor && cacheCDA_VolumeProfile[idx].GAPFont == gAPFont && cacheCDA_VolumeProfile[idx].GAPLabel == gAPLabel && cacheCDA_VolumeProfile[idx].GAPLineStyle == gAPLineStyle && cacheCDA_VolumeProfile[idx].GAPLineWidth == gAPLineWidth && cacheCDA_VolumeProfile[idx].HighColor == highColor && cacheCDA_VolumeProfile[idx].HighLabel == highLabel && cacheCDA_VolumeProfile[idx].HighlightIB == highlightIB && cacheCDA_VolumeProfile[idx].HighlightMCVA == highlightMCVA && cacheCDA_VolumeProfile[idx].HighlightVA == highlightVA && cacheCDA_VolumeProfile[idx].HighLineStyle == highLineStyle && cacheCDA_VolumeProfile[idx].HighLineWidth == highLineWidth && cacheCDA_VolumeProfile[idx].IB15xColor == iB15xColor && cacheCDA_VolumeProfile[idx].IB15xLineStyle == iB15xLineStyle && cacheCDA_VolumeProfile[idx].IB15xLineWidth == iB15xLineWidth && cacheCDA_VolumeProfile[idx].IB2xColor == iB2xColor && cacheCDA_VolumeProfile[idx].IB2xLineStyle == iB2xLineStyle && cacheCDA_VolumeProfile[idx].IB2xLineWidth == iB2xLineWidth && cacheCDA_VolumeProfile[idx].IBColor == iBColor && cacheCDA_VolumeProfile[idx].IBH15xLabel == iBH15xLabel && cacheCDA_VolumeProfile[idx].IBH2xLabel == iBH2xLabel && cacheCDA_VolumeProfile[idx].IBHLabel == iBHLabel && cacheCDA_VolumeProfile[idx].IBL15xLabel == iBL15xLabel && cacheCDA_VolumeProfile[idx].IBL2xLabel == iBL2xLabel && cacheCDA_VolumeProfile[idx].IBLineStyle == iBLineStyle && cacheCDA_VolumeProfile[idx].IBLineWidth == iBLineWidth && cacheCDA_VolumeProfile[idx].IBLLabel == iBLLabel && cacheCDA_VolumeProfile[idx].IBMinutes == iBMinutes && cacheCDA_VolumeProfile[idx].InsideColor == insideColor && cacheCDA_VolumeProfile[idx].LabelDelay == labelDelay && cacheCDA_VolumeProfile[idx].LabelDisplacement == labelDisplacement && cacheCDA_VolumeProfile[idx].LabelFont == labelFont && cacheCDA_VolumeProfile[idx].LoadVBCache == loadVBCache && cacheCDA_VolumeProfile[idx].LowColor == lowColor && cacheCDA_VolumeProfile[idx].LowLabel == lowLabel && cacheCDA_VolumeProfile[idx].LowLineStyle == lowLineStyle && cacheCDA_VolumeProfile[idx].LowLineWidth == lowLineWidth && cacheCDA_VolumeProfile[idx].MCAnchorPositionLabelFollowsValue == mCAnchorPositionLabelFollowsValue && cacheCDA_VolumeProfile[idx].MCBeginEndByManualRect == mCBeginEndByManualRect && cacheCDA_VolumeProfile[idx].MCRectangleTagPrefix == mCRectangleTagPrefix && cacheCDA_VolumeProfile[idx].mcVAColor == mcVAColor && cacheCDA_VolumeProfile[idx].mcVAHLabel == mcVAHLabel && cacheCDA_VolumeProfile[idx].mcVALineStyle == mcVALineStyle && cacheCDA_VolumeProfile[idx].mcVALineWidth == mcVALineWidth && cacheCDA_VolumeProfile[idx].mcVALLabel == mcVALLabel && Math.Abs(cacheCDA_VolumeProfile[idx].mcVAPercent - mcVAPercent) <= double.Epsilon && cacheCDA_VolumeProfile[idx].MicroCHVNColor == microCHVNColor && cacheCDA_VolumeProfile[idx].MicroCHVNLineStyle == microCHVNLineStyle && cacheCDA_VolumeProfile[idx].MicroCHVNLineWidth == microCHVNLineWidth && cacheCDA_VolumeProfile[idx].MicroCLVNColor == microCLVNColor && cacheCDA_VolumeProfile[idx].MicroCLVNLineStyle == microCLVNLineStyle && cacheCDA_VolumeProfile[idx].MicroCLVNLineWidth == microCLVNLineWidth && cacheCDA_VolumeProfile[idx].MicroCompositeAnchorBar == microCompositeAnchorBar && cacheCDA_VolumeProfile[idx].MicroCompositeAnchorEdge == microCompositeAnchorEdge && cacheCDA_VolumeProfile[idx].MicroCompositeAnchorEdgeToolLabel == microCompositeAnchorEdgeToolLabel && cacheCDA_VolumeProfile[idx].MicroCompositeAnchorOffset == microCompositeAnchorOffset && cacheCDA_VolumeProfile[idx].MicroCompositeAnchorOffsetToolLabel == microCompositeAnchorOffsetToolLabel && cacheCDA_VolumeProfile[idx].MicroCompositeAnchorPosition == microCompositeAnchorPosition && cacheCDA_VolumeProfile[idx].MicroCompositeAnchorPositionToolLabel == microCompositeAnchorPositionToolLabel && cacheCDA_VolumeProfile[idx].MicroCompositeBeginDate == microCompositeBeginDate && cacheCDA_VolumeProfile[idx].MicroCompositeDateRangeToolLabel == microCompositeDateRangeToolLabel && cacheCDA_VolumeProfile[idx].MicroCompositeEndDate == microCompositeEndDate && cacheCDA_VolumeProfile[idx].MicroCompositeFillColor == microCompositeFillColor && cacheCDA_VolumeProfile[idx].MicroCompositeOpacity == microCompositeOpacity && cacheCDA_VolumeProfile[idx].MicroCompositeOpacityToolLabel == microCompositeOpacityToolLabel && cacheCDA_VolumeProfile[idx].MicroCompositeOutlineColor == microCompositeOutlineColor && Math.Abs(cacheCDA_VolumeProfile[idx].MicroCompositeScale - microCompositeScale) <= double.Epsilon && cacheCDA_VolumeProfile[idx].MicroCompositeScaleToolLabel == microCompositeScaleToolLabel && cacheCDA_VolumeProfile[idx].MicroCompositeSelectToolLabel == microCompositeSelectToolLabel && cacheCDA_VolumeProfile[idx].MicroCompositeSmoothingFactorToolLabel == microCompositeSmoothingFactorToolLabel && cacheCDA_VolumeProfile[idx].MicroCompositeVNToolLabel == microCompositeVNToolLabel && Math.Abs(cacheCDA_VolumeProfile[idx].MicroCompSmoothingFactor - microCompSmoothingFactor) <= double.Epsilon && cacheCDA_VolumeProfile[idx].MicroCompSquareOutline == microCompSquareOutline && cacheCDA_VolumeProfile[idx].MicroCVPOCColor == microCVPOCColor && cacheCDA_VolumeProfile[idx].MicroCVPOCLabel == microCVPOCLabel && cacheCDA_VolumeProfile[idx].MicroCVPOCLineStyle == microCVPOCLineStyle && cacheCDA_VolumeProfile[idx].MicroCVPOCLineWidth == microCVPOCLineWidth && cacheCDA_VolumeProfile[idx].MicroValueNodeStrength == microValueNodeStrength && cacheCDA_VolumeProfile[idx].MidPtColor == midPtColor && cacheCDA_VolumeProfile[idx].MidPtLabel == midPtLabel && cacheCDA_VolumeProfile[idx].MidPtLineStyle == midPtLineStyle && cacheCDA_VolumeProfile[idx].MidPtLineWidth == midPtLineWidth && cacheCDA_VolumeProfile[idx].MinVAPCacheFileDate == minVAPCacheFileDate && cacheCDA_VolumeProfile[idx].MinVBCacheFileDate == minVBCacheFileDate && Math.Abs(cacheCDA_VolumeProfile[idx].MultiplierStdDev1 - multiplierStdDev1) <= double.Epsilon && Math.Abs(cacheCDA_VolumeProfile[idx].MultiplierStdDev2 - multiplierStdDev2) <= double.Epsilon && Math.Abs(cacheCDA_VolumeProfile[idx].MultiplierStdDev3 - multiplierStdDev3) <= double.Epsilon && cacheCDA_VolumeProfile[idx].NHighColor == nHighColor && cacheCDA_VolumeProfile[idx].NHighLabel == nHighLabel && cacheCDA_VolumeProfile[idx].NHLAlertEnabled == nHLAlertEnabled && cacheCDA_VolumeProfile[idx].NHLAlertSoundFile == nHLAlertSoundFile && cacheCDA_VolumeProfile[idx].NHLAppendDate == nHLAppendDate && cacheCDA_VolumeProfile[idx].NHLAppendPrice == nHLAppendPrice && cacheCDA_VolumeProfile[idx].NHLFont == nHLFont && cacheCDA_VolumeProfile[idx].NHLLineStyle == nHLLineStyle && cacheCDA_VolumeProfile[idx].NHLLineWidth == nHLLineWidth && cacheCDA_VolumeProfile[idx].NIBAlertEnabled == nIBAlertEnabled && cacheCDA_VolumeProfile[idx].NIBAlertSoundFile == nIBAlertSoundFile && cacheCDA_VolumeProfile[idx].NIBAppendDate == nIBAppendDate && cacheCDA_VolumeProfile[idx].NIBAppendPrice == nIBAppendPrice && cacheCDA_VolumeProfile[idx].NIBColor == nIBColor && cacheCDA_VolumeProfile[idx].NIBFont == nIBFont && cacheCDA_VolumeProfile[idx].NIBHLabel == nIBHLabel && cacheCDA_VolumeProfile[idx].NIBLineStyle == nIBLineStyle && cacheCDA_VolumeProfile[idx].NIBLineWidth == nIBLineWidth && cacheCDA_VolumeProfile[idx].NIBLLabel == nIBLLabel && cacheCDA_VolumeProfile[idx].NLowColor == nLowColor && cacheCDA_VolumeProfile[idx].NLowLabel == nLowLabel && cacheCDA_VolumeProfile[idx].NVAAlertEnabled == nVAAlertEnabled && cacheCDA_VolumeProfile[idx].NVAAlertSoundFile == nVAAlertSoundFile && cacheCDA_VolumeProfile[idx].NVAAppendDate == nVAAppendDate && cacheCDA_VolumeProfile[idx].NVAAppendPrice == nVAAppendPrice && cacheCDA_VolumeProfile[idx].NVAColor == nVAColor && cacheCDA_VolumeProfile[idx].NVAFont == nVAFont && cacheCDA_VolumeProfile[idx].NVAHLabel == nVAHLabel && cacheCDA_VolumeProfile[idx].NVALineStyle == nVALineStyle && cacheCDA_VolumeProfile[idx].NVALineWidth == nVALineWidth && cacheCDA_VolumeProfile[idx].NVALLabel == nVALLabel && cacheCDA_VolumeProfile[idx].NVPOCAlertEnabled == nVPOCAlertEnabled && cacheCDA_VolumeProfile[idx].NVPOCAlertSoundFile == nVPOCAlertSoundFile && cacheCDA_VolumeProfile[idx].NVPOCAppendDate == nVPOCAppendDate && cacheCDA_VolumeProfile[idx].NVPOCAppendPrice == nVPOCAppendPrice && cacheCDA_VolumeProfile[idx].NVPOCColor == nVPOCColor && cacheCDA_VolumeProfile[idx].NVPOCFont == nVPOCFont && cacheCDA_VolumeProfile[idx].NVPOCLabel == nVPOCLabel && cacheCDA_VolumeProfile[idx].NVPOCLineStyle == nVPOCLineStyle && cacheCDA_VolumeProfile[idx].NVPOCLineWidth == nVPOCLineWidth && cacheCDA_VolumeProfile[idx].OpacitySD1 == opacitySD1 && cacheCDA_VolumeProfile[idx].OpacitySD2 == opacitySD2 && cacheCDA_VolumeProfile[idx].OpacitySD3 == opacitySD3 && cacheCDA_VolumeProfile[idx].OpenColor == openColor && cacheCDA_VolumeProfile[idx].OpenLabel == openLabel && cacheCDA_VolumeProfile[idx].OpenLineStyle == openLineStyle && cacheCDA_VolumeProfile[idx].OpenLineWidth == openLineWidth && cacheCDA_VolumeProfile[idx].OpenSwingMaxMinutes == openSwingMaxMinutes && cacheCDA_VolumeProfile[idx].OperationalMode == operationalMode && cacheCDA_VolumeProfile[idx].OSColor == oSColor && cacheCDA_VolumeProfile[idx].OSHLabel == oSHLabel && cacheCDA_VolumeProfile[idx].OSLineStyle == oSLineStyle && cacheCDA_VolumeProfile[idx].OSLineWidth == oSLineWidth && cacheCDA_VolumeProfile[idx].OSLLabel == oSLLabel && cacheCDA_VolumeProfile[idx].OvernightDefaultColor == overnightDefaultColor && cacheCDA_VolumeProfile[idx].OvernightDisplayPeriodHL == overnightDisplayPeriodHL && cacheCDA_VolumeProfile[idx].OvernightDisplayPeriodVPOC == overnightDisplayPeriodVPOC && cacheCDA_VolumeProfile[idx].OvernightFont == overnightFont && cacheCDA_VolumeProfile[idx].OvernightHighColor == overnightHighColor && cacheCDA_VolumeProfile[idx].OvernightHighLabel == overnightHighLabel && cacheCDA_VolumeProfile[idx].OvernightHighLineStyle == overnightHighLineStyle && cacheCDA_VolumeProfile[idx].OvernightHighLineWidth == overnightHighLineWidth && cacheCDA_VolumeProfile[idx].OvernightLowColor == overnightLowColor && cacheCDA_VolumeProfile[idx].OvernightLowLabel == overnightLowLabel && cacheCDA_VolumeProfile[idx].OvernightLowLineStyle == overnightLowLineStyle && cacheCDA_VolumeProfile[idx].OvernightLowLineWidth == overnightLowLineWidth && cacheCDA_VolumeProfile[idx].OvernightStatsSessionName == overnightStatsSessionName && cacheCDA_VolumeProfile[idx].OvernightVPOCColor == overnightVPOCColor && cacheCDA_VolumeProfile[idx].OvernightVPOCLabel == overnightVPOCLabel && cacheCDA_VolumeProfile[idx].OvernightVPOCLineStyle == overnightVPOCLineStyle && cacheCDA_VolumeProfile[idx].OvernightVPOCLineWidth == overnightVPOCLineWidth && cacheCDA_VolumeProfile[idx].PlotCD == plotCD && cacheCDA_VolumeProfile[idx].RebuildVAPCache == rebuildVAPCache && cacheCDA_VolumeProfile[idx].RebuildVBCache == rebuildVBCache && cacheCDA_VolumeProfile[idx].RefreshCompositeCacheFile == refreshCompositeCacheFile && cacheCDA_VolumeProfile[idx].ResetCDatBar == resetCDatBar && Math.Abs(cacheCDA_VolumeProfile[idx].RolloverOffset - rolloverOffset) <= double.Epsilon && cacheCDA_VolumeProfile[idx].RolloverToContractMonth == rolloverToContractMonth && cacheCDA_VolumeProfile[idx].RolloverVAPCache == rolloverVAPCache && cacheCDA_VolumeProfile[idx].RootFolder == rootFolder && cacheCDA_VolumeProfile[idx].RunLogFileDir == runLogFileDir && cacheCDA_VolumeProfile[idx].RunLogFilename == runLogFilename && cacheCDA_VolumeProfile[idx].SaveVBData == saveVBData && cacheCDA_VolumeProfile[idx].SessionAnchorOffset == sessionAnchorOffset && cacheCDA_VolumeProfile[idx].SessionAnchorOffsetToolLabel == sessionAnchorOffsetToolLabel && cacheCDA_VolumeProfile[idx].SessionAnchorPosition == sessionAnchorPosition && cacheCDA_VolumeProfile[idx].SessionAnchorPositionToolLabel == sessionAnchorPositionToolLabel && cacheCDA_VolumeProfile[idx].SessionCDvapHeading == sessionCDvapHeading && cacheCDA_VolumeProfile[idx].SessionFillColor == sessionFillColor && cacheCDA_VolumeProfile[idx].SessionOpacity == sessionOpacity && cacheCDA_VolumeProfile[idx].SessionOpacityToolLabel == sessionOpacityToolLabel && cacheCDA_VolumeProfile[idx].SessionOutlineColor == sessionOutlineColor && Math.Abs(cacheCDA_VolumeProfile[idx].SessionScale - sessionScale) <= double.Epsilon && cacheCDA_VolumeProfile[idx].SessionScaleToolLabel == sessionScaleToolLabel && cacheCDA_VolumeProfile[idx].SessionSquareOutline == sessionSquareOutline && cacheCDA_VolumeProfile[idx].SessionVolumeFont == sessionVolumeFont && cacheCDA_VolumeProfile[idx].ShowBigPrints == showBigPrints && cacheCDA_VolumeProfile[idx].ShowBPHLine == showBPHLine && cacheCDA_VolumeProfile[idx].ShowBPVLine == showBPVLine && cacheCDA_VolumeProfile[idx].ShowCDAtEachPrice == showCDAtEachPrice && cacheCDA_VolumeProfile[idx].ShowCompositeBeginDate == showCompositeBeginDate && cacheCDA_VolumeProfile[idx].ShowCompositeProfile == showCompositeProfile && cacheCDA_VolumeProfile[idx].ShowCompositeVolumes == showCompositeVolumes && cacheCDA_VolumeProfile[idx].ShowCompValueNodePrice == showCompValueNodePrice && cacheCDA_VolumeProfile[idx].ShowCompValueNodes == showCompValueNodes && cacheCDA_VolumeProfile[idx].ShowGaps == showGaps && cacheCDA_VolumeProfile[idx].ShowIB == showIB && cacheCDA_VolumeProfile[idx].ShowIB15x == showIB15x && cacheCDA_VolumeProfile[idx].ShowIB2x == showIB2x && cacheCDA_VolumeProfile[idx].ShowIBRange == showIBRange && cacheCDA_VolumeProfile[idx].ShowLabels == showLabels && cacheCDA_VolumeProfile[idx].ShowMCVA == showMCVA && cacheCDA_VolumeProfile[idx].ShowMicroCompositeDates == showMicroCompositeDates && cacheCDA_VolumeProfile[idx].ShowMicroCompositeProfile == showMicroCompositeProfile && cacheCDA_VolumeProfile[idx].ShowMicroCompositeVolumes == showMicroCompositeVolumes && cacheCDA_VolumeProfile[idx].ShowMicroCompValueNodePrice == showMicroCompValueNodePrice && cacheCDA_VolumeProfile[idx].ShowMicroCompValueNodes == showMicroCompValueNodes && cacheCDA_VolumeProfile[idx].ShowNHLs == showNHLs && cacheCDA_VolumeProfile[idx].ShowNIBs == showNIBs && cacheCDA_VolumeProfile[idx].ShowNVAs == showNVAs && cacheCDA_VolumeProfile[idx].ShowNVPOCs == showNVPOCs && cacheCDA_VolumeProfile[idx].ShowOHMLC == showOHMLC && cacheCDA_VolumeProfile[idx].ShowOS == showOS && cacheCDA_VolumeProfile[idx].ShowOvernightStats == showOvernightStats && cacheCDA_VolumeProfile[idx].ShowPriceWithLabel == showPriceWithLabel && cacheCDA_VolumeProfile[idx].ShowSessionImbalanceFactor == showSessionImbalanceFactor && cacheCDA_VolumeProfile[idx].ShowSessionProfile == showSessionProfile && cacheCDA_VolumeProfile[idx].ShowSessionRange == showSessionRange && cacheCDA_VolumeProfile[idx].ShowSessionVolumes == showSessionVolumes && cacheCDA_VolumeProfile[idx].ShowStartupMessages == showStartupMessages && cacheCDA_VolumeProfile[idx].ShowToolBar == showToolBar && cacheCDA_VolumeProfile[idx].ShowTrendChange == showTrendChange && cacheCDA_VolumeProfile[idx].ShowVA == showVA && cacheCDA_VolumeProfile[idx].ShowVARange == showVARange && cacheCDA_VolumeProfile[idx].ShowVPOC == showVPOC && cacheCDA_VolumeProfile[idx].ShowVPOCTrack == showVPOCTrack && cacheCDA_VolumeProfile[idx].SlowPeriod == slowPeriod && cacheCDA_VolumeProfile[idx].StandardCDHeading == standardCDHeading && cacheCDA_VolumeProfile[idx].StaticMCEnabled == staticMCEnabled && cacheCDA_VolumeProfile[idx].Threshold == threshold && cacheCDA_VolumeProfile[idx].ToolBarHideDropDownLabel == toolBarHideDropDownLabel && cacheCDA_VolumeProfile[idx].ToolBarTextColor == toolBarTextColor && cacheCDA_VolumeProfile[idx].ToolBarTextFont == toolBarTextFont && cacheCDA_VolumeProfile[idx].ToolBarTextFontOnFocus == toolBarTextFontOnFocus && cacheCDA_VolumeProfile[idx].TrendCDvapHeading == trendCDvapHeading && cacheCDA_VolumeProfile[idx].TrendChangeDownColor == trendChangeDownColor && cacheCDA_VolumeProfile[idx].TrendChangeUpColor == trendChangeUpColor && cacheCDA_VolumeProfile[idx].UpdateInRealtimeEnabled == updateInRealtimeEnabled && cacheCDA_VolumeProfile[idx].VAColor == vAColor && cacheCDA_VolumeProfile[idx].VAHLabel == vAHLabel && cacheCDA_VolumeProfile[idx].VALineStyle == vALineStyle && cacheCDA_VolumeProfile[idx].VALineWidth == vALineWidth && cacheCDA_VolumeProfile[idx].VALLabel == vALLabel && cacheCDA_VolumeProfile[idx].VAOpacity == vAOpacity && Math.Abs(cacheCDA_VolumeProfile[idx].VAPercent - vAPercent) <= double.Epsilon && cacheCDA_VolumeProfile[idx].VPOCColor == vPOCColor && cacheCDA_VolumeProfile[idx].VPOCLabel == vPOCLabel && cacheCDA_VolumeProfile[idx].VPOCLineStyle == vPOCLineStyle && cacheCDA_VolumeProfile[idx].VPOCLineWidth == vPOCLineWidth && cacheCDA_VolumeProfile[idx].VWAPColor == vWAPColor && cacheCDA_VolumeProfile[idx].VWAPLabel == vWAPLabel && cacheCDA_VolumeProfile[idx].VWAPLineStyle == vWAPLineStyle && cacheCDA_VolumeProfile[idx].VWAPLineWidth == vWAPLineWidth && cacheCDA_VolumeProfile[idx].VWAPSD1Color == vWAPSD1Color && cacheCDA_VolumeProfile[idx].VWAPSD1LineStyle == vWAPSD1LineStyle && cacheCDA_VolumeProfile[idx].VWAPSD1LineWidth == vWAPSD1LineWidth && cacheCDA_VolumeProfile[idx].VWAPSD2Color == vWAPSD2Color && cacheCDA_VolumeProfile[idx].VWAPSD2LineStyle == vWAPSD2LineStyle && cacheCDA_VolumeProfile[idx].VWAPSD2LineWidth == vWAPSD2LineWidth && cacheCDA_VolumeProfile[idx].VWAPSD3Color == vWAPSD3Color && cacheCDA_VolumeProfile[idx].VWAPSD3LineStyle == vWAPSD3LineStyle && cacheCDA_VolumeProfile[idx].VWAPSD3LineWidth == vWAPSD3LineWidth && cacheCDA_VolumeProfile[idx].EqualsInput(input))
                            return cacheCDA_VolumeProfile[idx];

                CDA_VolumeProfile indicator = new CDA_VolumeProfile();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.AboveAskColor = aboveAskColor;
                indicator.AtAskColor = atAskColor;
                indicator.AtBidColor = atBidColor;
                indicator.AutoSaveMicroCompositeSettings = autoSaveMicroCompositeSettings;
                indicator.AutoUpdateMCEndDate = autoUpdateMCEndDate;
                indicator.BelowBidColor = belowBidColor;
                indicator.BigPrintsFileDir = bigPrintsFileDir;
                indicator.BPAlertEnabled = bPAlertEnabled;
                indicator.BPAlertSoundFile = bPAlertSoundFile;
                indicator.BPDisplayCount = bPDisplayCount;
                indicator.BPDisplayMode = bPDisplayMode;
                indicator.BPDisplayPosition = bPDisplayPosition;
                indicator.BPFilterMode = bPFilterMode;
                indicator.BPHLineStyle = bPHLineStyle;
                indicator.BPHLineWidth = bPHLineWidth;
                indicator.BPLabel = bPLabel;
                indicator.BPLabelColor = bPLabelColor;
                indicator.BPLabelFont = bPLabelFont;
                indicator.BPLabelOffset = bPLabelOffset;
                indicator.BPMinVolume = bPMinVolume;
                indicator.BPMulipleAboveMultipleOfAverageVolume = bPMulipleAboveMultipleOfAverageVolume;
                indicator.BPVLineStyle = bPVLineStyle;
                indicator.BPVLineWidth = bPVLineWidth;
                indicator.CalcMode = calcMode;
                indicator.CD0Label = cD0Label;
                indicator.CD0LineColor = cD0LineColor;
                indicator.CD0LineStyle = cD0LineStyle;
                indicator.CD0LineWidth = cD0LineWidth;
                indicator.CDDownColor = cDDownColor;
                indicator.CDHeadingsColor = cDHeadingsColor;
                indicator.CDHeadingsFont = cDHeadingsFont;
                indicator.CDHighLabel = cDHighLabel;
                indicator.CDHighLineColor = cDHighLineColor;
                indicator.CDHighLineStyle = cDHighLineStyle;
                indicator.CDHighLineWidth = cDHighLineWidth;
                indicator.CDLineStyle = cDLineStyle;
                indicator.CDLineWidth = cDLineWidth;
                indicator.CDLocation = cDLocation;
                indicator.CDLowLabel = cDLowLabel;
                indicator.CDLowLineColor = cDLowLineColor;
                indicator.CDLowLineStyle = cDLowLineStyle;
                indicator.CDLowLineWidth = cDLowLineWidth;
                indicator.CDNeutralColor = cDNeutralColor;
                indicator.CDPlotLabel = cDPlotLabel;
                indicator.CDUpColor = cDUpColor;
                indicator.CDValueFont = cDValueFont;
                indicator.CHVNBandColor = cHVNBandColor;
                indicator.CHVNBandOpacity = cHVNBandOpacity;
                indicator.CHVNBandOpacityToolLabel = cHVNBandOpacityToolLabel;
                indicator.CHVNBandWidth = cHVNBandWidth;
                indicator.CHVNLineColor = cHVNLineColor;
                indicator.CHVNLineStyle = cHVNLineStyle;
                indicator.CHVNLineWidth = cHVNLineWidth;
                indicator.CloseColor = closeColor;
                indicator.CloseLabel = closeLabel;
                indicator.CloseLineStyle = closeLineStyle;
                indicator.CloseLineWidth = closeLineWidth;
                indicator.CLVNBandColor = cLVNBandColor;
                indicator.CLVNBandOpacity = cLVNBandOpacity;
                indicator.CLVNBandOpacityToolLabel = cLVNBandOpacityToolLabel;
                indicator.CLVNBandWidth = cLVNBandWidth;
                indicator.CLVNLineColor = cLVNLineColor;
                indicator.CLVNLineStyle = cLVNLineStyle;
                indicator.CLVNLineWidth = cLVNLineWidth;
                indicator.CompositeAnchorOffset = compositeAnchorOffset;
                indicator.CompositeAnchorOffsetToolLabel = compositeAnchorOffsetToolLabel;
                indicator.CompositeAnchorPosition = compositeAnchorPosition;
                indicator.CompositeAnchorPositionToolLabel = compositeAnchorPositionToolLabel;
                indicator.CompositeBeginDate = compositeBeginDate;
                indicator.CompositeBeginDateToolLabel = compositeBeginDateToolLabel;
                indicator.CompositeFillColor = compositeFillColor;
                indicator.CompositeOpacity = compositeOpacity;
                indicator.CompositeOpacityToolLabel = compositeOpacityToolLabel;
                indicator.CompositeOutlineColor = compositeOutlineColor;
                indicator.CompositeScale = compositeScale;
                indicator.CompositeScaleToolLabel = compositeScaleToolLabel;
                indicator.CompositeSmoothingFactor = compositeSmoothingFactor;
                indicator.CompositeSmoothingFactorToolLabel = compositeSmoothingFactorToolLabel;
                indicator.CompositeSquareOutline = compositeSquareOutline;
                indicator.CompositeVNToolLabel = compositeVNToolLabel;
                indicator.CompValueNodeStrength = compValueNodeStrength;
                indicator.CurrentSessionAnchorPosition = currentSessionAnchorPosition;
                indicator.CVPOCColor = cVPOCColor;
                indicator.CVPOCLabel = cVPOCLabel;
                indicator.CVPOCLineStyle = cVPOCLineStyle;
                indicator.CVPOCLineWidth = cVPOCLineWidth;
                indicator.DataFileDir = dataFileDir;
                indicator.DisplayComputedAtBar = displayComputedAtBar;
                indicator.DisplayComputedAtPrice = displayComputedAtPrice;
                indicator.DisplaySD1 = displaySD1;
                indicator.DisplaySD2 = displaySD2;
                indicator.DisplaySD3 = displaySD3;
                indicator.DisplayVABand = displayVABand;
                indicator.DrawCD0 = drawCD0;
                indicator.DrawCDHighLow = drawCDHighLow;
                indicator.EmailAddress = emailAddress;
                indicator.EmailToAddress = emailToAddress;
                indicator.EnableCD = enableCD;
                indicator.EnableCHVNOpacityTool = enableCHVNOpacityTool;
                indicator.EnableCLVNOpacityTool = enableCLVNOpacityTool;
                indicator.EnableCompositeAnchorOffsetTool = enableCompositeAnchorOffsetTool;
                indicator.EnableCompositeAnchorPositionTool = enableCompositeAnchorPositionTool;
                indicator.EnableCompositeBeginDateTool = enableCompositeBeginDateTool;
                indicator.EnableCompositeHeatmap = enableCompositeHeatmap;
                indicator.EnableCompositeOpacityTool = enableCompositeOpacityTool;
                indicator.EnableCompositeScaleTool = enableCompositeScaleTool;
                indicator.EnableCompositeSmoothingFactorTool = enableCompositeSmoothingFactorTool;
                indicator.EnableCompositeVNTool = enableCompositeVNTool;
                indicator.EnableHideBlockTradesButton = enableHideBlockTradesButton;
                indicator.EnableHideCDsButton = enableHideCDsButton;
                indicator.EnableHideCompositeProfileButton = enableHideCompositeProfileButton;
                indicator.EnableHideCompositeProfileValueNodesButton = enableHideCompositeProfileValueNodesButton;
                indicator.EnableHideMicroCompositeProfilesButton = enableHideMicroCompositeProfilesButton;
                indicator.EnableHideMicroCompositeProfileValueAreasButton = enableHideMicroCompositeProfileValueAreasButton;
                indicator.EnableHideMicroCompositeProfileValueNodesButton = enableHideMicroCompositeProfileValueNodesButton;
                indicator.EnableHideOvernightStatsButton = enableHideOvernightStatsButton;
                indicator.EnableHideSessionProfilesButton = enableHideSessionProfilesButton;
                indicator.EnableMicroCompositeAnchorEdgeTool = enableMicroCompositeAnchorEdgeTool;
                indicator.EnableMicroCompositeAnchorOffsetTool = enableMicroCompositeAnchorOffsetTool;
                indicator.EnableMicroCompositeAnchorPositionTool = enableMicroCompositeAnchorPositionTool;
                indicator.EnableMicroCompositeDateRangeTool = enableMicroCompositeDateRangeTool;
                indicator.EnableMicroCompositeHeatmap = enableMicroCompositeHeatmap;
                indicator.EnableMicroCompositeOpacityTool = enableMicroCompositeOpacityTool;
                indicator.EnableMicroCompositeScaleTool = enableMicroCompositeScaleTool;
                indicator.EnableMicroCompositeSmoothingFactorTool = enableMicroCompositeSmoothingFactorTool;
                indicator.EnableMicroCompositeVNTool = enableMicroCompositeVNTool;
                indicator.EnablePrecisionRangeProfiling = enablePrecisionRangeProfiling;
                indicator.EnableRunLog = enableRunLog;
                indicator.EnableSessionAnchorOffsetTool = enableSessionAnchorOffsetTool;
                indicator.EnableSessionAnchorPositionTool = enableSessionAnchorPositionTool;
                indicator.EnableSessionHeatmap = enableSessionHeatmap;
                indicator.EnableSessionOpacityTool = enableSessionOpacityTool;
                indicator.EnableSessionScaleTool = enableSessionScaleTool;
                indicator.EnableVWAP = enableVWAP;
                indicator.ExportFileDir = exportFileDir;
                indicator.ExportStats = exportStats;
                indicator.FastPeriod = fastPeriod;
                indicator.GAPAlertEnabled = gAPAlertEnabled;
                indicator.GAPAlertSoundFile = gAPAlertSoundFile;
                indicator.GAPAppendDate = gAPAppendDate;
                indicator.GAPAppendPrice = gAPAppendPrice;
                indicator.GAPColor = gAPColor;
                indicator.GAPFont = gAPFont;
                indicator.GAPLabel = gAPLabel;
                indicator.GAPLineStyle = gAPLineStyle;
                indicator.GAPLineWidth = gAPLineWidth;
                indicator.HighColor = highColor;
                indicator.HighLabel = highLabel;
                indicator.HighlightIB = highlightIB;
                indicator.HighlightMCVA = highlightMCVA;
                indicator.HighlightVA = highlightVA;
                indicator.HighLineStyle = highLineStyle;
                indicator.HighLineWidth = highLineWidth;
                indicator.IB15xColor = iB15xColor;
                indicator.IB15xLineStyle = iB15xLineStyle;
                indicator.IB15xLineWidth = iB15xLineWidth;
                indicator.IB2xColor = iB2xColor;
                indicator.IB2xLineStyle = iB2xLineStyle;
                indicator.IB2xLineWidth = iB2xLineWidth;
                indicator.IBColor = iBColor;
                indicator.IBH15xLabel = iBH15xLabel;
                indicator.IBH2xLabel = iBH2xLabel;
                indicator.IBHLabel = iBHLabel;
                indicator.IBL15xLabel = iBL15xLabel;
                indicator.IBL2xLabel = iBL2xLabel;
                indicator.IBLineStyle = iBLineStyle;
                indicator.IBLineWidth = iBLineWidth;
                indicator.IBLLabel = iBLLabel;
                indicator.IBMinutes = iBMinutes;
                indicator.InsideColor = insideColor;
                indicator.LabelDelay = labelDelay;
                indicator.LabelDisplacement = labelDisplacement;
                indicator.LabelFont = labelFont;
                indicator.LoadVBCache = loadVBCache;
                indicator.LowColor = lowColor;
                indicator.LowLabel = lowLabel;
                indicator.LowLineStyle = lowLineStyle;
                indicator.LowLineWidth = lowLineWidth;
                indicator.MCAnchorPositionLabelFollowsValue = mCAnchorPositionLabelFollowsValue;
                indicator.MCBeginEndByManualRect = mCBeginEndByManualRect;
                indicator.MCRectangleTagPrefix = mCRectangleTagPrefix;
                indicator.mcVAColor = mcVAColor;
                indicator.mcVAHLabel = mcVAHLabel;
                indicator.mcVALineStyle = mcVALineStyle;
                indicator.mcVALineWidth = mcVALineWidth;
                indicator.mcVALLabel = mcVALLabel;
                indicator.mcVAPercent = mcVAPercent;
                indicator.MicroCHVNColor = microCHVNColor;
                indicator.MicroCHVNLineStyle = microCHVNLineStyle;
                indicator.MicroCHVNLineWidth = microCHVNLineWidth;
                indicator.MicroCLVNColor = microCLVNColor;
                indicator.MicroCLVNLineStyle = microCLVNLineStyle;
                indicator.MicroCLVNLineWidth = microCLVNLineWidth;
                indicator.MicroCompositeAnchorBar = microCompositeAnchorBar;
                indicator.MicroCompositeAnchorEdge = microCompositeAnchorEdge;
                indicator.MicroCompositeAnchorEdgeToolLabel = microCompositeAnchorEdgeToolLabel;
                indicator.MicroCompositeAnchorOffset = microCompositeAnchorOffset;
                indicator.MicroCompositeAnchorOffsetToolLabel = microCompositeAnchorOffsetToolLabel;
                indicator.MicroCompositeAnchorPosition = microCompositeAnchorPosition;
                indicator.MicroCompositeAnchorPositionToolLabel = microCompositeAnchorPositionToolLabel;
                indicator.MicroCompositeBeginDate = microCompositeBeginDate;
                indicator.MicroCompositeDateRangeToolLabel = microCompositeDateRangeToolLabel;
                indicator.MicroCompositeEndDate = microCompositeEndDate;
                indicator.MicroCompositeFillColor = microCompositeFillColor;
                indicator.MicroCompositeOpacity = microCompositeOpacity;
                indicator.MicroCompositeOpacityToolLabel = microCompositeOpacityToolLabel;
                indicator.MicroCompositeOutlineColor = microCompositeOutlineColor;
                indicator.MicroCompositeScale = microCompositeScale;
                indicator.MicroCompositeScaleToolLabel = microCompositeScaleToolLabel;
                indicator.MicroCompositeSelectToolLabel = microCompositeSelectToolLabel;
                indicator.MicroCompositeSmoothingFactorToolLabel = microCompositeSmoothingFactorToolLabel;
                indicator.MicroCompositeVNToolLabel = microCompositeVNToolLabel;
                indicator.MicroCompSmoothingFactor = microCompSmoothingFactor;
                indicator.MicroCompSquareOutline = microCompSquareOutline;
                indicator.MicroCVPOCColor = microCVPOCColor;
                indicator.MicroCVPOCLabel = microCVPOCLabel;
                indicator.MicroCVPOCLineStyle = microCVPOCLineStyle;
                indicator.MicroCVPOCLineWidth = microCVPOCLineWidth;
                indicator.MicroValueNodeStrength = microValueNodeStrength;
                indicator.MidPtColor = midPtColor;
                indicator.MidPtLabel = midPtLabel;
                indicator.MidPtLineStyle = midPtLineStyle;
                indicator.MidPtLineWidth = midPtLineWidth;
                indicator.MinVAPCacheFileDate = minVAPCacheFileDate;
                indicator.MinVBCacheFileDate = minVBCacheFileDate;
                indicator.MultiplierStdDev1 = multiplierStdDev1;
                indicator.MultiplierStdDev2 = multiplierStdDev2;
                indicator.MultiplierStdDev3 = multiplierStdDev3;
                indicator.NHighColor = nHighColor;
                indicator.NHighLabel = nHighLabel;
                indicator.NHLAlertEnabled = nHLAlertEnabled;
                indicator.NHLAlertSoundFile = nHLAlertSoundFile;
                indicator.NHLAppendDate = nHLAppendDate;
                indicator.NHLAppendPrice = nHLAppendPrice;
                indicator.NHLFont = nHLFont;
                indicator.NHLLineStyle = nHLLineStyle;
                indicator.NHLLineWidth = nHLLineWidth;
                indicator.NIBAlertEnabled = nIBAlertEnabled;
                indicator.NIBAlertSoundFile = nIBAlertSoundFile;
                indicator.NIBAppendDate = nIBAppendDate;
                indicator.NIBAppendPrice = nIBAppendPrice;
                indicator.NIBColor = nIBColor;
                indicator.NIBFont = nIBFont;
                indicator.NIBHLabel = nIBHLabel;
                indicator.NIBLineStyle = nIBLineStyle;
                indicator.NIBLineWidth = nIBLineWidth;
                indicator.NIBLLabel = nIBLLabel;
                indicator.NLowColor = nLowColor;
                indicator.NLowLabel = nLowLabel;
                indicator.NVAAlertEnabled = nVAAlertEnabled;
                indicator.NVAAlertSoundFile = nVAAlertSoundFile;
                indicator.NVAAppendDate = nVAAppendDate;
                indicator.NVAAppendPrice = nVAAppendPrice;
                indicator.NVAColor = nVAColor;
                indicator.NVAFont = nVAFont;
                indicator.NVAHLabel = nVAHLabel;
                indicator.NVALineStyle = nVALineStyle;
                indicator.NVALineWidth = nVALineWidth;
                indicator.NVALLabel = nVALLabel;
                indicator.NVPOCAlertEnabled = nVPOCAlertEnabled;
                indicator.NVPOCAlertSoundFile = nVPOCAlertSoundFile;
                indicator.NVPOCAppendDate = nVPOCAppendDate;
                indicator.NVPOCAppendPrice = nVPOCAppendPrice;
                indicator.NVPOCColor = nVPOCColor;
                indicator.NVPOCFont = nVPOCFont;
                indicator.NVPOCLabel = nVPOCLabel;
                indicator.NVPOCLineStyle = nVPOCLineStyle;
                indicator.NVPOCLineWidth = nVPOCLineWidth;
                indicator.OpacitySD1 = opacitySD1;
                indicator.OpacitySD2 = opacitySD2;
                indicator.OpacitySD3 = opacitySD3;
                indicator.OpenColor = openColor;
                indicator.OpenLabel = openLabel;
                indicator.OpenLineStyle = openLineStyle;
                indicator.OpenLineWidth = openLineWidth;
                indicator.OpenSwingMaxMinutes = openSwingMaxMinutes;
                indicator.OperationalMode = operationalMode;
                indicator.OSColor = oSColor;
                indicator.OSHLabel = oSHLabel;
                indicator.OSLineStyle = oSLineStyle;
                indicator.OSLineWidth = oSLineWidth;
                indicator.OSLLabel = oSLLabel;
                indicator.OvernightDefaultColor = overnightDefaultColor;
                indicator.OvernightDisplayPeriodHL = overnightDisplayPeriodHL;
                indicator.OvernightDisplayPeriodVPOC = overnightDisplayPeriodVPOC;
                indicator.OvernightFont = overnightFont;
                indicator.OvernightHighColor = overnightHighColor;
                indicator.OvernightHighLabel = overnightHighLabel;
                indicator.OvernightHighLineStyle = overnightHighLineStyle;
                indicator.OvernightHighLineWidth = overnightHighLineWidth;
                indicator.OvernightLowColor = overnightLowColor;
                indicator.OvernightLowLabel = overnightLowLabel;
                indicator.OvernightLowLineStyle = overnightLowLineStyle;
                indicator.OvernightLowLineWidth = overnightLowLineWidth;
                indicator.OvernightStatsSessionName = overnightStatsSessionName;
                indicator.OvernightVPOCColor = overnightVPOCColor;
                indicator.OvernightVPOCLabel = overnightVPOCLabel;
                indicator.OvernightVPOCLineStyle = overnightVPOCLineStyle;
                indicator.OvernightVPOCLineWidth = overnightVPOCLineWidth;
                indicator.PlotCD = plotCD;
                indicator.RebuildVAPCache = rebuildVAPCache;
                indicator.RebuildVBCache = rebuildVBCache;
                indicator.RefreshCompositeCacheFile = refreshCompositeCacheFile;
                indicator.ResetCDatBar = resetCDatBar;
                indicator.RolloverOffset = rolloverOffset;
                indicator.RolloverToContractMonth = rolloverToContractMonth;
                indicator.RolloverVAPCache = rolloverVAPCache;
                indicator.RootFolder = rootFolder;
                indicator.RunLogFileDir = runLogFileDir;
                indicator.RunLogFilename = runLogFilename;
                indicator.SaveVBData = saveVBData;
                indicator.SessionAnchorOffset = sessionAnchorOffset;
                indicator.SessionAnchorOffsetToolLabel = sessionAnchorOffsetToolLabel;
                indicator.SessionAnchorPosition = sessionAnchorPosition;
                indicator.SessionAnchorPositionToolLabel = sessionAnchorPositionToolLabel;
                indicator.SessionCDvapHeading = sessionCDvapHeading;
                indicator.SessionFillColor = sessionFillColor;
                indicator.SessionOpacity = sessionOpacity;
                indicator.SessionOpacityToolLabel = sessionOpacityToolLabel;
                indicator.SessionOutlineColor = sessionOutlineColor;
                indicator.SessionScale = sessionScale;
                indicator.SessionScaleToolLabel = sessionScaleToolLabel;
                indicator.SessionSquareOutline = sessionSquareOutline;
                indicator.SessionVolumeFont = sessionVolumeFont;
                indicator.ShowBigPrints = showBigPrints;
                indicator.ShowBPHLine = showBPHLine;
                indicator.ShowBPVLine = showBPVLine;
                indicator.ShowCDAtEachPrice = showCDAtEachPrice;
                indicator.ShowCompositeBeginDate = showCompositeBeginDate;
                indicator.ShowCompositeProfile = showCompositeProfile;
                indicator.ShowCompositeVolumes = showCompositeVolumes;
                indicator.ShowCompValueNodePrice = showCompValueNodePrice;
                indicator.ShowCompValueNodes = showCompValueNodes;
                indicator.ShowGaps = showGaps;
                indicator.ShowIB = showIB;
                indicator.ShowIB15x = showIB15x;
                indicator.ShowIB2x = showIB2x;
                indicator.ShowIBRange = showIBRange;
                indicator.ShowLabels = showLabels;
                indicator.ShowMCVA = showMCVA;
                indicator.ShowMicroCompositeDates = showMicroCompositeDates;
                indicator.ShowMicroCompositeProfile = showMicroCompositeProfile;
                indicator.ShowMicroCompositeVolumes = showMicroCompositeVolumes;
                indicator.ShowMicroCompValueNodePrice = showMicroCompValueNodePrice;
                indicator.ShowMicroCompValueNodes = showMicroCompValueNodes;
                indicator.ShowNHLs = showNHLs;
                indicator.ShowNIBs = showNIBs;
                indicator.ShowNVAs = showNVAs;
                indicator.ShowNVPOCs = showNVPOCs;
                indicator.ShowOHMLC = showOHMLC;
                indicator.ShowOS = showOS;
                indicator.ShowOvernightStats = showOvernightStats;
                indicator.ShowPriceWithLabel = showPriceWithLabel;
                indicator.ShowSessionImbalanceFactor = showSessionImbalanceFactor;
                indicator.ShowSessionProfile = showSessionProfile;
                indicator.ShowSessionRange = showSessionRange;
                indicator.ShowSessionVolumes = showSessionVolumes;
                indicator.ShowStartupMessages = showStartupMessages;
                indicator.ShowToolBar = showToolBar;
                indicator.ShowTrendChange = showTrendChange;
                indicator.ShowVA = showVA;
                indicator.ShowVARange = showVARange;
                indicator.ShowVPOC = showVPOC;
                indicator.ShowVPOCTrack = showVPOCTrack;
                indicator.SlowPeriod = slowPeriod;
                indicator.StandardCDHeading = standardCDHeading;
                indicator.StaticMCEnabled = staticMCEnabled;
                indicator.Threshold = threshold;
                indicator.ToolBarHideDropDownLabel = toolBarHideDropDownLabel;
                indicator.ToolBarTextColor = toolBarTextColor;
                indicator.ToolBarTextFont = toolBarTextFont;
                indicator.ToolBarTextFontOnFocus = toolBarTextFontOnFocus;
                indicator.TrendCDvapHeading = trendCDvapHeading;
                indicator.TrendChangeDownColor = trendChangeDownColor;
                indicator.TrendChangeUpColor = trendChangeUpColor;
                indicator.UpdateInRealtimeEnabled = updateInRealtimeEnabled;
                indicator.VAColor = vAColor;
                indicator.VAHLabel = vAHLabel;
                indicator.VALineStyle = vALineStyle;
                indicator.VALineWidth = vALineWidth;
                indicator.VALLabel = vALLabel;
                indicator.VAOpacity = vAOpacity;
                indicator.VAPercent = vAPercent;
                indicator.VPOCColor = vPOCColor;
                indicator.VPOCLabel = vPOCLabel;
                indicator.VPOCLineStyle = vPOCLineStyle;
                indicator.VPOCLineWidth = vPOCLineWidth;
                indicator.VWAPColor = vWAPColor;
                indicator.VWAPLabel = vWAPLabel;
                indicator.VWAPLineStyle = vWAPLineStyle;
                indicator.VWAPLineWidth = vWAPLineWidth;
                indicator.VWAPSD1Color = vWAPSD1Color;
                indicator.VWAPSD1LineStyle = vWAPSD1LineStyle;
                indicator.VWAPSD1LineWidth = vWAPSD1LineWidth;
                indicator.VWAPSD2Color = vWAPSD2Color;
                indicator.VWAPSD2LineStyle = vWAPSD2LineStyle;
                indicator.VWAPSD2LineWidth = vWAPSD2LineWidth;
                indicator.VWAPSD3Color = vWAPSD3Color;
                indicator.VWAPSD3LineStyle = vWAPSD3LineStyle;
                indicator.VWAPSD3LineWidth = vWAPSD3LineWidth;
                Indicators.Add(indicator);
                indicator.SetUp();

                CDA_VolumeProfile[] tmp = new CDA_VolumeProfile[cacheCDA_VolumeProfile == null ? 1 : cacheCDA_VolumeProfile.Length + 1];
                if (cacheCDA_VolumeProfile != null)
                    cacheCDA_VolumeProfile.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheCDA_VolumeProfile = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Plots histograms of volume-at-price on price bars panel.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.CDA_VolumeProfile CDA_VolumeProfile(Color aboveAskColor, Color atAskColor, Color atBidColor, bool autoSaveMicroCompositeSettings, bool autoUpdateMCEndDate, Color belowBidColor, string bigPrintsFileDir, bool bPAlertEnabled, string bPAlertSoundFile, int bPDisplayCount, CDA_VolumeProfile_BigPrintDisplayMode bPDisplayMode, CDA_VolumeProfile_BigPrintDisplayPosition bPDisplayPosition, CDA_VolumeProfile_BigPrintFilterMode bPFilterMode, DashStyle bPHLineStyle, int bPHLineWidth, string bPLabel, Color bPLabelColor, Font bPLabelFont, int bPLabelOffset, int bPMinVolume, int bPMulipleAboveMultipleOfAverageVolume, DashStyle bPVLineStyle, int bPVLineWidth, CDA_VolumeProfile_CDCalculationModeType calcMode, string cD0Label, Color cD0LineColor, DashStyle cD0LineStyle, int cD0LineWidth, Color cDDownColor, Color cDHeadingsColor, Font cDHeadingsFont, string cDHighLabel, Color cDHighLineColor, DashStyle cDHighLineStyle, int cDHighLineWidth, DashStyle cDLineStyle, int cDLineWidth, CDA_VolumeProfile_CDLocation cDLocation, string cDLowLabel, Color cDLowLineColor, DashStyle cDLowLineStyle, int cDLowLineWidth, Color cDNeutralColor, string cDPlotLabel, Color cDUpColor, Font cDValueFont, Color cHVNBandColor, int cHVNBandOpacity, string cHVNBandOpacityToolLabel, int cHVNBandWidth, Color cHVNLineColor, DashStyle cHVNLineStyle, int cHVNLineWidth, Color closeColor, string closeLabel, DashStyle closeLineStyle, int closeLineWidth, Color cLVNBandColor, int cLVNBandOpacity, string cLVNBandOpacityToolLabel, int cLVNBandWidth, Color cLVNLineColor, DashStyle cLVNLineStyle, int cLVNLineWidth, int compositeAnchorOffset, string compositeAnchorOffsetToolLabel, CDA_VolumeProfile_CAnchorPosition compositeAnchorPosition, string compositeAnchorPositionToolLabel, DateTime compositeBeginDate, string compositeBeginDateToolLabel, Color compositeFillColor, int compositeOpacity, string compositeOpacityToolLabel, Color compositeOutlineColor, double compositeScale, string compositeScaleToolLabel, double compositeSmoothingFactor, string compositeSmoothingFactorToolLabel, bool compositeSquareOutline, string compositeVNToolLabel, int compValueNodeStrength, CDA_VolumeProfile_AnchorPositionCurrentSession currentSessionAnchorPosition, Color cVPOCColor, string cVPOCLabel, DashStyle cVPOCLineStyle, int cVPOCLineWidth, string dataFileDir, bool displayComputedAtBar, bool displayComputedAtPrice, bool displaySD1, bool displaySD2, bool displaySD3, bool displayVABand, bool drawCD0, bool drawCDHighLow, string emailAddress, string emailToAddress, bool enableCD, bool enableCHVNOpacityTool, bool enableCLVNOpacityTool, bool enableCompositeAnchorOffsetTool, bool enableCompositeAnchorPositionTool, bool enableCompositeBeginDateTool, CDA_VolumeProfile_Heatmap enableCompositeHeatmap, bool enableCompositeOpacityTool, bool enableCompositeScaleTool, bool enableCompositeSmoothingFactorTool, bool enableCompositeVNTool, bool enableHideBlockTradesButton, bool enableHideCDsButton, bool enableHideCompositeProfileButton, bool enableHideCompositeProfileValueNodesButton, bool enableHideMicroCompositeProfilesButton, bool enableHideMicroCompositeProfileValueAreasButton, bool enableHideMicroCompositeProfileValueNodesButton, bool enableHideOvernightStatsButton, bool enableHideSessionProfilesButton, bool enableMicroCompositeAnchorEdgeTool, bool enableMicroCompositeAnchorOffsetTool, bool enableMicroCompositeAnchorPositionTool, bool enableMicroCompositeDateRangeTool, CDA_VolumeProfile_Heatmap enableMicroCompositeHeatmap, bool enableMicroCompositeOpacityTool, bool enableMicroCompositeScaleTool, bool enableMicroCompositeSmoothingFactorTool, bool enableMicroCompositeVNTool, bool enablePrecisionRangeProfiling, bool enableRunLog, bool enableSessionAnchorOffsetTool, bool enableSessionAnchorPositionTool, CDA_VolumeProfile_Heatmap enableSessionHeatmap, bool enableSessionOpacityTool, bool enableSessionScaleTool, bool enableVWAP, string exportFileDir, CDA_VolumeProfile_RebuildCache exportStats, int fastPeriod, bool gAPAlertEnabled, string gAPAlertSoundFile, bool gAPAppendDate, bool gAPAppendPrice, Color gAPColor, Font gAPFont, string gAPLabel, DashStyle gAPLineStyle, int gAPLineWidth, Color highColor, string highLabel, bool highlightIB, bool highlightMCVA, bool highlightVA, DashStyle highLineStyle, int highLineWidth, Color iB15xColor, DashStyle iB15xLineStyle, int iB15xLineWidth, Color iB2xColor, DashStyle iB2xLineStyle, int iB2xLineWidth, Color iBColor, string iBH15xLabel, string iBH2xLabel, string iBHLabel, string iBL15xLabel, string iBL2xLabel, DashStyle iBLineStyle, int iBLineWidth, string iBLLabel, int iBMinutes, Color insideColor, int labelDelay, int labelDisplacement, Font labelFont, bool loadVBCache, Color lowColor, string lowLabel, DashStyle lowLineStyle, int lowLineWidth, bool mCAnchorPositionLabelFollowsValue, bool mCBeginEndByManualRect, string mCRectangleTagPrefix, Color mcVAColor, string mcVAHLabel, DashStyle mcVALineStyle, int mcVALineWidth, string mcVALLabel, double mcVAPercent, Color microCHVNColor, DashStyle microCHVNLineStyle, int microCHVNLineWidth, Color microCLVNColor, DashStyle microCLVNLineStyle, int microCLVNLineWidth, CDA_VolumeProfile_AnchorPosition microCompositeAnchorBar, CDA_VolumeProfile_AnchorEdge microCompositeAnchorEdge, string microCompositeAnchorEdgeToolLabel, int microCompositeAnchorOffset, string microCompositeAnchorOffsetToolLabel, CDA_VolumeProfile_MCAnchorPosition microCompositeAnchorPosition, string microCompositeAnchorPositionToolLabel, DateTime microCompositeBeginDate, string microCompositeDateRangeToolLabel, DateTime microCompositeEndDate, Color microCompositeFillColor, int microCompositeOpacity, string microCompositeOpacityToolLabel, Color microCompositeOutlineColor, double microCompositeScale, string microCompositeScaleToolLabel, string microCompositeSelectToolLabel, string microCompositeSmoothingFactorToolLabel, string microCompositeVNToolLabel, double microCompSmoothingFactor, bool microCompSquareOutline, Color microCVPOCColor, string microCVPOCLabel, DashStyle microCVPOCLineStyle, int microCVPOCLineWidth, int microValueNodeStrength, Color midPtColor, string midPtLabel, DashStyle midPtLineStyle, int midPtLineWidth, DateTime minVAPCacheFileDate, DateTime minVBCacheFileDate, double multiplierStdDev1, double multiplierStdDev2, double multiplierStdDev3, Color nHighColor, string nHighLabel, bool nHLAlertEnabled, string nHLAlertSoundFile, bool nHLAppendDate, bool nHLAppendPrice, Font nHLFont, DashStyle nHLLineStyle, int nHLLineWidth, bool nIBAlertEnabled, string nIBAlertSoundFile, bool nIBAppendDate, bool nIBAppendPrice, Color nIBColor, Font nIBFont, string nIBHLabel, DashStyle nIBLineStyle, int nIBLineWidth, string nIBLLabel, Color nLowColor, string nLowLabel, bool nVAAlertEnabled, string nVAAlertSoundFile, bool nVAAppendDate, bool nVAAppendPrice, Color nVAColor, Font nVAFont, string nVAHLabel, DashStyle nVALineStyle, int nVALineWidth, string nVALLabel, bool nVPOCAlertEnabled, string nVPOCAlertSoundFile, bool nVPOCAppendDate, bool nVPOCAppendPrice, Color nVPOCColor, Font nVPOCFont, string nVPOCLabel, DashStyle nVPOCLineStyle, int nVPOCLineWidth, int opacitySD1, int opacitySD2, int opacitySD3, Color openColor, string openLabel, DashStyle openLineStyle, int openLineWidth, int openSwingMaxMinutes, CDA_VolumeProfile_OperationalMode operationalMode, Color oSColor, string oSHLabel, DashStyle oSLineStyle, int oSLineWidth, string oSLLabel, Color overnightDefaultColor, int overnightDisplayPeriodHL, int overnightDisplayPeriodVPOC, Font overnightFont, Color overnightHighColor, string overnightHighLabel, DashStyle overnightHighLineStyle, int overnightHighLineWidth, Color overnightLowColor, string overnightLowLabel, DashStyle overnightLowLineStyle, int overnightLowLineWidth, string overnightStatsSessionName, Color overnightVPOCColor, string overnightVPOCLabel, DashStyle overnightVPOCLineStyle, int overnightVPOCLineWidth, bool plotCD, CDA_VolumeProfile_RebuildCache rebuildVAPCache, CDA_VolumeProfile_RebuildCache rebuildVBCache, CDA_VolumeProfile_RefreshWhen refreshCompositeCacheFile, CDA_VolumeProfile_CDReset resetCDatBar, double rolloverOffset, string rolloverToContractMonth, bool rolloverVAPCache, string rootFolder, string runLogFileDir, string runLogFilename, bool saveVBData, int sessionAnchorOffset, string sessionAnchorOffsetToolLabel, CDA_VolumeProfile_AnchorPosition sessionAnchorPosition, string sessionAnchorPositionToolLabel, string sessionCDvapHeading, Color sessionFillColor, int sessionOpacity, string sessionOpacityToolLabel, Color sessionOutlineColor, double sessionScale, string sessionScaleToolLabel, bool sessionSquareOutline, Font sessionVolumeFont, bool showBigPrints, bool showBPHLine, bool showBPVLine, bool showCDAtEachPrice, bool showCompositeBeginDate, bool showCompositeProfile, bool showCompositeVolumes, bool showCompValueNodePrice, CDA_VolumeProfile_VNMode showCompValueNodes, bool showGaps, CDA_VolumeProfile_ShowInSessions showIB, bool showIB15x, bool showIB2x, bool showIBRange, CDA_VolumeProfile_ShowInSessions showLabels, bool showMCVA, CDA_VolumeProfile_MCDatesPosition showMicroCompositeDates, bool showMicroCompositeProfile, bool showMicroCompositeVolumes, bool showMicroCompValueNodePrice, bool showMicroCompValueNodes, bool showNHLs, bool showNIBs, bool showNVAs, bool showNVPOCs, CDA_VolumeProfile_ShowInSessions showOHMLC, CDA_VolumeProfile_ShowInSessions showOS, bool showOvernightStats, bool showPriceWithLabel, bool showSessionImbalanceFactor, CDA_VolumeProfile_ShowInSessions showSessionProfile, bool showSessionRange, bool showSessionVolumes, bool showStartupMessages, bool showToolBar, bool showTrendChange, CDA_VolumeProfile_ShowInSessions showVA, bool showVARange, bool showVPOC, bool showVPOCTrack, int slowPeriod, string standardCDHeading, bool staticMCEnabled, int threshold, string toolBarHideDropDownLabel, Color toolBarTextColor, Font toolBarTextFont, Font toolBarTextFontOnFocus, string trendCDvapHeading, Color trendChangeDownColor, Color trendChangeUpColor, bool updateInRealtimeEnabled, Color vAColor, string vAHLabel, DashStyle vALineStyle, int vALineWidth, string vALLabel, int vAOpacity, double vAPercent, Color vPOCColor, string vPOCLabel, DashStyle vPOCLineStyle, int vPOCLineWidth, Color vWAPColor, string vWAPLabel, DashStyle vWAPLineStyle, int vWAPLineWidth, Color vWAPSD1Color, DashStyle vWAPSD1LineStyle, int vWAPSD1LineWidth, Color vWAPSD2Color, DashStyle vWAPSD2LineStyle, int vWAPSD2LineWidth, Color vWAPSD3Color, DashStyle vWAPSD3LineStyle, int vWAPSD3LineWidth)
        {
            return _indicator.CDA_VolumeProfile(Input, aboveAskColor, atAskColor, atBidColor, autoSaveMicroCompositeSettings, autoUpdateMCEndDate, belowBidColor, bigPrintsFileDir, bPAlertEnabled, bPAlertSoundFile, bPDisplayCount, bPDisplayMode, bPDisplayPosition, bPFilterMode, bPHLineStyle, bPHLineWidth, bPLabel, bPLabelColor, bPLabelFont, bPLabelOffset, bPMinVolume, bPMulipleAboveMultipleOfAverageVolume, bPVLineStyle, bPVLineWidth, calcMode, cD0Label, cD0LineColor, cD0LineStyle, cD0LineWidth, cDDownColor, cDHeadingsColor, cDHeadingsFont, cDHighLabel, cDHighLineColor, cDHighLineStyle, cDHighLineWidth, cDLineStyle, cDLineWidth, cDLocation, cDLowLabel, cDLowLineColor, cDLowLineStyle, cDLowLineWidth, cDNeutralColor, cDPlotLabel, cDUpColor, cDValueFont, cHVNBandColor, cHVNBandOpacity, cHVNBandOpacityToolLabel, cHVNBandWidth, cHVNLineColor, cHVNLineStyle, cHVNLineWidth, closeColor, closeLabel, closeLineStyle, closeLineWidth, cLVNBandColor, cLVNBandOpacity, cLVNBandOpacityToolLabel, cLVNBandWidth, cLVNLineColor, cLVNLineStyle, cLVNLineWidth, compositeAnchorOffset, compositeAnchorOffsetToolLabel, compositeAnchorPosition, compositeAnchorPositionToolLabel, compositeBeginDate, compositeBeginDateToolLabel, compositeFillColor, compositeOpacity, compositeOpacityToolLabel, compositeOutlineColor, compositeScale, compositeScaleToolLabel, compositeSmoothingFactor, compositeSmoothingFactorToolLabel, compositeSquareOutline, compositeVNToolLabel, compValueNodeStrength, currentSessionAnchorPosition, cVPOCColor, cVPOCLabel, cVPOCLineStyle, cVPOCLineWidth, dataFileDir, displayComputedAtBar, displayComputedAtPrice, displaySD1, displaySD2, displaySD3, displayVABand, drawCD0, drawCDHighLow, emailAddress, emailToAddress, enableCD, enableCHVNOpacityTool, enableCLVNOpacityTool, enableCompositeAnchorOffsetTool, enableCompositeAnchorPositionTool, enableCompositeBeginDateTool, enableCompositeHeatmap, enableCompositeOpacityTool, enableCompositeScaleTool, enableCompositeSmoothingFactorTool, enableCompositeVNTool, enableHideBlockTradesButton, enableHideCDsButton, enableHideCompositeProfileButton, enableHideCompositeProfileValueNodesButton, enableHideMicroCompositeProfilesButton, enableHideMicroCompositeProfileValueAreasButton, enableHideMicroCompositeProfileValueNodesButton, enableHideOvernightStatsButton, enableHideSessionProfilesButton, enableMicroCompositeAnchorEdgeTool, enableMicroCompositeAnchorOffsetTool, enableMicroCompositeAnchorPositionTool, enableMicroCompositeDateRangeTool, enableMicroCompositeHeatmap, enableMicroCompositeOpacityTool, enableMicroCompositeScaleTool, enableMicroCompositeSmoothingFactorTool, enableMicroCompositeVNTool, enablePrecisionRangeProfiling, enableRunLog, enableSessionAnchorOffsetTool, enableSessionAnchorPositionTool, enableSessionHeatmap, enableSessionOpacityTool, enableSessionScaleTool, enableVWAP, exportFileDir, exportStats, fastPeriod, gAPAlertEnabled, gAPAlertSoundFile, gAPAppendDate, gAPAppendPrice, gAPColor, gAPFont, gAPLabel, gAPLineStyle, gAPLineWidth, highColor, highLabel, highlightIB, highlightMCVA, highlightVA, highLineStyle, highLineWidth, iB15xColor, iB15xLineStyle, iB15xLineWidth, iB2xColor, iB2xLineStyle, iB2xLineWidth, iBColor, iBH15xLabel, iBH2xLabel, iBHLabel, iBL15xLabel, iBL2xLabel, iBLineStyle, iBLineWidth, iBLLabel, iBMinutes, insideColor, labelDelay, labelDisplacement, labelFont, loadVBCache, lowColor, lowLabel, lowLineStyle, lowLineWidth, mCAnchorPositionLabelFollowsValue, mCBeginEndByManualRect, mCRectangleTagPrefix, mcVAColor, mcVAHLabel, mcVALineStyle, mcVALineWidth, mcVALLabel, mcVAPercent, microCHVNColor, microCHVNLineStyle, microCHVNLineWidth, microCLVNColor, microCLVNLineStyle, microCLVNLineWidth, microCompositeAnchorBar, microCompositeAnchorEdge, microCompositeAnchorEdgeToolLabel, microCompositeAnchorOffset, microCompositeAnchorOffsetToolLabel, microCompositeAnchorPosition, microCompositeAnchorPositionToolLabel, microCompositeBeginDate, microCompositeDateRangeToolLabel, microCompositeEndDate, microCompositeFillColor, microCompositeOpacity, microCompositeOpacityToolLabel, microCompositeOutlineColor, microCompositeScale, microCompositeScaleToolLabel, microCompositeSelectToolLabel, microCompositeSmoothingFactorToolLabel, microCompositeVNToolLabel, microCompSmoothingFactor, microCompSquareOutline, microCVPOCColor, microCVPOCLabel, microCVPOCLineStyle, microCVPOCLineWidth, microValueNodeStrength, midPtColor, midPtLabel, midPtLineStyle, midPtLineWidth, minVAPCacheFileDate, minVBCacheFileDate, multiplierStdDev1, multiplierStdDev2, multiplierStdDev3, nHighColor, nHighLabel, nHLAlertEnabled, nHLAlertSoundFile, nHLAppendDate, nHLAppendPrice, nHLFont, nHLLineStyle, nHLLineWidth, nIBAlertEnabled, nIBAlertSoundFile, nIBAppendDate, nIBAppendPrice, nIBColor, nIBFont, nIBHLabel, nIBLineStyle, nIBLineWidth, nIBLLabel, nLowColor, nLowLabel, nVAAlertEnabled, nVAAlertSoundFile, nVAAppendDate, nVAAppendPrice, nVAColor, nVAFont, nVAHLabel, nVALineStyle, nVALineWidth, nVALLabel, nVPOCAlertEnabled, nVPOCAlertSoundFile, nVPOCAppendDate, nVPOCAppendPrice, nVPOCColor, nVPOCFont, nVPOCLabel, nVPOCLineStyle, nVPOCLineWidth, opacitySD1, opacitySD2, opacitySD3, openColor, openLabel, openLineStyle, openLineWidth, openSwingMaxMinutes, operationalMode, oSColor, oSHLabel, oSLineStyle, oSLineWidth, oSLLabel, overnightDefaultColor, overnightDisplayPeriodHL, overnightDisplayPeriodVPOC, overnightFont, overnightHighColor, overnightHighLabel, overnightHighLineStyle, overnightHighLineWidth, overnightLowColor, overnightLowLabel, overnightLowLineStyle, overnightLowLineWidth, overnightStatsSessionName, overnightVPOCColor, overnightVPOCLabel, overnightVPOCLineStyle, overnightVPOCLineWidth, plotCD, rebuildVAPCache, rebuildVBCache, refreshCompositeCacheFile, resetCDatBar, rolloverOffset, rolloverToContractMonth, rolloverVAPCache, rootFolder, runLogFileDir, runLogFilename, saveVBData, sessionAnchorOffset, sessionAnchorOffsetToolLabel, sessionAnchorPosition, sessionAnchorPositionToolLabel, sessionCDvapHeading, sessionFillColor, sessionOpacity, sessionOpacityToolLabel, sessionOutlineColor, sessionScale, sessionScaleToolLabel, sessionSquareOutline, sessionVolumeFont, showBigPrints, showBPHLine, showBPVLine, showCDAtEachPrice, showCompositeBeginDate, showCompositeProfile, showCompositeVolumes, showCompValueNodePrice, showCompValueNodes, showGaps, showIB, showIB15x, showIB2x, showIBRange, showLabels, showMCVA, showMicroCompositeDates, showMicroCompositeProfile, showMicroCompositeVolumes, showMicroCompValueNodePrice, showMicroCompValueNodes, showNHLs, showNIBs, showNVAs, showNVPOCs, showOHMLC, showOS, showOvernightStats, showPriceWithLabel, showSessionImbalanceFactor, showSessionProfile, showSessionRange, showSessionVolumes, showStartupMessages, showToolBar, showTrendChange, showVA, showVARange, showVPOC, showVPOCTrack, slowPeriod, standardCDHeading, staticMCEnabled, threshold, toolBarHideDropDownLabel, toolBarTextColor, toolBarTextFont, toolBarTextFontOnFocus, trendCDvapHeading, trendChangeDownColor, trendChangeUpColor, updateInRealtimeEnabled, vAColor, vAHLabel, vALineStyle, vALineWidth, vALLabel, vAOpacity, vAPercent, vPOCColor, vPOCLabel, vPOCLineStyle, vPOCLineWidth, vWAPColor, vWAPLabel, vWAPLineStyle, vWAPLineWidth, vWAPSD1Color, vWAPSD1LineStyle, vWAPSD1LineWidth, vWAPSD2Color, vWAPSD2LineStyle, vWAPSD2LineWidth, vWAPSD3Color, vWAPSD3LineStyle, vWAPSD3LineWidth);
        }

        /// <summary>
        /// Plots histograms of volume-at-price on price bars panel.
        /// </summary>
        /// <returns></returns>
        public Indicator.CDA_VolumeProfile CDA_VolumeProfile(Data.IDataSeries input, Color aboveAskColor, Color atAskColor, Color atBidColor, bool autoSaveMicroCompositeSettings, bool autoUpdateMCEndDate, Color belowBidColor, string bigPrintsFileDir, bool bPAlertEnabled, string bPAlertSoundFile, int bPDisplayCount, CDA_VolumeProfile_BigPrintDisplayMode bPDisplayMode, CDA_VolumeProfile_BigPrintDisplayPosition bPDisplayPosition, CDA_VolumeProfile_BigPrintFilterMode bPFilterMode, DashStyle bPHLineStyle, int bPHLineWidth, string bPLabel, Color bPLabelColor, Font bPLabelFont, int bPLabelOffset, int bPMinVolume, int bPMulipleAboveMultipleOfAverageVolume, DashStyle bPVLineStyle, int bPVLineWidth, CDA_VolumeProfile_CDCalculationModeType calcMode, string cD0Label, Color cD0LineColor, DashStyle cD0LineStyle, int cD0LineWidth, Color cDDownColor, Color cDHeadingsColor, Font cDHeadingsFont, string cDHighLabel, Color cDHighLineColor, DashStyle cDHighLineStyle, int cDHighLineWidth, DashStyle cDLineStyle, int cDLineWidth, CDA_VolumeProfile_CDLocation cDLocation, string cDLowLabel, Color cDLowLineColor, DashStyle cDLowLineStyle, int cDLowLineWidth, Color cDNeutralColor, string cDPlotLabel, Color cDUpColor, Font cDValueFont, Color cHVNBandColor, int cHVNBandOpacity, string cHVNBandOpacityToolLabel, int cHVNBandWidth, Color cHVNLineColor, DashStyle cHVNLineStyle, int cHVNLineWidth, Color closeColor, string closeLabel, DashStyle closeLineStyle, int closeLineWidth, Color cLVNBandColor, int cLVNBandOpacity, string cLVNBandOpacityToolLabel, int cLVNBandWidth, Color cLVNLineColor, DashStyle cLVNLineStyle, int cLVNLineWidth, int compositeAnchorOffset, string compositeAnchorOffsetToolLabel, CDA_VolumeProfile_CAnchorPosition compositeAnchorPosition, string compositeAnchorPositionToolLabel, DateTime compositeBeginDate, string compositeBeginDateToolLabel, Color compositeFillColor, int compositeOpacity, string compositeOpacityToolLabel, Color compositeOutlineColor, double compositeScale, string compositeScaleToolLabel, double compositeSmoothingFactor, string compositeSmoothingFactorToolLabel, bool compositeSquareOutline, string compositeVNToolLabel, int compValueNodeStrength, CDA_VolumeProfile_AnchorPositionCurrentSession currentSessionAnchorPosition, Color cVPOCColor, string cVPOCLabel, DashStyle cVPOCLineStyle, int cVPOCLineWidth, string dataFileDir, bool displayComputedAtBar, bool displayComputedAtPrice, bool displaySD1, bool displaySD2, bool displaySD3, bool displayVABand, bool drawCD0, bool drawCDHighLow, string emailAddress, string emailToAddress, bool enableCD, bool enableCHVNOpacityTool, bool enableCLVNOpacityTool, bool enableCompositeAnchorOffsetTool, bool enableCompositeAnchorPositionTool, bool enableCompositeBeginDateTool, CDA_VolumeProfile_Heatmap enableCompositeHeatmap, bool enableCompositeOpacityTool, bool enableCompositeScaleTool, bool enableCompositeSmoothingFactorTool, bool enableCompositeVNTool, bool enableHideBlockTradesButton, bool enableHideCDsButton, bool enableHideCompositeProfileButton, bool enableHideCompositeProfileValueNodesButton, bool enableHideMicroCompositeProfilesButton, bool enableHideMicroCompositeProfileValueAreasButton, bool enableHideMicroCompositeProfileValueNodesButton, bool enableHideOvernightStatsButton, bool enableHideSessionProfilesButton, bool enableMicroCompositeAnchorEdgeTool, bool enableMicroCompositeAnchorOffsetTool, bool enableMicroCompositeAnchorPositionTool, bool enableMicroCompositeDateRangeTool, CDA_VolumeProfile_Heatmap enableMicroCompositeHeatmap, bool enableMicroCompositeOpacityTool, bool enableMicroCompositeScaleTool, bool enableMicroCompositeSmoothingFactorTool, bool enableMicroCompositeVNTool, bool enablePrecisionRangeProfiling, bool enableRunLog, bool enableSessionAnchorOffsetTool, bool enableSessionAnchorPositionTool, CDA_VolumeProfile_Heatmap enableSessionHeatmap, bool enableSessionOpacityTool, bool enableSessionScaleTool, bool enableVWAP, string exportFileDir, CDA_VolumeProfile_RebuildCache exportStats, int fastPeriod, bool gAPAlertEnabled, string gAPAlertSoundFile, bool gAPAppendDate, bool gAPAppendPrice, Color gAPColor, Font gAPFont, string gAPLabel, DashStyle gAPLineStyle, int gAPLineWidth, Color highColor, string highLabel, bool highlightIB, bool highlightMCVA, bool highlightVA, DashStyle highLineStyle, int highLineWidth, Color iB15xColor, DashStyle iB15xLineStyle, int iB15xLineWidth, Color iB2xColor, DashStyle iB2xLineStyle, int iB2xLineWidth, Color iBColor, string iBH15xLabel, string iBH2xLabel, string iBHLabel, string iBL15xLabel, string iBL2xLabel, DashStyle iBLineStyle, int iBLineWidth, string iBLLabel, int iBMinutes, Color insideColor, int labelDelay, int labelDisplacement, Font labelFont, bool loadVBCache, Color lowColor, string lowLabel, DashStyle lowLineStyle, int lowLineWidth, bool mCAnchorPositionLabelFollowsValue, bool mCBeginEndByManualRect, string mCRectangleTagPrefix, Color mcVAColor, string mcVAHLabel, DashStyle mcVALineStyle, int mcVALineWidth, string mcVALLabel, double mcVAPercent, Color microCHVNColor, DashStyle microCHVNLineStyle, int microCHVNLineWidth, Color microCLVNColor, DashStyle microCLVNLineStyle, int microCLVNLineWidth, CDA_VolumeProfile_AnchorPosition microCompositeAnchorBar, CDA_VolumeProfile_AnchorEdge microCompositeAnchorEdge, string microCompositeAnchorEdgeToolLabel, int microCompositeAnchorOffset, string microCompositeAnchorOffsetToolLabel, CDA_VolumeProfile_MCAnchorPosition microCompositeAnchorPosition, string microCompositeAnchorPositionToolLabel, DateTime microCompositeBeginDate, string microCompositeDateRangeToolLabel, DateTime microCompositeEndDate, Color microCompositeFillColor, int microCompositeOpacity, string microCompositeOpacityToolLabel, Color microCompositeOutlineColor, double microCompositeScale, string microCompositeScaleToolLabel, string microCompositeSelectToolLabel, string microCompositeSmoothingFactorToolLabel, string microCompositeVNToolLabel, double microCompSmoothingFactor, bool microCompSquareOutline, Color microCVPOCColor, string microCVPOCLabel, DashStyle microCVPOCLineStyle, int microCVPOCLineWidth, int microValueNodeStrength, Color midPtColor, string midPtLabel, DashStyle midPtLineStyle, int midPtLineWidth, DateTime minVAPCacheFileDate, DateTime minVBCacheFileDate, double multiplierStdDev1, double multiplierStdDev2, double multiplierStdDev3, Color nHighColor, string nHighLabel, bool nHLAlertEnabled, string nHLAlertSoundFile, bool nHLAppendDate, bool nHLAppendPrice, Font nHLFont, DashStyle nHLLineStyle, int nHLLineWidth, bool nIBAlertEnabled, string nIBAlertSoundFile, bool nIBAppendDate, bool nIBAppendPrice, Color nIBColor, Font nIBFont, string nIBHLabel, DashStyle nIBLineStyle, int nIBLineWidth, string nIBLLabel, Color nLowColor, string nLowLabel, bool nVAAlertEnabled, string nVAAlertSoundFile, bool nVAAppendDate, bool nVAAppendPrice, Color nVAColor, Font nVAFont, string nVAHLabel, DashStyle nVALineStyle, int nVALineWidth, string nVALLabel, bool nVPOCAlertEnabled, string nVPOCAlertSoundFile, bool nVPOCAppendDate, bool nVPOCAppendPrice, Color nVPOCColor, Font nVPOCFont, string nVPOCLabel, DashStyle nVPOCLineStyle, int nVPOCLineWidth, int opacitySD1, int opacitySD2, int opacitySD3, Color openColor, string openLabel, DashStyle openLineStyle, int openLineWidth, int openSwingMaxMinutes, CDA_VolumeProfile_OperationalMode operationalMode, Color oSColor, string oSHLabel, DashStyle oSLineStyle, int oSLineWidth, string oSLLabel, Color overnightDefaultColor, int overnightDisplayPeriodHL, int overnightDisplayPeriodVPOC, Font overnightFont, Color overnightHighColor, string overnightHighLabel, DashStyle overnightHighLineStyle, int overnightHighLineWidth, Color overnightLowColor, string overnightLowLabel, DashStyle overnightLowLineStyle, int overnightLowLineWidth, string overnightStatsSessionName, Color overnightVPOCColor, string overnightVPOCLabel, DashStyle overnightVPOCLineStyle, int overnightVPOCLineWidth, bool plotCD, CDA_VolumeProfile_RebuildCache rebuildVAPCache, CDA_VolumeProfile_RebuildCache rebuildVBCache, CDA_VolumeProfile_RefreshWhen refreshCompositeCacheFile, CDA_VolumeProfile_CDReset resetCDatBar, double rolloverOffset, string rolloverToContractMonth, bool rolloverVAPCache, string rootFolder, string runLogFileDir, string runLogFilename, bool saveVBData, int sessionAnchorOffset, string sessionAnchorOffsetToolLabel, CDA_VolumeProfile_AnchorPosition sessionAnchorPosition, string sessionAnchorPositionToolLabel, string sessionCDvapHeading, Color sessionFillColor, int sessionOpacity, string sessionOpacityToolLabel, Color sessionOutlineColor, double sessionScale, string sessionScaleToolLabel, bool sessionSquareOutline, Font sessionVolumeFont, bool showBigPrints, bool showBPHLine, bool showBPVLine, bool showCDAtEachPrice, bool showCompositeBeginDate, bool showCompositeProfile, bool showCompositeVolumes, bool showCompValueNodePrice, CDA_VolumeProfile_VNMode showCompValueNodes, bool showGaps, CDA_VolumeProfile_ShowInSessions showIB, bool showIB15x, bool showIB2x, bool showIBRange, CDA_VolumeProfile_ShowInSessions showLabels, bool showMCVA, CDA_VolumeProfile_MCDatesPosition showMicroCompositeDates, bool showMicroCompositeProfile, bool showMicroCompositeVolumes, bool showMicroCompValueNodePrice, bool showMicroCompValueNodes, bool showNHLs, bool showNIBs, bool showNVAs, bool showNVPOCs, CDA_VolumeProfile_ShowInSessions showOHMLC, CDA_VolumeProfile_ShowInSessions showOS, bool showOvernightStats, bool showPriceWithLabel, bool showSessionImbalanceFactor, CDA_VolumeProfile_ShowInSessions showSessionProfile, bool showSessionRange, bool showSessionVolumes, bool showStartupMessages, bool showToolBar, bool showTrendChange, CDA_VolumeProfile_ShowInSessions showVA, bool showVARange, bool showVPOC, bool showVPOCTrack, int slowPeriod, string standardCDHeading, bool staticMCEnabled, int threshold, string toolBarHideDropDownLabel, Color toolBarTextColor, Font toolBarTextFont, Font toolBarTextFontOnFocus, string trendCDvapHeading, Color trendChangeDownColor, Color trendChangeUpColor, bool updateInRealtimeEnabled, Color vAColor, string vAHLabel, DashStyle vALineStyle, int vALineWidth, string vALLabel, int vAOpacity, double vAPercent, Color vPOCColor, string vPOCLabel, DashStyle vPOCLineStyle, int vPOCLineWidth, Color vWAPColor, string vWAPLabel, DashStyle vWAPLineStyle, int vWAPLineWidth, Color vWAPSD1Color, DashStyle vWAPSD1LineStyle, int vWAPSD1LineWidth, Color vWAPSD2Color, DashStyle vWAPSD2LineStyle, int vWAPSD2LineWidth, Color vWAPSD3Color, DashStyle vWAPSD3LineStyle, int vWAPSD3LineWidth)
        {
            return _indicator.CDA_VolumeProfile(input, aboveAskColor, atAskColor, atBidColor, autoSaveMicroCompositeSettings, autoUpdateMCEndDate, belowBidColor, bigPrintsFileDir, bPAlertEnabled, bPAlertSoundFile, bPDisplayCount, bPDisplayMode, bPDisplayPosition, bPFilterMode, bPHLineStyle, bPHLineWidth, bPLabel, bPLabelColor, bPLabelFont, bPLabelOffset, bPMinVolume, bPMulipleAboveMultipleOfAverageVolume, bPVLineStyle, bPVLineWidth, calcMode, cD0Label, cD0LineColor, cD0LineStyle, cD0LineWidth, cDDownColor, cDHeadingsColor, cDHeadingsFont, cDHighLabel, cDHighLineColor, cDHighLineStyle, cDHighLineWidth, cDLineStyle, cDLineWidth, cDLocation, cDLowLabel, cDLowLineColor, cDLowLineStyle, cDLowLineWidth, cDNeutralColor, cDPlotLabel, cDUpColor, cDValueFont, cHVNBandColor, cHVNBandOpacity, cHVNBandOpacityToolLabel, cHVNBandWidth, cHVNLineColor, cHVNLineStyle, cHVNLineWidth, closeColor, closeLabel, closeLineStyle, closeLineWidth, cLVNBandColor, cLVNBandOpacity, cLVNBandOpacityToolLabel, cLVNBandWidth, cLVNLineColor, cLVNLineStyle, cLVNLineWidth, compositeAnchorOffset, compositeAnchorOffsetToolLabel, compositeAnchorPosition, compositeAnchorPositionToolLabel, compositeBeginDate, compositeBeginDateToolLabel, compositeFillColor, compositeOpacity, compositeOpacityToolLabel, compositeOutlineColor, compositeScale, compositeScaleToolLabel, compositeSmoothingFactor, compositeSmoothingFactorToolLabel, compositeSquareOutline, compositeVNToolLabel, compValueNodeStrength, currentSessionAnchorPosition, cVPOCColor, cVPOCLabel, cVPOCLineStyle, cVPOCLineWidth, dataFileDir, displayComputedAtBar, displayComputedAtPrice, displaySD1, displaySD2, displaySD3, displayVABand, drawCD0, drawCDHighLow, emailAddress, emailToAddress, enableCD, enableCHVNOpacityTool, enableCLVNOpacityTool, enableCompositeAnchorOffsetTool, enableCompositeAnchorPositionTool, enableCompositeBeginDateTool, enableCompositeHeatmap, enableCompositeOpacityTool, enableCompositeScaleTool, enableCompositeSmoothingFactorTool, enableCompositeVNTool, enableHideBlockTradesButton, enableHideCDsButton, enableHideCompositeProfileButton, enableHideCompositeProfileValueNodesButton, enableHideMicroCompositeProfilesButton, enableHideMicroCompositeProfileValueAreasButton, enableHideMicroCompositeProfileValueNodesButton, enableHideOvernightStatsButton, enableHideSessionProfilesButton, enableMicroCompositeAnchorEdgeTool, enableMicroCompositeAnchorOffsetTool, enableMicroCompositeAnchorPositionTool, enableMicroCompositeDateRangeTool, enableMicroCompositeHeatmap, enableMicroCompositeOpacityTool, enableMicroCompositeScaleTool, enableMicroCompositeSmoothingFactorTool, enableMicroCompositeVNTool, enablePrecisionRangeProfiling, enableRunLog, enableSessionAnchorOffsetTool, enableSessionAnchorPositionTool, enableSessionHeatmap, enableSessionOpacityTool, enableSessionScaleTool, enableVWAP, exportFileDir, exportStats, fastPeriod, gAPAlertEnabled, gAPAlertSoundFile, gAPAppendDate, gAPAppendPrice, gAPColor, gAPFont, gAPLabel, gAPLineStyle, gAPLineWidth, highColor, highLabel, highlightIB, highlightMCVA, highlightVA, highLineStyle, highLineWidth, iB15xColor, iB15xLineStyle, iB15xLineWidth, iB2xColor, iB2xLineStyle, iB2xLineWidth, iBColor, iBH15xLabel, iBH2xLabel, iBHLabel, iBL15xLabel, iBL2xLabel, iBLineStyle, iBLineWidth, iBLLabel, iBMinutes, insideColor, labelDelay, labelDisplacement, labelFont, loadVBCache, lowColor, lowLabel, lowLineStyle, lowLineWidth, mCAnchorPositionLabelFollowsValue, mCBeginEndByManualRect, mCRectangleTagPrefix, mcVAColor, mcVAHLabel, mcVALineStyle, mcVALineWidth, mcVALLabel, mcVAPercent, microCHVNColor, microCHVNLineStyle, microCHVNLineWidth, microCLVNColor, microCLVNLineStyle, microCLVNLineWidth, microCompositeAnchorBar, microCompositeAnchorEdge, microCompositeAnchorEdgeToolLabel, microCompositeAnchorOffset, microCompositeAnchorOffsetToolLabel, microCompositeAnchorPosition, microCompositeAnchorPositionToolLabel, microCompositeBeginDate, microCompositeDateRangeToolLabel, microCompositeEndDate, microCompositeFillColor, microCompositeOpacity, microCompositeOpacityToolLabel, microCompositeOutlineColor, microCompositeScale, microCompositeScaleToolLabel, microCompositeSelectToolLabel, microCompositeSmoothingFactorToolLabel, microCompositeVNToolLabel, microCompSmoothingFactor, microCompSquareOutline, microCVPOCColor, microCVPOCLabel, microCVPOCLineStyle, microCVPOCLineWidth, microValueNodeStrength, midPtColor, midPtLabel, midPtLineStyle, midPtLineWidth, minVAPCacheFileDate, minVBCacheFileDate, multiplierStdDev1, multiplierStdDev2, multiplierStdDev3, nHighColor, nHighLabel, nHLAlertEnabled, nHLAlertSoundFile, nHLAppendDate, nHLAppendPrice, nHLFont, nHLLineStyle, nHLLineWidth, nIBAlertEnabled, nIBAlertSoundFile, nIBAppendDate, nIBAppendPrice, nIBColor, nIBFont, nIBHLabel, nIBLineStyle, nIBLineWidth, nIBLLabel, nLowColor, nLowLabel, nVAAlertEnabled, nVAAlertSoundFile, nVAAppendDate, nVAAppendPrice, nVAColor, nVAFont, nVAHLabel, nVALineStyle, nVALineWidth, nVALLabel, nVPOCAlertEnabled, nVPOCAlertSoundFile, nVPOCAppendDate, nVPOCAppendPrice, nVPOCColor, nVPOCFont, nVPOCLabel, nVPOCLineStyle, nVPOCLineWidth, opacitySD1, opacitySD2, opacitySD3, openColor, openLabel, openLineStyle, openLineWidth, openSwingMaxMinutes, operationalMode, oSColor, oSHLabel, oSLineStyle, oSLineWidth, oSLLabel, overnightDefaultColor, overnightDisplayPeriodHL, overnightDisplayPeriodVPOC, overnightFont, overnightHighColor, overnightHighLabel, overnightHighLineStyle, overnightHighLineWidth, overnightLowColor, overnightLowLabel, overnightLowLineStyle, overnightLowLineWidth, overnightStatsSessionName, overnightVPOCColor, overnightVPOCLabel, overnightVPOCLineStyle, overnightVPOCLineWidth, plotCD, rebuildVAPCache, rebuildVBCache, refreshCompositeCacheFile, resetCDatBar, rolloverOffset, rolloverToContractMonth, rolloverVAPCache, rootFolder, runLogFileDir, runLogFilename, saveVBData, sessionAnchorOffset, sessionAnchorOffsetToolLabel, sessionAnchorPosition, sessionAnchorPositionToolLabel, sessionCDvapHeading, sessionFillColor, sessionOpacity, sessionOpacityToolLabel, sessionOutlineColor, sessionScale, sessionScaleToolLabel, sessionSquareOutline, sessionVolumeFont, showBigPrints, showBPHLine, showBPVLine, showCDAtEachPrice, showCompositeBeginDate, showCompositeProfile, showCompositeVolumes, showCompValueNodePrice, showCompValueNodes, showGaps, showIB, showIB15x, showIB2x, showIBRange, showLabels, showMCVA, showMicroCompositeDates, showMicroCompositeProfile, showMicroCompositeVolumes, showMicroCompValueNodePrice, showMicroCompValueNodes, showNHLs, showNIBs, showNVAs, showNVPOCs, showOHMLC, showOS, showOvernightStats, showPriceWithLabel, showSessionImbalanceFactor, showSessionProfile, showSessionRange, showSessionVolumes, showStartupMessages, showToolBar, showTrendChange, showVA, showVARange, showVPOC, showVPOCTrack, slowPeriod, standardCDHeading, staticMCEnabled, threshold, toolBarHideDropDownLabel, toolBarTextColor, toolBarTextFont, toolBarTextFontOnFocus, trendCDvapHeading, trendChangeDownColor, trendChangeUpColor, updateInRealtimeEnabled, vAColor, vAHLabel, vALineStyle, vALineWidth, vALLabel, vAOpacity, vAPercent, vPOCColor, vPOCLabel, vPOCLineStyle, vPOCLineWidth, vWAPColor, vWAPLabel, vWAPLineStyle, vWAPLineWidth, vWAPSD1Color, vWAPSD1LineStyle, vWAPSD1LineWidth, vWAPSD2Color, vWAPSD2LineStyle, vWAPSD2LineWidth, vWAPSD3Color, vWAPSD3LineStyle, vWAPSD3LineWidth);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Plots histograms of volume-at-price on price bars panel.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.CDA_VolumeProfile CDA_VolumeProfile(Color aboveAskColor, Color atAskColor, Color atBidColor, bool autoSaveMicroCompositeSettings, bool autoUpdateMCEndDate, Color belowBidColor, string bigPrintsFileDir, bool bPAlertEnabled, string bPAlertSoundFile, int bPDisplayCount, CDA_VolumeProfile_BigPrintDisplayMode bPDisplayMode, CDA_VolumeProfile_BigPrintDisplayPosition bPDisplayPosition, CDA_VolumeProfile_BigPrintFilterMode bPFilterMode, DashStyle bPHLineStyle, int bPHLineWidth, string bPLabel, Color bPLabelColor, Font bPLabelFont, int bPLabelOffset, int bPMinVolume, int bPMulipleAboveMultipleOfAverageVolume, DashStyle bPVLineStyle, int bPVLineWidth, CDA_VolumeProfile_CDCalculationModeType calcMode, string cD0Label, Color cD0LineColor, DashStyle cD0LineStyle, int cD0LineWidth, Color cDDownColor, Color cDHeadingsColor, Font cDHeadingsFont, string cDHighLabel, Color cDHighLineColor, DashStyle cDHighLineStyle, int cDHighLineWidth, DashStyle cDLineStyle, int cDLineWidth, CDA_VolumeProfile_CDLocation cDLocation, string cDLowLabel, Color cDLowLineColor, DashStyle cDLowLineStyle, int cDLowLineWidth, Color cDNeutralColor, string cDPlotLabel, Color cDUpColor, Font cDValueFont, Color cHVNBandColor, int cHVNBandOpacity, string cHVNBandOpacityToolLabel, int cHVNBandWidth, Color cHVNLineColor, DashStyle cHVNLineStyle, int cHVNLineWidth, Color closeColor, string closeLabel, DashStyle closeLineStyle, int closeLineWidth, Color cLVNBandColor, int cLVNBandOpacity, string cLVNBandOpacityToolLabel, int cLVNBandWidth, Color cLVNLineColor, DashStyle cLVNLineStyle, int cLVNLineWidth, int compositeAnchorOffset, string compositeAnchorOffsetToolLabel, CDA_VolumeProfile_CAnchorPosition compositeAnchorPosition, string compositeAnchorPositionToolLabel, DateTime compositeBeginDate, string compositeBeginDateToolLabel, Color compositeFillColor, int compositeOpacity, string compositeOpacityToolLabel, Color compositeOutlineColor, double compositeScale, string compositeScaleToolLabel, double compositeSmoothingFactor, string compositeSmoothingFactorToolLabel, bool compositeSquareOutline, string compositeVNToolLabel, int compValueNodeStrength, CDA_VolumeProfile_AnchorPositionCurrentSession currentSessionAnchorPosition, Color cVPOCColor, string cVPOCLabel, DashStyle cVPOCLineStyle, int cVPOCLineWidth, string dataFileDir, bool displayComputedAtBar, bool displayComputedAtPrice, bool displaySD1, bool displaySD2, bool displaySD3, bool displayVABand, bool drawCD0, bool drawCDHighLow, string emailAddress, string emailToAddress, bool enableCD, bool enableCHVNOpacityTool, bool enableCLVNOpacityTool, bool enableCompositeAnchorOffsetTool, bool enableCompositeAnchorPositionTool, bool enableCompositeBeginDateTool, CDA_VolumeProfile_Heatmap enableCompositeHeatmap, bool enableCompositeOpacityTool, bool enableCompositeScaleTool, bool enableCompositeSmoothingFactorTool, bool enableCompositeVNTool, bool enableHideBlockTradesButton, bool enableHideCDsButton, bool enableHideCompositeProfileButton, bool enableHideCompositeProfileValueNodesButton, bool enableHideMicroCompositeProfilesButton, bool enableHideMicroCompositeProfileValueAreasButton, bool enableHideMicroCompositeProfileValueNodesButton, bool enableHideOvernightStatsButton, bool enableHideSessionProfilesButton, bool enableMicroCompositeAnchorEdgeTool, bool enableMicroCompositeAnchorOffsetTool, bool enableMicroCompositeAnchorPositionTool, bool enableMicroCompositeDateRangeTool, CDA_VolumeProfile_Heatmap enableMicroCompositeHeatmap, bool enableMicroCompositeOpacityTool, bool enableMicroCompositeScaleTool, bool enableMicroCompositeSmoothingFactorTool, bool enableMicroCompositeVNTool, bool enablePrecisionRangeProfiling, bool enableRunLog, bool enableSessionAnchorOffsetTool, bool enableSessionAnchorPositionTool, CDA_VolumeProfile_Heatmap enableSessionHeatmap, bool enableSessionOpacityTool, bool enableSessionScaleTool, bool enableVWAP, string exportFileDir, CDA_VolumeProfile_RebuildCache exportStats, int fastPeriod, bool gAPAlertEnabled, string gAPAlertSoundFile, bool gAPAppendDate, bool gAPAppendPrice, Color gAPColor, Font gAPFont, string gAPLabel, DashStyle gAPLineStyle, int gAPLineWidth, Color highColor, string highLabel, bool highlightIB, bool highlightMCVA, bool highlightVA, DashStyle highLineStyle, int highLineWidth, Color iB15xColor, DashStyle iB15xLineStyle, int iB15xLineWidth, Color iB2xColor, DashStyle iB2xLineStyle, int iB2xLineWidth, Color iBColor, string iBH15xLabel, string iBH2xLabel, string iBHLabel, string iBL15xLabel, string iBL2xLabel, DashStyle iBLineStyle, int iBLineWidth, string iBLLabel, int iBMinutes, Color insideColor, int labelDelay, int labelDisplacement, Font labelFont, bool loadVBCache, Color lowColor, string lowLabel, DashStyle lowLineStyle, int lowLineWidth, bool mCAnchorPositionLabelFollowsValue, bool mCBeginEndByManualRect, string mCRectangleTagPrefix, Color mcVAColor, string mcVAHLabel, DashStyle mcVALineStyle, int mcVALineWidth, string mcVALLabel, double mcVAPercent, Color microCHVNColor, DashStyle microCHVNLineStyle, int microCHVNLineWidth, Color microCLVNColor, DashStyle microCLVNLineStyle, int microCLVNLineWidth, CDA_VolumeProfile_AnchorPosition microCompositeAnchorBar, CDA_VolumeProfile_AnchorEdge microCompositeAnchorEdge, string microCompositeAnchorEdgeToolLabel, int microCompositeAnchorOffset, string microCompositeAnchorOffsetToolLabel, CDA_VolumeProfile_MCAnchorPosition microCompositeAnchorPosition, string microCompositeAnchorPositionToolLabel, DateTime microCompositeBeginDate, string microCompositeDateRangeToolLabel, DateTime microCompositeEndDate, Color microCompositeFillColor, int microCompositeOpacity, string microCompositeOpacityToolLabel, Color microCompositeOutlineColor, double microCompositeScale, string microCompositeScaleToolLabel, string microCompositeSelectToolLabel, string microCompositeSmoothingFactorToolLabel, string microCompositeVNToolLabel, double microCompSmoothingFactor, bool microCompSquareOutline, Color microCVPOCColor, string microCVPOCLabel, DashStyle microCVPOCLineStyle, int microCVPOCLineWidth, int microValueNodeStrength, Color midPtColor, string midPtLabel, DashStyle midPtLineStyle, int midPtLineWidth, DateTime minVAPCacheFileDate, DateTime minVBCacheFileDate, double multiplierStdDev1, double multiplierStdDev2, double multiplierStdDev3, Color nHighColor, string nHighLabel, bool nHLAlertEnabled, string nHLAlertSoundFile, bool nHLAppendDate, bool nHLAppendPrice, Font nHLFont, DashStyle nHLLineStyle, int nHLLineWidth, bool nIBAlertEnabled, string nIBAlertSoundFile, bool nIBAppendDate, bool nIBAppendPrice, Color nIBColor, Font nIBFont, string nIBHLabel, DashStyle nIBLineStyle, int nIBLineWidth, string nIBLLabel, Color nLowColor, string nLowLabel, bool nVAAlertEnabled, string nVAAlertSoundFile, bool nVAAppendDate, bool nVAAppendPrice, Color nVAColor, Font nVAFont, string nVAHLabel, DashStyle nVALineStyle, int nVALineWidth, string nVALLabel, bool nVPOCAlertEnabled, string nVPOCAlertSoundFile, bool nVPOCAppendDate, bool nVPOCAppendPrice, Color nVPOCColor, Font nVPOCFont, string nVPOCLabel, DashStyle nVPOCLineStyle, int nVPOCLineWidth, int opacitySD1, int opacitySD2, int opacitySD3, Color openColor, string openLabel, DashStyle openLineStyle, int openLineWidth, int openSwingMaxMinutes, CDA_VolumeProfile_OperationalMode operationalMode, Color oSColor, string oSHLabel, DashStyle oSLineStyle, int oSLineWidth, string oSLLabel, Color overnightDefaultColor, int overnightDisplayPeriodHL, int overnightDisplayPeriodVPOC, Font overnightFont, Color overnightHighColor, string overnightHighLabel, DashStyle overnightHighLineStyle, int overnightHighLineWidth, Color overnightLowColor, string overnightLowLabel, DashStyle overnightLowLineStyle, int overnightLowLineWidth, string overnightStatsSessionName, Color overnightVPOCColor, string overnightVPOCLabel, DashStyle overnightVPOCLineStyle, int overnightVPOCLineWidth, bool plotCD, CDA_VolumeProfile_RebuildCache rebuildVAPCache, CDA_VolumeProfile_RebuildCache rebuildVBCache, CDA_VolumeProfile_RefreshWhen refreshCompositeCacheFile, CDA_VolumeProfile_CDReset resetCDatBar, double rolloverOffset, string rolloverToContractMonth, bool rolloverVAPCache, string rootFolder, string runLogFileDir, string runLogFilename, bool saveVBData, int sessionAnchorOffset, string sessionAnchorOffsetToolLabel, CDA_VolumeProfile_AnchorPosition sessionAnchorPosition, string sessionAnchorPositionToolLabel, string sessionCDvapHeading, Color sessionFillColor, int sessionOpacity, string sessionOpacityToolLabel, Color sessionOutlineColor, double sessionScale, string sessionScaleToolLabel, bool sessionSquareOutline, Font sessionVolumeFont, bool showBigPrints, bool showBPHLine, bool showBPVLine, bool showCDAtEachPrice, bool showCompositeBeginDate, bool showCompositeProfile, bool showCompositeVolumes, bool showCompValueNodePrice, CDA_VolumeProfile_VNMode showCompValueNodes, bool showGaps, CDA_VolumeProfile_ShowInSessions showIB, bool showIB15x, bool showIB2x, bool showIBRange, CDA_VolumeProfile_ShowInSessions showLabels, bool showMCVA, CDA_VolumeProfile_MCDatesPosition showMicroCompositeDates, bool showMicroCompositeProfile, bool showMicroCompositeVolumes, bool showMicroCompValueNodePrice, bool showMicroCompValueNodes, bool showNHLs, bool showNIBs, bool showNVAs, bool showNVPOCs, CDA_VolumeProfile_ShowInSessions showOHMLC, CDA_VolumeProfile_ShowInSessions showOS, bool showOvernightStats, bool showPriceWithLabel, bool showSessionImbalanceFactor, CDA_VolumeProfile_ShowInSessions showSessionProfile, bool showSessionRange, bool showSessionVolumes, bool showStartupMessages, bool showToolBar, bool showTrendChange, CDA_VolumeProfile_ShowInSessions showVA, bool showVARange, bool showVPOC, bool showVPOCTrack, int slowPeriod, string standardCDHeading, bool staticMCEnabled, int threshold, string toolBarHideDropDownLabel, Color toolBarTextColor, Font toolBarTextFont, Font toolBarTextFontOnFocus, string trendCDvapHeading, Color trendChangeDownColor, Color trendChangeUpColor, bool updateInRealtimeEnabled, Color vAColor, string vAHLabel, DashStyle vALineStyle, int vALineWidth, string vALLabel, int vAOpacity, double vAPercent, Color vPOCColor, string vPOCLabel, DashStyle vPOCLineStyle, int vPOCLineWidth, Color vWAPColor, string vWAPLabel, DashStyle vWAPLineStyle, int vWAPLineWidth, Color vWAPSD1Color, DashStyle vWAPSD1LineStyle, int vWAPSD1LineWidth, Color vWAPSD2Color, DashStyle vWAPSD2LineStyle, int vWAPSD2LineWidth, Color vWAPSD3Color, DashStyle vWAPSD3LineStyle, int vWAPSD3LineWidth)
        {
            return _indicator.CDA_VolumeProfile(Input, aboveAskColor, atAskColor, atBidColor, autoSaveMicroCompositeSettings, autoUpdateMCEndDate, belowBidColor, bigPrintsFileDir, bPAlertEnabled, bPAlertSoundFile, bPDisplayCount, bPDisplayMode, bPDisplayPosition, bPFilterMode, bPHLineStyle, bPHLineWidth, bPLabel, bPLabelColor, bPLabelFont, bPLabelOffset, bPMinVolume, bPMulipleAboveMultipleOfAverageVolume, bPVLineStyle, bPVLineWidth, calcMode, cD0Label, cD0LineColor, cD0LineStyle, cD0LineWidth, cDDownColor, cDHeadingsColor, cDHeadingsFont, cDHighLabel, cDHighLineColor, cDHighLineStyle, cDHighLineWidth, cDLineStyle, cDLineWidth, cDLocation, cDLowLabel, cDLowLineColor, cDLowLineStyle, cDLowLineWidth, cDNeutralColor, cDPlotLabel, cDUpColor, cDValueFont, cHVNBandColor, cHVNBandOpacity, cHVNBandOpacityToolLabel, cHVNBandWidth, cHVNLineColor, cHVNLineStyle, cHVNLineWidth, closeColor, closeLabel, closeLineStyle, closeLineWidth, cLVNBandColor, cLVNBandOpacity, cLVNBandOpacityToolLabel, cLVNBandWidth, cLVNLineColor, cLVNLineStyle, cLVNLineWidth, compositeAnchorOffset, compositeAnchorOffsetToolLabel, compositeAnchorPosition, compositeAnchorPositionToolLabel, compositeBeginDate, compositeBeginDateToolLabel, compositeFillColor, compositeOpacity, compositeOpacityToolLabel, compositeOutlineColor, compositeScale, compositeScaleToolLabel, compositeSmoothingFactor, compositeSmoothingFactorToolLabel, compositeSquareOutline, compositeVNToolLabel, compValueNodeStrength, currentSessionAnchorPosition, cVPOCColor, cVPOCLabel, cVPOCLineStyle, cVPOCLineWidth, dataFileDir, displayComputedAtBar, displayComputedAtPrice, displaySD1, displaySD2, displaySD3, displayVABand, drawCD0, drawCDHighLow, emailAddress, emailToAddress, enableCD, enableCHVNOpacityTool, enableCLVNOpacityTool, enableCompositeAnchorOffsetTool, enableCompositeAnchorPositionTool, enableCompositeBeginDateTool, enableCompositeHeatmap, enableCompositeOpacityTool, enableCompositeScaleTool, enableCompositeSmoothingFactorTool, enableCompositeVNTool, enableHideBlockTradesButton, enableHideCDsButton, enableHideCompositeProfileButton, enableHideCompositeProfileValueNodesButton, enableHideMicroCompositeProfilesButton, enableHideMicroCompositeProfileValueAreasButton, enableHideMicroCompositeProfileValueNodesButton, enableHideOvernightStatsButton, enableHideSessionProfilesButton, enableMicroCompositeAnchorEdgeTool, enableMicroCompositeAnchorOffsetTool, enableMicroCompositeAnchorPositionTool, enableMicroCompositeDateRangeTool, enableMicroCompositeHeatmap, enableMicroCompositeOpacityTool, enableMicroCompositeScaleTool, enableMicroCompositeSmoothingFactorTool, enableMicroCompositeVNTool, enablePrecisionRangeProfiling, enableRunLog, enableSessionAnchorOffsetTool, enableSessionAnchorPositionTool, enableSessionHeatmap, enableSessionOpacityTool, enableSessionScaleTool, enableVWAP, exportFileDir, exportStats, fastPeriod, gAPAlertEnabled, gAPAlertSoundFile, gAPAppendDate, gAPAppendPrice, gAPColor, gAPFont, gAPLabel, gAPLineStyle, gAPLineWidth, highColor, highLabel, highlightIB, highlightMCVA, highlightVA, highLineStyle, highLineWidth, iB15xColor, iB15xLineStyle, iB15xLineWidth, iB2xColor, iB2xLineStyle, iB2xLineWidth, iBColor, iBH15xLabel, iBH2xLabel, iBHLabel, iBL15xLabel, iBL2xLabel, iBLineStyle, iBLineWidth, iBLLabel, iBMinutes, insideColor, labelDelay, labelDisplacement, labelFont, loadVBCache, lowColor, lowLabel, lowLineStyle, lowLineWidth, mCAnchorPositionLabelFollowsValue, mCBeginEndByManualRect, mCRectangleTagPrefix, mcVAColor, mcVAHLabel, mcVALineStyle, mcVALineWidth, mcVALLabel, mcVAPercent, microCHVNColor, microCHVNLineStyle, microCHVNLineWidth, microCLVNColor, microCLVNLineStyle, microCLVNLineWidth, microCompositeAnchorBar, microCompositeAnchorEdge, microCompositeAnchorEdgeToolLabel, microCompositeAnchorOffset, microCompositeAnchorOffsetToolLabel, microCompositeAnchorPosition, microCompositeAnchorPositionToolLabel, microCompositeBeginDate, microCompositeDateRangeToolLabel, microCompositeEndDate, microCompositeFillColor, microCompositeOpacity, microCompositeOpacityToolLabel, microCompositeOutlineColor, microCompositeScale, microCompositeScaleToolLabel, microCompositeSelectToolLabel, microCompositeSmoothingFactorToolLabel, microCompositeVNToolLabel, microCompSmoothingFactor, microCompSquareOutline, microCVPOCColor, microCVPOCLabel, microCVPOCLineStyle, microCVPOCLineWidth, microValueNodeStrength, midPtColor, midPtLabel, midPtLineStyle, midPtLineWidth, minVAPCacheFileDate, minVBCacheFileDate, multiplierStdDev1, multiplierStdDev2, multiplierStdDev3, nHighColor, nHighLabel, nHLAlertEnabled, nHLAlertSoundFile, nHLAppendDate, nHLAppendPrice, nHLFont, nHLLineStyle, nHLLineWidth, nIBAlertEnabled, nIBAlertSoundFile, nIBAppendDate, nIBAppendPrice, nIBColor, nIBFont, nIBHLabel, nIBLineStyle, nIBLineWidth, nIBLLabel, nLowColor, nLowLabel, nVAAlertEnabled, nVAAlertSoundFile, nVAAppendDate, nVAAppendPrice, nVAColor, nVAFont, nVAHLabel, nVALineStyle, nVALineWidth, nVALLabel, nVPOCAlertEnabled, nVPOCAlertSoundFile, nVPOCAppendDate, nVPOCAppendPrice, nVPOCColor, nVPOCFont, nVPOCLabel, nVPOCLineStyle, nVPOCLineWidth, opacitySD1, opacitySD2, opacitySD3, openColor, openLabel, openLineStyle, openLineWidth, openSwingMaxMinutes, operationalMode, oSColor, oSHLabel, oSLineStyle, oSLineWidth, oSLLabel, overnightDefaultColor, overnightDisplayPeriodHL, overnightDisplayPeriodVPOC, overnightFont, overnightHighColor, overnightHighLabel, overnightHighLineStyle, overnightHighLineWidth, overnightLowColor, overnightLowLabel, overnightLowLineStyle, overnightLowLineWidth, overnightStatsSessionName, overnightVPOCColor, overnightVPOCLabel, overnightVPOCLineStyle, overnightVPOCLineWidth, plotCD, rebuildVAPCache, rebuildVBCache, refreshCompositeCacheFile, resetCDatBar, rolloverOffset, rolloverToContractMonth, rolloverVAPCache, rootFolder, runLogFileDir, runLogFilename, saveVBData, sessionAnchorOffset, sessionAnchorOffsetToolLabel, sessionAnchorPosition, sessionAnchorPositionToolLabel, sessionCDvapHeading, sessionFillColor, sessionOpacity, sessionOpacityToolLabel, sessionOutlineColor, sessionScale, sessionScaleToolLabel, sessionSquareOutline, sessionVolumeFont, showBigPrints, showBPHLine, showBPVLine, showCDAtEachPrice, showCompositeBeginDate, showCompositeProfile, showCompositeVolumes, showCompValueNodePrice, showCompValueNodes, showGaps, showIB, showIB15x, showIB2x, showIBRange, showLabels, showMCVA, showMicroCompositeDates, showMicroCompositeProfile, showMicroCompositeVolumes, showMicroCompValueNodePrice, showMicroCompValueNodes, showNHLs, showNIBs, showNVAs, showNVPOCs, showOHMLC, showOS, showOvernightStats, showPriceWithLabel, showSessionImbalanceFactor, showSessionProfile, showSessionRange, showSessionVolumes, showStartupMessages, showToolBar, showTrendChange, showVA, showVARange, showVPOC, showVPOCTrack, slowPeriod, standardCDHeading, staticMCEnabled, threshold, toolBarHideDropDownLabel, toolBarTextColor, toolBarTextFont, toolBarTextFontOnFocus, trendCDvapHeading, trendChangeDownColor, trendChangeUpColor, updateInRealtimeEnabled, vAColor, vAHLabel, vALineStyle, vALineWidth, vALLabel, vAOpacity, vAPercent, vPOCColor, vPOCLabel, vPOCLineStyle, vPOCLineWidth, vWAPColor, vWAPLabel, vWAPLineStyle, vWAPLineWidth, vWAPSD1Color, vWAPSD1LineStyle, vWAPSD1LineWidth, vWAPSD2Color, vWAPSD2LineStyle, vWAPSD2LineWidth, vWAPSD3Color, vWAPSD3LineStyle, vWAPSD3LineWidth);
        }

        /// <summary>
        /// Plots histograms of volume-at-price on price bars panel.
        /// </summary>
        /// <returns></returns>
        public Indicator.CDA_VolumeProfile CDA_VolumeProfile(Data.IDataSeries input, Color aboveAskColor, Color atAskColor, Color atBidColor, bool autoSaveMicroCompositeSettings, bool autoUpdateMCEndDate, Color belowBidColor, string bigPrintsFileDir, bool bPAlertEnabled, string bPAlertSoundFile, int bPDisplayCount, CDA_VolumeProfile_BigPrintDisplayMode bPDisplayMode, CDA_VolumeProfile_BigPrintDisplayPosition bPDisplayPosition, CDA_VolumeProfile_BigPrintFilterMode bPFilterMode, DashStyle bPHLineStyle, int bPHLineWidth, string bPLabel, Color bPLabelColor, Font bPLabelFont, int bPLabelOffset, int bPMinVolume, int bPMulipleAboveMultipleOfAverageVolume, DashStyle bPVLineStyle, int bPVLineWidth, CDA_VolumeProfile_CDCalculationModeType calcMode, string cD0Label, Color cD0LineColor, DashStyle cD0LineStyle, int cD0LineWidth, Color cDDownColor, Color cDHeadingsColor, Font cDHeadingsFont, string cDHighLabel, Color cDHighLineColor, DashStyle cDHighLineStyle, int cDHighLineWidth, DashStyle cDLineStyle, int cDLineWidth, CDA_VolumeProfile_CDLocation cDLocation, string cDLowLabel, Color cDLowLineColor, DashStyle cDLowLineStyle, int cDLowLineWidth, Color cDNeutralColor, string cDPlotLabel, Color cDUpColor, Font cDValueFont, Color cHVNBandColor, int cHVNBandOpacity, string cHVNBandOpacityToolLabel, int cHVNBandWidth, Color cHVNLineColor, DashStyle cHVNLineStyle, int cHVNLineWidth, Color closeColor, string closeLabel, DashStyle closeLineStyle, int closeLineWidth, Color cLVNBandColor, int cLVNBandOpacity, string cLVNBandOpacityToolLabel, int cLVNBandWidth, Color cLVNLineColor, DashStyle cLVNLineStyle, int cLVNLineWidth, int compositeAnchorOffset, string compositeAnchorOffsetToolLabel, CDA_VolumeProfile_CAnchorPosition compositeAnchorPosition, string compositeAnchorPositionToolLabel, DateTime compositeBeginDate, string compositeBeginDateToolLabel, Color compositeFillColor, int compositeOpacity, string compositeOpacityToolLabel, Color compositeOutlineColor, double compositeScale, string compositeScaleToolLabel, double compositeSmoothingFactor, string compositeSmoothingFactorToolLabel, bool compositeSquareOutline, string compositeVNToolLabel, int compValueNodeStrength, CDA_VolumeProfile_AnchorPositionCurrentSession currentSessionAnchorPosition, Color cVPOCColor, string cVPOCLabel, DashStyle cVPOCLineStyle, int cVPOCLineWidth, string dataFileDir, bool displayComputedAtBar, bool displayComputedAtPrice, bool displaySD1, bool displaySD2, bool displaySD3, bool displayVABand, bool drawCD0, bool drawCDHighLow, string emailAddress, string emailToAddress, bool enableCD, bool enableCHVNOpacityTool, bool enableCLVNOpacityTool, bool enableCompositeAnchorOffsetTool, bool enableCompositeAnchorPositionTool, bool enableCompositeBeginDateTool, CDA_VolumeProfile_Heatmap enableCompositeHeatmap, bool enableCompositeOpacityTool, bool enableCompositeScaleTool, bool enableCompositeSmoothingFactorTool, bool enableCompositeVNTool, bool enableHideBlockTradesButton, bool enableHideCDsButton, bool enableHideCompositeProfileButton, bool enableHideCompositeProfileValueNodesButton, bool enableHideMicroCompositeProfilesButton, bool enableHideMicroCompositeProfileValueAreasButton, bool enableHideMicroCompositeProfileValueNodesButton, bool enableHideOvernightStatsButton, bool enableHideSessionProfilesButton, bool enableMicroCompositeAnchorEdgeTool, bool enableMicroCompositeAnchorOffsetTool, bool enableMicroCompositeAnchorPositionTool, bool enableMicroCompositeDateRangeTool, CDA_VolumeProfile_Heatmap enableMicroCompositeHeatmap, bool enableMicroCompositeOpacityTool, bool enableMicroCompositeScaleTool, bool enableMicroCompositeSmoothingFactorTool, bool enableMicroCompositeVNTool, bool enablePrecisionRangeProfiling, bool enableRunLog, bool enableSessionAnchorOffsetTool, bool enableSessionAnchorPositionTool, CDA_VolumeProfile_Heatmap enableSessionHeatmap, bool enableSessionOpacityTool, bool enableSessionScaleTool, bool enableVWAP, string exportFileDir, CDA_VolumeProfile_RebuildCache exportStats, int fastPeriod, bool gAPAlertEnabled, string gAPAlertSoundFile, bool gAPAppendDate, bool gAPAppendPrice, Color gAPColor, Font gAPFont, string gAPLabel, DashStyle gAPLineStyle, int gAPLineWidth, Color highColor, string highLabel, bool highlightIB, bool highlightMCVA, bool highlightVA, DashStyle highLineStyle, int highLineWidth, Color iB15xColor, DashStyle iB15xLineStyle, int iB15xLineWidth, Color iB2xColor, DashStyle iB2xLineStyle, int iB2xLineWidth, Color iBColor, string iBH15xLabel, string iBH2xLabel, string iBHLabel, string iBL15xLabel, string iBL2xLabel, DashStyle iBLineStyle, int iBLineWidth, string iBLLabel, int iBMinutes, Color insideColor, int labelDelay, int labelDisplacement, Font labelFont, bool loadVBCache, Color lowColor, string lowLabel, DashStyle lowLineStyle, int lowLineWidth, bool mCAnchorPositionLabelFollowsValue, bool mCBeginEndByManualRect, string mCRectangleTagPrefix, Color mcVAColor, string mcVAHLabel, DashStyle mcVALineStyle, int mcVALineWidth, string mcVALLabel, double mcVAPercent, Color microCHVNColor, DashStyle microCHVNLineStyle, int microCHVNLineWidth, Color microCLVNColor, DashStyle microCLVNLineStyle, int microCLVNLineWidth, CDA_VolumeProfile_AnchorPosition microCompositeAnchorBar, CDA_VolumeProfile_AnchorEdge microCompositeAnchorEdge, string microCompositeAnchorEdgeToolLabel, int microCompositeAnchorOffset, string microCompositeAnchorOffsetToolLabel, CDA_VolumeProfile_MCAnchorPosition microCompositeAnchorPosition, string microCompositeAnchorPositionToolLabel, DateTime microCompositeBeginDate, string microCompositeDateRangeToolLabel, DateTime microCompositeEndDate, Color microCompositeFillColor, int microCompositeOpacity, string microCompositeOpacityToolLabel, Color microCompositeOutlineColor, double microCompositeScale, string microCompositeScaleToolLabel, string microCompositeSelectToolLabel, string microCompositeSmoothingFactorToolLabel, string microCompositeVNToolLabel, double microCompSmoothingFactor, bool microCompSquareOutline, Color microCVPOCColor, string microCVPOCLabel, DashStyle microCVPOCLineStyle, int microCVPOCLineWidth, int microValueNodeStrength, Color midPtColor, string midPtLabel, DashStyle midPtLineStyle, int midPtLineWidth, DateTime minVAPCacheFileDate, DateTime minVBCacheFileDate, double multiplierStdDev1, double multiplierStdDev2, double multiplierStdDev3, Color nHighColor, string nHighLabel, bool nHLAlertEnabled, string nHLAlertSoundFile, bool nHLAppendDate, bool nHLAppendPrice, Font nHLFont, DashStyle nHLLineStyle, int nHLLineWidth, bool nIBAlertEnabled, string nIBAlertSoundFile, bool nIBAppendDate, bool nIBAppendPrice, Color nIBColor, Font nIBFont, string nIBHLabel, DashStyle nIBLineStyle, int nIBLineWidth, string nIBLLabel, Color nLowColor, string nLowLabel, bool nVAAlertEnabled, string nVAAlertSoundFile, bool nVAAppendDate, bool nVAAppendPrice, Color nVAColor, Font nVAFont, string nVAHLabel, DashStyle nVALineStyle, int nVALineWidth, string nVALLabel, bool nVPOCAlertEnabled, string nVPOCAlertSoundFile, bool nVPOCAppendDate, bool nVPOCAppendPrice, Color nVPOCColor, Font nVPOCFont, string nVPOCLabel, DashStyle nVPOCLineStyle, int nVPOCLineWidth, int opacitySD1, int opacitySD2, int opacitySD3, Color openColor, string openLabel, DashStyle openLineStyle, int openLineWidth, int openSwingMaxMinutes, CDA_VolumeProfile_OperationalMode operationalMode, Color oSColor, string oSHLabel, DashStyle oSLineStyle, int oSLineWidth, string oSLLabel, Color overnightDefaultColor, int overnightDisplayPeriodHL, int overnightDisplayPeriodVPOC, Font overnightFont, Color overnightHighColor, string overnightHighLabel, DashStyle overnightHighLineStyle, int overnightHighLineWidth, Color overnightLowColor, string overnightLowLabel, DashStyle overnightLowLineStyle, int overnightLowLineWidth, string overnightStatsSessionName, Color overnightVPOCColor, string overnightVPOCLabel, DashStyle overnightVPOCLineStyle, int overnightVPOCLineWidth, bool plotCD, CDA_VolumeProfile_RebuildCache rebuildVAPCache, CDA_VolumeProfile_RebuildCache rebuildVBCache, CDA_VolumeProfile_RefreshWhen refreshCompositeCacheFile, CDA_VolumeProfile_CDReset resetCDatBar, double rolloverOffset, string rolloverToContractMonth, bool rolloverVAPCache, string rootFolder, string runLogFileDir, string runLogFilename, bool saveVBData, int sessionAnchorOffset, string sessionAnchorOffsetToolLabel, CDA_VolumeProfile_AnchorPosition sessionAnchorPosition, string sessionAnchorPositionToolLabel, string sessionCDvapHeading, Color sessionFillColor, int sessionOpacity, string sessionOpacityToolLabel, Color sessionOutlineColor, double sessionScale, string sessionScaleToolLabel, bool sessionSquareOutline, Font sessionVolumeFont, bool showBigPrints, bool showBPHLine, bool showBPVLine, bool showCDAtEachPrice, bool showCompositeBeginDate, bool showCompositeProfile, bool showCompositeVolumes, bool showCompValueNodePrice, CDA_VolumeProfile_VNMode showCompValueNodes, bool showGaps, CDA_VolumeProfile_ShowInSessions showIB, bool showIB15x, bool showIB2x, bool showIBRange, CDA_VolumeProfile_ShowInSessions showLabels, bool showMCVA, CDA_VolumeProfile_MCDatesPosition showMicroCompositeDates, bool showMicroCompositeProfile, bool showMicroCompositeVolumes, bool showMicroCompValueNodePrice, bool showMicroCompValueNodes, bool showNHLs, bool showNIBs, bool showNVAs, bool showNVPOCs, CDA_VolumeProfile_ShowInSessions showOHMLC, CDA_VolumeProfile_ShowInSessions showOS, bool showOvernightStats, bool showPriceWithLabel, bool showSessionImbalanceFactor, CDA_VolumeProfile_ShowInSessions showSessionProfile, bool showSessionRange, bool showSessionVolumes, bool showStartupMessages, bool showToolBar, bool showTrendChange, CDA_VolumeProfile_ShowInSessions showVA, bool showVARange, bool showVPOC, bool showVPOCTrack, int slowPeriod, string standardCDHeading, bool staticMCEnabled, int threshold, string toolBarHideDropDownLabel, Color toolBarTextColor, Font toolBarTextFont, Font toolBarTextFontOnFocus, string trendCDvapHeading, Color trendChangeDownColor, Color trendChangeUpColor, bool updateInRealtimeEnabled, Color vAColor, string vAHLabel, DashStyle vALineStyle, int vALineWidth, string vALLabel, int vAOpacity, double vAPercent, Color vPOCColor, string vPOCLabel, DashStyle vPOCLineStyle, int vPOCLineWidth, Color vWAPColor, string vWAPLabel, DashStyle vWAPLineStyle, int vWAPLineWidth, Color vWAPSD1Color, DashStyle vWAPSD1LineStyle, int vWAPSD1LineWidth, Color vWAPSD2Color, DashStyle vWAPSD2LineStyle, int vWAPSD2LineWidth, Color vWAPSD3Color, DashStyle vWAPSD3LineStyle, int vWAPSD3LineWidth)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.CDA_VolumeProfile(input, aboveAskColor, atAskColor, atBidColor, autoSaveMicroCompositeSettings, autoUpdateMCEndDate, belowBidColor, bigPrintsFileDir, bPAlertEnabled, bPAlertSoundFile, bPDisplayCount, bPDisplayMode, bPDisplayPosition, bPFilterMode, bPHLineStyle, bPHLineWidth, bPLabel, bPLabelColor, bPLabelFont, bPLabelOffset, bPMinVolume, bPMulipleAboveMultipleOfAverageVolume, bPVLineStyle, bPVLineWidth, calcMode, cD0Label, cD0LineColor, cD0LineStyle, cD0LineWidth, cDDownColor, cDHeadingsColor, cDHeadingsFont, cDHighLabel, cDHighLineColor, cDHighLineStyle, cDHighLineWidth, cDLineStyle, cDLineWidth, cDLocation, cDLowLabel, cDLowLineColor, cDLowLineStyle, cDLowLineWidth, cDNeutralColor, cDPlotLabel, cDUpColor, cDValueFont, cHVNBandColor, cHVNBandOpacity, cHVNBandOpacityToolLabel, cHVNBandWidth, cHVNLineColor, cHVNLineStyle, cHVNLineWidth, closeColor, closeLabel, closeLineStyle, closeLineWidth, cLVNBandColor, cLVNBandOpacity, cLVNBandOpacityToolLabel, cLVNBandWidth, cLVNLineColor, cLVNLineStyle, cLVNLineWidth, compositeAnchorOffset, compositeAnchorOffsetToolLabel, compositeAnchorPosition, compositeAnchorPositionToolLabel, compositeBeginDate, compositeBeginDateToolLabel, compositeFillColor, compositeOpacity, compositeOpacityToolLabel, compositeOutlineColor, compositeScale, compositeScaleToolLabel, compositeSmoothingFactor, compositeSmoothingFactorToolLabel, compositeSquareOutline, compositeVNToolLabel, compValueNodeStrength, currentSessionAnchorPosition, cVPOCColor, cVPOCLabel, cVPOCLineStyle, cVPOCLineWidth, dataFileDir, displayComputedAtBar, displayComputedAtPrice, displaySD1, displaySD2, displaySD3, displayVABand, drawCD0, drawCDHighLow, emailAddress, emailToAddress, enableCD, enableCHVNOpacityTool, enableCLVNOpacityTool, enableCompositeAnchorOffsetTool, enableCompositeAnchorPositionTool, enableCompositeBeginDateTool, enableCompositeHeatmap, enableCompositeOpacityTool, enableCompositeScaleTool, enableCompositeSmoothingFactorTool, enableCompositeVNTool, enableHideBlockTradesButton, enableHideCDsButton, enableHideCompositeProfileButton, enableHideCompositeProfileValueNodesButton, enableHideMicroCompositeProfilesButton, enableHideMicroCompositeProfileValueAreasButton, enableHideMicroCompositeProfileValueNodesButton, enableHideOvernightStatsButton, enableHideSessionProfilesButton, enableMicroCompositeAnchorEdgeTool, enableMicroCompositeAnchorOffsetTool, enableMicroCompositeAnchorPositionTool, enableMicroCompositeDateRangeTool, enableMicroCompositeHeatmap, enableMicroCompositeOpacityTool, enableMicroCompositeScaleTool, enableMicroCompositeSmoothingFactorTool, enableMicroCompositeVNTool, enablePrecisionRangeProfiling, enableRunLog, enableSessionAnchorOffsetTool, enableSessionAnchorPositionTool, enableSessionHeatmap, enableSessionOpacityTool, enableSessionScaleTool, enableVWAP, exportFileDir, exportStats, fastPeriod, gAPAlertEnabled, gAPAlertSoundFile, gAPAppendDate, gAPAppendPrice, gAPColor, gAPFont, gAPLabel, gAPLineStyle, gAPLineWidth, highColor, highLabel, highlightIB, highlightMCVA, highlightVA, highLineStyle, highLineWidth, iB15xColor, iB15xLineStyle, iB15xLineWidth, iB2xColor, iB2xLineStyle, iB2xLineWidth, iBColor, iBH15xLabel, iBH2xLabel, iBHLabel, iBL15xLabel, iBL2xLabel, iBLineStyle, iBLineWidth, iBLLabel, iBMinutes, insideColor, labelDelay, labelDisplacement, labelFont, loadVBCache, lowColor, lowLabel, lowLineStyle, lowLineWidth, mCAnchorPositionLabelFollowsValue, mCBeginEndByManualRect, mCRectangleTagPrefix, mcVAColor, mcVAHLabel, mcVALineStyle, mcVALineWidth, mcVALLabel, mcVAPercent, microCHVNColor, microCHVNLineStyle, microCHVNLineWidth, microCLVNColor, microCLVNLineStyle, microCLVNLineWidth, microCompositeAnchorBar, microCompositeAnchorEdge, microCompositeAnchorEdgeToolLabel, microCompositeAnchorOffset, microCompositeAnchorOffsetToolLabel, microCompositeAnchorPosition, microCompositeAnchorPositionToolLabel, microCompositeBeginDate, microCompositeDateRangeToolLabel, microCompositeEndDate, microCompositeFillColor, microCompositeOpacity, microCompositeOpacityToolLabel, microCompositeOutlineColor, microCompositeScale, microCompositeScaleToolLabel, microCompositeSelectToolLabel, microCompositeSmoothingFactorToolLabel, microCompositeVNToolLabel, microCompSmoothingFactor, microCompSquareOutline, microCVPOCColor, microCVPOCLabel, microCVPOCLineStyle, microCVPOCLineWidth, microValueNodeStrength, midPtColor, midPtLabel, midPtLineStyle, midPtLineWidth, minVAPCacheFileDate, minVBCacheFileDate, multiplierStdDev1, multiplierStdDev2, multiplierStdDev3, nHighColor, nHighLabel, nHLAlertEnabled, nHLAlertSoundFile, nHLAppendDate, nHLAppendPrice, nHLFont, nHLLineStyle, nHLLineWidth, nIBAlertEnabled, nIBAlertSoundFile, nIBAppendDate, nIBAppendPrice, nIBColor, nIBFont, nIBHLabel, nIBLineStyle, nIBLineWidth, nIBLLabel, nLowColor, nLowLabel, nVAAlertEnabled, nVAAlertSoundFile, nVAAppendDate, nVAAppendPrice, nVAColor, nVAFont, nVAHLabel, nVALineStyle, nVALineWidth, nVALLabel, nVPOCAlertEnabled, nVPOCAlertSoundFile, nVPOCAppendDate, nVPOCAppendPrice, nVPOCColor, nVPOCFont, nVPOCLabel, nVPOCLineStyle, nVPOCLineWidth, opacitySD1, opacitySD2, opacitySD3, openColor, openLabel, openLineStyle, openLineWidth, openSwingMaxMinutes, operationalMode, oSColor, oSHLabel, oSLineStyle, oSLineWidth, oSLLabel, overnightDefaultColor, overnightDisplayPeriodHL, overnightDisplayPeriodVPOC, overnightFont, overnightHighColor, overnightHighLabel, overnightHighLineStyle, overnightHighLineWidth, overnightLowColor, overnightLowLabel, overnightLowLineStyle, overnightLowLineWidth, overnightStatsSessionName, overnightVPOCColor, overnightVPOCLabel, overnightVPOCLineStyle, overnightVPOCLineWidth, plotCD, rebuildVAPCache, rebuildVBCache, refreshCompositeCacheFile, resetCDatBar, rolloverOffset, rolloverToContractMonth, rolloverVAPCache, rootFolder, runLogFileDir, runLogFilename, saveVBData, sessionAnchorOffset, sessionAnchorOffsetToolLabel, sessionAnchorPosition, sessionAnchorPositionToolLabel, sessionCDvapHeading, sessionFillColor, sessionOpacity, sessionOpacityToolLabel, sessionOutlineColor, sessionScale, sessionScaleToolLabel, sessionSquareOutline, sessionVolumeFont, showBigPrints, showBPHLine, showBPVLine, showCDAtEachPrice, showCompositeBeginDate, showCompositeProfile, showCompositeVolumes, showCompValueNodePrice, showCompValueNodes, showGaps, showIB, showIB15x, showIB2x, showIBRange, showLabels, showMCVA, showMicroCompositeDates, showMicroCompositeProfile, showMicroCompositeVolumes, showMicroCompValueNodePrice, showMicroCompValueNodes, showNHLs, showNIBs, showNVAs, showNVPOCs, showOHMLC, showOS, showOvernightStats, showPriceWithLabel, showSessionImbalanceFactor, showSessionProfile, showSessionRange, showSessionVolumes, showStartupMessages, showToolBar, showTrendChange, showVA, showVARange, showVPOC, showVPOCTrack, slowPeriod, standardCDHeading, staticMCEnabled, threshold, toolBarHideDropDownLabel, toolBarTextColor, toolBarTextFont, toolBarTextFontOnFocus, trendCDvapHeading, trendChangeDownColor, trendChangeUpColor, updateInRealtimeEnabled, vAColor, vAHLabel, vALineStyle, vALineWidth, vALLabel, vAOpacity, vAPercent, vPOCColor, vPOCLabel, vPOCLineStyle, vPOCLineWidth, vWAPColor, vWAPLabel, vWAPLineStyle, vWAPLineWidth, vWAPSD1Color, vWAPSD1LineStyle, vWAPSD1LineWidth, vWAPSD2Color, vWAPSD2LineStyle, vWAPSD2LineWidth, vWAPSD3Color, vWAPSD3LineStyle, vWAPSD3LineWidth);
        }
    }
}
#endregion
