    using NinjaTrader.Data;
    using NinjaTrader.Gui.Chart;
    using System;
    using System.ComponentModel;
    using System.Drawing;
    using System.Drawing.Drawing2D;
    using System.Xml.Serialization;
namespace NinjaTrader.Indicator
{
    [Description("Enter the description of your new custom indicator here")]
    public class bftatBFTiDiverScout : NinjaTrader.Indicator.Indicator
    {
        private double currentHigh;
        private double currentHighRSI;
        private double currentLow;
        private double currentLowRSI;
        private int distance = 2;
        private bool highDivFlag;
        private bool highFlag;
        private double[] highQueue;
        private bool lowDivFlag;
        private bool lowFlag;
        private double[] lowQueue;
        private int period = 14;
        private double previousHigh;
        private double previousHighRSI;
        private double previousLow;
        private double previousLowRSI;
        private int scanWidth = 30;
        private DataSeries SignalDirSeries;
        private int smooth = 3;

        public void findHigh()
        {
            for (int i = 1; i < this.scanWidth; i++)
            {
                if ((base.High[1] < this.highQueue[i]) || (base.High[1] <= base.High[0]))
                {
                    this.highFlag = false;
                    return;
                }
                this.highFlag = true;
            }
        }

        public void findLow()
        {
            for (int i = 1; i < this.scanWidth; i++)
            {
                if ((base.Low[1] > this.lowQueue[i]) || (base.Low[1] >= base.Low[0]))
                {
                    this.lowFlag = false;
                    return;
                }
                this.lowFlag = true;
            }
        }

        public void getQueue()
        {
            int index = 1;
            for (int i = 2; i <= this.scanWidth; i++)
            {
                this.highQueue[index] = base.High[i];
                this.lowQueue[index] = base.Low[i];
                index++;
            }
        }

        protected override void Initialize()
        {            
            base.CalculateOnBarClose = true;
            base.Overlay = true;
            base.PriceTypeSupported = false;
            base.Add(new Plot(Color.Red, PlotStyle.Dot, "HighDot"));
            base.Add(new Plot(Color.Green, PlotStyle.Dot, "LowDot"));
            base.Plots[0].Pen.Width = 2f;
            base.Plots[0].Pen.DashStyle = DashStyle.Dot;
            base.Plots[1].Pen.Width = 2f;
            base.Plots[1].Pen.DashStyle = DashStyle.Dot;
            this.highQueue = new double[this.scanWidth];
            this.lowQueue = new double[this.scanWidth];
            base.Name = "bftatBFTiDiverScout";
            this.SignalDirSeries = new DataSeries(this, MaximumBarsLookBack.Infinite);
        }

        public void markHighLow()
        {
            int num = 0;
            if (this.highFlag)
            {
                this.currentHigh = base.High[1];
                this.currentHighRSI = base.RSI(this.period, this.smooth)[1];
                if ((this.currentHigh > this.previousHigh) && (this.currentHighRSI < this.previousHighRSI))
                {
                    this.highDivFlag = true;
                    base.DrawArrowDown(base.Time[10].ToString(), true, 1, base.High[1] + (base.TickSize * this.distance), Color.Blue);
                    num = -1;
                }
                else
                {
                    this.highDivFlag = false;
                }
                this.previousHigh = this.currentHigh;
                this.previousHighRSI = this.currentHighRSI;
                this.HighPlot.Set(1, base.High[1] + (base.TickSize * this.distance));
                this.highFlag = false;
            }
            if (this.lowFlag)
            {
                this.currentLow = base.Low[1];
                this.currentLowRSI = base.RSI(this.period, this.smooth)[1];
                if ((this.currentLow < this.previousLow) && (this.currentLowRSI > this.previousLowRSI))
                {
                    this.lowDivFlag = true;
                    base.DrawArrowUp(base.Time[11].ToString(), true, 1, base.Low[1] - (base.TickSize * this.distance), Color.Yellow);
                    num = 1;
                }
                else
                {
                    this.lowDivFlag = false;
                }
                this.previousLow = this.currentLow;
                this.previousLowRSI = this.currentLowRSI;
                this.LowPlot.Set(1, base.Low[1] - (base.TickSize * this.distance));
                this.lowFlag = false;
            }
            this.SignalDirSeries.Set((double) num);
        }

        protected override void OnBarUpdate()
        {
            if (base.CurrentBar > this.scanWidth)
            {
                this.getQueue();
                this.findHigh();
                this.findLow();
                this.markHighLow();
            }
        }

        private DataSeries HighPlot
        {
            get
            {
                return base.Values[0];
            }
        }

        private DataSeries LowPlot
        {
            get
            {
                return base.Values[1];
            }
        }

        [Description("")]
        [Category("Parameters")]
        public int Period
        {
            get
            {
                return this.period;
            }
            set
            {
                this.period = Math.Max(1, value);
            }
        }

        [Description("")]
        [Category("Parameters")]
        public int ScanWidth
        {
            get
            {
                return this.scanWidth;
            }
            set
            {
                this.scanWidth = Math.Max(2, value);
            }
        }

        [Browsable(false), XmlIgnore]
        public DataSeries SignalDir
        {
            get
            {
                return this.SignalDirSeries;
            }
        }

        [Description("")]
        [Category("Parameters")]
        public int Smooth
        {
            get
            {
                return this.smooth;
            }
            set
            {
                this.smooth = Math.Max(1, value);
            }
        }
    }
}


#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private bftatBFTiDiverScout[] cachebftatBFTiDiverScout = null;

        private static bftatBFTiDiverScout checkbftatBFTiDiverScout = new bftatBFTiDiverScout();

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public bftatBFTiDiverScout bftatBFTiDiverScout(int period, int scanWidth, int smooth)
        {
            return bftatBFTiDiverScout(Input, period, scanWidth, smooth);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public bftatBFTiDiverScout bftatBFTiDiverScout(Data.IDataSeries input, int period, int scanWidth, int smooth)
        {
            if (cachebftatBFTiDiverScout != null)
                for (int idx = 0; idx < cachebftatBFTiDiverScout.Length; idx++)
                    if (cachebftatBFTiDiverScout[idx].Period == period && cachebftatBFTiDiverScout[idx].ScanWidth == scanWidth && cachebftatBFTiDiverScout[idx].Smooth == smooth && cachebftatBFTiDiverScout[idx].EqualsInput(input))
                        return cachebftatBFTiDiverScout[idx];

            lock (checkbftatBFTiDiverScout)
            {
                checkbftatBFTiDiverScout.Period = period;
                period = checkbftatBFTiDiverScout.Period;
                checkbftatBFTiDiverScout.ScanWidth = scanWidth;
                scanWidth = checkbftatBFTiDiverScout.ScanWidth;
                checkbftatBFTiDiverScout.Smooth = smooth;
                smooth = checkbftatBFTiDiverScout.Smooth;

                if (cachebftatBFTiDiverScout != null)
                    for (int idx = 0; idx < cachebftatBFTiDiverScout.Length; idx++)
                        if (cachebftatBFTiDiverScout[idx].Period == period && cachebftatBFTiDiverScout[idx].ScanWidth == scanWidth && cachebftatBFTiDiverScout[idx].Smooth == smooth && cachebftatBFTiDiverScout[idx].EqualsInput(input))
                            return cachebftatBFTiDiverScout[idx];

                bftatBFTiDiverScout indicator = new bftatBFTiDiverScout();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Period = period;
                indicator.ScanWidth = scanWidth;
                indicator.Smooth = smooth;
                Indicators.Add(indicator);
                indicator.SetUp();

                bftatBFTiDiverScout[] tmp = new bftatBFTiDiverScout[cachebftatBFTiDiverScout == null ? 1 : cachebftatBFTiDiverScout.Length + 1];
                if (cachebftatBFTiDiverScout != null)
                    cachebftatBFTiDiverScout.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachebftatBFTiDiverScout = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.bftatBFTiDiverScout bftatBFTiDiverScout(int period, int scanWidth, int smooth)
        {
            return _indicator.bftatBFTiDiverScout(Input, period, scanWidth, smooth);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.bftatBFTiDiverScout bftatBFTiDiverScout(Data.IDataSeries input, int period, int scanWidth, int smooth)
        {
            return _indicator.bftatBFTiDiverScout(input, period, scanWidth, smooth);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.bftatBFTiDiverScout bftatBFTiDiverScout(int period, int scanWidth, int smooth)
        {
            return _indicator.bftatBFTiDiverScout(Input, period, scanWidth, smooth);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.bftatBFTiDiverScout bftatBFTiDiverScout(Data.IDataSeries input, int period, int scanWidth, int smooth)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.bftatBFTiDiverScout(input, period, scanWidth, smooth);
        }
    }
}
#endregion
