    using NinjaTrader.Data;
    using NinjaTrader.Gui.Chart;
    using System;
    using System.ComponentModel;
    using System.Drawing;
    using System.Drawing.Drawing2D;
    using System.Xml.Serialization;
namespace NinjaTrader.Indicator
{
    [Description("Empty placeholder indicator for creating plots in NinjaScript Strategies")]
    public class bftatBFTiECMonitor : NinjaTrader.Indicator.Indicator
    {
        private int id = 1;

        protected override void Initialize()
        {
            base.Add(new Plot(new Pen(Color.Green, 3f), PlotStyle.Bar, "DailyEquityCurve"));
            base.Add(new Plot(new Pen(Color.Green, 1f), PlotStyle.Line, "DailyEquityHigh"));
            base.Add(new Plot(new Pen(Color.Red, 1f), PlotStyle.Line, "DailyEquityLow"));
            base.Add(new Plot(new Pen(Color.Orange, 1f), PlotStyle.Hash, "DailyEquityStopTrigger"));
            base.Plots[3].Pen.DashStyle = DashStyle.Solid;
            base.Add(new Plot(new Pen(Color.Magenta, 2f), PlotStyle.Hash, "DailyEquityStopFloor"));
            base.Plots[4].Pen.DashStyle = DashStyle.Solid;
            base.Add(new Line(Color.DarkGray, 0.0, "ZeroLine"));
            base.Overlay = false;
            base.PriceTypeSupported = false;
        }

        protected override void OnBarUpdate()
        {
        }

        public override string ToString()
        {
            return base.Name;
        }

        [Description("")]
        [Category("Parameters")]
        public int Id
        {
            get
            {
                return this.id;
            }
            set
            {
                this.id = Math.Max(0, value);
            }
        }

        [XmlIgnore, Browsable(false)]
        public DataSeries Plot0
        {
            get
            {
                return base.Values[0];
            }
        }

        [XmlIgnore, Browsable(false)]
        public DataSeries Plot1
        {
            get
            {
                return base.Values[1];
            }
        }

        [XmlIgnore, Browsable(false)]
        public DataSeries Plot2
        {
            get
            {
                return base.Values[2];
            }
        }

        [XmlIgnore, Browsable(false)]
        public DataSeries Plot3
        {
            get
            {
                return base.Values[3];
            }
        }

        [XmlIgnore, Browsable(false)]
        public DataSeries Plot4
        {
            get
            {
                return base.Values[4];
            }
        }
    }
}


#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private bftatBFTiECMonitor[] cachebftatBFTiECMonitor = null;

        private static bftatBFTiECMonitor checkbftatBFTiECMonitor = new bftatBFTiECMonitor();

        /// <summary>
        /// Empty placeholder indicator for creating plots in NinjaScript Strategies
        /// </summary>
        /// <returns></returns>
        public bftatBFTiECMonitor bftatBFTiECMonitor(int id)
        {
            return bftatBFTiECMonitor(Input, id);
        }

        /// <summary>
        /// Empty placeholder indicator for creating plots in NinjaScript Strategies
        /// </summary>
        /// <returns></returns>
        public bftatBFTiECMonitor bftatBFTiECMonitor(Data.IDataSeries input, int id)
        {
            if (cachebftatBFTiECMonitor != null)
                for (int idx = 0; idx < cachebftatBFTiECMonitor.Length; idx++)
                    if (cachebftatBFTiECMonitor[idx].Id == id && cachebftatBFTiECMonitor[idx].EqualsInput(input))
                        return cachebftatBFTiECMonitor[idx];

            lock (checkbftatBFTiECMonitor)
            {
                checkbftatBFTiECMonitor.Id = id;
                id = checkbftatBFTiECMonitor.Id;

                if (cachebftatBFTiECMonitor != null)
                    for (int idx = 0; idx < cachebftatBFTiECMonitor.Length; idx++)
                        if (cachebftatBFTiECMonitor[idx].Id == id && cachebftatBFTiECMonitor[idx].EqualsInput(input))
                            return cachebftatBFTiECMonitor[idx];

                bftatBFTiECMonitor indicator = new bftatBFTiECMonitor();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Id = id;
                Indicators.Add(indicator);
                indicator.SetUp();

                bftatBFTiECMonitor[] tmp = new bftatBFTiECMonitor[cachebftatBFTiECMonitor == null ? 1 : cachebftatBFTiECMonitor.Length + 1];
                if (cachebftatBFTiECMonitor != null)
                    cachebftatBFTiECMonitor.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachebftatBFTiECMonitor = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Empty placeholder indicator for creating plots in NinjaScript Strategies
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.bftatBFTiECMonitor bftatBFTiECMonitor(int id)
        {
            return _indicator.bftatBFTiECMonitor(Input, id);
        }

        /// <summary>
        /// Empty placeholder indicator for creating plots in NinjaScript Strategies
        /// </summary>
        /// <returns></returns>
        public Indicator.bftatBFTiECMonitor bftatBFTiECMonitor(Data.IDataSeries input, int id)
        {
            return _indicator.bftatBFTiECMonitor(input, id);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Empty placeholder indicator for creating plots in NinjaScript Strategies
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.bftatBFTiECMonitor bftatBFTiECMonitor(int id)
        {
            return _indicator.bftatBFTiECMonitor(Input, id);
        }

        /// <summary>
        /// Empty placeholder indicator for creating plots in NinjaScript Strategies
        /// </summary>
        /// <returns></returns>
        public Indicator.bftatBFTiECMonitor bftatBFTiECMonitor(Data.IDataSeries input, int id)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.bftatBFTiECMonitor(input, id);
        }
    }
}
#endregion
