    using NinjaTrader.Data;
    using NinjaTrader.Gui.Chart;
    using System;
    using System.ComponentModel;
    using System.Drawing;
    using System.Xml.Serialization;
namespace NinjaTrader.Indicator
{
    [Description("Creates Entry plots in NinjaScript Strategies")]
    public class bftatBFTiEntryPlot : NinjaTrader.Indicator.Indicator
    {
        private int id = 1;

        protected override void Initialize()
        {
            base.Add(new NinjaTrader.Gui.Chart.Plot(new Pen(Color.Aqua, 2f), PlotStyle.Dot, "EntryPlot"));
            base.CalculateOnBarClose = true;
            base.Overlay = true;
            base.PriceTypeSupported = false;
        }

        protected override void OnBarUpdate()
        {
        }

        public override string ToString()
        {
            return string.Empty;
        }

        [Description("")]
        [Category("Parameters")]
        public int Id
        {
            get
            {
                return this.id;
            }
            set
            {
                this.id = Math.Max(0, value);
            }
        }

        [XmlIgnore, Browsable(false)]
        public DataSeries Plot
        {
            get
            {
                return base.Values[0];
            }
        }
    }
}


#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private bftatBFTiEntryPlot[] cachebftatBFTiEntryPlot = null;

        private static bftatBFTiEntryPlot checkbftatBFTiEntryPlot = new bftatBFTiEntryPlot();

        /// <summary>
        /// Creates Entry plots in NinjaScript Strategies
        /// </summary>
        /// <returns></returns>
        public bftatBFTiEntryPlot bftatBFTiEntryPlot(int id)
        {
            return bftatBFTiEntryPlot(Input, id);
        }

        /// <summary>
        /// Creates Entry plots in NinjaScript Strategies
        /// </summary>
        /// <returns></returns>
        public bftatBFTiEntryPlot bftatBFTiEntryPlot(Data.IDataSeries input, int id)
        {
            if (cachebftatBFTiEntryPlot != null)
                for (int idx = 0; idx < cachebftatBFTiEntryPlot.Length; idx++)
                    if (cachebftatBFTiEntryPlot[idx].Id == id && cachebftatBFTiEntryPlot[idx].EqualsInput(input))
                        return cachebftatBFTiEntryPlot[idx];

            lock (checkbftatBFTiEntryPlot)
            {
                checkbftatBFTiEntryPlot.Id = id;
                id = checkbftatBFTiEntryPlot.Id;

                if (cachebftatBFTiEntryPlot != null)
                    for (int idx = 0; idx < cachebftatBFTiEntryPlot.Length; idx++)
                        if (cachebftatBFTiEntryPlot[idx].Id == id && cachebftatBFTiEntryPlot[idx].EqualsInput(input))
                            return cachebftatBFTiEntryPlot[idx];

                bftatBFTiEntryPlot indicator = new bftatBFTiEntryPlot();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Id = id;
                Indicators.Add(indicator);
                indicator.SetUp();

                bftatBFTiEntryPlot[] tmp = new bftatBFTiEntryPlot[cachebftatBFTiEntryPlot == null ? 1 : cachebftatBFTiEntryPlot.Length + 1];
                if (cachebftatBFTiEntryPlot != null)
                    cachebftatBFTiEntryPlot.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachebftatBFTiEntryPlot = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Creates Entry plots in NinjaScript Strategies
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.bftatBFTiEntryPlot bftatBFTiEntryPlot(int id)
        {
            return _indicator.bftatBFTiEntryPlot(Input, id);
        }

        /// <summary>
        /// Creates Entry plots in NinjaScript Strategies
        /// </summary>
        /// <returns></returns>
        public Indicator.bftatBFTiEntryPlot bftatBFTiEntryPlot(Data.IDataSeries input, int id)
        {
            return _indicator.bftatBFTiEntryPlot(input, id);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Creates Entry plots in NinjaScript Strategies
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.bftatBFTiEntryPlot bftatBFTiEntryPlot(int id)
        {
            return _indicator.bftatBFTiEntryPlot(Input, id);
        }

        /// <summary>
        /// Creates Entry plots in NinjaScript Strategies
        /// </summary>
        /// <returns></returns>
        public Indicator.bftatBFTiEntryPlot bftatBFTiEntryPlot(Data.IDataSeries input, int id)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.bftatBFTiEntryPlot(input, id);
        }
    }
}
#endregion
