    using NinjaTrader.Gui.Design;
    using System;
    using System.ComponentModel;
    using System.Drawing;
    using System.Windows.Forms;
namespace NinjaTrader.Indicator
{
    [Description("bftatSCBV1a | www.bigfootautomatedtrading.com/")]
    public class bftatBFTiSCBV1a : NinjaTrader.Indicator.Indicator
    {
        private bool _initButtonEvents;
        public Button btnBFTBuyMkt;
        public Button btnBFTClosePos;
        public Button btnBFTCTOn;
        public Button btnBFTLongOn;
        public Button btnBFTSellMkt;
        public Button btnBFTShortOn;
        public Button btnBFTStrategyOn;
        private int btnHeightPixels = 0x17;
        private int btnHeightPixelsShort = 0x1a;
        private int btnHeightPixelsTall = 0x23;
        private int btnLoc01_Width;
        private int btnLoc01_X;
        private int btnLoc01_Y;
        private int btnLoc02_Width;
        private int btnLoc02_X;
        private int btnLoc02_Y;
        private int btnLoc03_Width;
        private int btnLoc03_X;
        private int btnLoc03_Y;
        private int btnLoc04_Width;
        private int btnLoc04_X;
        private int btnLoc04_Y;
        private int btnLoc05_Width;
        private int btnLoc05_X;
        private int btnLoc05_Y;
        private int btnLoc06_Width;
        private int btnLoc06_X;
        private int btnLoc06_Y;
        private int btnLoc07_Width;
        private int btnLoc07_X;
        private int btnLoc07_Y;
        private int btnLoc08_Width;
        private int btnLoc08_X;
        private int btnLoc08_Y;
        private int btnLoc09_Width;
        private int btnLoc09_X;
        private int btnLoc09_Y;
        private int btnLoc10_Width;
        private int btnLoc10_X;
        private int btnLoc10_Y;
        private int btnLoc11_Width;
        private int btnLoc11_X;
        private int btnLoc11_Y;
        private int btnLocY1 = 0x2d;
        private int btnLocY2 = 0x4b;
        private int btnLocY3 = 0x69;
        private int btnLocY4 = 0x87;
        private int btnLocY5 = 0xa5;
        private int btnLocY6 = 0xc3;
        private int btnLocY7 = 0xe1;
        private int btnLocY8 = 0xff;
        private int btnLocY9 = 0x11d;
        private int btnWidthPixels = 80;
        private int ppButtonsXPixels = 15;
        private int ppButtonsYPixels = 60;
        private bool strategyBuyMktEvent;
        private bool strategyClosePosState;
        private bool strategyCTOn;
        private bool strategyLongOnState;
        private bool strategySellMktEvent;
        private bool strategyShortOnState;
        private bool strategyStrategyOnState;

        private void btnBFTBuyMkt_Click(object sender, EventArgs e)
        {
        }

        private void btnBFTClosePos_Click(object sender, EventArgs e)
        {
        }

        private void btnBFTCTOn_Click(object sender, EventArgs e)
        {
        }

        private void btnBFTLongOn_Click(object sender, EventArgs e)
        {
        }

        private void btnBFTSellMkt_Click(object sender, EventArgs e)
        {
        }

        private void btnBFTShortOn_Click(object sender, EventArgs e)
        {
        }

        private void btnBFTStrategyOn_Click(object sender, EventArgs e)
        {
        }

        protected override void Initialize()
        {            
            base.CalculateOnBarClose = false;
            base.PaintPriceMarkers = false;
            base.DrawOnPricePanel = true;
            base.AutoScale = false;
            base.BarsRequired = 0;
            base.Overlay = true;
        }

        protected override void OnBarUpdate()
        {
            int width = 80;
            this.btnLoc01_Y = this.pButtonsYPixels;
            this.btnLoc01_X = this.pButtonsXPixels;
            this.btnLoc01_Width = 80;
            this.btnLoc02_Y = this.btnLoc01_Y + 0x1a;
            this.btnLoc02_X = this.pButtonsXPixels;
            this.btnLoc02_Width = 80;
            this.btnLoc03_Y = this.btnLoc02_Y + 0x1a;
            this.btnLoc03_X = this.pButtonsXPixels;
            this.btnLoc03_Width = 80;
            this.btnLoc04_Y = this.btnLoc03_Y + 0x1a;
            this.btnLoc04_X = this.pButtonsXPixels;
            this.btnLoc04_Width = 80;
            this.btnLoc05_Y = this.btnLoc04_Y + 0x1a;
            this.btnLoc05_X = this.pButtonsXPixels;
            this.btnLoc05_Width = 80;
            this.btnLoc06_Y = this.btnLoc05_Y + 0x1a;
            this.btnLoc06_X = this.pButtonsXPixels;
            this.btnLoc06_Width = 80;
            this.btnLoc07_Y = this.btnLoc06_Y + 0x1a;
            this.btnLoc07_X = this.pButtonsXPixels;
            this.btnLoc07_Width = 80;
            this.btnLoc08_Y = this.btnLoc07_Y + 0x1a;
            this.btnLoc08_X = this.pButtonsXPixels;
            this.btnLoc08_Width = 80;
            this.btnLoc09_Y = this.btnLoc08_Y + 0x1a;
            this.btnLoc09_X = this.pButtonsXPixels;
            this.btnLoc09_Width = 80;
            this.btnLoc10_Y = this.btnLoc09_Y + 0x1a;
            this.btnLoc10_X = this.pButtonsXPixels;
            this.btnLoc10_Width = 80;
            this.btnLoc11_Y = this.btnLoc10_Y + 0x1a;
            this.btnLoc11_X = this.pButtonsXPixels;
            this.btnLoc11_Width = 80;
            if ((base.ChartControl != null) && !this._initButtonEvents)
            {
                try
                {
                    if (((base.ChartControl != null) && (base.ChartControl.ChartPanel != null)) && (base.ChartControl.ChartPanel.Controls != null))
                    {
                        for (int i = base.ChartControl.ChartPanel.Controls.Count - 1; i >= 0; i--)
                        {
                            Control control = base.ChartControl.ChartPanel.Controls[i];
                            if ((control != null) && ((((control.Name == "btnBFTStrategyOn") || (control.Name == "btnBFTLongOn")) || ((control.Name == "btnBFTShortOn") || (control.Name == "btnBFTCTOn"))) || (((control.Name == "btnBFTBuyMkt") || (control.Name == "btnBFTSellMkt")) || (control.Name == "btnBFTClosePos"))))
                            {
                                base.ChartControl.ChartPanel.Controls.Remove(control);
                                base.Print("bftatBFTiSCBV1a - Removing control : " + control.Name);
                            }
                        }
                    }
                    this.btnBFTStrategyOn = new Button();
                    this.btnBFTLongOn = new Button();
                    this.btnBFTShortOn = new Button();
                    this.btnBFTCTOn = new Button();
                    this.btnBFTBuyMkt = new Button();
                    this.btnBFTSellMkt = new Button();
                    this.btnBFTClosePos = new Button();
                    this.btnBFTStrategyOn.BackColor = Color.LightGray;
                    this.btnBFTStrategyOn.Location = new Point(this.btnLoc01_X, this.btnLoc01_Y);
                    this.btnBFTStrategyOn.Name = "btnBFTStrategyOn";
                    this.btnBFTStrategyOn.Size = new Size(width, this.btnHeightPixels);
                    this.btnBFTStrategyOn.TabIndex = 1;
                    this.btnBFTStrategyOn.Text = "Strategy On";
                    this.btnBFTStrategyOn.UseVisualStyleBackColor = true;
                    this.btnBFTStrategyOn.Click += new EventHandler(this.btnBFTStrategyOn_Click);
                    base.ChartControl.ChartPanel.Controls.Add(this.btnBFTStrategyOn);
                    this.btnBFTLongOn.BackColor = Color.LightGray;
                    this.btnBFTLongOn.Location = new Point(this.btnLoc02_X, this.btnLoc02_Y);
                    this.btnBFTLongOn.Name = "btnBFTLongOn";
                    this.btnBFTLongOn.Size = new Size(width, this.btnHeightPixels);
                    this.btnBFTLongOn.TabIndex = 2;
                    this.btnBFTLongOn.Text = "Long On";
                    this.btnBFTLongOn.UseVisualStyleBackColor = false;
                    this.btnBFTLongOn.Click += new EventHandler(this.btnBFTLongOn_Click);
                    base.ChartControl.ChartPanel.Controls.Add(this.btnBFTLongOn);
                    this.btnBFTShortOn.BackColor = Color.LightGray;
                    this.btnBFTShortOn.Location = new Point(this.btnLoc03_X, this.btnLoc03_Y);
                    this.btnBFTShortOn.Name = "btnBFTShortOn";
                    this.btnBFTShortOn.Size = new Size(width, this.btnHeightPixels);
                    this.btnBFTShortOn.TabIndex = 3;
                    this.btnBFTShortOn.Text = "Short On";
                    this.btnBFTShortOn.UseVisualStyleBackColor = false;
                    this.btnBFTShortOn.Click += new EventHandler(this.btnBFTShortOn_Click);
                    base.ChartControl.ChartPanel.Controls.Add(this.btnBFTShortOn);
                    this.btnBFTCTOn.BackColor = Color.LightGray;
                    this.btnBFTCTOn.Location = new Point(this.btnLoc04_X, this.btnLoc04_Y);
                    this.btnBFTCTOn.Name = "btnBFTCTOn";
                    this.btnBFTCTOn.Size = new Size(width, this.btnHeightPixels);
                    this.btnBFTCTOn.TabIndex = 4;
                    this.btnBFTCTOn.Text = "CT On";
                    this.btnBFTCTOn.UseVisualStyleBackColor = false;
                    this.btnBFTCTOn.Click += new EventHandler(this.btnBFTCTOn_Click);
                    base.ChartControl.ChartPanel.Controls.Add(this.btnBFTCTOn);
                    this.btnBFTBuyMkt.ForeColor = Color.White;
                    this.btnBFTBuyMkt.BackColor = Color.Gray;
                    this.btnBFTBuyMkt.Location = new Point(this.btnLoc05_X, this.btnLoc05_Y);
                    this.btnBFTBuyMkt.Name = "btnBFTBuyMkt";
                    this.btnBFTBuyMkt.Size = new Size(width, this.btnHeightPixels);
                    this.btnBFTBuyMkt.TabIndex = 5;
                    this.btnBFTBuyMkt.Text = "BUY";
                    this.btnBFTBuyMkt.UseVisualStyleBackColor = true;
                    this.btnBFTBuyMkt.Click += new EventHandler(this.btnBFTBuyMkt_Click);
                    base.ChartControl.ChartPanel.Controls.Add(this.btnBFTBuyMkt);
                    this.btnBFTSellMkt.ForeColor = Color.White;
                    this.btnBFTSellMkt.BackColor = Color.Gray;
                    this.btnBFTSellMkt.Location = new Point(this.btnLoc06_X, this.btnLoc06_Y);
                    this.btnBFTSellMkt.Name = "btnBFTSellMkt";
                    this.btnBFTSellMkt.Size = new Size(width, this.btnHeightPixels);
                    this.btnBFTSellMkt.TabIndex = 6;
                    this.btnBFTSellMkt.Text = "SELL";
                    this.btnBFTSellMkt.UseVisualStyleBackColor = true;
                    this.btnBFTSellMkt.Click += new EventHandler(this.btnBFTSellMkt_Click);
                    base.ChartControl.ChartPanel.Controls.Add(this.btnBFTSellMkt);
                    this.btnBFTClosePos.ForeColor = Color.White;
                    this.btnBFTClosePos.BackColor = Color.Gray;
                    this.btnBFTClosePos.Location = new Point(this.btnLoc07_X, this.btnLoc07_Y);
                    this.btnBFTClosePos.Name = "btnBFTClosePos";
                    this.btnBFTClosePos.Size = new Size(width, this.btnHeightPixels);
                    this.btnBFTClosePos.TabIndex = 7;
                    this.btnBFTClosePos.Text = "CLOSE";
                    this.btnBFTClosePos.UseVisualStyleBackColor = true;
                    this.btnBFTClosePos.Click += new EventHandler(this.btnBFTClosePos_Click);
                    base.ChartControl.ChartPanel.Controls.Add(this.btnBFTClosePos);
                    this._initButtonEvents = true;
                }
                catch (Exception exception)
                {
                    base.Print("bftatBFTiSCBV1a - Error 1: " + exception.Message);
                    this._initButtonEvents = true;
                }
            }
            try
            {
                if (base.Historical)
                {
                }
            }
            catch (Exception exception2)
            {
                base.Print("bftatBFTiSCBV1a - Error 2: " + exception2.Message);
            }
        }

        protected override void OnTermination()
        {
            try
            {
                if (((base.ChartControl != null) && (base.ChartControl.ChartPanel != null)) && (base.ChartControl.ChartPanel.Controls != null))
                {
                    for (int i = base.ChartControl.ChartPanel.Controls.Count - 1; i >= 0; i--)
                    {
                        Control control = base.ChartControl.ChartPanel.Controls[i];
                        if ((control != null) && ((((control.Name == "btnBFTStrategyOn") || (control.Name == "btnBFTLongOn")) || ((control.Name == "btnBFTShortOn") || (control.Name == "btnBFTCTOn"))) || (((control.Name == "btnBFTBuyMkt") || (control.Name == "btnBFTSellMkt")) || (control.Name == "btnBFTClosePos"))))
                        {
                            base.ChartControl.ChartPanel.Controls.Remove(control);
                            base.Print("bftatBFTiSCBV1a - Removing control : " + control.Name);
                        }
                    }
                }
            }
            catch (Exception exception)
            {
                base.Print("bftatBFTiSCBV1a - Error 3: " + exception.Message);
            }
        }

        public override string ToString()
        {
            return string.Empty;
        }

        [NinjaTrader.Gui.Design.DisplayName("pButtonsXPixels"), Description("ButtonsXPixels - positions the upper left corner of the button array from the upper left corner of the chart")]
        [Category("Parameters")]
        public int pButtonsXPixels
        {
            get
            {
                return this.ppButtonsXPixels;
            }
            set
            {
                this.ppButtonsXPixels = Math.Max(1, value);
            }
        }

        [Description("ButtonsYPixels - positions the upper left corner of the button array from the upper left corner of the chart"), NinjaTrader.Gui.Design.DisplayName("pButtonsYPixels")]
        [Category("Parameters")]
        public int pButtonsYPixels
        {
            get
            {
                return this.ppButtonsYPixels;
            }
            set
            {
                this.ppButtonsYPixels = Math.Max(1, value);
            }
        }
    }
}


#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private bftatBFTiSCBV1a[] cachebftatBFTiSCBV1a = null;

        private static bftatBFTiSCBV1a checkbftatBFTiSCBV1a = new bftatBFTiSCBV1a();

        /// <summary>
        /// bftatSCBV1a | www.bigfootautomatedtrading.com/
        /// </summary>
        /// <returns></returns>
        public bftatBFTiSCBV1a bftatBFTiSCBV1a(int pButtonsXPixels, int pButtonsYPixels)
        {
            return bftatBFTiSCBV1a(Input, pButtonsXPixels, pButtonsYPixels);
        }

        /// <summary>
        /// bftatSCBV1a | www.bigfootautomatedtrading.com/
        /// </summary>
        /// <returns></returns>
        public bftatBFTiSCBV1a bftatBFTiSCBV1a(Data.IDataSeries input, int pButtonsXPixels, int pButtonsYPixels)
        {
            if (cachebftatBFTiSCBV1a != null)
                for (int idx = 0; idx < cachebftatBFTiSCBV1a.Length; idx++)
                    if (cachebftatBFTiSCBV1a[idx].pButtonsXPixels == pButtonsXPixels && cachebftatBFTiSCBV1a[idx].pButtonsYPixels == pButtonsYPixels && cachebftatBFTiSCBV1a[idx].EqualsInput(input))
                        return cachebftatBFTiSCBV1a[idx];

            lock (checkbftatBFTiSCBV1a)
            {
                checkbftatBFTiSCBV1a.pButtonsXPixels = pButtonsXPixels;
                pButtonsXPixels = checkbftatBFTiSCBV1a.pButtonsXPixels;
                checkbftatBFTiSCBV1a.pButtonsYPixels = pButtonsYPixels;
                pButtonsYPixels = checkbftatBFTiSCBV1a.pButtonsYPixels;

                if (cachebftatBFTiSCBV1a != null)
                    for (int idx = 0; idx < cachebftatBFTiSCBV1a.Length; idx++)
                        if (cachebftatBFTiSCBV1a[idx].pButtonsXPixels == pButtonsXPixels && cachebftatBFTiSCBV1a[idx].pButtonsYPixels == pButtonsYPixels && cachebftatBFTiSCBV1a[idx].EqualsInput(input))
                            return cachebftatBFTiSCBV1a[idx];

                bftatBFTiSCBV1a indicator = new bftatBFTiSCBV1a();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.pButtonsXPixels = pButtonsXPixels;
                indicator.pButtonsYPixels = pButtonsYPixels;
                Indicators.Add(indicator);
                indicator.SetUp();

                bftatBFTiSCBV1a[] tmp = new bftatBFTiSCBV1a[cachebftatBFTiSCBV1a == null ? 1 : cachebftatBFTiSCBV1a.Length + 1];
                if (cachebftatBFTiSCBV1a != null)
                    cachebftatBFTiSCBV1a.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachebftatBFTiSCBV1a = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// bftatSCBV1a | www.bigfootautomatedtrading.com/
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.bftatBFTiSCBV1a bftatBFTiSCBV1a(int pButtonsXPixels, int pButtonsYPixels)
        {
            return _indicator.bftatBFTiSCBV1a(Input, pButtonsXPixels, pButtonsYPixels);
        }

        /// <summary>
        /// bftatSCBV1a | www.bigfootautomatedtrading.com/
        /// </summary>
        /// <returns></returns>
        public Indicator.bftatBFTiSCBV1a bftatBFTiSCBV1a(Data.IDataSeries input, int pButtonsXPixels, int pButtonsYPixels)
        {
            return _indicator.bftatBFTiSCBV1a(input, pButtonsXPixels, pButtonsYPixels);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// bftatSCBV1a | www.bigfootautomatedtrading.com/
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.bftatBFTiSCBV1a bftatBFTiSCBV1a(int pButtonsXPixels, int pButtonsYPixels)
        {
            return _indicator.bftatBFTiSCBV1a(Input, pButtonsXPixels, pButtonsYPixels);
        }

        /// <summary>
        /// bftatSCBV1a | www.bigfootautomatedtrading.com/
        /// </summary>
        /// <returns></returns>
        public Indicator.bftatBFTiSCBV1a bftatBFTiSCBV1a(Data.IDataSeries input, int pButtonsXPixels, int pButtonsYPixels)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.bftatBFTiSCBV1a(input, pButtonsXPixels, pButtonsYPixels);
        }
    }
}
#endregion
