    using NinjaTrader.Data;
    using NinjaTrader.Gui.Chart;
    using System;
    using System.ComponentModel;
    using System.Drawing;
    using System.Xml.Serialization;
namespace NinjaTrader.Indicator
{
    [Description("Creates Stop plots in NinjaScript Strategies")]
    public class bftatBFTiStopPlot : NinjaTrader.Indicator.Indicator
    {
        private int id = 1;

        protected override void Initialize()
        {
            base.Add(new NinjaTrader.Gui.Chart.Plot(new Pen(Color.Red, 3f), PlotStyle.Hash, "StopPlot"));
            base.Overlay = true;
            base.PriceTypeSupported = false;
        }

        protected override void OnBarUpdate()
        {
        }

        public override string ToString()
        {
            return string.Empty;
        }

        [Description("")]
        [Category("Parameters")]
        public int Id
        {
            get
            {
                return this.id;
            }
            set
            {
                this.id = Math.Max(0, value);
            }
        }

        [XmlIgnore, Browsable(false)]
        public DataSeries Plot
        {
            get
            {
                return base.Values[0];
            }
        }
    }
}


#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private bftatBFTiStopPlot[] cachebftatBFTiStopPlot = null;

        private static bftatBFTiStopPlot checkbftatBFTiStopPlot = new bftatBFTiStopPlot();

        /// <summary>
        /// Creates Stop plots in NinjaScript Strategies
        /// </summary>
        /// <returns></returns>
        public bftatBFTiStopPlot bftatBFTiStopPlot(int id)
        {
            return bftatBFTiStopPlot(Input, id);
        }

        /// <summary>
        /// Creates Stop plots in NinjaScript Strategies
        /// </summary>
        /// <returns></returns>
        public bftatBFTiStopPlot bftatBFTiStopPlot(Data.IDataSeries input, int id)
        {
            if (cachebftatBFTiStopPlot != null)
                for (int idx = 0; idx < cachebftatBFTiStopPlot.Length; idx++)
                    if (cachebftatBFTiStopPlot[idx].Id == id && cachebftatBFTiStopPlot[idx].EqualsInput(input))
                        return cachebftatBFTiStopPlot[idx];

            lock (checkbftatBFTiStopPlot)
            {
                checkbftatBFTiStopPlot.Id = id;
                id = checkbftatBFTiStopPlot.Id;

                if (cachebftatBFTiStopPlot != null)
                    for (int idx = 0; idx < cachebftatBFTiStopPlot.Length; idx++)
                        if (cachebftatBFTiStopPlot[idx].Id == id && cachebftatBFTiStopPlot[idx].EqualsInput(input))
                            return cachebftatBFTiStopPlot[idx];

                bftatBFTiStopPlot indicator = new bftatBFTiStopPlot();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Id = id;
                Indicators.Add(indicator);
                indicator.SetUp();

                bftatBFTiStopPlot[] tmp = new bftatBFTiStopPlot[cachebftatBFTiStopPlot == null ? 1 : cachebftatBFTiStopPlot.Length + 1];
                if (cachebftatBFTiStopPlot != null)
                    cachebftatBFTiStopPlot.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachebftatBFTiStopPlot = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Creates Stop plots in NinjaScript Strategies
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.bftatBFTiStopPlot bftatBFTiStopPlot(int id)
        {
            return _indicator.bftatBFTiStopPlot(Input, id);
        }

        /// <summary>
        /// Creates Stop plots in NinjaScript Strategies
        /// </summary>
        /// <returns></returns>
        public Indicator.bftatBFTiStopPlot bftatBFTiStopPlot(Data.IDataSeries input, int id)
        {
            return _indicator.bftatBFTiStopPlot(input, id);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Creates Stop plots in NinjaScript Strategies
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.bftatBFTiStopPlot bftatBFTiStopPlot(int id)
        {
            return _indicator.bftatBFTiStopPlot(Input, id);
        }

        /// <summary>
        /// Creates Stop plots in NinjaScript Strategies
        /// </summary>
        /// <returns></returns>
        public Indicator.bftatBFTiStopPlot bftatBFTiStopPlot(Data.IDataSeries input, int id)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.bftatBFTiStopPlot(input, id);
        }
    }
}
#endregion
