    using NinjaTrader.Data;
    using System;
    using System.ComponentModel;
    using System.Xml.Serialization;
namespace NinjaTrader.Indicator
{
    [Description("EminiTargeterV3 is used to confirm EminiSniper entries and exits.")]
    public class bftatBFTiTG2A : NinjaTrader.Indicator.Indicator
    {
        private DataSeries AtrRsi;
        private int LastAlertBar;
        private int lastSignalDir;
        private DataSeries MaAtrRsi;
        private int rSI_Period = 20;
        private DataSeries RsiAr;
        private DataSeries RsiMa;
        private double SecondaryTargeterValue1;
        private double SecondaryTargeterValue2;
        private int sF = 20;
        private int StartBar;
        private DataSeries TrLevelSlow;
        private DataSeries Value1_Series;
        private DataSeries Value2_Series;
        private int Wilders_Period;

        protected override void Initialize()
        {
            this.Value1_Series = new DataSeries(this, MaximumBarsLookBack.Infinite);
            this.Value2_Series = new DataSeries(this, MaximumBarsLookBack.Infinite);
            this.AtrRsi = new DataSeries(this);
            this.MaAtrRsi = new DataSeries(this);
            base.CalculateOnBarClose = true;
            base.Overlay = false;
            base.PriceTypeSupported = true;
        }

        protected override void OnBarUpdate()
        {
            if ((base.BarsInProgress == 0) && (base.CurrentBar > this.StartBar))
            {
                this.Value1_Series.Set(base.EMA(base.RSI(this.RSI_Period, 3), this.Int32_0)[0]);
                this.AtrRsi.Set(Math.Abs((double) (this.Value1_Series[1] - this.Value1_Series[0])));
                this.MaAtrRsi.Set(base.EMA(this.AtrRsi, this.Wilders_Period)[0]);
                double num4 = this.Value2_Series[1];
                double num2 = this.Value1_Series[1];
                double num = this.Value1_Series[0];
                double num3 = base.EMA(this.MaAtrRsi, this.Wilders_Period)[0] * 4.236;
                double num5 = num4;
                if (num < num4)
                {
                    num4 = num + num3;
                    if ((num2 < num5) && (num4 > num5))
                    {
                        num4 = num5;
                    }
                }
                else if (num > num4)
                {
                    num4 = num - num3;
                    if ((num2 > num5) && (num4 < num5))
                    {
                        num4 = num5;
                    }
                }
                this.Value2_Series.Set(num4);
            }
        }

        protected override void OnStartUp()
        {
            this.Wilders_Period = (this.RSI_Period * 2) - 1;
            if (this.Wilders_Period < this.Int32_0)
            {
                this.StartBar = this.Int32_0;
            }
            else
            {
                this.StartBar = this.Wilders_Period;
            }
        }

        [Description("")]
        [Category("Parameters")]
        public int Int32_0
        {
            get
            {
                return this.sF;
            }
            set
            {
                this.sF = Math.Max(1, value);
            }
        }

        [Description("")]
        [Category("Parameters")]
        public int RSI_Period
        {
            get
            {
                return this.rSI_Period;
            }
            set
            {
                this.rSI_Period = Math.Max(1, value);
            }
        }

        [XmlIgnore, Browsable(false)]
        public DataSeries Value1
        {
            get
            {
                return this.Value1_Series;
            }
        }

        [Browsable(false), XmlIgnore]
        public DataSeries Value2
        {
            get
            {
                return this.Value2_Series;
            }
        }
    }
}


#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private bftatBFTiTG2A[] cachebftatBFTiTG2A = null;

        private static bftatBFTiTG2A checkbftatBFTiTG2A = new bftatBFTiTG2A();

        /// <summary>
        /// EminiTargeterV3 is used to confirm EminiSniper entries and exits.
        /// </summary>
        /// <returns></returns>
        public bftatBFTiTG2A bftatBFTiTG2A(int int32_0, int rSI_Period)
        {
            return bftatBFTiTG2A(Input, int32_0, rSI_Period);
        }

        /// <summary>
        /// EminiTargeterV3 is used to confirm EminiSniper entries and exits.
        /// </summary>
        /// <returns></returns>
        public bftatBFTiTG2A bftatBFTiTG2A(Data.IDataSeries input, int int32_0, int rSI_Period)
        {
            if (cachebftatBFTiTG2A != null)
                for (int idx = 0; idx < cachebftatBFTiTG2A.Length; idx++)
                    if (cachebftatBFTiTG2A[idx].Int32_0 == int32_0 && cachebftatBFTiTG2A[idx].RSI_Period == rSI_Period && cachebftatBFTiTG2A[idx].EqualsInput(input))
                        return cachebftatBFTiTG2A[idx];

            lock (checkbftatBFTiTG2A)
            {
                checkbftatBFTiTG2A.Int32_0 = int32_0;
                int32_0 = checkbftatBFTiTG2A.Int32_0;
                checkbftatBFTiTG2A.RSI_Period = rSI_Period;
                rSI_Period = checkbftatBFTiTG2A.RSI_Period;

                if (cachebftatBFTiTG2A != null)
                    for (int idx = 0; idx < cachebftatBFTiTG2A.Length; idx++)
                        if (cachebftatBFTiTG2A[idx].Int32_0 == int32_0 && cachebftatBFTiTG2A[idx].RSI_Period == rSI_Period && cachebftatBFTiTG2A[idx].EqualsInput(input))
                            return cachebftatBFTiTG2A[idx];

                bftatBFTiTG2A indicator = new bftatBFTiTG2A();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Int32_0 = int32_0;
                indicator.RSI_Period = rSI_Period;
                Indicators.Add(indicator);
                indicator.SetUp();

                bftatBFTiTG2A[] tmp = new bftatBFTiTG2A[cachebftatBFTiTG2A == null ? 1 : cachebftatBFTiTG2A.Length + 1];
                if (cachebftatBFTiTG2A != null)
                    cachebftatBFTiTG2A.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachebftatBFTiTG2A = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// EminiTargeterV3 is used to confirm EminiSniper entries and exits.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.bftatBFTiTG2A bftatBFTiTG2A(int int32_0, int rSI_Period)
        {
            return _indicator.bftatBFTiTG2A(Input, int32_0, rSI_Period);
        }

        /// <summary>
        /// EminiTargeterV3 is used to confirm EminiSniper entries and exits.
        /// </summary>
        /// <returns></returns>
        public Indicator.bftatBFTiTG2A bftatBFTiTG2A(Data.IDataSeries input, int int32_0, int rSI_Period)
        {
            return _indicator.bftatBFTiTG2A(input, int32_0, rSI_Period);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// EminiTargeterV3 is used to confirm EminiSniper entries and exits.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.bftatBFTiTG2A bftatBFTiTG2A(int int32_0, int rSI_Period)
        {
            return _indicator.bftatBFTiTG2A(Input, int32_0, rSI_Period);
        }

        /// <summary>
        /// EminiTargeterV3 is used to confirm EminiSniper entries and exits.
        /// </summary>
        /// <returns></returns>
        public Indicator.bftatBFTiTG2A bftatBFTiTG2A(Data.IDataSeries input, int int32_0, int rSI_Period)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.bftatBFTiTG2A(input, int32_0, rSI_Period);
        }
    }
}
#endregion
