    using NinjaTrader.Data;
    using NinjaTrader.Gui.Chart;
    using System;
    using System.ComponentModel;
    using System.Drawing;
    using System.Drawing.Drawing2D;
    using System.Xml.Serialization;
namespace NinjaTrader.Indicator
{
    [Description("bftatBFTiTG2ADisplay.")]
    public class bftatBFTiTG2ADisplay : NinjaTrader.Indicator.Indicator
    {
        private DataSeries AtrRsi;
        private int LastAlertBar;
        private int lastSignalDir;
        private DataSeries MaAtrRsi;
        private int midOffset = 10;
        private int rSI_Period = 20;
        private DataSeries RsiAr;
        private DataSeries RsiMa;
        private double SecondaryTargeterValue1;
        private double SecondaryTargeterValue2;
        private int sF = 20;
        private int StartBar;
        private DataSeries TrLevelSlow;
        private int Wilders_Period;

        protected override void Initialize()
        {
            base.Add(new Plot(new Pen(Color.LimeGreen, 2f), PlotStyle.Line, "Value1"));
            base.Plots[0].Pen.DashStyle = DashStyle.Solid;
            base.Add(new Plot(new Pen(Color.Magenta, 2f), PlotStyle.Line, "Value2"));
            base.Plots[1].Pen.DashStyle = DashStyle.Dot;
            base.Add(new Line(new Pen(Color.Green, 1f), (double) (50 + this.MidOffset), "OB"));
            base.Add(new Line(new Pen(Color.Gray, 2f), 50.0, "Midline"));
            base.Add(new Line(new Pen(Color.Red, 1f), (double) (50 - this.MidOffset), "OS"));
            this.AtrRsi = new DataSeries(this);
            this.MaAtrRsi = new DataSeries(this);
            base.CalculateOnBarClose = true;
            base.Overlay = false;
            base.PriceTypeSupported = true;
        }

        protected override void OnBarUpdate()
        {
            if ((base.BarsInProgress == 0) && (base.CurrentBar > this.StartBar))
            {
                this.Value1.Set(base.EMA(base.RSI(this.RSI_Period, 3), this.Int32_0)[0]);
                this.AtrRsi.Set(Math.Abs((double) (this.Value1[1] - this.Value1[0])));
                this.MaAtrRsi.Set(base.EMA(this.AtrRsi, this.Wilders_Period)[0]);
                double num4 = this.Value2[1];
                double num2 = this.Value1[1];
                double num = this.Value1[0];
                double num3 = base.EMA(this.MaAtrRsi, this.Wilders_Period)[0] * 4.236;
                double num5 = num4;
                if (num < num4)
                {
                    num4 = num + num3;
                    if ((num2 < num5) && (num4 > num5))
                    {
                        num4 = num5;
                    }
                }
                else if (num > num4)
                {
                    num4 = num - num3;
                    if ((num2 > num5) && (num4 < num5))
                    {
                        num4 = num5;
                    }
                }
                this.Value2.Set(num4);
            }
        }

        protected override void OnStartUp()
        {
            this.Wilders_Period = (this.RSI_Period * 2) - 1;
            if (this.Wilders_Period < this.Int32_0)
            {
                this.StartBar = this.Int32_0;
            }
            else
            {
                this.StartBar = this.Wilders_Period;
            }
        }

        [Description("")]
        [Category("Parameters")]
        public int Int32_0
        {
            get
            {
                return this.sF;
            }
            set
            {
                this.sF = Math.Max(1, value);
            }
        }

        [Description("")]
        [Category("Parameters")]
        public int MidOffset
        {
            get
            {
                return this.midOffset;
            }
            set
            {
                this.midOffset = Math.Max(0, value);
            }
        }

        [Description("")]
        [Category("Parameters")]
        public int RSI_Period
        {
            get
            {
                return this.rSI_Period;
            }
            set
            {
                this.rSI_Period = Math.Max(1, value);
            }
        }

        [XmlIgnore, Browsable(false)]
        public DataSeries Value1
        {
            get
            {
                return base.Values[0];
            }
        }

        [XmlIgnore, Browsable(false)]
        public DataSeries Value2
        {
            get
            {
                return base.Values[1];
            }
        }
    }
}


#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private bftatBFTiTG2ADisplay[] cachebftatBFTiTG2ADisplay = null;

        private static bftatBFTiTG2ADisplay checkbftatBFTiTG2ADisplay = new bftatBFTiTG2ADisplay();

        /// <summary>
        /// bftatBFTiTG2ADisplay.
        /// </summary>
        /// <returns></returns>
        public bftatBFTiTG2ADisplay bftatBFTiTG2ADisplay(int int32_0, int midOffset, int rSI_Period)
        {
            return bftatBFTiTG2ADisplay(Input, int32_0, midOffset, rSI_Period);
        }

        /// <summary>
        /// bftatBFTiTG2ADisplay.
        /// </summary>
        /// <returns></returns>
        public bftatBFTiTG2ADisplay bftatBFTiTG2ADisplay(Data.IDataSeries input, int int32_0, int midOffset, int rSI_Period)
        {
            if (cachebftatBFTiTG2ADisplay != null)
                for (int idx = 0; idx < cachebftatBFTiTG2ADisplay.Length; idx++)
                    if (cachebftatBFTiTG2ADisplay[idx].Int32_0 == int32_0 && cachebftatBFTiTG2ADisplay[idx].MidOffset == midOffset && cachebftatBFTiTG2ADisplay[idx].RSI_Period == rSI_Period && cachebftatBFTiTG2ADisplay[idx].EqualsInput(input))
                        return cachebftatBFTiTG2ADisplay[idx];

            lock (checkbftatBFTiTG2ADisplay)
            {
                checkbftatBFTiTG2ADisplay.Int32_0 = int32_0;
                int32_0 = checkbftatBFTiTG2ADisplay.Int32_0;
                checkbftatBFTiTG2ADisplay.MidOffset = midOffset;
                midOffset = checkbftatBFTiTG2ADisplay.MidOffset;
                checkbftatBFTiTG2ADisplay.RSI_Period = rSI_Period;
                rSI_Period = checkbftatBFTiTG2ADisplay.RSI_Period;

                if (cachebftatBFTiTG2ADisplay != null)
                    for (int idx = 0; idx < cachebftatBFTiTG2ADisplay.Length; idx++)
                        if (cachebftatBFTiTG2ADisplay[idx].Int32_0 == int32_0 && cachebftatBFTiTG2ADisplay[idx].MidOffset == midOffset && cachebftatBFTiTG2ADisplay[idx].RSI_Period == rSI_Period && cachebftatBFTiTG2ADisplay[idx].EqualsInput(input))
                            return cachebftatBFTiTG2ADisplay[idx];

                bftatBFTiTG2ADisplay indicator = new bftatBFTiTG2ADisplay();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Int32_0 = int32_0;
                indicator.MidOffset = midOffset;
                indicator.RSI_Period = rSI_Period;
                Indicators.Add(indicator);
                indicator.SetUp();

                bftatBFTiTG2ADisplay[] tmp = new bftatBFTiTG2ADisplay[cachebftatBFTiTG2ADisplay == null ? 1 : cachebftatBFTiTG2ADisplay.Length + 1];
                if (cachebftatBFTiTG2ADisplay != null)
                    cachebftatBFTiTG2ADisplay.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachebftatBFTiTG2ADisplay = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// bftatBFTiTG2ADisplay.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.bftatBFTiTG2ADisplay bftatBFTiTG2ADisplay(int int32_0, int midOffset, int rSI_Period)
        {
            return _indicator.bftatBFTiTG2ADisplay(Input, int32_0, midOffset, rSI_Period);
        }

        /// <summary>
        /// bftatBFTiTG2ADisplay.
        /// </summary>
        /// <returns></returns>
        public Indicator.bftatBFTiTG2ADisplay bftatBFTiTG2ADisplay(Data.IDataSeries input, int int32_0, int midOffset, int rSI_Period)
        {
            return _indicator.bftatBFTiTG2ADisplay(input, int32_0, midOffset, rSI_Period);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// bftatBFTiTG2ADisplay.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.bftatBFTiTG2ADisplay bftatBFTiTG2ADisplay(int int32_0, int midOffset, int rSI_Period)
        {
            return _indicator.bftatBFTiTG2ADisplay(Input, int32_0, midOffset, rSI_Period);
        }

        /// <summary>
        /// bftatBFTiTG2ADisplay.
        /// </summary>
        /// <returns></returns>
        public Indicator.bftatBFTiTG2ADisplay bftatBFTiTG2ADisplay(Data.IDataSeries input, int int32_0, int midOffset, int rSI_Period)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.bftatBFTiTG2ADisplay(input, int32_0, midOffset, rSI_Period);
        }
    }
}
#endregion
