    using NinjaTrader.Cbi;
    using NinjaTrader.Data;
    using NinjaTrader.Gui.Chart;
    using System;
    using System.ComponentModel;
    using System.Drawing;
    using System.Drawing.Drawing2D;
    using System.Xml.Serialization;
namespace NinjaTrader.Indicator
{
    [Description("EminiTargeterV3 is used to confirm EminiSniper entries and exits.")]
    public class bftatBFTiTG4A : NinjaTrader.Indicator.Indicator
    {
        private DataSeries AtrRsi;
        private int LastAlertBar;
        private int lastSignalDir;
        private DataSeries MaAtrRsi;
        private int MidOffset = 10;
        private int pMaxExceptionsAllowed = 3;
        private int rSI_Period = 5;
        private DataSeries RsiAr;
        private DataSeries RsiMa;
        private int sF = 5;
        private DataSeries SignalDir_Series;
        private int StartBar;
        private DataSeries TrLevelSlow;
        private int TryCatchExceptionCounter;
        private int Wilders_Period;

        protected override void Initialize()
        {            
            base.Add(new Plot(new Pen(Color.LimeGreen, 2f), PlotStyle.Line, "Value1"));
            base.Plots[0].Pen.DashStyle = DashStyle.Solid;
            base.Add(new Plot(new Pen(Color.Magenta, 2f), PlotStyle.Line, "Value2"));
            base.Plots[1].Pen.DashStyle = DashStyle.Dot;
            base.Add(new Line(new Pen(Color.Green, 1f), (double) (50 + this.MidOffset), "OB"));
            base.Add(new Line(new Pen(Color.Gray, 2f), 50.0, "Midline"));
            base.Add(new Line(new Pen(Color.Red, 1f), (double) (50 - this.MidOffset), "OS"));
            this.SignalDir_Series = new DataSeries(this, MaximumBarsLookBack.Infinite);
            this.AtrRsi = new DataSeries(this);
            this.MaAtrRsi = new DataSeries(this);
            base.CalculateOnBarClose = true;
            base.Overlay = false;
            base.PriceTypeSupported = true;
        }

        protected override void OnBarUpdate()
        {
            try
            {
                if ((base.CurrentBar >= this.StartBar) && (base.CurrentBar > this.StartBar))
                {
                    this.Value1.Set(base.EMA(base.RSI(this.RSI_Period, 3), this.Int32_0)[0]);
                    this.AtrRsi.Set(Math.Abs((double) (this.Value1[1] - this.Value1[0])));
                    this.MaAtrRsi.Set(base.EMA(this.AtrRsi, this.Wilders_Period)[0]);
                    double num4 = this.Value2[1];
                    double num2 = this.Value1[1];
                    double num = this.Value1[0];
                    double num3 = base.EMA(this.MaAtrRsi, this.Wilders_Period)[0] * 4.236;
                    double num5 = num4;
                    if (num < num4)
                    {
                        num4 = num + num3;
                        if ((num2 < num5) && (num4 > num5))
                        {
                            num4 = num5;
                        }
                    }
                    else if (num > num4)
                    {
                        num4 = num - num3;
                        if ((num2 > num5) && (num4 < num5))
                        {
                            num4 = num5;
                        }
                    }
                    this.Value2.Set(num4);
                    if (this.Value1[0] > this.Value2[0])
                    {
                        if (this.Value1[0] <= 50.0)
                        {
                            this.SignalDir_Series.Set(1.0);
                            this.lastSignalDir = 1;
                        }
                        else
                        {
                            this.SignalDir_Series.Set(2.0);
                            this.lastSignalDir = 2;
                        }
                    }
                    else if (this.Value1[0] < this.Value2[0])
                    {
                        if (this.Value1[0] >= 50.0)
                        {
                            this.SignalDir_Series.Set(-1.0);
                            this.lastSignalDir = -1;
                        }
                        else
                        {
                            this.SignalDir_Series.Set(-2.0);
                            this.lastSignalDir = -2;
                        }
                    }
                    else
                    {
                        this.SignalDir_Series.Set((double) this.lastSignalDir);
                    }
                }
            }
            catch (Exception exception)
            {
                base.Log(string.Concat(new object[] { "TryCatch Error: Please check your indicator for errors:", base.Time[0], " ", exception.ToString() }), NinjaTrader.Cbi.LogLevel.Error);
                base.Print(base.Time[0] + " " + exception.ToString());
                string[] strArray = exception.StackTrace.Split(new char[] { '\n' });
                for (int i = 0; i <= (strArray.Length - 1); i++)
                {
                    string str = strArray[i];
                    base.Log("TraceStack: " + str, NinjaTrader.Cbi.LogLevel.Error);
                    base.Print("TraceStack: " + str);
                }
            }
        }

        protected override void OnStartUp()
        {
            this.Wilders_Period = (this.RSI_Period * 2) - 1;
            if (this.Wilders_Period < this.Int32_0)
            {
                this.StartBar = this.Int32_0;
            }
            else
            {
                this.StartBar = this.Wilders_Period;
            }
        }

        [Description("")]
        [Category("Parameters")]
        public int Int32_0
        {
            get
            {
                return this.sF;
            }
            set
            {
                this.sF = Math.Max(1, value);
            }
        }

        [Description("")]
        [Category("Parameters")]
        public int RSI_Period
        {
            get
            {
                return this.rSI_Period;
            }
            set
            {
                this.rSI_Period = Math.Max(1, value);
            }
        }

        [Browsable(false), XmlIgnore]
        public DataSeries SignalDir
        {
            get
            {
                return this.SignalDir_Series;
            }
        }

        [Browsable(false), XmlIgnore]
        public DataSeries Value1
        {
            get
            {
                return base.Values[0];
            }
        }

        [Browsable(false), XmlIgnore]
        public DataSeries Value2
        {
            get
            {
                return base.Values[1];
            }
        }
    }
}


#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private bftatBFTiTG4A[] cachebftatBFTiTG4A = null;

        private static bftatBFTiTG4A checkbftatBFTiTG4A = new bftatBFTiTG4A();

        /// <summary>
        /// EminiTargeterV3 is used to confirm EminiSniper entries and exits.
        /// </summary>
        /// <returns></returns>
        public bftatBFTiTG4A bftatBFTiTG4A(int int32_0, int rSI_Period)
        {
            return bftatBFTiTG4A(Input, int32_0, rSI_Period);
        }

        /// <summary>
        /// EminiTargeterV3 is used to confirm EminiSniper entries and exits.
        /// </summary>
        /// <returns></returns>
        public bftatBFTiTG4A bftatBFTiTG4A(Data.IDataSeries input, int int32_0, int rSI_Period)
        {
            if (cachebftatBFTiTG4A != null)
                for (int idx = 0; idx < cachebftatBFTiTG4A.Length; idx++)
                    if (cachebftatBFTiTG4A[idx].Int32_0 == int32_0 && cachebftatBFTiTG4A[idx].RSI_Period == rSI_Period && cachebftatBFTiTG4A[idx].EqualsInput(input))
                        return cachebftatBFTiTG4A[idx];

            lock (checkbftatBFTiTG4A)
            {
                checkbftatBFTiTG4A.Int32_0 = int32_0;
                int32_0 = checkbftatBFTiTG4A.Int32_0;
                checkbftatBFTiTG4A.RSI_Period = rSI_Period;
                rSI_Period = checkbftatBFTiTG4A.RSI_Period;

                if (cachebftatBFTiTG4A != null)
                    for (int idx = 0; idx < cachebftatBFTiTG4A.Length; idx++)
                        if (cachebftatBFTiTG4A[idx].Int32_0 == int32_0 && cachebftatBFTiTG4A[idx].RSI_Period == rSI_Period && cachebftatBFTiTG4A[idx].EqualsInput(input))
                            return cachebftatBFTiTG4A[idx];

                bftatBFTiTG4A indicator = new bftatBFTiTG4A();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Int32_0 = int32_0;
                indicator.RSI_Period = rSI_Period;
                Indicators.Add(indicator);
                indicator.SetUp();

                bftatBFTiTG4A[] tmp = new bftatBFTiTG4A[cachebftatBFTiTG4A == null ? 1 : cachebftatBFTiTG4A.Length + 1];
                if (cachebftatBFTiTG4A != null)
                    cachebftatBFTiTG4A.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachebftatBFTiTG4A = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// EminiTargeterV3 is used to confirm EminiSniper entries and exits.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.bftatBFTiTG4A bftatBFTiTG4A(int int32_0, int rSI_Period)
        {
            return _indicator.bftatBFTiTG4A(Input, int32_0, rSI_Period);
        }

        /// <summary>
        /// EminiTargeterV3 is used to confirm EminiSniper entries and exits.
        /// </summary>
        /// <returns></returns>
        public Indicator.bftatBFTiTG4A bftatBFTiTG4A(Data.IDataSeries input, int int32_0, int rSI_Period)
        {
            return _indicator.bftatBFTiTG4A(input, int32_0, rSI_Period);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// EminiTargeterV3 is used to confirm EminiSniper entries and exits.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.bftatBFTiTG4A bftatBFTiTG4A(int int32_0, int rSI_Period)
        {
            return _indicator.bftatBFTiTG4A(Input, int32_0, rSI_Period);
        }

        /// <summary>
        /// EminiTargeterV3 is used to confirm EminiSniper entries and exits.
        /// </summary>
        /// <returns></returns>
        public Indicator.bftatBFTiTG4A bftatBFTiTG4A(Data.IDataSeries input, int int32_0, int rSI_Period)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.bftatBFTiTG4A(input, int32_0, rSI_Period);
        }
    }
}
#endregion
