    using NinjaTrader.Data;
    using NinjaTrader.Gui.Chart;
    using System;
    using System.ComponentModel;
    using System.Drawing;
    using System.Xml.Serialization;
namespace NinjaTrader.Indicator
{
    [Description("Creates Stop plots in NinjaScript Strategies")]
    public class bftatBFTiTG4ADisplay : NinjaTrader.Indicator.Indicator
    {
        private int id = 1;

        protected override void Initialize()
        {
            base.Add(new NinjaTrader.Gui.Chart.Plot(new Pen(Color.Red, 3f), PlotStyle.Square, "TG4APlot"));
            base.Overlay = false;
            base.PriceTypeSupported = false;
        }

        protected override void OnBarUpdate()
        {
        }

        [Description("")]
        [Category("Parameters")]
        public int Id
        {
            get
            {
                return this.id;
            }
            set
            {
                this.id = Math.Max(0, value);
            }
        }

        [XmlIgnore, Browsable(false)]
        public DataSeries Plot
        {
            get
            {
                return base.Values[0];
            }
        }
    }
}


#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private bftatBFTiTG4ADisplay[] cachebftatBFTiTG4ADisplay = null;

        private static bftatBFTiTG4ADisplay checkbftatBFTiTG4ADisplay = new bftatBFTiTG4ADisplay();

        /// <summary>
        /// Creates Stop plots in NinjaScript Strategies
        /// </summary>
        /// <returns></returns>
        public bftatBFTiTG4ADisplay bftatBFTiTG4ADisplay(int id)
        {
            return bftatBFTiTG4ADisplay(Input, id);
        }

        /// <summary>
        /// Creates Stop plots in NinjaScript Strategies
        /// </summary>
        /// <returns></returns>
        public bftatBFTiTG4ADisplay bftatBFTiTG4ADisplay(Data.IDataSeries input, int id)
        {
            if (cachebftatBFTiTG4ADisplay != null)
                for (int idx = 0; idx < cachebftatBFTiTG4ADisplay.Length; idx++)
                    if (cachebftatBFTiTG4ADisplay[idx].Id == id && cachebftatBFTiTG4ADisplay[idx].EqualsInput(input))
                        return cachebftatBFTiTG4ADisplay[idx];

            lock (checkbftatBFTiTG4ADisplay)
            {
                checkbftatBFTiTG4ADisplay.Id = id;
                id = checkbftatBFTiTG4ADisplay.Id;

                if (cachebftatBFTiTG4ADisplay != null)
                    for (int idx = 0; idx < cachebftatBFTiTG4ADisplay.Length; idx++)
                        if (cachebftatBFTiTG4ADisplay[idx].Id == id && cachebftatBFTiTG4ADisplay[idx].EqualsInput(input))
                            return cachebftatBFTiTG4ADisplay[idx];

                bftatBFTiTG4ADisplay indicator = new bftatBFTiTG4ADisplay();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Id = id;
                Indicators.Add(indicator);
                indicator.SetUp();

                bftatBFTiTG4ADisplay[] tmp = new bftatBFTiTG4ADisplay[cachebftatBFTiTG4ADisplay == null ? 1 : cachebftatBFTiTG4ADisplay.Length + 1];
                if (cachebftatBFTiTG4ADisplay != null)
                    cachebftatBFTiTG4ADisplay.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachebftatBFTiTG4ADisplay = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Creates Stop plots in NinjaScript Strategies
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.bftatBFTiTG4ADisplay bftatBFTiTG4ADisplay(int id)
        {
            return _indicator.bftatBFTiTG4ADisplay(Input, id);
        }

        /// <summary>
        /// Creates Stop plots in NinjaScript Strategies
        /// </summary>
        /// <returns></returns>
        public Indicator.bftatBFTiTG4ADisplay bftatBFTiTG4ADisplay(Data.IDataSeries input, int id)
        {
            return _indicator.bftatBFTiTG4ADisplay(input, id);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Creates Stop plots in NinjaScript Strategies
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.bftatBFTiTG4ADisplay bftatBFTiTG4ADisplay(int id)
        {
            return _indicator.bftatBFTiTG4ADisplay(Input, id);
        }

        /// <summary>
        /// Creates Stop plots in NinjaScript Strategies
        /// </summary>
        /// <returns></returns>
        public Indicator.bftatBFTiTG4ADisplay bftatBFTiTG4ADisplay(Data.IDataSeries input, int id)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.bftatBFTiTG4ADisplay(input, id);
        }
    }
}
#endregion
